------------------------------------------------------------------------------
--                                                                          --
--                           POLYORB COMPONENTS                             --
--                                                                          --
--                 T E S T _ S U I T E . S C E N A R I O S                  --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--         Copyright (C) 2003-2009, Free Software Foundation, Inc.          --
--                                                                          --
-- PolyORB is free software; you  can  redistribute  it and/or modify it    --
-- under terms of the  GNU General Public License as published by the  Free --
-- Software Foundation;  either version 2,  or (at your option)  any  later --
-- version. PolyORB is distributed  in the hope that it will be  useful,    --
-- but WITHOUT ANY WARRANTY;  without even the implied warranty of MERCHAN- --
-- TABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public --
-- License  for more details.  You should have received  a copy of the GNU  --
-- General Public License distributed with PolyORB; see file COPYING. If    --
-- not, write to the Free Software Foundation, 51 Franklin Street, Fifth    --
-- Floor, Boston, MA 02111-1301, USA.                                       --
--                                                                          --
--                                                                          --
--                  PolyORB is maintained by AdaCore                        --
--                     (email: sales@adacore.com)                           --
--                                                                          --
------------------------------------------------------------------------------

with Test_Suite.Output;

package Test_Suite.Scenarios is

   use Test_Suite.Output;

   procedure Run_Scenario
     (Scenario_File     : String;
      Position          : Integer := -1;
      Configuration_Dir : String;
      Output            : Test_Suite_Output'Class;
      Test_Success      : out Boolean;
      Verbose           : Boolean);
   --  Run scenario file Scenario_File. If Position is greater than
   --  -1, executes only test at #position position in Scenario_File.
   --  On exit, set Test_Success according to test output.

   procedure Run_All_Scenarios
     (Directory_Name    : String;
      Configuration_Dir : String;
      Output            : Test_Suite_Output'Class;
      Test_Success      : out Boolean;
      Verbose           : Boolean);
   --  Run recursively all scenarios in Directory_Name directory
   --  On exit, set Test_Success according to test output.

end Test_Suite.Scenarios;
