/*************************************************************************\
*   Copyright (C) 2009 by Ulf Kreissig                                    *
*   udev@gmx.net                                                          *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
\*************************************************************************/

//--- LOCAL ---
#include "utils.h"
#include "countrymap.h"
#include "logger/streamlogger.h"

//--- QT4 ---
#include <QDesktopServices>
#include <QTime>
#include <QUrl>

namespace Utils
{

void
ShowUrl(const QLatin1String & url)
{
	//TODO need to use the kde stuff here
	QDesktopServices::openUrl(QUrl(url));
}

bool
IsDayTime( const QTime & sunrise, const QTime & sunset )
{
	QTime currentTime( QTime::currentTime() );
	if( sunset.isValid() && sunrise.isValid() )
		return (currentTime > sunrise && currentTime  < sunset);
	else
		return true;
}

bool
GetCountryCode( const QString & sCountry, QString & sCountryCode )
{
	sCountryCode.clear();
	if( sCountry.isEmpty() )
		return false;
	
	QString sTmpCountry;
	/*** Handle special cases for country names here ***
	*    Some countries contains an article (e.g.: accuweather "Harbour Island, The Bahamas(Harbour Island)"
	*    in this case we will not find the countrycode for this country.
	*/
	if( sCountry.left(4).compare("the ", Qt::CaseInsensitive) == 0 )
		sTmpCountry = sCountry.right( sCountry.length()-4 ).simplified();
	else if( sCountry.compare("uk", Qt::CaseInsensitive) == 0 )
		sTmpCountry = "United Kingdom";
	else
		sTmpCountry = sCountry;
	
	if( !UsStatesMap::instance()->state(sTmpCountry).isEmpty() )
	{
		sCountryCode = "us";
	}
	if( sCountryCode.isEmpty() )
	{
		sCountryCode = CountryMap::instance()->countryCode(sTmpCountry);
	}
	if( sCountryCode.isEmpty() &&
		CountryMap::instance()->countryCodeIndex( sTmpCountry.toLower() ) >= 0 )
	{
		sCountryCode = sTmpCountry.toLower();
	}
	
	return !sCountryCode.isEmpty();
}

void
ExtractLocationInfo( const QString & sLocation,
                     QString & sCity,
                     QString & sDistrict,
                     QString & sCountry )
{
	QString sTmpLocation;
	sCity.clear();
	sDistrict.clear();
	sCountry.clear();
	
	/*** Extract the district ...(DISTRICT)...
	*/
	int iPos = sLocation.indexOf('(');
	if( iPos > 0 )
	{
		int iClose = sLocation.lastIndexOf(')');
		if( iClose > iPos )
		{
			sDistrict = sLocation.mid(iPos+1, iClose-iPos-1).simplified();
			sTmpLocation = sLocation.left(iPos) + sLocation.right(sLocation.length()-iClose-1);
		}
	}
	
	/*** Tokenize the cityname without the district, because some providers uses colons in the district as well.
	*    e.g.: accuweather: "London, United Kingdom(Westminster, England)"
	*/
	const QString * pLocation = sTmpLocation.isEmpty() ? &sLocation : &sTmpLocation;
	iPos = pLocation->lastIndexOf(',');
	if( iPos > 0 )
	{
		sCity = pLocation->left(iPos).simplified();
		sCountry = pLocation->right(pLocation->length()-iPos-1).simplified();
	}
	else
		sCity = pLocation->simplified();
}

}	// end of namespace Utils
