/*************************************************************************\
*   Copyright (C) 2009 by Ulf Kreißig                                     *
*   udev@gmx.net                                                          *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
\*************************************************************************/

#ifndef IONLISTMODEL_H
#define IONLISTMODEL_H

//--- LOCAL ---

//--- QT4 ---
#include <QAbstractListModel>
#include <QPointer>
#include <QMutex>
#include <QStringList>

//--- KDE4 ---
namespace Plasma
{
	class DataEngine;
}


class IonListModel : public QAbstractListModel
{
public:
	enum IonModelRole {ProviderNameRole = Qt::UserRole};

	static bool			init( QObject * parent, const Plasma::DataEngine * engine );
	static IonListModel	*	instance();
	static void			clear();

	~IonListModel();

	int				rowCount( const QModelIndex & parent = QModelIndex() ) const;
	QVariant			data( const QModelIndex & index, int role ) const;
	const Plasma::DataEngine *	engine() const;

private:
	IonListModel( QObject * parent, const Plasma::DataEngine * engine );
	QStringList			m_vProviderDisplayNames;
	QStringList			m_vProviderNames;	// to use when we request information from this ion
	const Plasma::DataEngine *	m_pEngine;

	static QPointer<IonListModel>	m_pInstance;
	static QMutex			m_singeltonMutex;
};

#endif
