/***************************************************************************
 *   By Karthik Paithankar <biophysics@hotmail.com>     *
 *   A lot of code was used from weatherplasmoid. Thanks to                *
 *                         Vinnie Futia <rowancompsciguy@gmail.com>        *
 *   Thanks to Yannig, Joe Istead for the help
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 3 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .        *
 ***************************************************************************/

#include "plasma-simpleweatherforecast.h"
#include "config.h"

#include <QPainter>
#include <QFontMetrics>
#include <QStyleOptionGraphicsItem>
#include <QSizeF>
#include <QRectF>
#include <QFile>
#include <KGlobalSettings>
#include <QProcess>
#include <QDomDocument>
#include <QTimer>
#include <QDir>
#include <QLineF>
#include <KConfigGroup>

#include <plasma/svg.h>
#include <plasma/theme.h>
#include <kio/job.h>

Plasma_Weather::Plasma_Weather(
    QObject *parent, const QVariantList &args  )
    : Plasma::Applet(parent, args)
{
   timer = new QTimer(this);
	setBackgroundHints(DefaultBackground);
//   resize(390, 350);
   resize(195, 195);

   setHasConfigurationInterface(true);
//    setAspectRatioMode(Plasma::IgnoreAspectRatio);


   connect(timer, SIGNAL(timeout()), this, SLOT(refresh()));
}
 
Plasma_Weather::~Plasma_Weather()
{
   timer->stop();
   delete timer;
}



void Plasma_Weather::init()
{
   refresh();
}

void Plasma_Weather::refresh()
{
   bool error = false;

   readConfigData();
   collectData();
   parseData();
   update();

   timer->stop();
   timer->setInterval(updateFrequency.toInt(&error) * 60 * 1000);
   timer->start();
}

void Plasma_Weather::readConfigData()
{
   KConfigGroup cg = config();

   iconTheme = cg.readEntry("iconTheme", iconTheme);
   zip = cg.readEntry("zip", "UKXX0106");
   tempType = cg.readEntry("tempType", "C");
   updateFrequency = cg.readEntry("updateFrequency", "55");
   font.fromString( cg.readEntry("font", QFont(KGlobalSettings::smallestReadableFont()).toString()) );
} 
 
void Plasma_Weather::collectData()
{
// proxy support  
// proxy support  
// proxy support  
//	QString proxy_xml_file = "http://weather.yahooapis.com/forecastrss?p=" + zip;
//    if(tempType == "C")
//    {
//	proxy_xml_file.append("&u=c");
//    }

//The next line clears cache for the file
//	KIO::http_update_cache(proxy_xml_file, true, 0);
// proxy support: for some crazy reason the update does not happen properly !
// so I have enabled both wget and proxy support 
// FIX ME
	KIO::file_delete(QDir::homePath() + "/.weather.xml", KIO::HideProgressInfo );
//	KIO::file_copy(proxy_xml_file, QDir::homePath() + "/.weather.xml", -1, KIO::Overwrite | KIO::HideProgressInfo);
//
// Now the normal wget...
// Now the normal wget...
// Now the normal wget...
    QProcess* process = new QProcess(this);
    QString wget_xml_command = "wget -q -t 4 --random-wait -O " + QDir::homePath() + "/.weather.xml http://weather.yahooapis.com/forecastrss?p=" + zip;
    if(tempType == "C")
    {
	wget_xml_command.append("&u=c");
    }
    process->start(wget_xml_command);
    process->waitForFinished();
    delete process;
}

void Plasma_Weather::parseData()
{
    //get the invidual elements from the XML file
    QDomDocument doc("weather");
    QFile file(QDir::homePath() + "/.weather.xml");
    //read the data into the XML parser and close the file
    doc.setContent(&file);
    file.close();

    QDomElement root = doc.documentElement();

    QDomNode n = root.firstChild();

    n = root.firstChild();
    n = n.firstChild();

    while(!n.isNull())
    {
       QDomElement e = n.toElement();

       if(!e.isNull())
       {
          if(e.tagName() == "yweather:location")
          {
             city = e.attribute("city", "");
             region = e.attribute("region", "");
             country = e.attribute("country", "");
          }
          else if(e.tagName() == "yweather:wind")
          {
             temperature = e.attribute("chill", "");
          }
          else if(e.tagName() == "yweather:atmosphere")
          {
             humidity = e.attribute("humidity", "");
          }
          else if(e.tagName() == "item")
          {
             n = n.firstChild();

             while(!n.isNull())
             {
                QDomElement e = n.toElement();

                if(!e.isNull())
                {
                   if(e.tagName() == "yweather:condition")
                   {
                      condition = e.attribute("text", "");
                      today_code = e.attribute("code", "");
		      temperature = e.attribute("temp","");
// works			code = "10";
// no			code = "11";
// no			code = "12";
// works 		code = "13";
// all should work as we have changed the icon
                   }
                   if(e.tagName() == "yweather:forecast")
			{
			tomorrow_day = e.attribute("day","");
			temperature_tomorrow_low = e.attribute("low","");
			temperature_tomorrow_high = e.attribute("high","");
			temperature_tomorrow_condition = e.attribute("text","");
			tomorrow_code = e.attribute("code","");
		
                 n = n.nextSibling();
                QDomElement e = n.toElement();
          			if(e.tagName() == "yweather:forecast")
				{
// d_a_t means day after tomorrow
				d_a_t = e.attribute("day","");
				d_a_t_low = e.attribute("low","");
				d_a_t_high = e.attribute("high","");
				d_a_t_condition = e.attribute("text","");
			        d_a_t_code = e.attribute("code","");
				}

			}
                }
               
                 n = n.nextSibling();
             } 
           
             n = n.parentNode();
          }
       }

       n = n.nextSibling();
    }    
}

void Plasma_Weather::paintInterface(QPainter *p,
        const QStyleOptionGraphicsItem *option, const QRect &contentsRect)
{
    Q_UNUSED( option );

// this one is the main forecast OXF
//    QRect textRect(contentsRect.left(), contentsRect.top()+(int)contentsRect.height()/12,contentsRect.left() + (int)(contentsRect.width() / 2.0), (int)contentsRect.top() + (int)contentsRect.height()/3);
    QRect textRect_city_name(contentsRect.left(), contentsRect.top()+(int)contentsRect.height()/27,contentsRect.left() + (int)(contentsRect.width() / 2.0), (int)contentsRect.top() + (int)contentsRect.height()/3);
// 8 -> 7.5
    QRect textRect_temperature(contentsRect.left(), contentsRect.top()+(int)contentsRect.height()/7,contentsRect.left() + (int)(contentsRect.width() / 2.0), (int)contentsRect.top() + (int)contentsRect.height()/3);

// this one is the main forecast _description_ 5-> 4.5
    QRect textRect_main_description(contentsRect.left(), contentsRect.top()+(int)contentsRect.height()/4,contentsRect.left() + (int)(contentsRect.width() / 2.0), (int)contentsRect.top() + (int)contentsRect.height()/3);


// this is for the image in the right top quadrant
   QRect imageRect(contentsRect.left()+(int)contentsRect.width() / 1.8, contentsRect.top(), (int)contentsRect.width()/2.5, (int)contentsRect.height()/2.5);
//    QRect imageRect_tomorrow(contentsRect.left()+(int)contentsRect.width()/12, contentsRect.top()+(int)contentsRect.height()/1.5, (int)contentsRect.width()/2.5, (int)contentsRect.height()/2.5);
    QRect imageRect_tomorrow(contentsRect.left()+(int)contentsRect.width()/6, contentsRect.top()+(int)contentsRect.height()/1.6, (int)contentsRect.width()/3.5, (int)contentsRect.height()/3.5);
   QRect imageRect_d_a_t(contentsRect.right() - (int)contentsRect.width() /2.6, contentsRect.top()+(int)contentsRect.height()/1.6, (int)contentsRect.width()/3.5, (int)contentsRect.height()/3.5);




// this is for the  LOW and HIGH tag
//   QRect textRect1(contentsRect.left(), (int)contentsRect.bottom()-(int)contentsRect.height()/2, (int)contentsRect.width()/2, (int)contentsRect.height()/2);
// WORKS NOW   QRect textRect_high_low_tag(contentsRect.left(), (int)contentsRect.top()+(int)contentsRect.height()/2.2, (int)contentsRect.width()/2, (int)contentsRect.height()/2);
   QRect textRect_low_tag(contentsRect.left(), (int)contentsRect.top()+(int)contentsRect.height()/2.3, (int)contentsRect.width()/2, (int)contentsRect.height()/2);
   QRect textRect_high_tag(contentsRect.left(), (int)contentsRect.top()+(int)contentsRect.height()/1.9, (int)contentsRect.width()/2, (int)contentsRect.height()/2);

// this is for tomorrow forecast
//   QRect textRect3(contentsRect.left()+(int)contentsRect.width()/24, (int)contentsRect.bottom()-(int)contentsRect.height()*1/3, (int)contentsRect.width()/2, (int)contentsRect.height()/2);
    QRect textRect_tomorrow_day(contentsRect.left()+(int)contentsRect.width()/24, contentsRect.top()+(int)contentsRect.height()/2.8,contentsRect.left() + (int)(contentsRect.width() / 2.0), (int)contentsRect.top() + (int)contentsRect.height()/3);
// WORKS FINE    QRect textRect_tomorrow_temp(contentsRect.left()+(int)contentsRect.width()/24, contentsRect.top()+(int)contentsRect.height()/2.2,contentsRect.left() + (int)(contentsRect.width() / 2.0), (int)contentsRect.top() + (int)contentsRect.height()/3);
    QRect textRect_tomorrow_temp_low(contentsRect.left()+(int)contentsRect.width()/24, contentsRect.top()+(int)contentsRect.height()/2.3,contentsRect.left() + (int)(contentsRect.width() / 2.0), (int)contentsRect.top() + (int)contentsRect.height()/3);
    QRect textRect_tomorrow_temp_high(contentsRect.left()+(int)contentsRect.width()/24, contentsRect.top()+(int)contentsRect.height()/1.9,contentsRect.left() + (int)(contentsRect.width() / 2.0), (int)contentsRect.top() + (int)contentsRect.height()/3);
    QRect textRect_tomorrow_condition(contentsRect.left(), contentsRect.top()+(int)contentsRect.height()/1.15,contentsRect.left() + (int)(contentsRect.width() / 2.0), (int)contentsRect.top() + (int)contentsRect.height()/3);

// this is for day-after-tomorrow forecast textRect2
   QRect textRect_d_a_t_day(contentsRect.right() - (int)(contentsRect.width() /2), contentsRect.top()+(int)contentsRect.height()/2.8, (int)contentsRect.width()/2, (int)contentsRect.height()/2);
// WORKS FINE   QRect textRect_d_a_t_temp(contentsRect.right() - (int)(contentsRect.width() /2), contentsRect.top()+(int)contentsRect.height()/2.2, (int)contentsRect.width()/2, (int)contentsRect.height()/2);
   QRect textRect_d_a_t_temp_low(contentsRect.right() - (int)(contentsRect.width() /2), contentsRect.top()+(int)contentsRect.height()/2.3, (int)contentsRect.width()/2, (int)contentsRect.height()/2);
   QRect textRect_d_a_t_temp_high(contentsRect.right() - (int)(contentsRect.width() /2), contentsRect.top()+(int)contentsRect.height()/1.9, (int)contentsRect.width()/2, (int)contentsRect.height()/2);
   QRect textRect_d_a_t_condition(contentsRect.right() - (int)contentsRect.width() /2, contentsRect.top()+(int)contentsRect.height()/1.15,contentsRect.left() + (int)(contentsRect.width() / 2.0), (int)contentsRect.top() + (int)contentsRect.height()/3);

// attribution text for Yahoo !
    QRect textRect_attribution_text(contentsRect.left(), contentsRect.top()+(int)contentsRect.height()/1.05,contentsRect.left() + (int)(contentsRect.width() / 1.0), (int)contentsRect.top() + (int)contentsRect.height()/3);


    p->setRenderHint(QPainter::SmoothPixmapTransform);
    p->setRenderHint(QPainter::Antialiasing);
 
    // We place the icon and text
//    int width = (int)contentsRect.width();
//  int height = (int)contentsRect.height();

//    paintImage(p, imageRect);
	p->save();
//    	p->setPen(Qt::white);
    	p->setPen(Qt::NoPen);
	p->setPen(Plasma::Theme::defaultTheme()->color(Plasma::Theme::TextColor));
     	p->setFont(font);
//   titleFont = QFont("FreeSans", height/16, false);
//    p->setFont(titleFont);

//    if(region != "")
//    {
//       p->drawText(textRect_city_name,
//          Qt::AlignTop | Qt::AlignHCenter,
//          city + ", " + region); 
//    }
//    else
//    {
       p->drawText(textRect_city_name,
          Qt::AlignTop| Qt::AlignHCenter ,
          city); 

//          city + ", " + country); 
//    }

// do not display is there is no update
// show the image
	    if(today_code != ""){
//    p->drawText(textRect,
//       Qt::AlignVCenter | Qt::AlignHCenter,
//       temperature + char(176) + tempType);
//       p->drawText(textRect, Qt::AlignLeft, tr("\n")+ temperature + char(176) + tempType);
       p->drawText(textRect_temperature, Qt::AlignHCenter|Qt::AlignTop, temperature + char(176) + tempType);


// the next line just works TM
//    p->drawText(textRect_high_low_tag,Qt::AlignLeft|Qt::AlignTop,tr("Low: ")+tr("\nHigh: "));
// WORKS NOW    p->drawText(textRect_high_low_tag,Qt::AlignLeft|Qt::AlignTop,i18n("Low: ")+i18n("\nHigh: "));
    p->drawText(textRect_low_tag,Qt::AlignLeft|Qt::AlignTop,i18n("Low: "));
    p->drawText(textRect_high_tag,Qt::AlignLeft|Qt::AlignTop,i18n("High: "));
    p->drawText(textRect_tomorrow_day,Qt::AlignHCenter|Qt::AlignTop,tomorrow_day);
    p->drawText(textRect_d_a_t_day,Qt::AlignHCenter|Qt::AlignTop,d_a_t);



// the code below adds a small space to the temp. if it is single digit to make it 
// center aligned
     if(temperature_tomorrow_high>0 && temperature_tomorrow_high.size()==1){
       temperature_tomorrow_high=" "+temperature_tomorrow_high;
     }
     if(temperature_tomorrow_low>0 && temperature_tomorrow_low.size()==1){
       temperature_tomorrow_low=" "+temperature_tomorrow_low;
     }
     if(d_a_t_high>0 && d_a_t_high.size()==1){
       d_a_t_high=" "+d_a_t_high;
     }
     if(d_a_t_low>0 && d_a_t_low.size()==1){
       d_a_t_low=" "+d_a_t_low;
     }




//    p->drawText(textRect_tomorrow_temp,
//      Qt::AlignHCenter|Qt::AlignTop,temperature_tomorrow_low+char(176)+ tempType +("\n")+temperature_tomorrow_high+char(176)+ tempType+("\n"));
    p->drawText(textRect_tomorrow_temp_low,
      Qt::AlignHCenter|Qt::AlignTop,temperature_tomorrow_low+char(176)+ tempType +("\n"));
    p->drawText(textRect_tomorrow_temp_high,
      Qt::AlignHCenter|Qt::AlignTop,temperature_tomorrow_high+char(176)+ tempType +("\n"));

//    p->drawText(textRect_d_a_t_temp,
//      Qt::AlignHCenter|Qt::AlignTop,d_a_t_low+char(176)+ tempType +("\n")+d_a_t_high+char(176)+ tempType+("\n"));
    p->drawText(textRect_d_a_t_temp_low,
      Qt::AlignHCenter|Qt::AlignTop,d_a_t_low+char(176)+ tempType +("\n"));
    p->drawText(textRect_d_a_t_temp_high,
      Qt::AlignHCenter|Qt::AlignTop,d_a_t_high+char(176)+ tempType +("\n"));
//   titleFont = QFont(KGlobalSettings::smallestReadableFont());


       p->setFont(QFont(KGlobalSettings::smallestReadableFont()));
    p->drawText(textRect_main_description,Qt::AlignHCenter|Qt::AlignTop, i18n("%1",condition));
    p->drawText(textRect_d_a_t_condition,Qt::AlignHCenter|Qt::AlignTop,i18n("%1",d_a_t_condition));
    p->drawText(textRect_tomorrow_condition,Qt::AlignHCenter|Qt::AlignTop,i18n("%1",temperature_tomorrow_condition));
       p->drawText(textRect_attribution_text,Qt::AlignTop| Qt::AlignHCenter,"Data from Yahoo! Weather"); 

//    paintImage(p, imageRect);
//    paintImage(p2, imageRect_d_a_t);

    QString svg_file = QString();
    if(iconTheme == "")
    {
       svg_file = "widgets/plasma-simpleweatherforecast";
    }
    else
    {
       svg_file = iconTheme;
    }

    Plasma::Svg* svg;
    svg = new Plasma::Svg(this);
    svg->setImagePath( svg_file );
    svg->setContainsMultipleImages(true);
       svg->resize(imageRect.width(), imageRect.height());
       svg->resize(imageRect_tomorrow.width(), imageRect_tomorrow.height());
       svg->resize(imageRect_d_a_t.width(), imageRect_d_a_t.height());
        		svg->paint(p,imageRect, today_code);
        		svg->paint(p,imageRect_tomorrow, tomorrow_code);
        		svg->paint(p,imageRect_d_a_t, d_a_t_code);
     		}
		else{
//   show busy widget now
    		QString svg_file = QString();
	      	svg_file = "widgets/busywidget";
    		Plasma::Svg* svg;
    		svg = new Plasma::Svg(this);
    		svg->setImagePath( svg_file );
   		QRect imageRect(contentsRect.left()+(int)contentsRect.width()/4, contentsRect.top()+(int)contentsRect.height()/4, (int)contentsRect.width()/2, (int)contentsRect.height()/2);
       		svg->resize(imageRect.width(), imageRect.height());
		svg->paint(p,imageRect);
       		p->setFont(QFont(KGlobalSettings::smallestReadableFont()));
// using the string temperature_tomorrow_condition for displaying the text - network not reachable
    		QRect textRect_tomorrow_condition(contentsRect.left(), contentsRect.top()+(int)contentsRect.height()/1.2,contentsRect.left() + (int)(contentsRect.width() ), (int)contentsRect.top() + (int)contentsRect.height()/3);
		temperature_tomorrow_condition = "Network not reachable";
    		p->drawText(textRect_tomorrow_condition, Qt::AlignHCenter|Qt::AlignTop,i18n("%1",temperature_tomorrow_condition));
	}
		
    	p->restore();
}



//void Plasma_Weather::paintImage( QPainter *p, const QRect &imageRect)
//void Plasma_Weather::paintImage( QPainter *p, const QRect &image1Rect)
//{

//    QString svg_file = QString();

//    if(iconTheme == "")
//    {
//       svg_file = "widgets/weather";
//    }
//    else
//    {
//       svg_file = iconTheme;  
//    }


//    Plasma::Svg* svg;
//    svg = new Plasma::Svg(this);
//    svg->setImagePath( svg_file );
//    svg->setContainsMultipleImages(true);
//       svg->resize(image1Rect.width(), image1Rect.height());
//	svg->paint(p,imageRect, d_a_t_code);
//	svg->paint(p,image1Rect, today_code);
//}

void Plasma_Weather::createConfigurationInterface(KConfigDialog* parent)
{
   bool error = false;
   conf = new ConfigDialog();
   parent->setButtons(KDialog::Ok | KDialog::Cancel | KDialog::Apply);
   parent->addPage(conf, parent->windowTitle(), icon());

   conf->zipText->setText(zip);
   conf->iconThemeText->setText(iconTheme);
   conf->freqChooser->setValue(updateFrequency.toInt(&error));
   conf->font = font;
   
   if(tempType == "F")
   {
      conf->fahrenheitSelect->setChecked(true);
   }
   else
   {
      conf->celsiusSelect->setChecked(true);
   }

   connect(parent, SIGNAL(applyClicked()), this, SLOT(configAccepted()));
   connect(parent, SIGNAL(okClicked()), this, SLOT(configAccepted()));
   connect(parent, SIGNAL(cancelClicked()), this, SLOT(configRejected()));
}

void Plasma_Weather::configAccepted()
{
   KConfigGroup cg = config();
   cg.writeEntry("zip", conf->zipText->text());

   if(conf->fahrenheitSelect->isChecked())
   {
      cg.writeEntry("tempType", "F");
   }
   else
   {
      cg.writeEntry("tempType", "C");
   }

   cg.writeEntry("iconTheme", conf->iconThemeText->text());
   cg.writeEntry("updateFrequency", updateFrequency.setNum(conf->freqChooser->value()));
   cg.writeEntry("font", conf->font.toString());

   emit configNeedsSaving();

   refresh();
   
   delete conf;
}

void Plasma_Weather::configRejected()
{
   delete conf;
}

Qt::Orientations Plasma_Weather::expandingDirections() const
{
    // no use of additional space in any direction
    return 0;
}

#include "plasma-simpleweatherforecast.moc" 
