/***********************************************************************************
* Fancy Tasks: Plasmoid providing a fancy representation of your tasks and launchers.
* Copyright (C) 2009 Michal Dutkiewicz aka Emdek <emdeck@gmail.com>
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*
***********************************************************************************/

#ifndef FANCYTASKSPREVIEW_HEADER
#define FANCYTASKSPREVIEW_HEADER

#include <QWidget>
#include <QPointer>
#include <QMouseEvent>
#include <QTimerEvent>
#include <QTextDocument>
#include <QDragEnterEvent>
#include <QContextMenuEvent>

#include <Plasma/FrameSvg>

class FancyTasksTask;
class FancyTasksLauncher;

class FancyTasksPreview : public QWidget
{
    Q_OBJECT

    public:
        FancyTasksPreview(const QPixmap &icon, const QString &text, QWidget *parent);
        FancyTasksPreview(const QPixmap &pixmap, const QPixmap &icon, const QString &text, FancyTasksTask *task, QWidget *parent);
        FancyTasksPreview(const QPixmap &pixmap, const QPixmap &icon, const QString &text, int offset, FancyTasksTask *task, QWidget *parent);
        FancyTasksPreview(const QPixmap &pixmap, const QPixmap &icon, const QString &text, int offset, FancyTasksLauncher *launcher, QWidget *parent);

        void setText(const QString &text);
        FancyTasksTask* task();
        Plasma::FrameSvg* background();
        QSize previewSize();
        int offset();

    public slots:
        void updateAnimation(qreal progress);
        void updateTheme();

    protected:
        void init(const QPixmap &pixmap, const QPixmap &icon, const QString &text, int offset);
        void paintEvent(QPaintEvent *event);
        void enterEvent(QEvent *event);
        void leaveEvent(QEvent *event);
        void dragEnterEvent(QDragEnterEvent *event);
        void mousePressEvent(QMouseEvent *event);
        void contextMenuEvent(QContextMenuEvent *event);
        void timerEvent(QTimerEvent *event);

    private:
        QPointer<FancyTasksTask> m_task;
        QPointer<FancyTasksLauncher> m_launcher;
        Plasma::FrameSvg *m_background;
        QPixmap m_pixmap;
        QPixmap m_icon;
        QTextDocument *m_document;
        QSize m_previewSize;
        qreal m_opacity;
        int m_highlightTimer;
        int m_offset;
        int m_animationId;
        bool m_fadeIn;

    signals:
        void startWindowsHighlight(QList<WId> windows);
        void stopWindowsHighlight(QList<WId> windows);
};

#endif
