/***************************************************************************
 *   Copyright (C) 2009 by Mathias Rabe <masterunderlined [at] web.de>     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 3 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .        *
 ***************************************************************************/
#ifndef DROP2FTP_H
#define DROP2FTP_H

#include <QGraphicsLinearLayout>
#include <QStandardItemModel>

#include <KIcon>
#include <KDE/KIO/Job>
#include <kbookmarkmanager.h>
 
#include <Plasma/Applet>
#include <plasma/widgets/iconwidget.h>
#include <plasma/widgets/label.h>

#include "bookmarktraverser.h"

#include "ui_drop2ftpConfigAppearance.h"
#include "ui_drop2ftpConfigDestination.h"

namespace Plasma
{
    class Icon;
}

class QSizeF;

class Drop2FTP : public Plasma::Applet
{
    Q_OBJECT
    public:
        Drop2FTP(QObject *parent, const QVariantList &args);
        ~Drop2FTP();
        void init();
        void paintInterface(QPainter *painter,
                const QStyleOptionGraphicsItem *option,
                const QRect& contentsRect);

    public slots:
        void configAccepted(); //FIXME public?
        void openIconDialog();
        void addBookmarkGroup(QString icon, QString text);
        void addBookmark(QString icon, QString text, KUrl url);
        void leaveBookmarkGroup();
        void copyBookmarkAddress(const QModelIndex &index);
        void traverseBookmarks(const QString &groupAddress, const QString &caller);

    private slots:
        void slotResult(KJob *job);
        void openFileDialog(bool pressed);
        void resetIcon();

    protected:
        void sendToServer(KUrl::List &src);
        void dragEnterEvent(QGraphicsSceneDragDropEvent *event);
        void dropEvent(QGraphicsSceneDragDropEvent *event);
        void createConfigurationInterface(KConfigDialog *parent);
        void traverseBookmarks();

    private:
        QGraphicsLinearLayout *layout;
        Ui::drop2ftpConfigAppearance uiAppear;
        Ui::drop2ftpConfigDestination uiDest;
        QString m_serverAddress; 
        QString m_serverTitle;
        bool m_hideProgressInfo;
        int m_numActivJobs;
        QString m_newIcon;
        QString m_iconName;
        Plasma::IconWidget *m_icon;
        Plasma::Label *m_label;
        QStandardItemModel *model;
        QStandardItem *parentItem;
        KBookmarkManager* bookmarkManager;
        BookmarkTraverser *traverser;
};
 
// This is the command that links your applet to the .desktop file
K_EXPORT_PLASMA_APPLET(drop2ftp, Drop2FTP)
#endif
