/***********************************************************************************
* Adjustable Clock: Plasmoid to show date and time in adjustable format.
* Copyright (C) 2008 - 2009 Michal Dutkiewicz aka Emdek <emdeck@gmail.com>
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*
***********************************************************************************/

#ifndef ADJUSTABLECLOCK_HEADER
#define ADJUSTABLECLOCK_HEADER

#include "ui_appearanceConfiguration.h"
#include "ui_advancedConfiguration.h"
#include "ui_clipboardActions.h"

#include <QDateTime>
#include <QList>
#include <QtGui/QGraphicsProxyWidget>

#include <Plasma/Applet>
#include <Plasma/Label>
#include <Plasma/DataEngine>

#include <plasmaclock/clockapplet.h>

class QSizeF;

class AdjustableClock : public ClockApplet
{
    Q_OBJECT

    public:
        AdjustableClock(QObject *parent, const QVariantList &args);

        void init();
        void createConfigurationInterface(KConfigDialog *parent);
        void updateSize();
        QString formatDateTime(const QDateTime dateTime, QString format);
        QString formatDateTime(QString format);
        QList<QAction*> contextualActions();

    public slots:
        void dataUpdated(const QString &name, const Plasma::DataEngine::Data &data);
        void constraintsEvent(Plasma::Constraints constraints);
        void configAccepted();
        void itemSelectionChanged();
        void insertRow();
        void deleteRow();
        void moveRow(bool up);
        void moveRowUp();
        void moveRowDown();
        void updateRow(int row, int column);
        void toolTipAboutToShow();
        void toolTipHidden();
        void copyToClipboard(QAction *action);
        void updateClipboardMenu();
        void updateClock();
        void updateToolTipContent();

    protected:
        void mousePressEvent(QGraphicsSceneMouseEvent *event);

    private:
        Plasma::Label *m_clock;
        QString m_timeFormat;
        QString m_toolTipFormat;
        QString m_fastCopyFormat;
        QString m_dateTimeString;
        QStringList m_clipboardFormats;
        QList<QAction*> m_actions;
        QAction *m_clipboardMenu;
        QDateTime m_dateTime;
        int m_timeDifference;
        bool m_updateToolTip;
        Ui::appearanceConfiguration m_appearanceConfigurationUi;
        Ui::advancedConfiguration m_advancedConfigurationUi;
        Ui::clipboardActions m_clipboardActionsUi;
};

K_EXPORT_PLASMA_APPLET(adjustableclock, AdjustableClock)
#endif
