# ***** BEGIN LICENSE BLOCK *****
# Version: RCSL 1.0/RPSL 1.0/GPL 2.0
#
# Portions Copyright (c) 1995-2002 RealNetworks, Inc. All Rights Reserved.
# Portions Copyright (c) 2004 Robert Vollmert. All Rights Reserved.
# Portions Copyright (c) 2005 Lukas Lalinsky. All Rights Reserved.
#
# The contents of this file, and the files included with this file, are
# subject to the current version of the RealNetworks Public Source License
# Version 1.0 (the "RPSL") available at
# http://www.helixcommunity.org/content/rpsl unless you have licensed
# the file under the RealNetworks Community Source License Version 1.0
# (the "RCSL") available at http://www.helixcommunity.org/content/rcsl,
# in which case the RCSL will apply. You may also obtain the license terms
# directly from RealNetworks.  You may not use this file except in
# compliance with the RPSL or, if you have a valid RCSL with RealNetworks
# applicable to this file, the RCSL.  Please see the applicable RPSL or
# RCSL for the rights, obligations and limitations governing use of the
# contents of the file.
#
# This file is part of the Helix DNA Technology. RealNetworks is the
# developer of the Original Code and owns the copyrights in the portions
# it created.
#
# This file, and the files included with this file, is distributed and made
# available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
# EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS ALL SUCH WARRANTIES,
# INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY, FITNESS
# FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT.
#
# Technology Compatibility Kit Test Suite(s) Location:
#    http://www.helixcommunity.org/content/tck
#
# --------------------------------------------------------------------
#
# picard is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# picard is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with picard; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
#
# Contributor(s):
#   Robert Vollmert, Lukas Lalinsky
#
#
# ***** END LICENSE BLOCK *****

import wx
from page import Page

class ColorWell(wx.Panel):
    def __init__(self, parent, id, color, size=wx.Size(25,25)):
        wx.Panel.__init__(self, parent, id, style=wx.SUNKEN_BORDER, size=size)
        self.setColor(color)
        wx.EVT_LEFT_UP(self, self.OnClick)

    def OnClick(self, event):
        dlg = wx.ColourDialog(self)
        if dlg.ShowModal() == wx.ID_OK:
            colorData = dlg.GetColourData()
            self.setColor(colorData.GetColour())

    def setColor(self, color):
        self.SetBackgroundColour(color)
        self.Refresh()

    def getColor(self):
        return self.GetBackgroundColour()

class ColorsPage(Page):

    name = N_("Colors")
    goodMatchColorWellId = wx.NewId()
    badMatchColorWellId = wx.NewId()
    fontColorWellId = wx.NewId()
    defaultButtonId = wx.NewId()

    def __init__(self, parent, config):
        Page.__init__(self, parent, config)

        self.goodMatchColorWell = ColorWell(self, self.goodMatchColorWellId, wx.Colour(255, 0, 255))
        self.badMatchColorWell = ColorWell(self, self.badMatchColorWellId, wx.Colour(255, 0, 255))
        self.fontColorWell = ColorWell(self, self.fontColorWellId, wx.Colour(255, 0, 255))

        box = wx.StaticBox(self, -1, _("Matched track highlighting"))
        sizer = wx.StaticBoxSizer(box, wx.VERTICAL)
        sizer.Add(wx.StaticText(self, -1, _("Good match background color") + ":"), 0, wx.LEFT | wx.RIGHT | wx.TOP, 5)
        sizer.Add(self.goodMatchColorWell, 0, wx.LEFT | wx.RIGHT, 40)
        sizer.Add(wx.StaticText(self, -1, _("Bad match background color") + ":"), 0, wx.LEFT | wx.RIGHT | wx.TOP, 5)
        sizer.Add(self.badMatchColorWell, 0, wx.LEFT | wx.RIGHT, 40)
        sizer.Add(wx.StaticText(self, -1, _("Font color") + ":"), 0, wx.LEFT | wx.RIGHT | wx.TOP, 5)
        sizer.Add(self.fontColorWell, 0, wx.LEFT | wx.RIGHT, 40)
        self.content.Add(sizer, 0, wx.EXPAND)

        self.goodMatchColorWell.setColor(self.config.settingGoodMatchBGColor)
        self.badMatchColorWell.setColor(self.config.settingBadMatchBGColor)
        self.fontColorWell.setColor(self.config.settingFontColor)

    def save(self):
        self.config.settingGoodMatchBGColor = self.goodMatchColorWell.getColor()
        self.config.settingBadMatchBGColor = self.badMatchColorWell.getColor()
        self.config.settingFontColor = self.fontColorWell.getColor()
