# ***** BEGIN LICENSE BLOCK *****
# Version: RCSL 1.0/RPSL 1.0/GPL 2.0
#
# Portions Copyright (c) 1995-2002 RealNetworks, Inc. All Rights Reserved.
# Portions Copyright (c) 2004 Robert Kaye. All Rights Reserved.
#
# The contents of this file, and the files included with this file, are
# subject to the current version of the RealNetworks Public Source License
# Version 1.0 (the "RPSL") available at
# http://www.helixcommunity.org/content/rpsl unless you have licensed
# the file under the RealNetworks Community Source License Version 1.0
# (the "RCSL") available at http://www.helixcommunity.org/content/rcsl,
# in which case the RCSL will apply. You may also obtain the license terms
# directly from RealNetworks.  You may not use this file except in
# compliance with the RPSL or, if you have a valid RCSL with RealNetworks
# applicable to this file, the RCSL.  Please see the applicable RPSL or
# RCSL for the rights, obligations and limitations governing use of the
# contents of the file.
#
# This file is part of the Helix DNA Technology. RealNetworks is the
# developer of the Original Code and owns the copyrights in the portions
# it created.
#
# This file, and the files included with this file, is distributed and made
# available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
# EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS ALL SUCH WARRANTIES,
# INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY, FITNESS
# FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT.
#
# Technology Compatibility Kit Test Suite(s) Location:
#    http://www.helixcommunity.org/content/tck
#
# --------------------------------------------------------------------
#
# picard is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# picard is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with picard; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
#
# Contributor(s):
#   Robert Kaye
#
#
# ***** END LICENSE BLOCK *****

import wx, os, sys, copy
import pydirctrl, albumpanel
from picard import events, wpath

class TaggerDirCtrl(pydirctrl.PyDirCtrl):
    
    selections = []
    menuRefreshId = wx.NewId()

    def __init__(self, parent, frame, albumPanel, id, config, dirCache):
        
        initialDir = config.persistDirControlPath
        wp = wpath.wpath(config)
        while initialDir and not wp.isdir(initialDir):
            head, tail = wp.split(initialDir)
            if head == tail:
                break
            initialDir = head
        
        pydirctrl.PyDirCtrl.__init__(self, parent, id, initialDir=initialDir, 
                                     cache=dirCache, config=config)
        self.frame = frame
        self.config = config
        self.id = id
        self.albumPanel = albumPanel

        self.Bind(wx.EVT_TREE_BEGIN_DRAG, self.OnBeginDrag, id=self.id)
        self.Bind(wx.EVT_TREE_SEL_CHANGED, self.OnSelChanged, id=self.id)
        self.Bind(wx.EVT_RIGHT_DOWN, self.OnRightDown)
        self.Bind(wx.EVT_MENU, self.OnRefresh, id=self.menuRefreshId)

        wx.PostEvent(self.frame, events.ShowDirectoryEvent(initialDir))
        wx.WakeUpIdle()

    def OnSelChanged(self, event):
        paths = self.getSelectedPaths()
        if len(paths) > 0:
            if len(paths) == 1:
                self.config.persistDirControlPath = paths[0]
                wx.PostEvent(self.frame, events.ShowDirectoryEvent(copy.copy(paths[0])))
            else:
                wx.PostEvent(self.frame, events.ShowDirectoryEvent(""))
            wx.WakeUpIdle()

    def OnBeginDrag(self, event):
        paths = self.getSelectedPaths()
        paths = [path for path in paths if wpath.wpath(self.config).isdir(path)]
        if len(paths) > 0:
            tds = wx.DropSource(self)
            tds = albumpanel.TaggerDropSource(self, self.albumPanel) 
            dropText = u"dirs:" + u"\n".join(paths)
            tds.SetData(wx.PyTextDataObject(dropText)) 
            tds.DoDragDrop()
            event.Skip()

    def OnRightDown(self, event):
        item, flags = self.HitTest(wx.Point(event.m_x, event.m_y))
        if item:
            if not self.IsSelected(item):
                self.UnselectAll()
                self.SelectItem(item)
            popupMenu = wx.Menu()
            popupMenu.Append(self.menuRefreshId, u"Refresh")
            self.PopupMenuXY(popupMenu, event.m_x, event.m_y)

    def OnRefresh(self, event):
        sels = self.GetSelections()
        for sel in sels:
            path = self.GetPyData(sel)
            if path:
                self.refreshPath(path)

