# ***** BEGIN LICENSE BLOCK *****
# Version: RCSL 1.0/RPSL 1.0/GPL 2.0
#
# Portions Copyright (c) 1995-2002 RealNetworks, Inc. All Rights Reserved.
# Portions Copyright (c) 2004 Robert Kaye. All Rights Reserved.
#
# The contents of this file, and the files included with this file, are
# subject to the current version of the RealNetworks Public Source License
# Version 1.0 (the "RPSL") available at
# http://www.helixcommunity.org/content/rpsl unless you have licensed
# the file under the RealNetworks Community Source License Version 1.0
# (the "RCSL") available at http://www.helixcommunity.org/content/rcsl,
# in which case the RCSL will apply. You may also obtain the license terms
# directly from RealNetworks.  You may not use this file except in
# compliance with the RPSL or, if you have a valid RCSL with RealNetworks
# applicable to this file, the RCSL.  Please see the applicable RPSL or
# RCSL for the rights, obligations and limitations governing use of the
# contents of the file.
#
# This file is part of the Helix DNA Technology. RealNetworks is the
# developer of the Original Code and owns the copyrights in the portions
# it created.
#
# This file, and the files included with this file, is distributed and made
# available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
# EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS ALL SUCH WARRANTIES,
# INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY, FITNESS
# FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT.
#
# Technology Compatibility Kit Test Suite(s) Location:
#    http://www.helixcommunity.org/content/tck
#
# --------------------------------------------------------------------
#
# picard is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# picard is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with picard; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
#
#   Robert Kaye
#
#
# ***** END LICENSE BLOCK *****

import wx, copy
#import sys

# Here's a quick ready-reference as to where code needs to be added for each
# event:
# * Copy + paste by example in this file (wx.NewId(), an EVT* function, a class)
# * In tagger.py, create a handler function (def OnFoo)
# * In tagger.py, call the connector function EVT_FOO to connect the event to OnFoo

################################################################################

EVT_CLUSTER_ADDED_ID = wx.NewEventType()
EVT_CLUSTER_ADDED = wx.PyEventBinder(EVT_CLUSTER_ADDED_ID, 0)

EVT_CLUSTER_REMOVED_ID = wx.NewEventType()
EVT_CLUSTER_REMOVED = wx.PyEventBinder(EVT_CLUSTER_REMOVED_ID, 0)

EVT_CLUSTER_CHANGED_ID = wx.NewEventType()
EVT_CLUSTER_CHANGED = wx.PyEventBinder(EVT_CLUSTER_CHANGED_ID, 0)

EVT_CLUSTER_FILE_ADDED_ID = wx.NewEventType()
EVT_CLUSTER_FILE_ADDED = wx.PyEventBinder(EVT_CLUSTER_FILE_ADDED_ID, 0)

EVT_CLUSTER_FILE_REMOVED_ID = wx.NewEventType()
EVT_CLUSTER_FILE_REMOVED = wx.PyEventBinder(EVT_CLUSTER_FILE_REMOVED_ID, 0)

class ClusterEvent(wx.PyEvent):
    """Triggered when a cluster is added, removed or changed (file added or removed)."""

    def __init__(self, cluster, eventType):
        wx.PyEvent.__init__(self, eventType=eventType)
        self.cluster = cluster
        assert(eventType in (EVT_CLUSTER_ADDED_ID, EVT_CLUSTER_REMOVED_ID, EVT_CLUSTER_CHANGED_ID))

    def getCluster(self):
        return self.cluster

class ClusterFileEvent(wx.PyEvent):
    """Triggered when a file is added to, or removed from, a cluster."""

    def __init__(self, cluster, fileId, eventType):
        wx.PyEvent.__init__(self, eventType=eventType)
        self.cluster = cluster
        self.fileId = fileId
        assert(eventType in (EVT_CLUSTER_FILE_ADDED_ID, EVT_CLUSTER_FILE_REMOVED_ID))

    def getCluster(self):
        return self.cluster

    def getFileId(self):
        return self.fileId

################################################################################

_myEVT_BROWSER_MSG = wx.NewEventType()
EVT_BROWSER_MSG = wx.PyEventBinder(_myEVT_BROWSER_MSG, 0)

class BrowserMessageEvent(wx.PyEvent):

    def __init__(self, action, args, eventType=_myEVT_BROWSER_MSG):
        wx.PyEvent.__init__(self, eventType=eventType)
        self.action = action
        self.args = args

    def getAction(self):
        return self.action
   
    def getArgs(self):
        return self.args

################################################################################

class AlbumEvent(wx.PyEvent):
    """A base class for various album-related events."""

    def __init__(self, mbid, eventType):
        wx.PyEvent.__init__(self, eventType=eventType)
        self.mbid = mbid

    def getId(self):
        return self.mbid

    def setId(self, mbid):
        self.mbid = mbid

########################################

_myEVT_ALBUM_UPDATE = wx.NewEventType()
EVT_ALBUM_UPDATE = wx.PyEventBinder(_myEVT_ALBUM_UPDATE, 0)

class AlbumUpdateEvent(AlbumEvent):
    """Triggered when an album's pending load has completed (which may or may not have succeeded)."""

    def __init__(self, mbid, eventType=_myEVT_ALBUM_UPDATE):
        AlbumEvent.__init__(self, mbid, eventType=eventType)

########################################

_myEVT_ALBUM_TRACK_COUNTS_CHANGED = wx.NewEventType()
EVT_ALBUM_TRACK_COUNTS_CHANGED = wx.PyEventBinder(_myEVT_ALBUM_TRACK_COUNTS_CHANGED, 0)

class AlbumTrackCountsChangedEvent(AlbumEvent):
    """Triggered when an album's track counts may have changed."""

    def __init__(self, mbid, eventType=_myEVT_ALBUM_TRACK_COUNTS_CHANGED):
        AlbumEvent.__init__(self, mbid, eventType=eventType)

########################################

_myEVT_ALBUM_REMOVED = wx.NewEventType()
EVT_ALBUM_REMOVED = wx.PyEventBinder(_myEVT_ALBUM_REMOVED, 0)

class AlbumRemovedEvent(AlbumEvent):
    """Triggered when an album has been removed from the album manager."""

    def __init__(self, mbid, eventType=_myEVT_ALBUM_REMOVED):
        AlbumEvent.__init__(self, mbid, eventType=eventType)

########################################

_myEVT_ALBUM_REMOVE = wx.NewEventType()
EVT_ALBUM_REMOVE = wx.PyEventBinder(_myEVT_ALBUM_REMOVE, 0)

class AlbumRemoveEvent(AlbumEvent):
    """The user has requested than an album be removed."""

    def __init__(self, mbid, eventType=_myEVT_ALBUM_REMOVE):
        AlbumEvent.__init__(self, mbid, eventType=eventType)

########################################

_myEVT_ALBUM_FILES_REMOVED = wx.NewEventType()
EVT_ALBUM_FILES_REMOVED = wx.PyEventBinder(_myEVT_ALBUM_FILES_REMOVED, 0)

class AlbumFilesRemovedEvent(AlbumEvent):
    """Triggered when a file has been removed from an album."""

    def __init__(self, mbid, fileIdList, eventType=_myEVT_ALBUM_FILES_REMOVED):
        AlbumEvent.__init__(self, mbid, eventType=eventType)
        self.fileIdList = fileIdList

    def getFileList(self):
        return self.fileIdList

########################################

_myEVT_ALBUM_REMOVE_UNMATCHED_FILES = wx.NewEventType()
EVT_ALBUM_REMOVE_UNMATCHED_FILES = wx.PyEventBinder(_myEVT_ALBUM_REMOVE_UNMATCHED_FILES, 0)

class AlbumRemoveUnmatchedFilesEvent(AlbumEvent):
    """The user has requested that an album's unmatched files be removed."""

    def __init__(self, mbid, eventType=_myEVT_ALBUM_REMOVE_UNMATCHED_FILES):
        AlbumEvent.__init__(self, mbid, eventType=eventType)

########################################

_myEVT_MOVE_ALBUM_UNMATCHED_TO_UNMATCHED = wx.NewEventType()
EVT_MOVE_ALBUM_UNMATCHED_TO_UNMATCHED = wx.PyEventBinder(_myEVT_MOVE_ALBUM_UNMATCHED_TO_UNMATCHED, 0)

class MoveAlbumUnmatchedToUnmatchedEvent(AlbumEvent):
    """The user has requested that an album's unmatched files all be moved back to the main "unmatched files" set."""

    def __init__(self, mbid, eventType=_myEVT_MOVE_ALBUM_UNMATCHED_TO_UNMATCHED):
        AlbumEvent.__init__(self, mbid, eventType=eventType)

################################################################################

class CoverArtEvent(wx.PyEvent):

    def __init__(self, asin, eventType):
        wx.PyEvent.__init__(self, eventType=eventType)
        self.asin = asin

    def getAsin(self):
        return self.asin
   
    def setAsin(self, asin):
        self.asin = asin

########################################

_myEVT_COVERART_LOAD = wx.NewEventType()
EVT_COVERART_LOAD = wx.PyEventBinder(_myEVT_COVERART_LOAD, 0)

class CoverArtLoadEvent(CoverArtEvent):
    """Triggered when an album's cover art has been loaded, ready for display."""

    def __init__(self, asin, eventType=_myEVT_COVERART_LOAD):
        CoverArtEvent.__init__(self, asin, eventType=eventType)

########################################

_myEVT_COVERART_SHOW = wx.NewEventType()
EVT_COVERART_SHOW = wx.PyEventBinder(_myEVT_COVERART_SHOW, 0)

class CoverArtShowEvent(CoverArtEvent):

    def __init__(self, asin, eventType=_myEVT_COVERART_SHOW):
        CoverArtEvent.__init__(self, asin, eventType=eventType)

################################################################################

_myEVT_FILE_ADD = wx.NewEventType()
EVT_FILE_ADD = wx.PyEventBinder(_myEVT_FILE_ADD, 0)

class FileAddEvent(wx.PyEvent):
    """The user has requested that some file(s) be added to tunepimp."""

    def __init__(self, fileNames, albumId = "", albumSeq = "", eventType=_myEVT_FILE_ADD):
        wx.PyEvent.__init__(self, eventType=eventType)
        self.fileNames = copy.copy(fileNames)
        self.albumId = copy.copy(albumId)
        self.albumSeq = copy.copy(albumSeq)

    def getFileNames(self):
        return self.fileNames

    def getAlbumId(self):
        return self.albumId

    def getAlbumSeq(self):
        return self.albumSeq

################################################################################

_myEVT_DIR_ADD = wx.NewEventType()
EVT_DIR_ADD = wx.PyEventBinder(_myEVT_DIR_ADD, 0)

class DirAddEvent(wx.PyEvent):
    """The user has requested that some directory/ies (the files there in)  be added to tunepimp."""

    def __init__(self, dirNames, eventType=_myEVT_DIR_ADD):
        wx.PyEvent.__init__(self, eventType=eventType)
        self.dirNames = dirNames

    def getDirNames(self):
        return self.dirNames

################################################################################

_myEVT_SHOW_ITEM_DETAILS = wx.NewEventType()
EVT_SHOW_ITEM_DETAILS = wx.PyEventBinder(_myEVT_SHOW_ITEM_DETAILS, 0)

class ShowItemDetailsEvent(wx.PyEvent):

    def __init__(self, item, eventType=_myEVT_SHOW_ITEM_DETAILS):
        wx.PyEvent.__init__(self, eventType=eventType)
        self.item = item

    def getItem(self):
        return self.item

################################################################################

_myEVT_SHOW_DIRECTORY = wx.NewEventType()
EVT_SHOW_DIRECTORY = wx.PyEventBinder(_myEVT_SHOW_DIRECTORY, 0)

class ShowDirectoryEvent(wx.PyEvent):

    def __init__(self, dir, eventType=_myEVT_SHOW_DIRECTORY):
        wx.PyEvent.__init__(self, eventType=eventType)
        self.dir = dir

    def getDir(self):
        return self.dir

################################################################################

class LinkEvent(wx.PyEvent):
    """A base class for events for linking and unlinking tracks / files."""

    def __init__(self, trackId, fileId, eventType):
        wx.PyEvent.__init__(self, eventType=eventType)
        self.trackId = trackId
        self.fileId = fileId

    def getTrackId(self):
        return self.trackId

    def getFileId(self):
        return self.fileId

########################################

_myEVT_LINK_FILE = wx.NewEventType()
EVT_LINK_FILE = wx.PyEventBinder(_myEVT_LINK_FILE, 0)

class LinkFileEvent(LinkEvent):
    """The user has requested that a file be linked to a track."""
    
    def __init__(self, trackId, fileId, eventType=_myEVT_LINK_FILE):
        LinkEvent.__init__(self, trackId, fileId, eventType=eventType)

################################################################################

_myEVT_SAVE_FILE = wx.NewEventType()
EVT_SAVE_FILE = wx.PyEventBinder(_myEVT_SAVE_FILE, 0)

class SaveFileEvent(wx.PyEvent):
    """Some files are ready to be saved.  Triggered indirectly by the "save" button."""

    def __init__(self, fileIdList, eventType=_myEVT_SAVE_FILE):
        wx.PyEvent.__init__(self, eventType=eventType)
        self.fileIdList = fileIdList

    def getFileIdList(self):
        return self.fileIdList

################################################################################

class FileEvent(wx.PyEvent):
    """A base class for various tunepimp file-related events."""

    def __init__(self, fileId, eventType):
        wx.PyEvent.__init__(self, eventType=eventType)
        self.fileId = fileId

    def getFileId(self):
        return self.fileId

########################################

_myEVT_UPDATE_FILE = wx.NewEventType()
EVT_UPDATE_FILE = wx.PyEventBinder(_myEVT_UPDATE_FILE, 0)

class UpdateFileEvent(FileEvent):

    def __init__(self, fileId, eventType=_myEVT_UPDATE_FILE):
        FileEvent.__init__(self, fileId, eventType=eventType)

########################################

_myEVT_ANALYZE_FILE2 = wx.NewEventType()
EVT_ANALYZE_FILE2 = wx.PyEventBinder(_myEVT_ANALYZE_FILE2, 0)

class AnalyzeFile2Event(wx.PyEvent):

    def __init__(self, fileIdList, eventType=_myEVT_ANALYZE_FILE2):
        wx.PyEvent.__init__(self, eventType=eventType)
        self.fileIdList = fileIdList

    def getFileIdList(self):
        return copy.copy(self.fileIdList)

########################################

_myEVT_ANALYZE_FILE = wx.NewEventType()
EVT_ANALYZE_FILE = wx.PyEventBinder(_myEVT_ANALYZE_FILE, 0)

class AnalyzeFileEvent(wx.PyEvent):
    """Analyze the file again after the user corrected some error. """

    def __init__(self, fileIdList, eventType=_myEVT_ANALYZE_FILE):
        wx.PyEvent.__init__(self, eventType=eventType)
        self.fileIdList = fileIdList

    def getFileIdList(self):
        return copy.copy(self.fileIdList)

########################################

_myEVT_CLEAR_ERROR = wx.NewEventType()
EVT_CLEAR_ERROR = wx.PyEventBinder(_myEVT_CLEAR_ERROR, 0)

class ClearErrorEvent(FileEvent):
    """The user cleared an error from a track and wants to attempt saving it again."""

    def __init__(self, fileId, eventType=_myEVT_CLEAR_ERROR):
        FileEvent.__init__(self, fileId, eventType=eventType)

########################################

_myEVT_FORCE_SAVE = wx.NewEventType()
EVT_FORCE_SAVE = wx.PyEventBinder(_myEVT_FORCE_SAVE, 0)

class ForceSaveEvent(FileEvent):
    """The user wants to force saving this file, even if libtp doesn't think anything has changed."""

    def __init__(self, fileId, eventType=_myEVT_FORCE_SAVE):
        FileEvent.__init__(self, fileId, eventType=eventType)

########################################

_myEVT_RELOAD_ALBUM = wx.NewEventType()
EVT_RELOAD_ALBUM = wx.PyEventBinder(_myEVT_RELOAD_ALBUM, 0)

class ReloadAlbumEvent(AlbumEvent):
    """The user wants to reload the album from the server since the server data may have changed."""

    def __init__(self, albumId, eventType=_myEVT_RELOAD_ALBUM):
        AlbumEvent.__init__(self, albumId, eventType=eventType)

########################################

_myEVT_GENERATE_CUESHEET = wx.NewEventType()
EVT_GENERATE_CUESHEET = wx.PyEventBinder(_myEVT_GENERATE_CUESHEET, 0)

class GenerateCuesheetEvent(AlbumEvent):
    """The user wants to generate a cuesheet."""

    def __init__(self, albumId, eventType=_myEVT_GENERATE_CUESHEET):
        AlbumEvent.__init__(self, albumId, eventType=eventType)

########################################

_myEVT_GENERATE_PLAYLIST = wx.NewEventType()
EVT_GENERATE_PLAYLIST = wx.PyEventBinder(_myEVT_GENERATE_PLAYLIST, 0)

class GeneratePlaylistEvent(AlbumEvent):
    """The user wants to generate a M3U playlist."""

    def __init__(self, albumId, eventType=_myEVT_GENERATE_PLAYLIST):
        AlbumEvent.__init__(self, albumId, eventType=eventType)

################################################################################

_myEVT_MOVE_FILES_TO_UNMATCHED = wx.NewEventType()
EVT_MOVE_FILES_TO_UNMATCHED = wx.PyEventBinder(_myEVT_MOVE_FILES_TO_UNMATCHED, 0)

class MoveFilesToUnmatchedEvent(wx.PyEvent):
    """The user has requested that some files be moved to "unmatched files"."""

    def __init__(self, fileIdList, eventType=_myEVT_MOVE_FILES_TO_UNMATCHED):
        wx.PyEvent.__init__(self, eventType=eventType)
        self.fileIdList = fileIdList

    def getFileIdList(self):
        return copy.copy(self.fileIdList)

################################################################################

_myEVT_MATCH_FILES_TO_ALBUM = wx.NewEventType()
EVT_MATCH_FILES_TO_ALBUM = wx.PyEventBinder(_myEVT_MATCH_FILES_TO_ALBUM, 0)

class MatchFilesToAlbumEvent(wx.PyEvent):
    """The user has requested that some files (given by filename) be matched to an album."""

    def __init__(self, fileList, albumId, eventType=_myEVT_MATCH_FILES_TO_ALBUM):
        wx.PyEvent.__init__(self, eventType=eventType)
        self.fileList = fileList
        self.albumId = albumId

    def getFileList(self):
        return self.fileList

    def getAlbumId(self):
        return self.albumId

################################################################################

_myEVT_MATCH_FILEIDS_TO_ALBUM = wx.NewEventType()
EVT_MATCH_FILEIDS_TO_ALBUM = wx.PyEventBinder(_myEVT_MATCH_FILEIDS_TO_ALBUM, 0)

class MatchFileIdsToAlbumEvent(wx.PyEvent):
    """The user has requested that some files be moved onto some album
    OR
    file matching has been triggered because an album has just finished loading
    """

    def __init__(self, fileIdList, albumId, eventType=_myEVT_MATCH_FILEIDS_TO_ALBUM):
        wx.PyEvent.__init__(self, eventType=eventType)
        self.fileIdList = fileIdList
        self.albumId = albumId

    def getFileIdList(self):
        return self.fileIdList

    def getAlbumId(self):
        return self.albumId

################################################################################

_myEVT_MATCH_DIR_TO_ALBUM = wx.NewEventType()
EVT_MATCH_DIR_TO_ALBUM = wx.PyEventBinder(_myEVT_MATCH_DIR_TO_ALBUM, 0)

class MatchDirToAlbumEvent(wx.PyEvent):
    """The user has matched (dragged) a directory to an album."""

    def __init__(self, dirName, albumId, eventType=_myEVT_MATCH_DIR_TO_ALBUM):
        wx.PyEvent.__init__(self, eventType=eventType)
        self.dirName = dirName
        self.albumId = albumId

    def getDirName(self):
        return self.dirName

    def getAlbumId(self):
        return self.albumId

################################################################################

_myEVT_ADD_FILE_TO_CLUSTER = wx.NewEventType()
EVT_ADD_FILE_TO_CLUSTER = wx.PyEventBinder(_myEVT_ADD_FILE_TO_CLUSTER, 0)

class AddFileToClusterEvent(wx.PyEvent):
    """The user has requested that a file be moved into some cluster."""

    def __init__(self, fileId, clusterId, eventType=_myEVT_ADD_FILE_TO_CLUSTER):
        wx.PyEvent.__init__(self, eventType=eventType)
        self.fileId = fileId
        self.clusterId = clusterId

    def getFileId(self):
        return self.fileId

    def getClusterId(self):
        return self.clusterId

################################################################################

_myEVT_REMOVE_CLUSTER_ALBUM = wx.NewEventType()
EVT_REMOVE_CLUSTER_ALBUM = wx.PyEventBinder(_myEVT_REMOVE_CLUSTER_ALBUM, 0)

class RemoveClusterAlbumEvent(wx.PyEvent):
    """The user has requested that a cluster be removed."""

    def __init__(self, clusterId, eventType=_myEVT_REMOVE_CLUSTER_ALBUM):
        wx.PyEvent.__init__(self, eventType=eventType)
        self.clusterId = clusterId

    def getClusterId(self):
        return self.clusterId

################################################################################

_myEVT_CLUSTER_UNMATCHED_FILES = wx.NewEventType()
EVT_CLUSTER_UNMATCHED_FILES = wx.PyEventBinder(_myEVT_CLUSTER_UNMATCHED_FILES, 0)

class ClusterUnmatchedFilesEvent(wx.PyEvent):
    """The user has requested that unmatched files be clustered."""

    def __init__(self, threshold, eventType=_myEVT_CLUSTER_UNMATCHED_FILES):
        wx.PyEvent.__init__(self, eventType=eventType)
        self.threshold = threshold

    def getThreshold(self):
        return self.threshold

################################################################################

_myEVT_MOVE_CLUSTERS_TO_UNMATCHED = wx.NewEventType()
EVT_MOVE_CLUSTERS_TO_UNMATCHED = wx.PyEventBinder(_myEVT_MOVE_CLUSTERS_TO_UNMATCHED, 0)

class MoveClustersToUnmatchedEvent(wx.PyEvent):
    """The user has requested that an album (???) be moved to "unmatched files"."""

    def __init__(self, eventType=_myEVT_MOVE_CLUSTERS_TO_UNMATCHED):
        wx.PyEvent.__init__(self, eventType=eventType)

################################################################################

_myEVT_SETTINGS_CHANGED = wx.NewEventType()
EVT_SETTINGS_CHANGED = wx.PyEventBinder(_myEVT_SETTINGS_CHANGED, 0)

class SettingsChangedEvent(wx.PyEvent):
    """The tunepimp settings have changed."""

    def __init__(self, eventType=_myEVT_SETTINGS_CHANGED):
        wx.PyEvent.__init__(self, eventType=eventType)

################################################################################

_myEVT_REMOVE_TPFILE_COMMAND = wx.NewEventType()
EVT_REMOVE_TPFILE_COMMAND = wx.PyEventBinder(_myEVT_REMOVE_TPFILE_COMMAND, 0)

class RemoveTPFileCommand(wx.PyEvent):
    """The user has requested that some file be removed from tunepimp."""

    def __init__(self, fileId, eventType=_myEVT_REMOVE_TPFILE_COMMAND):
        wx.PyEvent.__init__(self, eventType=eventType)
        self.fileId = fileId

    def getFileId(self):
        return self.fileId

################################################################################

_myEVT_ALBUM_FILES_ADDED = wx.NewEventType()
EVT_ALBUM_FILES_ADDED = wx.PyEventBinder(_myEVT_ALBUM_FILES_ADDED, 0)

class AlbumFilesAddedEvent(AlbumEvent):
    """Triggered when a file has been added to an album (either linked to a specific track, or not ('unmatched')."""

    def __init__(self, mbid, fileIdList, eventType=_myEVT_ALBUM_FILES_ADDED):
        AlbumEvent.__init__(self, mbid, eventType=eventType)
        self.fileIdList = fileIdList

    def getFileList(self):
        return self.fileIdList

################################################################################

_myEVT_ALBUM_ADD = wx.NewEventType()
EVT_ALBUM_ADD = wx.PyEventBinder(_myEVT_ALBUM_ADD, 0)

class AlbumAddEvent(AlbumEvent):
    """Triggered when an album has been added to the album manager."""

    def __init__(self, mbid, eventType=_myEVT_ALBUM_ADD):
        AlbumEvent.__init__(self, mbid, eventType=eventType)

################################################################################

_myEVT_SET_STATUS_TEXT = wx.NewEventType()
EVT_SET_STATUS_TEXT = wx.PyEventBinder(_myEVT_SET_STATUS_TEXT, 0)

class SetStatusTextEvent(wx.PyEvent):
    """Set the status bar text."""
    
    def __init__(self, text, eventType=_myEVT_SET_STATUS_TEXT):
        wx.PyEvent.__init__(self, eventType=eventType)
        self.text = text

################################################################################

_myEVT_SHOW_STARTUP_DIALOGS = wx.NewEventType()
EVT_SHOW_STARTUP_DIALOGS = wx.PyEventBinder(_myEVT_SHOW_STARTUP_DIALOGS, 0)

class ShowStartupDialogsEvent(wx.PyEvent):
    
    DONATION = 1
    ACCOUNT = 2
    CONNECTION_ERROR = 4
    
    def __init__(self, dialogs, eventType=_myEVT_SHOW_STARTUP_DIALOGS):
        wx.PyEvent.__init__(self, eventType=eventType)
        self.dialogs = dialogs

