<?php
/**
 * Turkish Language file for PhpGedView.
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2002 to 2007  PGV Development Team
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * @package PhpGedView
 * @author Kurt Norgaz
 * @author Adem GENÇ uzayuydu@gmail.com http://www.muttafi.com
 * @version $Id: lang.tr.php 1974 2007-10-20 03:33:42Z canajun2eh $
 */
if (stristr($_SERVER["SCRIPT_NAME"], basename(__FILE__))!==false) {
	print "Doğrudan lisan dosyasına erişemezsiniz.";
	exit;
}

$pgv_lang["date_of_entry"]				= "Orijinal kaynağın giriş tarihi";
$pgv_lang["continue_import2"]		= "Tarih verilerini okumaya devam et";
$pgv_lang["importing_dates"]		= "Tarih verileri okunuyor";
$pgv_lang["changelog"]			= "v#VERSION# sürümündeki değişiklikler";
$pgv_lang["view_changelog"]			= "changelog.txt dosyayı görüntüle";
$pgv_lang["html_block_descr"]		= "Sizin isteyebildiğiniz mesajın çeşidini eklemek için bu sizin sayfanızda yerleştirebildiğiniz bir basit HTML bloktur.";
$pgv_lang["html_block_sample_part1"]	= "<p class=\"blockhc\"><b>Başlığınızı buraya yerleştirin</b></p><br /><p>configure düğmesini tıkla";
$pgv_lang["html_block_name"]		= "HTML Blok";
$pgv_lang["htmlplus_block_name"]	= "Gelişmiş HTML";
$pgv_lang["htmlplus_block_descr"]	= "Bu blok HTML blokudur, Sayfanızdan her hangibir mesej eklemek için bu bloğu yerleştirebilirsiniz. Bu loğun içine HTML kodlarıyla GEDCOM hakkında bilgiler verebilirsiniz.";
$pgv_lang["htmlplus_block_templates"] = "Şablonlar";
$pgv_lang["htmlplus_block_content"] = "İçerik";
$pgv_lang["htmlplus_block_narrative"] = "Öykü stili (Sadece ingilizce)";
$pgv_lang["htmlplus_block_custom"]	= "Özel";
$pgv_lang["htmlplus_block_keyword"]	= "Örnek Anatar Sözcük (Sadece İngilizce)";
$pgv_lang["htmlplus_block_taglist"]	= "Tag Listesi";
$pgv_lang["htmlplus_block_compat"]	= "Uygunluk Modu";
$pgv_lang["htmlplus_block_current"]	= "Şimdiki";
$pgv_lang["htmlplus_block_default"]	= "Varsayılan";
$pgv_lang["htmlplus_block_gedcom"]	= "Aile Ağacı";
$pgv_lang["htmlplus_block_birth"]	= "doğum";
$pgv_lang["htmlplus_block_death"]	= "ölüm";
$pgv_lang["htmlplus_block_marrage"]	= "evlenme";
$pgv_lang["htmlplus_block_adoption"]= "evlat edinme";
$pgv_lang["htmlplus_block_burial"]	= "defin";
$pgv_lang["htmlplus_block_census"]	= "nüfüs sayımı eklendi";
$pgv_lang["num_to_show"]			= "Gösterilecek adet";
$pgv_lang["days_to_show"]			= "Gösterilecek gün sayısı";
$pgv_lang["before_or_after"]		= "Sayaç isimlerden önce? veya sonra?";
$pgv_lang["before"]					= "önce";
$pgv_lang["after"]					= "sonra";
$pgv_lang["config_block"]			= "Blok Konfigurasyonu";
$pgv_lang["pls_note12"]				= "Lütfen kendinizi tanıtın, Muttafi Gencaloğlu sülalesinden iseniz yönetici size giriş izni vermesi için detaylı olarak kendinizi tanıtın.";
$pgv_lang["enter_comments"]			= "Please enter your relationship to the data in the Comments field.";
$pgv_lang["comments"]				= "Çok detaylı kendinizi tanıtın:";
$pgv_lang["none"]					= "Hiç biri";
$pgv_lang["ahnentafel_born_m"]		= "in doğumu";
$pgv_lang["ahnentafel_born_f"]		= "in doğumu";
$pgv_lang["ahnentafel_christened_m"] = "Vaftiz edil";
$pgv_lang["ahnentafel_christened_f"] = "Vaftiz edil";
$pgv_lang["ahnentafel_report"]		= "Soy raporu";
$pgv_lang["ahnentafel_header"]		= "Soy raporu için ";
$pgv_lang["ahnentafel_generation"]	= "Nesil";
$pgv_lang["ahnentafel_pronoun_m"]	= "Bay ";
$pgv_lang["ahnentafel_pronoun_f"]	= "Bayan ";
$pgv_lang["ahnentafel_married_m"]	= "evli";
$pgv_lang["ahnentafel_married_f"]	= "evli";
$pgv_lang["ahnentafel_died_m"]		= "öldü";
$pgv_lang["ahnentafel_died_f"]		= "öldü";
$pgv_lang["ahnentafel_buried_m"]	= "gömülü";
$pgv_lang["ahnentafel_buried_f"]	= "gömülü";
$pgv_lang["ahnentafel_place"]		= " yeri ";
$pgv_lang["ahnentafel_no_details"]	= " Fakat bilinmeyen ayrıntılar";
$pgv_lang["descend_report"]		= "Şahsı İzleyen Nesiller Rapor";
$pgv_lang["descendancy_header"]		= "Şahsı İzleyen Nesiller Rapor için ";
$pgv_lang["child-family"]			= "Ebeveynler ve Kardeşler";
$pgv_lang["spouse-family"]			= "Hayat arkadaşı ve çocuklar";
$pgv_lang["direct-ancestors"]		= "Direk atalara doğru";
$pgv_lang["ancestors"]				= "Direk atalara doğru ve onların aileleri";
$pgv_lang["descendants"]			= "Çocuksuzlar";
$pgv_lang["choose_relatives"]		= "Akraba seçimi";
$pgv_lang["relatives_report"]		= "Akrabalık raporu";
$pgv_lang["total_living"]			= "Yaşayanların sayısı";
$pgv_lang["total_dead"]				= "Ölülerin sayısı";
$pgv_lang["total_not_born"]			= "Doğmamışların sayısı";
$pgv_lang["remove_custom_tags"]		= "Özel PGV etiketleri kaldır? (eg. _PGVU, _THUM)";
$pgv_lang["download_zipped"]		= "GEDCOM ZİP-dosyası olarak indirilsin mi?";
$pgv_lang["cookie_login_help"]		= "Bu site bir önceki girişinizden sizi hatırladı. Bu erişim özel bilgiye, siteyi düzenlemek ve yönetmeye  izin verir ancak artırılmış güvenlik olarak tekrar giriş yapmanız gerekiyor, Lütfen Rumuz adınızı ve Şifrenizi girerek giriş yapın.";
$pgv_lang["remember_me"]		= "Beni bu bilgisayarda hatırla";
$pgv_lang["add_unlinked_person"]	= "Yeni şahıs ekle";
$pgv_lang["add_unlinked_source"]	= "Kaynak bağlanmayana bir kaynak ekle";
$pgv_lang["fams_with_surname"]		= "#Soyad# Soyad ile aileler";
$pgv_lang["support_contact"]		= "Teknik yardım ilişkisi";
$pgv_lang["genealogy_contact"]		= "Soykütüğü bağlantı";
$pgv_lang["importing_places"]		= "İthal edilen yer kayıtları";
$pgv_lang["total_memory_usage"]		= "Topam Kullanılan Hafıza";
$pgv_lang["mothers_family_with"]	= "Anne için Aile ";
$pgv_lang["fathers_family_with"]	= "Babanın Diğer Ailesi ";
$pgv_lang["halfbrother"]			= "Üvey-Erkek Kardeş";
$pgv_lang["halfsister"]				= "Üvey-Kız Kardeş";
$pgv_lang["halfsibling"]			= "Üvey-Kardeş";
$pgv_lang["family_timeline"]		= "Zaman çizgi şemasında aileye göster";
$pgv_lang["children_timeline"]		= "Zaman çizgi şemasında çocuklara göster";
$pgv_lang["continue_import"]		= "İthal edilen yerlere devam";
$pgv_lang["other"]			= "Çeşitli";
$pgv_lang["sort_by_marriage"]		= "Evlilik tarihi yoluyla sırala";
$pgv_lang["reorder_families"]		= "Aileleri Yeniden Sırala";
$pgv_lang["indis_with_surname"]		= "#Soyad# Soyad ile bireyseller";
$pgv_lang["first_letter_fname"]		= "Mektubunun üzerinde bu ad ile başlayan bireyleri göstermek için mektubu se.";
$pgv_lang["import_marr_names"]		= "Evli İsimler İçeri Aktarımı";
$pgv_lang["marr_name_import_instr"]	= "Sadece bu soy ağacında evli kadınları hesaplayarak görüntülemek için aşağıdaki butonu tıklayın. Burada evli kadın isimleri arayıp listelemenize izin verecektir.";
$pgv_lang["calc_marr_names"]		= "Hesaplanan Evli İsimler";
$pgv_lang["total_names"]			= "Toplam isim sayısı";
$pgv_lang["upload_file"]			= "Bilgisayarınızdan resim yükleyin";
$pgv_lang["thumb_genned"]			= "Tırnak önizleme otomatik olarak üret.";
$pgv_lang["thumbgen_error"]			= "Tırnak önizleme üretme başarısız";
$pgv_lang["generate_thumbnail"]		= "Otomatik olarak tırnak önizleme üret ";
$pgv_lang["auto_thumbnail"]			= "Otomatik tırnak önizleme";
$pgv_lang["no_upload"]				= "Medya dosyaları yükleme izni verilmedi, Çoklu-medya dosyaları yükleme izni verilmedi veya media dosya yazılabilir değildir.";
$pgv_lang["upload"]					= "Yükle";
$pgv_lang["top10_pageviews_nohits"]	= "Orada halen gösterecek birşey yok.";
$pgv_lang["top10_pageviews_msg"]	= "Bu blok için sayaçları çalıştırmak için konfigürasyonda sayaçlar etkinlileştirilmedir.";
$pgv_lang["review_changes_block"]	= "Ilımlıdaki Değişiklikler";
$pgv_lang["review_changes_subject"]	= "PhpGedView de - Değişenleri Tekrar Görüntüle";
$pgv_lang["review_changes_body"]	= "Çevrimiçi değişiklikler, Soyağacındaki GEDCOM içinde bazı değişiklikler yapıldı, Bu değişiklikler diğer ziyaretçilere görünmeden önde yöneticinin onayı gereken değişiklik bekliyor. Aşağıdaki linki kullanarak soyağacına giriş yapıp değişikliği gözden geçirip uygun ise onaylayınız. Soyağacına Giriş için Aşağıdaki Linki Tıklayın.";
$pgv_lang["show_pending"]		= "Ilımlıdaki Değişenleri Göster";
$pgv_lang["show_spouses"]		= "Eşleri göster";
$pgv_lang["quick_update_title"]		= "Hızlı güncelleme";
$pgv_lang["quick_update_instructions"] = "Bu sayfada kişisel bilgilerinizi hızlı güncellemenize izin verir. Sadece şu anda veritabanında olan bilgilerinizi değiştirmek için veya yeni bir bilginizi girme ihtiyacı duyuyorsanız kullanın. Değişimlerinizi veya yeni bilgilerinizi gönderdikten sonra diğer üyelere gösterilmeden önce yönetici tarafından incelenip üygün görüldüğünde onaylacaktır.";
$pgv_lang["update_name"] = "İsmi Güncelle";
$pgv_lang["update_fact"]		= "Hadiseyi güncelle";
$pgv_lang["update_fact_restricted"] = "Bu gerçeğin günceleştirilmesi sınırlıdır:";
$pgv_lang["update_photo"]		= "Fotoğrafı güncelle";
$pgv_lang["photo_replace"]		= "Bu fotoğrafı eski bir fotoğraf yerine mi koymak istiyorsunuz?";
$pgv_lang["select_fact"]		= "Hadise seç...";
$pgv_lang["update_address"]		= "Adresi güncelle";
$pgv_lang["add_new_chil"]		= "Yeni çocuk ekle";
$pgv_lang["top10_pageviews_descr"]	= "Bu bloğu görüntüleyen ençok 10 kayıdı gösterecek. Bu bloğu tıklayan hit sayıları görmek için GEDCOM konfigüresyon ayarları etkinleştirin.";
$pgv_lang["top10_pageviews"]		= "En Çok Görüntülenler";
$pgv_lang["top10_pageviews_block"]		= "Ençok Görüntülenen Blok Parçaları";
$pgv_lang["user_default_tab"]		= "Şahısların bilgileri sayfasında gösterilecek ilk sekme";
$pgv_lang["stepfamily"]				= "Adım Aile";
$pgv_lang["stepdad"]				= "Adım-Baba";
$pgv_lang["stepmom"]				= "Adım-Anne";
$pgv_lang["stepsister"]				= "Adım-Kız Kardeş";
$pgv_lang["stepbrother"]			= "Adım-Erkek Kardeş";
$pgv_lang["max_upload_size"]		= "Enfazla Yükleme Boyutu: ";
$pgv_lang["edit_fam"]				= "Aile Düzenle";
$pgv_lang["fams_charts"]			= "Aile için Seçenekler";
$pgv_lang["sort_by_birth"]			= "Doğum Tarihi Yoluyla Sırala";
$pgv_lang["reorder_children"]		= "Çocukları Tekrar Düzenle";
$pgv_lang["copy"]					= "Kopyala";
$pgv_lang["cut"]					= "Kes";
$pgv_lang["indis_charts"]		= "Şahsi seçenekler";
$pgv_lang["edit_indi"] 				= "Kişisel Düzenle";
$pgv_lang["locked"]					= "Değiştirme";
$pgv_lang["privacy"]				= "Mahremiyet";
$pgv_lang["number_sign"]			= "#";
$pgv_lang["review_changes_email_freq"]	= "Hatırlatıcı email frekansı (gün)";
$pgv_lang["external_objects"]		= "Dış nesneler";

//-- GENERAL HELP MESSAGES
$pgv_lang["qm"]				= "?";
$pgv_lang["qm_ah"]					= "?";
$pgv_lang["page_help"]			= "Yardım";
$pgv_lang["help_for_this_page"]		= "Bu sayfa üzerine yardım";
$pgv_lang["help_contents"]		= "Yardım içeriği";
$pgv_lang["show_context_help"]		= "Bağlamsal yardımı GÖSTER";
$pgv_lang["hide_context_help"]		= "Bağlamsal yardımı SAKLA";
$pgv_lang["sorry"]			= "<b>Ne yazık ki bu sayfa ya da bölümün yardım mesajı daha tamamlanmamıştır</b>";
$pgv_lang["help_not_exist"]		= "<b>Ne yazık ki bu sayfanın ya da bu bölümün yardım mesajı daha işlenmemiştir</b>";
$pgv_lang["var_not_exist"]			= "<span style=font-weight: bold>Bu lisan değişkeni yok. Lütfen bu hatayı rapor edin.</span>";
$pgv_lang["resolution"]			= "Ekran çözünürlüğü";
$pgv_lang["menu"]			= "Seçenek listesi";
$pgv_lang["header"]			= "Başlık";
$pgv_lang["imageview"]				= "Resim Görüntüle";
$pgv_lang["login_head"]			= "PhpGedView üye girişi";
$pgv_lang["review_changes_email"]	= "Hatırlatıcı emailler gönder?";

//-- CONFIG FILE MESSAGES
$pgv_lang["error_title"]		= "HATA: GEDCOM dosyası açılamıyor";
$pgv_lang["error_header"]		= "[#GEDCOM#], isimli GEDCOM dosyası, belirlenen yerde bulunamadı.";
$pgv_lang["error_header_write"] 	= "[#GEDCOM#] isimli GEDCOM dosyasına yazma izni yoktur. Check attributes and access rights.";
$pgv_lang["for_support"]		= "Teknik yardım ve bilgi için danışabileceğiniz ilişki adresi:";
$pgv_lang["for_contact"]		= "Seçere hakkında yardım için danışabileceğiniz ilişki adresi:";
$pgv_lang["for_all_contact"]		= "Teknik yardım veya seçere ile ilgili sorular için danışabileceğiniz ilişki adresi:";
$pgv_lang["build_title"]		= "İndeks dosyaları inşa ediliyor";
$pgv_lang["build_error"]		= "GEDCOM dosyası güncelleştirildi.";
$pgv_lang["choose_username"]		= "Kullanıcı adı(rumuz)";
$pgv_lang["please_wait"]		= "Lütfen biraz bekleyin. İndeks dosyaları yeniden yaratılmaktadır.";
$pgv_lang["choose_gedcom"]		= "Bir GEDCOM veritabanını seç";
$pgv_lang["username"]			= "Rumuz";
$pgv_lang["invalid_username"]		= "Rumuz içinde geçersiz harfler bulunmaktadır";
$pgv_lang["firstname"]				= "Adınız";
$pgv_lang["lastname"]				= "Soyadınız";
$pgv_lang["choose_password"]		= "Şifre";
$pgv_lang["fullname"]			= "Komple isim";
$pgv_lang["password"]			= "Şifre";
$pgv_lang["confirm"]			= "Şifre tekrarla";
$pgv_lang["user_contact_method"]	= "Tercih edilen ilişki yöntemi";
$pgv_lang["login"]			= "Giriş";
$pgv_lang["login_aut"]			= "Üye verilerini işle";
$pgv_lang["logout"]			= "Çıkış";
$pgv_lang["admin"]			= "İdare / Ayarlar";
$pgv_lang["logged_in_as"]		= "Giriş rumuzu";
$pgv_lang["my_pedigree"]		= "Benim soyağacım";
$pgv_lang["my_indi"]			= "Şahsi sayfam";
$pgv_lang["yes"]			= "Evet";
$pgv_lang["no"]				= "Hayır";
$pgv_lang["add_gedcom"]			= "GEDCOM ekle";
$pgv_lang["no_support"]			= "Sizin tarayıcınızın bu PhpGedView sitesi için gerekli olan standartları desteklemediği tespit edildi. Çoğu tarayıcılar en yeni sürümlerinde bu standartları desteklemektedirler. Bunun için tarayıcınızı güncelleştirmenizi önermek isteriz.";
$pgv_lang["change_theme"]		= "Temayı değiştir ";
$pgv_lang["gedcom_downloadable"]	= "Bu GEDECOM dosyası İnternet üzerinden indirilebilinir!<br />Lütfen <a href=\"readme.txt\">readme.txt</a> dosyasının \"SECURITY\" bölümünü okuyup bu sorunu ortadan kaldırın.";

//-- INDEX (PEDIGREE_TREE) FILE MESSAGES
$pgv_lang["index_header"]		= "Soyağacı Ağaç Çizimi";
$pgv_lang["gen_ped_chart"]		= "#PEDIGREE_GENERATIONS# nesil - Soyağacı Ağaç Çizim görüntüsü";
$pgv_lang["generations"]		= "Gösterilecek nesil sayısı";
$pgv_lang["view"]			= "Göster";
$pgv_lang["fam_spouse"]			= "Eş ve aile";
$pgv_lang["root_person"]		= "Kök şahıs numarası";
$pgv_lang["hide_details"]		= "Detayları sakla";
$pgv_lang["show_details"]		= "Detayları göster";
$pgv_lang["person_links"]		= "Bu şahısın çizimlerine, ailesine ve yakın akrabalarına ulaşan bağlantılar. Bu simgeye tıklayıp şahıs ile ilgili sayfaları izleyin.";
$pgv_lang["zoom_box"]			= "Bu kutuyu büyüt / küçült";
$pgv_lang["orientation"]			= "Yönlendirme";
$pgv_lang["portrait"]			= "Düşey";
$pgv_lang["landscape"]			= "Yatay";
$pgv_lang["start_at_parents"]		= "Anne ve baba ile başla";
$pgv_lang["charts"]			= "Çizimler";
$pgv_lang["lists"]			= "Listeler";
$pgv_lang["welcome_page"]		= "Karşılama sayfası";
$pgv_lang["max_generation"] 		= "#PEDIGREE_GENERATIONS# Soy ağacı nesillerin en fazla sayısıdır.";
$pgv_lang["min_generation"] 		= "3 Soy ağacı nesillerin en az seçin sayısıdır.";
$pgv_lang["box_width"]			= "Kutu eni";

//-- FUNCTIONS FILE MESSAGES
$pgv_lang["unable_to_find_family"]	= "Bu numaraya bağlı aile bulunamadı";
$pgv_lang["unable_to_find_indi"]	= "Bu numaraya bağlı şahıs bulunamadı";
$pgv_lang["unable_to_find_record"]	= "Bu numaraya bağlı kayıt bulunamadı";
$pgv_lang["unable_to_find_source"]	= "Bu numaraya bağlı kaynak bulunamadı";
$pgv_lang["unable_to_find_repo"]	= "Bu numaraya bağlı veri tabanı tablosu bulunamadı";
$pgv_lang["repo_name"]			= "Veri tabanı tablosunun ismi:";
$pgv_lang["address"]			= "Adres:";
$pgv_lang["phone"]			= "Telefon:";
$pgv_lang["source_name"]		= "Kaynağın ismi:";
$pgv_lang["title"]			= "Başlık";
$pgv_lang["author"]			= "Yazar:";
$pgv_lang["publication"]		= "Yayın:";
$pgv_lang["call_number"]		= "Telefon numarası:";
$pgv_lang["living"]			= "Yaşıyor";
$pgv_lang["private"]			= "Özel";
$pgv_lang["birth"]			= "Doğum:";
$pgv_lang["death"]			= "Vefat:";
$pgv_lang["descend_chart"]		= "Şahsı İzleyen Nesiller Çizimi";
$pgv_lang["individual_list"]		= "Şahıs listesi";
$pgv_lang["family_list"]		= "Aile listesi";
$pgv_lang["source_list"]		= "Kaynak listesi";
$pgv_lang["place_list"]			= "Yer listesi";
$pgv_lang["place_list_aft"] 		= "Sonradan Hiyerarşiyi Yerleştirin";
$pgv_lang["media_list"]			= "Mültimedya listesi";
$pgv_lang["search"]			= "Arama";
$pgv_lang["search_general"]			= "Genel Arama";
$pgv_lang["chart_new"]				= "Aile Ağacı Grafiği";
$pgv_lang["loading"]				= "Yükleniyor...";
$pgv_lang["clear_chart"]			= "Grafiği Temizle";
$pgv_lang["file_information"]		= "Dosya Bilgisi";
$pgv_lang["choose_file_type"]		= "Dosya Tipini Seç";
$pgv_lang["add_individual_by_id"]		= "Bireysel Kişi ID si Ekle";
$pgv_lang["advanced_options"]		= "Gelişmiş Seçenekler";
$pgv_lang["zip_files"]				= "Zip Dosyası";
$pgv_lang["include_media"]			= "Media içine al (Zipli dosyalar otomatikman)";
$pgv_lang["clipping_privacy"]		= "Bazı maddeler gizlilik kısıtlamalarından dolayı eklenemezler";
$pgv_lang["search_soundex"]			= "Aynısını Ara";
$pgv_lang["search_replace"]			= "Ara ve eskisi ile değiştir";
$pgv_lang["search_inrecs"]			= "Aranacak";
$pgv_lang["search_fams"]			= "Aileler";
$pgv_lang["search_indis"]			= "Kişiseller";
$pgv_lang["search_sources"]			= "Kaynaklar";
$pgv_lang["search_more_chars"]      = "Lütfen bir karakterden fazla girin";
$pgv_lang["search_soundextype"]		= "Tam metin tipi:";
$pgv_lang["search_russell"]			= "Basit";
$pgv_lang["search_prtnames"]		= "Kişiseller'<br />yazdırma isimleri:";
$pgv_lang["search_prthit"]			= "Hit ile isimler";
$pgv_lang["results_per_page"]		= "Sayfadaki sonuçlar";
$pgv_lang["search_prtall"]			= "Tüm isimler";
$pgv_lang["search_tagfilter"]		= "Filtre Hariç";
$pgv_lang["search_tagfon"]			= "Buraya özel olmayan soyağacı bilgiyi hariç et";
$pgv_lang["search_tagfoff"]			= "Kapalı";
$pgv_lang["associate"]				= "birleşik";
$pgv_lang["search_record"]			= "Bütün kayıt";
$pgv_lang["search_to"]				= "den";
$pgv_lang["search_asso_label"]		= "Birleşikler";
$pgv_lang["search_asso_text"]		= "Kişiseller/Aileler ilişkili göster";
$pgv_lang["clippings_cart"]		= "Parça toplama mahfazası";
$pgv_lang["not_an_array"]		= "Dizi (array) değildir";
$pgv_lang["print_preview"]		= "Baskı ön izleme";
$pgv_lang["cancel_preview"]		= "Normal görüntüye geri dön";
$pgv_lang["change_lang"]		= "Dil seçimi";
$pgv_lang["print"]			= "Yazdır";
$pgv_lang["total_queries"]		= "Veritabanına sorma sayısı: ";
$pgv_lang["total_privacy_checks"]	= "Toplam mahremiyet denetlemeleri: ";
$pgv_lang["back"]			= "geri dön";
$pgv_lang["privacy_list_indi_error"]	= "Mahremiyet kuralları yüzünden bazı şahısların detayları gizli tutulmaktadır.";
$pgv_lang["privacy_list_fam_error"]	= "Mahremiyet kuralları yüzünden bazı ailelerin detayları gizli tutulmaktadır.";
$pgv_lang["aka"]			= "Tanındığı diğer isimler";

//-- INDIVIDUAL FILE MESSAGES
$pgv_lang["male"]			= "erkek";
$pgv_lang["female"]			= "kadın";
$pgv_lang["temple"]			= "LDS Temple";
$pgv_lang["temple_code"]		= "LDS Temple kodu:";
$pgv_lang["status"]			= "Durumu";
$pgv_lang["source"]			= "Kaynak";
$pgv_lang["citation"]			= "Bölüm:";
$pgv_lang["text"]			= "Kaynak metin:";
$pgv_lang["note"]			= "Not";
$pgv_lang["NN"]				= "Soy isimsiz";
$pgv_lang["PN"]				= "İsimsiz";
$pgv_lang["unrecognized_code"]		= "Tanınmayan GEDCOM kodu";
$pgv_lang["unrecognized_code_msg"]	= "Bu düzeltmek istediğimiz bir hatadır. Bu hatayı lütfen bu adrese bildirin:";
$pgv_lang["indi_info"]			= "Kişisel bilgi";
$pgv_lang["pedigree_chart"]		= "Soyağacı Ağaç Çizimi";
$pgv_lang["individual"]				= "Kişisel";
$pgv_lang["individual"]				= "Kişisel";
$pgv_lang["desc_chart2"]		= "Şahsı izleyen nesillerin görüntüsü";
$pgv_lang["family"]			= "Aile";
$pgv_lang["family_with"]			= "Ailesi";
$pgv_lang["as_spouse"]			= "(eş olarak) Aile tablosu";
$pgv_lang["as_child"]			= "(kardeş olarak) Aile tablosu";
$pgv_lang["view_gedcom"]		= "GEDCOM kayıdını göster";
$pgv_lang["add_to_cart"]		= "Parça toplama mahfazasına kat";
$pgv_lang["still_living_error"]		= "Bu şahıs daha yaşamaktadır veyahut doğum ya da ölüm tarihleri eksiktir.<br />Burada yaşayan şahıslar hakkında hiçbir ayrıntı gösterilmez.<br />Ayrıntılı bilgi için bu adres ile temasa geçin:";
$pgv_lang["privacy_error"]		= "Bu şahısın detayları şahsidir.<br />Ayrıntılı bilgi için bu adres ile temasa geçin:";
$pgv_lang["more_information"]		= "Ayrıntılı bilgi için danışabileceğiniz ilişki adresi:";
$pgv_lang["name"]			= "İsim";
$pgv_lang["given_name"]			= "İsim:";
$pgv_lang["surname"]			= "Soy isim:";
$pgv_lang["suffix"]			= "Ek isim:";
$pgv_lang["object_note"]		= "Nesne notu:";
$pgv_lang["sex"]			= "Cinsiyet";
$pgv_lang["personal_facts"]		= "Kişisel bilgiler ve detaylar";
$pgv_lang["type"]			= "Tip";
$pgv_lang["date"]			= "Tarih";
$pgv_lang["place_description"]		= "Yer / Tarif";
$pgv_lang["parents"]			= "Anne ve baba:";
$pgv_lang["siblings"] 			= "Kardeşleri";
$pgv_lang["father"]			= "Baba";
$pgv_lang["mother"]			= "Anne";
$pgv_lang["parent"] 				= "Ebeveyn";
$pgv_lang["relatives"]			= "Yakın akrabalar";
$pgv_lang["relatives_events"]		= "Yakın akrabaların hadiseleri";
$pgv_lang["child"]			= "Çocuk";
$pgv_lang["surnames"]			= "Soy isimleri";
$pgv_lang["adopted"]			= "Evlatlık edinme";
$pgv_lang["foster"]			= "Babalık / Analık";
$pgv_lang["sealing"]				= "Mühürle";
$pgv_lang["challenged"]				= "Meydan oku";
$pgv_lang["disproved"]				= "Doğru olmadığını kanıtla";
$pgv_lang["infant"]					= "Bebek";
$pgv_lang["stillborn"]				= "Ölü doğan";
$pgv_lang["deceased"]				= "Merhum";
$pgv_lang["link_as_child"]			= "Var olan bir aileye bu kişiyi çocuğu olarak bağla";
$pgv_lang["link_as_wife"]			= "Var olan bir aileye bu kişiyi hanımı olarak bağla";
$pgv_lang["link_as_husband"]		= "Var olan bir aileye bu kişiyi kocası olarak bağla";
$pgv_lang["link_as"]				= "Olarak şu andaki aileye bu kişiyi bağla";
$pgv_lang["no_tab1"]				= "Bu şahıs ile ilgili hiç bir hadise bulunmamaktadır.";
$pgv_lang["no_tab2"]				= "Bu şahıs ile ilgili hiç bir not bulunmamaktadır.";
$pgv_lang["no_tab3"]				= "Bu kişisel için hiç kaynak davetleri yoktur.";
$pgv_lang["no_tab4"]				= "Bu şahıs ile ilgili hiç bir mültimedya nesnesi bulunmamaktadır.";
$pgv_lang["no_tab5"]				= "Bu şahıs ile ilgili hiç bir yakın akraba bulunmamaktadır.";
$pgv_lang["no_tab6"]				= "Bu kişisele bağlı hiç araştırma kütüğü yoktur.";
$pgv_lang["spouse"]			= "Eşi";
$pgv_lang["spouses"] 				= "Eşler";

//-- FAMILY FILE MESSAGES
$pgv_lang["family_info"]		= "Aile bilgisi";
$pgv_lang["family_group_info"]		= "Aile gurubu üzerine bilgi";
$pgv_lang["husband"]			= "Koca";
$pgv_lang["wife"]			= "Hanımı";
$pgv_lang["marriage"]			= "Evlilik:";
$pgv_lang["lds_sealing"]			= "LDS Mühürle:";
$pgv_lang["marriage_license"]		= "Evlilik izini:";
$pgv_lang["media_object"]		= "Mültimedya nesnesi:";
$pgv_lang["children"]			= "Çocuklar";
$pgv_lang["no_children"]		= "Kayıt edilmiş çocuk yok";
$pgv_lang["childless_family"]		= "Bu aile çocuksuz kaldı";
$pgv_lang["number_children"]		= "Çocukların sayısı: ";
$pgv_lang["parents_timeline"]		= "Çifti zaman çizgisinde göster";

//-- CLIPPINGS FILE MESSAGES
$pgv_lang["clip_cart"]			= "Parça toplama mahfazası";
$pgv_lang["clip_explaination"]		= "Parça toplama mahfazası bu seçereden istediğiniz &quot;parçaları&quot işaretleyip sonradan işaretlediğiniz tüm parçaları özel bir GEDCOM dosyası halinde indirmeniz içindir.<br /><br />";
$pgv_lang["item_with_id"]		= "ID üzerine bilgi";
$pgv_lang["error_already"]		= "Parça toplama mahfazasının içindedir.";
$pgv_lang["which_links"]		= "Bu aile ile ilgili hangi bağlantıyı eklemek istiyorsunuz?";
$pgv_lang["just_family"]		= "Sadece bu aile kayıdını ekle.";
$pgv_lang["parents_and_family"]		= "Anne ve babayı bu aile kayıtı ile ekle.";
$pgv_lang["parents_and_child"]		= "Bu şahsı, annesini, babasını ve çocuklarını ekle.";
$pgv_lang["parents_desc"]		= "Bu şahsı, annesini, babasını ve onu izleyen tüm şahısları ekleyin.";
$pgv_lang["continue"]			= "Eklemeye devam et";
$pgv_lang["which_p_links"]		= "Bu şahısla ilgili hangi bağlantıyı eklemek istiyorsunuz?";
$pgv_lang["just_person"]		= "Bu şahsı ekle.";
$pgv_lang["person_parents_sibs"]	= "Bu şahsı, annesini, babasını ve kardeşlerini ekle.";
$pgv_lang["person_ancestors"]		= "Bu şahsı ve direk öncelerini ekle.";
$pgv_lang["person_ancestor_fams"]	= "Bu şahsı, direk öncelerini ve ailesini ekle.";
$pgv_lang["person_spouse"]		= "Bu şahsı, eşlerini ve çocuklarını ekle.";
$pgv_lang["person_desc"]		= "Bu şahsı, eşlerini ve onu izleyen tüm şahısları ekle.";
$pgv_lang["which_s_links"]			= "Bu kaynağın eklenmesi için hangı kayıda bağlansın?";
$pgv_lang["just_source"]		= "Şimdi bu kaynağı ekle.";
$pgv_lang["linked_source"]		= "Bu kaynağı ekle ve kişi/aileleri ona bağlanır.";
$pgv_lang["unable_to_open"]		= "Parça toplama mahfazası yazmak için açılamadı.";
$pgv_lang["person_living"]		= "Bu şahıs daha yaşamaktadır veyahut şahısın doğum ya da ölüm tarihleri eksiktir.<br />Burada yaşayan şahıslar hakkında hiçbir ayrıntı gösterilmez.";
$pgv_lang["person_private"]		= "Bu şahısın detayları şahsidir. Kişisel detaylar eklenmeyecektir.";
$pgv_lang["family_private"]		= "Bu ailenin detayları şahsidir. Kişisel detaylar eklenmeyecektir.";
$pgv_lang["download"]			= "Yeni yaratılmış GEDCOM dosyasını yerel bilgisayarınıza indirebilmek için aşağıdaki bağlantıya farenin sağ tuşu ile basıp (MAC te Control-Click) \"Hedefi Farklı Kaydet...\" emrini seçin.";
$pgv_lang["media_files"]		= "Medya dosyaları ile ilişkide bulunan GEDCOM";
$pgv_lang["cart_is_empty"]		= "Parça toplama mahfazasınız boştur.";
$pgv_lang["id"]				= "ID";
$pgv_lang["name_description"]		= "İsim / Tarif";
$pgv_lang["remove"]			= "Kaldır";
$pgv_lang["empty_cart"]			= "Parça toplama mahfazasının boşalt";
$pgv_lang["download_now"]		= "Şimdi indir";
$pgv_lang["download_file"]			= "Dosya indir #GLOBALS[whichFile]#";
$pgv_lang["indi_downloaded_from"]	= "Şahısın bilgileri buradan indirildi:";
$pgv_lang["family_downloaded_from"]	= "Ailenin bilgileri buradan indirildi:";
$pgv_lang["source_downloaded_from"]	= "Kaynağın bilgileri buradan indirildi:";

//-- PLACELIST FILE MESSAGES
$pgv_lang["connections"]		= "Yer bağlantısı bulundu<br />Şimdi sonuçlara bak";
$pgv_lang["top_level"]			= "geri dön";
$pgv_lang["form"]			= "Yerlerin sıralanma şekli:";
$pgv_lang["default_form"]		= "Kasaba, İlçe, İl, Ülke";
$pgv_lang["default_form_info"]		= "(Varsayılan / Default)";
$pgv_lang["gedcom_form_info"]		= "(GEDCOM)";
$pgv_lang["unknown"]			= "Bilinmeyen";
$pgv_lang["individuals"]		= "Şahıslar";
$pgv_lang["view_records_in_place"]	= "Bu yer ile ilgili tüm kayıtları göster";
$pgv_lang["place_list2"]		= "Yer listesi";
$pgv_lang["show_place_hierarchy"]	= "Hiyerarşide Yerleştirileni Göster";
$pgv_lang["show_place_list"]		= "Tüm yerleri tek liste halinde göster";
$pgv_lang["total_unic_places"]		= "Toplam Tek Yerleşenler";

//-- MEDIALIST FILE MESSAGES
$pgv_lang["multi_title"]		= "Mültimedya nesne listesi";
$pgv_lang["media_found"]		= "mültimedya nesnesi bulundu";
$pgv_lang["view_person"]		= "Şahsı göster";
$pgv_lang["view_family"]		= "Aileyi göster";
$pgv_lang["view_source"]		= "Kaynağı göster";
$pgv_lang["view_object"]			= "Nesneyi Görüntüle";
$pgv_lang["prev"]			= "&lt; bir sayfa geri dön";
$pgv_lang["next"]			= "bir sayfa ilerle &gt;";
$pgv_lang["next_image"]				= "Sonraki Resim";
$pgv_lang["file_not_found"]		= "Dosya bulunamadı";
$pgv_lang["medialist_show"] 		= "Göster";
$pgv_lang["per_page"]			= "sayfadaki nesne sayısı";
$pgv_lang["delete_directory"]		= "Dızını sil";
$pgv_lang["remove_object"]			= "Nesneyi kaldır";
$pgv_lang["confirm_remove_object"]	= "Databaseden bu nesneyi kaldırmak istediğinizden eminmisiniz?";
$pgv_lang["remove_links"]			= "Bağlantıları kaldır";
$pgv_lang["confirm_remove_links"]	= "Bu nesneye bağlı tüm bağlantıları kaldırmak istediğinizden eminmisiniz?";
$pgv_lang["delete_file"]			= "Dosyayı sil";
$pgv_lang["confirm_delete_file"]	= "Bu dosyayı silmek istediğinizden eminmisiniz?";
$pgv_lang["multiple_gedcoms"]		= "Bu dosya bu serverden başka soyağacı veritabanına bağlanılır. Bu bağlantılar kaldırılanakadar taşınmış veya adlandıralan silinemez.";
$pgv_lang["directory_not_empty"]	= "Dızın boş.";
$pgv_lang["directory_not_exist"]	= "Dızın yok.";
$pgv_lang["media_not_deleted"]		= "Media dızın yok kaldırıldı.";
$pgv_lang["media_deleted"]			= "Media dızın başarılı biçimde kaldırıldı.";
$pgv_lang["thumbs_not_deleted"]		= "Tırnak önizleme dızın yok kaldırıldı.";
$pgv_lang["thumbs_deleted"]			= "Tırnak önizleme dızın başarılı biçimde kaldırıldı.";
$pgv_lang["delete_dir_success"]		= "Media ve tırnak önizleme dızınleri başarılı biçimde kaldırıldı.";
$pgv_lang["current_dir"]			= "Geçerli dızın";
$pgv_lang["SHOW_ID_NUMBERS"]		= "Üyelerin GEDCOM Numaraları Göster";
$pgv_lang["SHOW_HIGHLIGHT_IMAGES"]	= "Kutularda Üyelerin Resimlerini Göster";
$pgv_lang["view_img_details"]		= "Resim detaylarını görüntüle";
$pgv_lang["external_file"]			= "Bu medya nesnesi bu serverd dosya olarak yok. Nesne taşınmı, yeniden adlandırılmış veya silinmiş olabilir.";

//-- SEARCH FILE MESSAGES
$pgv_lang["search_gedcom"]		= "GEDCOM dosyası içinde arama";
$pgv_lang["enter_terms"]		= "Aranacak Terim";
$pgv_lang["soundex_search"]		= "- Ya da isimin yazıldığını düşündüğünüz şekilde arayın (Tam metin):";
$pgv_lang["sources"]			= "Kaynaklar";
$pgv_lang["firstname_search"]		= "İsim";
$pgv_lang["lastname_search"]		= "Soy isim";
$pgv_lang["search_place"]		= "Yer";
$pgv_lang["search_year"]		= "Sene";
$pgv_lang["no_results"]			= "Hiçbir sonuç bulunmadı.";
$pgv_lang["invalid_search_input"]	= "Lütfen sene ile beraber bir isim, soy isim ya da bir yerin ismini ekleyin";
$pgv_lang["search_options"]			= "Arama seçenekleri";
$pgv_lang["search_geds"]			= "GEDCOM larin içinde ara";
$pgv_lang["search_type"]			= "Arama tipi";

//-- SOURCELIST FILE MESSAGES
$pgv_lang["sources_found"]		= "Kaynak bulundu";
$pgv_lang["titles_found"]			= "Başlıklar";
$pgv_lang["find_source"]			= "Kaynak Bul";

//-- REPOLIST FILE MESSAGES
$pgv_lang["repo_list"]			= "Veri havuzu listesi";
$pgv_lang["repos_found"]		= "Veri havuzları bulundu";
$pgv_lang["find_repository"]		= "Veri Tabanı Tablosunu Bul";
$pgv_lang["total_repositories"]		= "Toplam Veri Havuzları";
$pgv_lang["repo_info"]				= "Veri Tabanı Tablı Bilgisi";
$pgv_lang["delete_repo"]			= "Veri Tabanı Tablosu Sil";
$pgv_lang["other_repo_records"]		= "Bu veri tabanı tablo link kayıtları:";
$pgv_lang["create_repository"]		= "Veri Tabanı Tablo Oluştur";
$pgv_lang["new_repo_created"]		= "Yeni Veri Tabanı Tablo Oluşturuldu";
$pgv_lang["paste_rid_into_field"]	= "Bu saklama yerine referans göstermek için baskıya hazırlama alanlarınıza takip eden saklama yeri kimlik bilgisini yapıştırın";
$pgv_lang["confirm_delete_repo"]	= "Databaseden bu veri tabanı tablosunu silmek istediğinizden emin misini?";


//-- SOURCE FILE MESSAGES
$pgv_lang["source_info"]		= "Kaynak bilgisi";
$pgv_lang["other_records"]		= "Bu kaynakla ilişkide olan diğer kayıtlar:";
$pgv_lang["people"]			= "Şahıslar";
$pgv_lang["families"]			= "Aileler";
$pgv_lang["total_sources"]		= "Toplam kaynak sayısı";

//-- BUILDINDEX FILE MESSAGES
$pgv_lang["building_indi"]		= "Şahıs ve aile indeksini geliştiriyorum";
$pgv_lang["building_index"]		= "İndeks listelerini geliştiriyorum";
$pgv_lang["invalid_gedformat"]		= "Hatalı GEDCOM 5.5 biçimi";
$pgv_lang["importing_records"]		= "Kayıtları veritabanına işliyorum";
$pgv_lang["detected_change"]		= "PhpGedView \$GEDCOM isimli GEDCOM dosyasının değiştiğini fark etti. Devam etmeden önce indeks dosyalarının yenilenmesi lazım.";
$pgv_lang["please_be_patient"]		= "LÜTFEN BİRAZ SABIRLI OLUN";
$pgv_lang["reading_file"]		= "GEDCOM dosyası okunuyor";
$pgv_lang["flushing"]			= "İçerikleri siliyorum";
$pgv_lang["found_record"]		= "Bulunan kayıt";
$pgv_lang["exec_time"]			= "Toplam işletim süresi:";
$pgv_lang["time_limit"]				= "Zaman Kotası:";
$pgv_lang["unable_to_create_index"]	= "İndeks dosyasını yenileyemedim. PhpGedView dizinine yazma izninizin olup olmadığını denetleyin. İzinler indeks dosyalarının yaratılmasından sonra eski duruma geri getirilebilinir.";
$pgv_lang["indi_complete"]		= "Şahısların indeks dosyası yenilendi.";
$pgv_lang["family_complete"]		= "Ailelerin indeks dosyası yenilendi.";
$pgv_lang["source_complete"]		= "Kaynakların indeks dosyası yenilendi.";
$pgv_lang["tables_exist"]		= "PhpGedView tabloları veri tabanında vardı";
$pgv_lang["you_may"]			= "Seçenekleriniz:";
$pgv_lang["drop_tables"]		= "Aktüel sql-table ları silin";
$pgv_lang["import_multiple"]		= "Çeşitli GEDCOM-Dosyalarını ithal edip devam edin";
$pgv_lang["path_to_gedcom"]		= "GEDCOM-Dosyanızın yerini belirleyin:";
$pgv_lang["dataset_exists"]		= "Veri tabanına bu isim altında başka bir GEDCOM-Dosyası ithal edilmiştir.";
$pgv_lang["empty_dataset"]		= "Veri kümesini hakikatten silmek istiyor musunuz?";
$pgv_lang["index_complete"]		= "İndeks tamamlandı.";
$pgv_lang["click_here_to_go_to_pedigree_tree"]	= "Soyağacı Ağaç Çizim tablosuna ulaşmak için buraya tıklayın";
$pgv_lang["import_complete"]		= "İçerik aktarımı tamamlandı";
$pgv_lang["updating_family_names"]	= "Aile soy isimleri FAM için güncelleştiriliyor ";
$pgv_lang["processed_for"]			= "için dosyayı işleme tabi tut ";
$pgv_lang["run_tools"]				= "İthal edilmeden önce GEDCOM unuzda takip araçların birini yükseltmek istermisiniz:";
$pgv_lang["addmedia"]			= "Medya ekleme aracı";
$pgv_lang["dateconvert"]		= "Tarihleri dönüştürme aracı";
$pgv_lang["xreftorin"]			= "XREF İD'lerini RİN numarasına dönüştür";
$pgv_lang["tools_readme"]		= "Ayrıntılı bilgi için #README.TXT# dosyasının \"tools\" bölümünü okuyun.";
$pgv_lang["sec"]			= "saniye";
$pgv_lang["bytes_read"]			= "Okunan byte miktarı:";
$pgv_lang["created_remotelinks"]	= "Başarılı biçimde <i>Başka sitedeki bağlantılar</i> tablo oluşturuldu.";
$pgv_lang["created_remotelinks_fail"] 	= "<i>Başka sitedeki bağlantılar</i> tablosu oluşturamaz.";
$pgv_lang["created_indis"]			= "Başarılı biçimde <i>Bireyseller</i> tablo oluşturuldu.";
$pgv_lang["created_indis_fail"] 	= "<i>Bireyseller</i> tablo oluşturma başarısız.";
$pgv_lang["created_fams"]			= "Başarılı biçimde <i>Aileler</i> tablosu oluşturuldu.";
$pgv_lang["created_fams_fail"]		= "<i>Aileler</i> tablosu oluşturma başarısız.";
$pgv_lang["created_sources"]		= "Başarılı biçimde <i>Kaynaklar</i> tablosu oluşturuldu.";
$pgv_lang["created_sources_fail"]	= "<i>Kaynaklar</i> tablosu oluşturma başarısız.";
$pgv_lang["created_other"]			= "Başarılı biçimde <i>Diğer</i> tablo oluşturuldu.";
$pgv_lang["created_other_fail"] 	= "<i>Diğer</i> tablo oluşturma başarısız.";
$pgv_lang["created_places"] 		= "Başarılı biçimde <i>Alanlar</i> tablosu oluşturuldu.";
$pgv_lang["created_places_fail"]	= "<i>Alanlar</i> tablosu oluşturma başarısız.";
$pgv_lang["created_placelinks"] 	= "Başarılı biçimde <i>Yer bağlantılar</i> tablosu oluşturuldu.";
$pgv_lang["created_placelinks_fail"]	= "<i>Yer bağlantılar</i> tablosu oluşturulamaz.";
$pgv_lang["created_media_fail"]	= "<i>Media</i> tablosu oluşturalamadı.";
$pgv_lang["import_progress"]		= "İthal gelişimi...";

//-- INDIVIDUAL AND FAMILYLIST FILE MESSAGES
$pgv_lang["total_fams"]			= "Toplam aile sayısı";
$pgv_lang["total_indis"]		= "Toplam şahıs sayısı";
$pgv_lang["starts_with"]		= "Bununla başla:";
$pgv_lang["person_list"]		= "Şahıs listesi:";
$pgv_lang["paste_person"]		= "Şahsı ekle";
$pgv_lang["notes_sources_media"]	= "Notlar, Kaynaklar, Medya-Dosyaları";
$pgv_lang["notes"]			= "Notlar";
$pgv_lang["ssourcess"]			= "Kaynaklar";
$pgv_lang["media"]			= "Mültimedya";
$pgv_lang["name_contains"]		= "İsim içeriği:";
$pgv_lang["filter"]			= "Filtre";
$pgv_lang["find_sourceid"]		= "Kaynak no'sunu ara";
$pgv_lang["find_specialchar"]		= "Özel Karakterleri Bul";
$pgv_lang["magnify"]				= "Büyüt";
$pgv_lang["find_individual"]		= "Şahıs arama listesi";
$pgv_lang["find_familyid"]		= "Aile numarasını ara";
$pgv_lang["skip_surnames"]		= "Soy isimleri atlayarak listele";
$pgv_lang["show_surnames"]		= "Soy isim listesini göster";
$pgv_lang["all"]			= "HEPSİ";
$pgv_lang["hidden"]			= "Saklı";
$pgv_lang["confidential"]		= "Özel";
$pgv_lang["alpha_index"]				= "Alfabetik İndex";
$pgv_lang["name_list"] 				= "İsim Listesi";
$pgv_lang["firstname_alpha_index"] 	= "İlk Ad Alfabetik İndex";
$pgv_lang["roots"]		 				= "Kökler";
$pgv_lang["leaves"] 					= "Ayrılmalar";
$pgv_lang["widow"] 					= "Dul kadın";
$pgv_lang["widower"] 				= "Dul erkek";

//-- TIMELINE FILE MESSAGES
$pgv_lang["age"]			= "Yaş";
$pgv_lang["days"]					= "Gün";
$pgv_lang["months"]					= "Aylık";
$pgv_lang["years"]					= "Yıl";
$pgv_lang["day1"]					= "Gün";
$pgv_lang["month1"]					= "Ay";
$pgv_lang["year1"]					= "Yıl";
$pgv_lang["timeline_title"]		= "PhpGedView zaman çizgisi";
$pgv_lang["timeline_chart"]		= "Zaman içinde çizim";
$pgv_lang["remove_person"]		= "Şahsı sil";
$pgv_lang["show_age"]			= "Yaşını göster";
$pgv_lang["add_another"]		= "Yeni bir şahsı çizime ekle:<br />Şahıs numarası:";
$pgv_lang["find_id"]			= "Numarayı ara";
$pgv_lang["show"]			= "Göster";
$pgv_lang["year"]			= "Sene:";
$pgv_lang["timeline_instructions"]	= "Yeni tarayıcıların çoğunda tıklayarak veyahut kutuları çekerek görüntünün bir yerinden diğerine yerleştirebilirsiniz.";
$pgv_lang["zoom_out"]			= "Görüntüyü küçült";
$pgv_lang["timeline_beginYear"] = "Başlama Yaşı";
$pgv_lang["timeline_endYear"] = "Bitirme Yaşı";
$pgv_lang["timeline_scrollSpeed"] = "Hız";
$pgv_lang["timeline_controls"] = "Zaman yolu Kontrolleri";
$pgv_lang["include_family"] = "Acil Aileyi İçer";
$pgv_lang["lifespan_chart"] = "Ömür Çizimi";
$pgv_lang["cal_none"]                 = "Takvim dönüştürme hayır";
$pgv_lang["cal_french"]               = "Fransız";
$pgv_lang["cal_arabic"]               = "Arap";
$pgv_lang["zoom_in"]			= "Görüntüyü büyüt";

//-- MONTH NAMES
$pgv_lang["jan"]			= "Ocak";
$pgv_lang["feb"]			= "Şubat";
$pgv_lang["mar"]			= "Mart";
$pgv_lang["apr"]			= "Nisan";
$pgv_lang["may"]			= "Mayıs";
$pgv_lang["jun"]			= "Haziran";
$pgv_lang["jul"]			= "Temmuz";
$pgv_lang["aug"]			= "Ağustos";
$pgv_lang["sep"]			= "Eylül";
$pgv_lang["oct"]			= "Ekim";
$pgv_lang["nov"]			= "Kasım";
$pgv_lang["dec"]			= "Aralık";
$pgv_lang["safar"]        = "Safari";
$pgv_lang["ramad"]        = "Ramazan";
$pgv_lang["abt"]			= "civarında";
$pgv_lang["aft"]			= "'#EXT# sonra";
$pgv_lang["and"]			= "ve";
$pgv_lang["bef"]			= "'#EXT# önce";
$pgv_lang["bet"]			= "arasında";
$pgv_lang["cal"]			= "hesaplandı";
$pgv_lang["est"]			= "varsayım";
$pgv_lang["from"]			= "'#EXT#";
$pgv_lang["int"]			= "herhalde";
$pgv_lang["to"]				= "'#EXT# kadar";
$pgv_lang["apx"]			= "takriben";
$pgv_lang["cir"]			= "dolaylarında";

//-- Admin File Messages
$pgv_lang["configuration"]		= "Genel ayarlar";
$pgv_lang["rebuild_indexes"]		= "İndeks dosyalarını yenile";
$pgv_lang["user_admin"]			= "Kullanıcı Yönetimi";
$pgv_lang["user_created"]		= "Üye başarıyla eklendi.";
$pgv_lang["user_create_error"]		= "Üye eklenemedi. Lütfen bir sayfa geri dönüp tekrar deneyin.";
$pgv_lang["select_an_option"]		= "Aşağıdaki seçeneklerden birini seçin:";
$pgv_lang["readme_documentation"]	= "Beni oku dokümanı";
$pgv_lang["view_readme"]			= "readme.txt dosyası görüntüle";
$pgv_lang["password_mismatch"]		= "Şifreler birbirine uymuyor.";
$pgv_lang["enter_username"]		= "Üyenin rumuzunu işlemeniz gerekiyor.";
$pgv_lang["enter_fullname"]		= "Üyenin komple ismini işlemeniz gerekiyor.";
$pgv_lang["enter_password"]		= "Üyenin şifresini işlemeniz gerekiyor.";
$pgv_lang["confirm_password"]		= "Şifreyi tekrarlamanız lazım";
$pgv_lang["update_user"]		= "Üye verilerini güncelleştir";
$pgv_lang["update_myaccount"]		= "Benim üyelik verilerimi güncelleştir";
$pgv_lang["save"]			= "Hafıza et";
$pgv_lang["delete"]			= "Sil";
$pgv_lang["edit"]			= "İşle";
$pgv_lang["full_name"]			= "Komple isim";
$pgv_lang["visibleonline"]		= "Siteye bağlantılı iken diğer üyeler sizi görsünmü";
$pgv_lang["comment"]				= "Yönetici kullanıcıya yorumları";
$pgv_lang["comment_exp"]			= "Yöneticiyi uyaracak tarih";
$pgv_lang["editaccount"]		= "Bu üyeye kendi üyelik verilerini işleme hakkı ver";
$pgv_lang["admin_gedcom"]		= "GEDCOM ayarlarını düzenle";
$pgv_lang["confirm_user_delete"]	= "Üyeyi hakikatten silmek mi istiyorsunuz";
$pgv_lang["create_user"]		= "Yeni üye yarat";
$pgv_lang["no_login"]			= "İlettiğiniz rumuz ya da şifre tasdik edilemedi :-(";
$pgv_lang["basic_realm"]			= "PhpGedView Kanıtlama Sistemi";
$pgv_lang["basic_auth_failure"]		= "Bir geçerli giriş ID bilgisi ve bu kaynağa erişmek için parolaya girmelisiniz";
$pgv_lang["basic_auth"]				= "Temel Kanıtlama";
$pgv_lang["digest_auth"]				= "Kanıtlamayı Kabullen";
$pgv_lang["no_auth_needed"]			= "Kanıtlama yok";
$pgv_lang["import_gedcom"]		= "Bu GEDCOM dosyasını ithal et";
$pgv_lang["duplicate_username"]		= "Çifte rumuz. Siteye bu rumuz ile başka bir üye kayıtlıdır. Lütfen geri dönüp başka bir rumuz seçiniz.";
$pgv_lang["cache_life"]				= "Yaşam dosya cache";
$pgv_lang["genealogy"]					= "soyağacı";
$pgv_lang["activate"]					= "Aktif";
$pgv_lang["deactivate"]					= "Aktif değil";
$pgv_lang["play"]					= "Yürüt";
$pgv_lang["stop"]					= "Dur";
$pgv_lang["random_media_start_slide"]	= "Slayt gösteri sayfasını başlat?";
$pgv_lang["random_media_ajax_controls"]	= "Slayt gösteri gösterme kontrolleri?";
$pgv_lang["gedcomid"]			= "Şahsın GEDCOM kayıt numarası";
$pgv_lang["enter_gedcomid"]		= "GEDCOM kayıt numarasını işlemeniz gerekiyor.";
$pgv_lang["upload_gedcom"]		= "GEDCOM dosyasını yolla";
$pgv_lang["add_new_gedcom"]		= "Yeni bir GEDCOM yarat";
$pgv_lang["user_info"]			= "Kişisel sayfam";
$pgv_lang["rootid"]			= "Soyağacının kök şahsı";
$pgv_lang["download_gedcom"]		= "GEDCOM dosyasını indir";
$pgv_lang["manage_gedcoms"]		= "GEDCOM - Veritabanı ayarları";
$pgv_lang["research_assistant"]		= "Yardımcıyı Araştır";
$pgv_lang["research_log"]			= "Kütüğü Araştır";
$pgv_lang["gedcom_file"]		= "GEDCOM dosyası";
$pgv_lang["enter_filename"]		= "GEDCOM dosyasının ismini işlemeniz gerekiyor.";
$pgv_lang["file_not_exists"]		= "İşlediğiniz isimli dosya yoktur.";
$pgv_lang["file_not_present"]		= "Dosya yok";
$pgv_lang["file_exists"]		= "Bu isim altında başka bir GEDCOM bulunmuştur. Lütfen başka bir isim seçin ya da eski dosyayı önce silin.";
$pgv_lang["new_gedcom_title"]		= "[#GEDCOMFILE#] dosyasından alınan seçere ile ilgili veri";
$pgv_lang["upload_error"]		= "Dosyayı yollarken bir hata oldu.";
$pgv_lang["upload_media_help"]		= "~#pgv_lang[upload_media]#~<br /><br />Serverinize yüklemek için yerel bilgisayarınızdan dosyaları seçin. Dızın <b>#MEDIA_DIRECTORY#</b> ya da onun alt dizininin birisine tüm dosya yüklenecek..<br /><br />Sizin belirttiğiniz dosya adlar #MEDIA_DIRECTORY# ilave edilecekler. örneğin #MEDIA_DIRECTORY#benimailem.Tırnak önizleme dızın var olmazsa otomatik olarak oluşturulacak.";
$pgv_lang["upload_gedcom_help"]		= "Serverinize yüklemek için yerel bilgisayarınızdan GEDCOM ya da ZIP dosyayı seçin. Dosya dızın <b>#INDEX_DIRECTORY#</b> yüklenecek.<br /><br />Bir ZIP dosyayı yüklerseniz tek bir GEDCOM içermeli ve sonraki adımda o GEDCOM otomatik olarak kullanılmış olacak.<br /><br />";
$pgv_lang["upload_help"]		= "Yerel bilgisayarınızdan sunucuya yollamak için bir dosya seçin. Tüm dosyalar dizine yollanılacaktır.";
$pgv_lang["add_gedcom_instructions"]	= "Bu yeni GEDCOM için bir dosya ismini işleyin. Yeni GEDCOM dosyası indeks dizininde yaratılacaktır.";
$pgv_lang["file_partial"]		= "Dosya tamamen yollanamadı. Lütfen tekrar deneyin";
$pgv_lang["file_missing"]		= "Dosya buraya ulaşmadı. Tekrar yollayın.";
$pgv_lang["file_success"]		= "Dosya başarı ile yollandı.";
$pgv_lang["file_too_big"]		= "Yollanılan dosya izin verilen büyüklüğü geçiyor.";
$pgv_lang["user_manual"]		= "PhpGedView - Kullanıcı belgelemesi";
$pgv_lang["upgrade"]			= "PhpGedView yazılımını güncelleştir";
$pgv_lang["administration"]		= "İdare / Ayarlar";
$pgv_lang["ansi_to_utf8"]		= "ANSİ ile kodlanmısş bu GEDCOM veritabanı UTF-8'e dönüştürülsün mü?";
$pgv_lang["utf8_to_ansi"]		= "UTF-8 ile kodlanmısş bu GEDCOM veritabanı ANSİ'ye (ISO-8859-1) dönüştürülsün mü?";
$pgv_lang["visitor"]				= "Ziyaretçi";
$pgv_lang["user"]					= "Kullanıcıyı kanıtla";
$pgv_lang["gedadmin"]				= "GEDCOM yönetici";
$pgv_lang["siteadmin"]				= "Site yönetici";
$pgv_lang["apply_privacy"]			= "Gizlilik ayarları uygula?";
$pgv_lang["choose_priv"]			= "Gizlilik düzeyi seç:";
$pgv_lang["view_logs"]			= "Sistemin günlük raporuna bak";
$pgv_lang["logfile_content"]		= "Sistemin günlük raporunun içeriği. Günlük dosyasının isimi:";
$pgv_lang["step1"]			= "4 adımdan 1'incisi:";
$pgv_lang["step2"]			= "4 adımdan 2'ncisi:";
$pgv_lang["step3"]			= "4 adımdan 3'üncüsü:";
$pgv_lang["step4"]			= "4 adımdan 4'üncüsü:";
$pgv_lang["validate_gedcom"]		= "GEDCOM veritabanının geçerliğini denetle";
$pgv_lang["img_admin_settings"] 	= "Resim İşletme Konfigürasyonunu Düzenle";
$pgv_lang["pgv_registry"]		= "PhpGedView kullanan diğer sitelerin listesi";
$pgv_lang["verify_upload_instructions"]	= "Aynı isimli GEDCOM dosyası bulundu. Eğer devam etmeyi seçersenin eski GEDCOM dosyanın üzerine yeni içeri aktarım yüklediğiniz dosyadaki bilgiler geçerli olacak ve geri donuşu olmayacak. Eğer iptal seçerseniz eski GEDCOM dosyanız değiştirilmemiş olacaktır.";
$pgv_lang["cancel_upload"]		= "Yollamayı iptal et";
$pgv_lang["add_media_records"]		= "Media Kayıtları Ekle";
$pgv_lang["manage_media_files"]		= "Mültimedya dosyalarını yönet";
$pgv_lang["link_media_records"]		= "Bireylerin Media Link";

//-- Relationship chart messages
$pgv_lang["relationship_chart"]		= "Akrabalık çizimi";
$pgv_lang["person1"]			= "1. şahıs";
$pgv_lang["person2"]			= "2. şahıs";
$pgv_lang["no_link_found"]		= "İki şahıs arasında hiç bir bağlantı bulunamadı";
$pgv_lang["sibling"]			= "Kardeş";
$pgv_lang["follow_spouse"]		= "Evlilik ile gelişen akrabalılığı araştır";
$pgv_lang["timeout_error"]		= "Bu \"script\" hiçbir akrabalık bağlantısı bulamadan sona erdi!!!";
$pgv_lang["son"]			= "Erkek çocuk";
$pgv_lang["daughter"]			= "Kız çocuk";
$pgv_lang["son-in-law"]				= "Damadı";
$pgv_lang["daughter-in-law"]		= "Gelini";
$pgv_lang["grandchild"]				= "Torun";
$pgv_lang["grandson"]				= "Erkek torun";
$pgv_lang["granddaughter"]			= "Kız torun";
$pgv_lang["brother"]			= "Erkek kardeş";
$pgv_lang["sister"]			= "Kız kardeş";
$pgv_lang["brother-in-law"]		= "Kanun içinde erken kardeş";
$pgv_lang["sister-in-law"]			= "Kardeş eşi (yenge)";
$pgv_lang["aunt"]					= "Teyze";
$pgv_lang["uncle"]				= "Amca";
$pgv_lang["firstcousin"]			= "İlk kuzen";
$pgv_lang["femalecousin"]			= "Kadın kuzen";
$pgv_lang["malecousin"]				= "Erkek kuzen";
$pgv_lang["cousin-in-law"]			= "Kuzen eşi";
$pgv_lang["relationship_to_me"]		= "Benimle olan akrabalığı";
$pgv_lang["rela_husb"]				= "Kocaya ilişki";
$pgv_lang["rela_wife"]				= "Karıya ilişki";
$pgv_lang["next_path"]				= "Diğer seçeneği bul";
$pgv_lang["show_path"]				= "Diğer Seçenek";
$pgv_lang["line_up_generations"]	= "Ayni kuşaktan olan şahısları bir seviyede göster";
$pgv_lang["oldest_top"]			= "En yaşlıları üstte göster";
$pgv_lang["relationship_male_1_is_the_2_of_3"] = "%3\$s 'in %2\$s 'i   %1\$s";
$pgv_lang["relationship_female_1_is_the_2_of_3"] = "%3\$s 'in %2\$s 'i   %1\$s";
$pgv_lang["mother_in_law"]		    = "kaynana";
$pgv_lang["father_in_law"]		    = "kayınpeder";
$pgv_lang["brother_in_law"]		    = "enişte";
$pgv_lang["sister_in_law"]		    = "yenge";
$pgv_lang["son_in_law"]		        = "damat";
$pgv_lang["daughter_in_law"]		= "gelin";
$pgv_lang["step_son"]		        = "üvey oğul";
$pgv_lang["step_daughter"]	    	= "üvey kız";
$pgv_lang["bosa_brothers_offspring_2"] 				= "erkek yeğen";
$pgv_lang["bosa_brothers_offspring_3"] 				= "kız yeğen";
$pgv_lang["bosa_brothers_offspring_4"] 				= "büyük erkek yeğen";
$pgv_lang["bosa_brothers_offspring_5"] 				= "büyük kız yeğen";
$pgv_lang["bosa_brothers_offspring_6"] 				= "büyük erkek yeğen";
$pgv_lang["bosa_brothers_offspring_7"] 				= "büyük kız yeğen";
$pgv_lang["n_x_brothers_son"]	  = "%2\$d x büyük erkek yeğen";
$pgv_lang["n_x_brothers_daughter"] = "%2\$d x büyük kız yeğen";
$pgv_lang["bosa_sisters_offspring_2"] 				= "erkek yeğen";
$pgv_lang["bosa_sisters_offspring_3"] 				= "kız yeğen";
$pgv_lang["bosa_sisters_offspring_4"] 				= "büyük erkek yeğen";
$pgv_lang["bosa_sisters_offspring_5"] 				= "büyük kız yeğen";
$pgv_lang["bosa_sisters_offspring_6"] 				= "büyük erkek yeğen";
$pgv_lang["bosa_sisters_offspring_7"] 				= "büyük kız yeğen";
$pgv_lang["n_x_sisters_son"]	  = "%2\$d x büyük erkek yeğen";
$pgv_lang["n_x_sisters_daughter"] = "%2\$d x büyük kız yeğen";
$pgv_lang["bosa_2"] 				= "erkek çocuk";
$pgv_lang["bosa_3"] 				= "kız çocuk";
$pgv_lang["bosa_4"] 				= "erkek torun";
$pgv_lang["bosa_5"] 				= "kız torun";
$pgv_lang["bosa_6"] 				= "erkek torun";
$pgv_lang["bosa_7"] 				= "kız torun";
$pgv_lang["bosa_8"] 				= "büyük erkek torun";
$pgv_lang["bosa_9"] 				= "büyük kız torun";
$pgv_lang["bosa_10"] 				= "büyük erkek torun";
$pgv_lang["bosa_11"] 				= "büyük kız torun";
$pgv_lang["bosa_12"] 				= "büyük erkek torun";
$pgv_lang["bosa_13"] 				= "büyük kız torun";
$pgv_lang["bosa_14"] 				= "büyük erkek torun";
$pgv_lang["bosa_15"] 				= "büyük kız torun";
$pgv_lang["n_x_grandson_from_son"]	  = "%3\$d x büyük erkek torun";
$pgv_lang["n_x_granddaughter_from_son"] = "%3\$d x büyük kız torun";
$pgv_lang["n_x_grandson_from_daughter"]	  = "%3\$d x büyük erkek torun";
$pgv_lang["n_x_granddaughter_from_daughter"] = "%3\$d x büyük kız torun";
$pgv_lang["sosa_uncle_2"] 				= "amca";
$pgv_lang["sosa_uncle_3"] 				= "amca";
$pgv_lang["sosa_uncle_4"] 				= "büyük amca";
$pgv_lang["sosa_uncle_5"] 				= "büyük amca";
$pgv_lang["sosa_uncle_6"] 				= "büyük amca";
$pgv_lang["sosa_uncle_7"] 				= "büyük amca";
$pgv_lang["n_x_paternal_uncle"]		= "%2\$d x büyük amca";
$pgv_lang["n_x_maternal_uncle"]	    = "%2\$d x büyük amca";
$pgv_lang["sosa_aunt_2"] 				= "teyze";
$pgv_lang["sosa_aunt_3"] 				= "teyze";
$pgv_lang["sosa_aunt_4"] 				= "büyük teyze";
$pgv_lang["sosa_aunt_5"] 				= "büyük teyze";
$pgv_lang["sosa_aunt_6"] 				= "büyük teyze";
$pgv_lang["sosa_aunt_7"] 				= "büyük teyze";
$pgv_lang["n_x_paternal_aunt"]		= "%2\$d x büyük teyze";
$pgv_lang["n_x_maternal_aunt"]	    = "%2\$d x büyük teyze";
$pgv_lang["sosa_uncle_bm_2"] 				= "amca";
$pgv_lang["sosa_uncle_bm_3"] 				= "amca";
$pgv_lang["sosa_uncle_bm_4"] 				= "büyük amca";
$pgv_lang["sosa_uncle_bm_5"] 				= "büyük amca";
$pgv_lang["sosa_uncle_bm_6"] 				= "büyük amca";
$pgv_lang["sosa_uncle_bm_7"] 				= "büyük amca";
$pgv_lang["n_x_paternal_uncle_bm"]		= "%2\$d x büyük amca";
$pgv_lang["n_x_maternal_uncle_bm"]	    = "%2\$d x büyük amca";
$pgv_lang["sosa_aunt_bm_2"] 				= "teyze";
$pgv_lang["sosa_aunt_bm_3"] 				= "teyze";
$pgv_lang["sosa_aunt_bm_4"] 				= "büyük teyze";
$pgv_lang["sosa_aunt_bm_5"] 				= "büyük teyze";
$pgv_lang["sosa_aunt_bm_6"] 				= "büyük teyze";
$pgv_lang["sosa_aunt_bm_7"] 				= "büyük teyze";
$pgv_lang["n_x_paternal_aunt_bm"]		= "%2\$d x büyük teyze";
$pgv_lang["n_x_maternal_aunt_bm"]	    = "%2\$d x büyük teyze";
$pgv_lang["male_cousin_1"]              = "ilk kuzen";
$pgv_lang["male_cousin_2"]              = "ikinci kuzen";
$pgv_lang["male_cousin_3"]              = "üçüncü kuzen";
$pgv_lang["male_cousin_4"]              = "dördüncü kuzen";
$pgv_lang["male_cousin_5"]              = "beşinci kuzen";
$pgv_lang["male_cousin_6"]              = "altıncı kuzen";
$pgv_lang["male_cousin_7"]              = "yedinci kuzen";
$pgv_lang["male_cousin_8"]              = "sekizinci kuzen";
$pgv_lang["male_cousin_9"]              = "dokuzuncu kuzen";
$pgv_lang["male_cousin_10"]             = "onuncu kuzen";
$pgv_lang["male_cousin_11"]             = "onbirinci kuzen";
$pgv_lang["male_cousin_12"]             = "onikinci kuzen";
$pgv_lang["male_cousin_13"]             = "onüçüncü kuzen";
$pgv_lang["male_cousin_14"]             = "ondördüncü kuzen";
$pgv_lang["male_cousin_15"]             = "onbeşinci kuzen";
$pgv_lang["male_cousin_16"]             = "onaltıncı kuzen";
$pgv_lang["male_cousin_17"]             = "onyedinci kuzen";
$pgv_lang["male_cousin_18"]             = "onsekizinci kuzen";
$pgv_lang["male_cousin_19"]             = "ondokuzuncu kuzen";
$pgv_lang["male_cousin_20"]             = "yirminci kuzen";
$pgv_lang["male_cousin_n"]              = "%d x kuzen";
$pgv_lang["female_cousin_1"]            = "ilk kuzen";
$pgv_lang["female_cousin_20"]           = "yirminci kuzen";
$pgv_lang["female_cousin_n"]            = "%d x kuzen";
$pgv_lang["removed_ascending_1"]   = "birkez yeniden-eskiye kaldırıldı";
$pgv_lang["removed_ascending_2"]   = "ikikez yeniden-eskiye kaldırıldı";
$pgv_lang["removed_ascending_3"]   = "üç zaman yeniden-eskiye kaldırıldı";
$pgv_lang["removed_ascending_4"]   = "dört zaman yeniden-eskiye kaldırıldı";
$pgv_lang["removed_ascending_5"]   = "beş zaman yeniden-eskiye kaldırıldı";
$pgv_lang["removed_ascending_6"]   = "alti zaman yeniden-eskiye kaldırıldı";
$pgv_lang["removed_ascending_7"]   = "yedi zaman yeniden-eskiye kaldırıldı";
$pgv_lang["removed_ascending_8"]   = "sekiz zaman yeniden-eskiye kaldırıldı";
$pgv_lang["removed_ascending_9"]   = "dokuz zaman yeniden-eskiye kaldırıldı";
$pgv_lang["removed_ascending_10"]  = "on zaman yeniden-eskiye kaldırıldı";
$pgv_lang["removed_ascending_11"]  = "onbir zaman yeniden-eskiye kaldırıldı";
$pgv_lang["removed_ascending_12"]  = "oniki zaman yeniden-eskiye kaldırıldı";
$pgv_lang["removed_ascending_13"]  = "onüç zaman yeniden-eskiye kaldırıldı";
$pgv_lang["removed_ascending_14"]  = "ondört zaman yeniden-eskiye kaldırıldı";
$pgv_lang["removed_ascending_15"]  = "onbeş zaman yeniden-eskiye kaldırıldı";
$pgv_lang["removed_ascending_16"]  = "onalti zaman yeniden-eskiye kaldırıldı";
$pgv_lang["removed_ascending_17"]  = "onyedi zaman yeniden-eskiye kaldırıldı";
$pgv_lang["removed_ascending_18"]  = "onsekiz zaman yeniden-eskiye kaldırıldı";
$pgv_lang["removed_ascending_19"]  = "ondokuz zaman yeniden-eskiye kaldırıldı";
$pgv_lang["removed_ascending_20"]  = "yirmi zaman yeniden-eskiye kaldırıldı";
$pgv_lang["removed_descending_1"]  = "birkere eskiden-yeniye kaldırıldı";
$pgv_lang["removed_descending_2"]  = "ikikere eskiden-yeniye kaldırıldı";
$pgv_lang["removed_descending_3"]  = "üç zaman eskiden-yeniye kaldırıldı";
$pgv_lang["removed_descending_4"]  = "dört zaman eskiden-yeniye kaldırıldı";
$pgv_lang["removed_descending_5"]  = "beş zaman eskiden-yeniye kaldırıldı";
$pgv_lang["removed_descending_6"]  = "alti zaman eskiden-yeniye kaldırıldı";
$pgv_lang["removed_descending_7"]  = "yedi zaman eskiden-yeniye kaldırıldı";
$pgv_lang["removed_descending_8"]  = "sekiz zaman eskiden-yeniye kaldırıldı";
$pgv_lang["removed_descending_9"]  = "dokuz zaman eskiden-yeniye kaldırıldı";
$pgv_lang["removed_descending_10"] = "on zaman eskiden-yeniye kaldırıldı";
$pgv_lang["removed_descending_11"] = "onbir zaman eskiden-yeniye kaldırıldı";
$pgv_lang["removed_descending_12"] = "oniki zaman eskiden-yeniye kaldırıldı";
$pgv_lang["removed_descending_13"] = "onüç zaman eskiden-yeniye kaldırıldı";
$pgv_lang["removed_descending_14"] = "ondört zaman eskiden-yeniye kaldırıldı";
$pgv_lang["removed_descending_15"] = "onbeş zaman eskiden-yeniye kaldırıldı";
$pgv_lang["removed_descending_16"] = "onalti zaman eskiden-yeniye kaldırıldı";
$pgv_lang["removed_descending_17"] = "onyedi zaman eskiden-yeniye kaldırıldı";
$pgv_lang["removed_descending_18"] = "onsekiz zaman eskiden-yeniye kaldırıldı";
$pgv_lang["removed_descending_19"] = "ondokuz zaman eskiden-yeniye kaldırıldı";
$pgv_lang["removed_descending_20"] = "yirmi zaman eskiden-yeniye kaldırıldı";
$pgv_lang["female_cousin_19"]           = "ondokuzuncu kuzen";
$pgv_lang["female_cousin_18"]           = "onsekizinci kuzen";
$pgv_lang["female_cousin_17"]           = "onyedinci kuzen";
$pgv_lang["female_cousin_16"]           = "onaltıncı kuzen";
$pgv_lang["female_cousin_15"]           = "onbeşinci kuzen";
$pgv_lang["female_cousin_14"]           = "ondördüncü kuzen";
$pgv_lang["female_cousin_13"]           = "onüçüncü kuzen";
$pgv_lang["female_cousin_12"]           = "onikinci kuzen";
$pgv_lang["female_cousin_11"]           = "onbirinci kuzen";
$pgv_lang["female_cousin_10"]           = "onuncu kuzen";
$pgv_lang["female_cousin_9"]            = "dokuzuncu kuzen";
$pgv_lang["female_cousin_8"]            = "sekizinci kuzen";
$pgv_lang["female_cousin_7"]            = "yedinci kuzen";
$pgv_lang["female_cousin_6"]            = "altıncı kuzen";
$pgv_lang["female_cousin_5"]            = "beşinci kuzen";
$pgv_lang["female_cousin_4"]            = "dördüncü kuzen";
$pgv_lang["female_cousin_3"]            = "üçüncü kuzen";
$pgv_lang["female_cousin_2"]            = "ikinci kuzen";

//-- gedcom edit utility
$pgv_lang["check_delete"]		= "Bu GEDCOM hadisesini gerçekten silmek istiyor musunuz?";
$pgv_lang["access_denied"]			= "Bu kaynağa erişemezsiniz. <br /><b>Erişim Reddedildi</b>";
$pgv_lang["gedrec_deleted"] 		= "GEDCOM kayıtı başarı ile silindi.";
$pgv_lang["gedcom_deleted"] 		= "[#GED#] isimli GEDCOM veritabanı başarı ile silindi.";
$pgv_lang["changes_exist"]		= "Bu GEDCOM dosyasında değişiklikler yapılmıştır";
$pgv_lang["accept_changes"]		= "Veritabanındaki değişiklikleri kabul/ret et";
$pgv_lang["show_changes"]		= "Bu kayıt güncelleştirilmiştir. Buraya tıklayıp değişiklikleri gözden geçirin.";
$pgv_lang["hide_changes"]		= "Buraya tıklayıp değişiklikleri saklayın.";
$pgv_lang["review_changes"]		= "GEDCOM içindeki değişiklikleri göster";
$pgv_lang["undo_successful"]		= "Değişiklikler geri alındı";
$pgv_lang["undo"]			= "Geri al";
$pgv_lang["view_change_diff"]		= "Değiştirilen Dosyayı Görütüle";
$pgv_lang["changes_occurred"]		= "Bu şahısın hakkında yapılan değişiklikler";
$pgv_lang["place_contains"]		= "Yerin içeriği:";
$pgv_lang["accept_gedcom"]			= "Her bir değişikliği kabul etmek veya red etmek için karar ver.<br /><br /><br /><br />Değişikliklerin tümünü bir kerede katdetmek için aşağıdaki <b>\"Tüm değişiklikleri kabul et\"</b> linkini kullana bilirsiniz ve bilgi alabilirsiniz.<br /><br /><br />Değişiklikler hakkında daha çok bilgi almak için,<br /><br /><b>\"Değiştirilen Dosyayı Görüntüle\"</b> linkini tıkla,<br />veya yeni kayıtları görmek için <b>\"GEDCOM kayıdını göster\"</b> linkini tıklayın.";
$pgv_lang["ged_import"]			= "İçeri aktarımı (import)";
$pgv_lang["now_import"]			= "Şimdi GEDCOM kayıtlarını aşağıdaki \"İçeri aktarımı (import)\" bağlantısına tıklayarak PhpGedView içine ithal etmeniz gerekiyor.";
$pgv_lang["find_place"]			= "Yer ara";
$pgv_lang["refresh"]				= "Yenile";
$pgv_lang["close_window"]		= "Pencereyi kapat";
$pgv_lang["close_window_without_refresh"]	= "Pencereyi tazelemeden kapat";
$pgv_lang["add_fact"]			= "Yeni hadise ekle";
$pgv_lang["add"]			= "Ekle";
$pgv_lang["add_new_husb"]		= "Yeni bir erkek eş ekle";
$pgv_lang["edit_name"]			= "İsmini işle";
$pgv_lang["add_wife"]			= "Bayan eş ekle";
$pgv_lang["add_new_wife"]		= "Yeni bir bayan eş ekle";
$pgv_lang["add_wife_to_family"]		= "Bu aileye bayan eş ekle";
$pgv_lang["find_family"]		= "Aile ara";
$pgv_lang["find_fam_list"]		= "Aile arama listesi";
$pgv_lang["custom_event"]		= "Kişisel hadise";
$pgv_lang["update_successful"]		= "Güncelleştirme başarılıydı";
$pgv_lang["add_child"]			= "Çocuk ekle";
$pgv_lang["delete_name"]		= "İsmini sil";
$pgv_lang["no_temple"]				= "Tapınak Hayır - Yaşam Emir";
$pgv_lang["replace"]			= "Kayıtı değiştir";
$pgv_lang["append"] 			= "Kayıtı ekle";
$pgv_lang["add_father"]			= "Yeni bir baba ekle";
$pgv_lang["add_mother"]			= "Yeni bir anne ekle";
$pgv_lang["add_obje"]			= "Yeni mültimedya nesnesini ekle";
$pgv_lang["no_changes"]			= "Aktüel olarak yapılmış hiç bir değişiklik yoktur.";
$pgv_lang["accept"]			= "Kabul et";
$pgv_lang["accept_all"] 		= "Tüm değişiklikleri kabul et";
$pgv_lang["accept_successful"]		= "Değişiklikler başarı ile veritabanına işlenmiştir";
$pgv_lang["edit_raw"]			= "Sade GEDCOM kayıdını düzenle";
$pgv_lang["select_date"]		= "Bir tarih seçiniz";
$pgv_lang["create_source"]		= "Yeni kaynak ekle";
$pgv_lang["new_source_created"] 	= "Yeni kaynak başarı ile eklenmiştir.";
$pgv_lang["add_name"]			= "Yeni isim ekle";
$pgv_lang["privacy_not_granted"]	= "Hiç erişime sahip olamazsınız";
$pgv_lang["user_cannot_edit"]		= "Bu rumuzlu üye bu GEDCOM veritabanını düzenleyemez.";
$pgv_lang["ged_noshow"]				= "Bu sayfa yönetici tarafından devre dışı birakıldı.";
$pgv_lang["gedcom_editing_disabled"]	= "Bu GEDCOM veritabanının düzenlenmesi sistem yöneticisi tarafından engellenmiştir.";
$pgv_lang["privacy_prevented_editing"]	= "Mahremiyet ayarları bu kayıtı düzenlemenizi engellemektedir.";
$pgv_lang["add_asso"]				= "Yeni bir ilişki / eş ekle";
$pgv_lang["edit_sex"]				= "Cinsiyet Düzenle";
$pgv_lang["bdm"]					= "Doğumlar, Ölümler, Evlilikler";
$pgv_lang["delete_source"]		= "Bu kaynağı sil";
$pgv_lang["confirm_delete_source"]	= "Bu kaynağı hakikatten GEDCOM dosyasından silmek istiyor musunuz?";
$pgv_lang["add_husb"]			= "Erkek eş ekle";
$pgv_lang["add_husb_to_family"]		= "Bu aileye erkek eş ekle";
$pgv_lang["add_child_to_family"]	= "Bu aileye bir çocuk ekle";
$pgv_lang["add_sibling"]		= "Erkek ya da kız kardeş ekle";
$pgv_lang["add_son_daughter"]		= "Erkek ya da kız çocuk ekle";
$pgv_lang["must_provide"]			= "Temin etmelisiniz bir";
$pgv_lang["delete_person"]		= "Bu şahsı sil";
$pgv_lang["confirm_delete_person"]	= "Bu şahsı hakikatten GEDCOM dosyasından silmek istiyor musunuz?";
$pgv_lang["find_media"]			= "Mültimedya dosyalarını ara";
$pgv_lang["set_link"]			= "Bağlantı ekle";
$pgv_lang["add_source_lbl"]		= "Kaynak alıntısını ekle";
$pgv_lang["add_note"]			= "Hadiseye not ekle";
$pgv_lang["add_media_lbl"]		= "Mültimedya nesnesini ekle";
$pgv_lang["add_media"]			= "Yeni mültimedya nesnesini ekle";
$pgv_lang["add_source"]			= "Hadiseye yeni bir kaynak alıntısını ekle";
$pgv_lang["add_note_lbl"]		= "Not ekle";

$pgv_lang["in_this_month"]		= "Bu Ay içinde...";
$pgv_lang["in_this_year"]		= "Bu sene içinde - Sizin tarihinizde...";

//-- calendar.php messages
$pgv_lang["on_this_day"]		= "Bugünkü hadiseler...";
$pgv_lang["year_anniversary"]		= "#year_var#. yıl dönümü";
$pgv_lang["today"]			= "Bugün";
$pgv_lang["day"]			= "Gün:";
$pgv_lang["month"]			= "Ay:";
$pgv_lang["showcal"]			= "Gösterilen:";
$pgv_lang["anniversary"]			= "Yıldönümü";
$pgv_lang["anniversary_calendar"]	= "Yıldönümü takvimi";
$pgv_lang["sunday"]			= "Pazar";
$pgv_lang["monday"]			= "Pazartesi";
$pgv_lang["tuesday"]			= "Salı";
$pgv_lang["wednesday"]			= "Çarşamba";
$pgv_lang["thursday"]			= "Perşembe";
$pgv_lang["living_only"]		= "Yaşayan şahısları";
$pgv_lang["recent_events"]		= "Güncel hadiseler (< 100 sene)";
$pgv_lang["day_not_set"]			= "Gün kurulu değil";
$pgv_lang["year_error"]			= "Üzgünüz, ama 1970'ten önce olan bir tarih desteklenmiyor.";
$pgv_lang["all_people"]			= "Tüm şahıslar";
$pgv_lang["friday"]			= "Cuma";
$pgv_lang["saturday"]			= "Cumartesi";
$pgv_lang["lost_password"]		= "Şifrenizi unuttunuz mu?";
$pgv_lang["viewday"]			= "Günü göster";
$pgv_lang["viewmonth"]			= "Ayı göster";
$pgv_lang["viewyear"]			= "Seneyi göster";
$pgv_lang["min6chars"]			= "Şifre en azından 6 harf ya da sayı uzunluğunda olmalıdır";
$pgv_lang["pls_note03"]			= "Bu E-posta adresi üyeliğinizin canlandırılmasından önce tasdik edilecektir. Bu adres yöneticiden başka kimseye gösterilmeyecektir. Bu adres üzerinden size üyelik hesabınızın içeriklerini gösteren bir mektup gönderilecektir. Bu mektup sayesinde üyelik hesabınızı tasdik edebileceksiniz.";
$pgv_lang["pls_note02"]			= "Lütfen dikkat edin: Şifrenizde sırf alfabenin büyük / küçük harflerini ya da sayıları kullanın. Eğer şifrenizin içinde diğer özel harfleri kullanacak olursanız başka bir sistemden giriş yapmak isterken zorluklarla karşılaşabilirsiniz.";

//-- upload media messages
$pgv_lang["media_file"]			= "Medya dosyası";
$pgv_lang["upload_media"]		= "Medya dosyalarını yolla";
$pgv_lang["folder"]		 			= "Serverdeki dızın";
$pgv_lang["thumbnail"]			= "Tırnak resim";
$pgv_lang["upload_successful"]		= "Yollama başarılı idi";
$pgv_lang["media_file_deleted"]		= "Media dosya başarılı biçimde silindi.";
$pgv_lang["media_file_not_deleted"]	= "Media dosyası silemez.";
$pgv_lang["media_file_not_moved"]	= "Media dosyası taşıyamaz.";
$pgv_lang["media_file_not_renamed"]	= "Media dosyası taşıyamaz veya adlandıramaz.";
$pgv_lang["thumbnail_deleted"]		= "Tırnak önizleme dosya başarılı biçimde silindi.";
$pgv_lang["thumbnail_not_deleted"]	= "Tırnak önizleme dosya silemez.";
$pgv_lang["media_record_deleted"]	= "Media #xref# kaydetti ve bağlantıları veri tabanından başarılı biçimde silindi.";
$pgv_lang["media_record_not_deleted"]	= "Media #xref# kaydetme ve bağlantıları veri tabanından silemez. ";
$pgv_lang["record_updated"]			= "#pid# kayıt başarılı biçimde güncellendi.";
$pgv_lang["record_not_updated"]		= "#pid# kayıdı güncelleyemez.";
$pgv_lang["record_removed"]			= "#xref# kayıdı GEDCOM dan başarılı biçimde kaldırıldı.";
$pgv_lang["record_not_removed"]		= "#xref# kayıdı GEDCOM dan taşıyamaz.";
$pgv_lang["record_added"]			= "#xref# kayıdı GEDCOM a başarılı biçimde eklendi.";
$pgv_lang["record_not_added"]		= "#xref# kayıdı GEDCOM a ekleyemez.";

//-- user self registration module
$pgv_lang["requestpassword"]		= "Şifremi unuttum. Yeni şifre istiyorum";
$pgv_lang["no_account_yet"]		= "Üye değil misiniz?";
$pgv_lang["requestaccount"]		= "Üye olmak istiyorum";
$pgv_lang["register_info_01"]		= "Bu sitenin sırf ziyaretçisi olarak veritabanındaki tüm kayıtları görebilme olanağınız yoktur.<br /><br />Bu ayarlar siteye eklenmiş yaşayan şahısların kişisel detaylarını korumak için yapılmıştır.<br />Eğer sizin kişisel detaylarınız bu sitenin veritabanına eklenmiş olsa, siz de tanımadığınız kişilerin sizinle ilgili tüm bilgileri görebilme olanağına sahip olmalarını istemezsiniz.<br /><br />Bunun için burada siteye üye olup, verilerinizin sitenin yöneticileri tarafından tasdik edilmesinden sonra yaşayan şahısların siteye eklenen kişisel detaylarını görme olanağına kavuşabilirsiniz. Eğer bu site akrabalık denetimini kullanıyorsa siteye üye olduktan sonra bile ancak yakın akrabalarınızın detaylarını görebilirsiniz.<br />Üye olduktan sonra sitenin yöneticileri size bu detayları görme hakkı dışında bunları işleme ve yeni bilgi ekleme hakkını da verebilirler.<br /><br />Üyelik isteminde bulunmadan önce lütfen bu sitede gördüğünüz şahıslarla akrabalık bağınızın bulunup bulunmadığını araştırın. Bunu sitedeki arama fonksiyonu sayesinde soy isimlerini ya da sizin akrabalarınızın yaşadığı şehirleri arayarak öğrenebilirsiniz.<br /><br />Eğer akrabalık bağınız yok ya da belli değilse detayları görebilme olanağı verilmeyeceği için boşuna üyelik için başvurmayın...<br />Eğer emin değilseniz önce bu sayfanın alt tarafında bulunan bağlantıyı tıklayın ve sitenin yöneticilerine E-posta yazıp bunlara danışın!<br /><br />";
$pgv_lang["pls_note01"]			= "Lütfen dikkat edin: Sistem büyük ve küçük harf arasında ayırt ediyor";
$pgv_lang["pls_note04"]			= "* ile işaretlenmiş alanlara içerik eklenmesi şarttır";
$pgv_lang["pls_note05"]			= "İstenen tüm verilerinizi doldurduktan ve sistemin bunları denetlemesinden sonra, iletmiş olduğunuz E-posta adresine bir tasdik mektubu gönderilecektir. Bu mektubun içindeki bilgilerle üyelik hesabınızı tasdik etmeniz gerekir. Eğer bu tasdik işlemini tamamlamazsanız üyelik hesabınız bu günden bir hafta sonra otomatik olarak silinecektir (bu silinme işleminden sonra tekrar istediğiniz rumuzu (username) kullanarak üyelik için başvurabilirsiniz). Bu siteye girmek için rumuzunuzu ve şifrenizi unutmamanız gerekir. Lütfen geçerli bir E-posta adresini iletmeye dikkat edin. Aksi taktirde tasdik mektubu elinize geçmez.<br /><br />Üyelik işleminde hata veyahut sorunlarla karşılaşırsanız yardım için lütfen bu sitenin webmasterine danışınız.";
$pgv_lang["emailadress"]		= "E-posta adresi";
$pgv_lang["mandatory"] 			= "* İşaretli alanların doldurulması zorunludur.";
$pgv_lang["savedata"]			= "Değişiklikleri hafıza et";
$pgv_lang["datachanged"]		= "Üyenin verileri değiştirilmiştir!";
$pgv_lang["datachanged_name"]		= "Yeni rumuzunuz ile tekrar giriş yapmak zorunda kalabilirsiniz.";
$pgv_lang["myuserdata"]			= "Şahsi ayarlar";
$pgv_lang["verified"]			= "Üye kendini tasdik etti";
$pgv_lang["verified_by_admin"]		= "Yönetici üyeyi tasdik etti";
$pgv_lang["user_theme"]			= "Şahsi tema";
$pgv_lang["mgv"]			= "Şahsi SoyGörüntüleme";
$pgv_lang["editowndata"]		= "Şahsi ayarlar";
$pgv_lang["mail01_line01"]		= "Merhaba: #user_fullname# ...";
$pgv_lang["mail01_line02"]		= "( #SERVER_NAME# ) sitesinde sizin E-posta adresiniz ( #user_email# ) ile üyelik isteminde bulunulmuştur.";
$pgv_lang["mail01_line03"]		= "Aşağıda gösterilen veriler iletilmiştir.";
$pgv_lang["mail01_line04"]		= "Üyelik işlemini tamamlamak için lütfen aşağıdaki bağlantıyı tıklayarak açılacak sayfada rumuzunuzu, şifrenizi ve tasdik kodunuzu işleyiniz.";
$pgv_lang["mail01_line05"]		= "Eğer siz bu üyelik isteminde bulunmadıysanız bu mektubu silip unutabilirsiniz.";
$pgv_lang["mail01_line06"]		= "Üyelik verileri başvurudan bir hafta sonra otomatik olarak silineceği için, size bu siteden bir daha mektup gönderilmeyecektir.";
$pgv_lang["mail01_subject"]		= "#SERVER_NAME# sitesine kayıdınız";
$pgv_lang["hashcode"]			= "Tasdik kodunuz:";
$pgv_lang["thankyou"]			= "Merhaba #user_fullname# ...<br />Üyelik isteminde bulunduğunuz için teşekkür ederiz.";
$pgv_lang["pls_note06"]			= "Şimdi işlediğiniz E-posta adresine (#user_email#) tasdik mektubu gönderilecektir. Bu mektubun içindeki verileri kullanıp önümüzdeki 7 gün içersinde verilerinizi tasdik etmeniz gerekiyor. Aksi taktirde verileriniz otomatik olarak silinecektir (bu silinme işleminden sonra tekrar istediğiniz rumuzu (username) kullanarak üyelik için başvurabilirsiniz). Bu siteye girmek için rumuzunuzu ve şifrenizi unutmamanız gerekir.";
$pgv_lang["registernew"]		= "Yeni üyelik tasdiki";
$pgv_lang["user_verify"]		= "Üyelik tasdiki";
$pgv_lang["mail02_line01"]		= "Merhaba Yönetici ...";
$pgv_lang["mail02_line02"]		= "Yeni bir ziyaretçi ( #SERVER_NAME# ) sitesinde üyelik isteminde bulunmuştur.";
$pgv_lang["mail02_line03"]		= "Bu üyeye üyelik işlemini tamamlaması için gerekli bilgiler gönderilmiştir.";
$pgv_lang["mail02_line04"]		= "Üye kendisini tasdik ettikten sonra onun sitenize giriş yapabilmesi için izin vermeniz gerektiğinden bir mesaj ile bilgilendirileceksiniz.";
$pgv_lang["mail02_line04a"]			= "Bu gelecekteki kullanıcı kendisini doğruladığı zaman elektronik postayla haberdar edileceksiniz. <br />Sağlamadan sonra kullanıcı   bölümünüzdeki aksiyon olmaksızın giriş.";
$pgv_lang["mail02_subject"]		= "#SERVER_NAME# sitesinde yeni üyelik istemi";
$pgv_lang["date_created"]		= "Gönderiliş tarihi:";
$pgv_lang["message_from"]		= "Mesajı gönderen:";
$pgv_lang["message_from_name"]		= "İsminiz:";
$pgv_lang["message_to"]			= "Mesaj gönderilen rumuz:";
$pgv_lang["message_subject"]		= "Mesaj konusu:";
$pgv_lang["message_body"]		= "Mesaj içeriği:";
$pgv_lang["no_to_user"] 		= "Alıcı üye işlenmemiştir. Devam edemem.";
$pgv_lang["provide_email"]			= "Bu mesajınıza cevap alabilmeniz için lütfen email adresinizi girin. Email adresinizi girmezseniz sorunuza cevap veremeyiz. Email adresiniz herhangibir yerde veya başka türlü amaçlarda kullanılmayacaktır. Email adresiniz sadece bu sorunuza cevap vermek için kullanılacaktır.";
$pgv_lang["message_sent"]		= "Mesaj gönderildi";
$pgv_lang["reset"]			= "Sıfırla - İlk duruma getir";
$pgv_lang["site_default"]		= "Sitenin standardı";
$pgv_lang["invalid_email"]		= "Lütfen geçerli bir E-posta adresi ekleyiniz";
$pgv_lang["enter_subject"]		= "Lütfen mesajın konusunu ekleyin";
$pgv_lang["enter_body"]			= "Lütfen gönderilmeden mesaja birkaç satır ekleyin ;-)";
$pgv_lang["confirm_message_delete"]	= "Bu mesajı gerçekten silmek mi istiyorsunuz? Bu silme emri ileride geri alınamaz.";
$pgv_lang["message_email1"]		= "Aşağıdaki mesajı sizin PhpGedView üye hesabınıza gönderen: ";
$pgv_lang["message_email2"]		= "Aşağıdaki mesajı bir PhpGedView üye hesabına gönderdiniz:";
$pgv_lang["message_email3"]		= "Aşağıdaki mesajı bir PhpGedView yöneticisine (administrator) gönderdiniz:";
$pgv_lang["viewing_url"]		= "Bu mesaj yandaki URL okunurken yollandı:";
$pgv_lang["messaging2_help"]		= "Bu mesajın bir kopyası belirlediğiniz E-posta adresinize gönderilecektir.";
$pgv_lang["mygedview_desc"]		= "Sizin Benim GedView Anasayfam alanında kısa yoldan devamlı görmek istediğiniz kişileri Sık Kullanılanlara ekleyerek gelecek yıl dönümlerini kaçırmayacaksınız  yada incelemek istediğinizde arama yapmadan kısa yoldan görüntüleyebilirsiniz, Günlüğünüze istediğiniz hadiseleri kaydedebilir bu vesile ile unutmak istemediğiniz notları yazabilirsiniz Günlüğünüzü sizden başka yönetici dahil hiç kimse göremez, Bu anasayfada diğer kayıtlı üyelerin gelecek yıldönümleri yada diğer üyelerden PhpGedView üzerinden size gönderilen mesajları okuyabilir yada diğer kayıtlı üyelere PhpGedView üzerinden mesajlaşma imkanı bulacaksınız. Ayrıca sağda ...Benim GedView Anasayfamı özelleştir... linki tıklatıp Benim GedView Anasayfamda görmek istediğiniz modülleri yükleyin Benim GedView Anasayfanızı zenginleştirebilirsiniz ve dahası.";
$pgv_lang["no_messages"]		= "Okunmamış mesajınız yoktur.";
$pgv_lang["clicking_ok"]		= "OK kelimesini tıklarsanız açılacak pencerede #user[fullname]# ile ilişkiye geçebilirsiniz.";
$pgv_lang["favorites"]				= "Favorileriniz";
$pgv_lang["my_favorites"]		= "Sık kullanılanlar";
$pgv_lang["no_favorites"]		= "Daha hiçbir şahsı \"Sık kullanılanlar\" bölümünüze eklemediniz. \"Sık kullanılanlar\" bölümünüze bir şahsı eklemeniz için ekleyeceğiniz şahısın ayrıntılarını bulup \"Sık kullanılanlarıma ekle\" bağına tıklayın veyahut aşağıdaki kutunun içinde eklemek istediğiniz şahısın \"GEDCOM-Kişisel numarasını\" işleyin.";
$pgv_lang["add_to_my_favorites"]	= "\"Sık kullanılanlarıma\" ekle";
$pgv_lang["gedcom_favorites"]		= "Bu GEDCOM veritabanının \"Sık kullanılanları\"";
$pgv_lang["no_gedcom_favorites"]	= "\"Sık kullanılanlar\" bölümüne daha ekleme yapılmamıştır. Buraya ancak sitenin yöneticisi ekleme yapabilir.";
$pgv_lang["confirm_fav_remove"]		= "Bu şahsı hakikatten \"Sık kullanılanlarınızdan\" silmek istiyor musunuz?";
$pgv_lang["message_deleted"]		= "Mesaj silindi";
$pgv_lang["message"]			= "Mesaj gönder";
$pgv_lang["my_messages"]		= "Kişisel mesajlar";
$pgv_lang["send"]			= "Gönder";
$pgv_lang["pls_note07"]			= "Lütfen üyelik isteminizin tamamlanması ve tasdik edilmesi için, size bu siteden gönderiliş olan mektup ile elinize geçen rumuzunuzu, şifrenizi ve tasdik kodunuzu işleyin.";
$pgv_lang["pls_note08"]			= "#user_name# rumuzlu üyenin verileri gözden geçirildi.";
$pgv_lang["mail03_line01"]		= "Merhaba Yönetici ...";
$pgv_lang["mail03_line02"]		= "#newuser[username]# ( #newuser[fullname]# ) kendisine gönderilen tasdik kodu ile verilerini tasdik etmiştir.";
$pgv_lang["mail03_line03"]		= "Lütfen aşağıdaki bağlantıyı tıklayıp sitenize giriş yapın, üyenin verilerini işleyip tasdik edin ve sitenize girmesine izin verin.";
$pgv_lang["mail03_subject"]		= "#SERVER_NAME# sitesinde yeni tasdik";
$pgv_lang["pls_note09"]			= "Üye olarak tasdik edildiniz.";
$pgv_lang["pls_note10"]			= "Yöneticiye haber verilmiştir.<br />O sizin hesabınızı açıp siteye girmenize izin verdikten sonra rumuzunuz ve şifreniz ile siteye giriş yapabilirsiniz.";
$pgv_lang["pls_note10a"]			= "Şimdi giriş yapabilmek için kullanıcı adınız ve şifreniz";
$pgv_lang["data_incorrect"]		= "Verileriniz yanlıştır.<br />Lütfen tekrarlayınız!";
$pgv_lang["user_not_found"]		= "Sistem işlediğiniz verileri tasdik edememiştir. Lütfen bir sayfa geri gidip tekrar deneyiniz.";
$pgv_lang["lost_pw_reset"]		= "Yeni şifre istek sayfası";
$pgv_lang["pls_note11"]			= "Size yeni bir şifre yollanmasını istiyorsaniz, üyelik hesabınızın rumuzunu ve E-posta adresini işleyin.<br /><br />Bundan sonra biz size E-posta yolu ile hesabınızı onaylayıcı bilgi içeren özel bir URL yollayacağız.<br />Yollanan bu URL adresini ziyaret ettiğinizde bu siteye giriş için gerekli olan şifrenizi değiştirmenize izin verilecektir.<br />Güvenlik nedenleri yüzünden bu özel URL adresini (bu sitenin yöneticileri dahil) kimseye göstermemeniz rica olunur.<br />Biz zaten böyle bir istekte bulunmayız...<br /><br />Bu sitenin yöneticisi tarafından yardıma ihtiyacınız varsa lütfen direk ona danışın.";
$pgv_lang["enter_email"]		= "E-posta adresinizi eklemeniz gerekiyor";
$pgv_lang["mail04_line01"]		= "Merhaba #user_fullname# ...";
$pgv_lang["mail04_line02"]		= "Rumuzunuz için yeni bir şifre istenmiştir!";
$pgv_lang["mail04_line03"]		= "Tavsiye:";
$pgv_lang["mail04_line04"]		= "Lütfen şimdi aşağıdaki bağlantıyı tıklayıp yeni şifreniz ile giriş yapın ve sonra şifrenizi güvenlik nedenleri yüzünden tekrar değiştirin.";
$pgv_lang["mail04_line05"]			= "Soyağacı websitesine giriş yaptıktan sonra '#pgv_lang[mygedview]#' nden '#pgv_lang[myuserdata]#' linkini tıklatın açılan sayfada '#pgv_lang[label_password_id]# ve #pgv_lang[confirm]#' her iki alanını yeni aynı şifrenizi girerek aşağıdaki '#pgv_lang[update_myaccount]#' butonunu tıklamanız yeterli olacaktır.";
$pgv_lang["mail04_subject"] 		= "#SERVER_NAME# deki veriyi talep etmek";
$pgv_lang["pwreqinfo"]				= "Merhaba...<br /><br />Yeni şifreniz (#user[email]#) rumuz adınıza kayıtlı email adresinize gönderilmiştir.<br /><br />Lütfen email hesabinizi kontrol edin; Mesajımızı yakın zamanda almalızınız.<br /><br />Tavsiye:<br />Siz yeni şifrenizle bu siteye giriş yaptıktan sonra en kısa zamanda güvenliğinizi sürdürmek için şifrenizi değiştirmelisiniz.";
$pgv_lang["mygedview"]			= "Benim GedView Anasayfam";
$pgv_lang["passwordlength"]		= "Şifre en azından 6 harf ya da sayı uzunluğunda olmalıdır";
$pgv_lang["admin_approved"]		= "#SERVER_NAME# sitesindeki üyeliğiniz yönetici tarafından tasdik edilmiştir.";
$pgv_lang["you_may_login"]		= "Şimdi isterseniz aşağıdaki bağlantıya giderek PhpGedView sitesine girebilirsiniz...";
$pgv_lang["welcome_text_auth_mode_3"]	= "<center><b>Bu soy ağacı websitesine hoş geldiniz</b></center><br />Bu siteye giriş sadece <u>aile üyelerine</u> giriş izni verilir.<br /><br />If you have a user account you can login on this page. If you don't have a user account, you can apply for one by clicking on the appropriate link below.<br /><br />After verifying the information you provide, the administrator will either approve or decline your request for an account. You will receive an email when your request is approved.";
$pgv_lang["welcome_text_auth_mode_1"]	= "<center><b>Bu soy ağacı web siyesine hoş geldiniz</b></center><br /> permitted to every visitor who has a user account.<br /><br />If you have a user account, you can login on this page. If you don't have a user account, you can apply for one by clicking on the appropriate link below.<br /><br />After verifying your application, the site administrator will activate your account. You will receive an email when your application has been approved.";
$pgv_lang["welcome_text_cust_head"] 	= "<center><b>Soy Ağacı Websitesine Hoş Geldiniz</b></center><br />Erişim, Bu website için kayıtlı kullanıcı adı ve şifresi olan kullanıcılara giriş inzi verilir.<br />";
$pgv_lang["acceptable_use"]			= "<div class=\"largeError\">ÖNEMLİ LÜTFEN ÜYE OLMADAN ÖNCE OKUYUN: </div><div class=\"error\">Burası Rize / Ardeşen / Gündoğan (muttafi) köyün GENÇ(GENCALOĞLU) sülalesine ait özel soyağacıdır lütfen siz muttafi köyün GENÇ(GENCALOĞLU) sülalesine mensup değilseniz üye olmayınız.<ul><li>Muttafi köyün GENÇ(GENCALOĞLU) sülalesine mensup iseniz lütfen üye olun çok eskiden göç etmiş olabilirsiniz soyunuz muttafi deki GENÇ(GENCALOĞLU) sülalesine dayanıyorsa lütfen üye olunuz.</li><li>Üyeliğinize izin verilebilmesi için üye olurken vereceğiniz email adresine göndereceğimiz mesajın içeriğinde gerekeni yapmanız yani linki tıklamanız gerekiyor bu yüzden vereceğiniz email adresinizin çalışan o email gelen mesajları görebilmeniz gerekiyor.</li><li>Üyelik formunda kendinizi tanıtın alanına sizi daha kolay tanıyabilmemiz için dedenizden başlayarak detaylı anlatmanızı rica ediyoruz varsa referanslar verebilirsiniz soyağacına giriş izni verebilmemiz için mutlaka sizi tam tanımamız gerekiyor.</li><li>GENÇ(GENCALOĞLU) sülalesi soyağacına sadece GENÇ(GENCALOĞLU) sülalesi mensupları üye olabildikleri için soyağacı bilgilerin akrabanın dışındakilerin görmesi mümkün değildir.</li><li>Tüm Muttafi GENÇ(GENCALOĞLU) sülalesi mensuplarını GENÇ(GENCALOĞLU) soyağacına mutlaka üye olmalarını rica ediyorum.</li></ul></div>";

//-- mygedview page
$pgv_lang["welcome"]			= "Hoş geldiniz";
$pgv_lang["upcoming_events"]		= "Gelecek yıldönümleri";
$pgv_lang["living_or_all"]			= "Sadece yaşayanların hadiseleri göster?";
$pgv_lang["basic_or_all"]			= "Sadece Doğum, Ölüm ve Evlilikleri Göster?";
$pgv_lang["style"]					= "Sunma Stili";
$pgv_lang["style1"]					= "Metin";
$pgv_lang["style2"]					= "Tablo";
$pgv_lang["cal_download"]			= "İzin verilen takvim olaylarını indir?";
$pgv_lang["no_events_living"]		= "Yaşayan insanlar için sonraki #pgv_lang[global_num1]# gün için herhangibir hadise yok.";
$pgv_lang["no_events_living1"]		= "Yaşayan insanlar için yarın için herhangibir hadise yok.";
$pgv_lang["no_events_all"]			= "Sonraki #pgv_lang[global_num1]# gün içinde herhangibir hadise yok.";
$pgv_lang["no_events_all1"]			= "Yarın için herhangibir hadise yok.";
$pgv_lang["no_events_privacy"]		= "Sonraki #pgv_lang[global_num1]# gün için hadiseler mevcut, Ancak onları görme yetkiniz kısıtlı olduğu için göremezsiniz.";
$pgv_lang["no_events_privacy1"]		= "Yarın için hadiseler mevcut, Ancak onları görme yetkiniz kısıtlı olduğu için göremezsiniz.";
$pgv_lang["more_events_privacy"]	= "<br />Sonraki #pgv_lang[global_num1]# gün için daha fazla hadiseler mevcut, Ancak onları görme yetkiniz kısıtlı olduğu için göremezsiniz.";
$pgv_lang["more_events_privacy1"]	= "<br />Yarın için daha fazla hadiseler mevcut, Ancak onları görme yetkiniz kısıtlı olduğu için göremezsiniz.";
$pgv_lang["none_today_living"]		= "Yaşayan insanlar için bügün için herhangibir hadise yok.";
$pgv_lang["none_today_all"]			= "Bugün için herhangibir hadise yok.";
$pgv_lang["none_today_privacy"]		= "Bugün için hadiseler mevcut, Ancak onları görme yetkiniz kısıtlı olduğu için göremezsiniz.";
$pgv_lang["more_today_privacy"]		= "<br />Bugün için daha fazla hadiseler mevcut, Ancak onları görme yetkiniz kısıtlı olduğu için göremezsiniz.";
$pgv_lang["chat"]			= "Chat";
$pgv_lang["users_logged_in"]		= "Bağlı bulunan diğer ziyaretçiler";
$pgv_lang["anon_user"]				= "1 gizli kullanıcı";
$pgv_lang["anon_users"]				= "#pgv_lang[global_num1]# gizli kullanıcılar";
$pgv_lang["login_user"]				= "1 kayıtlı kullanıcı";
$pgv_lang["login_users"]			= "#pgv_lang[global_num1]# kayıtlı kullanıcılar";
$pgv_lang["no_login_users"]			= "Kayıtlı veya gizli kullanıcılar yok";
$pgv_lang["reply"]			= "Cevapla";
$pgv_lang["random_picture"]		= "Rasgele fotoğraf";
$pgv_lang["sending_to"]			= "Bu mesaj #TO_USER# rumuzlu üyeye yollanacaktır.";
$pgv_lang["preferred_lang"]		= "Bu üye mesajlarını #USERLANG# dilinde okumayı tercih ediyor.";
$pgv_lang["gedcom_created_using"]	= "Bu GEDCOM veritabanı <b>#SOFTWARE#</b> yazılımının <b>#VERSION#</b> sürümü ile yaratılmıştır. ";
$pgv_lang["gedcom_created_on"]		= "Bu GEDCOM veritabanı <b>#DATE#</b> tarihinde yaratılmıştır.";
$pgv_lang["gedcom_created_on2"]		= "Yaratılış tarihi: <b>#DATE#</b>";
$pgv_lang["gedcom_stats"]		= "GEDCOM veritabanı istatistikleri:";
$pgv_lang["stat_individuals"]		= "Şahıslar";
$pgv_lang["stat_families"]		= "Aileler";
$pgv_lang["stat_sources"]		= "Kaynaklar";
$pgv_lang["stat_other"]			= "Diğer kayıt";
$pgv_lang["stat_earliest_birth"] 	= "İlk Doğan";
$pgv_lang["stat_latest_birth"] 	= "Son Doğan";
$pgv_lang["stat_earliest_death"] 	= "İlk Ölen";
$pgv_lang["stat_latest_death"] 	= "Son Ölen";
$pgv_lang["customize_page"]		= "Benim GedView Anasayfamı özelleştir";
$pgv_lang["customize_gedcom_page"]	= "Bu GEDCOM karşılama sayfasını özelleştirin";
$pgv_lang["upcoming_events_block"]	= "Gelecek olaylar kutusu";
$pgv_lang["upcoming_events_descr"]	= "Yakın gelecekte gerçekleşen hadiselerin yıldönümlerini gösterilme engellerler. Gösterilen detayları ayarlayabilirsiniz ve yönetici gelecek içinde bu bloğu görülecek seklinde ayarlayabilir.";
$pgv_lang["todays_events_block"]	= "\"Bugünkü hadise\" kutusu";
$pgv_lang["todays_events_descr"]	= "Bugünkü hadiseler... blokğu hadisleri yıldönümleri gösterir. Gösterilecek detayları ayarlayabilirsiniz.";
$pgv_lang["logged_in_users_block"]	= "Bağlı bulunan ziyaretçiler kutusu";
$pgv_lang["logged_in_users_descr"]	= "Bu blok kullanıcılara kimler çevrimiçi olduğunu gösteren bir bloktur.";
$pgv_lang["user_messages_block"]	= "Üye mesajları kutusu";
$pgv_lang["user_messages_descr"]	= "Bu blok üyelerin listesini gösterir, Bu listedeki üyeler mesaj gönderme imkanı verir.";
$pgv_lang["user_favorites_block"]	= "Üye - \"Sık Kullanılanlar\" kutusu";
$pgv_lang["user_favorites_descr"]	= "Bu blok üyeye kendine özel favorilerin ekenmesine izin verir.";
$pgv_lang["welcome_block"]		= "Üye - \"Hoş geldin\" kutusu";
$pgv_lang["welcome_descr"]			= "Bu blok üyeye üye adı ile hoş geldin der ve şahsi ayarların linkini verir, tarih verir bu bloğu ister sağda ister solda gösterebilirsiniz.";
$pgv_lang["random_media_block"]		= "\"Rasgele medya\" kutusu";
$pgv_lang["random_media_descr"] 	= "Bu blok rasgele media dosyaları gösterir, Soyağacında kayıtlı fotoğrafları ve kime ait olduğunu bilgisiyl beraberinde gösterin, Ayrıca manuel olarak bir sonraki resimleri görme, veya sonraki resimleri otoatik olarak değiştirebilir.<br /><br />Bu blokta media dosyaların gösterilmesi hakkında yönetici veya sahibi kısıtlamış olabilr.";
$pgv_lang["random_media_persons_or_all"]	= "Hepsi veya sadece şahıslar olayları göster?";
$pgv_lang["random_media_persons"]	= "Şahıslar";
$pgv_lang["random_media_events"]	= "Hadiseler";
$pgv_lang["gedcom_block"]		= "GEDCOM - \"Hoş geldin\" kutusu";
$pgv_lang["gedcom_descr"]			= "Bu GEDCOM için Hoş geldiniz bloku. Bu sitedeki bu GEDCOM kayıtları için siteye gelenleri karşılar ve günün tarihi ve saati gösterir.";
$pgv_lang["gedcom_favorites_block"]	= "GEDCOM - \"Sık kullanılanlar\" kutusu";
$pgv_lang["gedcom_stats_block"]		= "GEDCOM - \"İstatistikler\" kutusu";
$pgv_lang["gedcom_stats_show_surnames"]	= "Ençok kullanılan soy isimler listesi göster?";
$pgv_lang["login_block"]		= "\"Giriş\" kutusu";
$pgv_lang["login_descr"]			= "Bu blok giriş bloğudur, üyeler siteye giriş yapmak için kullanıcı adını ve şifresiniz girebileceği bir bloktur.";
$pgv_lang["theme_select_block"]		= "\"Tema seçme\" kutusu";
$pgv_lang["theme_select_descr"] 	= "Bu blok tema seçme bloğudur üyeler kendi zevklerine göre site görümünü mevcut temalar için de seçim yapabilecekleri bir bloktur.";
$pgv_lang["block_top10_title"]		= "Başlıca işlenmiş soy isimleri";
$pgv_lang["block_top10"]		= "Soy isimleri \"Top 10\" kutusu";
$pgv_lang["block_top10_descr"]		= "Bu blok sık sık kullanılan en çok 10 soyadları database den gösterir. Bu blokta gösterilecek soyadların sayılarını konfigurasyondan ayarlayabilirsiniz. Bu listeden isimleri kaldırmak için GEDCOMu ayarlayabilirsiniz.";
$pgv_lang["gedcom_news_block"]		= "GEDCOM - \"Haberler\" kutusu";
$pgv_lang["gedcom_news_limit"]		= "Kota yoluyla göster:";
$pgv_lang["gedcom_news_limit_nolimit"]	= "Kota yok";
$pgv_lang["gedcom_news_limit_date"]		= "Parçanın yaşı";
$pgv_lang["gedcom_news_limit_count"]	= "Parçaların numarası";
$pgv_lang["gedcom_news_flag"]		= "Kota:";
$pgv_lang["gedcom_news_archive"] 	= "Arşivi görüntüle";
$pgv_lang["user_news_block"]		= "Üye - \"Günlük\" kutusu";
$pgv_lang["user_news_descr"]		= "Kullanıcı günlüğü, bu blok kullanıcı çevrimiçi olduğunda istediği notların tutmasını sağlar isterse bu günlüğünü ekleyerek devam etmesini sağlar";
$pgv_lang["my_journal"]			= "Benim günlüğüm";
$pgv_lang["no_journal"] 			= "Herhangibir günlük oluşturmadınız.";
$pgv_lang["confirm_journal_delete"] = "Bu günlük girişi silmek istediğinizden emin misiniz?";
$pgv_lang["add_journal"]		= "Yeni bir günlük mesajını ekle";
$pgv_lang["gedcom_news"]		= "Haberler";
$pgv_lang["confirm_news_delete"]	= "Bu haberi gerçekten silmek mi istiyorsunuz?";
$pgv_lang["add_news"]			= "Haber mesajı ekle";
$pgv_lang["no_news"]			= "Daha hiçbir haber yayınlanmamıştır.";
$pgv_lang["edit_news"]			= "Günlük ya da haberlere ekleme yap veyahut içerikleri değiştir";
$pgv_lang["enter_title"]		= "Lütfen başlık ekleyin.";
$pgv_lang["enter_text"] 			= "Lütfen bu haberler veya günlük girişi için bazı metin girin.";
$pgv_lang["news_saved"] 		= "Yaptığınız ekleme başarı ile hafıza edilmiştir.";
$pgv_lang["article_text"]		= "Mesajın metni:";
$pgv_lang["main_section"]		= "Ana bölüm kutuları";
$pgv_lang["right_section"]		= "Sağ bölüm kutuları";
$pgv_lang["available_blocks"]		= "Mevcut Bloklar";
$pgv_lang["move_up"]			= "Bir yukarıya taşı";
$pgv_lang["move_down"]			= "Bir aşağıya taşı";
$pgv_lang["move_right"]			= "Sağa taşı";
$pgv_lang["move_left"]			= "Sola taşı";
$pgv_lang["add_main_block"] 		= "Ana bölüme bloğu ekle...";
$pgv_lang["add_right_block"]		= "Dik keside bir bloğu ekleyin...";
$pgv_lang["broadcast_all"]		= "Tüm üyelere mesaj gönder";
$pgv_lang["hit_count"]			= "Sayaç:";
$pgv_lang["phpgedview_message"]		= "PhpGedView mesajı";
$pgv_lang["common_surnames"]		= "Ençok kullanılan soy isimler listesi";
$pgv_lang["default_news_title"]		= "Nesep tetkikine hoş geldiniz";
$pgv_lang["default_news_text"]		= "Bu sitede bulunan seçere bilgileri <a href=\"http://www.phpgedview.net/\" target=\"_blank\">PhpGedView #VERSION#</a> yazılımı ile gösterilmektedir. Bu sayfada bu soy ağacını tanıtan bilgiler bulunmaktadır. Bu bilgilere ulaşmak için 'Çizimler' menüsünden bir çizgeyi seçin, ya da 'Listeler' menüsünden şahıs listesine gidin, veyahut sizi ilgilendiren bir soy ismini ya da yeri arayın.<br /><br />Bu siteyi gezerken bir sorunla karşılaşacak olursanız yardım simgesine tıklayıp bulunduğunuz sayfa hakkında gerekli yardımı bulabilirsiniz.<br /><br />Bu siteyi ziyaret ettiğiniz için teşekkür ederiz.";
$pgv_lang["reset_default_blocks"]	= "Kutuları varsayılan duruma sıfırla";
$pgv_lang["recent_changes"]		= "En Son Değişiklikler";
$pgv_lang["recent_changes_block"]	= "\"En son değişiklikler\" kutusu";
$pgv_lang["recent_changes_descr"]	= "Son değişiklikler bloğu son ayda veri tabanına yapılan değişikliklerin hepsini listeleyecek. Bu bloğu yapılan değişiklikler ile günceli siz kaldırabilirsiniz. Değişiklikler otomatik olarak GEDCOM standarta tanımlı risk etiketi kullanma saptanabilir.";
$pgv_lang["recent_changes_none"]	= "<b>Son #pgv_lang[global_num1]# gün için hiç değişmeyenler.</b><br />";
$pgv_lang["recent_changes_some"]	= "<b>Son #pgv_lang[global_num1]# gün içinde yapılan değişiklikler</b><br />";
$pgv_lang["show_empty_block"]		= "Blok boş olduğunda gösterilsin mi?";
$pgv_lang["hide_block_warn"]		= "Blok boş iken gösterme ayarlarsanız blok görülmeden blok konfigürasyon ayarlarını değiştiremezsiniz.";
$pgv_lang["delete_selected_messages"]	= "Seçilmiş mesajları sil";
$pgv_lang["use_blocks_for_default"]	= "Bu kutular tüm ziyaretçiler icin varsayılan olarak kullanılsın mı?";
$pgv_lang["block_not_configure"]	=	"Bu blok ayarlanamaz.";
$pgv_lang["performing_validation"]	= "GEDCOM yapılıyor onaylanıyor...";

//-- upgrade.php messages
$pgv_lang["upgrade_util"]		= "Güncelleştirme aracı";
$pgv_lang["no_upgrade"]			= "Güncelleştirilecek dosya yoktur.";
$pgv_lang["use_version"]		= "Kullandığınız sürüm numarası:";
$pgv_lang["current_version"]		= "Güncel \"stable\" sürüm numarası:";
$pgv_lang["upgrade_download"]		= "İndir:";
$pgv_lang["upgrade_tar"]			= "TAR";
$pgv_lang["upgrade_zip"]			= "ZIP";
$pgv_lang["latest"]			= "Kullandığınız PhpGedView sürümü günceldir.";
$pgv_lang["location"]			= "Güncelleme dosyalarının bulundugu yer: ";
$pgv_lang["options"]			= "Seçenekler:";
$pgv_lang["inc_phpgedview"] 		= "PhpGedView Görüntüleme";
$pgv_lang["inc_languages"]		= "Diller";
$pgv_lang["inc_config"]			= "Yapılandırma dosyası";
$pgv_lang["inc_researchlog"]		= "Kütüğü araştır";
$pgv_lang["inc_index"]			= "İndeks dosyaları";
$pgv_lang["inc_themes"]			= " Temalar";
$pgv_lang["inc_docs"]			= "Elkitapları";
$pgv_lang["inc_privacy"]		= "Mahremiyet dosyası/dosyaları";
$pgv_lang["inc_backup"]			= " Yedekleme yap";
$pgv_lang["upgrade_help"]		= "Bana yardım et";
$pgv_lang["cannot_read"]		= "Okuyamadığım dosya:";
$pgv_lang["not_configured"]		= "Daha PhpGedView ayarlarını yapılandırmadınız.";
$pgv_lang["location_upgrade"]		= "Lütfen güncelleme dosyalarınızın bulunduğu yeri işleyin.";
$pgv_lang["new_variable"]		= "Yeni değişken bulundu: ";
$pgv_lang["config_open_error"]		= "Yapilandırma dosyasını açarken bir hata oluştu.";
$pgv_lang["gedcom_config_write_error"]	= "HATA!!! GEDCOM yapılandırma dosyasına yazamıyorum.";
$pgv_lang["config_update_ok"]		= "Yapılandırma dosyanız başarı ile güncelleştirilmiştir.";
$pgv_lang["date_of_entry"]				= "Orijinal kaynağın giriş tarihi";
$pgv_lang["server_file"]				= "Serverdeki dosya ismi";
$pgv_lang["server_file_advice"]			= "Orijinal dosya ismini elde tutmak için değiştirme.";
$pgv_lang["server_file_advice2"]		= "&laquo;http://&raquo; ile başlayan URL girebilirsiniz.";
$pgv_lang["server_folder"]				= "Serverdeki dızın ismi";
$pgv_lang["media_options"]			= "Media Seçenekleri";
$pgv_lang["server_folder_advice2"]		= "Eğer dosya isim alanı iine URL girdiseniz bu giriş dikkate alınmaz.";
$pgv_lang["add_linkid_advice"]			= "Bu kişi, aile veya kaynağın media nesnenin ID sinin media nesnenin bağlantısını ara.";
$pgv_lang["use_browse_advice"]			= "İstenen dosya için yerel bilgisayarınızı aramak için &laquo;Gözat&raquo; düğmesini kullan.";
$pgv_lang["add_media_other_folder"]		= "Diğer dosya... lütfen tipini";
$pgv_lang["add_media_file"]				= "Serverde var olan media dosylar";
$pgv_lang["link_to_existing_media"]		= "Var olan media nesnesinden bağla";
$pgv_lang["page_size"]					= "Sayfa biçimi";
$pgv_lang["record_not_found"]			= "Talep edilen GEDCOM kayıdı bulunamadı. Bu geçersin kişiye bağlantı olabilir veya bozulmuş GEDCOM dosya dosyalanmış olabilir.";
$pgv_lang["record_marked_deleted"]		= "Bu kayıt yönetici üzerine silmek için işaretledi.";
$pgv_lang["result_page"]				= "Sonuç Sayfası";
$pgv_lang["edit_media"]					= "Medya parçaları düzenle";
$pgv_lang["wiki_main_page"]				= "Wiki Ana Sayfa";
$pgv_lang["wiki_users_guide"]			= "Wiki Kullanıcılar Kılavuzu";
$pgv_lang["wiki_admin_guide"]			= "Wiki Yöneticiler Kılavuzu";
$pgv_lang["no_search_for"]			= "Arama seçeneği seçtiğinizden emin olun.";
$pgv_lang["no_search_site"]			= "Başka siteyi seçtiğinizden emin olun.";
$pgv_lang["other_searches"]			= "Diğer Aramalar";
$pgv_lang["multi_site_search"] 		= "Çoklu Site Ara";
$pgv_lang["switch_lifespan"]		= "Yaşam Süresi Çizimi Göster";
$pgv_lang["switch_timeline"]		= "Zaman Yolu Çizimi Göster";
$pgv_lang["differences"]			= "Farklar";
$pgv_lang["charts_block"]			= "Blok Çizimleri";
$pgv_lang["charts_block_descr"]		= "Çizimler bloku, Hoş geldiniz sayfasında veya Benim GedView Anasayfamda yerleştirmenize izin verir. Atalar nesilden olanları göstermek için bloğu ayarlayabilirsiniz veya Kum Saati Çizimi. Çizim için ayrıca kök kişiyi aynı zamanda seçebilirsiniz.";
$pgv_lang["search_sites"] 			= "Siteleri ara";
$pgv_lang["site_list"]				= "Site: ";
$pgv_lang["search_sites_discription"] = "Tanınmış siteleri ara";
$pgv_lang["basic_search_discription"] = "Basit site arama";
$pgv_lang["advanced_search_discription"] = "Site aramaya devam";
$pgv_lang["basic_search"]			= "ara";
$pgv_lang["advanced_search"]		= "Gelişmiş site arama";
$pgv_lang["name_search"]			= "İsim: ";
$pgv_lang["birthdate_search"]		= "Doğum tarihi: ";
$pgv_lang["birthplace_search"]		= "Doğum Yeri: ";
$pgv_lang["deathdate_search"]		= "Ölüm tarihi: ";
$pgv_lang["deathplace_search"]		= "Ölüm Yeri: ";
$pgv_lang["gender_search"]			= "Cinsiyet: ";
$pgv_lang["site_had"]				= "Aşağıdakiyi kapsa";
$pgv_lang["invalid_search_multisite_input"] = "Lütfen aşağıdaki yerlerin birine girin: İşim, Doğum Tarihi, Doğum Yeri, Ölüm Tarihi, ve Cinsiyet ";
$pgv_lang["invalid_search_multisite_input_gender"] = "Lütfen daha fazla bilgi ile tekrar ara doğru bilgi ile cinsiyet";
$pgv_lang["link_manage_servers"]    = "Sitelerin Yönetimi";
$pgv_lang["indi_is_remote"]			= "Bu kişisel için bilgi Başka sisteden bağlandı.";
$pgv_lang["link_remote"]            = "Başka siteden kişiyi bağla";
$pgv_lang["label_search_engine_detected"]  = "Arama Motoru Örümcek Oraya Çıkardı";
$pgv_lang["label_search_engine_spider"]    = "Arma Motor Örümceği";
$pgv_lang["current_person"]         = "Şimdiki İle Aynı";
$pgv_lang["title_remote_link"]      = "Başka sitedeki Bağlantıyı Ekle";
$pgv_lang["title_search_link"]      = "Yerel Bağlantı Ekle";
$pgv_lang["label_site_url2"]        = "Site URL";
$pgv_lang["label_same_server"]      = "Aynı Site";
$pgv_lang["label_diff_server"]      = "Başka Site";
$pgv_lang["label_accept_changes"]   = "Tüm Değişiklikleri Kabul Et";
$pgv_lang["label_ask_first"]        = "Önce Bana Sor";
$pgv_lang["label_rel_to_current"]   = "Geçerli Kişiye İlişkilendir";
$pgv_lang["label_location"]         = "Sitenin Yeri";
$pgv_lang["label_remote_id"]        = "Başka sitedeki Kişinin ID";
$pgv_lang["label_local_id"]         = "Kişi ID";
$pgv_lang["label_merge_options"]    = "Birleştirme Seçenekleri";
$pgv_lang["label_add_remote_link"]  = "Link Ekle";
$pgv_lang["error_remote"]           = "Başka siteden yeri seçtiniz.";
$pgv_lang["error_same"]             = "Aynı yeri seçtiniz.";
$pgv_lang["lbl_server_list"]        = "Var olan siteyi kullan.";
$pgv_lang["lbl_type_server"]        = "Yeni sitenin tipi.";
$pgv_lang["error_url_blank"]		= "Başka sitenin başlığı veya URL lütfen boş birakmayın";
$pgv_lang["error_siteauth_failed"]	= "Başka sitenin doğruluğunu doğrulamak başarışız oldu";
$pgv_lang["link_success"]			= "Başarılı biçimde bağlantı eklendi";
$pgv_lang["change"]					= "Değiştir";
$pgv_lang["change_family_instr"]	= "Aile üyelerini değiştirmek veya kaldırmak için bu sayfayı kullan.<br /><br />Her biri için sizin kullanabildiğiniz aile değişimdeki üye doldurana bir farklı lişiyi seçmeyi bağlar ailedeki o rol. Ayrıca ailede o kişiyi kaldırmak için kaldır bağlantıyı kullanabilirsiniz.<br /><br />Değiştirmeyi bitirdiğiniz zaman aile üyeler değişimleri kaydetmek için kaydet düğmesini tıklarlar..<br />";
$pgv_lang["label_ban_server"]		= "Gönder";
$pgv_lang["label_add_search_server"]	= "IP Ekle";
$pgv_lang["remove_ip"] 			= "IP Kaldır";
$pgv_lang["label_remove_ip"]		= "IP Adresi Yasakla (Eg: 198.128.*.*): ";
$pgv_lang["label_remove_search"]	= "Arama motor örümcekleri olarak İP adresini işaretle: ";
$pgv_lang["label_username_id"]		= "Kullanıcı Adı";
$pgv_lang["label_username_id2"]		= "Kullanıcı Adı: ";
$pgv_lang["label_password_id"]		= "Şifre";
$pgv_lang["label_password_id2"]		= "Şifre: ";
$pgv_lang["error_ban_server"]       = "Geçersiz IP adresi.";
$pgv_lang["error_view_connections"] = "Görüntülemek için siteyi seçmelisiniz.";
$pgv_lang["error_delete_server"]    = "Silmek için siteyi seçmelisiniz.";
$pgv_lang["title_manage_servers"]   = "Site Yönetimi";
$pgv_lang["label_banned_servers"]   = "IP yoluyla Siteleri Yasakla";
$pgv_lang["label_manual_search_engines"]   = "El ile İP yoluyla arama motorlarını işaretle";
$pgv_lang["label_ban_view_links"]   = "Bu yasaklanmış site bağlantısını görüntüle";
$pgv_lang["label_delete"]           = "Sil";
$pgv_lang["label_new_server"]       = "Yeni site ekle";
$pgv_lang["label_server_url"]       = "Site URL/IP";
$pgv_lang["label_add_server"]       = "Ekle";
$pgv_lang["label_added_servers"]	= "Başka siteden Eklenen Serverler";
$pgv_lang["error_url"]              = "Site URL/IP e sahip olmalı.";
$pgv_lang["error_exists_server"]    = "Site zaten var.";
$pgv_lang["error_view_info"]        = "Kişiel bilgiyi görüntülemek için kişiyi seçmelisiniz.";
$pgv_lang["error_delete_person"]    = "Silmek istediğiniz Başka siteden bağlantılı kişiyi seçmelisiniz.";
$pgv_lang["title_view_conns"]       = "Bağlantıları Görüntüle";
$pgv_lang["label_server_info"]      = "Tüm kişiler Başka sisteden bağlandılar.";
$pgv_lang["label_view_local"]       = "Kişinin yerel bilgilerini görüntüle";
$pgv_lang["label_view_remote"]      = "Kişinin Başka siteden bilgilerini görüntüle";
$pgv_lang["label_individuals"]      = "Bireyler";
$pgv_lang["label_families"]         = "Aileler";
$pgv_lang["ex-spouse"] = "Ex-Eş";
$pgv_lang["ex-wife"] = "Ex-Hanımı";
$pgv_lang["ex-husband"] = "Ex-Koca";
$pgv_lang["noemail"] 				= "Emailler olmadan adresleri";
$pgv_lang["onlyemail"] 				= "Sadece emailler ile adresler";
$pgv_lang["maxviews_exceeded"]		= "Oranın aştığı sayfa görüntüsü #GLOBALS[MAX_VIEWS]# her biri için #GLOBALS[MAX_VIEW_TIME]# sonraki sayfayı dene.";
$pgv_lang["broadcast_not_logged_6mo"]	= "6 aydan beri giriş yapmayan kullanıcılara mesaj gönder";
$pgv_lang["broadcast_never_logged_in"]	= "Hiç giriş yapmamış kullanıcılara mesaj gönder";
$pgv_lang["stats_to_show"]			= "Blokta gösterilecekleri seçin";
$pgv_lang["stat_avg_age_at_death"]	= "Ortalama Yaş";
$pgv_lang["stat_longest_life"]		= "Uzun Yaşayan";
$pgv_lang["stat_most_children"]		= "Çok Çocuklu";
$pgv_lang["stat_average_children"]	= "Bir aileye ortalama çocuk sayısı";
$pgv_lang["stat_events"]			= "Hadiseler";
$pgv_lang["stat_media"]				= "Medialar";
$pgv_lang["stat_surnames"]			= "Soyadlar";
$pgv_lang["stat_users"]				= "Üyeler";
$pgv_lang["no_family_facts"]		= "Bu aile için hiç bilgiler yok.";
$pgv_lang["stat_males"]				= "Toplam erkekler";
$pgv_lang["stat_females"]			= "Toplam bayanlar";
$pgv_lang["sunday_1st"]					= "Pz";
$pgv_lang["monday_1st"]					= "P";
$pgv_lang["tuesday_1st"]				= "Sl";
$pgv_lang["wednesday_1st"]				= "Ç";
$pgv_lang["thursday_1st"]				= "Pş";
$pgv_lang["friday_1st"]					= "C";
$pgv_lang["saturday_1st"]				= "Ct";
$pgv_lang["jan_1st"]					= "Oca";
$pgv_lang["feb_1st"]					= "Şub";
$pgv_lang["mar_1st"]					= "Mar";
$pgv_lang["apr_1st"]					= "Nis";
$pgv_lang["edit_source"]			= "Kaynağı Düzenle";
$pgv_lang["source_menu"]			= "Kaynak için seçenekler";
$pgv_lang["familybook_chart"]		= "Ayrı Ayrı Aile Çizimi";
$pgv_lang["family_of"]				= "Aile:&nbsp;";
$pgv_lang["descent_steps"]			= "Nesil Adımları";
$pgv_lang["user_auto_accept"]		= "Otomatik olarak bu kullanıcı tarafından yapılan değişiklikleri kabul et";
$pgv_lang["cancel"]					= "Çık";
$pgv_lang["cookie_help"]			= "Bu site giriş konumunuzun izni elde tutmak için coikeler kullanır, (Giriş yapmış olarak siteyi dolaşabilmeniz için).<br /><br /><br />Coikeler tarayıcınızda etkinleştirmek için belirmezler. Siteye girmeden önce coikeleri etkinleştimeniz gerekiyor. Coikeleri etkineştirmek için bilgi yarayıcınızın yardım dokümanyonundan bakabilirsiniz.";
$pgv_lang["change_family_members"]	= "Aile Üyeleri Değiş";
$pgv_lang["delete_family"]			= "Aileyi sil";
$pgv_lang["add_favorite"]			= "Yeni bir favori ekle";
$pgv_lang["url"]					= "URL";
$pgv_lang["add_fav_enter_note"]		= "Bu favori hakkında bir açıklama gir";
$pgv_lang["add_fav_or_enter_url"]	= "VEYA<br />URL ve başlık gir ";
$pgv_lang["add_fav_enter_id"]		= "Bir Kişi, Aile, veya Kaynak ID gir";
$pgv_lang["import_time_exceeded"]	= "İşletim süre kotası doldu. GEDCOM dosyasını yeniden içeri aktarımı başlatmak için aşağıdaki devam düğmesine basın.";
$pgv_lang["next_email_sent"]		= "Gelecek hatırlatıcı email gönderileceği zaman ";
$pgv_lang["last_email_sent"]		= "En son hatırlatıcı email gönderilme zamanı ";
$pgv_lang["confirm_remove"]			= "Ailedeki bu kişiyi kaldırmak istediğinizden eminmisiniz?";
$pgv_lang["remove_child"]			= "Aileden bu çocuğu kaldır";
$pgv_lang["address_labels"]			= "Adres Etiketleri";
$pgv_lang["filter_address"]			= "Kapsayan adresleri göster:";
$pgv_lang["address_list"]			= "Adres Listesi";
$pgv_lang["autocomplete"]			= "Tam otomatik";
$pgv_lang["undo_all_confirm"]		= "Bu GEDCOM için değişikliklerin hepsini silmek istediğinizden eminmisiniz?";
$pgv_lang["link_new_husb"]			= "Bu kişiye var olan bir koca ekle";
$pgv_lang["link_new_wife"]			= "Var olan kişiden yeni bir bayan eş ekle";
$pgv_lang["undo_all"]				= "Tüm değişiklikleri gerial";
$pgv_lang["index_edit_advice"]		= "Blok isimini belirt ve sonra gösterilen yönde bloğu belirten yere taşımak için taşıma ikonlarından birini tıklayın.";
$pgv_lang["config_uptodate"]		= "Yapılandırma dosyanız günceldir.";
$pgv_lang["processing"]			= "İşliyorum...";
$pgv_lang["privacy_open_error"]		= "[#PRIVACY_MODULE#] isimli mahremiyet dosyasını açılırken bir HATA ortaya çıktı.";
$pgv_lang["privacy_write_error"]	= "HATA!!! [#PRIVACY_MODULE#] isimli mahremiyet dosyasına yazamadım.<br />Lütfen bu dosyanın yazılma hakkına sahip olmasını sağlayın.<br />Bu yazma hakları değişiklikler eklendikten sonra geriye alınabilir.";
$pgv_lang["privacy_update_ok"]		= "[#PRIVACY_MODULE#] isimli mahremiyet dosyası başarı ile güncelleştirildi.";
$pgv_lang["privacy_uptodate"]		= "[#PRIVACY_MODULE#] isimli mahremiyet dosyası günceldir.";
$pgv_lang["heading_privacy"]		= "Mahremiyet dosyası/dosyaları";
$pgv_lang["heading_phpgedview"]		= "PhpGedView dosyaları:";
$pgv_lang["heading_image"]		= "Resim dosyaları:";
$pgv_lang["heading_index"]		= "İndeks dosyaları:";
$pgv_lang["heading_language"]		= "Dil dosyaları:";
$pgv_lang["heading_theme"]		= "Tema dosyaları:";
$pgv_lang["heading_docs"]		= "Elkitapları:";
$pgv_lang["heading_researchlog"]	= "Kütük dosyaları araştır:";
$pgv_lang["heading_researchloglang"]= "Kütük Lisan dosyaları araştır:";
$pgv_lang["copied_success"]		= "başarıyla kopyalandı.";
$pgv_lang["backup_copied_success"]	= "yedekleme dosyası başarı ile yaratıldı.";
$pgv_lang["folder_created"]		= "Klasör yaratıldı";
$pgv_lang["folder_no_create"]		= "Dızın oluşturulamaz";
$pgv_lang["process_error"]			= "Sayfayı işleme tabi tutan problem vardır. Yeni versiyon belirlenemiyor.";
$pgv_lang["upgrade_completed"]		= "Güncelleme başarı ile gerçekleştirilmiştir";
$pgv_lang["start_using_upgrad"] 	= "Kullanan versiyonu başlamak burayı tıkla";

$pgv_lang["january_1st"]			= "Oca";
$pgv_lang["february_1st"]			= "Şub";
$pgv_lang["march_1st"]				= "Mart";
$pgv_lang["april_1st"]				= "Nısan";
$pgv_lang["may_1st"]				= "May";
$pgv_lang["jun_1st"]					= "Haz";
$pgv_lang["jul_1st"]					= "Tem";
$pgv_lang["aug_1st"]					= "Ağu";
$pgv_lang["sep_1st"]					= "Eyl";
$pgv_lang["oct_1st"]					= "Eki";
$pgv_lang["nov_1st"]					= "Kas";
$pgv_lang["dec_1st"]					= "Ara";
$pgv_lang["june_1st"]				= "Haziran";
$pgv_lang["july_1st"]				= "Temmuz";
$pgv_lang["august_1st"]				= "Ağu";
$pgv_lang["september_1st"]			= "Eyl";
$pgv_lang["october_1st"]			= "Eki";
$pgv_lang["november_1st"]			= "Kas";
$pgv_lang["december_1st"]			= "Arl";

//-- validate gedcom
$pgv_lang["invalid_dates"]		= "Hatalı tarih biçimleri bulunmuştur. Temizlemeyi seçerseniz bunlar GG AAA SSSS (örnek: 1 JAN 2004) biçimine çevirilecektir.";
$pgv_lang["valid_gedcom"]		= "Geçerli GEDCOM bulundu. Temizlemeye gerek yok. ";
$pgv_lang["optional_tools"]		= "İsterseniz ithal etmeden önce asağıdaki seçmeli aracları kullanabilirsiniz.";
$pgv_lang["optional"]			= "Seçmeli araçlar";
$pgv_lang["date_format"]			= "Veri Formatı:";
$pgv_lang["day_before_month"]		= "Önce gün sonra ay (GG AA SSSS)";
$pgv_lang["month_before_day"]		= "Önce ay sonra gün (AA GG SSSS)";
$pgv_lang["do_not_change"]		= "Değiştirme";
$pgv_lang["change_id"]				= "Kişisel ID bilgilerini Değiştirme:";
$pgv_lang["example_place"]			= "GEDCOM dan geçersiz yerin örneği:";
$pgv_lang["example_date"]		= "GEDCOM veritabanınızdan hatalı bir tarih biçiminin örneği:";
$pgv_lang["add_media_tool"]		= "Medya dosyası ekleme aracı";
$pgv_lang["launch_media_tool"]		= "Buraya tıklayarak \"medya ekleme aracını\" kullanabilirsiniz.";
$pgv_lang["media_table_created"]	= "Başarılı biçimde <i>media</i> tablo güncellendi.";
$pgv_lang["click_to_add_media"] 	= "#GEDCOM# GEDCOM üste listelenilen medyayı eklemek için burayı tıkla";
$pgv_lang["highlighted"]		= "Vurgulanan resim";
$pgv_lang["extension"]			= "Uzantı";
$pgv_lang["order"]					= "Düzen";
$pgv_lang["inject_media_tool"]		= "GEDCOM media dosya ekle";
$pgv_lang["add_media_button"]		= "Medya dosyası ekle";
$pgv_lang["media_linked"]			= "Bu multimedia nesnesi aşağıdaki kişiye bağlıdır:";
$pgv_lang["media_not_linked"]		= "Bu media öbjesi hiçbir kişiye bağlı değil ve GEDCOM a kayıtlı değil.";
$pgv_lang["deleted_files"]          = "Dosyalar Silindi:";
$pgv_lang["media_dir_1"]			= "Bu media nesnesi dış sunucuda lokale yerleştirilir";
$pgv_lang["media_dir_2"]			= "Bu media nesnesi standart media klasöründedir";
$pgv_lang["media_dir_3"]			= "Bu media nesnesi korunmuş media klasöründedir";
$pgv_lang["thumb_dir_1"]			= "Bu tırnak önizleme dış sunucuda lokale yerleştirilir";
$pgv_lang["thumb_dir_2"]			= "Bu tırnak önizleme standart media klasöründedir";
$pgv_lang["thumb_dir_3"]			= "Bu tırnak önizleme korunmuş media klasöründedir";
$pgv_lang["moveto_2"]				= "Klasörü korumak için taşı";
$pgv_lang["moveto_3"]				= "Standart klasörü taşı";
$pgv_lang["move_standard"]			= "Standart taşı";
$pgv_lang["move_protected"]		= "Korunmuş taşı";
$pgv_lang["move_time_exceeded"]	= "İletişim süre limitine ulaşıldı. Dosyaların bundan sonrası taşımak için tekrar komutu dene.";
$pgv_lang["media_firewall_rootdir_no_exist"]			= "İstediğiniz bu media firewall kök klasörü yok. Önce bunu oluşturun.";
$pgv_lang["media_firewall_protected_dir_no_exist"]		= "Korunmuş media klasöründe media firewall kök klasörü oluşturulamıyor. Lütfen bu klasörü oluştur ve yazılabilir yap.";
$pgv_lang["media_firewall_protected_dir_not_writable"]	= "Media firewall kök klasöründe korunmuş media klasörü yazılabilir değil.";
$pgv_lang["relationship_great"]		= "Büyük";
$pgv_lang["phpinfo"]				= "PHPbilgisi";
$pgv_lang["admin_info"]				= "Bilgilendirme";
$pgv_lang["admin_geds"]				= "Veri ve GEDCOM yönetimi";
$pgv_lang["admin_site"]				= "Site yönetimi";
$pgv_lang["adds_completed"]		= "Medya dosyası başarı ile GEDCOM veritabanına eklenmiştir.";
$pgv_lang["cleanup_places"]		= "Yerleri temizle";
$pgv_lang["empty_lines_detected"]	= "GEDCOM veritabanınızda boş sıralar bulunmuştur. Temizlemeyi seçerseniz bunlar silinecektir.";
$pgv_lang["import_options"]		= "İçeri Aktarım Seçenekleri";
$pgv_lang["import_options_help"] 	= "GEDCOM u içeri aktarımda kullanmak için ek seçenekler seçebilirsiniz.";
$pgv_lang["verify_gedcom"]		= "GEDCOM Doğrula";
$pgv_lang["verify_gedcom_help"]	= "Burada yükleme ve içeri aktarım bitirmeden durdurmak veya GEDCOM dosyasını yüklemek ve içeri aktarım ile herhangi biri için devam seçebilirsiniz.";
$pgv_lang["import_statistics"]	= "İçeri Aktarım İstatistikleri";

//-- hourglass chart
$pgv_lang["hourglass_chart"]		= "Kum saati çizimi";

//-- report engine
$pgv_lang["choose_report"]		= "Rapor seçimi";
$pgv_lang["enter_report_values"]	= "Rapor içeriklerini işleyin";
$pgv_lang["selected_report"]		= "Seçilen rapor türü";
$pgv_lang["run_report"]			= "Rapora bak";
$pgv_lang["select_report"]		= "Raporu seç";
$pgv_lang["download_report"]		= "Raporu indir";
$pgv_lang["reports"]			= "Raporlar";
$pgv_lang["pdf_reports"]		= "PDF raporları";
$pgv_lang["html_reports"]		= "HTML raporları";
$pgv_lang["family_group_report"]	= "Aile Grup Raporu";
$pgv_lang["page"]					= "Sayfa";
$pgv_lang["of"] 					= "son";
$pgv_lang["enter_famid"]		= "Aile numarası";
$pgv_lang["show_sources"]		= "Kaynaklar gösterilsin mi?";
$pgv_lang["show_notes"]			= "Notlar gösterilsin mi?";
$pgv_lang["show_basic"]			= "Temel hadiseler, boş olsa da, eklensin mi?";
$pgv_lang["show_photos"]		= "Fotoğraflar gösterilsin mi?";
$pgv_lang["relatives_report_ext"]	= "Detaylı Akraba Raporu";
$pgv_lang["with"]					= "ile";
$pgv_lang["on"]						= "de";
$pgv_lang["in"]						= "içine";
$pgv_lang["individual_report"]		= "Şahıs raporu";
$pgv_lang["enter_pid"]			= "Şahıs numarası";
$pgv_lang["individual_list_report"]	= "Şahıs listesi raporu";
$pgv_lang["generated_by"]		= "Üretenin ismi:";
$pgv_lang["list_children"]		= "Her çocuğu doğum tarihine göre sırala.";
$pgv_lang["birth_report"]		= "Doğum tarihi ve yer raporu";
$pgv_lang["birthplace"]				= "Doğum yeri";
$pgv_lang["birthdate1"]				= "Doğum Tarihinden Başla";
$pgv_lang["birthdate2"]				= "Doğum Tarihinde Bitir";
$pgv_lang["death_report"]			= "Ölüm Tarihi ve Yer Raporu";
$pgv_lang["deathplace"]				= "Ölüm Yeri";
$pgv_lang["deathdate1"]				= "Ölüm Tarihinden Başla";
$pgv_lang["deathdate2"]				= "Ölüm Tarihinden Bitir";
$pgv_lang["marr_report"]			= "Evlilik Tarihi ve Yer Raporu";
$pgv_lang["marrplace"]				= "Evlilik Yeri";
$pgv_lang["marrdate1"]				= "Evlilik Tarihinden Başla";
$pgv_lang["marrdate2"]				= "Evlilik Tarihinden Bitir";
$pgv_lang["sort_by"]			= "Sıralama biçimi:";

$pgv_lang["cleanup"]			= "Temizle";
$pgv_lang["skip_cleanup"]		= "Temizlemeyi atla";

//-- CONFIGURE (extra) messages for programs patriarch, slklist and statistics
$pgv_lang["dynasty_list"]		= "Aile tablosu";
$pgv_lang["make_slklist"]		= "EXCEL (SLK) listesini yarat.";
$pgv_lang["excel_list"] 			= "Aşağıdaki dosyaları EXCEL (SLK) formatında çıkarır. (ilk kullanım aile reisleri listeler):";
$pgv_lang["excel_create"]			= "Dosyada oluşturuldu:";
$pgv_lang["patriarch_list"]		= "Ata listesi";
$pgv_lang["slk_list"]			= "EXCEL (SLK) listesi";
$pgv_lang["statistics"]			= "İstatistikler";

//-- Merge Records
$pgv_lang["merge_same"] 			= "Kayıtlar aynı tip değiller. Aynı tip olmayan kayıtları birleştirilmez.";
$pgv_lang["merge_records"]		= "Kayıtları birleştir";
$pgv_lang["merge_step1"]		= "Kayıt birleştirme - 3 adımdan 1'incisi";
$pgv_lang["merge_step2"]		= "Kayıt birleştirme - 3 adımdan 2'ncisi";
$pgv_lang["merge_step3"]		= "Kayıt birleştirme - 3 adımdan 3'üncüsü";
$pgv_lang["select_gedcom_records"]	= "Birleştirmek için iki GEDCOM kayıdı seç. Kayıtlar ayn tipden olmalılar.";
$pgv_lang["merge_to"]				= "Birleşecek yerin Kaynak ID:";
$pgv_lang["merge_from"] 			= "Birleştimek için Alınacak Kaynak ID:";
$pgv_lang["merge_facts_same"]		= "Her ikiside tam olarak aynı olan takip eden gerçekler otomatik olarak kaydederek birleştirilecek.";
$pgv_lang["no_matches_found"]		= "Uyan hiç bir hadise bulunamadı";
$pgv_lang["unmatching_facts"]		= "Aşağıdaki gerçekler eşlemediler. Elde tutmak istediğiniz bilgiyi seçin.";
$pgv_lang["record"]			= "Kayıt";
$pgv_lang["adding"] 				= "Eklendi";
$pgv_lang["updating_linked"]		= "Güncellenen kayıt bağlandı";
$pgv_lang["merge_more"]			= "Kayıt birleştirmeye devam et.";
$pgv_lang["same_ids"]				= "Aynı kimlik bilgileri girdiniz. Aynı kayıtlar birleştirilmez.";

//-- ANCESTRY FILE MESSAGES
$pgv_lang["ancestry_chart"]		= "Atalara Doğru Çizim";
$pgv_lang["gen_ancestry_chart"]		= "#PEDIGREE_GENERATIONS# Nesil Ataların Taslağını Çıkarırlar";
$pgv_lang["chart_style"]		= "Çizim türü";
$pgv_lang["chart_list"]			= "Liste";
$pgv_lang["chart_booklet"]   	= "Broşür";
$pgv_lang["ancestry_list"]		= "Seçere listesi";
$pgv_lang["ancestry_booklet"]		= "Seçere kitapçığı";
$pgv_lang["show_cousins"]			= "Kuzenleri göster";
// 1st generation
$pgv_lang["sosa_2"]			= "Baba";
$pgv_lang["sosa_3"]			= "Anne";
// 2nd generation
$pgv_lang["sosa_4"]			= "Büyükbaba";
$pgv_lang["sosa_5"]			= "Babaanne";
$pgv_lang["sosa_6"]			= "Dede";
$pgv_lang["sosa_7"]			= "Anneanne";
$pgv_lang["sosa_8"]			= "Büyükbabanın babası";
// 3rd generation
$pgv_lang["sosa_9"]			= "Büyükbabanın annesi";
$pgv_lang["sosa_10"]			= "Babaannenin babası";
$pgv_lang["sosa_11"]			= "Babaannenin annesi";
$pgv_lang["sosa_12"]			= "Dedenin babası";
$pgv_lang["sosa_13"]			= "Dedenin annesi";
$pgv_lang["sosa_14"]			= "Anneannenin babası";
$pgv_lang["sosa_15"]			= "Anneannenin annesi";
// 4th generation
$pgv_lang["sosa_16"]				= "Büyük-büyük-büyükbaba";
$pgv_lang["sosa_17"]				= "Büyük-büyük-büyükanne";
$pgv_lang["sosa_18"]				= "Büyük-büyük-büyükbaba";
$pgv_lang["sosa_19"]				= "Büyük-büyük-büyükanne";
$pgv_lang["sosa_20"]				= "Büyük-büyük-büyükbaba";
$pgv_lang["sosa_21"]				= "Büyük-büyük-büyükanne";
$pgv_lang["sosa_22"]				= "Büyük-büyük-büyükbaba";
$pgv_lang["sosa_23"]				= "Büyük-büyük-büyükanne";
$pgv_lang["sosa_24"]				= "Büyük-büyük-büyükbaba";
$pgv_lang["sosa_25"]				= "Büyük-büyük-büyükanne";
$pgv_lang["sosa_26"]				= "Büyük-büyük-büyükbaba";
$pgv_lang["sosa_27"]				= "Büyük-büyük-büyükanne";
$pgv_lang["sosa_28"]				= "Büyük-büyük-büyükbaba";
$pgv_lang["sosa_29"]				= "Büyük-büyük-büyükanne";
$pgv_lang["sosa_30"]				= "Büyük-büyük-büyükbaba";
$pgv_lang["sosa_31"]				= "Büyük-büyük-büyükanne";
$pgv_lang["sosa_paternal_female_n_generations"]	= "%3\$d x büyük büyükbaba";
$pgv_lang["sosa_paternal_male_n_generations"]	= "%3\$d x büyük büyükanne";
$pgv_lang["sosa_maternal_female_n_generations"]	= "%3\$d x büyük büyükbaba";
$pgv_lang["sosa_maternal_male_n_generations"]	= "%3\$d x büyük büyükanne";


// 5th generation
$pgv_lang["sosa_32"]			   = "Büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_33"]			   = "Büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_34"]			   = "Büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_35"]			   = "Büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_36"]			   = "Büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_37"]			   = "Büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_38"]			   = "Büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_39"]			   = "Büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_40"]			   = "Büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_41"]			   = "Büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_42"]			   = "Büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_43"]			   = "Büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_44"]			   = "Büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_45"]			   = "Büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_46"]			   = "Büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_47"]			   = "Büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_48"]			   = "Büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_49"]			   = "Büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_50"]			   = "Büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_51"]			   = "Büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_52"]			   = "Büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_53"]			   = "Büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_54"]			   = "Büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_55"]			   = "Büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_56"]			   = "Büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_57"]			   = "Büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_58"]			   = "Büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_59"]			   = "Büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_60"]			   = "Büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_61"]			   = "Büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_62"]			   = "Büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_63"]			   = "Büyük-büyük-büyük-büyükanne";
$pgv_lang["compact_chart"]			= "Sıkıştırılmış Çizim";
// 6th generation
$pgv_lang["sosa_64"]			   = "Büyük-büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_65"]			   = "Büyük-büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_66"]			   = "Büyük-büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_67"]			   = "Büyük-büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_68"]			   = "Büyük-büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_69"]			   = "Büyük-büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_70"]			   = "Büyük-büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_71"]			   = "Büyük-büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_72"]			   = "Büyük-büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_73"]			   = "Büyük-büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_73"]			   = "Büyük-büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_75"]			   = "Büyük-büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_76"]			   = "Büyük-büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_77"]			   = "Büyük-büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_78"]			   = "Büyük-büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_79"]			   = "Büyük-büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_80"]			   = "Büyük-büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_81"]			   = "Büyük-büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_82"]			   = "Büyük-büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_83"]			   = "Büyük-büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_84"]			   = "Büyük-büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_85"]			   = "Büyük-büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_86"]			   = "Büyük-büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_87"]			   = "Büyük-büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_88"]			   = "Büyük-büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_89"]			   = "Büyük-büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_90"]			   = "Büyük-büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_91"]			   = "Büyük-büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_92"]			   = "Büyük-büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_93"]			   = "Büyük-büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_94"]			   = "Büyük-büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_95"]			   = "Büyük-büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_96"]			   = "Büyük-büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_97"]			   = "Büyük-büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_98"]			   = "Büyük-büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_99"]			   = "Büyük-büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_100"]			   = "Büyük-büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_101"]			   = "Büyük-büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_102"]			   = "Büyük-büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_103"]			   = "Büyük-büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_104"]			   = "Büyük-büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_105"]			   = "Büyük-büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_106"]			   = "Büyük-büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_107"]			   = "Büyük-büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_108"]			   = "Büyük-büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_109"]			   = "Büyük-büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_110"]			   = "Büyük-büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_111"]			   = "Büyük-büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_112"]			   = "Büyük-büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_113"]			   = "Büyük-büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_114"]			   = "Büyük-büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_115"]			   = "Büyük-büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_116"]			   = "Büyük-büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_117"]			   = "Büyük-büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_118"]			   = "Büyük-büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_119"]			   = "Büyük-büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_120"]			   = "Büyük-büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_121"]			   = "Büyük-büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_122"]			   = "Büyük-büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_123"]			   = "Büyük-büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_124"]			   = "Büyük-büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_125"]			   = "Büyük-büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_126"]			   = "Büyük-büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_127"]			   = "Büyük-büyük-büyük-büyük-büyükanne";
// 7th generation
$pgv_lang["sosa_128"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_129"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_130"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_131"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_132"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_133"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_134"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_135"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_136"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_137"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_138"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_139"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_140"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_141"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_142"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_143"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_144"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_145"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_146"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_147"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_148"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_149"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_150"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_151"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_152"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_153"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_154"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_155"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_156"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_157"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_158"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_159"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_160"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_161"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_162"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_163"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_164"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_165"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_166"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_167"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_168"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_169"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_170"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_171"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_172"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_173"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_174"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_175"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_176"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_177"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_178"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_179"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_180"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_181"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_182"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_183"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_184"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_185"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_186"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_187"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_188"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_189"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_190"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_191"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_192"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_193"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_194"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_195"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_196"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_197"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_198"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_199"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_200"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_201"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_202"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_203"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_204"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_205"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_206"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_207"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_208"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_209"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_210"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_211"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_212"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_213"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_214"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_215"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_216"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_217"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_218"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_219"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_220"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_221"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_222"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_223"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_224"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_225"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_226"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_227"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_228"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_229"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_230"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_231"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_232"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_233"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_234"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_235"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_236"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_237"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_238"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_239"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_240"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_241"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_242"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_243"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_244"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_245"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_246"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_247"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_248"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_249"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_250"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_251"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_252"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_253"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_254"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_255"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükanne";
$pgv_lang["sosa_256"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükbaba";
$pgv_lang["sosa_257"]			   = "Büyük-büyük-büyük-büyük-büyük-büyükanne";


//-- FAN CHART
$pgv_lang["fan_chart"]			= "Diyagram Daire Çizimi";
$pgv_lang["gen_fan_chart"]  		= "#PEDIGREE_GENERATIONS# Nesil Çizim Yelpazesi";
$pgv_lang["fan_width"]			= "Değirmi çizge'nin eni";
$pgv_lang["gd_helplink"]			= "http://tr.php.net/gd";
$pgv_lang["fontfile_error"]		= "Yazı tipi dosyası PHP sunucusunda bulunamadı";
$pgv_lang["fanchart_IE"]			= "Bu yelpaze harıta görüntüsü tarayıcınız tarafından doğrudan yazılamaz. Bu durumda uygun yeri tıkla kaydet ve yazdır.";

//-- RSS Feed
$pgv_lang["rss_descr"]			= "Haberler ve bağlantılar #GEDCOM_TITLE# sitesindendir";
$pgv_lang["rss_logo_descr"]		= "Feed PhpGedView tarfından yaratılmıştır";
$pgv_lang["rss_feeds"]				= "RSS Kanalları";
$pgv_lang["no_feed_title"]			= "Feed mevcut değil";
$pgv_lang["no_feed"]				= "Bu PhpGedView sitesinde RSS mevcut değil veya kapalıdır";
$pgv_lang["authenticated_feed"]		= "Feed olduğunu onayla";
$pgv_lang["RSS_block"]				= "RSS Bloğu";
$pgv_lang["attendant"] = "Bağlı";
$pgv_lang["best_man"] = "En iyi Erkek";
$pgv_lang["bridesmaid"] = "Nedime";
$pgv_lang["buyer"] = "Alıcı";
$pgv_lang["circumciser"] = "Sünnet Edilme";
$pgv_lang["civil_registrar"] = "Medeni Sicil";
$pgv_lang["friend"] = "Arkadaş";
$pgv_lang["godfather"] = "Vaftiz Babası";
$pgv_lang["godmother"] = "Vaftiz anası";
$pgv_lang["godparent"] = "Vaftiz veli";
$pgv_lang["informant"] = "Bilgiveren";
$pgv_lang["lodger"] = "Konuk";
$pgv_lang["nurse"] = "Dadı";
$pgv_lang["priest"] = "Papaz";
$pgv_lang["rabbi"] = "Haham";
$pgv_lang["registry_officer"] = "Sicil Memuru";
$pgv_lang["seller"] = "Satıcı";
$pgv_lang["servant"] = "Hizmetçi";
$pgv_lang["twin"] = "İkiz";
$pgv_lang["twin_brother"] = "İkiz erkek kardeş";
$pgv_lang["twin_sister"] = "İkiz kız kardeş";
$pgv_lang["witness"] = "Tanık";
$pgv_lang["statutci"]			= "İndeks yaratılamadı";

//-- statistics utility
$pgv_lang["statnnames"]			= "Soy isim sayısı =";
$pgv_lang["statnfam"]			= "Aile sayısı =";
$pgv_lang["statnmale"]			= "Erkek sayısı =";
$pgv_lang["statnfemale"]		= "Kadın sayısı =";
$pgv_lang["statvars"]			= "Lütfen çizim için gerekli olan değişkenleri işleyin";
$pgv_lang["statlxa"]			= "X-Ekseni boyunca:";
$pgv_lang["statlya"]			= "Y-Ekseni boyunca";
$pgv_lang["statlza"]			= "Z-Ekseni boyunca";
$pgv_lang["stat_10_none"]		= "Hiç biri";
$pgv_lang["stat_11_mb"]			= "Doğum günlerinin ayı";
$pgv_lang["stat_12_md"]			= "Vefat günlerinin ayı";
$pgv_lang["stat_13_mm"]			= "Evlenme günlerinin ayı";
$pgv_lang["stat_14_mb1"]		= "Bir ilişkide doğan 1. çocuğun doğum ayı";
$pgv_lang["stat_15_mm1"]		= "İlk evlenme günlerinin ayı";
$pgv_lang["stat_16_mmb"]		= "Evlilik ile 1. doğum arasındaki ay sayısı.";
$pgv_lang["stat_17_arb"]		= "Doğum senesi bazında yaş.";
$pgv_lang["stat_18_ard"]		= "Vefat senesi bazında yaş.";
$pgv_lang["stat_19_arm"]		= "Evlilik senesi bazında yaş.";
$pgv_lang["stat_20_arm1"]		= "1. Evlilik senesi bazında yaş.";
$pgv_lang["stat_21_nok"]		= "Çocuk sayısı.";
$pgv_lang["stat_gmx"]			= " Aylar için limit değerleri denetleyin";
$pgv_lang["stat_gax"]			= " Yaşlar için limit değerleri denetleyin";
$pgv_lang["stat_gnx"]			= " Miktarlar için limit değerleri denetleyin";
$pgv_lang["stat_200_none"]		= "Hepsi (ya da boş)";
$pgv_lang["stat_201_num"]		= "Miktar";
$pgv_lang["stat_202_perc"]		= "Yüzdelik";
$pgv_lang["stat_300_none"]		= "Hiç biri";
$pgv_lang["stat_301_mf"]		= "Erkek / Kadın";
$pgv_lang["stat_302_cgp"]		= "Dönemler. Periyorlar z-ekseni için doğru değerleri kontrol et";
$pgv_lang["statmess1"]			= "Aşağıda yalnız x-ekseni ya da z-ekseni ile ilgili limit değerleri işleyin";
$pgv_lang["statar_xg"]			= "Doğru değerleri (x-ekseni):";
$pgv_lang["statar_zg"]			= "Doğru değerleri (z-ekseni):";
$pgv_lang["statar_xgp"]			= "Periyotlar için gerekli olan limit değerler (x-ekseni):";
$pgv_lang["statar_xgl"]			= "Yaşlar için gerekli olan limit değerler (x-ekseni):";
$pgv_lang["statar_xgm"]			= "Aylar için gerekli olan limit değerler (x-ekseni):";
$pgv_lang["statar_xga"]			= "Miktarlar için gerekli olan limit değerler (x-ekseni):";
$pgv_lang["statar_zgp"]			= "Periyotlar için gerekli olan limit değerler (z-ekseni):";
$pgv_lang["statreset"]			= "Sıfırla - İlk duruma getir";
$pgv_lang["statsubmit"]			= "Çizimi göster";
$pgv_lang["statistiek_list"]	= "İstatistik Alanı";

//-- statisticsplot utility
$pgv_lang["stpl"]			= "...";
$pgv_lang["stplGDno"]			= "Grafik sergileme kütüphanesi mevcut değildir, Sistem yöneticinize PHP 4 sorun";
$pgv_lang["stpljpgraphno"]		= "JPgraph modülleri rehber <i>PhpGedView/jpgraph/</i> da mevcut değiller. <br />Lütfen http://www.aditus.nu/jpgraph/jpdownload.php den onları önce alın<br> <br /><h3>Rehber <i>PhpGedView/jpgraph/</i></h3> da Jpgraph kurun<br>";
$pgv_lang["stplinfo"]			= "Çizim için değişken";
$pgv_lang["stpltype"]			= "Tipi:";
$pgv_lang["stplnoim"]			= "Uygulanacak yok:";
$pgv_lang["stplmf"]			= " / Erkek-Kadın";
$pgv_lang["stplipot"]			= " / her dönem zamanı";
$pgv_lang["stplgzas"]			= "Kenarları z-ekseni:";
$pgv_lang["stplmonth"]			= "Ay";
$pgv_lang["stplnumbers"]		= "Sayı";
$pgv_lang["stplage"]			= "Yaş";
$pgv_lang["stplperc"]			= "Yüzdelik";
$pgv_lang["stplnumof"]			 = "Sayımlar";
$pgv_lang["stplmarrbirth"]		 = "Evlilikle ile ilk çocuk arasındaki aylar";
$pgv_lang["slklist_header"]		= "(EXCEL) SYLK'i dosyalanmırmayı yap";
$pgv_lang["slklist_lezen"]		= "Bireylerdeki Kontrol";
$pgv_lang["slklist_progress1"]	= "Denetimde İlerleyin";
$pgv_lang["slklist_maken"]		= "Tüm isimler dosyalandılar";
$pgv_lang["slklist_progress2"]	= "Dosyayı yaparak ilerleyin";
$pgv_lang["slklist_tab"]		= "EXCEL not defteri:";
$pgv_lang["slklist_create"]		= " dosyada oluşturuldu: ";
$pgv_lang["alive_in_year"]			= "Yılda yaşayan";
$pgv_lang["is_alive_in"]			= "#YEAR# senesinde hayatta olanlar";
$pgv_lang["alive"]					= "Yaşayan";
$pgv_lang["dead"]					= "Ölü";
$pgv_lang["maybe"]					= "Belki";
$pgv_lang["both_alive"]					= "Her iki canli";
$pgv_lang["both_dead"]					= "Her iki ölü";

//-- alive in year

//-- find media
$pgv_lang["add_directory"]		= "Dizin ekle";
$pgv_lang["show_thumbnail"]		= "Tırnak resimleri göster";
$pgv_lang["image_format"]			= "Resim Biçimi";
$pgv_lang["media_format"]			= "Media Biçimi";
$pgv_lang["image_size"]				= "Resim ebatları--";
$pgv_lang["media_file_size"]		= "Media Boyutu";
$pgv_lang["no_thumb_dir"]			= "Tırnak önizleme rehberi yok ve oluşturulmaz.";
$pgv_lang["manage_media"]			= "Media Yönetimi";
$pgv_lang["gen_thumb"]				= "Tırnak önizleme Oluşturma";
$pgv_lang["move_to"]				= "den Taşı -->";
$pgv_lang["security_no_create"]		= "Güvenlik Uyarısı: <b><i>index.php</i></b> dosya yok  ";
$pgv_lang["security_not_exist"]		= "Güvenlik Uyarısı: Dosya <b><i>index.php</i></b> yi oluşturamıyorum  ";
$pgv_lang["illegal_chars"]			= "İsimdeki geçersiz karakterler";

//-- link media
$pgv_lang["link_media"]			= "Mültimedya bağla";
$pgv_lang["to_person"]			= "Kişiden";
$pgv_lang["to_family"]			= "Aileden";
$pgv_lang["to_source"]			= "Kaynaktan";
$pgv_lang["media_id"]			= "Media Kimlik";
$pgv_lang["invalid_id"]			= "Bu GEDCOM da böyle dosya var Dosyalanmaz.";
$pgv_lang["media_exists"]			= "Media dosya zaten var.";
$pgv_lang["media_thumb_exists"]		= "Media tırnak önizleme zaten var.";
$pgv_lang["move_file_success"]		= "Media ve tırnak önizleme dosyalar başarılı biçimde taşındı.";
$pgv_lang["media_folder_corrupt"]	= "Media dızın bozuk.";
$pgv_lang["max_media_depth"]		= "Sadece #MEDIA_DIRECTORY_LEVELS# dizinlere derin gidebilirsiniz";

//-- Help system
$pgv_lang["definitions"]		= "Tanımlar";

//-- Index_edit
$pgv_lang["description"]		= "Betimleme";
$pgv_lang["block_desc"]				= "Blok Detayları";
$pgv_lang["click_here"]				= "Devam etmek için burayı tıkla";
$pgv_lang["block_summary_table"]	= "&nbsp;";
$pgv_lang["total_places"]			= "Bulunan Yerler";
$pgv_lang["media_contains"]			= "Media içerikleri:";
$pgv_lang["repo_contains"]			= "Saklama yeri kapsa:";
$pgv_lang["source_contains"]		= "Kaynakları kapsa:";
$pgv_lang["display_all"]			= "Hepsini sergile";
$pgv_lang["accesskeys"]				= "Klavye Kısa Yolları";
$pgv_lang["accesskey_skip_to_content"]	= "İ";
$pgv_lang["accesskey_search"]	= "A";
$pgv_lang["accesskey_skip_to_content_desc"]	= "İçeriği Atla";
$pgv_lang["accesskey_viewing_advice_desc"]	= "Görüntülenen tavsiye";
$pgv_lang["accesskey_individual_details"]	= "I";
$pgv_lang["add_faq_header"] = "SSS Başlık";
$pgv_lang["add_faq_body"] = "SSS Mesajı";
$pgv_lang["add_faq_order"] = "SSS Konumu";
$pgv_lang["add_faq_visibility"] = "SSS Hangisi için";
$pgv_lang["no_faq_items"] = "Bu SSS listesi boş.";
$pgv_lang["position_item"] = "Bölümün konumu";
$pgv_lang["faq_list"] = "SSS Liste";
$pgv_lang["confirm_faq_delete"] = "SSS girişini silmek istediğinizden eminmisiniz";
$pgv_lang["preview"] =  "Önizleme";
$pgv_lang["no_id"] = "Belirtilen hiç SSS ID si yok !";
$pgv_lang["hs_title"] 			= "Yardım Metni Ara";
$pgv_lang["hs_search"] 			= "Arama";
$pgv_lang["hs_close"] 			= "Pencereyi kapat";
$pgv_lang["hs_results"] 		= "Bulunan sonuçlar:";
$pgv_lang["hs_keyword"] 		= "Arama için";
$pgv_lang["hs_searchin"]		= "Aranacak yer";
$pgv_lang["hs_searchuser"]		= "Kullanıcı Yardım";
$pgv_lang["hs_searchmodules"]	= "Modüller Yadımı";
$pgv_lang["hs_searchconfig"]	= "Yönetici Yardım";
$pgv_lang["hs_searchhow"]		= "Arama Tipi";
$pgv_lang["hs_searchall"]		= "Tüm kelimeler";
$pgv_lang["hs_searchany"]		= "Kelimenin biri";
$pgv_lang["hs_searchsentence"]	= "Aynı tabir";
$pgv_lang["hs_intruehelp"]		= "Tek yardım metni";
$pgv_lang["hs_inallhelp"]		= "Tüm metin";
$pgv_lang["media_import"] = "Media içeri aktar ve dönüştür";
$pgv_lang["confirm_folder_delete"] = "Bu dosyayı silmek istediğinizden eminmisiniz?";
$pgv_lang["choose"] = "Seçin: ";
$pgv_lang["account_information"] = "Hesap Bilgileri";
$pgv_lang["TYPE__audio"] = "Ses";
$pgv_lang["TYPE__book"] = "Kitap";
$pgv_lang["TYPE__card"] = "Kart";
$pgv_lang["TYPE__certificate"] = "Belge";
$pgv_lang["TYPE__document"] = "Doküman";
$pgv_lang["TYPE__electronic"] = "Elektronik";
$pgv_lang["TYPE__film"] = "Mikrofilm";
$pgv_lang["TYPE__magazine"] = "Magazin";
$pgv_lang["TYPE__manuscript"] = "El yazması";
$pgv_lang["TYPE__map"] = "Harita";
$pgv_lang["TYPE__newspaper"] = "Gazete";
$pgv_lang["TYPE__photo"] = "Fotoğraf";
$pgv_lang["TYPE__tombstone"] = "Mezartaşı";
$pgv_lang["TYPE__video"] = "Görüntü (video)";
$pgv_lang["view_slideshow"] = "Slayt olarak görüntüle";
$pgv_lang["download_image"]			= "Resmi İndir";
$pgv_lang["no_media"]				= "Media Bulunamadı";
$pgv_lang["media_privacy"]			= "Mahremiyet kısıtlamaları bu nesneyi görmenizi engeller";
$pgv_lang["relations_heading"]		= "Bu resme bağlı olan kişi:";
$pgv_lang["file_size"]				= "Dosya Boyutu";
$pgv_lang["img_size"]				= "Resim Boyutu";
$pgv_lang["media_broken"]			= "Bu media dosyası bozuk ve PHP ile okunamaz";
$pgv_lang["unknown_mime"]			= "Medya firewall için mediadaki bilinmeyen mimetipi dosyalar, bu problemlere neden oacak.";
$pgv_lang["module_error_unknown_action_v2"] = "Bilinmeyen hareket: [action].";
$pgv_lang["module_error_unknown_type"] = "Bilinmeyen modül tipi.";
$pgv_lang["button_alive_in_year"] = "Yılda yaşayan kişileri göster.";
$pgv_lang["button_BIRT_Y100"] = "Son 100 yıl içinde doğmuş kişileri göster.";
$pgv_lang["button_BIRT_YES"] = "100 yıl önce doğmuş çocukları göster";
$pgv_lang["button_DEAT_H"] = "Sadece ortak evlilik çiftlerin erkek ölüm yerlerini göster.";
$pgv_lang["button_DEAT_N"] = "Her iki ortaklar canlı olduğu yer canlı veya çiftler olan kişileri göster.";
$pgv_lang["button_DEAT_W"] = "Sadece ortak evlilik çiftlerin kadın ölüm yerlerini göster.";
$pgv_lang["button_DEAT_Y"] = "Aniden veya her iki ortakları öldüğü yer çiftleri olan kişileri göster.";
$pgv_lang["button_DEAT_Y100"] = "Son 100 yıl içinde ölenleri göster.";
$pgv_lang["button_DEAT_YES"] = "100 yıl önceden ölen kişileri göster.";
$pgv_lang["button_MARR_DIV"] = "Boşanan çiftleri göster.";
$pgv_lang["button_MARR_U"] = "Evlilik biçimi bilinmeyen çiftleri tarihe göre göster.";
$pgv_lang["button_MARR_Y100"] = "Son 100 yıl içinde evlenen çiftleri göster.";
$pgv_lang["button_MARR_YES"] = "100 yıl önceden evlenen çiftleri göster.";
$pgv_lang["button_reset"] = "Listeyi varsayılan olarak sıfırla.";
$pgv_lang["button_SEX_F"] = "Sadece bayanları göster.";
$pgv_lang["button_SEX_M"] = "Sadece erkekleri göster.";
$pgv_lang["button_SEX_U"] = "Sadece cinsiyeti bilinmeyen kişileri göster.";
$pgv_lang["button_TREE_L"] = "Çiftler veya bireylerden «ayrılan» göster. Bunlar canlı olan bireylerdir ama veri tabanında kaydediler hiç çocukları yok.";
$pgv_lang["button_TREE_R"] = "Çiftler veya bireyler «kökleri» göster. Bu kişiler aynı zamnada aile «reisi» adlandırabilir. Veritabanında keydedilen hiç ebeveynlere sahip olmayan bireylerdir.";
$pgv_lang["sort_column"] = "Buna göre sırala.";
$pgv_lang["sort_column"] = "Buna göre sırala";

//$pgv_lang["add_main_block"]		= "Ana bölüme bir kutu ekle...";
//$pgv_lang["add_right_block"]		= "Sağ bölüme bir kutu ekle...";
//$pgv_lang["gedcom_title"]		= "Bu GEDCOM-Dosyasının içeriğini belirleyen bir başlık belirleyin:";
//$pgv_lang["date_format"]		= "Tarih biçimi";

if (file_exists( "languages/lang.tr.extra.php")) require  "languages/lang.tr.extra.php";

$pgv_lang["hebrew_surn"]			= "Ibranice Soyad";
$pgv_lang["hebrew_givn"]			= "Belirlenmiş Ibranice İsim";
$pgv_lang["include"]				= "İçer:";
$pgv_lang["page_x_of_y"]				= "Sayfa #GLOBALS[currentPage]# son #GLOBALS[lastPage]#";
$pgv_lang["upload_replacement"]		="Yenisini Yükle";
$pgv_lang["roman_surn"]				= "Latin harfle Soyadı";
$pgv_lang["roman_givn"]				= "Latin Harfle Verilen Adı";
$pgv_lang["search_place_word"]		= "Sadece tüm kelime";
$pgv_lang["changes_report"]			= "Değiştirilenlerin Raporu";
$pgv_lang["changedate2"]			= "Değişenlerin başlama tarihi";
$pgv_lang["changedate1"]			= "Değişenlerin bitiş tarihi";
$pgv_lang["chart_type"]				= "Çizim Tipi";
?>
