<?php
/**
 * Italian Language file
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2002 to 2005  Fabio Parri, Lorenzo
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *
 * @author Lorenzo Simionato, Fabio Parri
 * @package PhpGedView
 * @subpackage Languages
 * @version $Id: lang.it.php 1777 2007-09-30 20:43:59Z fisharebest $
 */

if (stristr($_SERVER["SCRIPT_NAME"], basename(__FILE__))!==false) {
	print "You cannot access a language file directly.";
	exit;
}

//-- GENERAL HELP MESSAGES
$pgv_lang["qm"]    = "?";
$pgv_lang["qm_ah"]     = "?";
$pgv_lang["page_help"]    = "Aiuto";
$pgv_lang["help_for_this_page"]  = "Aiuto di questa pagina";
$pgv_lang["help_contents"]   = "Contenuti";
$pgv_lang["hide_context_help"]  = "Nascondi aiuto contestuale";
$pgv_lang["resolution"] 			= "Risoluzione Schermo";
$pgv_lang["sorry"]					= "<b>Spiacente, l'aiuto per questa pagina o questo oggeto non è ancora disponibile.</b>";
$pgv_lang["login_head"]    = "PhpGedView Login Utenti";
$pgv_lang["show_context_help"]  = "Mostra aiuto contestuale";
//-- CONFIG FILE MESSAGES
$pgv_lang["error_header_write"] 	= "Il file GEDCOM, <b>#GEDCOM#</b>, non è scrivibile. Per favore controlla i permessi.";
$pgv_lang["error_title"]   = "ERRORE: Impossibile aprire il file GEDCOM";
$pgv_lang["error_header"]   = "Il file GEDCOM, <b>#GEDCOM#</b>, non esiste nella posizione specificata.";
$pgv_lang["for_support"]  = "Per informazioni tecniche e supporto contattare";
$pgv_lang["for_all_contact"]  = "Per informazioni tecniche o domande sulla genealogia contattare";
$pgv_lang["for_contact"]  = "Per informazioni sulla genealogia contattare";
$pgv_lang["build_title"]   = "Costruzione dei file di indice in corso";
$pgv_lang["build_error"]  = "Trovato un nuovo file GEDCOM.";
$pgv_lang["please_wait"]  = "Per favore attendere: il file Indice sta venendo aggiornato.";
$pgv_lang["password"]				= "Password";
$pgv_lang["admin"]     = "Amministra";
$pgv_lang["confirm"]    = "Conferma Password";
$pgv_lang["fullname"]    = "Nome Completo";
$pgv_lang["invalid_username"]  = "L'user name contiene caratteri non validi";
$pgv_lang["firstname"]				= "Nome";
$pgv_lang["lastname"]				= "Cognome";
$pgv_lang["choose_gedcom"]  = "Scegli un archivio GEDCOM";
$pgv_lang["login_aut"]    = "Modifica Utente";
$pgv_lang["no"] 					= "No";
$pgv_lang["gedcom_downloadable"] 	= "Il file GEDCOm è scaricabile tramite internet!<br />Confronta la sezione SICUREZZA del file <a href=\"readme.txt\"><b>readme.txt</b></a> per risolvere il problema.";
$pgv_lang["user_contact_method"] = "Metodo di contatto preferito";
$pgv_lang["logged_in_as"]  = "Collegato come";
$pgv_lang["my_pedigree"]  = "Il mio pedigree";
$pgv_lang["yes"]    = "Si";
$pgv_lang["change_theme"]   = "Cambia Tema";
$pgv_lang["add_gedcom"]   = "Aggiungi un altro file GEDCOM";
$pgv_lang["no_support"]   = "Abbiamo rilevato che il tuo browser non supporta gli standard utilizzati da questo sito. La maggior parte dei browser recenti supporta questi standard. Per cortesia aggiorna il tuo browser.";
//-- INDEX (PEDIGREE_TREE) FILE MESSAGES
$pgv_lang["index_header"]  = "Albero genealogico";
$pgv_lang["gen_ped_chart"] = "#PEDIGREE_GENERATIONS# Tabella delle Generazioni";
$pgv_lang["generations"]  = "Generazioni";
$pgv_lang["view"]     = "Visualizza";
$pgv_lang["fam_spouse"]  = "Famiglia con coniuge";
$pgv_lang["root_person"]	= "ID persona";
$pgv_lang["hide_details"]	= "Nascondi i dettagli";
$pgv_lang["show_details"]	= "Mostra i dettagli";
$pgv_lang["person_links"]	= "Collegamento ai grafici, famigliari e parenti stretti di questa persona";
$pgv_lang["zoom_box"]		= "Zoom IN/OUT";
$pgv_lang["orientation"]			= "Orientamento";
$pgv_lang["portrait"]				= "In altezza";
$pgv_lang["landscape"]				= "In larghezza";
$pgv_lang["start_at_parents"]		= "Inizia dai genitori";
$pgv_lang["charts"] 				= "Diagrammi";
$pgv_lang["welcome_page"]			= "Pagina di Benvenuto";
$pgv_lang["box_width"] 				= "Grandezza riquadro";
$pgv_lang["lists"]					= "Liste";
//-- FUNCTIONS FILE MESSAGES
$pgv_lang["unable_to_find_family"]	= "Impossibile trovare una famiglia con questo ID";
$pgv_lang["unable_to_find_indi"]		= "Impossibile trovare una persona con questo ID";
$pgv_lang["unable_to_find_record"]	= "Impossibile trovare un record con questo ID";
$pgv_lang["unable_to_find_source"]	= "Impossibile trovare una fonte con questo ID";
$pgv_lang["unable_to_find_repo"]	= "Impossibile trovare un repository con questo ID";
$pgv_lang["repo_name"]					= "Nome dell'Archivio:";
$pgv_lang["address"]							= "Indirizzo:";
$pgv_lang["phone"]							= "Telefono:";
$pgv_lang["source_name"]					= "Nome della Fonte:";
$pgv_lang["title"]								= "Titolo:";
$pgv_lang["author"]							= "Autore:";
$pgv_lang["publication"]					= "Pubblicazione:";
$pgv_lang["call_number"]					= "Numero:";
$pgv_lang["living"]								= "In vita";
$pgv_lang["private"]			= "Privato";
$pgv_lang["birth"]								= "Nascita:";
$pgv_lang["death"]								= "Morte:";
$pgv_lang["descend_chart"]				= "Tabella dei Discendenti";
$pgv_lang["individual_list"]				= "Lista delle Persone";
$pgv_lang["family_list"]					= "Lista delle Famiglie";
$pgv_lang["source_list"]					= "Lista delle Fonti";
$pgv_lang["place_list"]						= "Gerarchia dei Luoghi";
$pgv_lang["media_list"]						= "Lista degli Oggetti Multimediali";
$pgv_lang["search"]							= "Cerca";
$pgv_lang["clippings_cart"]				= "Carrello Ritagli dell'Albero Genealogico";
$pgv_lang["total_queries"]			= "Totale Query al Database";
$pgv_lang["not_an_array"]				= "Non e' un'array";
$pgv_lang["print_preview"]				= "Versione Stampabile";
$pgv_lang["change_lang"]					= "Cambia Lingua";
$pgv_lang["print"]				= "Stampa";
$pgv_lang["back"]				= "Indietro";
//-- INDIVUDUAL FILE MESSAGES
$pgv_lang["male"]					= "Maschio";
$pgv_lang["female"]				= "Femmina";
$pgv_lang["temple"]				= "Tempio della Chiesa Mormone";
$pgv_lang["temple_code"]		= "Codice della Chiesa Mormone:";
$pgv_lang["status"]				= "Stato";
$pgv_lang["PN"] 					= "(sconosciuta)";
$pgv_lang["unrecognized_code_msg"]	= "Questo è un errore, e vorremo sistemarlo. Per favore notificalo a";
$pgv_lang["source"]				= "Fonte:";
$pgv_lang["citation"]				= "Citazione:";
$pgv_lang["text"]					= "Testo:";
$pgv_lang["note"]					= "Nota";
$pgv_lang["NN"] 					= "(sconosciuto)";
$pgv_lang["unrecognized_code"]	= "Codice GEDCOM sconosciuto";
$pgv_lang["indi_info"]			= "Informazione Individuale";
$pgv_lang["pedigree_chart"]	= "Albero genealogico";
$pgv_lang["desc_chart2"]		= "Discendente";
$pgv_lang["family_with"]			= "Famiglia con";
$pgv_lang["family"]				= "Famiglia";
$pgv_lang["as_spouse"]			= "Famiglia con coniuge";
$pgv_lang["as_child"]				= "Famiglia con i genitori";
$pgv_lang["view_gedcom"]	= "Visualizza il campo<br />GEDCOM";
$pgv_lang["add_to_cart"]		= "Aggiungi al<br />Carrello Ritagli";
$pgv_lang["still_living_error"]	= "Questa persona è ancora in vita oppure non ha una data di nascita o di morte registrata.  I dettagli delle persone ancora in vita non sono visualizzabili pubblicamente.<br />Per maggiori informazioni contattare";
$pgv_lang["privacy_error"]	    = "I dettagli di questa persona sono privati.";
$pgv_lang["more_information"]		= "Per maggiori informazioni contattare";
$pgv_lang["name"]					= "Nome:";
$pgv_lang["given_name"]		= "Nome proprio:";
$pgv_lang["surname"]			= "Cognome:";
$pgv_lang["suffix"]					= "Suffisso:";
$pgv_lang["object_note"]		= "Nota sull'Oggetto:";
$pgv_lang["sex"]						= "Sesso";
$pgv_lang["personal_facts"]	= "Fatti e Dettagli personali";
$pgv_lang["type"]					= "Tipo";
$pgv_lang["date"]					= "Data";
$pgv_lang["place_description"]	= "Posto / Descrizione";
$pgv_lang["no_tab2"]				= "Non ci sono note per questa persona.";
$pgv_lang["no_tab3"]				= "Non ci sono Fonti per questa persona.";
$pgv_lang["no_tab4"]				= "Non ci sono oggetti multimediali per questa persona.";
$pgv_lang["parents"] 			= "Genitori:";
$pgv_lang["link_as"]			= "Collega questa persona a una famiglia esistente come";
$pgv_lang["foster"]			= "Tutela";
$pgv_lang["adopted"]			= "Adottato";
$pgv_lang["surnames"]			= "Cognomi";
$pgv_lang["spouse"]				= "Coniuge";
$pgv_lang["child"]				= "Bambino";
$pgv_lang["relatives"]			= "Parenti stretti";
$pgv_lang["mother"] 			= "Madre";
$pgv_lang["parent"] 				= "Genitore";
$pgv_lang["father"] 			= "Padre";
$pgv_lang["siblings"] 			= "Fratello";
//-- FAMILY FILE MESSAGES
$pgv_lang["family_info"]				= "Informazioni sulla Famiglia";
$pgv_lang["family_group_info"]	= "Informazione sul Gruppo famigliare";
$pgv_lang["husband"]					= "Marito:";
$pgv_lang["wife"]							= "Moglie:";
$pgv_lang["marriage"]					= "Matrimonio:";
$pgv_lang["lds_sealing"]				= "Suggellatura Mormone:";
$pgv_lang["marriage_license"]		= "Licenza di Matrimonio:";
$pgv_lang["media_object"]				= "Oggetto Multimediale:";
$pgv_lang["children"]						= "Figli";
$pgv_lang["no_children"]				= "Nessun figlio";
$pgv_lang["parents_timeline"]			= "Mostra i genitori sulla<br />tabella temporale";
//-- CLIPPINGS FILE MESSAGES
$pgv_lang["clip_cart"]					= "Carrello Ritagli";
$pgv_lang["clip_explaination"]		= "Il Carrello Ritagli dell'Albero Genealogico permette di effettuare &quot;ritagli&quot; su questo albero genealogico e di inserirli in un unico file GEDCOM scaricabile.<br /><br />";
$pgv_lang["item_with_id"]			= "Elemento con id";
$pgv_lang["error_already"]			= "e' nel tuo carrello ritagli.";
$pgv_lang["which_links"]				= "Che legami di questa famiglia si vorrebbero ancora aggiungere?";
$pgv_lang["just_family"]				= "Aggiungere solo questa persona";
$pgv_lang["parents_and_family"]	= "Aggiungere i genitori con questa famiglia.";
$pgv_lang["parents_and_child"]	= "Aggiungere i genitori e i figli a questo record di famiglia.";
$pgv_lang["parents_desc"]				= "Aggiungere i genitori e tutti i discendenti a questo record di famiglia.";
$pgv_lang["continue"]					= "Continuare ad aggiungere";
$pgv_lang["which_p_links"]			= "Che legami di questa persona si vorrebbero ancora aggiungere?";
$pgv_lang["just_person"]				= "Aggiungere solo questa persona.";
$pgv_lang["person_parents_sibs"]= "Aggiungere questa persona, i suoi genitori e i suoi fratelli e sorelle.";
$pgv_lang["person_ancestors"]		= "Aggiungere questa persona e i suoi antenati in linea diretta.";
$pgv_lang["person_ancestor_fams"]="Aggiungere questa persona, i suoi antenati in linea diretta e le loro famiglie.";
$pgv_lang["person_spouse"]			= "Aggiungere questa persona, la sua sposa, e i bambini.";
$pgv_lang["person_desc"]				= "Aggiungere questa persona, la sua sposa e tutti i registri dei discendenti.";
$pgv_lang["unable_to_open"]		= "Impossibile aprire la cartella dei ritagli in scrittura";
$pgv_lang["options"]				= "Opzioni:";
$pgv_lang["family_private"] 		= "I dettagli della famiglia sono privati e pertanto non saranno inclusi.";
$pgv_lang["person_living"]			= "Questa persona e' ancora in vita.  I dettagli personali non verranno pertanto inclusi.";
$pgv_lang["person_private"]			= "I dettagli di questa persona sono privati. I dettagli personali non saranno inclusi";
$pgv_lang["download"]					= "Right click (control-click sui Mac) sui collegamenti e selezionare &quot;Salva oggetto con nome...&quot; per scaricare i file.";
$pgv_lang["latest"]						= "Stai utilizzando l'ultima versione di PhpGedView.";
$pgv_lang["location"]					= "Posizione dei file di aggiornamento:";
$pgv_lang["inc_languages"]		= "Lingue";
$pgv_lang["inc_config"]    = "File di configurazione";
$pgv_lang["inc_index"]    = "File di indice";
$pgv_lang["inc_themes"]    = "Temi";
$pgv_lang["inc_docs"]     = "Manuali";
$pgv_lang["inc_privacy"]   = "File della privacy";
$pgv_lang["inc_backup"] 			= "Crea Backup";
$pgv_lang["upgrade_help"]			= "Aiuto";
$pgv_lang["cannot_read"]   = "Non posso leggere il file:";
$pgv_lang["not_configured"]  = "Non hai ancora configurato PhpGedView";
$pgv_lang["location_upgrade"] = "Immetti la posizione del tuo file di aggiornamento.";
$pgv_lang["new_variable"]   = "Trovata nuova variabile:";
$pgv_lang["config_open_error"] = "C'e' stato un errore aprendo il file di configurazione.";
$pgv_lang["config_write_error"] = "Errore!!! Non posso scrivere nel file di configurazione.";
$pgv_lang["config_uptodate"] = "Il file di configurazione e' aggiornato.";
$pgv_lang["config_update_ok"] = "File di configurazione aggiornato con successo.";
$pgv_lang["stat_average_children"]	= "Numero medio di figli per famiglia";
$pgv_lang["stat_most_children"]		= "Famiglia con più figli";
$pgv_lang["stat_avg_age_at_death"]	= "Età media di morte";
$pgv_lang["stat_longest_life"]		= "Persona più longeva";
$pgv_lang["stat_longest_life"]		= "Persone più longeve";
$pgv_lang["stat_users"]				= "Utenti totali";
$pgv_lang["add_favorite"]			= "Aggiungi un preferito";
$pgv_lang["add_fav_enter_id"]		= "Inserisci una persona, famiglia o una fonte";
$pgv_lang["stat_events"]			= "Eventi totali";
$pgv_lang["stat_media"]				= "Oggetti multimediali";
$pgv_lang["stat_surnames"]			= "Cognomi totali";
$pgv_lang["privacy_open_error"] = "C'e' stato un errore aprendo il file della privacy [#PRIVACY_MODULE#] file";
$pgv_lang["privacy_update_ok"] = "Il file della privacy: [#PRIVACY_MODULE#] e' stato aggiornato con successo.";
$pgv_lang["heading_privacy"] = "File della privacy:";
$pgv_lang["page"]     = "Pagina";
$pgv_lang["heading_phpgedview"] = "File di PhpGedView:";
$pgv_lang["sort_by"]    = "Ordina per";
$pgv_lang["make_slklist"]   = "Create lista EXCEl (SLK)";
$pgv_lang["slk_list"]    = "Lista EXCEL SLK";
$pgv_lang["merge_step3"]   = "Unione Passo 3 di 3";
$pgv_lang["select_gedcom_records"]	= "Seleziona due record da fondere. Devono essere dello stesso tipo.";
$pgv_lang["unmatching_facts"]		= "I seguenti fatti non corrispondono. Seleziona le infomrazioni che vuoi mantenere.";
$pgv_lang["merge_more"] 			= "Fondi altri dati.";
$pgv_lang["merge_facts_same"]		= "I seguenti fatti sono esattamente uguali in entrambi i dati e saranno uniti automaticamente.";
$pgv_lang["no_matches_found"]		= "Nessun fatto trovato";
$pgv_lang["merge_to"]				= "Fondi a ID:";
$pgv_lang["merge_from"] 			= "Fondi da ID:";
$pgv_lang["ancestry_booklet"]    = "Libro Antenati";
$pgv_lang["ancestry_list"]   = "Lista Antenati";
$pgv_lang["chart_style"]			= "Stile diagramma";
$pgv_lang["ancestry_chart"]   = "Grafico Antenati";
$pgv_lang["show_cousins"]   = "Mostra cugini";
$pgv_lang["merge_step2"]   = "Unione Passo 2 di 3";
$pgv_lang["merge_step1"]   = "Unione Passo 1 di 3";
$pgv_lang["heading_image"]   = "File delle immagini:";
$pgv_lang["heading_index"]    = "File degli indici:";
$pgv_lang["heading_language"]  = "File dei linguaggi:";
$pgv_lang["heading_theme"]   = "File dei temi:";
$pgv_lang["heading_docs"]    = "Manuali:";
$pgv_lang["reports"]    = "Report";
$pgv_lang["pdf_reports"]			= "Report in PDF";
$pgv_lang["family_group_report"]	= "Report Famiglia";
$pgv_lang["enter_famid"]			= "Inserisci ID Famiglia";
$pgv_lang["generated_by"]			= "Generato da";
$pgv_lang["birthdate2"]				= "Data di nascita massima";
$pgv_lang["birthdate1"]				= "Data di nascita minima";
$pgv_lang["birthplace"]				= "Luogo di Nascita contiene";
$pgv_lang["birth_report"]			= "Report Data e luogo di nascita";
$pgv_lang["show_notes"] 			= "Mostra note?";
$pgv_lang["show_photos"]			= "Mostra foto?";
$pgv_lang["show_sources"]			= "Mostra Fonti?";
$pgv_lang["of"]      = "di";
$pgv_lang["enter_pid"]				= "Inserisci ID Persona";
$pgv_lang["individual_report"]  = "Report persona";
$pgv_lang["merge_records"]   = "Fondi Dati";
$pgv_lang["merge_same"] 			= "I record non sono dello stesso tipo. Impossibile fondere dati di tipo diverso.";
$pgv_lang["statistics"]    = "Statistiche";
$pgv_lang["sosa_3"]     = "Madre";
$pgv_lang["sosa_2"]     = "Padre";
$pgv_lang["sosa_5"]     = "Nonna";
$pgv_lang["stat_301_mf"]    = "maschio/femmina";
$pgv_lang["statsubmit"]			 = "mostra il grafico";
$pgv_lang["stpltype"]    = "tipo:";
$pgv_lang["is_alive_in"]   = "E' vivo nel #YEAR#";
$pgv_lang["manage_media"]			= "Amministra Media";
$pgv_lang["alive"]     = "Vivo";
$pgv_lang["add_directory"]   = "Aggiungi directory";
$pgv_lang["to_source"]			= "A Fonte";
$pgv_lang["to_family"]			= "A Famiglia";
$pgv_lang["to_person"]			= "A Persona";
$pgv_lang["stplperc"]    = "percento";
$pgv_lang["dead"]     = "Morto";
$pgv_lang["click_here"]				= "Clicca qui per continuare";
$pgv_lang["display_all"]			= "Mostra tutto";
$pgv_lang["accesskey_skip_to_content_desc"]	= "Vai ai contenuti";
$pgv_lang["faq_list"] = "Lista FAQ";
$pgv_lang["preview"] =  "Anteprima";
$pgv_lang["hs_search"] 			= "Cerca";
$pgv_lang["hs_close"] 			= "Chiudi finestra";
$pgv_lang["hs_searchconfig"]	= "Aiuto";
$pgv_lang["hs_searchall"]		= "Tutte le parole";
$pgv_lang["hs_searchany"]		= "Qualsiasi parola";
$pgv_lang["hs_inallhelp"]		= "Tutto il testo";
$pgv_lang["confirm_folder_delete"] = "Vuoi veramente cancellare questa cartella?";
$pgv_lang["choose"] = "Scegli:";
$pgv_lang["account_information"] = "Informazioni sull'account";
$pgv_lang["TYPE__audio"] = "Audio";
$pgv_lang["TYPE__book"] = "Libro";
$pgv_lang["fan_chart"]				= "Diagramma Circolare";
$pgv_lang["compact_chart"]			= "Grafico Compatto";
$pgv_lang["TYPE__card"] = "Carta";
$pgv_lang["TYPE__certificate"] = "Certificato";
$pgv_lang["TYPE__document"] = "Documento";
$pgv_lang["TYPE__electronic"] = "Elettronico";
$pgv_lang["TYPE__film"] = "Microfilm";
$pgv_lang["TYPE__magazine"] = "Rivista";
$pgv_lang["TYPE__manuscript"] = "Manoscritto";
$pgv_lang["TYPE__map"] = "Mappa";
$pgv_lang["TYPE__newspaper"] = "Giornale";
$pgv_lang["TYPE__photo"] = "Foto";
$pgv_lang["TYPE__tombstone"] = "Lapide";
$pgv_lang["TYPE__video"] = "Video";
$pgv_lang["stplmonth"]    = "mese";
$pgv_lang["stat_202_perc"]			 = "percentuale";
$pgv_lang["stplage"]    = "età";
$pgv_lang["alive_in_year"]   = "Vivi nel";
$pgv_lang["stat_21_nok"]    = "numero di figli.";
$pgv_lang["stat_11_mb"]    = "Mese di nascita";
$pgv_lang["sosa_8"] = "Bisnonno";
$pgv_lang["sosa_10"]				= "Bisnonno";
$pgv_lang["sosa_17"]				= "Trisavola";
$pgv_lang["sosa_41"]			   = "Quadrisavola";
$pgv_lang["sosa_43"]			   = "Quadrisavola";
$pgv_lang["sosa_42"]			   = "Quadrisavolo";
$pgv_lang["sosa_61"]			   = "Quadrisavola";
$pgv_lang["sosa_60"]			   = "Quadrisavolo";
$pgv_lang["sosa_63"]			   = "Quadrisavola";
$pgv_lang["sosa_58"]			   = "Quadrisavolo";
$pgv_lang["sosa_59"]			   = "Quadrisavola";
$pgv_lang["sosa_62"]			   = "Quadrisavolo";
$pgv_lang["sosa_57"]			   = "Quadrisavola";
$pgv_lang["sosa_54"]			   = "Quadrisavolo";
$pgv_lang["sosa_55"]			   = "Quadrisavola";
$pgv_lang["sosa_52"]			   = "Quadrisavolo";
$pgv_lang["sosa_51"]			   = "Quadrisavola";
$pgv_lang["sosa_56"]			   = "Quadrisavolo";
$pgv_lang["sosa_50"]			   = "Quadrisavolo";
$pgv_lang["sosa_47"]			   = "Quadrisavola";
$pgv_lang["sosa_49"]			   = "Quadrisavola";
$pgv_lang["sosa_46"]			   = "Quadrisavolo";
$pgv_lang["sosa_45"]			   = "Quadrisavola";
$pgv_lang["sosa_53"]			   = "Quadrisavola";
$pgv_lang["sosa_44"]			   = "Quadrisavolo";
$pgv_lang["sosa_48"]			   = "Quadrisavolo";
$pgv_lang["sosa_32"]			   = "Quadrisavolo";
$pgv_lang["sosa_33"]			   = "Quadrisavola";
$pgv_lang["sosa_40"]			   = "Quadrisavolo";
$pgv_lang["sosa_39"]			   = "Quadrisavola";
$pgv_lang["sosa_38"]			   = "Quadrisavolo";
$pgv_lang["sosa_37"]			   = "Quadrisavola";
$pgv_lang["sosa_36"]			   = "Quadrisavolo";
$pgv_lang["sosa_35"]			   = "Quadrisavola";
$pgv_lang["sosa_34"]			   = "Quadrisavolo";
$pgv_lang["sosa_28"]				= "Trisavolo";
$pgv_lang["sosa_30"]				= "Trisavolo";
$pgv_lang["sosa_29"]				= "Trisavola";
$pgv_lang["sosa_31"]				= "Trisavola";
$pgv_lang["sosa_25"]				= "Trisavola";
$pgv_lang["sosa_27"]				= "Trisavola";
$pgv_lang["sosa_26"]				= "Trisavolo";
$pgv_lang["sosa_20"]				= "Trisavolo";
$pgv_lang["sosa_21"]				= "Trisavola";
$pgv_lang["sosa_23"]				= "Trisavola";
$pgv_lang["sosa_24"]				= "Trisavolo";
$pgv_lang["sosa_22"]				= "Trisavolo";
$pgv_lang["sosa_19"]				= "Trisavola";
$pgv_lang["sosa_18"]				= "Trisavolo";
$pgv_lang["sosa_16"]				= "Trisavolo";
$pgv_lang["sosa_14"]				= "Bisnonno";
$pgv_lang["sosa_15"]				= "Bisnonna";
$pgv_lang["sosa_13"]				= "Bisnonna";
$pgv_lang["sosa_11"]				= "Bisnonna";
$pgv_lang["sosa_12"]				= "Bisnonno";
$pgv_lang["sosa_9"] 				= "Bisnonna";
$pgv_lang["twin"] = "Gemello";
$pgv_lang["backup_copied_success"]	= "file di backup creato con successo.";
$pgv_lang["friend"] = "Amico";
$pgv_lang["sosa_7"]     = "Nonna";
$pgv_lang["sosa_6"]     = "Nonno";
$pgv_lang["sosa_4"]     = "Nonno";
$pgv_lang["copied_success"]   = "copiato con successo.";
$pgv_lang["order"]     = "Ordina";
$pgv_lang["hourglass_chart"]		= "Grafico a clessidra";
$pgv_lang["download_report"]		= "Scarica Report";
$pgv_lang["select_report"]			= "Seleziona Report";
$pgv_lang["run_report"] 			= "Visualizza Report";
$pgv_lang["selected_report"]		= "Report Selezionato";
$pgv_lang["enter_report_values"]	= "Inserisci i valori del report";
$pgv_lang["choose_report"]			= "Seleziona un report da lanciare";
$pgv_lang["do_not_change"]   = "Non cambiare";
$pgv_lang["change_id"]				= "Modifica ID Persona in:";
$pgv_lang["upgrade_completed"]  = "Aggiornamento completato con successo";
$pgv_lang["folder_created"]   = "Creata cartella";
$pgv_lang["media_files"]    = "File multimediali a cui si fa riferimento in questo GEDCOM";
$pgv_lang["cart_is_empty"]   = "Il carrello ritagli dell'albero e' vuoto.";
$pgv_lang["id"]        = "ID";
$pgv_lang["name_description"]  = "Nome / Descrizione";
$pgv_lang["remove"]      = "Rimuovere";
$pgv_lang["empty_cart"]    = "Carrello vuoto";
$pgv_lang["download_now"]   = "Scaricare";
//-- PLACELIST FILE MESSAGES
$pgv_lang["total_unic_places"]  = "Totale luoghi unici";
$pgv_lang["show_place_list"]  = "Mostra tutti i luoghi in una lista";
$pgv_lang["total_unic_places"]  = "Totoale posti unici";
$pgv_lang["show_place_list"]  = "Mostra tutti i posti in una lista";
$pgv_lang["search_general"]			= "Ricerca Generale";
$pgv_lang["connections"]				= "Trovate connessioni a questi luoghi<br />Visualizzare i risultati";
$pgv_lang["top_level"]					=	"Livello superiore";
$pgv_lang["place_list2"] 			= "Lista dei posti";
$pgv_lang["repo_list"]				= "Lista Archivi";
$pgv_lang["form"]							= "I luoghi sono codificati nella seguente forma:";
$pgv_lang["default_form"]				= "Citta' , Frazione, Stato/Provincia, Nazione";
$pgv_lang["unknown"]					= "Sconosciuto";
$pgv_lang["individuals"]			= "Persone";
//-- MEDIALIST FILE MESSAGES
$pgv_lang["multi_title"]					= "Lista degli oggetti multimediali";
$pgv_lang["media_found"]				= "Oggetti multimediali trovati";
$pgv_lang["per_page"]				= "oggetti multimediali per pagina";
$pgv_lang["medialist_show"] 		= "Mostra";
$pgv_lang["view_person"]				= "Visualizza Persona";
$pgv_lang["view_family"]				= "Visualizza Famiglia";
$pgv_lang["view_source"]				= "Visualizza Fonte";
$pgv_lang["file_not_found"]				= "File non trovato";
$pgv_lang["prev"]						= "<Precedente";
$pgv_lang["next"]						= "Successivo>";
$pgv_lang["prev"]						= "Precedente";
//-- SEARCH FILE MESSAGES
$pgv_lang["search_gedcom"]			= "Cerca nel file GEDCOM";
$pgv_lang["enter_terms"]				= "Inserire i termini della ricerca:";
$pgv_lang["soundex_search"]			= "- O Cerca il nome come penso si scirva (Soundex):";
$pgv_lang["search_results"]			= "Risultati della Ricerca";
$pgv_lang["sources"]						= "FONTI";
$pgv_lang["firstname_search"]			= "Nome:";
$pgv_lang["no_results"]				= "Nessun risultato trovato";
$pgv_lang["soundex_results"]		= "Forse i campi soundex seguenti potrebbero esserti utili";
$pgv_lang["lastname_search"]			= "Cognome:";
$pgv_lang["find_source"]			= "Trova Fonti";
$pgv_lang["search_place"]				= "Luogo:";
$pgv_lang["titles_found"]			= "Titoli";
$pgv_lang["search_year"]				= "Anno:";
$pgv_lang["lastname_empty"]			= "Prego, inserire un cognome.";
//-- SOURCELIST FILE MESSAGES
$pgv_lang["total_sources"]			= "Totale Fonti";
$pgv_lang["sources_found"]			= "Trovate fonti";
//-- SOURCE FILE MESSAGES
$pgv_lang["source_info"]				= "Informazioni sulla Fonte";
$pgv_lang["other_records"]			= "Altri Record che puntano alla Fonte:";
$pgv_lang["people"]						= "GENTE";
$pgv_lang["families"]						= "FAMIGLIE";
//-- BUILDINDEX FILE MESSAGES
$pgv_lang["building_indi"]				= "Indice delle Persone e delle Famiglie in costruzione";
$pgv_lang["building_index"]			= "Costruzione delle Liste indice";
$pgv_lang["time_limit"]				= "Tempo limite:";
$pgv_lang["importing_records"]		= "Sto importando i record nel database";
$pgv_lang["detected_change"]			= "PhpGedView ha riscontrato delle modifiche nel file GEDCOM \$GEDCOM.  Occorre aggiornare gli gli archivi degli indici prima di procedere.";
$pgv_lang["please_be_patient"]		= "UN ATTIMO DI PAZIENZA PER FAVORE";
$pgv_lang["tables_exist"]			= "Le tabelle di PhpGedView esistono già nel database";
$pgv_lang["reading_file"]				= "Lettura del file GEDCOM in corso";
$pgv_lang["flushing"]						= "Aggiornamento dei contenuti";
$pgv_lang["found_record"]			= "Recordo trovato";
$pgv_lang["exec_time"]					= "Totale tempo impiegato:";
$pgv_lang["unable_to_create_index"]="Assicurarsi che la cartella di PhpGedview abbia i permessi di scrittura attivati. I permessi possono essere riportati alle condizioni originarie una volta che i file indice siano stati scritti.";
$pgv_lang["indi_complete"]			= "Aggiornamento dell'indice della persona completato.";
$pgv_lang["family_complete"]		= "Aggiornamento dell'Indice delle famiglie completato.";
$pgv_lang["source_complete"]		= "Aggiornamento dell'Indice delle fonti completato.";
$pgv_lang["drop_tables"]			= "Cancella le tabelle correnti";
$pgv_lang["import_progress"]		= "Stato importazione...";
$pgv_lang["bytes_read"] 			= "Byte letti:";
$pgv_lang["created_indis_fail"] 	= "Impossibile creare la tabella <i>Individui</i>.";
$pgv_lang["created_indis"]			= "Creata con successo la tabella <i>Individui</i>,";
$pgv_lang["import_complete"]		= "Importazione completata";
$pgv_lang["click_here_to_go_to_pedigree_tree"] = "Clicca qui per andare all'albero genealogico";
$pgv_lang["index_complete"]			= "Indice completato.";
$pgv_lang["dataset_exists"]			= "Un file GEDCOM con questo nome e' gia' stato importato nell'archivio";
$pgv_lang["empty_dataset"]			= "Vuoi cancellare i vecchi dati e sovrascriverli con i nuovi?";
$pgv_lang["gedcom_title"]			= "Immetti un titolo che descrive i dati in questo file GEDCOM";
$pgv_lang["path_to_gedcom"]			= "Immetti il percorso del tuo file GEDCOM";
$pgv_lang["you_may"]				= "Tu puoi:";
$pgv_lang["show_surnames"]			= "Raggruppa i cognomi";
$pgv_lang["skip_surnames"]			= "Non raggruppare i cognomi";
//-- INDIVIDUAL AND FAMILYLIST FILE MESSAGES
$pgv_lang["total_fams"]					= "Totale Famiglie";
$pgv_lang["total_indis"]					= "Persone Totali";
$pgv_lang["all"]					= "TUTTO";
$pgv_lang["find_specialchar"]		= "Trova Caratteri Speciali";
$pgv_lang["find_familyid"]			= "Trova ID Famiglia";
$pgv_lang["hidden"]					= "Nascosto";
$pgv_lang["confidential"]			= "Confidenziale";
$pgv_lang["find_individual"]		= "Trova ID Persona";
$pgv_lang["filter"]					= "Filtra";
$pgv_lang["name_contains"]			= "Il nome contiene";
$pgv_lang["notes_sources_media"]	= "Note, fonti e immagini";
$pgv_lang["ssourcess"]				= "Fonti";
$pgv_lang["notes"]					= "Note";
$pgv_lang["starts_with"]				= "Inizia con:";
$pgv_lang["person_list"]				= "Lista delle Persone:";
$pgv_lang["paste_person"]			= "Incollare Persona";
//-- TIMELINE FILE MESSAGES
$pgv_lang["age"]								= "Eta'";
$pgv_lang["validate_gedcom"]		= "Valida GEDCOM";
$pgv_lang["step4"]					= "Passo 4 di 4:";
$pgv_lang["step3"]					= "Passo 3 di 4:";
$pgv_lang["phpinfo"]				= "Informazioni su PHP";
$pgv_lang["add_media_button"]		= "Aggiungi Media";
$pgv_lang["step2"]					= "Passo 2 di 4:";
$pgv_lang["step1"]					= "Passo 1 di 4:";
$pgv_lang["timeline_title"]				= "Scala Temporale di PhpGedView";
$pgv_lang["timeline_chart"]			= "Scala Temporale";
$pgv_lang["upgrade"]				= "Aggiorna PhpGedView";
$pgv_lang["remove_person"]			= "Rimuovi questa persona";
$pgv_lang["show_age"]					= "Mostrare il marcatore d'eta'";
$pgv_lang["from"]			= "da";
$pgv_lang["logfile_content"]		= "Contenuto del file di log";
$pgv_lang["to"]				= "fino a";
$pgv_lang["select_an_option"]		= "Seleziona un'opzione:";
$pgv_lang["readme_documentation"]	= "File README";
$pgv_lang["configuration"]			= "Configurazione";
$pgv_lang["view_logs"]				= "Visualizza file di log";
$pgv_lang["rebuild_indexes"]		= "Ricostruisci l'indice";
$pgv_lang["user_manual"]		= "Manuale utente di PhpGedView";
$pgv_lang["pgv_registry"]			= "Visualizza altri siti che utilizzano PhpGedView";
$pgv_lang["admin_site"]				= "Amministrazione Sito";
$pgv_lang["admin_geds"]				= "Amministrazioni Dati e GEDCOM";
$pgv_lang["add_new_gedcom"] 		= "Crea un nuovo GEDCOM";
$pgv_lang["admin_info"]				= "Informazioni";
$pgv_lang["upload_help"]		= "Scegli un file dal tuo computer. Tutti i file saranno caricati nella directory:";
$pgv_lang["upload_error"]			= "C'è stato un errore caricando il file GEDCOM";
$pgv_lang["file_missing"]		= "Nessun file ricevuto, per favore riprova";
$pgv_lang["file_partial"]		= "Il file e' stato caricato solo parzialmente, per favore prova ancora";
$pgv_lang["file_too_big"]		= "I file caricati superano la dimensione massima consentita";
$pgv_lang["file_success"]		= "File caricato con successo";
$pgv_lang["gedcom_file"]		= "File GEDCOM";
$pgv_lang["utf8_to_ansi"]			= "Vuoi convertire da UTF-8 a ANSI (ISO-8859-1)?";
$pgv_lang["new_gedcom_title"]		= "Genealogia da [#GEDCOMFILE#]";
$pgv_lang["upload_gedcom"]		= "Carica file GEDCOM";
$pgv_lang["download_gedcom"]		= "Scarica file GEDCOM";
$pgv_lang["manage_gedcoms"]			= "Amministra il file GEDCOM";
$pgv_lang["administration"] 		= "Amministrazione";
$pgv_lang["rootid"]					= "Persona radice dei diagrammi";
$pgv_lang["user_info"]				= "Informazioni sul mio utente";
$pgv_lang["admin_gedcom"]			= "Amministra GEDCOM";
$pgv_lang["enter_gedcomid"]		= "Devi immettere un ID GEDCOM.";
$pgv_lang["duplicate_username"]		= "Username doppio. Un utente con questo username gia' esiste. Torna indietro e modificalo";
$pgv_lang["gedcomid"]				= "GEDCOM ID";
$pgv_lang["import_gedcom"]			= "Importa questo file GEDCOM";
$pgv_lang["no_login"]				= "impossibile autenticare l'utente";
$pgv_lang["create_user"]			= "Crea un utente";
$pgv_lang["confirm_user_delete"]	= "Sei sicuro di voler cancellare l'utente";
$pgv_lang["can_edit"]				= "Puo' modificare";
$pgv_lang["can_admin"]				= "Puo' amministrare";
$pgv_lang["full_name"]				= "Nome completo";
$pgv_lang["visibleonline"]			= "Visibile dagli altri utenti quando sei online?";
$pgv_lang["edit"]					= "Modifica";
$pgv_lang["save"]			= "Salva";
$pgv_lang["delete"]					= "Elimina";
$pgv_lang["update_user"]			= "Aggiorna utente";
$pgv_lang["update_myaccount"]		= "Aggiorna Account";
$pgv_lang["confirm_password"]		= "Devi confermare la password";
$pgv_lang["enter_fullname"]		= "Devi immettere il nome completo";
$pgv_lang["enter_password"]			= "Devi immettere una password";
$pgv_lang["enter_username"]			= "Devi immettere uno username";
$pgv_lang["password_mismatch"]		= "La password non corrisponde";
$pgv_lang["user_create_error"]		= "Impossibile aggiungere l'utente, per favore torna indietro e riprova";
$pgv_lang["user_created"]			= "Utente creato con successo";
$pgv_lang["user_admin"]				= "Amministrazione utenti";
$pgv_lang["int"]			= "interpretato";
$pgv_lang["est"]			= "stimato";
$pgv_lang["cal"]			= "calcolato";
$pgv_lang["add_another"]				= "Aggiungere un'altra persona al diagramma:<br />ID della persona:";
$pgv_lang["find_id"]						= "Cerca un ID";
$pgv_lang["show"]							= "Visualizza";
$pgv_lang["year"]							= "Anno:";
$pgv_lang["timeline_instructions"]= "Nei browser piu' recenti e' possibile selezionare e trascinare i riquadri.";
$pgv_lang["zoom_out"]				= "Rimpicciolisci";
$pgv_lang["zoom_in"]				= "Ingrandisci";
$pgv_lang["apr"]			= "Aprile";
$pgv_lang["bet"]			= "tra";
$pgv_lang["recent_changes"] 		= "Cambiamenti Recenti";
$pgv_lang["delete_selected_messages"]	= "Cancella i messaggi selezionati";
$pgv_lang["default_news_title"] 	= "Benvenuto nella tua Genealogia";
$pgv_lang["default_news_text"]		= "Le informazioni sulla genealogia di questo sito sono servite da <a href=\"http://www.phpgedview.net/\" target=\"_blank\">PhpGedView #VERSION#</a>. La pagina fornisce un introduzione e una presentazione della genealogia.<br /><br />Per iniziare a lavorare con i dati, selezione uno dei grafici dal menu Diagrammi, vai sulla lista delle persone o seleziona un nome o un posto.<br /><br />Se hai problemi nell'uso del sito, puoi fare click sull'icona di aiuto per avere informazioni su come usare la pagina che stai vedendo.<br /><br />Grazie per la tua visita.";
$pgv_lang["and"]				= "e";
$pgv_lang["bef"]			= "prima";
$pgv_lang["customize_gedcom_page"]	= "Personalizza la pagina di benvenuto del GEDCOM";
$pgv_lang["block_top10_title"]		= "Top 10 Cognomi";
$pgv_lang["add_news"]				= "Aggiungi una News";
$pgv_lang["aft"]			= "dopo";
$pgv_lang["dec"]			= "Dicembre";
$pgv_lang["nov"]			= "Novembre";
$pgv_lang["oct"]			= "Ottobre";
$pgv_lang["sep"]			= "Settembre";
$pgv_lang["aug"]			= "Agosto";
$pgv_lang["jul"]			= "Luglio";
$pgv_lang["jun"]			= "Giugno";
$pgv_lang["message_email3"]		= "Hai inviato il seguente messaggio all'amministratoe di PhpGedView:";
$pgv_lang["confirm_message_delete"]	= "Sei sicuro di voler cancellare questo messaggio? Non sara' piu' possibile recuperarlo.";
$pgv_lang["message_email1"]		= "Il messaggio seguente è stato inviato al tuo utente PhpGedView da ";
$pgv_lang["viewing_url"]		= "Questo messaggio e' stato inviato mentre si guardava la seguente pagina:";
$pgv_lang["messaging2_help"]		= "Appena invierai questo messaggio riceverai una copia via email all'indirizzo che hai fornito.";
$pgv_lang["my_favorites"]		= "I miei preferiti";
$pgv_lang["no_favorites"]		= "Non hai selezionato nessun preferito. Per aggiungere una persona ai tuoi preferiti, cerca i dettagli della persona che vuoi aggiungere e clicca su 'Aggiungi ai miei preferiti', oppure usa il metodo di ricerca per ID.";
$pgv_lang["broadcast_all"]			= "A tutti gli utenti";
$pgv_lang["common_surnames"]		= "Cognomi più comuni";
$pgv_lang["my_favorites"]		= "I miei preferiti";
$pgv_lang["customize_page"] 		= "Personalizza il mio GedView";
$pgv_lang["move_left"]				= "Sinistra";
$pgv_lang["move_right"] 			= "Destra";
$pgv_lang["move_down"]				= "Giù";
$pgv_lang["move_up"]				= "Su";
$pgv_lang["enter_title"]			= "Perfavore inserisci un titolo.";
$pgv_lang["no_news"]				= "Non sono state inserite news.";
$pgv_lang["no_gedcom_favorites"]	= "Al momento non ci sono preferiti selezionati. L'amministratore può aggiungere dei preferiti da mostrare all'avvio.";
$pgv_lang["stat_latest_death"] 	= "Anno di morte più recente";
$pgv_lang["stat_earliest_death"] 	= "Anno di morte più vecchio";
$pgv_lang["stat_latest_birth"] 	= "Anno di nascita più recente";
$pgv_lang["stat_earliest_birth"] 	= "Anno di nascita più vecchio";
$pgv_lang["gedcom_favorites"]		= "I Preferiti del GEDCOM";
$pgv_lang["add_to_my_favorites"]	= "Aggiungi ai miei preferiti";
$pgv_lang["stat_individuals"]		= "Persone, ";
$pgv_lang["stat_other"] 			= "Altri dati";
$pgv_lang["stat_sources"]			= "Fonti, ";
$pgv_lang["stat_families"]			= "Famiglie";
$pgv_lang["gedcom_created_using"]	= "Il GEDCOM è stato creato usando <b>#SOFTWARE# #VERSION#</b>";
$pgv_lang["gedcom_created_on"]		= "Il GEDCOM è stato creato il <b>#DATA</b>";
$pgv_lang["gedcom_created_on2"] 	= " il <b>#DATE#</b>";
$pgv_lang["gedcom_stats"]			= "Statistiche del GEDCOM";
$pgv_lang["confirm_fav_remove"]		= "Sei sicuro di voler rimuovere questo elemento dai tuoi preferiti?";
$pgv_lang["min6chars"]				= "La password deve contenere almeno 6 caratteri";
$pgv_lang["pls_note02"] 			= "Nota: Le password possono contenere lettere, numeri e altri caratteri.";
$pgv_lang["pls_note03"] 			= "Questo indirizzo email sarà verificato prima dell'attivazione dell'account. Non sarà mostrato sul sito. Un messaggio con i tuoi dati di registrazione sarà inviato al tuo indirizzo.";
$pgv_lang["pls_note01"] 			= "Attenzione: Il sistema è case-sensitive!";
$pgv_lang["portal"]			= "Portale";
$pgv_lang["random_picture"]		= "Foto casuale";
$pgv_lang["preferred_lang"] 		= "L'utente preferisce ricevere i messaggi in #USERLANG#";
$pgv_lang["sending_to"] 			= "Questo messaggio sarà inviato a #TO_USER#";
$pgv_lang["no_upgrade"]				= "Non ci sono file da aggiornare.";
$pgv_lang["use_version"]			= "Stai usando la versione:";
$pgv_lang["current_version"]	=	"Versione stabile corrente:";
$pgv_lang["cal_gregorian"] = "Gregoriano";
$pgv_lang["cal_julian"]    = "Giuliano";
$pgv_lang["cal_french"]    = "French";
$pgv_lang["cal_jewish"]    = "Jewish";
$pgv_lang["cal_hebrew"]    = "Ebreo";
$pgv_lang["cal_jewish_and_gregorian"] = "Jewish and Gregorian";
$pgv_lang["cal_hebrew_and_gregorian"] = "Hebrew and Gregorian";
$pgv_lang["may"]			= "Maggio";
$pgv_lang["mar"]			= "Marzo";
$pgv_lang["feb"]			= "Febbraio";
$pgv_lang["jan"]			= "Gennaio";
$pgv_lang["relationship_chart"]		= "Grafico relazioni";
$pgv_lang["person2"]				= "Seconda Persona";
$pgv_lang["no_link_found"]			= "Non puo' essere trovato un legame tra le due persone.";
$pgv_lang["person1"]				= "Prima Persona";
$pgv_lang["media_file"]			= "File multimediale";
$pgv_lang["requestpassword"]		= "Richiedi una nuova password";
$pgv_lang["site_default"]			= "Standard del Sito";
$pgv_lang["lost_password"]			= "Hai perso la password?";
$pgv_lang["none_today_living"]		= "Nessun avvenimento per oggi.";
$pgv_lang["register_info_01"]		= "L'insieme delle informazioni che possono essere visualizzate su questo sito potrebbe essere limitato, per l'applicazione delle leggi sulla privacy. Molte persone non vogliono rendere pubblici i loro dati personali su internet, poiché potrebbero essere usati per misure di spam o furto di identità.<br/><br/><br />Per avere accesso ai dati privati, devi avere un account su questo sito. Per ottenerne uno puoi registrarti fornendo le informazioni richieste. Appena l'amministratore avrà verificato e approvato il tuo account, potrai collegarti e vedere le informazioni private.<br/><br/><br />Se sono state attivate delle restrizioni sulla privacy potrai avere accesso alle informazioni riservate solamente dei tuoi parenti stretti, dopo che ti sarai collegato. L'amministratore può anche permettere la modifica del database per alcuni utenti, così che possano modificare o aggiungere informazioni.<br/><br/><br />NOTA: Ti sarà permesso l'accesso alle informazioni riservate solamente se potrai dimostrare di essere un parente stretto di una persona nel database. Se non sei parente di nessuno probabilmente non ti sarà concesso un account, potresti dunque evitare il disturbo di registrarti.<br/><br/>Se hai bisogno di qualsiasi altro aiuto, contatta l'amministratore tramite il link sotto.<br/><br/>";
$pgv_lang["requestaccount"] 		= "Richiedi un nuovo account utente";
$pgv_lang["upload_media"]		= "Carica file multimediale";
$pgv_lang["follow_spouse"]			= "Considera i matrimoni";
$pgv_lang["sibling"]				= "Fratello";
$pgv_lang["saturday"]			= "Sabato";
$pgv_lang["mygedview"]			= "Il mio GEDView";
$pgv_lang["passwordlength"]		= "La password deve contenere almeno sei caratteri.";
$pgv_lang["admin_approved"]		= "Il tuo account su #SERVER_NAME# e' stato accettato";
$pgv_lang["you_may_login"]		= " dall'amministratore. Ora devi autenticarti cliccando sul link qui sotto:";
$pgv_lang["welcome"]			= "Benvenuto";
$pgv_lang["mail04_line03"]			= "Raccomandazione:";
$pgv_lang["upcoming_events"]		= "Prossimi Eventi";
$pgv_lang["users_logged_in"]		= "Utenti collegati";
$pgv_lang["no_login_users"]			= "Nessun utente autenticato e anonimo";
$pgv_lang["message"]			= "Manda un messaggio";
$pgv_lang["message_email2"]		= "Hai inviato il seguente messaggio a un utente PhpGedView:";
$pgv_lang["enter_body"]			= "Per favore immetti un messaggio";
$pgv_lang["enter_subject"]		= "Per favore immetti un oggetto";
$pgv_lang["enter_subject"]		= "Per favore immetti un messaggio";
$pgv_lang["invalid_email"]		= "Per favore immetti un indirizzo e-mail valido";
$pgv_lang["message_deleted"]		= "Messaggio eliminato";
$pgv_lang["message_sent"]		= "Messaggio inviato";
$pgv_lang["mygedview_desc"]		= "La tua pagina PhpGedView ti permettere di tenere traccia dei tuoi preferiti, monitorare gli eventi in arrivo e collaborare con altri utenti .";
$pgv_lang["no_messages"]		= "Non hai messaggi pendenti.";
$pgv_lang["no_to_user"]			= "Non e' stato fornito nessun destinatario, Non posso continuare.";
$pgv_lang["savedata"]			= "Salva i dati modificati";
$pgv_lang["user_verify"]		= "Verifica utente";
$pgv_lang["send"]			= "Invia";
$pgv_lang["pls_note07"] 			= "Per verificare la tua richiesta di un account utente, scrivi il tuo nome utente, la password e il codice di verifica che hai ricevuto per email.";
$pgv_lang["pls_note08"] 			= "Le informazioni per l'utente #user_name# sono state verificate.";
$pgv_lang["pls_note10a"]			= "Puoi ora collegarti con il tuo nome utente e password.";
$pgv_lang["pls_note10"] 			= "L'amministratore è stato informato. Appena ti darà l'autorizzazione, potrai collegarto con il tuo nome utente e password.";
$pgv_lang["mail03_line03"]			= "Clicca sul link qui sotto per collegarti al sito. Devi modificare l\'utente per attivare l\'account così potrà collegarsi sul tuo sito.";
$pgv_lang["mail03_line02"]			= "L'utente #newuser[username]# ( #newuser[fullname]# ) ha verificato i suoi dati di registrazione.";
$pgv_lang["pls_note09"] 			= "Hai confermato la richiesta per diventare un utente registrato.";
$pgv_lang["mail03_line01"]		= "Ciao Amministratore...";
$pgv_lang["mgv"]					= "Il mio GedView";
$pgv_lang["data_incorrect"]		= "I dati non sono stati coretti!<br />Per favore riprova!";
$pgv_lang["enter_email"]		= "Devi immettere un indirizzo e-mail.";
$pgv_lang["pls_note06"] 			= "Manderemo ora una mail di conferma all'indirizzo ( #user_email# ). Devi verificare l'account richiesto seguendo le istruzioni nel messaggio di conferma. Se non effettuerai questa verifica entro sette giorni, il tuo account sarà cancellato automaticamente. Dovrai registrarti di nuovo.<br/><br/>Dopo che avrai seguito le istruzioni nella mail di conferma, l'amministratore dovrà approvare la tua richiesta prima che tu possa utilizzare il tuo account.<br/><br/>Per collegarti al sito, devi ricordare l'username e la password.<br/><br/>";
$pgv_lang["mail04_line01"]		= "Ciao #user_fullname#....";
$pgv_lang["thankyou"]				= "Ciao #user_fullname# ...<br />Grazie per la tua registrazione";
$pgv_lang["registernew"]			= "Conferma nuovo Account";
$pgv_lang["datachanged"]		= "I dati dell'utente sono stati modificati!";
$pgv_lang["datachanged_name"]		= "Devi rientrare con il nuovo username.";
$pgv_lang["verified"]				= "L'utente ha verificato se stesso";
$pgv_lang["myuserdata"]			= "Il mio account";
$pgv_lang["verified_by_admin"]		= "Utente approvato dall'amministratore";
$pgv_lang["year_error"] 			= "Spiacente, le date precedenti al 1970 non sono supportate";
$pgv_lang["user_theme"]			= "Il mio tema";
$pgv_lang["clicking_ok"]		= "Cliccando OK si aprira' un'altra finestra dove potrai contattare #user[fullname]#";
$pgv_lang["reply"]			= "Rispondi";
$pgv_lang["provide_email"]		= "Per favore immetti un indirizzo valido se vuoi ricevere una risposta, altrimenti non saremo capaci di contattarti";
$pgv_lang["message_body"]		= "Corpo:";
$pgv_lang["message_subject"]		= "Oggetto:";
$pgv_lang["message_to"]			= "Messaggio a:";
$pgv_lang["message_from_name"]		= "Nome";
$pgv_lang["message_from"]		= "Indirizzo e-mail";
$pgv_lang["date_created"]		= "Data inviato:";
$pgv_lang["privacy_not_granted"]	= "Non hai accesso a";
$pgv_lang["confirm_delete_source"]	= "Sei sicuro di voler cancellare questa fonte dal file GEDCOM?";
$pgv_lang["my_messages"]		= "I miei messaggi";
$pgv_lang["editowndata"]		= "Il mio account";
$pgv_lang["find_media"]			= "Trova oggetto";
$pgv_lang["add_source_lbl"] 		= "Aggiungi fonte";
$pgv_lang["mail01_line04"]			= "Perfavore clicca sul seguente link e riempi i campi richiesti per verificare il tuo account e indirizzo email.";
$pgv_lang["bdm"]					= "Nascite, Morti, Matrimoni";
$pgv_lang["hashcode"]				= "Codice di verifica:";
$pgv_lang["mail01_line03"]			= "Le informazioni sulla richiesta sono mostrare seguendo il link qui sotto.";
$pgv_lang["mail01_line06"]			= "Non riceverai altre email da questo sito, perché l'account richiesto sarà cancellato automaticamente in sette giorni.";
$pgv_lang["mail01_line05"]			= "Se non hai richiesto un account, puoi semplicemente cancellare questo messaggio.";
$pgv_lang["mail01_line02"]			= "Una richiesta è stata ricevuta su ( #SERVER_NAME# ) per creare un account con il tuo indirizzo email ( #user_email# ).";
$pgv_lang["mail02_line01"]			= "Ciao Amministratore ...";
$pgv_lang["mail02_line04"]			= "Sarai informato da una email quando questo utente si sarà autoverificato. Potrai quindi completare il processo attivando l'username. Il nuovo utente non potrà collegarsi finché non attiverai il suo account.";
$pgv_lang["mail02_line03"]			= "L'utente ha ricevuto una email con le informazioni necessario per verificare il proprio account.";
$pgv_lang["mail02_line02"]			= "Un aspirante utente si è registrato a ( #SERVER_NAME# ).";
$pgv_lang["pls_note05"] 			= "Devi specificare un valido e funzionante indirizzo email per ricevere una mail di conferma.<br/><br/>Dopo che avrai compilato questo form e le tue informazioni saranno state verificate, riceverai una mail di conferma all'indirizzo che hai inserito. Tale email conterrà le istruzioni necessarie da seguire per attivare il tuo account. Se non attiverai il tuo account secondo le istruzioni in sette giorni, la tua richiesta verrà cancellata automaticamente. Dovrai quindi ripetere la registrazione.<br/><br/>Per utilizzare questo sito, devi conoscere il tuo username e password.<br/><br/>Per qualsiasi problema riguardante la registrazione di un account su questo sito, manda una richiesta di aiuto al contatto tecnico riportato sotto.";
$pgv_lang["mail01_line01"]			= "Ciao #user_fullname# ...";
$pgv_lang["pls_note04"] 			= "I campi con * sono obbligatori.";
$pgv_lang["emailadress"]		= "Indirizzo e-mail";
$pgv_lang["recent_events"]		= "Eventi recenti (<100 anni)";
$pgv_lang["living_only"]		= "Persone viventi";
$pgv_lang["all_people"]			= "Tutte le persone";
$pgv_lang["viewmonth"]			= "Guarda il mese";
$pgv_lang["viewyear"]				= "Guarda l'anno";
$pgv_lang["now_import"]			= "Ora potresti importare i campi GEDCOM in PhpGedView cliccando sul link sotto.";
$pgv_lang["viewday"]			= "Guarda il giorno";
$pgv_lang["friday"]				= "Venerdi'";
$pgv_lang["thursday"]			= "Giovedi'";
$pgv_lang["add_name"]				= "Aggiungi un nuovo nome";
$pgv_lang["select_date"]			= "Seleziona una data";
$pgv_lang["edit_raw"]				= "Modifica il campo GEDCOM";
$pgv_lang["accept_successful"]		= "Cambiamenti effettuati con successo nel database";
$pgv_lang["accept_all"] 			= "Accetta tutte le modifiche";
$pgv_lang["accept"] 				= "Accetta";
$pgv_lang["must_provide"]		= "Devi fornire un ";
$pgv_lang["add_asso"]				= "Aggiungi una persona collegata";
$pgv_lang["add_obje"]				= "Aggiungi un oggetto multimediale";
$pgv_lang["wednesday"]			= "Mercoledi'";
$pgv_lang["tuesday"]			= "Martedi'";
$pgv_lang["monday"]				= "Lunedi'";
$pgv_lang["sunday"]				= "Domenica";
$pgv_lang["anniversary_calendar"] = "Calendario anniversari";
$pgv_lang["month"]				= "Mese:";
$pgv_lang["day"]				= "Giorno";
$pgv_lang["add_note_lbl"]			= "Aggiungi nota";
$pgv_lang["today"]					= "Oggi";
$pgv_lang["year_anniversary"]	= "#year_var# anni d'anniversario";
$pgv_lang["on_this_day"]		= "In questo giorno nella tua storia....";
$pgv_lang["in_this_month"]			= "In questo mese, nella tua storia...";
$pgv_lang["in_this_year"]			= "In questo anno, nella tua storia...";
$pgv_lang["add_wife_to_family"]	= "Aggiungi una moglie a questa famiglia";
$pgv_lang["add_mother"] 			= "Aggiungi una madre";
$pgv_lang["add_father"] 			= "Aggiungi un padre";
$pgv_lang["delete_name"]		= "Cancella il nome";
$pgv_lang["replace"]				= "Sostituzione campo";
$pgv_lang["edit_name"]			= "Modifica il nome";
$pgv_lang["delete_source"]		= "Cancella questa fonte";
$pgv_lang["add_note"]			= "Aggiungi una nuova nota";
$pgv_lang["add_media_lbl"]			= "Aggiungi Media";
$pgv_lang["add_media"]				= "Aggiungi un oggetto multimediale";
$pgv_lang["undo_successful"]		= "Annullao con successo";
$pgv_lang["undo"]			= "Annulla";
$pgv_lang["view_change_diff"]		= "Guarda le differenze";
$pgv_lang["changes_occurred"]		= "La persona presenta le seguenti modifiche:";
$pgv_lang["find_place"]			= "Trova posto";
$pgv_lang["add_source"]			= "Aggiungi una fonte";
$pgv_lang["gedrec_deleted"]		= "Campo GEDCOM cancellato con successo.";
$pgv_lang["changes_exist"]		= "Sono stati fatti dei cambiamenti al file GEDCOM.";
$pgv_lang["confirm_delete_person"]	= "Sei sicuro di voler cancellare questa persona nel file GEDCOM?";
$pgv_lang["delete_person"]		= "Cancella questa persona";
$pgv_lang["add_new_husb"]		= "Aggiungi un nuovo marito";
$pgv_lang["add_new_wife"]		= "Aggiungi una nuova moglie";
$pgv_lang["find_family"]			= "Trova la famiglia";
$pgv_lang["add_wife"]			= "Aggiungi moglie";
$pgv_lang["ged_import"]			= "Importa file GEDCOM";
$pgv_lang["add_son_daughter"]		= "Aggiungi un figlio o una figlia";
$pgv_lang["add_sibling"]			= "Aggiungi un fratello o una sorella";
$pgv_lang["add_husb_to_family"]	= "Aggiungi marito a questa famiglia";
$pgv_lang["add_husb"]			= "Aggiungi marito";
$pgv_lang["add_child_to_family"]	= "Aggiungi un bambino a questa famiglia";
$pgv_lang["add_child"]			= "Aggiungi bambino";
$pgv_lang["check_delete"]		= "Sei sicuro di voler eliminare questo fatto?";
$pgv_lang["update_successful"]		= "Caricato con successo";
$pgv_lang["accept_gedcom"]		= "Decidi per ogni modifica se accettarla o rifiutarla.<br /><br />Per accettare tutte le modifiche in una volta, clicca <b>\"Accetta tutte le modifiche\"</b> in fondo.<br />Per avere più informazioni riguardo una modifica.<br />clicca <b>\"Guarda le differenze\"</b>,<br />o clicca <b>\"Mostra campo GEDCOM\"</b> per vedere i nuovi dati nel formato GEDCOM.";
$pgv_lang["place_contains"]		= "Il posto contiene:";
$pgv_lang["close_window_without_refresh"] = "Chiudi la finestra senza ricaricare";
$pgv_lang["custom_event"]			= "Evento personalizzato";
$pgv_lang["add"]				= "Aggiungi";
$pgv_lang["review_changes"]		= "Rivedi le modifiche al file GEDCOM";
$pgv_lang["show_changes"]		= "Il campo e' stato aggiornato. Clicca qui per mostrare le modifiche.";
$pgv_lang["add_fact"]			= "Aggiungi un nuovo fatto";
$pgv_lang["line_up_generations"]	= "Allinea le generazioni";
$pgv_lang["oldest_top"]             = "Mostra i più vecchi in alto";
$pgv_lang["show_path"]				= "Mostra collegamento";
$pgv_lang["next_path"]				= "Trova un altro collegamento";
$pgv_lang["close_window"]		= "Chiudi finestra";
$pgv_lang["accept_changes"]		= "Accetta/Rifiuta le modifiche";
$pgv_lang["access_denied"]		= "<b>Accesso negato</b><br />Non hai accesso a questa risorsa";
$pgv_lang["relationship_to_me"]		= "Relazionato a me";
$pgv_lang["son"]					= "Figlio";
$pgv_lang["sister"]					= "Sorella";
$pgv_lang["brother"]				= "Fratello";
$pgv_lang["daughter"]				= "Figlia";
$pgv_lang["support_contact"]		= "Contatto Tecnico";
$pgv_lang["genealogy_contact"]		= "Contatto genealogia";

$pgv_lang["indis_charts"]			= "Opzioni per la persona";
$pgv_lang["edit_indi"] 				= "Modifica Persona";
$pgv_lang["locked"]					= "non cambiare";
$pgv_lang["total_not_born"]			= "Totale non ancora nati";
$pgv_lang["remove_custom_tags"]		= "Rimuovere i tag PGV personalizzati? (es. _PGVU._THUM)";
$pgv_lang["cookie_login_help"]		= "Questo sito si ricorda di te dal precedente login. Questo ti permette di avere accesso a informazioni private e altre funzioni, ma per modificare o amministrare il sito, devi eseguire ancora il login per maggior sicurezza.";
$pgv_lang["cut"]					= "Taglia";
$pgv_lang["children_timeline"]		= "Mostra i figli sulla tabella temporale";
$pgv_lang["family_timeline"]		= "Mostra la famiglia sulla tabella temporale";
$pgv_lang["family_timeline"]		= "Mostra la famiglia sulla linea temporale";
$pgv_lang["fams_charts"]			= "Opzioni per la famiglia";
$pgv_lang["sort_by_birth"]			= "Ordina per date di nascita";
$pgv_lang["reorder_children"]		= "Riordina Figli";
$pgv_lang["edit_fam"]				= "Modifica famiglia";
$pgv_lang["fams_with_surname"]		= "Famiglie con cognome #surname#";
$pgv_lang["fathers_family_with"] = "Famiglia paterna con ";
$pgv_lang["common_upload_errors"]	= "Questo errore significa probabilmente che il file che ahi provato a spedire supera il limite imposta dal tuo host. Il limite di default di PHP è 2MB. Puoi contattare il tuo team di supporto per l'host per far aumentare il limite imposto in php.ini o puoi mandare il file tramite FTP. Usa la pagina <a href=\"uploadgedcom.php?action=add_form\"><b>Aggiungi GEDCOM</b></a> per inserire un GEDCOM che hai mandato via FTP.";
$pgv_lang["mothers_family_with"] = "Famiglia materna con ";
$pgv_lang["importing_places"]  = "Importazione luoghi";
$pgv_lang["total_memory_usage"]		= "Totale Utilizzo Memoria:";
$pgv_lang["continue_import"]		= "Continua l'importazione dei luoghi";
$pgv_lang["add_unlinked_person"]	= "Aggiungi una persona non collegata";
$pgv_lang["select_fact"] = "Seleziona un fatto...";
$pgv_lang["update_address"] = "Aggiorna Indirizzo";
$pgv_lang["update_photo"] = "Aggiorna Foto";
$pgv_lang["photo_replace"] = "Vuoi sostituire la vecchia foto con questa?";
$pgv_lang["update_fact"] = "Aggiorna un Fatto";
$pgv_lang["update_name"] = "Aggiorna Nome";
$pgv_lang["show_spouses"]		= "Mostra sposi";
$pgv_lang["review_changes_block"]	= "Cambiamenti Pendenti";
$pgv_lang["thumb_genned"]			= "Anteprime generate automaticamente.";
$pgv_lang["thumbgen_error"]			= "Impossibile generare l'anteprima per ";
$pgv_lang["upload_file"]			= "Carica file dal mio computer";
$pgv_lang["total_names"]			= "Totale Nomi";
$pgv_lang["indis_with_surname"]		= "Persone con il cognome #surname#";
$pgv_lang["first_letter_fname"]		= "Seleziona una lettera per mostrare le persone con il nome che inizia con quella lettera.";
$pgv_lang["choose_relatives"]		= "Seleziona Parenti";
$pgv_lang["descendants"]			= "Discendenti";
$pgv_lang["relatives_report"]		= "Report Parenti";
$pgv_lang["reorder_families"]		= "Riordina le famiglie";
$pgv_lang["sort_by_marriage"]		= "Ordina per data di matrimonio";
$pgv_lang["copy"]					= "Copia";
$pgv_lang["user_default_tab"]		= "Scheda di Default per la tua pagina personale";
$pgv_lang["max_upload_size"]  = "Grandezza Massima Caricamento: ";
$pgv_lang["add_new_chil"] = "Aggiungi un figlio";
$pgv_lang["quick_update_title"] = "Modifica veloce";
$pgv_lang["other"]     = "Altro";
$pgv_lang["changelog"]    = "Cambiamenti della versione #VERSION#";
$pgv_lang["enter_comments"]   = "Per favore indica la tua relazione con i dati nel campo dei Commenti.";
$pgv_lang["comments"]    = "Commenti";
$pgv_lang["none"]     = "Nessuno";
$pgv_lang["ancestors"]    = "Antenati in linea diretta e familiari";
$pgv_lang["direct-ancestors"]  = "Antenati in linea diretta";
$pgv_lang["spouse-family"]   = "Coniuge e figli";
$pgv_lang["child-family"]   = "Genitori e Fratelli";
$pgv_lang["pls_note12"]    = "Usa questo campo per descrivere perché stai richiedendo un account su questo sito e in che modo sei collegato alla genealogia.";
$pgv_lang["config_block"]   = "Blocco di Configurazione";
$pgv_lang["days_to_show"]   = "Numero di giorni da mostrare";
$pgv_lang["num_to_show"]   = "Numero di elementi da mostrare";
$pgv_lang["html_block_descr"]  = "Questo è un semplice blocco HTML che puoi mettere nella tua pagina per aggiungere qualsiasi tipo di messaggio che vuoi.";
$pgv_lang["html_block_name"]  = "Blocco HTML";
$pgv_lang["total_living"]   = "Totale vivi";
$pgv_lang["total_dead"]    = "Totale morti";
$pgv_lang["remember_me"]   = "Ricordami da questo computer";
?>
