<?php
/**
 * Greek Language file for PhpGedView.
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2002 to 2005  Nicholas G. Antimisiaris
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * @package PhpGedView
 * @author Nicholas G. Antimisiaris
 * @version $Id: help_text.el.php 981 2007-03-21 13:24:38Z fisharebest $
 */

if (stristr($_SERVER["SCRIPT_NAME"], basename(__FILE__))!==false) {
	print "You cannot access a language file directly.";
	exit;
}

//-- GENERAL
$pgv_lang["help_header"]					= "Πληροφορίες για:";
$pgv_lang["privacy_error_help"]				= "<b>ΠΡΟΣΩΠΙΚΑ ΣΤΟΙΧΕΙΑ</b><br /><br />Υπάρχουν διάφορες πιθανές αιτίες για το μήνυμα αυτό:<br /><br /><b>1. Πληροφορίες για άτομα εν ζωή έχουν οριστεί ως \"Κρυφά\"</b><br />Μη εγγεγραμμένοι χρήστες που δεν έχουν συνδεθεί μπορούν να δούν πλήρη στοιχεία μόνο για άτομα που έχουν πεθάνει.  Εάν έχει επιτραπεί από τον Διαχειριστή, μπορείτε να υποβάλλετε αίτηση για λογαριασμό επιλέγοντας το κουμπί Διασύνδεσης, και μετά τον σύνδεσμο #pgv_lang[requestpassword]#.<br /><br /><b>2. Είστε χρήστης με όνομα και κωδικό πρόσβασης...</b><br />Αλλά έχετε ξεχάσει να συνδεθείτε ή έχετε αποσυνδεθεί λόγω αδράνειας.<br /><br /><b>3. Λόγω προστασίας προσωπικών δεδομένων</b><br />το άτομο έχει ζητήσει από τον διαχειριστή να τον καταχωρήσει ως \"Πριβέ\" ή δεν θέλει να εμφανίζεται καθόλου (Κρυφός/η).<br />Privacy can be set to:<br />a) #pgv_lang[PRIV_USER]#<br />b) #pgv_lang[PRIV_NONE]#<br />c) #pgv_lang[PRIV_HIDE]#<br /><br /><b>4. Out of \"Relation Path\"</b><br />Even if you are a regular user <b>and</b> logged in, it can still happen that you see this message if the person you are trying to view is not related to you within the number of relationship steps (Relation Path length) set by the site administrator for this GEDCOM.<br />Examples:<br />When the Relation Path length is set to <b>1</b>, you can only see the details of your own family, father, mother, brother, sister (but not the spouses and children of your brother or sister)<br /><br />When the Relation Path is set to <b>2</b>, you can also see the details of your brother's wife and their children (but not the spouses of their children).<br />The higher the Relation Path length setting, the more remote relatives you can see.<br /><br />If you think that you qualify to see certain details, please contact the site administrator by following the contact link on any screen.";
$pgv_lang["more_help"]						= "<br />If you would like to have contextual help available on every screen, make sure that the <b>#pgv_lang[show_context_help]#</b> (in the Help Menu) is on, and click on a <b>?</b> behind the subject.<br />";
$pgv_lang["more_config_help"]				= "<br /><b>More help</b><br />More help is available on the form. Please click the <b>?</b> behind the labels.<br />";
$pgv_lang["start_admin_help"]				= "+++ Begin extra Admin Info +++";
$pgv_lang["end_admin_help"]					= "--- End extra Admin Info ---";
$pgv_lang["multiple_help"]					= "<center>--- This is a general help text for multiple pages ---</center>";
$pgv_lang["header_general_help"]			= "<div class=\"name_head\"><center><b>GENERAL INFORMATION</b></center></div><br />";
$pgv_lang["best_display_help"]				= "~Your Screen~<br />PhpGedView is designed for a screen resolution of 1024x768 pixels.<br />This should be the minimum resolution to have everything displayed properly.<br />If you set the resolution to a lower value (for example 800x600 pix.), you will need to do horizontal scrolling.<br />";
$pgv_lang["preview_help"]					= "~Printing~<br />Clicking the Printer-friendly Version link will remove the items that don't look good on a printed page (menus, \"input boxes\", extra \"links\", the question marks for the contextual help, etc.).<br /><br />On the Printer-friendly Page, you will get a Print link at the bottom of the page. Just click it and your printer dialog will pop up. After printing, just click the Back link and the screen will be rebuilt in standard mode.<br /><br />Note: Although the \"Printer-friendly version\" has many links removed from the screen, the remaining links are still clickable.<br />";
$pgv_lang["readme_help"]					= "<center>See the <a href=\"readme.txt\" target=\"_blank\"><b>Readme.txt</b></a> for more information.</center>";
$pgv_lang["is_user_help"]					= "--- This help text is the same text that site visitors will read. --- <br />--- To save space, we did not make a special admin text for this item. ---";
$pgv_lang["edit_raw_gedcom_help"]			= "~EDIT RAW GEDCOM~<br /><br />When you click this link, a new window will open with the raw GEDCOM data concerning the details on this page.<br />Here you can edit the GEDCOM data directly. Be sure to enter valid GEDCOM 5.5 data, as no further validity checks will be done.<br />The changed and/or added data will be displayed in PhpGedView as changes, and have to be accepted by a user with acceptance rights.";


//-- Pages Help-messages
//-- Index-page
$pgv_lang["index_help"]						= "~Καλωσόρισμα~<br /><br />Σελίδα Καλωσορίσματος.  It welcomes you to the selected <a href=\"#def_gedcom\">GEDCOM</a> file. You can return to this page by selecting Welcome Page from the top  menu. If there are multiple GEDCOMs on this site, you can select a GEDCOM from the drop down menu.<br /><b>This help page contains information about:</b> (since this page is the main PhpGedView site page)<ul><li><a href=\"#index_portal\">Welcome Page</a><li><a href=\"#header\">Header Area</a><li><a href=\"#menu\">Menus</a><li><a href=\"#header_general\">General Information</a><li><a href=\"#def\">Definitions</a></ul><br />Version #VERSION# brings a new look for <a href=\"#def_pgv\">PhpGedView</a>.  The menus, the starting page, and many other features are improved and/or revamped.<br /><br />";

//-- Index-page Header
$pgv_lang["header_help"]					= "<div class=\"name_head\"><center><b>HEADER AREA</b></center></div><br />The header is shown at the top of every page.<br />The header contains some useful links that you can use throughout the site.<br />Since this site can have a different look depending on the selected <a href=\"#def_theme\">Theme</a>, headers can be affected and links may vary.<br /><br /><b>The links that you might find are:</b><ul><li><a href=\"#header_search\">Search Box</a><li><a href=\"#header_lang_select\">Language Selector</a><li><a href=\"#header_user_links\">User Links</a><li><a href=\"#header_favorites\">Favorites</a><li><a href=\"#header_theme\">Change Theme</a></ul>";
$pgv_lang["header_search_help"]				= "~Header Area: Search Box~<br />This search box is small but powerful.<br />You can have PhpGedView search almost anything for you. When you click the ' <b>&gt;</b>' or <b>Search</b> button, you will be linked to the search main page to see the results of your search.<br />You will find extensive help about searching options on the search main page.<br />";
$pgv_lang["header_lang_select_help"]		= "~Header Area: Language Selector~<br />One of the most important features of PhpGedView is that multiple languages are supported and switched automatically for each visitor according to their browser setting.<br />If the switch is not done automatically to your preferred language (most likely because of an incorrect \"Preferred Language\" browser setting), you can change the language by using the <b>Language Selector</b>.<br />The Language selector can be displayed in two different ways:<br />1. Classic selector with a \"drop down\" list selector.<br />2. Colorful version with the National Country Flags.<br />";
$pgv_lang["header_user_links_help"]			= "~Header Area: User Links~<br />The User Links is a small block with useful links, that the user can find on the same place throughout the site (as long the user does not change the Theme)<br />When not logged in, you will only see the <b>Login</b> link.<br />When logged in you will see: <b>Logged in as (your user name)</b>. Clicking that link will bring you to your Account.<br />Click <b>Log out</b> to Log out.<br />If you have admin rights, you will also see <b>Admin</b>. Clicking this link will bring you directly to the Administration Main Page.<br />";
$pgv_lang["header_favorites_help"]			= "~Header Area: Favorites~<br />The Favorites drop-down list shows the Favorites that you have selected on your Personal Portal.  It also shows the favorites that the site administrator has selected for the currently active GEDCOM.<br />Clicking on one of the Favorites, will bring you directly to the Individual Details Page of that person.<br />More help about adding Favorites is available in your Personal Portal.<br />";
$pgv_lang["header_theme_help"]				= "~Header Area: Change Theme~<br />When enabled by the site administrator, the Change Theme drop-down list shows you a list of the themes that you can use to view the site.  Selecting a theme from the drop-down list will change the theme of the site.  If you are logged in, it will also change your user theme to the one that you have chosen.<br />";

//-- Index-page Menu
$pgv_lang["menu_help"]						= "<div class=\"name_head\"><center><b>ΜΕΝΟΥ</b></center></div><br />In the page headers we have (drop down) menus.<br />Moving your mouse pointer over the menu icon, will give you a sub menu if one exists for that item.<br />If you click on main menu icon, it will take you to the first item in the sub menu.<br /><br /><b>You can choose from the following main menu items:</b><ul><li><a href=\"#menu_fam\">#pgv_lang[welcome_page]#</a><br /><li><a href=\"#menu_myged\">Mygedview Portal</a><br /><li><a href=\"#menu_charts\">Charts</a><br /><li><a href=\"#menu_lists\">Lists</a><br /><li><a href=\"#menu_annical\">Anniversary Calendar</a><br /><li><a href=\"#menu_clip\">#pgv_lang[clippings_cart]#</a><br /><li><a href=\"#menu_search\">Search</a><br /><li><a href=\"#menu_rslog\">Research Log</a><br /><li><a href=\"#menu_help\">Help</a></ul><br />";
$pgv_lang["menu_famtree_help"]				= "~Μενού Σελίδας Καλωσορίσματος~<br />All of this site's available GEDCOM files are listed in this menu. Each GEDCOM file has it's own customized Welcome Page, like this one.<br />If there is only one GEDCOM at this site, there is no sub-menu under the Welcome Page icon.<br />";
$pgv_lang["menu_myged_help"]				= "~MyGedview Portal Menu~<br />If you are logged in, this menu can include the following items:<dl><dt>MyGedview Portal</dt><dd>This brings you to your own customizable \"Starting Page\".</dd><dt>My Account</dt><dd>You can edit your personal data here.</dd><dt>My Pedigree</dt><dd>If you have selected a Root person for this GEDCOM, this will take you to the Pedigree Chart for that person.</dd><dt>My Indi</dt><dd>This link will forward you to your Individual Page, where all genealogical data about yourself and your family is displayed.</dd></dl>";
$pgv_lang["menu_charts_help"]				= "~Μενού Διαγραμμάτων~<br />All the available charts are listed in this menu:<dl><dt><a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a></dt><dd>This will link you to the Pedigree chart of this GEDCOM file. The pedigree will start with the root person of the GEDCOM. When you are logged in, however, the root person can be you, or somebody of you own choice.</dd><dt><a href=\"?help=help_descendancy.php\">#pgv_lang[descend_chart]#</a></dt><dd>The Descendancy Chart is, more or less, a <a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a> in reversed order.<br />This comparison is not quite correct, but while the Pedigree Tree shows you all the ancestors of a starting person, the Descendancy chart shows you all the descendants of a starting person.</dd><dt><a href=\"?help=help_timeline.php\">#pgv_lang[timeline_chart]#</a></dt><dd>Here you view the events of a person along a Time Lime.<br />It's interesting to compare the events of two or more persons along the same time line.</dd><dt><a href=\"?help=help_relationship.php\">#pgv_lang[relationship_chart]#</a></dt><dd>Here you can check the relation of a person to yourself, or to another person.</dd><dt><a href=\"?help=help_ancestry.php\">#pgv_lang[ancestry_chart]#</a></dt><dd>Very similar to the <a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a>, but with more details and alternate <a href=\"?help=chart_style_help\">#pgv_lang[chart_style]#</a> displays.</dd><dt><a href=\"?help=help_fanchart.php\">#pgv_lang[fan_chart]#</a></dt><dd>Very similar to the <a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a>, on a more graphical way.</dd></dl>";
$pgv_lang["menu_lists_help"]				= "~Μενού Καταλόγων~<br />The following Lists are available in this menu:<dl><dt><a href=\"?help=help_indilist.php\">#pgv_lang[individual_list]#</a></dt><dt><a href=\"?help=help_famlist.php\">#pgv_lang[family_list]#</a></dt><dd>In these two lists you can browse alphabetical lists of people in this GEDCOM.<br />The first one will return a list of individuals, the second a list of families.</dd><dt><a href=\"?help=help_sourcelist.php\">#pgv_lang[source_list]#</a></dt><dd>This items returns a list of all the sources used in the GEDCOM.</dd><dt><a href=\"?help=help_placelist.php\">#pgv_lang[place_list]#</a></dt><dd>Here you can look for people by Place. A two-column list will be returned. The individuals are listed on the left, the families on the right.</dd><dt><a href=\"?help=help_medialist.php\">#pgv_lang[media_list]#</a></dt><dd>You see this menu-item only if enabled by the site admin.<br />This will display links to all multi media files that are used in this GEDCOM.</dd></dl>";
$pgv_lang["menu_annical_help"]				= "~Μενού Ημερολογίου Επετειών~<br />The Anniversary Calendar displays the events in a GEDCOM for a given date, month, or year.<dl><dt><a href=\"?help=day_month_help\">#pgv_lang[viewday]#</a></dt><dd>Clicking this menu item will bring you to the Anniversary Calendar, displaying the events of the current day.</dd><dt><a href=\"?help=day_month_help\">#pgv_lang[viewmonth]#</a></dt><dd>This will bring you to the Anniversary Calendar, displaying a monthly calendar with the events of the current month.</dd><dt><a href=\"?help=day_month_help\">#pgv_lang[viewyear]#</a></dt><dd>This will bring you to the Anniversary Calendar, displaying a list of all the events for the current year.</dd></dl>";
$pgv_lang["menu_clip_help"]					= "~Family Tree Clipping Cart Menu~<br />If enabled in this GEDCOM by your site administrator, you will see this item in the menu bar.<br />The Clipping Cart allows you to select individuals, families, and sources as store them as Family Tree clippings in your Clippings cart that you can later download in GEDCOM 5.5 format.<br /><br />";
$pgv_lang["menu_search_help"]				= "~Search Menu~<br />The Search Page, where you will jump to by clicking this link, is the more powerful brother of the Search box you may find in the header.<br /><br />";
$pgv_lang["menu_rslog_help"]				= "~Research Log Menu~<br />You will only see this option if it has been installed by the site administrator, and may require logging in before you can access it.<br />The Research Log gives you the option to keep log files about your research activities.<br />Others can use the same or different logs.<br />";
$pgv_lang["menu_help_help"]					= "~Help Menu ~<br />#pgv_lang[help_help_items]#";

//-- Index-page Portal
$pgv_lang["index_portal_head_help"]			= "<div class=\"name_head\"><center><b>THE WELCOME PAGE</b></center></div><br />";
$pgv_lang["index_portal_help"]				= "The Welcome Page consists of several separate blocks, and can be customized. So for each GEDCOM, on sites that have more than one GEDCOM file, you may see a different Welcome Page.<br /><br /><b>Depending on how the administrator customized the site, you may see any of the following blocks on the Welcome Page:</b><ul><li><a href=\"#index_welcome\">Welcome</a><li><a href=\"#index_login\">Login</a><li><a href=\"#index_events\">Upcoming events</a><li><a href=\"#index_onthisday\">On this Day in Your History</a><li><a href=\"#index_favorites\">GEDCOM Favorites</a><li><a href=\"#index_stats\">GEDCOM Statistics</a><li><a href=\"#index_common_surnames\">Most Common Surnames</a><li><a href=\"#index_media\">Random Media</a><li><a href=\"#index_loggedin\">Logged in Users</a><li><a href=\"#gedcom_news\">GEDCOM News</a><li><a href=\"#recent_changes\">Recent Changes</a></ul>";
$pgv_lang["index_welcome_help"]				= "~WELCOME BLOCK~<br />The Welcome Block shows you:<br />The current GEDCOM file, The date and time and (if enabled by the admin) the <b>Hit Counter</b>.<br />The Hit Counter can only be shown in the Welcome Block and on the Individual Details Page.<br />The counter counts the \"Hits\" of these pages. That means it counts how many times these pages are visited.<br />The counter does not check the URL of a visitor, so when somebody revisits a page after some time, it will be counted as another Hit.<br />";
$pgv_lang["index_login_help"]				= "~LOGIN BLOCK ~<br />Although you can login on almost every page of this program, you will typically do so on the first page, since you can only access privileged information when you are logged in.<br />You can login by typing your <b>username</b> and <b>password</b> and click the Login button.<br /><br />#pgv_lang[new_password_help]#<br />";
$pgv_lang["index_events_help"]				= "~UPCOMING EVENTS BLOCK~<br />This block show you anniversaries of events from the GEDCOM that are coming up in the next month.<br />";
$pgv_lang["index_onthisday_help"]			= "~ON THIS DAY IN YOUR HISTORY BLOCK~<br />This block works like the \"Upcoming Events\" block, only it displays today's events from your GEDCOM<br />";
$pgv_lang["index_favorites_help"]			= "~GEDCOM FAVORITES BLOCK~<br />The GEDCOM Favorites Block is much the same as the \"My Favorites\" block of the MyGedView Portal. But in this case, only the Site Admin, or a user with admin rights, can add, delete, or change the Favorite(s).<br />The purpose of the GEDCOM Favorites block is to draw visitor attention to a person (or persons) of special interest.<br />On every page of the site, \"This GEDCOM's Favorites\" are available to select from a drop down list in the header.<br />This will forward you to the individual page of the person.<br /><br />To save space, the boxes are displayed with limited information. At the right side of the name box you see the magnifying glass to reveal some more information.<br />Clicking the name will forward you to the individual page of the person.<br />Also at the right side you will find a menu, that can take to pages with more information or charts.<br />";
$pgv_lang["index_stats_help"]				= "~GEDCOM STATISTICS BLOCK~<br />In this block you will see some statistics about the current GEDCOM file.<br />If you want more information than listed, you can send a note to the contact at the bottom of the page.<br /><br />";
$pgv_lang["index_common_names_help"]		= "~MOST COMMON SURNAMES~<br />A list of the surnames in this GEDCOM are displayed in this block. The number of names displayed is set by the site administrator.<br />(Current setting is surnames who are present in the GEDCOM more than #COMMON_NAMES_THRESHOLD# times)<br /><br />The names are clickable. Clicking on a name will take you to the #pgv_lang[individual_list]#, where you will get more details about the name.<br />";
$pgv_lang["index_media_help"]				= "~RANDOM PICTURE BLOCK~<br />In this block PhpGedView randomly chooses a media file to show you on each visit to this page.<br />Clicking on the picture, or on its caption, will give you the full-size version.<br />Underneath the picture you have a link to the person the picture is linked to.<br />Clicking on the person's name will take you to the individual page of that person.<br />";
$pgv_lang["index_loggedin_help"]			= "~LOGGED IN USERS BLOCK~<br />This block will show you the number of users currently logged in.<br />";
$pgv_lang["index_gedcom_news_help"]			= "~GEDCOM NEWS BLOCK~<br />The news block is like a bulletin board for this GEDCOM.<br />The site administrator can place important announcements or interesting news messages here.<br /><br />If you have something interesting to display, please contact the site administrator and he can put your message on the bulletin board.";
$pgv_lang["index_gedcom_news_adm_help"]		= "The GEDCOM News Block allows the use of <b>HTML tags</b>.<br />Be careful to always use both start and end tags.<br />It may help to have a level of knowledge of HTML appropriate for a web site administrator.<br /><br />This program uses <b>Style Sheets (CSS)</b> as well. For each theme a different style sheet applies.<br />You can also use classes from these style sheets.<br /><br />If you need more help with this, the PhpGedView web site has some examples of how to use these tags in your GEDCOM News Block.<br />";
$pgv_lang["recent_changes_help"]			= "~RECENT CHANGES BLOCK~<br />This block show you the most recent changes that were made to the GEDCOM as noted by the CHAN GEDCOM tag.<br />";

//-- Index-Page Help
$pgv_lang["help_help"]						= "Of course, it would be ideal to make a program simple enough that it doesn't need any explanation at all.<br />It should be as simple as reading a book.<br />Although the program is rather complicated, you do not notice that in the user interface. Almost anything can be used without explanation.<br />But, since we have a lot of visitors and users who are not very experienced with the use of a computer or with the Internet, we offer you some help at certain places.<br />In the help menu, you will find the following items:<br />";
$pgv_lang["help_page_help"]					= "<dl><dt><b>Help with this Page</b></dt><dd>For all pages there is a general \"Page Help\" available.<br />When you are on a page, you can click this item in the menu, and you will get the \"Page Help\" which will inform you about the items that you can find on that very page.<br />The Page Help is brief, in most cases.<br />If you need some more help, or info, about a certain item on the page, then there is the third option of the help menu: the \"Contextual Help\".</dd></dl>";
$pgv_lang["help_content_help"]				= "<dl><dt><b>Help Contents</b></dt><dd>Clicking this menu item will give you the help pop-up, displaying an index of the major help items.<br />This index will have more items, in the near future, since also the minor help items will be indexed.</dd></dl>";
$pgv_lang["help_qm_help"]					= "<dl><dt><b>Hide / Show Contextual Help</b></dt><dd>This last menu item maybe is the most handy for you. Clicking this link will either switch on or off the \"Contextual Help\".<br />What is \"Contextual Help\"?<br />When switched on, you may find a Question Mark at the right of some links, drop-down boxes or buttons . Clicking this <b>?</b> will pop-up this little help screen with some more information about that object.<br />Of course, when you click \"Hide Contextual Help\", all the Question Marks will be hidden, until you click \"Show....\" again.</dd></dl>";

//-- Index-page Definitions
$pgv_lang["def_help"]						= "<div class=\"name_head\"><center><b>DEFINITIONS</b></center></div><br />Some definitions of words, used in this help text:<ul><li><a href=\"#def_gedcom\">GEDCOM</a><br /><li><a href=\"#def_gedcom_date\">Dates</a><li><a href=\"#def_pgv\">PhpGedView</a><li><a href=\"#def_portal\">Portal</a><li><a href=\"#def_theme\">Theme</a></ul>";
$pgv_lang["def_portal_help"]				= "~Portal~<br />Also on this web site a Portal is like a lobby of a restaurant. It is the place where you enter, but you can also find important information like explanations, menus etc..<br />";
$pgv_lang["def_gedcom_help"]				= "~GEDCOM file~<br />The GEDCOM file is the file that contains all the information about the family.<br />All facts, dates, events, etc. are stored in the GEDCOM file.<br />A GEDCOM file has to follow strict rules, because it is exchangeable between many programs, independent of platforms and/or systems.<br />";
$pgv_lang["def_gedcom_date_help"]			= "~Dates in a GEDCOM file~<br />Since the formats in the GEDCOM files have to follow the International rules, there is an agreement about the notation of the dates as well.<br /><br />Although the date field in a GEDCOM file is a free field (meaning you can even type in just text), here some explanation about typing in correct dates:<br />The full date is entered like DD MMM YYYY like:<br />01 Mar 1801 or 14 Dec 1950<br />If you are missing a part of the date, you can omit that part, like:<br />Mar 1801 or 14 Dec<br />If you are not sure, or the date is not confirmed, you could type:<br />abt Mar 1801 (abt = about)<br />bef 20 Dec 1950 (bef = before)<br />aft 1949 (aft = after)<br />Make sure that you enter these dates and abbreviations in English, because then the GEDCOM file is exchangeable and the program will translate all dates and abbreviations properly in the desired language.<br />Also the program has to calculate with the dates. If improper dates are entered in the date fields of the GEDCOM file, the program will not be able to calculate properly.<br />";
$pgv_lang["def_pgv_help"]					= "~PhpGedView~<br />PhpGedView (or PGV) is a program designed by John Finlay to view GEDCOM files on line.<br />As you can see, PGV does not just put static pages on the web, but is dynamic and can be customized in many ways.<br />John started developing the program on his own, but an entire international team of developers and translators has since joined him and is working to improve the program.<br />Apart from just viewing GEDCOM files, PGV also allows adding and editing events on-line now.<br />";
$pgv_lang["def_theme_help"]					= "~Theme~<br />This site can have some different \"looks\", called Themes.<br />The site administrator chooses a Theme for startup.<br />Everybody who enters this site will see the same Look (Theme). When the site admin has set up the site in a way that logged in users can choose their own theme, they can find out for themselves what they like most.<br />If a user has chosen a different Theme, he/she will have that site layout, as soon as he/she is logged in.<br />";

//-- Index-page MyGEDCOM
$pgv_lang["mygedview_portal_help"]			= "~#pgv_lang[upper_mygedview]#~<br />This is your Personal #pgv_lang[mgv]# Page.<br />You may find here easy links to access your personal data, like <b>My Account, My Indi</b> (this is your Individual Page), <b>My Pedigree</b>.<br />Furthermore you can have a block with <b>Messages</b>, a <b>Journal</b> (like a Notepad) and many more.<br /><br />The layout of this page works the same as the Welcome Page.<br />But while the parts of the Welcome Page are selected by the site adminstrator, you select what parts to include on this page.<br /><br />In the Welcome Block on this page you will find the link to customize this page.<br /><br /><b>You can choose from the following blocks:</b><ul><li><a href=\"#mygedview_welcome\">Welcome</a><li><a href=\"#mygedview_customize\">Customize MyGedView</a><li><a href=\"#mygedview_message\">Messages</a><li><a href=\"#mygedview_events\">Upcoming events</a><li><a href=\"#mygedview_onthisday\">On this Day in Your History</a><li><a href=\"#mygedview_favorites\">My Favorites</a><li><a href=\"#mygedview_stats\">GEDCOM Statistics</a><li><a href=\"#mygedview_myjournal\">My Journal</a><li><a href=\"#mygedview_media\">Random Media</a><li><a href=\"#mygedview_loggedin\">Logged In Users</a><li><a href=\"#mygedview_recent_changes\">Recent Changes</a></ul>";
$pgv_lang["mygedview_customize_help"]		= "~CUSTOMIZE #pgv_lang[upper_mygedview]#~<br />When you entered here for the first time, you already had some blocks on this page.<br />If you like, you can customize this Portal.<br />Clicking this link will bring you to a form in a pop up window, in which you can add, delete or move around blocks.<br />More explanation is available on that form.<br />";
$pgv_lang["mygedview_message_help"]			= "~MESSAGES BLOCK ~<br />In this block you will find the messages sent to you by other users or the admin.<br />Of course, you too can send messages to other users or admin.<br />The PhpGedView mail system is designed to help protect your privacy.  You don't have to leave your email address here and others will not be able to see your email address.<br /><br />To expand a message click on the message subject or the \"+\" sign beside it.  You can delete multiple messages by checking the boxes next to the messages you want to delete and clicking on the \"Delete Selected Messages\" button.<br />";
$pgv_lang["mygedview_favorites_help"]		= "~MY FAVORITES BLOCK ~<br />My favorites works like bookmarks.<br />Suppose you have somebody in the family tree whose record you want to check regularly.<br />Just go to the person's individual page, and select the \"Add to My Favorites\" option from the favorites drop-down list. This person is now book marked and added to your list of Favorites.<br />Wherever you are on this site, you can click on a name in the \"My Favorites\" drop down list in the header.<br />This will forward you to the individual page of the person.<br /><br />To save space, the boxes are displayed with limited information. At the right side of the name box you see the magnifying glass to reveal some more information.<br />Clicking the name will forward you to the individual page of the person.<br />Also at the right side you will find a menu that can take you to pages with more information or charts.<br />";
$pgv_lang["mygedview_myjournal_help"]		= "~MY JOURNAL BLOCK ~<br />You can use this journal to write notes (or reminders) for your own use.<br />Of course, when you make a note, it will still be there, the next time when you visit the site.<br /><br />These notes will not be visible for others.<br />";
$pgv_lang["mygedview_welcome_help"]			= "~ΠΛΑΙΣΙΟ ΚΑΛΩΣΟΡΙΣΜΑΤΟΣ ~<dt>This Welcome block shows you:</dt><dd>- The current GEDCOM file</dd><dd>- The date and time</dd><dd>- Links to:</dd><dd> - - #pgv_lang[myuserdata]#</dd><dd>- - #pgv_lang[my_pedigree]# (see remark)</dd><dd>- - #pgv_lang[my_indi]# (see remark)</dd><dd>- - #pgv_lang[customize_page]#</dd><br /><b>Remark</b><br />You will see the links to \"My Indi\" and \"My Pedigree\" only if you have a record in the current GEDCOM file.<br />So, it may be that in one GEDCOM file you have a record, and see the links \"My Indi\" and \"My Pedigree\", while in another GEDCOM file you do not have a record and \"My Indi\" and \"My Pedigree\" are not displayed.<br />";

//-- Pedigree-page
$pgv_lang["help_pedigree.php"]				= "~THE PEDIGREE PAGE.~<br /><br />Most users and visitors will know what a Pedigree is, but still a little information about our Pedigree:<br />The Pedigree is, in fact, an enumeration of all ancestors of the starting person.<br />When you entered this site, the starting person is the person in the box at the left (when you log in, you can choose your own starting person).<br /><br />So, \"All the ancestors\" means father and mother, and their parents and so on.<br />On this site you see the Pedigree in the graphical way.<br />You don't have to struggle through pages of text, to find out where your ancestors are.<br />All individuals are displayed in the name boxes on the screen.<br /><br />* THE NAME BOXES ON THE PEDIGREE<br />If the pedigree page is set to show details, you will see the persons name, and the dates of birth and death.<br />You can click on a persons name, and that will bring you directly to the Individual Details page.<br />When \"Show details\" is on there are two icons inside the name box.<br /><br />* PEDIGREE ICON INSIDE THE NAME BOX<br />When the option \"Show Details\" is on, you see a Pedigree Icon at the inside of the Name Box. Depending on the site-settings you have to hover over the Icon, or to click on it.<br />So, when you click on, or hover over, this icon, a small sub menu appears.<br />The item \"Pedigree Tree\" and \"Descendancy Chart\" are similar to those items in the main menu, but the difference is that the starting person is now the individual of the name box.<br />Further you see the \"Family with spouse\". You see the name of the spouse, followed by the name(s) of the children.<br />All names are clickable.<br /><br />* MAGNIFYING GLASS INSIDE THE NAME BOX<br />Also depending of the site-settings, you have to hover over it, or to click on it.<br />This magnifies the name box, so that some more details will be displayed.<br />You see more dates and events. Names are clickable.<br /><br />* THE ARROWS<br />On the left or right of the utmost left or utmost right name box(es) you may see Arrows.<br />Clicking on these arrow will \"shift\" the screen in the direction of the arrow.<br /><br />More help is available by clicking the <b>?</b> behind the boxes or links, on the page.";
$pgv_lang["show_full_help"]					= "~HIDE  OR  SHOW  DETAILS~<br /><br />With this option you can either show all details in the name boxes, or hide the details.<br /> With the details hidden, you can display more boxes on one screen.<br /><br />When you choose the option to hide the details, you still can reveal the details if the magnifying glass in the normal view is enabled.<br />It depends on how your admin has configured the program.<br />If you normally have to click on the magnifying glass to zoom in, then you can reveal details as well by clicking on the name box.<br />If you normally zoom in, just by hovering over the magnifying glass, then it will work the same way when you hover over the \"simple\" box.";
$pgv_lang["talloffset_help"]				= "~PAGE LAYOUT~<br /><br />With this option you determine the page layout orientation.<br /> Changing this setting might be useful if you want to make a screen print, or if you have a different type of screen.  Choosing portrait will make the tree taller, such that a 4 generation chart should fit on a single page in portrait mode.  Landscape will make a wider tree that should print on a single page in landscape mode.";
$pgv_lang["rootid_help"]					= "~NEW  ROOT  PERSON~<br /><br />If you want to display a tree with a new root person, then in this box you can type the ID of that new person.<br /> If you don't know the ID of the person, use the <b>>Find ID link<</b>.<br /><br /><b>ID NUMBER</b><br />The ID numbers used inside PhpGedView are not the ID card numbers of an individual!<br />The ID number is only a number used in the GEDCOM and is given by the ancestry program used to create the GEDCOM!";
$pgv_lang["PEDIGREE_GENERATIONS_help"]		= "~NUMBER  OF  GENERATIONS~<br /><br />Here you can set the number of generations to display on this page.<br />The right number for you depends of the size of your screen and whether you show details or not.";

//-- LOGIN-page
$pgv_lang["login_page_help"]				= "~Η ΣΕΛΙΔΑ ΠΡΟΣΒΑΣΗΣ~<br /><br />On this page you can Login, Request a new Password or Request a new User Account.<br />";
$pgv_lang["username_help"]					= "~ΨΕΥΔΟΝΥΜΟ ΧΡΗΣΤΗ~<br /><br />In this box you type your user name.<br />The user name is case sensitive";
$pgv_lang["password_help"]					= "~ΣΥΝΘΗΜΑΤΙΚΟ ΧΡΗΣΤΗ~<br /><br />In this box you type your password.<br />The password is case sensitive";
$pgv_lang["login_buttons_help"]				= "~LOGIN BUTTONS~<br /><br />Here you see two buttons to Login to the system.<br />To what page you will be forwarded (or sent back to), is depending of the button, that you click after typing your user name and password.<br /><br />* The <b> #pgv_lang[login]# </b> Button<br />IF you click this button, you will return to the page, you came from.<br />So, if you clicked \" #pgv_lang[login]# \" when you were at the Pedigree Page, you will return to that page.<br /><br />* The <b> #pgv_lang[admin]# </b> Button<br />If you have admin rights, you can click this button to go directly to the main Administration Page.";
$pgv_lang["login_buttons_aut_help"]			= "~AUTHENTICATION MODE~<br /><br />LOGIN BUTTONS<br /><br />Here you see two buttons to Login to the system.<br />To what page you will be forwarded (or sent back to), is depending of the button, that you click after typing your user name and password.<br /><br />* The <b> #pgv_lang[login]# </b> Button<br />IF you click this button, you will be logged in and go directly to your MyGedView page, where you edit your settings, add or edit favorites, send and read messages and so on.<br /><br />* The <b> #pgv_lang[admin]# </b> Button<br />If you have admin rights, you can click this button to go directly to the main Administration Page.";
$pgv_lang["new_password_help"]				= "~REQUEST NEW PASSWORD~<br />If you have lost your password, you can click the link to request for a new password.<br />You will be forwarded to the \"Lost Password Request Page\".";
$pgv_lang["new_user_help"]					= "~REQUEST NEW USER ACCOUNT~<br /><br />If you are a visitor of this site, who likes to request a user account, you click this link.<br />You will be forwarded to the \"Register Page\".";
$pgv_lang["mygedview_login_help"]			= "In order to access the MyGedView Portal, you must be a registered user on the system.<br /><br />With the MyGedView portal you can bookmark your favorite people, keep a user journal, manage messages, see other logged in users, and customize your experience with PhpGedView.<br /><br />Enter your User name and Password in the fields, with that name, to login to MyGedView.";
$pgv_lang["new_user_fullname_help"]			= "~#pgv_lang[fullname]#~<br /><br />In this box you have to type your full name.<br /><br />This is also the name that will be visible to other logged-in family members and users.<br /><br />Of course, we also need your full name to be able to check whether you qualify for a user account.";

//-- Descendancy-page
$pgv_lang["help_descendancy.php"]			= "~Η ΣΕΛΙΔΑ ΑΠΟΓΟΝΩΝ~<br /><br />This page will show the Descendants of a person.<br />You can choose a root person for this descendancy chart on this page, or you can be linked to this page by clicking the link \"Descendancy Chart\" on another page<br />Click on an up arrow to navigate up the tree.  Click on the chart icon in a person box to root the tree at that person.";
$pgv_lang["desc_rootid_help"]				= "~NEW  ROOT  PERSON~<br /><br />If you want to display a Descendancy Chart with a new root person, then in this box you can type the ID of that person.<br /> If you don't know the ID of the person, use the find_id link.";
$pgv_lang["desc_generations_help"]			= "~NUMBER  OF  GENERATIONS~<br /><br />Here you can set the maximum number of generations to display on this page.<br />Increasing the number of generations will increase the processing time.";
//-- show_full is used from pedigree

//-- Time line-page
$pgv_lang["help_timeline.php"]				= "~TIME LINE PAGE~<br /><br />On this page you can display one, or more, persons along a time-line.<br />In that way you can (for example) visualize the status of two, or more, persons at a certain moment.<br /><br />If you click the Time Line link, on another page, you already see one person on the Time Line.<br />If you clicked the menu item in the header, then you have to type the \"ID\" of a person in the box, to start with.";
$pgv_lang["add_person_help"]				= "~ADD PERSON TO THE CHART~<br /><br />You can have multiple persons on the time line.<br />Use this box to fill the person's ID.<br />If you don't know the ID of the person, you can click the \"Find ID\" link behind the box.";
$pgv_lang["remove_person_help"]				= "~REMOVE PERSON FROM THE CHART~<br /><br />Click this link to remove the person from the time line.";
$pgv_lang["show_age_marker_help"]			= "~SHOW AGE MARKER~<br /><br />If you check this box, you will see an age marker, which you can slide up or down along the time line.<br />This sliding Age Marker is a nice tool to check the age of a person at a certain event.<br />For each person in the chart you can enable or disable the Age Marker";

//-- Relationship-page
$pgv_lang["help_relationship.php"]			= "~RELATIONSHIP PAGE~<br /><br />On this page you can display the relationship between two people.<br />It does not mean that those two people have to be directly related by blood line.<br />Any relation will be found.";
$pgv_lang["relationship_id_help"]			= "~ID's of PERSON 1  and  PERSON 2~</b><br /><br />If you are linked from another page to this one (for example: by clicking the link \"Relation to me\", then you will see here the relationship between those two individuals.<br />Otherwise you have to type the ID's of the two persons, of whom you want to know the relationship between them.<br />If you don't know the ID's of the persons, you can click the link \"Find ID\"";
$pgv_lang["next_path_help"]					= "~FIND NEXT PATH~<br /><br />You can click this button to see whether there is another relationship path between the two persons.<br />The previous found path(s) can be displayed again by clicking the link with the path number.";
$pgv_lang["follow_spouse_help"]				= "~CHECK RELATIONSHIP BY MARRIAGE - CHECK BOX~<br /><br />With this check box <b>un</b>checked, the relationships are only checked between blood relatives.<br />With this check box checked, relationships by marriage are also checked.  You will likely find more relationships by leaving this box checked.";
$pgv_lang["line_up_generations_help"]		= "~LINE UP GENERATIONS - CHECK BOX~<br /><br />This check box selected the chart will be printed with the same generations lining up horizontally on the page.  Unchecked each generation will appear going down the page no matter if it is a parent or a child relationship.";
$pgv_lang["oldest_top_help"]				= "~SHOW OLDEST TOP - CHECK BOX~<br /><br />This check box selected the chart will be printed with oldest people at the top.<br />Unchecked, youngest people will appear at the top.<br /><br />NB : This option works only if <i>#pgv_lang[line_up_generations]#</i> is checked.";

//-- Ancestry-page
$pgv_lang["help_ancestry.php"]				= "~#pgv_lang[ancestry_chart]# page~<br /><br />The Ancestry page is very similar to the <a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a>, but with more details and alternate <a href=\"?help=chart_style_help\">#pgv_lang[chart_style]#</a> displays.<br /><br />Each ancestry is shown with a unique number, calculated from the <i>Sosa-Stradonitz</i> system :<br /> - even numbers for men (child*2)<br /> - odd numbers for women (husband+1) except for <big>1</big><br /><br />Ex: <big>7</big> is the wife of <big>6</big>, the mother of <big>3</big>, and the daughter of <big>14</big> and <big>15</big>.";
$pgv_lang["box_width_help"]					= "~#pgv_lang[ancestry_chart]# box width~</b><br /><br />Here you can change the box width from 50% to 300%.<br />Normal value is 100% : each box is about 270 pixels width.";
$pgv_lang["chart_style_help"]				= "~#pgv_lang[ancestry_chart]# style~<br /><br /><dl><dt>#pgv_lang[ancestry_list]#</dt><dd>Vertical tree, with  collapsable/expandable families.</dd><dt>#pgv_lang[ancestry_booklet]#</dt><dd>One family per page, with parents, grandparents and all recorded children.<br />Easy to print and give to your relatives.</dd></dl>";

//-- Fan chart-page
$pgv_lang["help_fanchart.php"]				= "~#pgv_lang[fan_chart]# page~<br /><br />The Fan Chart is very similar to the <a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a>, on a more graphical way.<br /><br />The Root Person is shown in the center, his parents on the first ring, grandparents on the second ring, and so on...<br /><br />Year of birth and death are printed under the name when known.<br /><br />Clicking on a name on the chart will place that person in the center.  Near the center person is an arrow that will open a box that will allow you to navigate the chart to one of the Root Person's children (or brothers or sisters) as you can with the <a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a>.";
$pgv_lang["fan_width_help"]					= "~#pgv_lang[fan_chart]# width~</b><br /><br />Here you can change the fan chart width from 50% to 300%.<br />Normal value is 100% : output image is about 640 pixels width.";
$pgv_lang["fan_style_help"]					= "~#pgv_lang[fan_chart]# style~<br /><br /><dl><dt>1/2</dt><dd>Half circle (180 deg) fan chart</dd><dt>3/4</dt><dd>Three-quarter (270 deg) fan chart or 'Angel wing'</dd><dt>4/4</dt><dd>Full circle (360 deg) fan chart</dd></dl>";

//-- Indilist-page
$pgv_lang["help_indilist.php"]				= "~INDIVIDUALS LIST PAGE~<br /><br />On this page you can display a list of individuals.<br /><br />The names will be displayed, Surnames first and sorted in alphabetical order.<br />The output of the name list depends of:<br /><b>1.</b> The letter you clicked in the alphabet-index.<br /><b>2.</b> You clicked \"Skip\" or \"Show\" Surname List.<br /><br />If you need more help about this, please click the ? behind the items.";
$pgv_lang["alpha_help"]						= "~ALPHABETICAL INDEX~<br /><br />Clicking a character in the Alphabetical index will display a list with names, starting with the character you clicked.<br />The second to last item in the Alphabetical index can be <b>(unknown)</b><br />This is displayed if there are people in the GEDCOM, whose surname is not entered in the persons' GEDCOM record, or does not contain any characters from the supported languages.<br />An unknown person, also.<br /><br /><b>Attention</b><br />If in a persons' GEDCOM record, the surname is entered like (for example): Nn, NN, Unknown, or even N.N., then that person's name will <b>not</b> be displayed, by clicking <b>(unknown)</b>. You will find these persons by clicking \"<b>N</b>\" or \"<b>U</b>\" (for the example in this line).<br />This is because the program will only check whether there is a surname entry in the persons' record of the GEDCOM file.<br /><br />At the end of the Alphabetical index you see \"<b>ALL</b>\". Clicking this, will display a list of all surnames in the GEDCOM file.<br /><br /><b>Missing characters?</b><br />It may be that, in your alphabetical index, one or more characters are \"missing\".<br />Well, they are not missing, it simply means that there are no records in the list, with a surname, starting with that \"missing\" character.";
$pgv_lang["name_list_help"]					= "~NAME LIST~<br /><br />This box will either display a surname list or a complete name list.<br />In both cases all surnames will start with the initial character that you clicked in the alphabetical index. Unless you clicked \"ALL\"<br /><br />Whether you will see a surname list or the complete list, is depending of the status of the link below the box.";
$pgv_lang["skip_sublist_help"]				= "~SKIP SUBLIST~<br /><br />The standard setting is that you will get a sub-list with surnames, after you have clicked a character of the alphabetical index.<br />If you click this link, the surname list will be skipped and all the names, with the initial character, will be displayed.";

//-- Families-page
$pgv_lang["help_famlist.php"]				= "~FAMILY LIST PAGE~<br /><br />On this page you can display a list of families.<br /><br />The names will be displayed Surnames first and sorted in alphabetical order.<br />The output of the name list depends of:<br /><b>1.</b> The letter you clicked in the alphabet-index.<br /><b>2.</b> You clicked \"Skip\" or \"Show\" Surname List.<br /><br />You can search on the husbands surname as well as on the wifes surname. Both are included in the list.<br /><br />If you need more help about this, please click the ? behind the items.";
$pgv_lang["help_family.php"]				= "~FAMILY DETAILS PAGE~<br /><br />This page will show you an overview of the family that you chose on a previous page.<br />From top to bottom you will see the personal details boxes of:<br />The husband and his parents, the wife and her parents, and the children.<br /><br />The layout and contents of the person boxes is the same as the boxes that you already know from the Pedigree page and Descendancy page.<br />To the right of the parent boxes you may see an arrow if more ancestors exist in the file. Clicking that arrow will move you up a generation bringing you to a new family page with the parents listed as the husband and wife.<br />At the right side <i>in</i> the name box you may see a magnifying glass to reveal some more information on details of the individual. Clicking the name will forward you to the individual page of the person.<br />Also at the right side you will find a small menu, that can take to pages with more information or charts.<br /><br />The Family Group Information shows all known facts and information about this family, like marriage, multimedia objects and notes. In the fact information, clicking a place will bring you to the placelist, where all other families and individuals, connected to that place are shown. Clicking a date will jump to the day-calendar, which will show all events, that happened on that day and month in history. Also multimedia objects can be clicked, this will open a new window in which the object is viewed. If you click on a source link, the details of that source will be displayed on the source page.<br /><br />Below the name boxes of the child(ren) you find the link to \"Add a child to this Family\".<br />Next to the name boxes of the children you see the \"Family Group Information\".<br />If you have enough rights, you can edit, delete, and add data and facts here.<br /><br />At the right side at the screen you see, if enabled by the admin, the icons and links for:<br /><b>View GEDCOM Record</b>, which shows the information in GEDCOM format.<br /><b>Add to Clipping Cart</b>, which enables you to store this information in your clippings cart. From there you can download the information and import it in your own genealogy program.<br /><b>Show couple on timeline chart</b>, which will jump to the Timeline Chart and display all facts of the couple on a timeline scale.<br /><br />#pgv_lang[more_help]#";
$pgv_lang["add_child_help"]					= "~ADD CHILD TO THIS FAMILY~<br /><br />By clicking this link, you can add a child to this family.<br />Adding a child is simple: Just click the link, fill out the boxes in the pop up screen and that's all.<br />";
$pgv_lang["show_fam_gedcom_help"]			= "~SHOW GEDCOM RECORD~<br /><br />By clicking this link, the information about the family, as it is stored in the GEDCOM, will be displayed in a popup window.";
$pgv_lang["add_fam_clip_help"]				= "~ADD FAMILY TO CLIPPING CART~<br /><br />By clicking this link you can add the family information, as it is stored in the GEDCOM, to your Clipping Cart. On the next page you can choose which information you exactely wish to add: just this parents, or also their parents and/or their children and/or all descendants.";
$pgv_lang["show_fam_timeline_help"]			= "~SHOW COUPLE ON TIMELINE CHART~<br /><br />By clicking this link you will jump to the timeline page, where all facts of the couple will be displayed on the timeline scale.";
//-- same variables as individuals page

//-- Source list-page
$pgv_lang["help_sourcelist.php"]			= "~SOURCES LIST PAGE~<br /><br />On this page a list of sources is displayed.<br />Unlike the Individual Page and the Family Page there is no alphabetical index on top. This is because sources can be individuals with, of course, given name and surname, or it can be public databases or institute, etc.<br />That means that it is difficult to find a sortorder. The names of the sources are sorted in alphabetical order, as stored in the GEDCOM.<br /><br /><b>SOURCES</b><br />Without sources we can not build our database. For all information stored in the database is a source. It can be a relative of a person an institute, public database, etc.<br />A source can be linked to many persons. On the other hand, one person can be linked to many sources as well. You can have different sources for every event, whether it is birth date, profession, marriage, children, etc. etc. ";
$pgv_lang["sourcelist_listbox_help"]		= "~SOURCES LIST BOX~<br /><br />In this box you see the names of the sources, as they are stored in the GEDCOM.<br />The names are displayed in alphabetical order.<br /><br />When you click on a name in the list, you will go to the source page where a list is displayed which persons and/or families are linked to that source.";

//-- Sources-page
$pgv_lang["help_source.php"]				= "~SOURCE DETAILS PAGE~<br /><br />On this page the details of the source are displayed.  Sources are very important to genealogical researchers and will allow you to follow the trail another researcher used to find the information.<br />On this page you may see information about the source's title, author, publication, and the repository where the source was looked up.  Because of the many different types of sources, some sources may have more information than other sources.<br /><br />If a multimedia object is connected to the source (like a scan of a document), you can view the object in a large window by either clicking the object or the filename beside it.<br /><br />After the source details, will be a list of all individuals and families who are linked to this source.  This allows you to see all of the information that was obtained from a particular data source.<br /><br />If enabled by the site admin, you will have one or two more menu icons on this page:<br /><b>View GEDCOM Record</b>, which shows the information in GEDCOM format.<br /><b>Add to Clipping Cart</b>, which enables you to store this information in your clippings cart. From there you can download the information and import it in your own genealogy program.<br /><br />More help is available on the page by clicking on the <b>?</b>";
$pgv_lang["sources_listbox_help"]			= "~RECORDS LINKED TO THIS SOURCE~<br /><br />In this box you see the names of individuals and families that are linked to the source.<br />The names are displayed in alphabetical order.<br /><br />When you click on a name in the list, you will go to the detail page of the individual or family.";
$pgv_lang["show_source_gedcom_help"]		= "~SHOW GEDCOM RECORD~<br /><br />By clicking this link, the information about the source, as it is stored in the GEDCOM, will be displayed in a popup window.";
$pgv_lang["add_source_clip_help"]			= "~ADD SOURCE TO CLIPPING CART~<br /><br />By clicking this link you can add the source, as it is stored in the GEDCOM, to your Clipping Cart.";
$pgv_lang["delete_source_help"]				= "~DELETE SOURCE FROM GEDCOM~<br /><br />By clicking this option you will mark this Source to be deleted from the GEDCOM.<br />What does that mean?<br />Let's suppose you have a good reason to remove this source from the GEDCOM. You click the link, and after that you will get a pop-up and asked whether you are sure, or want to cancel.<br /><br />If you continue to remove the source, it can take a little time, before you get a pop-up window with the message that the source is deleted.<br /><br />When you continue with your visit, you will notice that the source is still visible, and can even be used, just like before.<br /><br />This is <b>not</b> an error.<br />The site admin will get a message that a change has been made to the GEDCOM, and that you removed the Source.<br />The administrator has to accept (or reject) your change. Only then the process can not be reversed.<br />In case of a doubt, the administrator will contact you.";

//-- Persons per Place-page
$pgv_lang["help_placelist.php"]				= "~PLACE HIERARCHY~<br />(or Persons Per Place)<br /><br />This page will show you a hierarchy of the places in the GEDCOM and which individuals or families are connected to a location.<br /><br />If there is any connection between an individual or family and an event at a certain location, the program will find it for you.<br /><br />The results are displayed in a two-column list:<br />One for individuals and one for families.<br /><br />#pgv_lang[more_help]#";
$pgv_lang["ppp_default_form_help"]			= "~PLACE ORDER FORMAT~<br /><br /><b>DEFAULT ORDER</b><br />This means that there is no specified place encoding format found in this GEDCOM file.<br />In this case the default format is assumed.<br /><br />If another format was found in this GEDCOM file, it would have been showed between the (...) at the end of the line.";
$pgv_lang["ppp_match_one_help"]				= "~PLACE ORDER FORMAT~<br /><br />GEDCOM ORDER<br />The locations are assumed to be encoded in the format order as found in the GEDCOM file.<br />This overrules the default order, which is used when a format description is found in the GEDCOM";
$pgv_lang["ppp_numfound_help"]				= "~FOUND PLACE CONNECTIONS~<br /><br />The number of matches that are found is displayed here.<br />If you still see a list box with locations, it means that have not reached the lowest level yet.<br />You can choose to view all records found in this place or you can refine your search by clicking another location.";
$pgv_lang["ppp_levels_help"]				= "~LOCATION LEVELS~<br /><br />This is showing the levels that are displayed now.<br />The list box, which shows the places, is in fact a sublist of the utmost left Level.<br /><br />EXAMPLE:<br />The (default) order is: #pgv_lang[default_form]#<br />If the current level is \"Top Level\", then the box will list all the countries in the GEDCOM.<br />If the current level shows: \"U.S.A., Top Level\" , then the box will list all the states in the U.S.A.<br />etc.<br /><br />You can click a level, to go back one or more steps.";
$pgv_lang["ppp_placelist_help"]				= "~PLACE HIERARCHY~<br /><br />In this list you can see the Locations that are found under the current location you have chosen.  If you have not yet selected a place, you will see a list of all of the top level locations (ie. countries or states).<br />The names of the locations in the list are clickable.<br />Clicking on a location works like a filter. It will bring you to the next level down.";
$pgv_lang["ppp_placelist_help2"]			= "~PLACE LIST~<br /><br />In this list you can see the Locations that are found by now.<br />The names of the locations in the list are clickable.<br />Clicking on a location works like a filter. It will bring you to the next level down.<br />Only when you are in the top level, a name list will not be displayed. At all other levels down, you will get the list of persons and / or families, found at that location.";
$pgv_lang["ppp_view_records_help"]			= "~VIEW ALL RECORDS~<br /><br />Clicking on this link will show you a list of all of the individuals and families that have events occuring in this place.  When you get to the end of a place hierarchy such as a town or city, the name list will automatically be shown.";
$pgv_lang["ppp_name_list_help"]				= "~NAME LIST~<br /><br />This box will display a complete name list, of individuals and / or families that are related (in any way) to the location.<br /><br />The names in the list are clickable.<br />When you click a name, it will bring you to the detail page of the individual or family.<br /><br />You may also choose to change your selection, by clicking on a location on top of this list.";

//-- Multimedia-page
$pgv_lang["help_medialist.php"]				= "~MULTI MEDIA OBJECT LIST~<br /><br />This page lists all of the Multi Media Objects (MMO) that can be found in this GEDCOM.<br /><br />For each of the media items you may find the title or filename of the item, names of the people or families that are connected to the item, and any notes about the item.<br /><br />Clicking the title or filename of the item has the same affect as clicking on the thumbnail of the item.<br />Depending of the file format (*.gif, *.jpg), the item will be opened in the internal PGV image viewer, or in the viewer that is connected to your local browser.<br /><br />Clicking on the \"View\" link next to the persons or families will bring you to the Individual or Family details page.<br /><br />";

//-- Upload Media-page
$pgv_lang["help_uploadmedia.php"]			= "~UPLOAD MEDIA FILES~<br /><br />Uploading the Files is simple, so here just some additional information.<br /><br /><b>Thumbnails</b><br />Thumbnails should have a size somewhere around 100px width.<br />The filename has to be the same as the original.<br /><br /><b>Uploading</b><br />The files will be uploaded automatically to the directory ../media for the large copies and ../media/thumbs/ for the thumbnails.<br /><br />#pgv_lang[readme_help]#";

//-- Anniversaries-page
$pgv_lang["help_calendar.php"]				= "~ANNIVERSARY CALENDAR~<br /><br /><ul><li><a href=\"#calendar_general\">General information</a><li><a href=\"#calendar_day\">#pgv_lang[day]#</a><li><a href=\"#calendar_month\">#pgv_lang[month]#</a><li><a href=\"#calendar_year\">#pgv_lang[year]#</a><li><a href=\"#calendar_show\">#pgv_lang[show]# / #pgv_lang[showcal]#</a><li><a href=\"#calendar_sex\">#pgv_lang[sex]#</a><li><a href=\"#calendar_event\">Event</a><li><a href=\"#calendar_button\">Select mode (buttons)</a><li><a href=\"#calendar_tip\">Tip</a></ul><br /><a name=\"calendar_general\"></a>The Anniversary Calendar shows the persons and families who are linked to an event at a certain day and/or month or in a certain period of time. It has an advanced filtering system to select the right date or period, and events for you.<dl><dt><b>View <a href=\"#calendar_day\">Day</a></b></dt><dd>This shows the events on a certain day, independent of the selected year. Output will be either a single list with the names of Individuals or Families, or a two-column list with Individuals on one side and Families on the other.</dd><dt><b>View <a href=\"#calendar_month\">Month</a></b></dt><dd>In the <b>Calendar</b> the names of Individuals as well as the names of the Families are shown inside the day boxes. The calendar is shown as it was in the year you typed in in the year box. All events that happened in the past up to that year are shown.<br />In combination with the option \"<a href=\"#calendar_show\">#pgv_lang[recent_events]#</a>\" it will give a realistic view on how a calendar of your ancestors looked like.</dd><dt><b>View <a href=\"#calendar_year\">Year</a></b></dt><dd>This shows the events in a certain year, or in a number of years. Output will be either a single list with the names of Individuals or Families, or a two-column list with Individuals on one side and Families on the other.</dd></dl>The date and month displayed in a highlighted color, in the calendar menu, are the currently shown ones.<br /><br />The names and dates that appear in the list or in the calendar, are clickable.<br />Clicking on a name will bring you to the details page of the person or family, clicking on a date will jump to \"Today\" mode (or Year) which will display all events for the day and month in the clicked date.<br /><br /><a href=\"#top\">#pgv_lang[UpArrow]#</a><a name=\"calendar_day\"> </a>#pgv_lang[annivers_date_select_help]#<br /><a href=\"#top\">#pgv_lang[UpArrow]#</a><a name=\"calendar_month\"> </a>#pgv_lang[annivers_month_select_help]#<br /><a href=\"#top\">#pgv_lang[UpArrow]#</a><a name=\"calendar_year\"> </a>#pgv_lang[annivers_year_select_help]#<br /><a href=\"#top\">#pgv_lang[UpArrow]#</a><a name=\"calendar_show\"> </a>#pgv_lang[annivers_show_help]#<br /><a href=\"#top\">#pgv_lang[UpArrow]#</a><a name=\"calendar_sex\"> </a>#pgv_lang[annivers_sex_help]#<br /><a href=\"#top\">#pgv_lang[UpArrow]#</a><a name=\"calendar_event\"> </a>#pgv_lang[annivers_event_help]#<br /><a href=\"#top\">#pgv_lang[UpArrow]#</a><a name=\"calendar_button\"> </a>#pgv_lang[day_month_help]#<br /><a href=\"#top\">#pgv_lang[UpArrow]#</a><a name=\"calendar_tip\"> </a>#pgv_lang[annivers_tip_help]#";
$pgv_lang["annivers_date_select_help"]		= "~ΕΠΙΛΟΓΗ ΗΜΕΡΑΣ~<br /><br />The top row of the \"Selector Table\" is the <b>Day Selector</b>.<br />The meaning of it is obvious: You select a day.<br />The result of clicking on a certain day depends of whether you are in the \"Day mode\" or in the \"Month mode\".<br /><br />The <b>Day mode</b>:<br />In this mode, when you have clicked a day, the screen will refresh and the list, of the day you clicked, will be displayed.<br /><br />The <b>Month mode</b>:<br />When you have the calendar of a certain month on the screen and click a day in the \"Day\" row of the selector table, the screen will refresh, but you will still see the month that you had on the screen before.<br />The reason for this is that you can still make up your mind to select another month, year, or event to show, before you either click the <b>#pgv_lang[viewday]#</b> or <b>#pgv_lang[viewmonth]# Button</b>.<br /><br />At the end of the Day row you will see the <b>\"Quick Link\"</b> with today's date.<br />Clicking that \"Quick Link\" will display the list of today, in the \"Day mode\", no matter whether you are in the Month mode, or in the Day mode.<br />";
$pgv_lang["annivers_month_select_help"]		= "~ΕΠΙΛΟΓΗ ΜΗΝΑ~<br /><br />The middle row of the \"Selector Table\" is the <b>Month Selector</b>.<br />Like the \"Day Selector\", is the meaning of it obvious as well: You select a month.<br /><br />And also like the Day Selector is the result of clicking on a month in the \"Day mode\" different from clicking on a month in the \"Month mode\".<br /><br />The <b>Day mode</b>:<br />In this mode, when you have clicked a month, the screen will refresh and the list will be displayed with the dates for the new selected month.<br />All other settings like day, year, and events will remain the same.<br /><br />The <b>Month mode</b>:<br />When you have the calendar on the screen and click a month in the \"Month\" row of the selector table, the calendar of the new month will be displayed.<br /><br />At the end of the Month row you will see the <b>\"Quick Link\"</b> with the current month.<br />Clicking that \"Quick Link\" will display the calendar of this month, no matter whether you are in the Month mode, or in the Day mode.<br />";
$pgv_lang["annivers_year_select_help"]		= "~YEAR INPUT BOX~<br /><br />This input box is for changing the year for the calendar in the \"Month mode\" or the list in the \"Year mode\".<br />In \"Day mode\" changing the year will make no difference, as all events of all years are displayed.<dl><dt><b>Advanced features</b> for <b>#pgv_lang[viewyear]#:<br />More than one year</b></dt><dd>You may search for more than one year by entering this in the year field:<br />- Ex. 1: <b>1992-5</b> for all events from 1992 until 1995.<br />- Ex. 2: <b>1972-89</b> for all events from 1972 until 1989.<br />- Ex. 3: <b>1610-759</b> for all events from 1610 until 1759.<br />- Ex. 4: <b>1880-1905</b> for all events from 1880 until 1905.<br />- Ex. 5: <b>880-1105</b> for all events from 880 until 1105.<br /><br />You may also leave out the last number of the year to get all events with a date in a certain decade.<br />- Ex.: <b>197</b> for all events from 1970 until 1979.</dd><dt><br /><b>Abbreviations</b></dt><dd>Sometimes it's not clear when an event exactly happened. In that case terms like \"after\", \"before\" and \"about\" can be added to a date. The dates are stored in the GEDCOM together with an abbreviation of the term. In the Year mode you can also execute searches on the terms, with or without the accompanying date. Some examples of these searches are:<br /><b>abt</b> 1800 (abt = about)<br /><b>bet</b> 1950-1959 (bet = between) enter: bet 1950 or just: 1950-59<br /><b>bef</b> 1950 (bef = before)<br /><b>aft</b> 1900 (aft = after)<br /><br /><b>Note:</b> PhpGedView will search for the exact string you entered. When you search for \"abt 1850\", a date stored in the GEDCOM like \"abt oct 1850\" will <b>not</b> be included in the search results. - You may enter just the abbreviation without the year, to get all events with dates which contain that abbreviation.</dd></dl>Typing in another year will not directly refresh the screen.<br />Since this input box is not a link, you will have to click the <b>#pgv_lang[viewmonth]#</b> or <b>#pgv_lang[viewyear]#</b> Button before you will see the new situation.<br />";
$pgv_lang["annivers_show_help"]				= "~SHOW EVENTS OF...~<br />When you are not logged in you can choose between two options:<br /><br /><b>1. All People</b><br />With this option, all Persons and Families are displayed.<br /><br /><b>2. Recent Years (<100 yrs)</b><br />With this option you will see all events, on/in the chosen day/month, but no events longer than 100 years ago, will be listed.<br /><br />There is also a third option. For this you must be either Logged in, or the admin must have set up the system in a way that Living People can be displayed to anyone.<br /><br /><b>3. Living People</b><br />With this option selected, only the events of living persons will be displayed.<br /><br />Clicking on an option will refresh the screen, and the events of your choice will be displayed.<br />The settings of day, month, year, and day mode or month mode remain as they were.<br />";
$pgv_lang["annivers_sex_help"]				= "~SEX SELECTOR~<br />When you are logged in (or if the admin has disabled the privacy option) you can choose between three options:<dl><dt><b>1. All icon</b></dt><dd>With this option (default), the events of all Individuals and Families are displayed.</dd><dt><b>2. Male icon</b></dt><dd>Here only events of male individuals are displayed. Also male members of families will be displayed with the family event(s).</dd><dt><b>3. Female icon</b></dt><dd>Here only events of female individuals are displayed. Also female members of families will be displayed with the family event(s).</dd></dl>Clicking on an option will refresh the screen, and the events of your choice will be displayed.<br />Other settings of day, month, year, and events and mode remain as they were.<br />";
$pgv_lang["annivers_event_help"]			= "~EVENT SELECTOR~<br />Here you choose if you want all events for Individuals and Families displayed or just the event you select.<br /><br />Clicking on an option will refresh the screen, and the events of your choice will be displayed.<br />Other settings of day, month, year, and events and mode remain as they were.<br />";
$pgv_lang["annivers_tip_help"]				= "~TIP~<br />Just suppose you have a relative that was born on January 25, 1875.<br />Adjust the date selector to that date.<br />When you click now on one of the View buttons, you will see a list or calendar for that date.<br />All the ages, anniversaries, etc. are recalculated and count back from the date you have set in the date selector.<br />So, in fact you are now seeing the same in the list or on the calendar, as your relative would have seen, a long time ago.<br />";
$pgv_lang["day_month_help"]					= "~VIEW DAY / VIEW MONTH / VIEW YEAR BUTTONS~<br /><br />The <b>View Day</b> button will display the events of the chosen date in a list. All years are scanned, so only the day and month can be set here. Changing the year will have no effect.<br />You can limit the list by choosing the option \"Recent years\" or, if available, \"Living people\".<br />The ages in the list will be calculated from the current year.<br /><br />The <b>View Month</b> button will display a calendar diagram of the chosen month and year. Here too you can limit the lists by additionally clicking \"Living People\" or \"Recent years\".<br />By choosing a year in the past in combination with \"Recent years\", you will get a realistic impression of what a calendar on the wall of your ancestors looked like. All ages on the calendar are shown relative to the year in the yearbox.<br /><br />The <b>View Year</b> button will show you a list of events of the chosen year.<br />Again, you can limit the list by choosing the option \"Recent years\" or, if available, \"Living people\".<br />A nice feature is the possibility to show events for more than one year: Just type the last number in the second year right behind the first year separated with a \"-\" (f.ex: 1992-4 for all events from 1992 till 1994, or 1976-1984 for all events from 1976 till 1984).<br />- You may also just enter the first numbers of the year and have all events who starts with these numbers. (f.ex: 197 for all events from 1970 till 1979)<br /><br />When you want to <b>change the year</b> you <b>have</b> to press one of these three buttons.<br /><br />All other settings remain as they were, when clicking one of these buttons.<br />";

//-- Clipping Cart-page
$pgv_lang["help_clippings.php"]				= "~The Family Tree Clippings Cart~<br />The clippings cart allows you to take \"clippings\" from this family tree and bundle them up into a single GEDCOM file for downloading.<br /><br />* How to take clippings?<br />This is really simple. Whenever you see a clickable name (individual, family or source) you can go to the details page of that name. From there you will see the option \"Add to Clipping Cart\".<br />Clicking that link brings you to the page where you are offered several options to download.<br /><br />* How to download?<br />Once you have items in your cart, you can download them just by clicking the \"Download Now\" link.<br />Then follow the instructions and links.";
$pgv_lang["clip_download_help"]				= "~DOWNLOAD the CLIPPINGS~<br /><br />By clicking this link, you will be forwarded to the next page.<br />If there are any media items that are referenced in the GEDCOM clipping that you are downloading, they will also be displayed on that page.<br />Simply follow the instructions.";
$pgv_lang["empty_cart_help"]				= "~EMPTY the CLIPPINGS CART~<br /><br />By clicking this link, your Clipping Cart will be totally emptied.<br /><br />If you don't want to remove all persons, families, etc. from the Clipping Cart, you can remove item by item by clicking the \"Remove\" link in the name boxes. ";

//-- GEDCOM Edit Utility
$pgv_lang["show_changes_help"]				= "~SHOW CHANGES OF THE GEDCOM~<br /><br />When you see this message, it means two thing:<br /><br />1. Somebody has made changes to the GEDCOM<br />Record(s) may have been added, deleted, or changed.<br /><br />2. The changes have not been accepted yet by the administrator.<br />Once the changes have been accepted (or rejected), you will not see this message anymore.<br /><br /><br />By clicking the link, you can see what changes have been made.<br />If you notice that a change is not correct, please notify the admin.";

//-- Search-page
$pgv_lang["help_search.php"]				= "~The SEARCH PAGE~<br /><br />Although this page looks very simple, behind the two forms on it is a very powerful search engine.<br /><br />Most genealogy web sites just let you search for a (sur)name.<br />On this site you can practically search for anything.<br /><br />The search box on the left-hand side of the screen is the same as the search box in the header.<br /><br />If you are looking for people in connection to a certain year, just type the year. The program will find all connections for you.<br /><br />Looking for a name, or place?<br />Just type in the name or place, complete or just a part of it, and the program does the rest.<br /><br />SOUNDEX search method.<br />With the search box on the right hand side, you can search for names of persons and places, even if you don't know how to write the name.<br /><br />You will find more help about these two boxes, by clicking the <b>?</b> above the boxes.<br /><br />";

$pgv_lang["search_enter_terms_help"]		= "~ENTER SEARCH TERMS~<br /><br />In this search box you can enter criteria like dates, given names, surnames, places, multimedia, etc.<br /><br /><b>Wildcards</b><br />Wildcards, as you probably know them (like * or ?), are not allowed, but the program will automatically assume wildcards.<br />What does this mean?<br />Suppose you type in the search box the following: \"<b>Pete</b>\"<br />The result will be (again suppose the names are in the database):<br /><b>Pete</b> Smith<br /><b>Pete</b>r Johnes<br />Will <b>Pete</b>rson<br />somebody --Born 01 January 1901 <b>Pete</b>rsburg<br />etc., etc.<br /><br /><b>Dates</b><br />Typing a year in the search box, will give the names of all persons, who are somehow connected to that year.<br />If you type 1950, then the result will be the persons, born in 1950, or married, or died, or....whatever other event is connected to 1950.<br /><br />If you type \"4 Dec\", then all persons, connected to an event on the 4th of december of whatever year will be listed.<br />But also persons connected to an event on the 14th or 24th of December.<br />As you see, also here wildcards are assumed, so you do not have to type them.<br /><br /><b>Proper dates</b><br />The program is searching for data, as they are stored in the GEDCOM file.<br />So if you want to search for an event on December 14th, you should type:<br /><b>14 dec</b><br />because this is the way how the date is stored inside the GEDCOM file.<br />However, if you would type \"<b>dec 14</b>\", then the result will be a person connected to an event on 08 <b>dec</b>ember 18<b>14</b>.  You can also use regular expressions in your search if you are familiar with them.  For example, if you wanted to find all of the people who have dates in the 20th century, you could enter the search 19[0-9][0-9] and you would get all of the people with dates from 1900-1999.<br /><br />If you need more Help with this searching system, please let us know, so that we can extend this Help-file as well.";

$pgv_lang["soundex_search_help"]			= "~SEARCH THE WAY YOU THINK THE NAME IS WRITTEN (SOUNDEX): ~<br /><br />The SOUNDEX name search is also rather powerful.<br />First a short explanation of Soundex:<br /><br />Soundex sorts together names that sound similar but have different spellings. A soundex code begins with the first letter of the name followed by a three-digit code that represents the first three remaining consonants. Zeros will be added to names that do not have enough letters to be coded.<br /><br />In plain English this means:<br />If you are searching for \"Smith\", you can get as result:<br />Smith - Smid - Smit - Schmidt, Smyth, Smithe, Smithee, Schmitt, Smead,  Sneed, Smoote etc.<br /><br />You don't have to worry about the Soundex codes.<br />Just type in the name that you ar looking for, and the program does the work.<br /><br />The Soundex system is very good to use: sometimes you know a name, but you don't know the exact spelling of it.<br />It can also happen that a mistake was made, by putting the name into the database.<br />Using the Soundex system, you will still be able to find the name.<br /><br />To get used to it, try to find a certain name, but type it in the search form in a different way.<br /><br />In this Soundex search form, any name is enough to start searching.<br />You can search on last name, given name or place name.<br />Filling in more than one field works like \"AND\".<br />You can also limit the search results by entering a year or year range. Examples are: 1950 or 19[5-7][0-9] which represents 1950 to 1979.<br />The search results will contain any individual with an event in the given place, in the given year range.";

//-- Individuals-page
$pgv_lang["help_individual.php"]			= "~INDIVIDUAL'S DETAILS PAGE~<br /><br />On this page all details of a person are displayed.<br /><br />If there is a picture available, you will see it at the top left side.<br />Next to the picture (if present) you will see the name(s) of the person.<br />Names can have notes and sources attached to them.  If any of the names have notes or sources, you will see them listed under the names they relate to.<br />A person might have an AKA (maybe he's known under another name). If that is the case, it will be displayed.<br /><br />If you have editing rights to this person, you will also see edit and delete links next to the items that you can edit.<br /><br />On this page you see tab sheets for \"Personal Facts and Details\", \"Notes\", \"Sources\", \"Media\", \"Close Relatives\" and (if enabled) \"Research Log\"<br /><br />On these tab sheets you will find all the information, that is stored in the GEDCOM.<br /><br />The Personal Details tab will show you the facts and details about this person and any fact from their marriages.  Clicking on any date on this tab will take you to the Anniversary Calendar for that date, so that you can see other events in this GEDCOM that happened on the same day.  Clicking on a place, will take you to the Place Hierarchy where you can view other people who had events in the same place.  For marriage and other family related facts, the name of the person's spouse is available so that you can view the spouse and a link to the family record is also provided.<br /><br />The \"Notes\" tab will show you any general notes relating to this person.<br /><br />The \"Sources\" tab will show you all of the general sources for this person.  Clicking on the title of a source will bring you to a more details source information page that will display other people who are also linked to the same source.<br /><br />The \"Media\" tab will list all of the pictures and other media items that are attached to this individual.  Clicking on a thumbnail of the picture will open up a larger view of the image.<br /><br />The \"Close Relatives\" tab lists this persons parents and siblings, as well as all of the spouses and children that this person has had.  The persons will be listed in boxes similar to the charts that you may have already seen.<br /><br />On the right hand side of the screen, you will find a box with links.<br />Many of the links in the box are the same as the links in the menus.  For example, clicking on the \"Pedigree Chart\" link on the side links will take you to the pedigree chart for this person.  This is different from the menu links, because clicking on the \"Pedigree Chart\" link in the menu will take you back to the default pedigree chart for this GEDCOM.<br /><br />On of the links that might appear in this list if it has been enabled by the admin, is the \"View GEDCOM Record\" link.  This link will show you the raw GEDCOM record of this individual.<br /><br />If the clippings cart has been enabled by the site admin, you will also have a link that will allow you to add this person to your clippings cart.<br /><br />The Relationship To me link will only appear if you are logged in and have been assigned an ID in the GEDCOM.  This link will take you to the pedigree chart and show you how you are related to this person.<br /><br />More help is available on the page by clicking on the <b>?</b> behind links or items.";
$pgv_lang["delete_person_help"]				= "~DELETE PERSON FROM GEDCOM~<br /><br />By clicking this option you will mark this PERSON to be deleted from the GEDCOM.<br /><br />What does that mean?<br />Let's suppose you have a good reason to remove this person from the GEDCOM. You click the link, and after that you will get a pop-up and asked whether you are sure, or want to cancel.<br /><br />If you continue to remove the person, it can take a little time, before you get a pop-up window with the message that the person is deleted.<br /><br />When you continue with your visit, you will notice that the person is still visible, and can even be used, just like before.<br /><br />This is <b>not</b> an error.<br />The site admin will get a message that a change has been made to the GEDCOM, and that you removed the person.<br />The administrator has to accept (or reject) your change. Only then the process can not be reversed.<br />In case of a doubt, the administrator will contact you.";
$pgv_lang["delete_name_help"]				= "~EDIT or DELETE NAME FROM GEDCOM~<br /><br /><b>EDIT NAME</b><br />By clicking this link, you will open a pop up window, in which you can edit the name of the person.<br />It is very simple, just type the changes in the boxes and click the button, close the pop up, and that's it.<br /><br /><b>DELETE NAME</b><br />By clicking this option you will mark this Name to be deleted from the GEDCOM.<br />Keep in mind that deleting the name is completely different from deleting the Person.<br />Deleting the name, just removes the name from the person. The person will not be deleted.<br />If it is an AKA that you want to delete, the person still has his other name(s).<br />If it is the only name, that you want to remove, the person will still not be deleted, but continue as \"Unknown\".<br />The person will also not be disconnected from all other links to relatives, sources, notes, etc.<br /><br />How does it work?<br />Let's suppose you have a good reason to remove this name from the GEDCOM. You click the link, and after that you will get a pop-up and asked whether you are sure, or want to cancel.<br /><br />If you continue to remove the name, it can take a little time, before you get a pop-up window with the message that the name is deleted.<br /><br />When you continue with your visit, you will notice that the name is still visible, and can even be used, just like before.<br /><br />This is <b>not</b> an error.<br />The site admin will get a message that a change has been made to the GEDCOM, and that you removed the Name.<br />The administrator has to accept (or reject) your change. Only then the process can not be reversed.<br />In case of a doubt, the administrator will contact you.";
$pgv_lang["add_name_help"]					= "~ADD NEW NAME~<br /><br />This link will allow you to add another name to this individual.  Sometimes people are known by other names and alias'.  This link allows you to add new names to a person without changing the old name.";
$pgv_lang["add_sibling_help"]				= "~ADD BROTHER OR SISTER~<br /><br />By clicking this link, you can add a child to this family.<br />\"This Family\", in this case, are the father and mother of the principal person of this screen.<br />So, keep in mind that you are going to add a brother or sister of that person.<br />Adding a brother or sister is simple: Just click the link, fill out the boxes in the pop up screen and that's all.<br /><br />If you have to add a son or daughter of the principal person, scroll down a little and click the link in \"Family with Spouse\".";
$pgv_lang["add_son_daughter_help"]			= "~ADD SON OR DAUGHTER~<br /><br />By clicking this link, you can add a child to this family.<br />\"This Family\", in this case, is the principal person of this screen and his/her spouse.<br />So, keep in mind that you are going to add a son or daughter of that person.<br />Adding a son or daughter is simple: Just click the link, fill out the boxes in the popup screen and that's all.<br /><br />If you have to add a brother or sister of the principal person, scroll up a little and click the link in \"Family with Parents\".";
$pgv_lang["link_child_help"]				= "~LINK THIS PERSON TO AN EXISTING FAMILY AS CHILD~<br /><br />By clicking this link, you can link this person as a child to an existing family.<br /><br />Suppose the parents of the person were unknown, and you found out that they (the parents) have a record in this GEDCOM.<br /><br />Just click the link, enter the ID of the family (if you don't know the ID, you can search for it in the pop up window), and you have competed the task.";
$pgv_lang["link_husband_help"]				= "~LINK THIS PERSON TO AN EXISTING FAMILY AS HUSBAND~<br /><br />This item will allow you to link the current individual as a husband to a family that is already in the GEDCOM. By clicking this link you can add this person to an existing family, of which the husband is unknown until now. The person will take the place of the unknown person. All events, marriage information and children will keep their existing links to the family.<br /><br />Just click the link, enter the ID of the family (if you don't know the ID, you can search for it in the pop up window), and you have competed the task. This is an advanced editing option that should only be used if the family you want to link to already exists.  If you just want to add a new family, use the add a new wife link.";
$pgv_lang["add_husband_help"]				= "~ADD NEW HUSBAND~<br /><br />By clicking this link, you can add a \"New\" (male) person and link this person to principal individual as a new husband.<br /><br />Just click the link, and you will get a pop up window to add the new person.<br />Fill out as many boxes as you can and click the \"Save\" button.<br /><br />That's all.";
$pgv_lang["link_wife_help"]					= "~LINK THIS PERSON TO AN EXISTING FAMILY AS WIFE~<br /><br />This item will allow you to link the current individual as a wife to a family that is already in the GEDCOM.  This is an advanced editing option that should only be used if the family you want to link to already exists.  If you just want to add a new family, use the add a new husband link.";
$pgv_lang["add_wife_help"]					= "~ADD NEW WIFE~<br /><br />By clicking this link, you can add a \"New\" (female) person and link this person to principal individual as a new wife.<br /><br />Just click the link, and you will get a pop up window to add the new person.<br />Fill out as many boxes as you can and click the \"Save\" button.<br /><br />That's all.";
$pgv_lang["add_new_parent_help"]			= "#pgv_lang[multiple_help]#<br />~ADD NEW FATHER or MOTHER~<br /><br />Of course, there will be many individuals in the GEDCOM without a record of a father and/or mother.<br /><br />In that case, on the <b>Individual's Detail</b> page, tab sheet <b>Close Relatives</b>, table <b>Family with Parents</b>, you will find the link(s) to add a <b>new</b> father and/or mother to the individual.<br /><br /><b>NOTE:</b><br />Please keep in mind that these links are for adding a <b>new</b> father and/or mother.<br />If the father of mother already has a record in this GEDCOM, then you have to use the link: <b>#pgv_lang[link_as]##pgv_lang[child]#</b>, which you also will find on the Individual's Detail Page, underneath the last table on the page.";

//-- Add Facts
$pgv_lang["add_facts_help"]					= "~ADD NEW FACTS~<br /><br />Here you can add a fact to the person (or persons).<br /><br />First choose a fact from the \"drop down list\", then click the \"Add\" button.<br />In the \"drop down list\" are already all possible facts to add to the GEDCOM file.<br />";
$pgv_lang["add_custom_facts_help"]			= "~Add custom fact~<br />If you don't find the fact, that you want to add, in the list of the GEDCOM facts, you can enter a <b>custom fact</b> as well.<br />Entering a custom factt is just as simple as entering a pre-defined factt.<br />The only difference is that you have to name the fact as well. You have to do this in the top field: <b>#pgv_lang[type]#</b><br />";
$pgv_lang["add_note_help"]					= "#pgv_lang[multiple_help]#<br />~ADD NEW NOTE~<br />If you have a note to add to this person (or these persons), this is the place to do so.<br />The process is simple, just click the link, a pop up window will be opened, and you can type your note.<br /><br />When you are finished typing, just click the button under the box, close the pop up window, and that's all.<br /><br />#pgv_lang[add_facts_general_help]#";
$pgv_lang["add_source_help"]				= "#pgv_lang[multiple_help]#<br />~ADD NEW SOURCE CITATION~<br />By clicking this link you can add a source <b>Citation</b> to this person (or these persons).<br />A pop up window will be opened, you can choose the source from the list (Find ID) and add the \"Citation\".<br /><br />At this moment it is not possible to add a complete new source, so you have to choose the source from the list.<br /><br />If the Source, that you want to add, is not in the list, please notify the admin, give him the Source details, and he will put the new source in the list.<br />For future use you can then choose your new source from the list.<br /><br />Probably, in one of the next releases, it will be possible to add your new source directly.<br /><br />#pgv_lang[add_facts_general_help]#";
$pgv_lang["add_media_help"]					= "~ADD NEW MEDIA~<br /><br />Adding Multi Media Files (MM) to the GEDCOM is a very nice feature.<br />Although this program already has a great look without media, if you add pictures or other MM to your relatives, it will only get better.<br /><br /><b>What you should understand about MM.</b><br />As you probably know, there are almost countless formats of MM. Although PhpGedView can handle the most of them, there some things to consider.<br /><br /><b>Formats</b><br />Pictures can be edit and saved in many types of formats.<br />f.e. picture.jpg / picture.png / picture.bmp / picture.gif / etc.<br />All pictures in the example will have the same size, when you look at it, but there will be a big difference in the sizes of the files.<br /><br /><b>Resolution</b><br />The resolution of a picture is given in \"dpi\" (dots per inch). You can, more or less, compare it with the differences between 25ASA - 200ASA - 800ASA of conventional photographs.<br />The higher the resolution, the better the quality, but also the bigger the size of the files.<br />Normally for a picture on the web, 75 dpi is good enough.<br /><br /><b>Colour depth</b><br />The third way to keep a file small, is to decrease the number of colours that you use.<br />The numbers of colours can differ from pure black and white till true colours and anything in between.<br />Again you can imagine that the more colours are used, the bigger the size of the files.<br /><br /><b>Why is it important to keep the file size small?</b><br /><br />First of all: Our webspace is limmited.<br />The more large files, the more web space we need on the server. The more space we need, the more money we have to pay for it.<br /><br />Download time. If you have large files, the user (also you) will have to wait long for the page to download from the server.<br />Not everybody is blessed with a cable connection, broadband or DSL.<br /><br /><b>How to upload your MM</b><br />Well, to be short: you can't.<br />Because of all reasons, mentioned above, you can not directly upload your MM to the database.<br /><br /><b>How now?</b><br />Contact the Admin that you want to add MM to the GEDCOM. He will advise you which format is needed.<br />When you have the pictures in the right format, you can email them to the Admin. He will check the formats and sizes and upload them to the MM dir of the site.<br />You can then add the MM to your relatives, using this link";
$pgv_lang["add_facts_general_help"]			= "~General info about adding~<br />When you have added a fact, note, source or multi media file to a person or persons, the addition still has to be approved by a user who has been granted acceptance rights by the site admin.<br />Meanwhile the changes are visible on the pages, marked with a different color border, to editing users but not to public users. When the addition has been approved, the borders will disappear and the new data will display normally.";
//-- Edit user
$pgv_lang["edituser_my_account_help"]		= "On this page you can change your settings and preferences.<br /><br />You can change your user name, full name, password, language, email address, theme of the site, and preferred contact method.<br /><br />The item that you cannot change yourself is the GEDCOM INDI record ID.<br /><br />";
$pgv_lang["edituser_username_help"]			= "~#pgv_lang[username]#~<br /><br />In this box you can change your User Name.<br />If you don't like your user name anymore, or have other reasons to change it, you can do so, using this form.<br /><br />The username is <b>case sensitive</b>. That means that \"John\" is not the same as \"john\" or \"JOHN\".<br /><br />You should <b>only</b> use characters from those alphabets that are supported by the program (uppercase and lower case), numbers, dash (-), and underscore (_).<br /><br />Do <b>not</b> use punctuation marks, spaces or other characters apart from the supported alphabets.";
$pgv_lang["edituser_fullname_help"]			= "~#pgv_lang[fullname]#~<br /><br />In this box you can change your Full Name.<br />Although it is up to you to change your Full Name, it is probably better to inform, at least, the site admin about this changing.<br />Like you can see the names of other logged-in users, they also can see your name. So, if they suddenly see an unknown person, they might wonder who is at the site.<br />";
$pgv_lang["edituser_gedcomid_help"]			= "~#pgv_lang[gedcomid]#~<br /><br />This is an internal (GEDCOM ID) that links you to your own data in the GEDCOM File.<br /><br />You can not change this ID.<br />This link is set by the site administrator.<br />If you think that this ID is not correct, you should contact the site admin. to have it changed.<br />";
$pgv_lang["edituser_rootid_help"]			= "~#pgv_lang[rootid]#~<br /><br />This is the Root person of all your charts.<br />The Root person is the starting person.<br />If you would click (for example) the link to the Pedigree, then you see this root person in the utmost left box.<br />Of course, this root person does not have to be yourself. You can start with any person, as long you have the rights to see that person.<br />In some charts you can change the Root person, but that is just for those particular pages.<br />";
$pgv_lang["edituser_password_help"]			= "~#pgv_lang[password]#~<br /><br />It is a good practice to change your password at a regular basis.<br />You have to keep in mind that everybody who knows your user name and password, will have access to your data.<br />Make a password of at least 6 characters. The longer the better. You may use all characters of the alphabet, numbers, and any other character you can find on your keyboard.<br /><b>Note:</b> It is better <b>not</b> to use \" (quotes) or ' (single quotes). They might work, but it is not guaranteed.<br /><br /><b>Make a combination of Upper case, lower case, numbers and other characters</b>. For example: 5Z_q\$P4=r9.<br /><br />Like the username, the password is <b>case sensitive</b>. That means that \"Jo5hn\" is not the same as \"jo5hn\" or \"JO5HN\".";
$pgv_lang["edituser_conf_password_help"]	= "~#pgv_lang[confirm]#~<br /><br />If you have changed you Password, you need to confirm it as well.<br />This is just to make sure that you did not make a typing error in the password field.<br />If the program sees that the password and confirmation are not similar, you will get this error message: <b>#pgv_lang[password_mismatch]#</b>.<br />Both password field and confirmation will be cleared and you will have to type again the new password in both fields.<br />";
$pgv_lang["edituser_change_lang_help"]		= "~#pgv_lang[change_lang]#~<br /><br />Here you can set a Language as your default language for this site.<br />The program is capable to recognize the <b>Preferred Language Setting</b> of your browser, so in most cases there is no reason to change here your preferred language for the program.<br />However, if for example your browser has English as Preferred Language, but you want to have the <b>Site Language</b> in Dutch or Hebrew, you can change it here.<br />";
$pgv_lang["edituser_email_help"]			= "~#pgv_lang[emailadress]#~<br /><br />Your correct Email Address is, of course, important to us to keep in touch with you.<br />If you get a new email address, for example when you changed your provider, please do not forget to change the address here as well.<br />Maybe you have more than one email address and want to receive your messages from us at another email address, please change it here.<br />";
$pgv_lang["edituser_user_theme_help"]		= "~#pgv_lang[user_theme]#~<br /><br />On this site we have several Themes.<br />You could call it as well \"Site Lay out\". In every Theme you will see the same data, just in another layout.<br />It is like putting a picture in a different frame, and hang the picture in a different room as well. The picture does not change, but the way you look at it, is completely different.<br />Just give it a try. Set it to another theme. Look at it, try another. Change back to the one, that like most.<br />Every time when you log in, the program will give you your \"own\" theme again.<br />";
$pgv_lang["edituser_contact_meth_help"]		= "~#pgv_lang[user_contact_method]#~<br />Our mail systems a some different contact methods<br />The contact method of sending mails is set by the site administrator, so you can not change that setting.<br />The contact method of <b>receiving mail</b> can be changed by you.<br />At the moment you can choose 1 out of 4 possible contact methods.";
$pgv_lang["mail_option1_help"]				= "Using this option, the built in PhpGedView messaging system will be used and no e mails will be sent.<br />In this way you will receive only <b>internal messages</b> from the other users.<br />When another user sends you a message from this site, the message will be in your message block or your own MyGedView Page(if you have not removed this block from your page)<br />";
$pgv_lang["mail_option2_help"]				= "This option is like #pgv_lang[messaging]#, with one addition.<br />As an extra, a copy of the message will also be send to your email address, as set in Your Account.<br />This contact method is the default option.<br />";
$pgv_lang["mail_option3_help"]				= "With this option, you will only receive the send messages at you email address.<br />The other users can not reach you through the internal mail system.<br />";
$pgv_lang["mail_option4_help"]				= "Με την επολογή αυτή, δεν θα λαμβάνετε καθόλου μηνύματα.<br />";

//-- Add user
//$pgv_lang["help_adduser.php"] 	        = "#pgv_lang[sorry]#";

//-- Admin
$pgv_lang["admin_help"]						= "On this page you will find all links to the configuration pages, administration pages, documentation, and log files.<br /><br />The <b>System Time</b>, just under the page title is showing the time of the server, on which your site is hosted. The time showed, is the server time when you opened this page (or refreshed it).<br /><br /><b>WARNING</b><br />When you see a warning message under the system time, it means that your <b>config.php</b> is still writeable!<br />After configuring your site, you should, for <b>security</b>, set the permissions of this file back to read-only.<br />You have to do this <b>manualy</b>, since PhpGedView can not do this for you (yet).<br /><br />Apart from the options: Readme, User Manual, and Log File, you will get more help on the pages you choose.";

//-- User Admin
$pgv_lang["useradmin_help"]					= "~THE USER ADMINISTRATION~<br /><br />On this page you can administer the current users and add new users.<br /><br /><b>Current User List</b><br />In this table the current users, their status and their rights, are displayed.<br />You can <b>delete</b> or <b>edit</b> users.<br /><br /><b>Add a new User Form</b><br />This form is almost the same as you will know from \"Your Account\".<br />For several subjects we did not make special help text for the admin. In those cases you will see the following message:";
$pgv_lang["useradmin_gedcomid_help"]		= "~GEDCOM INDI RECORD ID~<br /><br />This GEDCOM record ID for the user has to be set by the Administrator.<br />It will identify the user.<br />It will also give the user access to his / her \"My Indi\" and \"My Pedigree\".<br /><br />For each GEDCOM that you are using in this program, you can set the GEDCOM INDI record ID for the user.<br />If a user does not have a record in the GEDCOM, you leave the text box empty.";
$pgv_lang["useradmin_rootid_help"]			= "~PEDIGREE CHART ROOT PERSON~<br /><br />For each GEDCOM in the program, you can assign a <b>Root Person</b> to a user.<br />Probably the user will like it to start the program with his own Pedigree, but this is not a must.<br /><br />The user can change this setting himself as well in his account.";
$pgv_lang["useradmin_can_admin_help"]		= "~USER CAN ADMINISTER CHECK BOX~<br /><br />If this box is checked, the user will have the rights, for the program, as you have.<dl><dt>So he / she cannot only:</dt><dd>Add / Remove / Edit Users.</dd><dd>Send messages to all users at once.</dd><dd>Edit Welcome Messages.</dd><dd>Edit and Configure language files.</dd><dt>But also:</dt><dd>Upgrade the Program.</dd><dd>Change Configuration.</dd><dd>Aminister the GEDCOMs.</dd><dd>Change Privacy Settings.</dd><dt>And anything else that is not mentioned here.</dt><dd>But not your site settings, outside this program</dd></dl> ";
$pgv_lang["useradmin_can_edit_help"]		= "~USER PRIVILEGES~<br /><br />For each GEDCOM in the system the user can have certain access and editing privileges.<br /><br />Setting this to <b>None</b> means that the user cannot access the private data in this GEDCOM.  Setting this to <b>Access</b> would mean that the user cannot edit or accept data into the database but can see the private data.<br /><br />Setting this to <b>Edit</b> would mean that the user can edit values but another user with <b>Accept</b> privileges must approve the changes before they are added to the database and made public.<br /><br />Setting this to <b>Accept</b> gives the user the option to edit and approve changes made by other users.<br /><br />Setting this to <b>Admin</b> will allow to the user to edit configuration and privacy settings for this GEDCOM.<br /><br />System administrators are automatically given <b>Admin</b> privileges.";
$pgv_lang["useradmin_verified_help"]		= "~USER VERIFIED HIMSELF~<br /><br /><b>Self Registration</b><br />A user can apply for a new account, by means of the <b>self registration</b> module.<br />If he did so, then he will have received an email message with a link to verify his application.<br />If he already did so, you will see the box checked, and you can proceed with the next step: <b>User Approved by Admin</b>.<br />If the user has not verified himself, you should wait with you approval.<br /><br /><b>Add user manually</b><br />If you use the form to add a user manually, you will find this box checked already.";
$pgv_lang["useradmin_verbyadmin_help"]		= "~APPROVED BY ADMIN~<br /><br />If a user has used the Self Registration Module and has verified himself, then the last step, before his account will be effective, is your approval.<br /><br />After you approved the application for the new account, the user will receive an email message that his account is effective and that he can loggin with the user name and password, that he used when applying for the account.";
$pgv_lang["useradmin_edit_user_help"]		= "~UPDATE USER ACCOUNT~<br /><br />This form is used by the admin to change a user's account<br /><br />The form is rather similar to form \"Add User\" or the form \"My Account\".";
$pgv_lang["useradmin_visibleonline_help"]	= "~VISIBLE ONLINE~<br /><br />If this box is checked, other logged in users will be able to see when you are online and you will be able to see when they are online.  If you don't want others to know when you are online, then you can uncheck this box but you will also be unable to tell if they are online.";
$pgv_lang["useradmin_editaccount_help"]		= "~EDIT ACCOUNT INFO~<br /><br />If this box is checked, then this user will be able to edit their account information.  If the box is not checked, then they will not be able to edit their account information.  This allows you to create a single username and password for multiple users and prevent them from editing their account information.";

//-- Upgrade utility
$pgv_lang["how_upgrade_help"]				= "~THE UPGRADE UTILITY~<br /><br />The upgrade utility will take care of upgrading your existing PhpGedView to a new version that you have downloaded.<br /><br /><b>Downloading a new version</b><br />A new version can either directly be downloaded from http://sourceforge.net/projects/phpgedview/ or you can have the upgrade utility check for a new version. If a new version exists it will display the available downloads. This can either be zip or gz file or both.<br /><br /><b>What to upgrade?</b><br />* PhpGedView<br />This will upgrade all core files of PhpGedView excluding config.php, privacy.php and authenticate.php. It also upgrades the images folder.<br />* Index files<br />This upgrades the folder /index. Use this with caution, as any existing file will be overwritten.<br />* Languages<br />This upgrades the /languages folder.<br />* Themes<br />This upgrades the /themes folder. Use this with caution, as any custom made changes to themes will be overwritten.* Configuration file<br />This checks your current configuration file with the new found configuration file and update your current file with    any new changes found in the new configuration file. This ensures you have the latest file with your own settings.<br />* Privacy file<br />This checks your current privacy file(s) with the new found privacy file and update your current file with any new changes found in the new privacy file. This ensures you have the latest file with your own privacy settings.<br />* Manuals<br />This upgrades the /doc folder.<br />* Researchlog<br />This upgrades the Researchlog plugin.<br />* Create backup<br />This will create a backup copy of the old file in the /backup folder.<br /><br /><b>How to upgrade?</b><br />1. Select the parts you want to upgrade<br />2. Click save<br /><br />The progress will be shown at the bottom.";

//-- G E D C O M
$pgv_lang["add_upload_gedcom_help"]			= "~ADDING versus UPLOADING GEDCOM~<dl><dt>Uploading GEDCOM Files</dt><dd>Uploading files can be done on line.<br />You can upload from any place, without needing an ftp program.</dd><dt>Adding GEDCOM Files</dt><dd>If a file is still present in your GEDCOM directory, you can use it again without uploading.<br />Sometimes need to use Add instead of Upload, because of file size, or upload limmitations.</dd></dl>Both procedures Add and Upload can be finished in 4 simple steps.<br />Only Step 1 of both procedures are different.<br />";
$pgv_lang["gedcom_configfile_help"]			= "~GEDCOM CONFIGURATION FILE~<br /><br />This is the file where all the basic settings a GEDCOM file is stored.<br /><br />In the column \"Configuration File\" on the GEDCOM Adminstration page, the path and name of the configuration file is displayed.";
$pgv_lang["default_gedcom_help"]			= "~DEFAULT GEDCOM~<br /><br />If you have more than 1 GEDCOM file in the program, you can set here which GEDCOM will be the <b>default</b> GEDCOM file for the program.<br /><br />It will be the GEDCOM that is displayed to visitors and users, who are not logged in yet.<br /><br />Users can override this default GEDCOM, when they change the setting in their account.<br />";
$pgv_lang["delete_gedcom_help"]				= "~DELETE GEDCOM~<br /><br />PhpGedView imports records from the GEDCOM file. When you click <b>Delete</b>, the program will erase those records that were imported from the GEDCOM.<br />The actual GEDCOM file will remain in the directy into which it was uploaded.<br /><br />If you later want to work with that GEDCOM file again, you don't have to upload it again. Instead you can then choose the option <b>Add GEDCOM</b>.<br /><br />After clicking Delete, you will have to <b>confirm</b> your choise in a popup dialog.";
//$pgv_lang["edit_gedcom_help"]				= "~EDIT GEDCOM~<br /><br />#pgv_lang[sorry]#";
$pgv_lang["add_gedcom_help"]				= "~ADD GEDCOM~<br /><br />When you use the Add GEDCOM option, it is assumed that you have already uploaded the GEDCOM file to your server, <i>using an external program</i>, for example for <b>ftp</b> or <b>network</b> connection.<br />If the GEDCOM file is not on your server yet, you <b>have to</b> do so first, before you can start with Adding.<br /><br />You are guided step by step through the procedure.<br />";
$pgv_lang["add_new_gedcom_help"]			= "~CREATE A NEW GEDCOM~<br /><br />You have the option to start a new GEDCOM from scratch.<br /><br />You can finish this procedure in only a few steps. Step 1 is different from what you know already about uploading and adding. The other steps will be familiar.<dl><dt>Step 1: Naming the new GEDCOM</dt><dd>Type the name of the new GEDCOM without the extention '.ged'. The new file will be created in the directory as indicated above the text field to enter the name.<br />Click <b>Add</b>.</dd><dt>Step 2: Configuration page.</dt><dd>This is the page you already know of configuring the settings for the GEDCOM files.</dd><dt>Step 3: Validate</dt><dd>Also this step you will know already. The new GEDCOM is checked and will be ok.</dd><dt>Step 4: Importing Records</dt><dd>Since there will be only one record to import, this will be finished very fast.</dd><dt>Ready creating.</dt><dd>Now you can go to the Pedigree chart to see your first person in the new GEDCOM. Click the name of the person and start editting. After that you can start adding new individuals to the first person.</dd></dl>";
$pgv_lang["download_gedcom_help"]			= "~DOWNLOAD GEDCOM~<br /><br />You have the option to download a GEDCOM file from your site.<br /><br />On the \"Download GEDCOM\" page you have the option to convert the file from <b>UTF-8</b> to <b>ANSI (ISO-8859-1)</b>.<br />Which format you need depends on the program that you want to use to work with the downloaded GEDCOM file.<br />Check the documentation of that program, if you are not sure.";
$pgv_lang["edit_gedcoms_help"]				= "~GEDCOM ADMINISTRATION~<br /><br />The GEDCOM Administration Page is the control centre for adminstrating your <b>current</b> and <b>new</b> GEDCOM files.<br /><dl><b>CURRENT GEDCOMS</b><br /><dt>In the <b>Current GEDCOMs</b> table you have the following options:</dt><dd>Delete GEDCOM</dd><dd>Edit GEDCOM</dd><dl><dt>Edit Privacy</dt><dd>The Edit Privacy is part of this table as well, since every GEDCOM has it's own privacy file.</dd></dl><dd>Set default GEDCOM</dd><dd>Import GEDCOM</dd><dd>Download GEDCOM</dd><dt>There are 3 colums with the following information:</dt><dd>GEDCOM File</dd><dd>GEDCOM Title</dd><dd>Configuration File</dd></dl><dl><b>NEW GEDCOM FILES</b><dt>On this page you have the following options to add <b>new</b> and / or <b>existing</b> GEDCOM Files to the system.</dt><dd>Add GEDCOM</dd><dd>Upload GEDCOM</dd><dd>Create a New GEDCOM</dd></dl>#pgv_lang[more_help]#<br />";
$pgv_lang["edit_config_gedcom_help"]		= "~CONFIGURE GEDCOM~<br /><br />Every GEDCOM that you are using with this program, has it's own <b>Configuration file</b>.<br /><br />On this form you set the basic settings like, for example, language, calendar format, email options, etc., etc.<br />";
$pgv_lang["import_gedcom_help"]				= "~IMPORT GEDCOM~<br /><br />In most cases Importing of a GEDCOM is one step in a procedure like adding, adding new, or uploading a GEDCOM.<br /><br />These steps are in a logical sequence and need to be completed, in order to work with the GEDCOM.<br />In case you did not complete the sequence, as described before, you will see a <b>warning</b> message that the GEDCOM is not yet imported. In this case, click the link to (re-)import the GEDCOM file.<br /><br /><b>Importing</b><br /><br />The Configuration (settings) of the GEDCOM will not change when you re-import a GEDCOM.<br />Existing data will be over written.";
$pgv_lang["upload_gedcom_help"]				= "~UPLOAD GEDCOM~<br /><br />Unlike the option \"Add GEDCOM\", you do not need to have the GEDCOM file on your server yet.<br /><br />In Step 1 you select a GEDCOM file from your local computer. Type the complete path and file name in the text box, or use the <b>Browse</b> on the page.<br /><br />You will find more help on the other pages during the procedure.<br />";
$pgv_lang["validate_gedcom_help"]			= "~VALIDATE GEDCOM~<br /><br />Validating the GEDCOM that you are uploading or adding, is step 3 in the procedure to set up the program to work with that file.<br /><br />The program will check the file on the correct use of: Date format, Place format, Character Set, and more.<br />Some of the deviations, found by the program, will be corrected automaticaly. Examples are MacIntosh line endings and incorrect use of Place format.<br />In those cases you will see a message that the program has changed the data.<br />For other deviations you will get a warning message with the provided solution.<br /><br /><b>Optional Tools</b><br />At this moment there are two additonal tools:<br /><b>Change Individual ID to...</b> and <b>Add Media Tool</b>.<br />This last tool is only available in the <b>MySQL</b>-mode. If you have the GEDCOM in the <b>Index</b>-mode, this option will be hidden.<br /><br /><b>More help</b> is available on the form.#pgv_lang[more_help]#<br />";
$pgv_lang["convert_ansi2utf_help"]			= "~CONVERT ANSI TO UTF-8~<br /><br />To make sure that the program handles your GEDCOM files correctly, the files should be encoded in UTF-8.<br /><br />Most third party Genealogy programs have the option to export a GEDCOM file in this UTF-8 encoding.<br />If the program that you are using does not offer you the option, PhpGedView can convert the file for you.<br /><br />When PhpGedview validates the uploaded (or added) file, the program will detect, whether the file is ANSI encoded.";
$pgv_lang["detected_ansi2utf_help"]			= "~ANSI ENCODING DETECTED~<br /><br />The GEDCOM file that is being validated now, is ANSI encoded.<br />It is strongly recommended that the file encoding will be converted to UTF-8.<br /><br />#pgv_lang[convert_ansi2utf_help]#";
$pgv_lang["detected_date_help"]				= "~WRONG DATE FORMAT DETECTED:~<br /><b>DATE FORMAT WILL BE CHANGED</b><br /><br />The Date format that is standard for PhpGedview and also according <b>GEDCOM 5.5 standards</b> is: DD MMM YYYY (ie. 01 JAN 2004)<br /><br />If you see, after your GEDCOM file has been validated, a message that a wrong date format has been detected, the program will convert the dates to it's standard.<br /><br />You have, however, the option to choose either \"<b>day</b> before month\" (DD MMM YYYY), or \"<b>month</b> before day\" (MMM DD YYYY).<br />We recommend to leave the proposed setting to the first option.";
$pgv_lang["addmedia_tool_help"]				= "~ADD MEDIA TOOL~<br />MySQL mode only</b><br /><br />The Add Media Tool was designed for users whose genealogy programs do not export GEDCOMs with Media links.  Family Tree Maker is the most notorious for this.  <br /><br />The Add Media Tool allows you to keep a list of media links outside of your GEDCOM file and seperate from the normal PhpGedView tables.  Because the data is kept in a seperate table,you only have to enter the data once.  This makes it easy for administrators to work with the genealogical data in their desktop program, export a new GEDCOM file, and then run Add Media tool on it as part of the import process to have the same image links added everytime they make a new GEDCOM.<br /><br />To use the Add Media Tool, first create a list a media items by filling the fields and clicking the Add Media button for each media item you want included in your GEDCOM.  The \"#pgv_lang[gedcomid]#\" field contains the ID of the GEDCOM record you want the image added to, I100 for example.  In the \"Exernal File\" field, type in the filename of the image you want to use.  Enter the file's extension in the \"#pgv_lang[extension]#\" field.  Use the \"#pgv_lang[highlighted]#\" field to tell whether or not this image is the highlighted or primary image for this individual.  The first highlighted or primary image will be used on charts and highlighted on the individual page next to the person's name.  In the \"#pgv_lang[title]#\" field enter a descriptive title or caption for the image.  Use the \"#pgv_lang[order]#\" field to specify an the order the images should appear on the individual's media tab.  Finally, the \"#pgv_lang[gedcom_file]#\" fields tells which GEDCOM the media item is for.  This allows you to use the tool with multiple GEDCOM files.<br /><br />When the list is completed, click on the \"#pgv_lang[click_to_add_media]#\" button to have the changes stored in the GEDCOM file.  The next time you update your GEDCOM you only need to launch the Add Media Tool and click this button.<br /><br />";
$pgv_lang["change_indi2id_help"]			= "~CHANGE INDIVIDUAL ID TO ....~<br /><br />This tool was designed for users whose Genealogy programs use a different GEDCOM ID for the individuals every time the GEDCOM is exported. For example, the first time the GEDCOM is exported some person's ID is I100 but the next time the GEDCOM is exported the same person's ID is I234.  These changing IDs make it difficult to administer PhpGedView because the ID is how people are referenced.<br /><br />However most genealogy programs also use the RIN or REFN tag to give each person a unique identifier that can be used to reference the individual. This tool will replace all of the individual IDs in the GEDCOM file with the value of another field you specify.  You can choose the RIN or the REFN field to replace the IDs with.<br /><br />";
$pgv_lang["edit_privacy_help"]				= "On this page you can make all the Privacy Settings for the chosen GEDCOM (if you have more than one).<br />You can check under the page title, whether you are editting the correct privacy file.<br />It is displayed like this: (path/nameofyourgedcom_priv.php)<br /><br />If you need more settings, than you can manualy make changes to the privacy file. You can read more about this on the PhpGedView web site.<br />";
$pgv_lang["invalid_header_help"]			= "~INVALID GEDCOM HEADER~<br />A GEDCOM file must begin with the first line 0 HEAD.  PhpGedView detected that your GEDCOM does not begin with the first line 0 HEAD.  After you click the cleanup button, any lines before the first 0 HEAD line will be removed from your GEDCOM.<br /><br />This error usually means that the program you used to create your GEDCOM did not create it properly or it is not a GEDCOM file.  You should check to make sure that you uploaded the correct GEDCOM file, and that it starts with the line 0 HEAD and ends with the line 0 TRLR.";
$pgv_lang["macfile_detected_help"]			= "~MACINSTOSH FILE DETECTED~<br />PhpGedView detected that your GEDCOM file was created on a Macintosh computer.  Macintosh files use different line endings (r) than Unix (n) or Windows (rn).  The PHP functions used by PhpGedView require that the GEDCOM files be Unix or DOS files.  When you click the cleanup button, your file will be converted to a DOS file.<br />";
$pgv_lang["cleanup_places_help"]			= "~CLEANUP PLACES~<br />PhpGedView detected that your GEDCOM file uses places on GEDCOM tags that should not have places.  Many genealogy programs, such as Family Tree Maker, will create this type of GEDCOM file.  PhpGedView will work with these GEDCOM files, but some invalid places will show up in your place hierarchy.  <br /><br />For example, your GEDCOM may have the following encoding<br />1 SSN<br />2 PLAC 123-45-6789<br />According to the GEDCOM specification this should really be shown as<br />1 SSN 123-45-6789<br />If you select Yes, PhpGedView will automatically detect and correct these encoding errors.<br />";
$pgv_lang["empty_lines_detected_help"]		= "~EMPTY LINES DETECTED~<br />PhpGedView has detected that there are empty lines in your GEDCOM file.  These lines may cause errors and will be removed from the GEDCOM before it is imported.<br />";
$pgv_lang["skip_cleanup_help"]				= "~SKIP CLEANUP~<br />It is highly reccommended that you allow PGV to cleanup your GEDCOM before it is imported, otherwise some of the functions may not work properly.<br /><br />But if you would like, you may click this button to skip the cleanup step and continue importing the GEDCOM as it is.<br />";

//-- Edit Config
$pgv_lang["help_editconfig.php"]			= "~CONFIGURE  PhpGedView~<br /><br />On this page you have to set the global settings for the program, when you have just installed PhpGedView on your server, and are running it for the first time.<br />#pgv_lang[review_readme]#<br /><br />As these settings are <b>global</b>, they are for the whole program and for all GEDCOM files, you are using within the program.<br />For each GEDCOM file you can make seperate settings.<br />Since you are here on the Configuration Page, you can click the link to Administer GEDCOMs, just above the form.<br />From anywhere else in the program, you will find the link in the menu, under the MyGedView Icon.";

//-- GDBI Changes
$pgv_lang["help_gdbi_changes.php"]			= "~#pgv_lang[review_changes]#~<br /><br />The list is clear and simple. Not much explanation needed.<br /><br />The <b>Undo link</b> does not give you a second chance. No new popup for confirmation!.<br /><br />When a user has changed something, and a <b>date</b> is involved, please check whether the date is in the proper format.<br />The date field is a text field, so anything can be entered.<br />Wrong date formats may result in an error message later, somewhere in the program.<br />For more info about dates in the GEDCOM, please read the <b>GEDCOM Info</b> in the Help menu.<br />";

//-- merge records
$pgv_lang["help_gdbi_merge.php"]			= "~#pgv_lang[merge_records]#~<br /><br />This page will allow you to merge 2 GEDCOM records from the same GEDCOM file.  This is useful for people who have merged GEDCOMs and now have many people, families, and sources, that are the same.<br /><br />The page consists of 3 steps.<br /><ul><li><b>Step 1</b> will ask you to enter two GEDCOM IDs.  The IDs have to be of the same type.  (ie. you cannot merge an individual and a family, or family and source).  In the Merge To field enter the ID of the record you want to be the new record after the merge is complete.  In the Merge From field, enter the Id of the record that will be merged from and then deleted.</li><li><b>Step 2</b> will ask you to select what facts you want to keep from the two records when they are merged into 1.  Just click the checkboxes next to the ones you want to keep.</li><li><b>Step 3</b> will show you the results of the merge.  Just like with all changes made online.  You will have to accept the changes to make them permanent.</li></ul><br />";

//-- Language Editor
$pgv_lang["lang_edit_help"]					= "This page is to administer your language files.<br />You can translate, compare and export language files.<br />Further you can configure the languages that are supported by the program.<br /><br />You can use the following options & utilities:";
$pgv_lang["language_to_edit_help"]			= "#pgv_lang[edit_lang_utility]# >> <b>#pgv_lang[language_to_edit]#</b><br /><br />From this list box you can select the language, of which want to <b>edit</b> the messages.";
$pgv_lang["file_to_edit_help"]				= "#pgv_lang[edit_lang_utility]# >> <b>#pgv_lang[file_to_edit]#</b><br /><br />From this list box you can choose the file type of the language files you want to edit.<br /><br />The options are:<br />lang.xx.php<br />facts.xx.php<br />configure_help.xx.php<br />help_text.xx.php<br />rs_lang.xx.php<br /><br />Where xx stands for the language code of your chosen language and is set automatically.<br />'rs_lang.xx.php' is only shown if the plug in 'research log' is installed.";
$pgv_lang["hide_translated_help"]			= "#pgv_lang[edit_lang_utility]# >> <b>#pgv_lang[hide_translated]#</b><br /><br />If set to 'yes' you will only see those messages of your selected language file, which have not been translated, that means which do not exist in your chosen language file yet.<br />After adding a new translation to a message this message is also not shown anymore in the list.";
$pgv_lang["language_to_export_help"]		= "#pgv_lang[export_lang_utility]# >> <b>#pgv_lang[language_to_export]#</b><br /><br />From this list box you can select the language, of which want to <b>export</b> the messages.";
$pgv_lang["new_language_help"]				= "#pgv_lang[compare_lang_utility]# >> <b>#pgv_lang[new_language]#</b><br /><br />From this list box you can select the language which is has the source of messages you want to compare with another language.<br /><br />All changes and additions to language files are first made to the <b>English</b> language files.";
$pgv_lang["old_language_help"]				= "#pgv_lang[compare_lang_utility]# >> <b>#pgv_lang[old_language]#</b><br /><br />From this list box you can select the language which you want to compare with the language chosen from the <b>Source</b> list box.<br /><br />After you made your choise, click the <b>Compare</b> button, and you will get a list of all additions and subtractions.<br /><br />Just to be sure:<br /><b>Adittion</b> means: It is <b>in</b> the Source File, but <b>not</b> in the Secondary File.<br /><br /><b>Subtraction</b> means: It is <b>not</b> in the Source File (anymore), but it (still) <b>is</b> in the Secondary File.";
$pgv_lang["add_new_lang_help"]				= "<b>#pgv_lang[add_new_language]#</b><br /><br />With this selection you can add a new language to PhpGedView.<br />You can setup the standard settings of the new language, like: language detection code, language direction, start of the week for this language, time settings, alphabet etc.<br /><br />You will get more help on the settings of a language, supported by PhpGedView, after selecting the language and clicking the \"Add new Language\" button.<br />In the new window for the settings of that language you will see more question marks which will help you.";

//-- report engine
$pgv_lang["help_reportengine.php"]			= "~΅ΑΝΑΦΟΡΕΣ~<br />The PGV reporting engine uses XML template files to automatically generate PDF reports.  The first step is to choose a report to run.  The reports available in the list are generated from the reports found in the \"reports\" directory.  Once you select a report to run, it will ask you to provide some information specific to that report such as which inidivual or family to start with and whether or not to show photos.  When you are ready to run the report, click the \"#pgv_lang[view_report]#\" button to open the report in your browser, or click the \"#pgv_lang[download_report]#\" button to download the report to your hard-drive.<br /><br />You can create your own reports by making a copy of any of the templates provided and modifying the template XML.  To add your custom report, just put it in the \"reports\" directory and PGV will automatically detect it and make it available in the \"Choose report\" drop-down list.";

//-- Help Contents
$pgv_lang["help_contents_head_help"]		= "<b>ΠΕΡΙΕΧΟΜΕΝΑ ΒΟΗΘΕΙΑ</b><br /><br />";
$pgv_lang["help_contents_gedcom_info"]		= "GEDCOM info";
$pgv_lang["help_contents_gedcom_places"]	= "Places in the GEDCOM";

//-- Admin Help Contents Items
$pgv_lang["admin_help_contents_head_help"]	= "<b>ΠΕΡΙΕΧΟΜΕΝΑ ΒΟΗΘΕΙΑΣ<br /><br />ADMINISTRATOR HELP ITEMS</b> added to the beginning of the list.<br /><br />";
$pgv_lang["ah1_help"]						= "_Αναβάθμιση";
$pgv_lang["ah2_help"]						= "_Προσαρμογή Εφαρμογής PhpGedView";
$pgv_lang["ah3_help"]						= "_GEDCOM: Add vs Upload";
$pgv_lang["ah4_help"]						= "_GEDCOM: Configuration file";
$pgv_lang["ah5_help"]						= "_GEDCOM: Default";
$pgv_lang["ah6_help"]						= "_GEDCOM: Διαγραφή";
$pgv_lang["ah7_help"]						= "_GEDCOM: Προσθήκη";
$pgv_lang["ah8_help"]						= "_GEDCOM: Δημιουργία νέου";
$pgv_lang["ah9_help"]						= "_GEDCOM: Download";
$pgv_lang["ah10_help"]						= "_GEDCOM: Σελίδα Διαχείρισης";
$pgv_lang["ah11_help"]						= "_GEDCOM: Configure";
$pgv_lang["ah12_help"]						= "_GEDCOM: Import";
$pgv_lang["ah13_help"]						= "_GEDCOM: Upload";
$pgv_lang["ah14_help"]						= "_GEDCOM: Validate";
$pgv_lang["ah15_help"]						= "_GEDCOM: Convert ANSI to UTF-8";
$pgv_lang["ah16_help"]						= "_GEDCOM: Privacy Settings";
$pgv_lang["ah17_help"]						= "_Διαχείριση Χρηστών";
$pgv_lang["ah18_help"]						= "_Διαχείριση";
$pgv_lang["ah19_help"]						= "_GEDCOM: Media Tool";
$pgv_lang["ah20_help"]						= "_GEDCOM: Change Individual ID to .......";
$pgv_lang["ah21_help"]						= "_Αρχεία Γλωσσών";
//           22 is in the help_text_vars.php

?>
