<?php
/**
 * Spanish language file for PhpGedView
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2002 to 2007  PGV Development Team
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *
 * @author PGV Developers
 * @translator: Julio Sánchez Fernández
 * @package PhpGedView
 * @subpackage Languages
 * @version $Id: configure_help.es.php 1777 2007-09-30 20:43:59Z fisharebest $
 */

if (stristr($_SERVER["SCRIPT_NAME"], basename(__FILE__))!==false) {
	print "Usted no puede acceder a este archivo de idioma directamente.";
	exit;
}

$pgv_lang["new_gedcom_title"]		= "Genealogía desde [#GEDCOMFILE#]";
$pgv_lang["keep_media_help"]			= "~#pgv_lang[keep_media]#~<br /><br />Define si se deben retener los vínculos existentes a objetos audiovisuales al subir una nueva versión del archivo GEDCOM. La opción <b>No</b> elimina los vínculos existentes de la base de datos, mientras que la opción <b>Sí</b> los conserva.<br /><br />Esta opción es útil al exportar su archivo GEDCOM de PhpGedView a un programa de mantenimiento externo que no maneje los punteros a objetos correctamente y reimportar posteriormente el GEDCOM modificado a PhpGedView.  En estas circunstancias, los punteros a objetos en el GEDCOM que exportó se destruyen y tendría que volver a vincular todos sus archivos audiovisuales a las personas, familias y fuentes correctas después de volver a importar el GEDCOM a PhpGedView.<br /><br />La opción <b>Sí</b> dice a PhpGedView que preserve los vínculos existentes para que no haya que volverlos a crear tras haber importado de nuevo el GEDCOM modificado, pero para que este sistema funcione es necesario que el programa externo produzca siempre los mismos números de identificación para personas, familias y fuentes.<br /><br /><i>Family Tree Maker</i> es uno de varios programas externos que <u>no</u> maneja correctamente los punteros a objetos en GEDCOM.  <i>Legacy</i>, entre otros, <u>sí</u> los maneja adecuadamente.<br /><br />";
$pgv_lang["USE_MEDIA_VIEWER"]			= "Usar el Visor de Objetos Audiovisuales";
$pgv_lang["USE_MEDIA_VIEWER_help"]		= "~#pgv_lang[USE_MEDIA_VIEWER]#~<br /><br />Si se fija este valor a <b>Sí</b>, cuando los usuarios hagan clic en las imágenes en su sitio, se les llevará a la página de Vista de Objeto Audiovisual introducida en la versión 4.1.  La Vista de Objeto Audiovisual muestra los detalles de una imagen y le permite modificar los detalles de la misma. <br /><br />Si se fija este valor a <b>No</b> se obtendrá el viejo comportamiento de las versiones de PhpGedView anteriores a la v4.1 en la que al hacer clic en una imagen la abre a resolución completa en una nueva ventana emergente.<br /><br />";
$pgv_lang["SHOW_SPIDER_TAGLINE"]		= "Mostrar la línea identificadores de la araña";
$pgv_lang["SHOW_SPIDER_TAGLINE_help"]		= "~#pgv_lang[SHOW_SPIDER_TAGLINE]#~<br /><br />En las páginas generadas para los motores de búsqueda, mostrar como última línea el motor de búsqueda que detectó la página.  Si se activa esta opción, puede afectar a Google AdSense a favor de las herramientas de optimización de motores de búsqueda.<br />";
$pgv_lang["SHOW_PRIVATE_RELATIONSHIPS_help"] = "~#pgv_lang[SHOW_PRIVATE_RELATIONSHIPS]#~<br /><br />Esta opción mantiene los vínculos familiares en registros privados.  Esto significa que verá cajas \"privadas\" en los diagramas de ascendientes y otros si hay personas privadas.<br /><br />Esto es similar al comportamiento de las versiones de PhpGedView anteriores a la v4.0.<br /><br />Este ajuste está desactivado por defecto.  Se recomienda que en vez de activar esta opción, escoja como persona raíz de su configuración GEDCOM una persona que no sea privada.<br />";
$pgv_lang["SHOW_PRIVATE_RELATIONSHIPS"]	= "Mostrar relaciones privadas";
$pgv_lang["SYNC_GEDCOM_FILE_help"] 			= "~#pgv_lang[SYNC_GEDCOM_FILE]#~<br /><br />En versiones anteriores de PGV, las modificaciones pendientes se almacenaban en el archivo GEDCOM y, después, eran aceptadas a la base de datos.  A partir de la versión v4.1, los cambios pendientes ya no se almacenan en el archivo GEDCOM, sino en el archivo de cambios.  <br /><br />Si se fija esta valor a verdadero, se actualizará en archivo GEDCOM cuando se acepten los cambios a la base de datos.  Esto mantendrá el archivo GEDCOM sincronizado con la base de datos.  Para mayor compatibilidad con versiones anteriores, está opción está activada por defecto.<br /><br />Puede querer desactivar esta opción para limitar el uso de memoria al aceptar cambios.<br />";
$pgv_lang["SYNC_GEDCOM_FILE"]			= "Sincronizar las modificaciones con el archivo GEDCOM";
$pgv_lang["COMMIT_COMMAND_help"] 			= "~#pgv_lang[COMMIT_COMMAND]#~<br /><br />Si desea utilizar un sistema de control de versiones como CVS para archivar los cambios a su archivo GEDCOM y sus ajustes de configuración o privacidad, introduzca el mandato aquí.  Deje la casilla en blanco si no desea usar un sistema de control de versiones.  Las opciones válidas son <b>cvs</b> y <b>svn</b>.<br />";
$pgv_lang["COMMIT_COMMAND"] 			= "Mandato para guardar una nueva versión en Control de Versiones";
$pgv_lang["SHOW_MULTISITE_SEARCH_help"]	= "~#pgv_lang[SHOW_MULTISITE_SEARCH]#~<br /><br />La búsqueda multi-sitio permite a los usuarios buscar a la vez en varios sitios PhpGedView que haya configurado en el área de administración de Gestionar Sitios o con los que haya vinculado remotamente.  Esta opción controla si la búsqueda multi-sitio está disponible para todos o solamente para los usuarios autenticados.<br />";
$pgv_lang["SHOW_MULTISITE_SEARCH"]		= "Mostrar búsqueda multi-sitio";
$pgv_lang["DBPERSIST"]					= "Utilizar conexiones persistentes de base de datos";
$pgv_lang["DBPERSIST_help"]				= "Controla si PhpGedView debe usar conexiones persistentes de base de datos cuando esté operando con la base de datos.<br /><br />Si se fija a <b>Sí</b>, PhpGedView puede reutilizar las conexiones de base de datos, acelerando de esta manera el establecimiento de accesos a la base de datos.  Sin embargo, esto podría causar errores si su configuración de host tiene en número máximo de conexiones fijado demasiado bajo.  Si no está seguro del soporte en su host de las conexiones persistentes, debería fijar este valor a <b>No</b>.<br />";
$pgv_lang["INDI_FACTS_ADD"] 			= "Hechos agregables a las personas";
$pgv_lang["INDI_FACTS_ADD_help"]		= "~#pgv_lang[INDI_FACTS_ADD]#~<br /><br />Es la lista de hechos GEDCOM que sus usuarios pueden agregar a las personas.  Puede modificar esta lista eliminando o agregando nombres de hechos, incluso los personalizados, como se apropiado.  Lo nombres de hechos que aparezcan en esta lista no deben aparecer también en la lista <i>#pgv_lang[INDI_FACTS_UNIQUE]#</i>.<br />";
$pgv_lang["INDI_FACTS_UNIQUE"] 			= "Hechos agregables a las personas una única vez";
$pgv_lang["INDI_FACTS_UNIQUE_help"]		= "~#pgv_lang[INDI_FACTS_UNIQUE]#~<br /><br />Es la lista de hechos GEDCOM que sus usuarios pueden añadir solamente <u>una vez</u> a las personas.  Por ejemplo, si BIRT consta en esta lista, los usuarios no podrán añadir más de un registro BIRT a una persona.  Los nombres de hechos que aparezcan en esta lista no deben aparecer también el la lista <i>#pgv_lang[INDI_FACTS_ADD]#</i>.<br />";
$pgv_lang["INDI_FACTS_QUICK"] 			= "Hechos Personales Rápidos";
$pgv_lang["INDI_FACTS_QUICK_help"]	= "~#pgv_lang[INDI_FACTS_QUICK]#~<br /><br />Es la lista corta de hechos GEDCOM personales que aparecen junto a la lista completa y que puede añadirse con un solo clic.<br />";
$pgv_lang["FAM_FACTS_ADD"] 			= "Hechos agregables a familias";
$pgv_lang["FAM_FACTS_ADD_help"]		= "~#pgv_lang[FAM_FACTS_ADD]#~<br /><br />Es la lista de hechos GEDCOM que sus usuarios pueden añadir a las familias.  Puede modificar esta lista eliminando o añadiendo nombres de hechos, incluso los personalizados, según sea apropiado.  Los nombres de hechos que aparezcan en esta lista no deben aparecer también en la lista <i>#pgv_lang[FAM_FACTS_UNIQUE]#</i>.<br />";
$pgv_lang["FAM_FACTS_UNIQUE"] 			= "Hechos agregables una sola vez a familias";
$pgv_lang["FAM_FACTS_UNIQUE_help"]		= "~#pgv_lang[FAM_FACTS_UNIQUE]#~<br /><br />Es la lista de hechos GEDCOM que sus usuarios sólo pueden agregar <u>una vez</u> a las familias.  Por ejemplo, si MARR está en esta lista, los usuarios no podrán agregar más de un registro MARR a una familia.  Los nombres de hechos que aparezcan en esta lista no deben aparecer también en la lista <i>#pgv_lang[FAM_FACTS_ADD]#</i>.<br />";
$pgv_lang["FAM_FACTS_QUICK"] 			= "Hechos Rápidos de Familia";
$pgv_lang["FAM_FACTS_QUICK_help"]	= "~#pgv_lang[FAM_FACTS_QUICK]#~<br /><br />Es la lista corta de hechos GEDCOM familiares que aparecen junto a la lista completa que pueden añadirse con un solo clic.<br />";
$pgv_lang["SOUR_FACTS_ADD"] 			= "Hechos agregables a fuentes";
$pgv_lang["SOUR_FACTS_ADD_help"]		= "~#pgv_lang[SOUR_FACTS_ADD]#~<br /><br />Es la lista de hechos GEDCOM que sus usuarios puede añadir a las fuentes.  Puede modificar esta lista eliminado o añadiendo nombres de hechos, incluso los personalizados, según sea apropiado.  Los nombres de hechos que aparezcan en esta lista no deben aparecer también en la lista <i>#pgv_lang[SOUR_FACTS_UNIQUE]#</i>.<br />";
$pgv_lang["SOUR_FACTS_UNIQUE"] 			= "Hechos agregables una sola vez a fuentes";
$pgv_lang["SOUR_FACTS_UNIQUE_help"]		= "~#pgv_lang[SOUR_FACTS_UNIQUE]#~<br /><br />Es la lista de hechos GEDCOM que sus usuarios sólo pueden añadir <u>una vez</u> a las fuentes.  Por ejemplo, si TITL aparece en esta lista, los usuarios no podrán añadir más de un registro TITL a una fuente.  Los nombres de hechos que aparezcan en esta lista no deben aparecer también en la lista <i>#pgv_lang[SOUR_FACTS_ADD]#</i>.<br />";
$pgv_lang["SOUR_FACTS_QUICK"] 			= "Hechos Rápidos para Fuentes";
$pgv_lang["SOUR_FACTS_QUICK_help"]	= "~#pgv_lang[SOUR_FACTS_QUICK]#~<br /><br />Es la lista corta de hechos GEDCOM para las fuentes que aparece junto a la lista completa y que pueden añadirse conun solo clic.<br />";
$pgv_lang["REPO_FACTS_ADD"] 			= "Hechos agregables a repositorios";
$pgv_lang["REPO_FACTS_ADD_help"]		= "~#pgv_lang[REPO_FACTS_ADD]#~<br /><br />Es la lista de hechos GEDCOM que sus usuarios pueden añadir a los repositorios.  Puede modificar esta lista eliminando o añadiendo nombres de hechos, incluso los personalizados, según sea necesario.  Los nombres de hechos que aparezcan en esta lista no deben aparecer también en la lista <i>#pgv_lang[REPO_FACTS_UNIQUE]#</i>.<br />";
$pgv_lang["REPO_FACTS_UNIQUE"] 			= "Hechos agregables una sola vez a repositorios";
$pgv_lang["REPO_FACTS_UNIQUE_help"]		= "~#pgv_lang[REPO_FACTS_UNIQUE]#~<br /><br />Es la lista de hechos GEDCOM que sus usuarios sólo pueden añadir <u>una vez</u> a los repositorios.  Por ejemplo, si NAME aparece en esta lista, los usuarios no podrán añadir más de un registro NAME a un repositorio.  Los nombres de hechos que aparezcan en esta lista no deben aparecer también en la lista <i>#pgv_lang[REPO_FACTS_ADD]#</i>.<br />";
$pgv_lang["REPO_FACTS_QUICK"] 			= "Hechos Rápidos para Repositorios";
$pgv_lang["REPO_FACTS_QUICK_help"]	= "~#pgv_lang[REPO_FACTS_QUICK]#~<br /><br />Es la lista corta de hechos GEDCOM para repositorios que aparece junto a la lista completa y que pueden añadirse con un solo clic.<br />";
$pgv_lang["LANG_SELECTION"] 			= "Idiomas seleccionables";
$pgv_lang["LANG_SELECTION_help"]		= "~#pgv_lang[LANG_SELECTION]#~<br /><br />Puede cambiar la lista de idiomas soportados por su sitio PhpGedView agregando o eliminando marcas como le convenga.  Esto cambia las opciones de idioma disponibles a sus usuarios.<br /><br />Puede obtener el mismo efecto mediante el vínculo <b>#pgv_lang[enable_disable_lang]#</b> del menú #pgv_lang[admin]#, donde también puede cambiar cosas como la bandera asociada al idioma o si el apellido debe mostrarse lo primero.<br />";
$pgv_lang["MEDIA_ID_PREFIX"]		= "Prefijo del ID de los objetos audiovisuales";
$pgv_lang["MEDIA_ID_PREFIX_help"]	= "~#pgv_lang[MEDIA_ID_PREFIX]#~<br /><br />Cuando se agrega un nuevo registro de objeto multimedia a PhpGedView, se genera un nuevo ID para el objeto de forma automática. El ID tendrá el prefijo que se indique aquí.<br />";
$pgv_lang["FAM_ID_PREFIX"]		= "Prefijo del ID de familia";
$pgv_lang["FAM_ID_PREFIX_help"]	= "~#pgv_lang[FAM_ID_PREFIX]#~<br /><br />Si se agrega un nuevo registro de familia en PhpGedView, se generará automáticamente un nuevo ID para ella. El ID de la familia tendrá este prefijo.<br />";
$pgv_lang["QUICK_REQUIRED_FAMFACTS"]			= "Hechos a mostrar siempre en las familias en actualización rápida";
$pgv_lang["QUICK_REQUIRED_FAMFACTS_help"]		= "~#pgv_lang[QUICK_REQUIRED_FAMFACTS]#~<br /><br />Es una lista separada por comas de hechos GEDCOM que se mostrarán siempre en las pestañas de Familia del formulario de Actualización Rápida tanto si existen ya en la personas como si no. Por ejemplo, si MARR está en la lista, siempre se mostrarán los campos para la fecha y lugar de matrimonio en el formulario.<br />";
$pgv_lang["QUICK_ADD_FAMFACTS"]			= "Hechos a mostrar en las familias en actualización rápida";
$pgv_lang["QUICK_ADD_FAMFACTS_help"]		= "~#pgv_lang[QUICK_ADD_FAMFACTS]#~<br /><br />Es una lista de etiquetas de hechos GEDCOM separadas por comas que se mostrarán en las pestañas de Familia del formulario de Actualización Rápida.  Solamente los hechos de esta lista se mostrarán en el formulario o se podrán seleccionar como nuevos hechos a añadir.<br />";
$pgv_lang["QUICK_REQUIRED_FACTS"]			= "Hechos a mostrar siempre en actualización rápida";
$pgv_lang["QUICK_REQUIRED_FACTS_help"]		= "~#pgv_lang[QUICK_REQUIRED_FACTS]#~<br /><br />Es una lista de etiquetas de hechos GEDCOM separadas por comas que siempre se mostrarán en el formulario de Actualización Rápida, tanto si ya existen en el registro de la persona como si no.  Por ejemplo, si BIRT aparece en la lista, los campos para fecha y lugar de nacimiento se mostrarán siempre en el formulario.<br />";
$pgv_lang["QUICK_ADD_FACTS"]			= "Hechos a mostrar en actualización rápida";
$pgv_lang["QUICK_ADD_FACTS_help"]		= "~#pgv_lang[QUICK_ADD_FACTS]#~<br /><br />Es una lista de etiquetas de hechos GEDCOM separados por comas que se mostrarán en el formulario de Actualización Rápida.  Sólo los hechos de esta lista se mostrarán en el formulario o se podrán seleccionar para añadir como un nuevo hecho.<br />";
$pgv_lang["SURNAME_TRADITION_help"] = "~#pgv_lang[SURNAME_TRADITION]#~<br /><br />Cuando se agregan nuevos hijos a una familia, PhpGedView puede proporcionar valores por defecto a los apellidos según las costumbres regionales.<br /><br /><ul><li>En la tradición <b>Paterna</b>, todos los miembros de la familia comparten el apellido del padre.</li><li>En las tradiciones <b>Española</b> y <b>Portuguesa</b>, los hijos reciben un apellido de cada padre.</li><li>En la tradición <b>Islandesa</b>, los hijos reciben el nombre de pila de su padre como apellido, con un sufijo que indica el sexo.</li></ul><br />";
$pgv_lang["ADVANCED_NAME_FACTS_help"] = "~#pgv_lang[ADVANCED_NAME_FACTS]#~<br /><br />Es una lista separada por comas de etiquetas de hechos GEDCOM que se mostrarán en el formulario de agregar/modificar nombre.  Si utiliza alfabetos no latinos como el hebreo, griego, cirílico o árabe, puede desea agregar etiquetas como _HEB, ROMN, FONE, etc. para permitirle almacenar nombres en diferentes alfabetos.<br />";
$pgv_lang["ADVANCED_PLAC_FACTS_help"] = "~#pgv_lang[ADVANCED_PLAC_FACTS]#~<br /><br />Es una lista separada por comas de etiquetas de hechos GEDCOM que se mostrarán cuando agregue o modifique nombres de lugares.  Si usa alfabetos no latinos como hebreo, griego, cirílico o árabe, puede desear agregar etiquetas como _HEB, ROMN, FONE, etc. para permitirle introducir los nombres de sitios en varios alfabetos diferentes.<br />";
$pgv_lang["AUTO_GENERATE_THUMBS"]			= "Miniaturas generadas automáticamente";
$pgv_lang["AUTO_GENERATE_THUMBS_help"]		= "~#pgv_lang[AUTO_GENERATE_THUMBS]#~<br /><br />Si debe el sistema generar automáticamente miniaturas para las imágenes que no las tengan.  Su instalación de PHP puede que no contemple esta funcionalidad.<br />";
$pgv_lang["phpinfo_help"]				= "~#pgv_lang[phpinfo]#~<br /><br />Esta página proporciona gran cantidad de información acerca del servidor en el que está albergado PhpGedView.  Pueden verse muchos detalles de configuración del software del servidor relacionados con PHP y PhpGedView.<br />";
$pgv_lang["config_help_help"]			= "~#pgv_lang[config_help]#~<br /><br />Esta página reúne todos las áreas principales de configuración en un solo sitio.  Puede ver esta información en pantalla o imprimirla para su uso posterior.<br />";
$pgv_lang["more_config_hjaelp"]			= "<br /><b>Más ayuda</b><br />Puede obtener más ayuda haciendo clic el <b>?</b> que aparece junto a los elementos de la página.<br />";
$pgv_lang["THUMBNAIL_WIDTH"]			= "Anchura de las miniaturas generadas";
$pgv_lang["THUMBNAIL_WIDTH_help"]		= "~#pgv_lang[THUMBNAIL_WIDTH]#~<br /><br />Es la anchura (en pixels) a utilizar al generar automáticamente las miniaturas.  El valor predeterminado es 100.<br />";
$pgv_lang["SHOW_SOURCES"]			= "Mostrar fuentes";
$pgv_lang["SHOW_SOURCES_help"]		= "~#pgv_lang[SHOW_SOURCES]#~<br /><br />Fija el nivel de acceso a todas las Fuentes.  Si el usuario no tiene acceso a las Fuentes, la lista de Fuentes se eliminará del menú de Listas y no se mostrará la pestaña Fuentes en la página de información de Detalles de la Persona.<br />";
$pgv_lang["REQUIRE_ADMIN_AUTH_REGISTRATION"]		= "Requerir que un administrador apruebe el registro de nuevos usuarios";
$pgv_lang["REQUIRE_ADMIN_AUTH_REGISTRATION_help"]	= "~#pgv_lang[REQUIRE_ADMIN_AUTH_REGISTRATION]#~<br /><br />Si la opción <b>#pgv_lang[USE_REGISTRATION_MODULE]#</b> está activada este ajuste controla si el administrador debe aprobar el registro.<br /><br />Si se fija a <b>Sí</b> se requerirá que los nuevos usuarios primero verifiquen su dirección de correo electrónico y después sean aprobados por un administrador antes de poder entrar.  Con este ajuste fijado a <b>No</b>, la casilla <b>#pgv_lang[verified_by_admin]#</b> quedará marcada automáticamente en cuanto los usuarios verifiquen su cuenta, permitiéndoles de forma inmediata la entrada identificada sin intervención de un operador.<br /><br />Esto fija \$REQUIRE_ADMIN_AUTH_REGISTRATION en <i>config.php</i>.<br />";
$pgv_lang["SPLIT_PLACES"]		= "Partir sitios en modo edición";
$pgv_lang["SPLIT_PLACES_help"]	= "~#pgv_lang[SPLIT_PLACES]#~<br /><br />Fije esto a <b>Sí</b> para partir cada sitio por las comas a subcampos para una más fácil edición.  Ejemplo :<br /><ol><li>Modo predeterminado<br /><u>Place</u>: Half Moon Bay, San Mateo, California, USA<br /><br /></li><li>Modo partido<br /><u>País</u>: USA<br /><u>Estado</u>: California<br/><u>Condado</u>: San Mateo<br/><u>Localidad</u>: Half Moon Bay</li></ol>";
$pgv_lang["ALLOW_REMEMBER_ME"]		= "¿Mostrar la opción <b>Recordarme</b> en la página de entrada.";
$pgv_lang["ALLOW_REMEMBER_ME_help"]	= "~#pgv_lang[ALLOW_REMEMBER_ME]#~<br /><br />Muchos sitios permiten a los usuarios elegir si desean ser recordados desde el mismo ordenador la próxima vez que visiten el sitio.  Activar esta opción pondrá una casilla <b>Recordarme</b> en la página de entrada.  Si se marca esta casilla, PhpGedView tiene permiso para almacenar una cookie en el equipo del usuario.  Esta cookie permitirá a PhpGedView recordar el usuario entre visitas desde el mismo equipo remoto.<br /><br />Esto fija \$ALLOW_REMEMBER_ME en <i>config.php</i>.<br />";
$pgv_lang["UNDERLINE_NAME_QUOTES"]		= "Subrayar nombres entrecomillados";
$pgv_lang["UNDERLINE_NAME_QUOTES_help"]	= "~#pgv_lang[UNDERLINE_NAME_QUOTES]#~<br /><br />Muchos programas colocarán el nombre de pila preferido entre \"comillas\" en el GEDCOM.  El convenio habitual para esto es subrayar el nombre de pila preferido.  Activar esta opción convertirá los nombres entre comillas a &lt;span&gt; con una clase de \"starredname\".<br /><br />Por ejemplo, si el nombre en el GEDCOM fuera 1&nbsp;NAME&nbsp;Gustave&nbsp;\"Jean&nbsp;Paul\"&nbsp;Charles&nbsp;/Wilson/ activar esta opción cambiaría la parte del nombre entre comillas a &lt;span&nbsp;class=\"starredname\"&gt;Jean&nbsp;Paul&lt;/span&gt; para su presentación.  Dependiendo de otros ajustes, el navegador lo mostraría como <b>Gustave&nbsp;<u>Jean&nbsp;Paul</u>&nbsp;Charles&nbsp;Wilson</b> o <b>Wilson,&nbsp;Gustave&nbsp;<u>Jean&nbsp;Paul</u> Charles</b><br /><br />Esto fija \$UNDERLINE_NAME_QUOTES en <i><u>xxx</u>.GED_conf.php</i>.<br />";
$pgv_lang["PRIVACY_BY_RESN"]		= "Utilizar la restricción de privacidad de GEDCOM (RESN)";
$pgv_lang["PRIVACY_BY_RESN_help"]	= "~#pgv_lang[PRIVACY_BY_RESN]#~<br /><br />La especificación GEDCOM 5.5.1 incluye la opción de utilizar etiquetas RESN para fijar las opciones de privacidad para personas y hechos en el archivo GEDCOM.  Activar esta opción indicará al programa que mire la presencia de etiquetas RESN de nivel 1 en los registros GEDCOM.  La etiquetas RESN de nivel 2 y superior se utilizan automáticamente y no se ven afectadas por este ajuste.  Tome nota de que esto puede ralentizar algo algunas funciones de PhpGedView como la lista de Personas.<br /><br />Esto fija \$PRIVACY_BY_RESN en <i><u>xxx</u>.GED_priv.php</i>.<br />";
$pgv_lang["SHOW_LDS_AT_GLANCE"]			= "Mostrar códigos de ordenanzas SUD en la cajas de los diagramas";
$pgv_lang["SHOW_LDS_AT_GLANCE_help"]	= "~#pgv_lang[SHOW_LDS_AT_GLANCE]#~<br /><br />Se se fija esta opción a <b>Sí</b> se mostrarán los códigos de estado para las ordenanzas SUD en la cajas de los diagramas.<ul><li><b>B</b> - Bautismo</li><li><b>E</b> - Investido</li><li><b>S</b> - Sellado al cónyuge</li><li><b>P</b> - Sellado a los padres</li></ul>Una persona que tenga todas estas ordenanzas tendrá <b>BESP</b> detrás de su nombre.  Las ordenanzas que faltan se indicarán mediante <b>_</b> en lugar de la letra correspondiente.  Por ejemplo, <b>BE__</b> indica que faltan las ordenanzas <b>S</b> y <b>P</b>.<br /><br />Esto fija \$SHOW_LDS_AT_GLANCE en <i><u>xxx</u>.GED_priv.php</i>.<br />";
$pgv_lang["GEDCOM_DEFAULT_TAB"]			= "Pestaña pretederminada a mostrar en la página de una persona";
$pgv_lang["GEDCOM_DEFAULT_TAB_help"]	= "~#pgv_lang[GEDCOM_DEFAULT_TAB]#~<br /><br />Esta opción le permite elegir qué pestaña abrir automáticamente en la página de persona cuando se accede a ella.<br /><br />Esto fija \$GEDCOM_DEFAULT_TAB en <i><u>xxx</u>.GED_conf.php</i>.<br />";
$pgv_lang["SHOW_MARRIED_NAMES"]			= "Mostrar nombres de casada en la lista de personas";
$pgv_lang["SHOW_MARRIED_NAMES_help"]	= "~#pgv_lang[SHOW_MARRIED_NAMES]#~<br /><br />Esta opción mostrará los nombres de casada de las mujeres en la lista de personas.  Esta opción requiere que calcule los nombres de casada cuando importe el archivo GEDCOM.<br /><br />Esto fija \$SHOW_MARRIED_NAMES en <i><u>xxx</u>.GED_conf.php</i>.<br />";
$pgv_lang["SHOW_QUICK_RESN"]		= "Mostrar campos de privacidad en el formulario #pgv_lang[quick_update_title]#";
$pgv_lang["SHOW_QUICK_RESN_help"]		= "~#pgv_lang[SHOW_QUICK_RESN]#~<br /><br />Esta opción le permite activar o desactivar los campos de privacidad en el formulario #pgv_lang[quick_update_title]#.  Los campos de privacidad permiten a un usuarios que está agregando información usando el formulario cambiar la privacidad predeterminada para el hecho que están introduciendo.<br /><br />Esto fija \$SHOW_QUICK_RESN en <i><u>xxx</u>.GED_conf.php</i>.<br />";
$pgv_lang["USE_QUICK_UPDATE"]		= "Utilice el formulario #pgv_lang[quick_update_title]#";
$pgv_lang["USE_QUICK_UPDATE_help"]		= "~#pgv_lang[USE_QUICK_UPDATE]#~<br /><br />Esta opción permite a los usuarios identificados enviar cambios usando el formulario #pgv_lang[quick_update_title]#.<br /><br />Esto fija \$USE_QUICK_UPDATE en <i><u>xxx</u>.GED_conf.php</i>.<br />";
$pgv_lang["SEARCHLOG_CREATE"]		= "Archivar los ficheros SearchLog";
$pgv_lang["SEARCHLOG_CREATE_help"]	= "~#pgv_lang[SEARCHLOG_CREATE]#~<br /><br />¿Con qué frecuencia debe el programa archivar los ficheros Searchlog.<br /><br />Esto fija \$SEARCHLOG_CREATE en <i><u>xxx</u>.GED_conf.php</i>.<br />";
$pgv_lang["CHANGELOG_CREATE"]		= "Archivar los ficheros ChangeLog";
$pgv_lang["CHANGELOG_CREATE_help"]	= "~#pgv_lang[CHANGELOG_CREATE]#~<br /><br />Frecuencia con la que debe el programa archivar los ficheros ChangeLog.<br /><br />Esto fija \$CHANGELOG_CREATE en <i><u>xxx</u>.GED_conf.php</i>.<br />";
$pgv_lang["CHART_BOX_TAGS"]		= "Otros hechos a mostrar en los diagramas";
$pgv_lang["CHART_BOX_TAGS_help"]		= "~#pgv_lang[CHART_BOX_TAGS]#~<br /><br />Esto debería ser una lista de los hechos separados por comas o espacios que, además del nacimiento y defunción, desea que aparezcan en las cajas de los diagramas como el Árbol de Ascendientes.  Esta lista requiere que utilice para los hechos las etiquetas definidas en el Estándar GEDCOM 5.5.1.  Por ejemplo, si deseara que se mostrara la profesión, añadiría \"OCCU\" a este campo.<br /><br />Esto fija \$CHART_BOX_TAGS en <i><u>xxx</u>.GED_conf.php</i>.<br />";


//-- CONFIGURE FILE MESSAGES
$pgv_lang["gedcom_conf"]		= "Opciones Básicas del Archivo GEDCOM";
$pgv_lang["media_conf"]			= "Multimedia";
$pgv_lang["accpriv_conf"]		= "Acceso y Privacidad";
$pgv_lang["displ_conf"]			= "Presentación y disposición";
$pgv_lang["displ_names_conf"]	= "Nombres";
$pgv_lang["displ_comsurn_conf"] = "Apellidos comunes";
$pgv_lang["displ_layout_conf"]	= "Presentación";
$pgv_lang["displ_hide_conf"]	= "Ocultar y mostrar";
$pgv_lang["editopt_conf"]		= "Opciones de edición";
$pgv_lang["useropt_conf"]		= "Opciones de usuario";
$pgv_lang["contact_conf"]		= "Información de contacto";
$pgv_lang["meta_conf"]			= "Ajustes del sitio web y etiquetas META";
$pgv_lang["gedconf_head"]		= "Configuración GEDCOM";
$pgv_lang["other_theme"]		= "Otro, escriba por favor";
$pgv_lang["performing_update"]		= "Actualizando.";
$pgv_lang["config_file_read"]		= "Leído el fichero de configuración.";
$pgv_lang["does_not_exist"]		= "no existe";
$pgv_lang["media_drive_letter"]		= "La ruta a los archivos de Medios no debe contener una letra de disco; los Medios pueden no mostrarse.";
$pgv_lang["db_setup_bad"]		= "Su configuración actual de la base de datos está mal.  Por favor revise su conexión a la base de datos y configure de nuevo.";
$pgv_lang["bad_host_user_pass"]		= "PhpGedView no pudo establecer una conexión con su servidor de base de datos.  Compruebe el servidor, el nombre de usuario y la contraseña y verifique que sean correctas.";
$pgv_lang["bad_database_name"]		= "PhpGedView hizo una conexión a su base de datos pero fue incapaz de utilizar la base de datos con el nombre que ha introducido.  Compruebe que la base de datos existe y que el nombre de usuario que introdujo tiene los permisos adecuados en la base de datos.";
$pgv_lang["db"]				= "Database";
$pgv_lang["dbase"]			= "dBase";
$pgv_lang["current_gedcoms"]		= "Gedcoms en uso";
$pgv_lang["ged_gedcom"]			= "Archivo";
$pgv_lang["ged_title"]			= "Título";
$pgv_lang["ged_config"]			= "Configuración";
$pgv_lang["ged_search"]			= "Archivos SearchLog";
$pgv_lang["ged_change"]			= "Archivos ChangeLog";
$pgv_lang["ged_privacy"]		= "Archivo de privacidad";
$pgv_lang["disabled"]			= "Desactivado";
$pgv_lang["mouseover"]			= "#pgv_lang[pgv_lang_es_Mouse]# encima";
$pgv_lang["mousedown"]			= "#pgv_lang[pgv_lang_es_Mouse]# pulsado";
$pgv_lang["click"]			= "Haciendo clic";
$pgv_lang["enter_db_pass"]		= "Por seguridad, siempre debe introducir el #pgv_lang[DBUSER]# y la #pgv_lang[DBPASS]# para poder cambiar los valores de configuración.";
$pgv_lang["server_url_note"]	= "Esto debería ser la URL de su carpeta PhpGedView. No debería cambiar este ajuste a menos que sepa muy bien lo que está haciendo. PhpGedView ha estimado que este valor debe ser <b>#GUESS_URL#</b>";

$pgv_lang["DBTYPE"]			= "Tipo de base de datos";
$pgv_lang["DBTYPE_help"]		= "~#pgv_lang[DBTYPE]#~<br /><br />El tipo de base de datos accesible por PEAR con la que se debe conectar.<br /><br />PhpGedView puede utilizar bases de datos MySQL, PostgreSQL y SQLite.  Tanto MySQL como PostgreSQL necesitan que se instalen bibliotecas específicas en PHP.  SQLite viene instalado por defecto en PHP 5.<br /><br />Con SQLite no es necesario que configure #pgv_lang[DBHOST]#, #pgv_lang[DBUSER]# o #pgv_lang[DBPASS]#, pero tendrá que introducir una ruta de archivo para su base de datos en el campo #pgv_lang[DBNAME]#.<br /><br />Esto fija el valor de \$DBTYPE en <i>config.php</i>.<br />";
$pgv_lang["DBHOST"]			= "Servidor de Base de Datos";
$pgv_lang["DBHOST_help"]		= "~#pgv_lang[DBHOST]#~<br /><br />La dirección DNS o IP del servidor de su base de datos.  Este ajuste se ignora si está utilizando una base de datos SQLite.<br /><br />Esto fija la variable \$DBHOST en <i>config.php</i>.<br />";
$pgv_lang["DBUSER"]			= "Nombre de usuario de la base de datos";
$pgv_lang["DBUSER_help"]		= "~#pgv_lang[DBUSER]#~<br /><br />El nombre de usuario de la base de datos requerido para conectar con la base de datos.  Este ajuste se ignora si está utilizando una base de datos SQLite.<br /><br />Esto fija \$DBUSER en <i>config.php</i>.<br />";
$pgv_lang["DBPASS"]			= "Contraseña para la base de datos";
$pgv_lang["DBPASS_help"]		= "~#pgv_lang[DBPASS]#~<br /><br />La contraseña de la base de datos para el usuario que ha escrito en el campo #pgv_lang[DBUSER]#.  Este ajuste se ignora si está utilizando una base de datos SQLite.<br /><br />Esto fija \$DBPASS en <i>config.php</i>.<br />";
$pgv_lang["DBNAME"]			= "Nombre Base de Datos:";
$pgv_lang["DBNAME_help"]		= "~#pgv_lang[DBNAME]#~<br /><br />La base de datos en el servidor que quiere que phpGedView utilice.<br /><br />El nombre de usuario que escribió en el campo #pgv_lang[DBUSER]# debe tener privilegios para poder crear, insertar, actualizar, borrar y seleccionar en esta base de datos.  En SQLite necesita fijar este campo al nombre de un archivo en un directorio que pueda escribir PHP como el directorio de índice (index/phpgedview.db).<br /><br />Esto fija \$DBNAME en <i>config.php</i>.<br />";
$pgv_lang["TBLPREFIX"]			= "Prefijo de las tablas de la base de datos";
$pgv_lang["TBLPREFIX_help"]		= "~#pgv_lang[TBLPREFIX]#~<br /><br />Un prefijo para anteponer a las tablas creadas por phpGedView.  Cambiando este valor puede gestionar múltiples sitios phpGedView, y utilizar la misma base de datos pero con diferentes tablas.  Por ejemplo, el mismo sitio podría albergar una instalación de \"prueba\" junto con una instalación de \"producción\" de PhpGedView con tablas de datos completamente independiente.  Esto cambia la variable \$TBLPREFIX en <i>config.php</i>.<br />\n";
$pgv_lang["ALLOW_CHANGE_GEDCOM"]	= "Permitir a los visitantes elegir gedcoms:";
$pgv_lang["ALLOW_CHANGE_GEDCOM_help"]	= "~#pgv_lang[ALLOW_CHANGE_GEDCOM]#~<br /><br />Si tiene un entorno con múltiples HEDCOMs, fijar este valor a <b>Sí</b> permite a los visitantes <u>y</u> usuarios de su sitio la opción de cambiar de GEDCOM.  Fijarlo a <b>No</b> impide el cambio de GEDCOMo a loss visitantes <u>y</u> usuarios autenticados.<br /><br />Esto cambia la variable \$ALLOW_CHANGE_GEDCOM en <i>config.php</i>.<br />";
$pgv_lang["upload_path"]			= "Ruta del fichero a subir";
$pgv_lang["upload_path_help"]		= "~#pgv_lang[upload_path]#~<br /><br />Esta es la ruta donde se encuentra el archivo GEDCOM que desea subir. Para seleccionar la ruta, haga clic en <b>Examinar</b>, navegue hasta su archivo GEDCOM y haga clic en <b>Abrir</b>.";
$pgv_lang["gedcom_path"]			= "Ruta y nombre del archivo GEDCOM";
$pgv_lang["gedcom_path_help"]		= "~#pgv_lang[gedcom_path]#~<br /><br />Hay dos formas de importar su archivo GEDCOM a PhpGedView. Son:<ol><li>Subit con FTP el archivo al servidor</li><li>Subir dentro de PhpGedView</li></ol>Si su archivo ya existe en el servidor, utilice el procedimiento <i>#pgv_lang[add_gedcom]#</i> y rellene la ruta y nombre de su archivo GEDCOM tal como existe en el servidor. El nombre se puede escribir con o sin la extensión. Si no se da la extensión, se supondrá .ged. La ruta es opcional.  Si no se da una ruta, se usará el valor de la opción <i>#pgv_lang[INDEX_DIRECTORY]#</i> como esté fijada en su configuración del sitio PhpGedView.  Tenga en cuenta que en la mayoría de los servidores, los nombres de archivos y ruta distinguen entre mayúsculas y minúsculas.<br /><br />Si utiliza en procedimiento <i>#pgv_lang[upload_gedcom]#</i> incorporado a PhpGedView, puede utilizar el botón <b>Examinar</b> para localizar el archivo deseado en su equipo local.  Éste puede ser un archivo GEDCOM normal o un archivo ZIP que contenga el archivo GEDCOM. PhpGedView extraerá y utilizará automáticamente el archivo GEDCOM contenido en ese archivo ZIP.<br /><br />Al subir un archivo es posible especificar una ruta o nombre de archivos alternativos con los que salvarlo en el servidor.<br /><br />Para más información, vea el archivo <a href=\"readme.txt\">Readme.txt</a>.<br />";
$pgv_lang["CHARACTER_SET"]		= "Codificación del juego de caracteres:";
$pgv_lang["CHARACTER_SET_help"]		= "~#pgv_lang[CHARACTER_SET]#~<br /><br />Éste es el juego de caracteres de su archivo GEDCOM.  El valor por defecto es UTF-8 y debería ser válido para casi todos los sitios.  Si exporta su GEDCOM usando codificación IBM Windows, debería poner WINDOWS aquí.<br /><br />NOTA: PhpGedView no puede manejar UNICODE (UTF-16) por que PHP no proporcionar el apoyo necesario.<br />";
$pgv_lang["LANGUAGE"]			= "Idioma";
$pgv_lang["LANGUAGE_help"]		= "~#pgv_lang[LANGUAGE]#~<br /><br />Asigna el idioma por defecto del sitio.<br /><br />Si se fija la opción <b>#pgv_lang[ENABLE_MULTI_LANGUAGE]#</b>, los usuarios pueden cambiar este ajuste mediante la configuración de idioma preferido de su navagador, las opciones de configuración de la página de su Cuenta o mediante vínculos o botones en la mayoría de las páginas de PhpGedView.<br />";
$pgv_lang["ENABLE_MULTI_LANGUAGE"]	= "Permitir a los usuarios elegir idioma:";
$pgv_lang["ENABLE_MULTI_LANGUAGE_help"]	= "Fijando en 'Sí' le da a los usuarios la opción de seleccionar un idioma diferente al por defecto, desde una lista desplegable en el pie de la página, y diferente también al de su navegador.";
$pgv_lang["CALENDAR_FORMAT"]		= "Formato del Calendario:";
$pgv_lang["CALENDAR_FORMAT_help"]	= "~#pgv_lang[CALENDAR_FORMAT]#~<br /><br />Esta opción le permite especificar qué tipo de calendario quiere utilizar con este archivo GEDCOM.<br /><br />El Hebreo es el mismo que el calendario Judío, pero utilizando caracteres hebreos.<br /><br />Nota: Los valores utilizados para las fechas judías y hebreas se calculan de las fechas gregorianas o julianas.  Puesto que el día de calendario judío comienza con la puesta de sol, cualquier evento ocurrido desde el crepúsculo hasta la media noche constará como ocurrido el día anterior a la fecha correcta judía.  La presentación de hebreo puede ser problemática en viejos navegadores, que pueden mostrar el texto hebro al revés (izquierda a derecha) o no presentarlo en absoluto.<br />";
$pgv_lang["DISPLAY_JEWISH_THOUSANDS"]	= "Mostrar miles hebreos";
$pgv_lang["DISPLAY_JEWISH_THOUSANDS_help"]	= "~#pgv_lang[DISPLAY_JEWISH_THOUSANDS]#~<br /><br />Mostrar Alafim en el calendario Hebreo.<br /><br />Si se fija a <b>Sí</b>, se mostrará el año 1969 como <span lang=\"he-IL\" dir='rtl'>&#1492;'&#160;&#1514;&#1513;&#1499;&quot;&#1496;</span>&lrm; mientras que si se fija a <b>No</b>, se mostrará el año como <span lang=\"he-IL\" dir='rtl'>&#1514;&#1513;&#1499;&quot;&#1496;</span>&lrm;.  Esto no tiene impacto en el ajuste de año judío.  El año se mostrará como 5279 independientemente de este ajuste.<br /><br />Esto cambia la variable \$DISPLAY_JEWISH_THOUSANDS en<i><u>xxx</u>.GED_conf.php</i>.<br /><br />Nota: Este ajuste es similar a la constante de calendario CAL_JEWISH_ADD_ALAFIM en PHP 5.0.<br />";
$pgv_lang["DISPLAY_JEWISH_GERESHAYIM"]		= "Mostrar el Gershayim hebreo";
$pgv_lang["DISPLAY_JEWISH_GERESHAYIM_help"]	= "~#pgv_lang[DISPLAY_JEWISH_GERESHAYIM]#~<br /><br />Mostrar comillas simples y dobles al mostrar fechas hebreas. Fijar este valor a 'Sí' mostrará 8 de febrero de 1969 como <span lang='he-IL' dir='rtl'>&#1499;'&#160;&#1513;&#1489;&#1496;&#160;&#1514;&#1513;&#1499;&quot;&#1496;</span>&lrm; mientras que fijarlo a <b>No</b> lo mostrará como <span lang='he-IL' dir='rtl'>&#1499;&#160;&#1513;&#1489;&#1496;&#160;&#1514;&#1513;&#1499;&#1496;</span>&lrm;.  Esto no afecta al ajuste del año judío puesto que no se utilizan comillas en las fechas judías mostradas con caracteres latinos.<br /><br />Esto cambia la variable \$DISPLAY_JEWISH_GERESHAYIM en <i><u>xxx</u>.GED_conf.php</i>.<br /><br />Nota: Este ajuste es similar al de las constantes del calendario CAL_JEWISH_ADD_ALAFIM_GERESH y CAL_JEWISH_ADD_GERESHAYIM en PHP 5.0. Este ajuste único afecta a ambos.<br />";
$pgv_lang["JEWISH_ASHKENAZ_PRONUNCIATION"]	= "Pronunciación Ashkenaz Judía:";
$pgv_lang["JEWISH_ASHKENAZ_PRONUNCIATION_help"]	= "~#pgv_lang[JEWISH_ASHKENAZ_PRONUNCIATION]#~<br /><br />Utilizar pronunciaciones Ashkenazi judías.<br />Si lo fijamos a <b>Sí</b>, los meses de Cheshvan y Teves serán escritos conforme a la pronunciación Ashkenazi. Fijarlo a <b>No</b> cambiará los meses a Hesvan y Tevet.  Esto sólo afecta al ajuste Judío.  El ajuste Hebreo siempre utilizará el alfabeto hebreo.<br /><br />Esto cambia la variable  \$JEWISH_ASHKENAZ_PRONUNCIATION en <i><u>xxx</u>.GED_conf.php</i>.<br />";
$pgv_lang["USE_RTL_FUNCTIONS"]	= "Active el tratamiento de derecha a izquierda";
$pgv_lang["USE_RTL_FUNCTIONS_help"]	= "~#pgv_lang[USE_RTL_FUNCTIONS]#~<br /><br />Activar el tratamiento que permite mostrar correctamente los datos GEDCOM en idiomas que se escriben de derecha a izquierda (RTL).  Si se fija a <b>Sí</b>, la base de datos se procesará para asegurar que se muestren correctamente este tipo de datos, pero este ajuste puede ralentizar el proceso.<br /><br />Esto cambia \$USE_RTL_FUNCTIONS en <i><u>xxx</u>.GED_conf.php</i>.<br />";
$pgv_lang["DEFAULT_PEDIGREE_GENERATIONS"]	= "Número Predeterminado de Generaciones de Ascendientes:";
$pgv_lang["DEFAULT_PEDIGREE_GENERATIONS_help"]	= "Ajusta el número de generaciones que se mostrarán por defecto en el Árbol de Ascendientes.";
$pgv_lang["MAX_PEDIGREE_GENERATIONS"]		= "Máximo de Generaciones en el Árbol de Ascendientes:";
$pgv_lang["MAX_PEDIGREE_GENERATIONS_help"]	= "Fija el número máximo de generaciones que se mostrarán en los árboles de ascendientes.";
$pgv_lang["MAX_DESCENDANCY_GENERATIONS"]	= "Máximo de Generaciones en Descendientes:";
$pgv_lang["MAX_DESCENDANCY_GENERATIONS_help"]	= "Ajusta el número de generaciones que se mostrarán por defecto en el informe de Descendientes.";
$pgv_lang["USE_RIN"]			= "Utilizar el RIN# del ID del GEDCOM:";
$pgv_lang["USE_RIN_help"]		= "~#pgv_lang[USE_RIN]#~<br /><br />Fíjelo a <b>Sí</b> para utilizar el número RIN en vez del ID del GEDCOM se necesite un ID para la persona en archivos de configuración, preferencias de usuario y diagramas.  Esto es útil para usar datos de programas de genealogía que no exportan GEDCOMs con IDs de personas fijo, pero siempre utilizan el mismo RIN.<br />";
$pgv_lang["GENERATE_GUID"]		= "Crear automáticamente IDs distintos globalmente";
$pgv_lang["GENERATE_GUID_help"]	= "~#pgv_lang[GENERATE_GUID]#~<br /><br /><b>GUID</b> en este contexto es una abreviatura de «Globally Unique ID» o «Identificadores Globales Únicos».<br /><br />Los GUIDs intentan ayudar a identificar a cada persona de una manera repetible, de modo que organizaciones como el Centro de Historia Familiar de la Iglesia SUD en Salt Lake City o incluso programas compatibles de su servidor, puedan determinar si están tratando con la misma persona, origine donde origine el GEDCOM.  El objetivo del Centro de Historia Familiar es tener un repositorio central de datos genealógicos y publicarlos mediante servicios Web. Esto permitirá a cualquier programa acceder a los datos y actualizar los datos almacenados.<br /><br />Si no planea compartir este GEDCOM con nadie, no necesita dejar a PhpGedView crear estos GUIDs; no obstante, hacerlo no causará más perjuicio que incrementar el tamaño de su GEDCOM.<br />";
$pgv_lang["PEDIGREE_ROOT_ID"]		= "Persona Inicial por defecto en diagramas de Ascendientes y Descendientes";
$pgv_lang["PEDIGREE_ROOT_ID_help"]	= "~#pgv_lang[PEDIGREE_ROOT_ID]#~<br /><br />Fija el ID de la persona que se mostrará por defecto en los diagramas Árbol de ascendientes y Descendencia.<br />";
$pgv_lang["GEDCOM_ID_PREFIX"]		= "Prefijo del ID de persona";
$pgv_lang["GEDCOM_ID_PREFIX_help"]	= "~#pgv_lang[GEDCOM_ID_PREFIX]#~<br /><br />Si se agrega un nuevo registro de persona en PhpGedView, se generará automáticamente un nuevo ID para ella. El ID de la persona tendrá este prefijo.<br />";
$pgv_lang["SOURCE_ID_PREFIX"]		= "Prefijo del ID de las Fuentes";
$pgv_lang["SOURCE_ID_PREFIX_help"]	= "~#pgv_lang[SOURCE_ID_PREFIX]#~<br /><br />Si se añade una nueva fuente en PhpGedView se generará automáticamente un número ID para ella.  El ID de la fuente tendrá este prefijo.<br />";
$pgv_lang["REPO_ID_PREFIX"]		= "Prefijo del ID de los Repositorios";
$pgv_lang["REPO_ID_PREFIX_help"]	= "~#pgv_lang[REPO_ID_PREFIX]#~<br /><br />Si se añade un nuevo repositorio en PhpGedView se generará automáticamente un número ID.  El ID del repositorio tendrá este prefijo.<br />";
$pgv_lang["PEDIGREE_FULL_DETAILS"]	= "Mostrar detalles de nacimiento y defunción en los árboles de Ascendientes y Descendientes:";
$pgv_lang["PEDIGREE_FULL_DETAILS_help"]	= "Le dice si debe mostrar o no los detalles de nacimiento o defunción de una persona por defecto.";
$pgv_lang["PEDIGREE_LAYOUT"]		= "Formato de Árbol de Ascendientes:";
$pgv_lang["PEDIGREE_LAYOUT_help"]	= "Esto le dice al programa en que formato mostrará el Árbol de Ascendientes: Natural o Apaisado.";
$pgv_lang["SHOW_EMPTY_BOXES"]		= "Mostrar cajas vacías en el Árbol de Ascendientes:";
$pgv_lang["SHOW_EMPTY_BOXES_help"]	= "Le dice si mostrar o no las cajas vacías en los árboles de ascendientes.";
$pgv_lang["ZOOM_BOXES"]			= "Aumentar cajas en informes:";
$pgv_lang["ZOOM_BOXES_help"]		= "~#pgv_lang[ZOOM_BOXES]#~<br /><br />Permite a los usuarios aumentar el tamaño de las cajas en los informes y poder acceder así a más datos.<br /><br />Fíjelo a <b>#pgv_lang[disabled]#</b> desactivar esta característica.  Fíjelo <b>#pgv_lang[mouseover]#</b> para aumentar las cajas cuando los usuarios sitúen el cursor sobre el icono en la caja.  Fíjelo a <b>#pgv_lang[click]#</b> para aumentar las cajas cuando los usuarios hagan clic en el icono de la caja.<br />";
$pgv_lang["LINK_ICONS"]			= "Ventana emergente de vínculos en diagramas:";
$pgv_lang["LINK_ICONS_help"]		= "~#pgv_lang[LINK_ICONS]#~<br /><br />Permite al usuario seleccionar vínculos a otros diagramas y familiares cercanos de la persona.<br /><br />Fíjelo a <b>#pgv_lang[disabled]#</b> para desactivar esta característica.  Fíjelo a <b>#pgv_lang[mouseover]#</b> para mostrar los vínculos cuando los usuarios sitúen el cursor sobre el icono en la caja.  Fíjelo a <b>#pgv_lang[click]#</b> para mostrar los vínculos cuando los usuarios hagan clic en el icono de la caja.<br />";
$pgv_lang["ABBREVIATE_CHART_LABELS"]			= "Abreviar las etiquetas en los diagramas";
$pgv_lang["ABBREVIATE_CHART_LABELS_help"]		= "Esta opción control si abreviar o no las etiquetas de como \"Nacimiento\" en los diagramas con su primera letra como, por ejemplo, \"N\".";
$pgv_lang["SHOW_PARENTS_AGE"]			= "Mostrar la edad de los padres junto a la fecha de nacimiento";
$pgv_lang["SHOW_PARENTS_AGE_help"]		= "~#pgv_lang[SHOW_PARENTS_AGE]#~<br /><br />Esta opción controla si se debe o no mostrar la edad de los padres junto a la fecha de nacimiento en los diagramas.<br />";
$pgv_lang["SHOW_RELATIVES_EVENTS"]      = "Mostrar eventos de los parientes cercanos en las páginas de las personas";
$pgv_lang["SHOW_RELATIVES_EVENTS_help"] = "~#pgv_lang[SHOW_RELATIVES_EVENTS]#~<br /><br />Nacimientos, matrimonios y defunciones de parientes son sucesos importantes en la vida de uno. Esta opción controla si se muestran o no estos sucesos en la pestaña <i>Detalles personales</i> de la página de persona.<br /><br />Los sucesos afectados por esta opción son <ul><li>Defunción de un cónyuge</li><li>Nacimiento y defunción de hijos</li><li>Defunción de los padres</li><li>Nacimiento y defunción de hermanos</li><li>Defunción de los abuelos</li><li>Nacimiento y defunción de tíos</li></ul><br />";
$pgv_lang["EXPAND_RELATIVES_EVENTS"]      = "Expandir automáticamente la lista de eventos";
$pgv_lang["EXPAND_RELATIVES_EVENTS_help"] = "~#pgv_lang[EXPAND_RELATIVES_EVENTS]#~<br /><br />Esta opción controla si se expande automáticamente o no la lista de <i>Sucesos de parientes cercanos</i>.<br />";
$pgv_lang["EXPAND_SOURCES"]      = "Expandir fuentes automáticamente";
$pgv_lang["EXPAND_SOURCES_help"] = "~#pgv_lang[EXPAND_SOURCES]#~<br /><br />Esta opción controla si se muestran automáticamente o no los datos de una <i>Fuente</i> en la página de una persona.<br />";
$pgv_lang["HIDE_LIVE_PEOPLE"]		= "Ocultar datos de personas vivas:";
$pgv_lang["HIDE_LIVE_PEOPLE_help"]	= "Activando esta opción se le dice al PhpGedView que no muestre los detalles de las personas que están vivas.  Estas personas son definidas por no tener un evento hace más de \$MAX_ALIVE_AGE años, y no tienen hijos hace más de \$MAX_ALIVE_AGE años.";
$pgv_lang["REQUIRE_AUTHENTICATION"]	= "Se necesita autenticación:";
$pgv_lang["REQUIRE_AUTHENTICATION_help"]	= "Activando esta opción  obligará a todos los visitantes a entrar como usuarios registrados para poder ver algún dato en el sitio.";
$pgv_lang["WELCOME_TEXT_AUTH_MODE"]	= "Texto de Bienvenida en la página de entrada identificada";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_help"]	= "~#pgv_lang[WELCOME_TEXT_AUTH_MODE]#~<br /><br />Aquí puede elegir el texto que aparecerá en la ventana de entrada identificada.  Debe determinar cuál de los textos predefinidos es el más apropiado.<br /><br />También puede optar por introducis su propio texto personalizado de Bienvenida, pero el texto que introduzca no se traducirá si sus usuarios cambian de idioma.  Sin embargo, si su texto personalizado contiene referencias a variables de idioma que puede definir en los distintos archivos <i>languages/extra.xx.php</i>, su sitio puede mostrar texto traducido.  Por favor consulte el texto de Ayuda asociado con el campo <b>#pgv_lang[WELCOME_TEXT_AUTH_MODE_CUST]#</b> para más información.<br /><br />Los textos predefinidos son:<ul><li><b>#pgv_lang[WELCOME_TEXT_AUTH_MODE_OPT1]#:</b><div class=\"list_value_wrap\">#pgv_lang[welcome_text_auth_mode_1]#</div><br/></li><li><b>#pgv_lang[WELCOME_TEXT_AUTH_MODE_OPT2]#:</b><div class=\"list_value_wrap\">#pgv_lang[welcome_text_auth_mode_2]#</div><br/></li><li><b>#pgv_lang[WELCOME_TEXT_AUTH_MODE_OPT3]#:</b><div class=\"list_value_wrap\">#pgv_lang[welcome_text_auth_mode_3]#</div></li></ul>";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT0"]	= "No hay texto predefinido";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT1"]	= "Texto predefinido que establece que todos los usuarios pueden solicitar una cuenta de usuario";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT2"]	= "Texto predefinido que establece que el administrador decidirá sobre cada solicitud de cuenta de usuario";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT3"]	= "Texto predefinido que establece que sólo los familiares pueden solicitar una cuenta de usuario";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT4"]	= "Seleccionar el texto de bienvenida a usuario tecleado abajo";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST"]	= "Texto de bienvenida personalizado";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST_help"]	= "~#pgv_lang[WELCOME_TEXT_AUTH_MODE_CUST]#~<br /><br />Si ha optado por un texto de bienvenida personalizado, puede teclear el texto aquí.  El texto NO se traducirá al idioma del visitante, sino que se mostrará exactamente como lo tecleó.  Sin embargo, si su texto personalizado cotiene referencias a variables de idioma que puede definir en los distintos archivos <i>languages/extra.xx.php</i> files, su sitio puede mostrar texto traducido.<br /><br />Puede insertar etiquetas HTML en su texto de Bienvenida personalizado.<br /><br />La siguiente descripción, tomada del texto de Ayuda para la lista de Preguntas Frecuentes, es igualmente aplicable al texto de Bienvenida personalizado.<br /><br />#pgv_lang[add_faq_pgvLangRefs]#<br />";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST_HEAD"] = "Encabezamiento estándar para el texto de bienvenida personalizado";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST_HEAD_help"] = "~#pgv_lang[WELCOME_TEXT_AUTH_MODE_CUST_HEAD]#~<br /><br />Seleccione para mostrar un encabezamiento estándar para su texto de Bienvenida personalizado.  Si sus usuarios cambian de idioma, este encabezamiento aparecerá en el nuevo idioma.<br /><br />Si se fija a <b>Sí</b>, el encabezamiento tendrá el siguiente aspecto:<div class=\"list_value_wrap\">#pgv_lang[welcome_text_cust_head]#</div>";
$pgv_lang["SHOW_REGISTER_CAUTION"]			= "Mostrar acuerdo de Uso Aceptable en la página de «Solicitar nueva cuenta de usuario»";
$pgv_lang["SHOW_REGISTER_CAUTION_help"]		= "~#pgv_lang[SHOW_REGISTER_CAUTION]#~<br /><br />Si se fija a <b>#pgv_lang[yes]#</b>, el siguiente mensaje aparecerá encima de los campos de entrada en la página «#pgv_lang[requestaccount]#»:<div class=\"list_value_wrap\">#pgv_lang[acceptable_use]#</div>";
$pgv_lang["CHECK_CHILD_DATES"]		= "Comprobar fechas hijos:";
$pgv_lang["CHECK_CHILD_DATES_help"]	= "Comprueba las fechas de los hijos cuando una persona ya ha fallecido.  En sistemas anticuados y grandes gedcoms esto puede ralentizar la respuesta de su sitio.";
$pgv_lang["MAX_ALIVE_AGE"]		= "Edad a la cual presumiblemente una persona ha fallecido:";
$pgv_lang["MAX_ALIVE_AGE_help"]		= "~#pgv_lang[MAX_ALIVE_AGE]#~<br /><br />Si esta persona ha tenido eventos aparte de Defunción, Entierro o Cremación hace menos que este número de años, se la considerara \"viva\".  Las fechas de nacimiento de sus hijos se cuentan como eventos para a este fin.<br />";
$pgv_lang["SHOW_GEDCOM_RECORD"]		= "Permitir a los usuarios ver el archivo GEDCOM original:";
$pgv_lang["SHOW_GEDCOM_RECORD_help"]	= "~#pgv_lang[SHOW_GEDCOM_RECORD]#~<br /><br />Si se fija a <b>Sí</b> aparecerán vínculos en personas, fuentes y familias que permitirán a los usuarios abrir otra ventana con los datos en bruto extraídos directamente del archivo GEDCOM.<br />";
$pgv_lang["ALLOW_EDIT_GEDCOM"]		= "Activar Edición en línea:";
$pgv_lang["ALLOW_EDIT_GEDCOM_help"]	= "~#pgv_lang[ALLOW_EDIT_GEDCOM]#~<br /><br />Esta opción activa la posibilidad de modificación en línea de esta base de datos de modo que los usuarios con privilegio de modificación puedan actualizar los datos en línea.<br />";
$pgv_lang["EDIT_AUTOCLOSE"]		= "Cerrar automáticamente las ventanas de edición";
$pgv_lang["EDIT_AUTOCLOSE_help"]	= "~#pgv_lang[EDIT_AUTOCLOSE]#~<br /><br />Esta opción controla si se cierra automáticamente la ventana de Edición tras una actualización con éxito.<br />";
$pgv_lang["INDEX_DIRECTORY"]		= "Directorio de los archivos de índice:";
$pgv_lang["INDEX_DIRECTORY_help"]	= "~#pgv_lang[INDEX_DIRECTORY]#~<br /><br />La ruta a un directorio con permiso de lectura y escritura, donde PhpGedView guardará los archivos de índices (incluya el \"/\" final).  PhpGedView no requiere que el nombre de este directorio sea \"index\".  Puede elegir cualquier nombre.<br /><br />Por razones de seguridad, este directorio debería colocarse en algún lugar del servidor al que no puede accederse desde la Internet. Un ejemplo de colocación:<br /><b>PhpGedView:</b> dir1/dir2/dir3/PhpGedView<br /><b>Índice:</b> dir1/dir4/dir5/dir6/index<br /><br />En el ejemplo mostrado, se introduciría en este campo <b>../../dir4/dir5/dir6/index/</b><br /><br />Esto fija el valor de \$INDEX_DIRECTORY en <i>config.php</i>.<br />";
$pgv_lang["POSTAL_CODE"]  = "Posición del Código Postal";
$pgv_lang["POSTAL_CODE_help"] = "~#pgv_lang[POSTAL_CODE]#~<br /><br />Hay distintas formas de escribir la dirección según el país. Esta opción le permite colocar el código postal bien antes o bien después del nombre de la población.<br />";
$pgv_lang["SUBLIST_TRIGGER_I"]		= "Número máximo de apellidos";
$pgv_lang["SUBLIST_TRIGGER_I_help"]	= "~#pgv_lang[SUBLIST_TRIGGER_I]#~<br /><br />Largas listas de personas con el mismo apellido puede partirse en sublistas menores en función de la inicial del nombre de pila de la persona.<br /><br />Esta opción determina cuándo se producirá la creación de sublistas.  Para desactivar la creación de sublistas, fije esta opción a cero.<br />";
$pgv_lang["SUBLIST_TRIGGER_F"]		= "Número máximo de nombres de familias";
$pgv_lang["SUBLIST_TRIGGER_F_help"]	= "~#pgv_lang[SUBLIST_TRIGGER_F]#~<br /><br />Largas listas de familias con el mismo nombre pueden partirse en sublistas menores según la inicial del nombre de pila.<br /><br />Esta opción determina cuándo se producirán las sublistas para los nombres de familias.  Para desactivar la creación de sublistas completamente, fije esta opción a cero.<br />";
$pgv_lang["SURNAME_LIST_STYLE"]		= "Estilo de lista de apellidos";
$pgv_lang["SURNAME_LIST_STYLE_help"]	= "~#pgv_lang[SURNAME_LIST_STYLE]#~<br /><br />Las listas de apellidos que aparecen en el bloque #pgv_lang[block_top10]#, la #pgv_lang[individual_list]# y la #pgv_lang[family_list]#, se pueden mostrar en diferentes estilos.<ul><li><b>#pgv_lang[style2]#</b>&nbsp;&nbsp;&nbsp;En este estilo, los apellidos se muestran en una tabla que se puede clasificar por apellido o por número de casos.</li><li><b>#pgv_lang[style3]#</b>&nbsp;&nbsp;&nbsp;En este estilo, los apellidos se muestran en una lista y el tamaño de la letra utilizada depende del número de casos de ese nombre en la base de datos.  La lista no se puede clasificar.</li></ul><br />";
$pgv_lang["NAME_FROM_GEDCOM"]		= "Mostrar el nombre desde el GEDCOM:";
$pgv_lang["NAME_FROM_GEDCOM_help"]	= "Por defecto phpGedView usa el nombre almacenado en los índices para mostrar el nombre de una persona.  Con algunos formatos gedcom e idiomas el nombre almacenado en los índices no se muestra correctamente y la mejor forma de corregirlo es mostrarlo directamente desde el gedcom. Los nombres con apellidos españoles son un buen ejemplo de esto. Un nombre español está compuesto de dos apellidos: el primero paterno y el segundo materno, de forma general. Utilizando los Índices para ordenar y mostrar, resultaría: Nombre Apellido de la Madre Apellido del Padre, lo cual es incorrecto. Tomando el nombre directamente desde el gedcom, éste se mostrará correctamente. El tener que localizar el nombre en el gedcom hará que el programa funcione un poco más lento.";
$pgv_lang["SHOW_ID_NUMBERS_help"]	= "~#pgv_lang[SHOW_ID_NUMBERS]#~<br /><br />Esta opción controla si se muestran o no los números ID entre paréntesis tras los nombres en diagramas y listas.<br />";
$pgv_lang["SHOW_LAST_CHANGE"]		= "Mostrar la fecha del último cambio del registro GEDCOM en las listas";
$pgv_lang["SHOW_LAST_CHANGE_help"]	= "~#pgv_lang[SHOW_LAST_CHANGE]#~<br /><br />Esta opción controla si se muestra o no la fecha de último cambio del registro GEDCOM en las listas.<br />";
$pgv_lang["SHOW_PEDIGREE_PLACES"]	= "Mostrar Lugares en las cajas de la persona:";
$pgv_lang["SHOW_PEDIGREE_PLACES_help"]	= "Muestra los lugares a continuación de las fechas de nacimiento y defunción en los árboles de ascendientes y descendientes.<br />Esto cambia la variable \$SHOW_PEDIGREE_PLACES en el archivo config.php.";
$pgv_lang["MULTI_MEDIA"]		= "Permitir características multimedia:";
$pgv_lang["MULTI_MEDIA_help"]		= "~#pgv_lang[MULTI_MEDIA]#~<br /><br />GEDCOM 5.5.1 le permite vincular fotos, vídeos, y otros objetos multimedia en su GEDCOM.  Si no incluye objetos multimedia en su GEDCOM, entonces puede desactivar estas características multimedia cambiando este valor a <b>No</b>.<br /><br />Vea la sección multimedia en el archivo <a href=\"readme.txt\">readme.txt</a> para más información acerca de cómo incluir media en su sitio.<br />";
$pgv_lang["MEDIA_EXTERNAL"]			= "Mantener los vínculos";
$pgv_lang["MEDIA_EXTERNAL_help"]	= "Si se encuentra un vínculo multimedia que comience, por ejemplo http://, ftp://, mms://, no se alterará si se fija a <b>Sí</b>. Por ejemplo: http://www.myfamily.com/photo/dad.jpg seguirá como http://www.myfamily.com/photo/dad.jpg.  Si se fija a <b>No</b>, se tratará el vínculo de la misma manera que una referencia estándar y se utilizará la profundidad de la ruta.  Por ejemplo: http://www.myfamily.com/photo/dad.jpg quedará como ./media/dad.jpg";
$pgv_lang["MEDIA_DIRECTORY"]		= "Directorio MultiMedia:";
$pgv_lang["MEDIA_DIRECTORY_help"]	= "La ruta a un Directorio de lectura donde PhpGedView buscará los archivos multimedia (incluya \"/\")";
$pgv_lang["MEDIA_DIRECTORY_LEVELS"]	= "Niveles de directorios de objetos audivisuales a guardar";
$pgv_lang["MEDIA_DIRECTORY_LEVELS_help"]	= "Un valor de 0 ignorará todos los directorios en la ruta de archivo del objeto de media.  Un valor de 1 utilizará el primer directorio conteniendo la imagen.  Incrementando el valor numérico se incrementa el número de directorios padre incluidos en la ruta.  <br />Por ejemplo: Si vincula una imagen en su gedcom con una ruta como esta C:\\Documents and Settings\\User\\My Documents\\My Pictures\\Genealogy\\Surname Line\\grandpa.jpg luego un valor de 0 trasladará esta ruta a ./media/grandpa.jpg.  Un valor de 1 la trasladará a ./media/Surname Line/grandpa.jpg, etc.  La mayoría solo necesitará utilizar 0. Pero es posible que algunos objetos de media tendrán el mismo nombre y se sobreescribirían.  Esto le permite organizar mejor sus media y prevenir catástrofes con los nombres.";
$pgv_lang["SHOW_HIGHLIGHT_IMAGES_help"]	= "~#pgv_lang[SHOW_HIGHLIGHT_IMAGES]#~<br /><br />Si tiene activada la multimedia en su sitio, entonces podrá hacer que PhpGedView muestre una imagen en miniatura al lado del nombre de la persona en diagramas y cajas.<br /><br />Actualmente PhpGedView utiliza el primer objeto multimedia listado en el registro GEDCOM como imagen resaltada.  Para las personas con varias imágenes, debería ordenar los objetos multimedia para que el que usted desee que se resalte aparezca el primero, antes de los demás.<br /><br />Vea la sección Multimedia en el archivo <a href=\"readme.txt\">readme.txt</a> para más información sobre cómo incluir media en su sitio.<br />";
$pgv_lang["USE_THUMBS_MAIN"]	= "Utilice la miniatura para la foto principal de la página de la persona";
$pgv_lang["USE_THUMBS_MAIN_help"]	= "Según como quiera almacenar sus imágenes, puede convenirle más usar las miniaturas en junto al nombre en la página de la persona.  Si sus imágenes principales son muy grandes. pueden tardar mucho en descargar y si sus miniaturas son de suficiente calidad, podrían utilizarse en lugar de las imágenes de resolución original.  Fije este valor a <b>Sí</b> para usar la miniatura i déjelo como <b>No</b> para usar la imagen original.";
// $pgv_lang["SHOW_MEDIA_FILENAME"]		= "Show file name in Media Viewer";
// $pgv_lang["SHOW_MEDIA_FILENAME_help"]	= "~#pgv_lang[SHOW_MEDIA_FILENAME]#~<br /><br />The Media Viewer can show the name of the Media file being viewed.  This option determines whether that file name is shown to users or not.<br /><br />You may want to hide the file name for security reasons.<br /><br />";
$pgv_lang["SHOW_MEDIA_DOWNLOAD"]		= "Mostrar vínculo de descargar en el Visor de Objetos";
// $pgv_lang["SHOW_MEDIA_DOWNLOAD_help"]	= "~#pgv_lang[SHOW_MEDIA_DOWNLOAD]#~<br /><br />The Media Viewer can show a link which, when clicked, will download the Media file to the local PC.<br /><br />You may want to hide the download link for security reasons.<br /><br />";
$pgv_lang["ENABLE_CLIPPINGS_CART"]	= "Activar Carrito Genealógico:";
$pgv_lang["ENABLE_CLIPPINGS_CART_help"]	= "~#pgv_lang[ENABLE_CLIPPINGS_CART]#~<br /><br />El carrito permite a los visitantes de su sitio ir añadiendo la información de personas a un archivo temporal que pueden descargar en formato GEDCOM para importarlo posteriormente a su programa de genealogía.<br />";
$pgv_lang["HIDE_GEDCOM_ERRORS"]		= "Ocultar errores GEDCOM:";
$pgv_lang["HIDE_GEDCOM_ERRORS_help"]	= "Fijando esto en 'Sí' no mostrará los mensajes de error producidos por PhpGedView cuando no comprende una etiqueta gedcom en su archivo.  PhpGedView hace lo posible por cumplir el estándar GEDCOM 5.5, pero muchos programas de genealogía tienen sus etiquetas propias.  Vea el archivo <a href=\"readme.txt\">readme.txt</a> para más información.";
$pgv_lang["WORD_WRAPPED_NOTES"]		= "Añadir espacios donde las notas fueron comprimidas:";
$pgv_lang["WORD_WRAPPED_NOTES_help"]	= "Algunos programas de genealogía compactan las notas en los límites de las palabras y otros en cualquier parte. Esto puede producir que PhpGedView escriba las palabras seguidas.  Fijando esto a 'sí' añadirá un espacio entre palabras donde fueron compactadas en el gedcom.";
$pgv_lang["SHOW_CONTEXT_HELP"]		= "Ver ? de ayuda en las páginas:";
$pgv_lang["SHOW_CONTEXT_HELP_help"]	= "~#pgv_lang[SHOW_CONTEXT_HELP]#~<br /><br />Esta opción activará vínculos de ayuda indicados con signos de interrogación situados cerca de los campos en muchas páginas.  Estos vínculos permiten los usuarios obtener información o ayuda sobre cada uno de esos campos.<br />";
$pgv_lang["DAYS_TO_SHOW_LIMIT"]		= "Límite de días para el bloque de Próximos Eventos";
$pgv_lang["DAYS_TO_SHOW_LIMIT_help"] = "~#pgv_lang[DAYS_TO_SHOW_LIMIT]#~<br /><br />Introduzca el número máximo de días a mostrar en los bloques de Próximos Eventos. No puede ser superior a 30. Si introduce un valor mayor, se utilizará 30.<br /><br />El valor que introduzca aquí determina lo lejos que mira PhpGedView buscando próximos eventos.  El resultado de esta búsqueda, que se hace una vez al día, se guarda en un archivo temporal.<br /><br />Ningún bloque de Próximos eventos en la página índice ni en los portales personales pueden pedir plazos superiores a este valor.  Cuanto mayor sea este valor, más tiempo costará construir el extracto de la base de datos y más costará mostrar el bloque, incluso si se solicita mostrar un número de día menor que este valor.<br />";
$pgv_lang["COMMON_NAMES_THRESHOLD"]	= "Mínima cantidad de apellidos antes de aparecer en Apellidos Comunes";
$pgv_lang["COMMON_NAMES_THRESHOLD_help"]	= "Este es la cantidad de veces que debe repetirse un apellido, antes de aparecer en la lista de Apellidos Comunes en la página de Bienvenida.";
$pgv_lang["COMMON_NAMES_ADD"]	= "Nombres a agregar a Apellidos Comunes (separados por comas)";
$pgv_lang["COMMON_NAMES_ADD_help"]	= "Si la cantidad de veces que un determinado apellido aparece es menor que el umbral. no aparecerá en la lista. Puede agregarse manualmente aquí. Si agrega más de un apellido, estos deben separarse con comas. Los apellidos son sensibles a mayúsculas y minúsculas.";
$pgv_lang["COMMON_NAMES_REMOVE"]	= "Nombres a quitar de la lista de Apellidos Comunes (separados por coma)";
$pgv_lang["COMMON_NAMES_REMOVE_help"]	= "~#pgv_lang[COMMON_NAMES_REMOVE]#~<br /><br />Si desea eliminar un apellido de la lista de Apellidos Comunes sin aumentar el valor del umbral, puede hacerlo tecleando aquí al apellido.  Si teclea más de un apellido, debe separarlos por comas. <b>Los apellidos distinguen entre mayúsculas y minúsculas.</b>  Los apellidos introducidos aquí también se eliminarán de la lista de 10 apellidos más frecuentes de la página de Bienvenida.<br />";
$pgv_lang["HOME_SITE_URL"]		= "URL principal de la web:";
$pgv_lang["HOME_SITE_URL_help"]		= "Una URL incluida en la cabecera del tema genera un vínculo a tu página principal.";
$pgv_lang["HOME_SITE_TEXT"]		= "Texto del vínculo a principal:";
$pgv_lang["HOME_SITE_TEXT_help"]	= "~#pgv_lang[HOME_SITE_TEXT]#~<br /><br />El rótulo utilizado para identificar el vínculo a su página de principal.<br />";
$pgv_lang["CONTACT_EMAIL"]		= "Contacto para genealogía";
$pgv_lang["CONTACT_EMAIL_help"]		= "~#pgv_lang[CONTACT_EMAIL]#~<br /><br />La persona a contactar acerca de los datos genealógicos de este sitio.<br />";
$pgv_lang["CONTACT_METHOD"]		= "Método de Contacto:";
$pgv_lang["CONTACT_METHOD_help"]	= "El método que los usuarios utilizarán para contactar en \"Contacto Usuarios\" sobre cuestiones genealógicas con usted. La opción 'Correo Para' añadirá un vínculo con la dirección de correo sobre el que el visitante podrá hacer clic para enviarle un mensaje utilizando su cliente de correo.  La opción 'Mensajes Privados' utilizará el sistema de mensajes privados del PhpGedView y no se envían mensajes de correo.  La opción 'Mensajes privados con correo' es la utilizada por defecto en el PhpGedView, y aparte del mensaje privado envía una copia del mismo por correo electrónico. Escogiendo la opción 'Ningún método de contacto' los visitantes no encontrarán ninguna opción para contactar con usted.";
$pgv_lang["PHPGEDVIEW_EMAIL"]		= "Dirección de correo de remitente en los mensajes de PhpGedView";
$pgv_lang["PHPGEDVIEW_EMAIL_help"]	= "~#pgv_lang[PHPGEDVIEW_EMAIL]#~<br /><br />Dirección de correo electrónico a utilizar en el campo &laquo;De:&raquo; de los mensajes que crea automáticamente PhpGedView.<br /><br />PhpGedView puede crear automáticamente mensajes de correo electrónico para notificar a los administradores de los cambios que necesitan ser revisados.  PhpGedView también envía mensajes de correo electrónico de notificación a los usuarios que solicitan una cuenta.<br /><br />Normalmente, el campo &laquo;De:&raquo; de estos mensajes automáticos es algo como <i>De: phpgedview-noreply@susitioweb</i> para mostrar que no se requiere respuesta al mensaje.  Para protegerse del <i>spam</i> y de otros tipos de abuso en el correo, algunos sistemas de correo electrónico requieren que el campo &laquo;De:&raquo; de todos los mensajes corresponda a una dirección de correo electrónico válida y no aceptan mensajes que parezcan venir de la cuenta <i>phpgedview-noreply</i>.<br />";
$pgv_lang["WEBMASTER_EMAIL"]		= "Contacto de soporte";
$pgv_lang["WEBMASTER_EMAIL_help"]	= "~#pgv_lang[WEBMASTER_EMAIL]#~<br /><br />La persona a contactar acerca de cuestiones técnicas o errores encontrados en su sitio.<br />";
$pgv_lang["SUPPORT_METHOD"]		= "Método de Soporte:";
$pgv_lang["SUPPORT_METHOD_help"]	= "El método que los usuarios utilizarán para contactar en \"Soporte Usuarios\" sobre cuestiones genealógicas con usted. La opción 'Correo Para' añadirá un vínculo con la dirección de correo sobre el que el visitante podrá hacer clic para enviarle un mensaje utilizando su cliente de correo.  La opción 'Mensajes Privados' utilizará el sistema de mensajes privados del PhpGedView y no se envían mensajes de correo.  La opción 'Mensajes privados con correo' es la utilizada por defecto en el PhpGedView, y aparte del mensaje privado envía una copia del mismo por correo electrónico. Escogiendo la opción 'Ningún método de contacto' los visitantes no encontrarán ninguna opción para contactar con usted.";
$pgv_lang["SHOW_FACT_ICONS"] 		= "Mostrar iconos para los hechos";
$pgv_lang["SHOW_FACT_ICONS_help"]	= "~#pgv_lang[SHOW_FACT_ICONS]#~<br /><br />Fije esto a <b>#pgv_lang[yes]#</b> para mostrar iconos junto a los nombres de los hechos en la página #pgv_lang[personal_facts]#.  Los iconos de hechos se mostrará sólo si existen en el directorio <i>images/facts</i> del tema actual.<br />";
$pgv_lang["FAVICON"]			= "Icono para Favoritos:";
$pgv_lang["FAVICON_help"]		= "~#pgv_lang[FAVICON]#~<br /><br />Cambie esto para que apunte al icono que quiera que aparezca en el menú de Favoritos de los visitantes que agreguen este sitio a su lista de favoritos.<br />";
$pgv_lang["THEME_DIR"]			= "Directorio del Tema:";
$pgv_lang["THEME_DIR_help"]		= "El directorio donde los archivos de su tema del PhpGedView son guardados.  Debe adaptar cualquiera de los temas estándar que vienen con PhpGedView para dar a su sitio un estilo único y diferente.  Vea la sección del archivo <a href=\"readme.txt\">readme.txt</a> para más información.";
$pgv_lang["TIME_LIMIT"]			= "Tiempo Límite PHP:";
$pgv_lang["TIME_LIMIT_help"]		= "El máximo de tiempo en segundos que debería estar permitido ejecutar el PhpGedView.  Por defecto es 1 minuto.  Dependiendo del tamaño de su archivo, necesitaría incrementar este tiempo cuando necesite construir los índices.  Fije este valor a 0, para permitir a PHP correr siempre.<br />PRECAUCIÓN: Al poner a 0, o demasiado alto podría paralizar algunos sistemas operativos hasta que finalice el script.  Fijándolo en 0 puede ocurrir que nunca finalice, hasta que un administrador del servidor corte el proceso o restaure el servidor. Un árbol grande de ascendientes puede llevar mucho tiempo para elaborar, dejando este valor bajo nos aseguramos que alguien pueda echar abajo nuestro servidor web por solicitar un informe de ascendientes de 1000 generaciones.";
$pgv_lang["PGV_SESSION_SAVE_PATH"]	= "Ruta para Guardar Sesión:";
$pgv_lang["PGV_SESSION_SAVE_PATH_help"]	= "~#pgv_lang[PGV_SESSION_SAVE_PATH]#~<br /><br />La ruta para guardar el archivo de sesión de PhpGedView. Algunos servidores no tienen PHP configurado correctamente y las sesiones no se mantienen entre cada solicitud de página.  Esto permite a los administradores del sitio evitarlo salvando el archivo en uno de sus directorios locales.  El directorio ./index/ es una buena opción si necesita cambiar esto.  Por defecto se deja vacío el campo y utilizará la ruta configurada en el archivo <i>php.ini</i>.<br /><br />Esto fija el valor de \$PGV_SESSION_SAVE_PATH en <i>config.php</i>.<br />";
$pgv_lang["SERVER_URL"]			= "URL del Servidor:";
$pgv_lang["SERVER_URL_help"]		= "~#pgv_lang[SERVER_URL]#~<br /><br />Si utiliza https o un puerto diferente al por defecto, necesitará introducir aquí la URL de acceso a su servidor.<br /><br />Esto fija el valor de \$SERVER_URL en <i>config.php</i>.<br />";
$pgv_lang["LOGIN_URL"]			= "URL de entrada";
$pgv_lang["LOGIN_URL_help"]		= "~#pgv_lang[LOGIN_URL]#~<br /><br />Sólo necesita introducir una URL de entrada si desea redirigir a otro sitio o ubicación para que sus usuarios se identifiquen.  Esto es muy útil si desea cambiar de http a https cuando se conectan sus usuarios. Incluya la URL completa a <i>login.php</i>.  Por ejemplo, https://www.suservidor.com/phpgedview/login.php<br /><br />Esto fija \$LOGIN_URL en <i>config.php</i>.<br />";
$pgv_lang["PGV_SESSION_TIME"]		= "Duración de la Sesión";
$pgv_lang["PGV_SESSION_TIME_help"]	= "~#pgv_lang[PGV_SESSION_TIME]#~<br /><br />El tiempo en segundos que una sesión en PhpGedView permanece activa antes de pedir de nuevo la contraseña.  El valor por defecto es 7200, que son 2 horas.<br /><br />Esto fija el valor de \$PGV_SESSION_TIME en <i>config.php</i>.<br />";
$pgv_lang["SHOW_STATS"]			= "Mostrar Estadísticas de Ejecución:";
$pgv_lang["SHOW_STATS_help"]		= "~#pgv_lang[SHOW_STATS]#~<br /><br />Muestra estadísticas de tiempo de ejecución y operaciones en la base de datos al pie de cada página.<br />";
$pgv_lang["SHOW_COUNTER"]		= "Mostrar contadores de visitas";
$pgv_lang["SHOW_COUNTER_help"]		= "~#pgv_lang[SHOW_COUNTER]#~<br /><br />Muestra contadores de visitas en las páginas de portal y de personas.<br />";
$pgv_lang["USE_REGISTRATION_MODULE"]	= "Permitir registrarse a los usuarios:";
$pgv_lang["USE_REGISTRATION_MODULE_help"]	= "~#pgv_lang[USE_REGISTRATION_MODULE]#~<br /><br />Da a los visitantes la posibilidad de registrarse por sí mismos en el sitio.<br /<br />El visitante recibirá un mensaje de correo electrónico para verificar su solicitud de cuenta.  Tras la verificación, el administrador tendrá que aprobar el registro para que la cuenta se active.<br /><br />Esto fija el valor de \$USE_REGISTRATION_MODULE en <i>config.php</i>.<br />";
$pgv_lang["ALLOW_USER_THEMES"]		= "Seleccionar tema por usuarios:";
$pgv_lang["ALLOW_USER_THEMES_help"]	= "~#pgv_lang[ALLOW_USER_THEMES]#~<br /><br />Da a los usuarios la opción de seleccionar su propio tema.<br /><br />Esto fija el valor de \$ALLOW_USER_THEMES en <i>config.php</i>.<br />";
$pgv_lang["PGV_SIMPLE_MAIL"] = "Usar encabezamientos simples en los correos externos";
$pgv_lang["PGV_SIMPLE_MAIL_help"] = "~#pgv_lang[PGV_SIMPLE_MAIL]#~<br /><br />En los encabezamientos normales para correos externos, se utilizan tanto la dirección de correo electrónico como el nombre. Algunos sistemas de correo no lo aceptan. Si se fija a <b>Sí</b>, sólo se utilizará la dirección de correo electrónico.<br /><br />Esto fika el valor de \$PGV_SIMPLE_MAIL en <i>config.php</i>.<br />";
$pgv_lang["gedcom_title"]			= "#pgv_lang[ged_title]#";
$pgv_lang["gedcom_title_help"]		= "~#pgv_lang[gedcom_title]#~<br /><br />Introduzca un título descriptivo a mostrar cuando a los usuarios al intentar elegir entre los distintos GEDCOM de su sitio.<br />";
$pgv_lang["LOGFILE_CREATE"]		= "Directorio para archivos Log:";
$pgv_lang["LOGFILE_CREATE_help"]	= "~#pgv_lang[LOGFILE_CREATE]#~<br /><br />Frecuencia con la que deben archivarse los archivos de registro de actividades.<br /><br />This fija el valor de \$LOGFILE_CREATE en <i>config.php</i>.<br />";
$pgv_lang["PGV_MEMORY_LIMIT"]		= "Límite máximo de memoria.";
$pgv_lang["PGV_MEMORY_LIMIT_help"]	= "~#pgv_lang[PGV_MEMORY_LIMIT]#~<br /><br />La cantidad máxima de memoria utilizable por las funciones de PhpGedView. Por defecto es 32Mb. Muchos servidores deshabilitan esta opción en su configuración PHP; de tal forma que un cambio en este valor puede no afectar el ajuste de memoria máxima actual.<br /><br />Modifica la variable \$PGV_MEMORY_LIMIT en <i>config.php</i>.<br />";
$pgv_lang["PGV_STORE_MESSAGES"]		= "Permitir el archivo de mensajes en línea:";
$pgv_lang["PGV_STORE_MESSAGES_help"]	= "~#pgv_lang[PGV_STORE_MESSAGES]#~<br /><br />Especifica si los mensajes enviados mediante PhpGedView se pueden almacenar en la base de datos.  Si se fija a <b>Sí</b> los usuarios podrán recuperar sus mensajes cuando se identifiquen a PhpGedView.  Si se fija a <b>No</b>, los mensajes sólo se enviarán por correo electrónico.<br /><br />Esto modifica la variable \$PGV_STORE_MESSAGES en <i>config.php</i>.<br />";
$pgv_lang["ALLOW_THEME_DROPDOWN"]		= "Mostrar el selector desplegables de Temas, para cambiar el Tema.";
$pgv_lang["ALLOW_THEME_DROPDOWN_help"]	= "Permite al usuario seleccionar su propio tema desde un menú desplegable (si está implementado en el tema)<br>Requiere que la variable ALLOW_USER_THEMES esté seleccionada como verdadera.<br>Modifica la variable \$ALLOW_THEME_DROPDOWN en el archivo config.php.";
$pgv_lang["MAX_VIEW_RATE"]		= "Máxima velocidad de visualización de páginas";
$pgv_lang["MAX_VIEW_RATE_help"]	= "~#pgv_lang[MAX_VIEW_RATE]#~<br /><br />Esta opción limita la velocidad a la que un usuario puede ver páginas.<br /><br />Si se excede de esa velocidad, PhpGedView trata la sesión como un intento de penetración y la sesión será finalizada con un mensaje adecuado.  Estos dos valores deberían representar un límite razonable en el ancho de banda y octetos descargados del servidor.  Esta característica puede desactivarse fijando el intervalo de tiempo a 0.<br /><br />Esto fija \$MAX_VIEWS y \$MAX_VIEW_TIME en <i>config.php</i>.<br />";
$pgv_lang["META_AUTHOR"]		= "Etiqueta META Author";
$pgv_lang["META_AUTHOR_help"]	= "~#pgv_lang[META_AUTHOR]#~<br /><br />Valor a colocar en la etiqueta meta Author del encabezado de la página HTML..  Déjelo en blanco para usar el nombre completo del #pgv_lang[CONTACT_EMAIL]#.<br /><br />Esto fija \$META_AUTHOR en <i><u>xxx</u>.GED_conf.php</i>.<br />";
$pgv_lang["META_AUTHOR_descr"]	= "Deje este campo en blanco para utilizar el nombre completo del #pgv_lang[CONTACT_EMAIL]#.";
$pgv_lang["META_PUBLISHER"]		= "Etiqueta META Publisher";
$pgv_lang["META_PUBLISHER_help"]	= "~#pgv_lang[META_PUBLISHER]#~<br /><br />El valor a colocar en la etiqueta meta Publisher en el encabezado de la página HTML.  Deje este campo en blanco para utilizar el nombre completo del #pgv_lang[CONTACT_EMAIL]#.<br /><br />Esto fija \$META_PUBLISHER en <i><u>xxx</u>.GED_conf.php</i>.<br />";
$pgv_lang["META_PUBLISHER_descr"]	= "Deje este campo en blanco para utilizar el nombre completo del #pgv_lang[CONTACT_EMAIL]#.";
$pgv_lang["META_COPYRIGHT"]		= "Etiqueta META Copyright";
$pgv_lang["META_COPYRIGHT_help"]	= "~#pgv_lang[META_COPYRIGHT]#~<br /><br />El valor a colocar en la etiqueta meta Copyright en el encabezado de la página HTML.  Deje en blanco para usar el nombre completo del #pgv_lang[CONTACT_EMAIL]#.<br /><br />Esto fija \$META_COPYRIGHT en <i><u>xxx</u>.GED_conf.php</i>.<br />";
$pgv_lang["META_COPYRIGHT_descr"]	= "Deje este campo en blanco para utilizar el nombre completo del #pgv_lang[CONTACT_EMAIL]#.";
$pgv_lang["META_DESCRIPTION"]		= "Etiqueta META Description";
$pgv_lang["META_DESCRIPTION_help"]	= "~#pgv_lang[META_DESCRIPTION]#~<br /><br />El valor a utilizar en la etiqueta meta Description en el encabezado de la página HTML.  Deje este campo en blanco para usar el título de la base de datos active en el momento.<br /><br />Esto fija \$META_DESCRIPTION en <i><u>xxx</u>.GED_conf.php</i>.<br />";
$pgv_lang["META_DESCRIPTION_descr"]	= "Deje este campo en blanco para usar el título de la base de datos activa en el momento.";
$pgv_lang["META_PAGE_TOPIC"]		= "Etiqueta META Page-topic";
$pgv_lang["META_PAGE_TOPIC_help"]	= "~#pgv_lang[META_PAGE_TOPIC]#~<br /><br />El valor a colocar en la etiqueta meta Page-topic en el encabezado de la página HTML.  Deje este campo en blanco para usar el título de la base de datos activa en el momento.<br /><br />Esto fija \$META_PAGE_TOPIC en <i><u>xxx</u>.GED_conf.php</i>.<br />";
$pgv_lang["META_PAGE_TOPIC_descr"]	= "Deje este campo en blanco para usar el título de la base de datos activa en el momento.";
$pgv_lang["META_AUDIENCE"]		= "Etiqueta META Audience";
$pgv_lang["META_AUDIENCE_help"]	= "~#pgv_lang[META_AUDIENCE]#~<br /><br />El valor a colocar en la etiqueta meta Audience en el encabezado de la página HTML.<br /><br />Esto fija \$META_AUDIENCE en <i><u>xxx</u>.GED_conf.php</i>.<br />";
$pgv_lang["META_PAGE_TYPE"]		= "Etiqueta META Page-type";
$pgv_lang["META_PAGE_TYPE_help"]	= "~#pgv_lang[META_PAGE_TYPE]#~<br /><br />El valor a colocar en la etiqueta meta Page-type en el encabezado de la página HTML.<br /><br />Esto fija \$META_PAGE_TYPE en <i><u>xxx</u>.GED_conf.php</i>.<br />";
$pgv_lang["META_ROBOTS"]		= "Etiqueta META Robots";
$pgv_lang["META_ROBOTS_help"]	= "~#pgv_lang[META_ROBOTS]#~<br /><br />El valor a colocar en la etiqueta meta Robots en el encabezado de la página HTML.  Algunos robots y arañas de red ignoran este valor.<br /><br />Esto fija \$META_ROBOTS en <i><u>xxx</u>.GED_conf.php</i>.<br />";
$pgv_lang["META_REVISIT"]		= "Etiqueta META Revisit";
$pgv_lang["META_REVISIT_help"]	= "~#pgv_lang[META_REVISIT]#~<br /><br />El valor a colocar en la etiqueta meta Revisit en el encabezado de la página HTML.  Algunas arañas ignoran este valor.<br /><br />Esto fija \$META_REVISIT en <i><u>xxx</u>.GED_conf.php</i>.<br />";
$pgv_lang["META_KEYWORDS"]		= "Etiqueta META Keywords";
$pgv_lang["META_KEYWORDS_help"]	= "~#pgv_lang[META_KEYWORDS]#~<br /><br />El valor a colocar en la etiqueta meta Keywords en el encabezamiento HTML de la página.  Algunos motores de búsqueda utilizarán la etiqueta meta Keywords para para ayudar a indexar su página.<br /><br />La lista #pgv_lang[common_surnames]# que aparece en el bloque #pgv_lang[gedcom_stats]# de su página de Bienvenida puede añadirse también a cualquier cosa que introduzca aquí.<br /><br />Esto fija \$META_KEYWORDS en <i><u>xxx</u>.GED_conf.php</i>.<br />";
$pgv_lang["META_SURNAME_KEYWORDS"]		= "Agregar los apellidos más corrientes al campo META Keywords";
$pgv_lang["META_SURNAME_KEYWORDS_help"]	= "~#pgv_lang[META_SURNAME_KEYWORDS]#~<br /><br />Si se fija esta opción a <b>Sí</b> los apellidos de la lista #pgv_lang[common_surnames]# se añadirán al campo meta Keywords.  Esto puede ayudar a que los motores de búsqueda encuentren mejor su sitio.<br /><br />Esto fija \$META_SURNAME_KEYWORDS en <i><u>xxx</u>.GED_conf.php</i>.<br />";
$pgv_lang["META_TITLE"]		= "Agregar a la etiqueta del encabezado TITLE";
$pgv_lang["META_TITLE_help"]	=	"~#pgv_lang[META_TITLE]#~<br /><br />Cualquier cosa en esta línea se añadirá a la etiqueta TITLE en el encabezado de la página HTML detrás del título normal y antes de la referencia a PhpGedView.<br /><br />Esto fija \$META_TITLE en <i><u>xxx</u>.GED_conf.php</i>.<br />";

$pgv_lang["ENABLE_RSS"]				= "Activar RSS";
$pgv_lang["ENABLE_RSS_help"]		= "~#pgv_lang[ENABLE_RSS]#~<br /><br />Esta opción le permite desactivar la característica RSS.<br /><br />RSS permite a los usuarios monitorizar su sitio para y detectar cambios a su página índice sin visitar el sitio periódicamente.  Si demasiados usuarios aprovechan esta facilidad o si la frecuencia de refresco de estos usuarios es demasiado alta, RSS puede consumir demasiado ancho de banda o capacidad del servidor.<br />";
$pgv_lang["RSS_FORMAT"]				= "Formato RSS";
$pgv_lang["RSS_FORMAT_help"]		= "~#pgv_lang[RSS_FORMAT]#~<br /><br />El formato de RSS a utilizar como formato predeterminado del flujo RSS del sitio. Los sufijos numéricos <u>no</u> indican versiones, identifican formatos.  Por ejemplo, RSS 2.0 no es más moderno que RSS 1.0, sino un formato diferente. Los lectores del flujo deberían ser capaces de leer cualquier formato. En la actualidad, no hay diferencia entre ATOM y ATOM 0.3. Ambos usan el borrador de especificación ATOM 0.3.<br />";
$pgv_lang["SECURITY_CHECK_GEDCOM_DOWNLOADABLE"] = "Comprobar si es descargable el archivo GEDCOM";
$pgv_lang["SECURITY_CHECK_GEDCOM_DOWNLOADABLE_help"] = "~#pgv_lang[SECURITY_CHECK_GEDCOM_DOWNLOADABLE]#~<br /><br />Por motivos de seguridad, el archivo GEDCOM no debería estar en un lugar del que pueda ser descargado directamente de forma que se salten las comprobaciones de privacidad. Haciendo clic en este enlace comprobará si su archivo GEDCOM se puede descargar por la red.<br /><br />En algunos sistemas esta comprobación se ha comprobado que puede durar mucho tiempo o incluso no completarse.  Si es su caso, debería intentar apuntar su navegador directamente a su archivo GEDCOM para ver si puede descargarse.<br />";
$pgv_lang["gedcom_download_secure"]	= "No se puede descargar #GEDCOM#.";

$pgv_lang["welcome_new2"]			= "<br /><br />Dado que está viendo esta página, ha instalado PhpGedView con éxito y puede comenzar a configurarlo en la forma que desee.<br /><br />";
$pgv_lang["welcome_new_help"]		= "~#pgv_lang[welcome_new]#~#pgv_lang[welcome_new2]#Esta página ayuda le guiará durante el proceso de configuración.  A medida que introduzca los diferentes campos, esta ventana le suministrará información de ayuda acerca del campo sobre el que se encuentre.  Puede cerrar esta ventana; para abrirla de nuevo haga clic en uno de los signos de interrogación \"?\" próximos a las etiquetas de los campos.<br />\n";
$pgv_lang["return_editconfig"]		= "Puede retornar a esta configuración en cualquier momento dirigiendo su navegador hacia el archivo <i>editconfig.php</i> o haciendo clic en el vínculo <b>Configuración</b> en la página de <b>Administración</b>.<br />";
$pgv_lang["return_editconfig_gedcom"]	= "Puede retornar a esta configuración en cualquier momento, haciendo clic en el vínculo: <b>Editar</b> en la tabla <b>#pgv_lang[current_gedcoms]#</b> de la página de <b>#pgv_lang[gedcom_adm_head]#</b> o dirigiendo su navegador hacia el archivo <i>editconfig_gedcom.php</i>.<br />";
$pgv_lang["save_config"] 		= "Salvar Configuración";
$pgv_lang["download_gedconf"]		= "Descargar configuración del GEDCOM.";
$pgv_lang["not_writable"]		= "Se ha detectado que su archivo de configuración no se puede reescribir por PHP.  Puede utilizar el botón de descarga para guardar el archivo en su ordenador, editarlo con su configuración y subirlo de nuevo.";
$pgv_lang["upload_to_index"]		= "Subir archivo al directorio index: ";
$pgv_lang["import_sql"]			= "Se han encontrado archivos SQL en su directorio de Índice. Puesto que pueden haberse generado por la herramienta de Migración de Usuarios, tiene la opción de importar la información a su base de datos. ¿Desea intentar importar estos archivos a su base de datos ahora? Toda la información relacionada con usuarios (definiciones, noticias, favoritos, bloques y mensajes) de su base de datos actual se perderá.<br /><br />Si escoge continuar, PhpGedView intentará importar los datos.  Si el proceso falla, se le pedirá de todos modos que cree la cuenta de administrador inicial.<br />";

//-- edit privacy messages
$pgv_lang["edit_privacy"]			= "Editar privacidad";
$pgv_lang["edit_privacy_title"]			= "Editar Ajustes de Privacidad del Gedcom";
$pgv_lang["save_changed_settings"]		= "Salvar cambios";
$pgv_lang["add_new_pp_setting"]			= "Añadir privacidad a un ID";
$pgv_lang["add_new_up_setting"]			= "Añadir privacidad a un Usuario";
$pgv_lang["add_new_gf_setting"]			= "Añadir nuevo ajuste de privacidad global de un hecho";
$pgv_lang["add_new_pf_setting"]			= "Agregar nuevo ajuste de privacidad de hechos por ID";
$pgv_lang["file_read_error"]			= "¡¡¡ E R R O R !!! ¡No se pudo leer el archivo de privacidad!";
$pgv_lang["edit_exist_person_privacy_settings"]	= "Editar privacidad de un ID";
$pgv_lang["edit_exist_user_privacy_settings"]	= "Editar privacidad de un Usuario";
$pgv_lang["edit_exist_global_facts_settings"]	= "Modificar los ajustes existentes de privacidad global del hecho";
$pgv_lang["edit_exist_person_facts_settings"]	= "Modificar ajustes existentes de privacidad de hechos por ID";
$pgv_lang["general_privacy"]			= "Configuración general de privacidad";
$pgv_lang["general_privacy_help"]		= "~#pgv_lang[general_privacy]#~<br /><br />Puede tener diferentes ajustes de Privacidad para cada GEDCOM de sus sitio PhpGedView.  Mire en el título de la página su está modificando el GEDCOM correcto.<br /><br />Estos ajustes generales pueden ser anulados utilizando los otros formularios de Privacidad en la página #pgv_lang[edit_privacy_title]#.<br />#pgv_lang[more_config_hjaelp]#";
$pgv_lang["person_privacy"]				= "Ajustes de privacidad por ID";
$pgv_lang["person_privacy_help"]		= "~#pgv_lang[person_privacy]#~<br /><br />Estos ajustes permiten a los administradores definir un ajuste de privacidad específico para una persona, familia, fuente u objeto audiovisual en particular.<br /><br />Suponga, por ejemplo, que tuvo un hijo que falleció en la infancia. Normalmente como figura como fallecido sus detalles personales serían mostrados a todos los visitantes. Pero sin embargo Vd. y los demás de su familia aparecen aún como privados. No quiere borrar el registro de defunción del hijo pero quiere ocultar los detalles y hacerlos privados.  para usted y su familia esta información sigue perteneciendo al ámbito privado. A usted no le interesa borrar la fecha de la defunción de su hijo pero quiere ocultar su información y hacerla privada. Si su hijo tuviese un ID de I100 debería hacer los ajustes de privacidad como sigue: <br /><br />ID: I100<br />Visible para: \"Sólo para usuarios registrados\"<br /><br />También nos sirve para proceder a la inversa. Si quiere hacer públicos los detalles de alguien (ID 101) que sabe que ha fallecido pero desconoce la fecha, podría ajustar su privacidad de la siguiente forma:<br /><br />ID: I101<br />Visible para: \"Todo el mundo\"<br /><br />Esto cambia la variable \$person_privacy en <i><u>xxx</u>.GED_priv.php</i>.<br />";
$pgv_lang["user_privacy"]				= "Ajustes de Privacidad de Usuario";
$pgv_lang["user_privacy_help"]			= "~#pgv_lang[user_privacy]#~<br /><br />Estos ajustes dan a los administradores la posibilidad de definir un ajuste de privacidad específico para una persona en particular del Gedcom y un nombre de usuario del sitio.  Suponga que no quiere que usuario registrado <b>Juan</b> pueda detalles del ID 100 del GEDCOM, podría configurar la privacidad así:<br /><br />Nombre usuario: Juan<br />ID: I100<br />Mostrar: \"Ocultar\"<br /><br /> y los detalles de la persona especificada se ocultarían del usuario \"Juan\" solamente.<br /><br />Para mostrar los detalles de I101 (que normalmente estarían ocultos porque I101 todavía vive) de nuevo al usuario \"Juan\" ponga:<br /><br />Nombre usuario: Juan<br />ID: I101<br />Mostrar: \"Mostrar\"<br /><br />Esto cambia la variable \$user_privacy en <i><u>xxx</u>.GED_priv.php</i>.<br />";
$pgv_lang["global_facts"]				= "Ajustes globales de privacidad para hechos";
$pgv_lang["global_facts_help"]			= "~#pgv_lang[global_facts]#~<br /><br />Estos ajustes definen hechos a ocultar a nivel global de todas las personas del GEDCOM.  Esto sólo se aplica a registros de hecho de nivel 1 como BIRT o DEAT que aparecen por sí mismos en la pestaña de hechos personales y detalles de la página de persona.<br /><ul><li>El elemento <b>#pgv_lang[name_of_fact]#</b> determina qué hecho debería ocultarse.</li><li>El elemento <b>#pgv_lang[choice]#</b> especifica el propio hecho o los detalles relacionados.</li><li>El elemento <b>#pgv_lang[accessible_by]#</b> determina a qué nivel de acceso se muestra el hecho.</li></ul><br />Esta característica permite ocultar ciertos hechos, identificados mediante etiquetas GEDCOM, para todoas las personas vivas o fallecidas. Por defecto, la etiqueta del SSN (Número Seguridad Social) permanece oculta para los visitantes. Esto es así para impedir la sustracción de los números de la Seguridad Social y la suplantación de identidad de sus familiares fallecidos.  Esto es especialmente importante para EE.UU.<br /><br />Si quisiese ocultar todos los matrimonios a los visitantes, pondría:<br /><br /><b>#pgv_lang[name_of_fact]#</b>  (MARR) - Marriage<br /><b>#pgv_lang[choice]#</b> \"#pgv_lang[fact_show]#\"<br /><br /><b>#pgv_lang[accessible_by]#</b> \"#pgv_lang[PRIV_USER]#\"<br /><br /><b>#pgv_lang[name_of_fact]#</b> (MARR) - Marriage<br /><b>#pgv_lang[choice]#</b> \"#pgv_lang[fact_details]#\"<br /><b>#pgv_lang[accessible_by]#</b> \"#pgv_lang[PRIV_USER]#\"<br /><br />Estos ajustes ocultarían los matrimonios y los detalles relacionados de todos los usuarios salvo los administradores.<br /><br />A diferencia de los demás ajustes, en <b>#pgv_lang[edit_exist_global_facts_settings]#</b> puede ocultar hechos hasta de los usuarios administradores. Los hechos no deseados quedan completamente suprimidos.<br /><br />Esto cambia la variable \$global_facts en <i><u>xxx</u>.GED_priv.php</i>.<br />";
$pgv_lang["person_facts"]				= "Ajustes de privacidad de hechos de persona";
$pgv_lang["person_facts_help"]			= "~#pgv_lang[person_facts]#~<br /><br />Estos ajustes definen hechos ocultos para una persona, familia o fuente específicos y el nivel de acceso al que se ocultan.  Esto sólo se aplica a los registros de hecho de nivel 1 como BIRT o DEAT que aparecen por sí mismos en la página de detalles relevante de la persona, familia o fuente.<br /><br />El primer elemento es el ID de la persona, familia o fuente.  El segundo elemento es el hecho.<br />El elemento <b>#pgv_lang[choice]#</b> especifica el propio hecho o los detalles relacionados.  El elemento <b>#pgv_lang[accessible_by]#</b> determina a qué nivel de acceso se mostrará el hecho  No todos los hechos mostrados en la listas son aplicables a todos los tipos de ID.  Por ejemplo, los hechos Nacimiento y Defunción no son relevantes para los registros de Fuente.<br /><br />La tabla \$person_facts funciona de la misma manera que la \$global_facts exceptuando que en este caso puede especificar el ID de la persona de la que quiere ocultar hechos.  De esta forma se podría ocultar el registro de matrimonio para una persona determinada.<br /><br />Esto cambia la variable \$person_facts en <i><u>xxx</u>.GED_priv.php</i>.<br />";
$pgv_lang["accessible_by"]			= "Visible por";
$pgv_lang["hide"]				= "No";
$pgv_lang["show_question"]			= "Mostrar";
$pgv_lang["user_name"]				= "Nombre usuario";
$pgv_lang["name_of_fact"]			= "Nombre del hecho";
$pgv_lang["choice"]				= "Elegir";
$pgv_lang["fact_show"]				= "Mostrar el hecho";
$pgv_lang["fact_details"]			= "Ver detalles del hecho";
$pgv_lang["privacy_header"]			= "Editar privacidad";
$pgv_lang["unable_to_find_privacy_indi"]	= "No fue posible encontrar una persona con el ID";
$pgv_lang["save_and_import"]			= "Después de guardar la configuración para este Gedcom, necesitará importar el archivo haciendo clic en el botón <b>Importar Gedcom</b> o yendo a <b>Admin.->Administrar Gedcoms->Importar</b>";
$pgv_lang["help_info"]				= "Puede obtener ayuda para cada opción haciendo clic en el signo de interrogación rojo \"?\" a la derecha de cada enunciado.";
$pgv_lang["SHOW_LIVING_NAMES"]			= "Ver nombres de vivos";
$pgv_lang["SHOW_LIVING_NAMES_help"]		= "~#pgv_lang[SHOW_LIVING_NAMES]#~<br /><br />Fija si se mostrarán al público los nombres de las personas vivas.<br /><br />Esto fija \$SHOW_LIVING_NAMES en <i><u>xxx</u>.GED_priv.php</i>.<br />\n";
$pgv_lang["SHOW_RESEARCH_ASSISTANT"]			= "Mostrar el asistente de investigación";
$pgv_lang["SHOW_RESEARCH_ASSISTANT_help"]		= "~#pgv_lang[SHOW_RESEARCH_ASSISTANT]#~<br /><br />¿Qué tipo de usuario puede ver el módulo asistente de investigación si está instalado?<br /><br />Esto fija \$SHOW_RESEARCH_ASSISTANT en <i><u>xxx</u>.GED_priv.php</i>.<br />";
$pgv_lang["USE_RELATIONSHIP_PRIVACY"]		= "Usar privacidad por parentesco";
$pgv_lang["USE_RELATIONSHIP_PRIVACY_help"]	= "~#pgv_lang[USE_RELATIONSHIP_PRIVACY]#~<br /><br />El valor <b>No</b> permite a los usuarios registrados ver los detalles de todas las personas vivas.  El valor <b>Sí</b> sólo permite ver la información privada de las personas vivas con las que los usuarios registrados están relacionados.<br /><br />Esto fija \$USE_RELATIONSHIP_PRIVACY en <i><u>xxx</u>.GED_priv.php</i>.<br />";
$pgv_lang["MAX_RELATION_PATH_LENGTH"]		= "Máxima longitud del camino";
$pgv_lang["MAX_RELATION_PATH_LENGTH_help"]	= "~#pgv_lang[MAX_RELATION_PATH_LENGTH]#~<br /><br />Si se ha activado #pgv_lang[USE_RELATIONSHIP_PRIVACY]#, los usuarios identificados sólo podrán ver y modificar personas dentro de este número de saltos de parentesco.<br /><br />Esto fija \$MAX_RELATION_PATH_LENGTH en <i><u>xxx</u>.GED_priv.php</i>.<br />";
$pgv_lang["CHECK_MARRIAGE_RELATIONS"]		= "Verificar parentesco por matrimonio";
$pgv_lang["CHECK_MARRIAGE_RELATIONS_help"]	= "~#pgv_lang[CHECK_MARRIAGE_RELATIONS]#~<br /><br />Comprueba el parentesco de las personas también a través de las relaciones por matrimonio.<br /><br />Esto fija \$CHECK_MARRIAGE_RELATIONS en <i><u>xxx</u>.GED_priv.php</i>.<br />";
$pgv_lang["SHOW_DEAD_PEOPLE"]			= "Ver fallecidos";
$pgv_lang["SHOW_DEAD_PEOPLE_help"]		= "~#pgv_lang[SHOW_DEAD_PEOPLE]#~<br /><br />Ajusta el nivel de acceso para toda las personas ya fallecidas.<br />";
$pgv_lang["select_privacyfile_button"]		= "Seleccione el archivo de privacidad";
$pgv_lang["PRIVACY_BY_YEAR"]		= "Limitar privacidad en función del año del evento";
$pgv_lang["PRIVACY_BY_YEAR_help"]	= "~#pgv_lang[PRIVACY_BY_YEAR]#~<br /><br />El ajuste <b>#pgv_lang[PRIVACY_BY_YEAR]#</b> permite ocultar detalles de personas en función de su edad a la fecha de ciertos eventos independientemente de si están vivos o si han fallecido.<br /><br />Utilice este ajuste junto con el ajuste <b>#pgv_lang[MAX_ALIVE_AGE]#</b>.  Por ejemplo, si fijó la edad a 100 y esta opción a <b>Sí</b>, todas las personas, vivas o no, nacidas hace menos de 100 años quedarán marcadas como privadas.  Personas casadas hace menos de 85 años y personas fallecidas hace menos de 75 años quedarán marcadas como privadas también.  Tome nota, por favor, de que el uso de esta opción ralentizará algo el funcionamiento de su sitio.<br /><br />Esto fija \$PRIVACY_BY_YEAR en <i><u>xxx</u>.GED_priv.php</i>.<br />";

//-- language edit utility
$pgv_lang["lang_edit_help"]			= "~#pgv_lang[translator_tools]#~<br /><br />Esta página está destinada a su uso por los traductores.  Puede traducir, comparar y exportar archivos de idioma.  También hay una opción para ayudar a los traductores a determinar el origen de un texto mostrado por PhpGedView.<br /><br />Puede utilizar las siguientes opciones y utilidades:<br />";
$pgv_lang["edit_langdiff"]		= "Editar y Configurar archivos de Idiomas";
$pgv_lang["bom_check"]		= "Comprobar marca de orden de octetos (BOM)";
$pgv_lang["bom_check_help"]		= "~#pgv_lang[bom_check]#~<br /><br />#pgv_lang[bom_check_desc]#<br />";
$pgv_lang["bom_check_desc"]		= "Esta comprobación analizará los archivos de idioma buscando el BOM (marca de orden de octetos).  Si se encuentra, se eliminará del archivo afectado. Estos códigos especiales pueden causar problemas en algunas partes de PhpGedView.";
$pgv_lang["lang_debug"]			= "Opción de depuración de los textos de ayuda";
$pgv_lang["lang_debug_help"]	= "~#pgv_lang[lang_debug]#~<br /><br />#pgv_lang[lang_debug_desc]#<br />";
$pgv_lang["lang_debug_desc"]	= "Si activa esta opción, los nombres de las variables de idioma utilizadas en los textos de ayuda se mostrarán en la ventana emergente de texto de ayuda.  Esto ayudará a los traductores a determinar qué nombre de variable necesita revisarse.<br /><br />Este ajuste sólo será válido durante la sesión PhpGedView actual.";
$pgv_lang["lang_debug_use"]		= "Utilizar la opción de depuración de los textos de ayuda";
$pgv_lang["bom_not_found"]		= "No se ha encontrado la marca de orden de octetos (BOM).";
$pgv_lang["bom_found"]			= "Se ha encontrado la marca de orden de octetos (BOM) in ";
$pgv_lang["edit_lang_utility"]		= "Herramienta para Edición de Idiomas";
$pgv_lang["edit_lang_utility_help"]	= "~#pgv_lang[edit_lang_utility]#~<br /><br />#pgv_lang[edit_lang_utility_desc]#<br />";
$pgv_lang["edit_lang_utility_desc"]	= "Puede usar esta utilidad para modificar el contenido de un archivo de idioma usando el contenido del archivo correspondiente inglés.<br /><br />Verá el contenido del archivo original inglés y el contenido del mismo tipo de archivo (hay cuatro) en su idioma elegido.  Entonces puede hacer clic en el texto de mensaje que se muestra bajo la versión inglesa y se abrirá una nueva ventana en la que puede modificar el texto.  Después puede salvar los cambios o abandonarlos.";
$pgv_lang["edit_lang_utility_warning"]	= "ATENCIÓN!<br /><br />Si decide utilizar el botón >#close_window_without_refresh#< debe tener en cuenta que no verá directamente los cambios en la pantalla del editor de idiomas hasta que no recargue manualmente la página y puede ocurrir que su archivo de idioma sea destruido si agrega un mensaje aún inexistente dentro del archivo de idioma o si edita nuevamente un mensaje que haya sido editado con anterioridad.<br /><br />Entonces, si realmente no sabe lo que está haciendo, por favor no utilice el botón <br />>#close_window_without_refresh#<.";
$pgv_lang["language_to_edit"]		= "Idioma a editar";
$pgv_lang["language_to_edit_help"]		= "~#pgv_lang[language_to_edit]#~<br /><br />En esta lista selecciona el idioma cuyos mensajes desee modificar.<br />";
$pgv_lang["file_to_edit"]		= "Tipo de archivo a editar";
$pgv_lang["file_to_edit_help"]			= "~#pgv_lang[file_to_edit]#~<br /><br />#pgv_lang[lang_file_descriptions]#";
$pgv_lang["lang_file_descriptions"]		= "~#pgv_lang[lang_filenames]#~<br /><br />PhpGedView ha implementado el soporte para muchos idiomas diferentes.  Esto se ha conseguido manteniendo todo los textos visibles a los usuarios en archivos completamente separados del programa principal.  Hay un conjunto de ocho archivos para cada idioma y los distintos textos se han ubicado en uno u otro archivo según su función.  <b>No todos los archivos necesitan estar presentes.</b>  Si un texto dado no está disponible aún traducido, PhpGedView utilizará la versión inglesa.<br /><br />Los archivos de cada idioma son:<br /><ul><li><b><i>admin.xx.php</i></b>&nbsp;&nbsp;Este archivo contiene términos y expresiones comunes a utilizar durante la administración de PhpGedView y de las bases de datos genealógicas.<br /><br /></li><li><b><i>configure_help.xx.php</i></b>&nbsp;&nbsp;Este archivo textos de ayuda utilizados durante la configuración de PhpGedView.  Estos textos de ayuda no están dirigidos a los usuarios normales.</li><li><b><i>countries.xx.php</i></b>&nbsp;&nbsp;Es una lista de nombres de países, tomadas del sitio Web de la División de Estadística del Departamento de Asuntos Económicos y Sociales de las Naciones Unidas. La lista en inglés aparece en <a href=\"http://unstats.un.org/unsd/methods/m49/m49alpha.htm\" target=\"_blank\"><b>link</b></a>.  La lista está disponible en inglés y en francés.</li><li><b><i>editor.xx.php</i></b>&nbsp;&nbsp;Este archivo contiene términos y expresiones comunes a utilizar durante la modificación de entradas de las bases de datos genealógicas.<br /><br /></li><li><b><i>facts.xx.php</i></b>&nbsp;&nbsp;Este archivo contiene los textos correspondientes a los códigos de hechos GEDCOM que aparecen en el estándar GEDCOM 5.5.1.  También contiene códigos adicionales de hechos que no aparecen en el estándar pero que diversos programas de genealogía utilizan.<br /><br />Se puede descargar un copia en inglés del <a href=\"http://www.phpgedview.net/ged551-5.pdf\" target=\"_blank\"><b>Estándar GEDCOM 5.5.1</b></a> en formato PDF (Portable Document Format).</li><li><b><i>faqlist.xx.php</i></b>&nbsp;&nbsp;Este archivo es un conjunto de <b>p</b>reguntas <b>f</b>recuentes que han sido recopiladas por el equipo de desarrollo de PhpGedView.  Cada pregunta frecuente tiene dos entradas en este archivo.  Una entrada es el encabezamiento (generalmente la pregunta) y la otra el cuerpo (generalmente la respuesta).  Los archivos <b><i>faqlist.xx.php</i></b> se actualizan con frecuencia y pueden descargarse del sitio web de PhpGedView.<br /><br />El administrador puede utilizar las preguntas frecuentes de este archivo para construir una lista de preguntas frecuentes específica para su sitio.<br /><br /></li><li><b><i>help_text.xx.php</i></b>&nbsp;&nbsp;Este archivo contiene texto de ayuda para los usuarios normales.  Algunos temas de ayuda en este archivo son para los administradores y no son vistos por usuarios que no tienen derechos de administración.</li><li><b><i>lang.xx.php</i></b>&nbsp;&nbsp;Muchos términos y expresiones comunes aparecen en este archivo.</li></ul>PhpGedView también utiliza un noveno archivo opcional de idioma, <b><i>extra.xx.php</i></b>.  Este archivo se carga siempre después de todos los demás y proporciona un medio por el que el administrador del sitio puede reemplazar cualquier texto estándar en el idioma seleccionado.  También se puede utilizar para proporcionar un título a las bases de datos genealógicas que cambie según el idioma activo en cada momento.<br /><br />El contenido de este archivo adicional queda completamente al arbitrio del administrador del sitio;  este archivo <b>nunca</b> formará parte de la distribución de ninguna versión de PhpGedView.  El administrador nunca debería cambiar los archivos de idioma estándar;  todos los cambios locales debería concentrarse en este archivo opcional.<br /><br />";
$pgv_lang["check"]			= "Comprobar";
$pgv_lang["lang_save"]			= "Salvar";
$pgv_lang["contents"]			= "Contenidos";
$pgv_lang["listing"]			= "Lista";
$pgv_lang["no_content"]			= "No hay contenido";
$pgv_lang["editlang"]			= "Modificar";
$pgv_lang["editlang_help"]		= "~#pgv_lang[editlang]#~<br /><br />Editar mensaje de un archivo de idioma.<br />";
$pgv_lang["savelang"]			= "Salvar";
$pgv_lang["savelang_help"]		= "~#pgv_lang[savelang]#~<br /><br />Guardar mensaje modificado en el archivo de idioma.<br />";
$pgv_lang["original_message"]		= "Mensaje original";
$pgv_lang["message_to_edit"]		= "Mensaje a editar";
$pgv_lang["changed_message"]		= "Contenido modificado";
$pgv_lang["message_empty_warning"]	= "-> Atención!!! Este mensaje está vacío en [#LANGUAGE_FILE#] <-";
$pgv_lang["language_to_export"]		= "Idioma a exportar";
$pgv_lang["language_to_export_help"]		= "~#pgv_lang[language_to_export]#~<br /><br />Con esta lista puede seleccionar el idioma cuyos mensajes desee exportar.<br /><br />Esta parte del programa sólo exporta actualmente el contenido de los archivos <i>configure_help.xx.php</i>, <i>help_text.xx.php</i> y <i>lang.xx.php</i>.  La salida es un archivo HTML que puede imprimir desde su navegador.<br />";
$pgv_lang["export_lang_utility"]	= "Exportar un archivo de idioma";
$pgv_lang["export"]			= "Exportar";
$pgv_lang["export_lang_utility_help"]	= "~#pgv_lang[export_lang_utility]#~<br /><br />#pgv_lang[export_lang_utility_desc]#<br />";
$pgv_lang["export_lang_utility_desc"]	= "Puede crear documentación para los administradores.<br /><br />Esta utilidad producirá una versión HTML del archivo Ayuda de Configuración en el idioma elegido.  Puede utilizar su navegador para inspeccionar este archivo que tiene un formato apropiado para ser impreso.";
$pgv_lang["export_ok"]			= "Mensajes de ayuda exportados";
$pgv_lang["compare_lang_utility"]	= "Comparación de archivos de idioma";
$pgv_lang["compare_lang_utility_help"]	= "~#pgv_lang[compare_lang_utility]#~<br /><br />#pgv_lang[compare_lang_utility_desc]#<br />";
$pgv_lang["compare_lang_utility_desc"]	= "Esta utilidad compara dos conjuntos de archivos de idioma para producir una lista de adiciones o eliminaciones entre ambos.<br /><br />Lea también el archivo <a href=\"languages/LANG_CHANGELOG.txt\" target=\"_blank\">LANG_CHANGELOG.txt</a> para ver los cambios a la versión en inglés.  Estos archivos en inglés deberían ser la referencia para la producción de los demás.";
$pgv_lang["new_language"]		= "Nuevo idioma";
$pgv_lang["new_language_help"]			= "~#pgv_lang[new_language]#~<br /><br />En esta lista puede seleccionar el idioma cuyos mensajes desea comparar con los de otros idioma.<br /><br />Todos los cambios y adiciones a los archivos de idioma se hacen primero en los archivos del idioma <b>Inglés</b>, así que normalmente seleccionaría inglés como uno de los idiomas con los que comparar.<br />";
$pgv_lang["old_language"]		= "Idioma anterior";
$pgv_lang["old_language_help"]			= "~#pgv_lang[old_language]#~<br /><br />En esta caja de lista puede seleccionar el idioma que quiere comparar con el idioma seleccionado en la caja de lista <b>Idioma fuente</b>.<br /><br />Tras haber hecho su selección, haga clic en el botón <b>Comparar</b> y obtendrá una lista de todas las adiciones y supresiones en los cuatro archivos de ambos idiomas.<br /><br />Para refrescar su memoria:<br /><b>Adición</b> significa: Está <u>en</u> el archivo Fuente, pero <u>no</u> en el archivo Secundario.<br /><br /><b>Supresión</b> significa: <u>No</u> está en el archivo Fuente, pero <u>está</u> en el archivo Secundario.  Esto podría ocurrir si un mensaje dado ya no se utiliza y por tanto se eliminó de los archivos del idioma inglés.  Puede eliminar sin miedo el mensaje correspondiente de los archivos del idioma secundario.<br />";
$pgv_lang["compare"]			= "Comparar";
$pgv_lang["comparing"]			= "Archivos de idiomas se comparan";
$pgv_lang["additions"]			= "Adiciones";
$pgv_lang["no_additions"]		= "No hubo añadidos";
$pgv_lang["subtractions"]		= "Supresiones";
$pgv_lang["no_subtractions"]		= "No hubo supresiones";
$pgv_lang["config_lang_utility"]	= "Configuración de idiomas";
$pgv_lang["config_lang_utility_help"]	= "~#pgv_lang[config_lang_utility]#~<br /><br />Esta página se utiliza para controlar qué idiomas están disponibles a sus usuarios.  Por ejemplo, puede configurar las cosas para que sólo estén disponibles el alemán y el francés.  Esto puede ser útil si, por ejemplo, no puede comunicar con sus usuarios en húngaro.<br /><br />También puede utilizar esta página para cambiar algunos aspectos de PhpGedView que dependen del idioma seleccionado..  Por ejemplo, aquí es donde puede decir a PhpGedView como mostrar los campos de fecha y hora.<br /><br />Los idiomas que están activos pero se muestran atenuados no se pueden desactivar porque están siendo utilizados.  Mire en la tabla inferior para ver dónde se usa.  Cuando un idioma ya no sea utilizado por un GEDCOM o por un usuario podrá desactivarlo.<br /><br />Todos sus cambios se grabarán en un nuevo archivo llamado <b>lang_settings.php</b> creado en el directorio <b>#INDEX_DIRECTORY#</b>.  Todos los cambios posteriores que haga se harán a este nuevo archivo y PhpGedView sólo utilizará <u>este</u> archivo.  Puede volver a los ajustes originales de idioma eliminando este archivo.<br /><br />Si debe reportar problemas con sus ajustes de idioma, indique por favor al equipo de soporte de PhpGedView si este nuevo archivo está presente o no.<br />";
$pgv_lang["active"]			= "Activar";
$pgv_lang["active_help"]		= "~#pgv_lang[active]#~<br /><br />Permite a los usuarios seleccionar este idioma si la opción option <b>#pgv_lang[ENABLE_MULTI_LANGUAGE]#</b> está activada.<br />";
$pgv_lang["edit_settings"]		= "Editar preferencias";
$pgv_lang["lang_edit"]			= "Editar";
$pgv_lang["lang_language"]		= "Idioma";
$pgv_lang["export_filename"]		= "Nombre del archivo con los datos de exportación:";
$pgv_lang["lang_back"]			= "Regresar al menú principal para editar y configurar los archivos de idiomas";
$pgv_lang["lang_back_admin"]		= "Regresar al menú de Administración.";
$pgv_lang["lang_back_manage_gedcoms"]	= "Regresar al menú de Administración del GEDCOM";
$pgv_lang["lang_name_czech"]		= "Checo";
$pgv_lang["lang_name_chinese"]		= "Chino";
$pgv_lang["lang_name_danish"]		= "Danés";
$pgv_lang["lang_name_dutch"]		= "Holandés";
$pgv_lang["lang_name_english"]		= "Inglés";
$pgv_lang["lang_name_finnish"]		= "Finlandés";
$pgv_lang["lang_name_french"]		= "Francés";
$pgv_lang["lang_name_german"]		= "Alemán";
$pgv_lang["lang_name_hebrew"]		= "Hebreo";
$pgv_lang["lang_name_hungarian"]	= "Húngaro";
$pgv_lang["lang_name_italian"]		= "Italiano";
$pgv_lang["lang_name_norwegian"]	= "Noruego";
$pgv_lang["lang_name_polish"]		= "Polaco";
$pgv_lang["lang_name_portuguese"]	= "Portugués";
$pgv_lang["lang_name_portuguese-br"]	= "Portugués Brasileño";
$pgv_lang["lang_name_russian"]		= "Ruso";
$pgv_lang["lang_name_spanish"]		= "Español";
$pgv_lang["lang_name_spanish-ar"]	= "Español Latino Americano";
$pgv_lang["lang_name_swedish"]		= "Sueco";
$pgv_lang["lang_name_turkish"]		= "Turco";
$pgv_lang["lang_name_greek"]		= "Griego";
$pgv_lang["lang_name_arabic"]		= "Árabe";
$pgv_lang["lang_name_lithuanian"]	= "Lituano";
$pgv_lang["lang_name_vietnamese"]	= "Vietnamita";
$pgv_lang["lang_name_slovak"]		= "Eslovaco";
$pgv_lang["lang_name_estonian"]		= "Estonio";
$pgv_lang["lang_new_language"]		= "Nuevo Idioma";
$pgv_lang["original_lang_name"]		= "Nombre original del idioma en #D_LANGNAME#";
$pgv_lang["original_lang_name_help"]	= "~Nombre original del idioma~<br /><br />¿Cómo se llama este idioma en este idioma?<br /><br />El español se llama a sí mismo <b>Español</b>; el inglés se llama a sí mismo <b>English</b>;  el alemán se llama a sí mismo <b>Deutsch</b>;  el checo se llama a sí mismo <b>Ceština</b>, etc.<br />";
$pgv_lang["lang_shortcut"]		= "Abreviatura para los archivos de idioma";
$pgv_lang["lang_shortcut_help"]		= "~#pgv_lang[lang_shortcut]#~<br /><br />Este código define una abreviatura para el nombre del idioma.  Esta abreviatura forma parte del nombre de cada uno de los archivos de idioma utilizados por PhpGedView.  Por ejemplo, la abreviatura utilizada para el francés es <b>fr</b> y, en consecuencia, los nombres de los archivos para el francés son <i>configure_help.<b>fr</b>.php</i>, <i>countries.<b>fr</b>.php</i>, <i>facts.<b>fr</b>.php</i>, <i>help_text.<b>fr</b>.php</i> y <i>lang.<b>fr</b>.php</i><br />";
$pgv_lang["lang_langcode"]		= "Códigos de detección de Idioma";
$pgv_lang["lang_langcode_help"]		= "~#pgv_lang[lang_langcode]#~<br /><br />Estos códigos permiten a PhpGedView detectar el ajuste de Idioma Preferido de su navegador.  PhpGedView determina el idioma realmente solicitado por el navegador comparando el código de idioma del navegador contra esta lista.  Los codigos individuales deben separarse por punto y coma.<br />";
$pgv_lang["lang_filenames"]		= "Archivos de idioma";
$pgv_lang["lang_filenames_help"]		= "~#pgv_lang[lang_filenames]#~<br /><br />#pgv_lang[lang_file_descriptions]#";
$pgv_lang["flagsfile"]			= "Nombre del archivo de bandera";
$pgv_lang["flagsfile_help"]		= "~#pgv_lang[flagsfile]#~<br /><br />Nombre del archivo con la imagen de la bandera para el idioma seleccionado.<br /><br />Están disponibles las imágenes para muchos países en el sitio de <a href=\"http://w3f.com/gifs/index.html\"><b>The WWWeb Factory</b></a>.<br /><br />Si encuentra una imagen de bandera que le gusta, haga clic con el botón derecho y salve la imagen en una carpeta temporal. A contiuación, abra la imagen salvada con un editor de imágenes (se recomienda IrfanView para sistemas Windows), reduzca su tamaños a 50x32 pixels, que es el tamaño normal utilizado en PhpGedView y sálvelo como un archivo GIF a la carpeta <i><b>images/flags</b></i>.<br /><br />Aunque puede utilizar cualquier nombre que desee, debería seleccionar un nombre consistente con la abreviatura de dos letras.  Por ejemplo, el croata se representa por el código de dos letras <i><b>hr</b></i>, así que la bandera croata se llamaría normalmente <i><b>hr.gif</b></i>.<br />";
$pgv_lang["text_direction"]		= "Dirección texto";
$pgv_lang["text_direction_help"]	= "~#pgv_lang[text_direction]#~<br /><br />Indica en qué dirección se escribe en el idioma elegido.  La mayoría de los idiomas se escriben de izquierda a derecha.  Árabe y hebreo son ejemplos de idiomas que se escriben en la dirección contraria (de derecha a izquierda).<br />";
$pgv_lang["date_format"]			= "Formato fecha";
$pgv_lang["date_format_help"]		= "~#pgv_lang[date_format]#~<br /><br />Este campo define el formato de fecha que ha de utilizar PhpGedView al mostrar fechas de la base de datos.<ul><li><b>Formato estándar</b><br />Los símbolos que puede utilizar son:<br /><b>D</b> para el día<br /><b>M</b> para el mes<br /><b>Y</b> para el año.<br /><br />Puede cambiar el orden de estos símbolos y puede añadir delimitadores al formato.<br /><br />Para los ejemplos que siguen, suponga que la fecha en la base de datos es 1965.08.20 que, en realidad, consta en ella como <b>DATE&nbsp;20&nbsp;Aug&nbsp;1965</b>.<br /><br />El ajuste estándar para el formato de presentación en inglés es <b>D&nbsp;M&nbsp;Y</b>, que produce el resultado <b>20&nbsp;August&nbsp;1965</b>.<br /><br />El formato de fecha alemán es generalmente <b>D.&nbsp;M&nbsp;Y</b>, lo que resulta en <b>20.&nbsp;August&nbsp;1965</b> al mostrarse en PhpGedView.  El octavo mes se llama \"August\" en alemán.<br /><br />En húngaro, el formato suele ser <b>Y.&nbsp;M&nbsp;D.</b> que produce <b>1965.&nbsp;augusztus&nbsp;20.</b> al mostrarse en PhpGedView.  En húngaro, los nombres de mes no comienzan con mayúscula y el octavo mes se llama \"augusztus\".<br /><br /></li><li><b>Formato alternativo</b><br />Para mostrar fechas en formas especiales no manejadas por el <b>Formato estándar</b>, utilice estos códigos:<br /><b>d</b> - día del mes, 2 dígitos, con cero a la izquierda si es necesario; es decir, desde <b>01</b> hasta <b>31</b><br /><b>D</b> - día de la semana, abreviado a 3 letras; p. ej. <b>vie</b><br /><b>F</b> - mes, como texto sin abreviar; p. ej. <b>enero</b><br /><b>j</b> - día del mes, sin ceros a la izquierda; es decir, desde <b>1</b> hasta <b>31</b><br /><b>l</b> (\"L\" minúscula) - día de la semana, en texto y sin abreviar; p. ej. <b>viernes</b><br /><b>M</b> - mes, en texto abreviado a 3 letras; p. ej. <b>ene</b><br /><b>Y</b> - año con cuatro dígitos; p. ej. <b>1999</b><br /><b>R</b> - formato revolucionario francés (ver nota)<br /><b>y</b> - año, dos dígitos; p. ej. <b>99</b><br /><br />Por ejemplo, el formato de fecha <b>D&nbsp;j&nbsp;F&nbsp;Y</b> puede producir fechas como <b>jue&nbsp;9&nbsp;enero&nbsp;1806</b> mientras que la misma fecha mostrada con la fórmula <b>l&nbsp;d&nbsp;M&nbsp;Y</b> resulta <b>jueves&nbsp;09&nbsp;ene&nbsp;1806</b><br /><br /></li><li><b>Formato revolucionario francés</b><br />El código de formato <b>R</b> funciona en todos los idiomas, pero produce salida cuando la fecha está comprendida en el intervalo 1792.09.22 a 1805.12.31.  El código <b>R</b> produce únicamente texto francés y el orden de día, mes y año no puede cambiarse. La salida del código de formato <b>R</b> se subraya para distinguirla de una fecha normal.  <br /><br />El código de formato <b>R</b> se considera texto normal si el formato de fecha contienes solamente los códigos <b>D</b>, <b>M</b> y <b>Y</b> como se describe el el tema <b>Formato estándar</b> más arriba.  En otras palabras, para que el código <b>R</b> se reconozca, el formato de fecha debe contener un código de la lista de <b>Formato alternativo</b> que no aparezca en la lista <b>Formato estándar</b>.<br /><br />Por ejemplo, el formato de fecha <b>D&nbsp;M&nbsp;Y&nbsp;R</b> producirá <b>13&nbsp;octubre&nbsp;1797&nbsp;R</b> en español para la fecha 1797.10.13. Si, por el contrario, el formato de fecha fuera <b>j&nbsp;F&nbsp;Y&nbsp;R</b>, la misma fecha produciría <b>13&nbsp;octubre&nbsp;1797&nbsp;<u>22&nbsp;Vendimiario&nbsp;An&nbsp;6</u></b> in español.</li></ul>";
$pgv_lang["time_format"]		= "Formato de hora";
$pgv_lang["time_format_help"]		= "~#pgv_lang[time_format]#~<br /><br />Este campo define el formato de hora utilizado por PhpGedView.<br /><br />Los símbolos que pueden utilizarse son:<br /><b>a</b> - antes del mediodía o después del mediodía en minúscula, es decir, <b>am</b> o <b>pm</b><br /><b>A</b> - antes del mediodía o después del mediodía en mayúsculas; es decir, <b>AM</b> o <b>PM</b><br /><b>B</b> - hora Internet de Swatch; es decir <b>000</b> a <b>999</b><br /><b>c</b> - fecha ISO 8601 (novedad en PHP 5); p. ej. <b>2004-02-12T15:19:21+00:00</b><br />d - día del mes, 2 dígitos con cero a la izquierda si fuera necesario; es decir, <b>01</b> a <b>31</b><br /><b>D</b> - día, texto, tres letras; p. ej. <b>lun</b> a <b>dom</b><br /><b>F</b> - mes, texto, completo, p.ej. <b>enero</b><br /><b>g</b> - hora, formato de 12 horas, sin cero a la izquierda; es decir, <b>1</b> a <b>12</b><br /><b>G</b> - hora, formato de 24 horas, sin cero a la izquierda; es decir, <b>0</b> a <b>23</b><br /><b>h</b> - hora, formato de 12 horas, con cero a la izquierda; es decir, <b>01</b> a <b>12</b><br /><b>H</b> - hora, formato de 25 horas, con cero a la izquierda; es decir, <b>00</b> a <b>23</b><br /><b>i</b> - minutos, cero a la izquierda; es decir, <b>00</b> a <b>59</b><br /><b>I</b> (\"i\" mayúscula) - indicador de horario de verano; <b>1</b> si en horario de verano, <b>0</b> en otro caso.<br /><b>j</b> - día del mes, sin cero a la izquierda; es decir, <b>1</b> a <b>31</b><br /><b>l</b> (\"L\" minúscula) - día de la semana, texto, completo; p.ej. <b>viernes</b><br /><b>L</b> - indicador de año bisiesto; <b>1</b> si es bisiesto, <b>0</b> en otro caso.<br /><b>m</b> - mes, numérico, cero a la izquierda; es decir, <b>01</b> a <b>12</b><br /><b>M</b> - mes, texto, 3 letras; p. ej <b>ene</b><br /><b>O</b> (\"o\" mayúscula) - diferencia entre la hora local y al de Greenwich (GMT) en horas; p. ej. <b>+0200</b><br /><b>r</b> - fecha en formato RFC 2822; p. ej. <b>Thu,&nbsp;21&nbsp;Dic&nbsp;2000&nbsp;16:01:07&nbsp;+0200</b><br /><b>s</b> - segundos, con cero a la izquierda; es decir, <b>00</b> a <b>59</b><br /><b>S</b> - sufijo para el día del mes, sólo en inglés, 2 caracteres; es decir, <b>st</b>, <b>nd</b>, <b>rd</b> o <b>th</b>. Va bien con <b>j</b><br /><b>t</b> - número de días en el mes dado; es decir; <b>28</b> a <b>31</b><br /><b>T</b> - zona horaria de esta máquina; p.ej.<b>CEST</b>, <b>EST</b>, <b>CET</b><br /><b>U</b> - segundos desde el comienzo de la era UNIX (1&nbsp;enero&nbsp;1970&nbsp;00:00:00 GMT)<br /><b>w</b> - día de la semana, numérico; es decir, <b>0</b> (domingo) a <b>6</b> (sábado)<br /><b>W</b> - número de la semana ISO 8601, comenzando las semanas en lunes; p. ej. <b>42</b> (la semana número 42 del año)<br /><b>Y</b> - año, 4 dígitos; p. ej. <b>1999</b><br /><b>y</b> - año, 2 dígitos; p. ej. <b>99</b><br /><b>z</b> - día del año, numérico, sin ceros a la izquierda; es decir, <b>0</b> (1 de enero) a <b>364</b> (31 de diciembre si no es año bisiesto) o <b>365</b> (31 de diciembre en año bisiesto)<br /><b>Z</b> - diferencia de la zona horaria en segundos.  La diferencia para las zonas al oeste de Greenwich es siempre negativa y para las que están al este de Greenwich es siempre positiva, es decir <b>-43200</b> a <b>43200</b><br /><br />Puede cambiar el orden de estas variables y también agregar caracteres delimitadores.<br /><br />Por ejemplo en alemán el contenido de este campo suele ser: <b>H:i:s</b> que genera <b>09:01:25</b>.<br />En inglés la definición de este campo suele ser <b>g:i:sa</b> que genera <b>9:01:25am</b>.<br /><br />En el sistema de 24 horas, la medianoches es 00:00.  En el sistema de 12 horas, la medianoche es 12:00am y el mediodía es 12:00pm.<br />";
$pgv_lang["week_start"]			= "Día de comienzo de la semana";
$pgv_lang["week_start_help"]		= "~#pgv_lang[week_start]#~<br /><br />El día de la semana en que ésta comienza en este idioma.  La mayoría de los idiomas comienzan la semana en domingo, pero otros comienzan en lunes u otros días.<br />";
$pgv_lang["name_reverse"]		= "Primero apellido";
$pgv_lang["name_reverse_help"]		= "~#pgv_lang[name_reverse]#~<br /><br />En algunos idiomas el apellido debería mostrarse delante del nombre, en lugar del modo por defecto en que se muestra en último lugar. Activando esta opción el apellido se mostrará primero. Húngaro, chino y japonés son ejemplos en los que el apellido (el nombre de familia) suele colocarse primero.<br />";
$pgv_lang["ltr"]			= "Izquierda a derecha";
$pgv_lang["rtl"]			= "Derecha a izquierda";
$pgv_lang["file_does_not_exist"]	= "¡ERROR! El archivo no existe...";
$pgv_lang["alphabet_upper"]		= "Alfabeto Mayúsculas";
$pgv_lang["alphabet_upper_help"]	= "~#pgv_lang[alphabet_upper]#~<br /><br />Las letras mayúsculas del alfabeto en este idioma. Este alfabeto se utiliza para ordenar las listas de nombres.<br />";
$pgv_lang["alphabet_lower"]		= "Alfabeto minúsculas";
$pgv_lang["alphabet_lower_help"]	= "~#pgv_lang[alphabet_lower]#~<br /><br />Las letras minúsculas del alfabeto en este idioma. Este alfabeto se utiliza para ordenar listas de nombres.<br />";
$pgv_lang["multi_letter_alphabet"]		= "Alfabeto multiletra";
$pgv_lang["multi_letter_alphabet_help"]	= "~#pgv_lang[multi_letter_alphabet]#~<br /><br />La combinaciones multi-letras que deban tratarse como una sola letra al clasificar las listas de nombres y títulos en este idioma.<br /><br />Algunos idiomas, húngaro y eslovaco por ejemplo, consideran que ciertas combinaciones de letras son letras distintas por sí mismas. El orden en que se especifican estas combinaciones de letras determina el orden en que se insertan en el alfabeto normal durante la clasificación.  Esto es importante cuando varias combinaciones multi-letra empiezan por la misma letra.  Salvo el caso de <b>ch</b>, estas combinaciones de letras se insertan en el alfabeto normal según su primera letra.  <b>ch</b> siempre se inserta detrás de <b>h</b>.<br />";
$pgv_lang["dictionary_sort"]		= "Utilizar reglas de diccionario al clasificar";
$pgv_lang["dictionary_sort_help"]	= "~#pgv_lang[dictionary_sort]#~<br /><br />Esta opción controlo cómo se clasifican los caracteres con marcas diacríticas.<br /><br />Se se fija a <b>#pgv_lang[yes]#</b>, todos los caracteres con marcas diacríticas se tratan como si no las tuvieran.  Estas marcas diacríticas sólo se tienen en cuenta cuando las palabras comparadas son en todo lo demás idénticas.  Si se fija a <b>#pgv_lang[no]#</b>, todas las letras con o sin marcas diacríticas se tratan como distintas.<br />";
$pgv_lang["lang_config_write_error"]	= "Error escribiendo los ajustes del idioma en el archivo [language_settings.php]. Compruebe los permisos e inténtelo de nuevo.";
$pgv_lang["translation_forum"]		= "Vínculo a foro PhpGedView de traducciones en SourceForge";
$pgv_lang["translation_forum_help"]	= "~#pgv_lang[translation_forum]#~<br /><br />#pgv_lang[translation_forum_desc]#<br />";
$pgv_lang["translation_forum_desc"]	= "Este <a href=\"http://sourceforge.net/forum/forum.php?forum_id=294245\" target=\"_blank\"><b>vínculo</b></a> abre una nueva ventana de su navegador en el foro de traducciones de PhpGedView, donde puede discutir acerca de la traducción.";
$pgv_lang["lang_set_file_read_error"]	= "¡¡¡ E R R O R !!! No se pudo leer el [language_settings.php]!";
$pgv_lang["add_new_language_help"]	= "~#pgv_lang[add_new_language]#~<br /><br />#pgv_lang[add_new_language_desc]#";
$pgv_lang["add_new_language_desc"]	= "Esta rutina le permite añadir un idioma completamente nuevo a PhpGedView.<br /><br />Puede establecer los ajustes estándar para el nuevo idioma.  Éstos incluyen el código de detección de idioma, la dirección de escritura del idioma, el comienzo de la semana para este idioma, los convenios de hora, el alfabeto, etc.<br /><br />Recibirá más ayuda acerca de los ajustes de los idiomas contemplados en PhpGedView tras seleccionar el idioma y hacer clic en el botón <b>#pgv_lang[add_new_lang_button]#</b>.<br /><br />Hay más ayuda disponible en la página de Configuración para el idioma.<br />";
$pgv_lang["add_new_lang_button"]	= "Agregar un nuevo idioma";
$pgv_lang["hide_translated"]		= "Ocultar traducidos";
$pgv_lang["hide_translated_help"]		= "~#pgv_lang[hide_translated]#~<br /><br />Si se fija a <b>Sí</b> sólo verá los mensajes de su idioma seleccionado que no hayan sido traducidos.  Esto significa que el nuevo mensaje <u>no</u> aparece en el archivo de idioma objetivo.<br /><br />Algunos archivos de idioma contienen texto inglés para varios mensajes sin traducción.  Esta rutina no puede identificar estas entradas sin traducción, puesto que ya están presentes en el archivo objetivo.  Se supone que \"Si el mensaje está presente en el archivo objetivo, debe haber sido traducido.\"<br />";
$pgv_lang["lang_file_write_error"]	= "¡¡¡ E R R O R !!!<br /><br />No se han podido grabar las modificaciones realizadas al archivo de idioma seleccionado!<br />Verifique los permisos de escritura en (#lang_filename#)|";
$pgv_lang["no_open"]	= "¡¡¡ E R R O R !!!<br /><br />No se pude abrir el fichero <b>#lang_filename#</b>";
$pgv_lang["users_langs"]			= "Idiomas de los usuarios";
$pgv_lang["configured_languages"]	= "Idiomas usados";

//-- User Migration Tool messages
$pgv_lang["um_header"] = "Herramienta para migración de la información de usuarios";
$pgv_lang["um_proceed"] = "Escoja una opción o haga clic en el vínculo inferior para volver al menú de Administración<br />";
$pgv_lang["um_creating"] = "Creando";
$pgv_lang["um_sql_index"] = "Esta herramienta creará archivos <i>authenticate.php</i> y varios <i>.dat</i> en su directorio index.<br /><br />Tras una creación con éxito, puede cambiar a modo Índice con todos los usuarios actuales y sus mensajes, favoritos, noticias y disposición en MiGedView preservados.<br /><br />Nota: Tras cambiar a modo Index, tendrá que importar sus archivos GEDCOM de nuevo.<br />";
$pgv_lang["um_file_create_fail1"] = "Falló la creación del nuevo archivo, ya existe un archivo con ese nombre:";
$pgv_lang["um_file_create_fail2"] = "No se pudo crear";
$pgv_lang["um_file_create_fail3"] = "Compruebe los derechos de acceso en este directorio.";
$pgv_lang["um_file_create_succ1"] = "Creación con éxito del nuevo archivo:";
$pgv_lang["um_file_not_created"] = "No se crea el archivo.";
$pgv_lang["um_nomsg"] = "No parece haber mensajes en el sistema.";
$pgv_lang["um_nofav"] = "No parece haber favoritos en el sistemas.";
$pgv_lang["um_nonews"] = "No parece haber noticias en el sistema.";
$pgv_lang["um_noblocks"] = "No parece haber bloques definidos en el sistema.";
$pgv_lang["um_index_sql"] = "Esta herramienta importará <i>authenticate.php</i> y otros archivos <i>.dat</i> de su directorio index a su base de datos.<br />";
$pgv_lang["um_noaction"] = "No es necesaria ninguna acción para migrar la información de usuarios al modo SQL.<br /><br />Una vez hecho el cambio, necesitará rearrancar la herramienta de Migración de Usuarios para importar todos los datos a la base de datos SQL.  PhpGedView utilizará los archivos existentes del modo Índice.<br /><br /><b><u>No</u> borre <i>authenticate.php</i> ni los archivos <i>.dat</i> de su directorio de índice mientras se hace el cambio.</b><br />";
$pgv_lang["um_import"] = "Importar";
$pgv_lang["um_export"] = "Exportar";
$pgv_lang["um_explain"] = "Esta herramienta le permitirá tanto exportar datos de usuario de modo SQL a modo Índice, como importar datos de usuario desde archivos Índice a tablas SQL.<br /><br />Tras la migración, se conservarán los datos de los usuarios, favoritos, definiciones de bloques, mensajes y noticias.<br /><br /><b>ATENCIÓN</b><br />No puede utilizar esta herramienta para migrar datos de usuario entre distintas versiones de PhpGedView. Asegúrese de que los datos provienen de, o son importados a, la misma versión de PhpGedView.<br /><br /><b>IMPORTAR</b><br />Si elige importar los archivos de datos de los usuarios del modo índice, todos los datos de usuarios presentes actualmente en las tablas de la base de datos serán <u>reemplazados</u> por los nuevos datos. Esta herramienta <u>no</u> mezcla la información. Una vez realizada la Importación, no hay forma de recuperar la vieja información utilizando PhpGedView.<br /><br /><b>EXPORTAR</b><br />Si exporta la información de usuarios de su base de datos SQL a archivos de modo Índice, esta herramienta creará <i>authenticate.php</i> y varios archivos <i>.dat</i> en su directorio index. Si existen archivos ya presentes con los mismos nombres, se le preguntará si desea sobreescribirlo. Tras cambiar a modo Índice, toda la información estará disponible directamente.<br /><br /><b>Nota:</b> Tras cambiar a modo Índice, tendrá que importar sus archivos GEDCOM de nuevo.<br />";
$pgv_lang["um_tool_help"] = "~#pgv_lang[um_header]#~<br /><br />#pgv_lang[um_explain]#";
$pgv_lang["um_sql_index_help"] = "~Migrar usuarios de modo SQL a modo Índice~<br /><br />#pgv_lang[um_sql_index]#";
$pgv_lang["um_index_sql_help"] = "~Migrar usuarios de modo Índice a modo SQL~<br /><br />#pgv_lang[um_index_sql]#";
$pgv_lang["um_imp_users"] = "Importando usuarios";
$pgv_lang["um_imp_blocks"] = "Importando bloques";
$pgv_lang["um_imp_favorites"] = "Importando favoritos";
$pgv_lang["um_imp_messages"] = "Importando mensajes";
$pgv_lang["um_imp_news"] = "Importando noticias";
$pgv_lang["um_nousers"] = "No se encontró el archivo <i>authenticate.php</i> en su directorio index. Se cancela la migración.";
$pgv_lang["um_imp_succ"] = "Importación con éxito";
$pgv_lang["um_imp_fail"] = "Falló la importación";
$pgv_lang["um_backup"] = "Copia de seguridad";
$pgv_lang["um_zip_succ"] = "Archivo ZIP creado con éxito";
$pgv_lang["um_zip_dl"] = "Descargar archivo ZIP con la copia de seguridad";
$pgv_lang["um_bu_explain"] = "Esta herramienta puede hacer copia de seguridad de varias clases de datos en PhpGedView.<br /><br />Los datos que elija que se guarden se juntarán en uns archivo ZIP, que podrá descargar haciendo clic en el vínculo en la parte inferior de la página tras completarse la realización de la copia de seguridad.<br /><br />El archivo ZIP permanecerá en su directorio Index hasta que lo elimine manualmente.<br />";
$pgv_lang["um_bu_help"] = "~#pgv_lang[um_backup]#~<br /><br />#pgv_lang[um_bu_explain]#";
$pgv_lang["um_bu_config"] = "Archivo de configuración de PhpGedView";
$pgv_lang["um_bu_gedcoms"] = "Archivos GEDCOM";
$pgv_lang["um_bu_gedsets"] = "Ajustes y archivos de configuración y privacidad de GEDCOM";
$pgv_lang["um_bu_logs"] = "Contadores, diarios de búsquedas de GEDCOM y diarios de operaciones de PhpGedView Logfiles";
$pgv_lang["um_bu_usinfo"] = "Definiciones de usuarios, configuración de bloques, favoritos, mensajes y noticias";
$pgv_lang["um_bu_media"]	= "Archivo audiovisual";
$pgv_lang["um_mk_bu"] = "Hacer copia de seguridad";
$pgv_lang["um_nofiles"] = "No se encontraron archivos para la copia de seguridad";
$pgv_lang["um_files_exist"] = "Uno o más archivos ya existen.  ¿Desea sobreescribirlos?";
$pgv_lang["um_results"]		= "Resultados";
$pgv_lang["preview_faq_item"] = "Previsualizar todas las Preguntas Frecuentes";
$pgv_lang["preview_faq_item_help"] = "~#pgv_lang[preview_faq_item]#~<br />Esta opción permite a un administrador ver la página de Preguntas Frecuentes sin todas las opciones y vínculos de edición.<br /><br /> Salvo por un sólo vínculo <b>Editar</b> encima de la primera entrada de Preguntas Frecuentes, la apariencia de la página de Preguntas Frecuentes será idéntica a lo que un usuario normal vería.  Este vínculo especial <b>Editar</b> devuelva la capacidad de modificación a la página de Preguntas Frecuentes.<br />";
$pgv_lang["restore_faq_edits"] = "Restaurar la funcionalidad de modificar las Preguntas Frecuentes";
$pgv_lang["restore_faq_edits_help"] = "~#pgv_lang[restore_faq_edits]#~<br />Esta opción cambia la vista de la página de Preguntas Frecuentas a la habitual de un administrador, de modo que sea posible introducir modificaciones.<br />";
$pgv_lang["add_faq_item"] = "Agregar Pregunta Frecuente";
$pgv_lang["add_faq_item_help"] = "~#pgv_lang[add_faq_item]#~<br />Esta opción le permite agregar una entrada a la página de Preguntas Frecuentes.<br />";
$pgv_lang["edit_faq_item"] = "Modificar Pregunta Frecuente";
$pgv_lang["edit_faq_item_help"] = "~#pgv_lang[edit_faq_item]#~<br />Esta opción le permite modificar una entrada de la página de Preguntas Frecuentes.<br />";
$pgv_lang["delete_faq_item"] = "Borrar Pregunta Frecuente";
$pgv_lang["delete_faq_item_help"] = "~#pgv_lang[delete_faq_item]#~<br />Esta opción le permite borrar una entrada de la página de Preguntas Frecuentes.<br />";
$pgv_lang["moveup_faq_item"] = "Subir Pregunta Frecuente";
$pgv_lang["moveup_faq_item_help"] = "~#pgv_lang[moveup_faq_item]#~<br />Esta opción le permite mover hacia arriba una entrada en la página de Preguntas Frecuentes.<br /><br />Cada vez que usa esta opción, el número de posición de esta entrada se reduce en una unidad.  Puede obtener el mismo efecto modificando el elemento y cambiando su campo Posición de la Pregunta Frecuente.  Si más de una entrada tiene el mismo número de posición, sólo uno de ellos será visible.<br />";
$pgv_lang["movedown_faq_item"] = "Bajar Pregunta Frecuente";
$pgv_lang["movedown_faq_item_help"] = "~#pgv_lang[movedown_faq_item]#~<br />Esta opción le permite mover hacia abajo una entrada en la página de Preguntas Frecuentes.<br /><br />Cada vez que usa esta opción, el número de posición de esta entrada se incrementa en una unidad.  Puede obtener el mismo efecto modificando el elemento y cambiando su campo Posición de la Pregunta Frecuente.  Si más de una entrada tiene el mismo número de posición, sólo uno de ellos será visible.<br />";
$pgv_lang["add_faq_header_help"] = "~#pgv_lang[add_faq_header]#~<br />Es el titulo o asunto de la Pregunta Frecuente.<br /><br />Lo que introduzca aquí puede tener formato. Se aceptan etiquetas HTML como &lt;b&gt; and &lt;br&gt;, así como entidades HTML como &amp;amp; y &amp;nbsp;.  No hay forma de introducir etiquetas HTML de modo que se interpreten como texto.<br /><br />#pgv_lang[add_faq_pgvLangRefs]#<br />";
$pgv_lang["add_faq_body_help"] = "~#pgv_lang[add_faq_body]#~<br />El texto de la Pregunta Frecuente se introduce aquí.<br /><br />El texto puede tener formato. Se aceptan etiquetas HTML como &lt;b&gt; and &lt;br&gt;, así como entidades HTML como &amp;amp; y &amp;nbsp;.  No hay forma de introducir etiquetas HTML de modo que se interpreten como texto.<br /><br />#pgv_lang[add_faq_pgvLangRefs]#<br />";
$pgv_lang["add_faq_pgvLangRefs"] = "Puede insertar referencias a entradas en los archivos de idioma o a los valores de las variables globales.  Ejemplos: <ul><li><b>&#x23;pgv_lang[add_to_cart]&#x23;</b>&nbsp;&nbsp;&nbsp;es una referencia a la variable de idioma \$pgv_lang[\"add_to_cart\"] y si apareciera en este campo, se mostraría como <b>#pgv_lang[add_to_cart]#</b> al ver la lista de Preguntas Frecuentes en el idioma actual.</li><li><b>&#x23;factarray[AFN]&#x23;</b>&nbsp;&nbsp;&nbsp;es una referencia al nombre de hecho \$factarray[\"AFN\"] y si apareciera en este campo, se mostraría como <b>#factarray[AFN]#</b> cuando la lista de Preguntas Frecuentes se ve en el idioma actual. </li><li><b>&#x23;GLOBALS[VERSION]&#x23;&nbsp;&#x23;GLOBALS[VERSION_RELEASE]&#x23;</b>&nbsp;&nbsp;&nbsp;es una referencia a la variable global \$VERSION, un espacio y una referencia a la variable global \$VERSION_RELEASE y si apareciera en este campo, se mostraría como <b>#GLOBALS[VERSION]#&nbsp;#GLOBALS[VERSION_RELEASE]#</b> al mostrar esta lista de Preguntas Frecuentes en el idioma actual.</li><li><b>&#x23;GLOBALS[GEDCOM]&#x23</b>&nbsp;&nbsp;&nbsp;es una referencia a la variable global \$GEDCOM, que es el nombre del archivo GEDCOM actual.  Si apareciera en este campo, se mostraría como <b>#GLOBALS[GEDCOM]#</b>.</li><li><b>&#x23;GLOBALS[GEDCOM_TITLE]&#x23</b>&nbsp;&nbsp;&nbsp;es una referencia a la variable global \$GEDCOM_TITLE, que es el título del archivo GEDCOM actual.  Si apareciera en este campo, se mostrará como <b>#GLOBALS[GEDCOM_TITLE]#</b>.</li></ul><br />Esta característica es útil si desea crear listas de Preguntas Frecuentes que varían según el idioma.  Debería poner sus títulos personalizados en la lista de Preguntas Frecuentes y las respuestas en los archivos <i>languages/extra.xx.php</i> (<i>xx</i> es el código de cada idioma), utilizando el siguiente formato:<br />\$pgv_lang[\"faq_title1\"] = \"Esto es un título ejemplo de Pregunta Frecuente\";<br />\$pgv_lang[\"faq_body1\"] = \"Esto es un cuerpo ejemplo de Pregunta Frecuente.\";<br />";
$pgv_lang["add_faq_order_help"] = "~#pgv_lang[add_faq_order]#~<br />Este campo controla el orden en que se muestran las Preguntas Frecuentes.<br /><br />No es necesario que introduzca los números secuencialmente.  Si deja huecos en el esquema de numeración, puede insertar otras entradas luego.  Por ejemplo, si utiliza los números 1, 6, 11, 16 puede insertar luego entradas con los números no utilizados.  Se permiten números negativos y cero, que se pueden utilizar para insertar entradas antes de la primera.<br /><br />Si más de una pregunta frecuente tiene el mismo número de posición, sólo una de ellas será visible.<br />";
$pgv_lang["add_faq_visibility_help"] = "~#pgv_lang[add_faq_visibility]#~<br />Puede determinar si esta pregunta frecuente será visible en todos los GEDCOM o si será visible únicamente en el GEDCOM actual.<br /><ul><li><b>#pgv_lang[all]#</b>&nbsp;&nbsp;&nbsp;Esta pregunta aparecerá en todas las listas de preguntas frecuentes, independientemente del GEDCOM.</li><li><b>#GLOBALS[GEDCOM]#</b>&nbsp;&nbsp;&nbsp;La pregunta aparecerá solamente en la lista de preguntas frecuentes del GEDCOM actual.</li></ul><br />";
$pgv_lang["index_gedcom_news_adm_help"]		= "El texto de Novedades GEDCOM permite el uso de <b>etiquetas HTML</b> y de <b>entidades HTML</b>.  No debe usarse HTML en los titulares de las Novedades.<br /><br />Asegúrese de usar siempre tanto las etiquetas de comienzo como las de fin.  Puede ser útil tener un conocimiento de HTML adecuado a un administrador de sitio web. Este programa también utiliza <b>Hojas de Estilo en Cascada (CSS)</b>. Cada tema incluye un CSS distinto.  Puede utilizar las clases de estas hojas de estilo para controlar la apariencia de sus mensajes.<br /><br />Si necesita más ayuda con esto, el sitio web de PhpGedView tiene algunos ejemplos de cómo utilizar estas etiquetas en su bloque de Novedades del GEDCOM.<br /><br />Al igual que con la lista de Preguntas Frecuentes, los títulos y los textos de las Novedades del GEDCOM permiten contener referencias a las variables \$pgv_lang y \$factarray y a las variables \$GLOBALS para proporcionar flexibilidad completa en la creación de Novedades que se adapten al idioma actual.<br /><br />La siguiente descripción, tomada del texto de Ayuda para la lista de Preguntas Frecuentes, se aplica igualmente a las Novedades del GEDCOM.<br /><br />#pgv_lang[add_faq_pgvLangRefs]#<br /><br />";
$pgv_lang["time_limit_help"]			= "~#pgv_lang[time_limit]#~<br /><br />El tiempo máximo que se permite ejecutar la importación durante el proceso del archivo GEDCOM.";

// Media items
$pgv_lang["media_import_help"] = "~#pgv_lang[media_import]#~<br />Esta importación convertirá los vínculos a objetos audiovisuales de su archivo GEDCOM a registros de objetos audiovisuales. Por ejemplo, la siguiente entrada de objeto se convertirá de <blockquote><code>1 OBJE<br />2 FORM jpg<br />2 FILE media/grandma.jpg<br />2 TITL Foto de la abuela</code></blockquote>a:<blockquote><code>0 @M1@ OBJE<br />1 FORM jpg<br />1 FILE media/grandma.jpg<br />1 TITL Foto de la abuela</code></blockquote>El nuevo registro de objeto audiovisual se almacenará separadamente en la base de datos. Los vínculos a archivos audiovisuales externos se cambiarán al nuevo registro de objeto audiovisual que, a su vez, contendrá una referencia al archivo externo. Por ejemplo, el siguiente registro GEDCOM se cambiará de:<blockquote><code>0 @I1@ INDI<br />1 NAME Su/Nombre/<br />1 OBJE<br />2 FORM jpg<br />2 FILE media/grandma.jpg<br />2 TITL Foto de la abuela</code></blockquote>a:<blockquote><code>0 @I1@ INDI<br />1 NAME Su/Nombre/<br />1 OBJE @M1@<br /></code></blockquote>La ventaja de utilizar registros de objetos audiovisuales es que se pueden gestionar los archivos audiovisuales con facilidad. Si cambia el título de un archivo audiovisual, queda cambiado en todos los registros GEDCOM que vinculan con este registro audiovisual. Varias personas, familias o fuentes pueden vincularse al mismo registro audiovisual.";

?>
