--TEST--
maxdb bind_param/bind_result short values
--SKIPIF--
<?php require 'skipif.inc'; ?>
--FILE--
<?php
	include "connect.inc";
	
	/*** test maxdb_connect 127.0.0.1 ***/
	$link = maxdb_connect("localhost", $user, $passwd);

	maxdb_select_db($link, $db);

        maxdb_report (MAXDB_REPORT_OFF);
  	maxdb_query($link,"DROP TABLE test_bind_fetch");
        maxdb_report (MAXDB_REPORT_ERROR);

  	maxdb_query($link,"CREATE TABLE test_bind_fetch(c1 smallint,
                                                     c2 smallint,
                                                     c3 smallint,
                                                     c4 smallint,
                                                     c5 smallint,
                                                     c6 smallint,
                                                     c7 smallint)");

	$stmt = maxdb_prepare($link, "INSERT INTO test_bind_fetch VALUES (?,?,?,?,?,?,?)");
	maxdb_bind_param($stmt, "iiiiiii", $c1,$c2,$c3,$c4,$c5,$c6,$c7);

	$c1 = -23;
	$c2 = 3599;
	$c3 = NULL;
	$c4 = -500;
	$c5 = -9999;
	$c6 = -0;
	$c7 = 0;

	maxdb_execute($stmt);
	maxdb_stmt_close($stmt);

	$stmt = maxdb_prepare($link, "SELECT * FROM test_bind_fetch");
	maxdb_bind_result($stmt, $c1, $c2, $c3, $c4, $c5, $c6, $c7);
	maxdb_execute($stmt);
	maxdb_fetch($stmt);

	$test = array($c1,$c2,$c3,$c4,$c5,$c6,$c7);

	var_dump($test);

	maxdb_stmt_close($stmt);
	maxdb_close($link);
?>
--EXPECT--
array(7) {
  [0]=>
  int(-23)
  [1]=>
  int(3599)
  [2]=>
  NULL
  [3]=>
  int(-500)
  [4]=>
  int(-9999)
  [5]=>
  int(0)
  [6]=>
  int(0)
}
