<?php
/*  
 *  COPYRIGHT
 *  ---------
 *
 *  See ../AUTHORS file
 *
 *
 *  LICENSE
 *  -------
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  $Revision: 1.7 $
 *
 *  ABOUT
 *  -----
 *
 *  Provides functions for locale support.
 *
 */

/**
 * This function returns the languages supported by the Kolab web
 * admin.  If you add a translation, add the new language here
 *
 * $Header: /home/kroupware/jail/kolabrepository/server/php-kolab/Kolab_Webadmin/Webadmin/locale.php,v 1.7 2007/09/18 06:08:48 gunnar Exp $
 *
 * @author  Steffen Hansen   <steffen@klaralvdalens-datakonsult.se>
 * @author  Romain Pokrzywka <romain@kdab.net>
 * @author  Gunnar Wrobel    <wrobel@pardus.de>
 * @package Kolab_Webadmin
 */
function offered_languages() 
{
    return array( 
        array( 
            'name' => 'Deutsch',
            'code' => 'de_DE' ),
        array( 
            'name' => 'English',
            'code' => 'en_US' ),
        array( 
            'name' => 'Français',
            'code' => 'fr_FR' ),
        array( 
            'name' => 'Italiano',
            'code' => 'it_IT' ),
        array( 
            'name' => 'Nederlands',
            'code' => 'nl_NL' ),
        array( 
            'name' => 'Español',
            'code' => 'es_ES' ),
    );

}

/**
 * This function converts a language identifier into the Kolab web
 * admin language id.  If you add a translation, add the new language
 * here
 *
 * $Header: /home/kroupware/jail/kolabrepository/server/php-kolab/Kolab_Webadmin/Webadmin/locale.php,v 1.7 2007/09/18 06:08:48 gunnar Exp $
 *
 * @author  Steffen Hansen   <steffen@klaralvdalens-datakonsult.se>
 * @author  Romain Pokrzywka <romain@kdab.net>
 * @package Kolab_Webadmin
 */
function supported_lang($lang) 
{
    // REMEMBER TO UPDATE THIS WHEN ADDING NEW LANGUAGES
    $a = array("de"    => "de_DE",
               "de_de" => "de_DE",
               "fr"    => "fr_FR",
               "fr_fr" => "fr_FR",
               "it"    => "it_IT",
               "it_it" => "it_IT",
               "nl"    => "nl_NL",
               "nl_nl" => "nl_NL",
               "en"    => "en_US",
               "en_gb" => "en_US",
               "en_us" => "en_US",
               "es"    => "es_ES",
               "es_es" => "es_ES");

    // Locales must be in the format xx_YY to be recognized by xgettext
    $lang = strtolower(str_replace('-', '_', $lang));
    if( !array_key_exists( $lang, $a ) ) {
        return false;
    } else {
        return $a[$lang];
    }
}

/**
 * Translates a string into the current language
 *
 * $Header: /home/kroupware/jail/kolabrepository/server/php-kolab/Kolab_Webadmin/Webadmin/locale.php,v 1.7 2007/09/18 06:08:48 gunnar Exp $
 *
 * @author  Steffen Hansen   <steffen@klaralvdalens-datakonsult.se>
 * @author  Romain Pokrzywka <romain@kdab.net>
 * @package Kolab_Webadmin
 */
function translate($params) 
{
    $msg = $params["msg"];
    $domain = $params["domain"];
    if(empty($domain)) {
        return gettext($msg);
    } else {
        return dgettext($domain, $msg);
    }
}

/**
 * Returns the currently selected language.
 *
 * $Header: /home/kroupware/jail/kolabrepository/server/php-kolab/Kolab_Webadmin/Webadmin/locale.php,v 1.7 2007/09/18 06:08:48 gunnar Exp $
 *
 * @author  Steffen Hansen   <steffen@klaralvdalens-datakonsult.se>
 * @author  Romain Pokrzywka <romain@kdab.net>
 * @package Kolab_Webadmin
 */
function getLanguage()
{
    if(empty($_SESSION["lang"])) {
        $acceptList = $_SERVER["HTTP_ACCEPT_LANGUAGE"];
        if(empty($acceptList)) {
            $lang = "en";
        } else {
            // In case of multiple accept languages, keep the first one
            $acceptList = explode(",", $acceptList);
            foreach($acceptList as $l) {
                $pos = strpos($l, ';' );
                if( $pos !== false ) {
                    $l = explode(';',$l);
                    $l = $l[0];
                }
                if( $tmp = supported_lang($l) ) {
                    $lang = $tmp;
                    break;
                }
            }
        }
        if( !$lang ) {
            $lang = "en";
        }
        setLanguage($lang);
    }    
    return supported_lang($_SESSION["lang"]);
}

/**
 * Set the current language.
 *
 * $Header: /home/kroupware/jail/kolabrepository/server/php-kolab/Kolab_Webadmin/Webadmin/locale.php,v 1.7 2007/09/18 06:08:48 gunnar Exp $
 *
 * @author  Steffen Hansen   <steffen@klaralvdalens-datakonsult.se>
 * @author  Romain Pokrzywka <romain@kdab.net>
 * @package Kolab_Webadmin
 */
function setLanguage($lang)
{   
    $lang = supported_lang($lang);
    $_SESSION["lang"] = $lang;
}

/*
  Local variables:
  mode: php
  indent-tabs-mode: f
  tab-width: 4
  buffer-file-coding-system: utf-8
  End:
  vim:encoding=utf-8:
 */
?>
