<?php
/*  
 *  COPYRIGHT
 *  ---------
 *
 *  See ../AUTHORS file
 *
 *
 *  LICENSE
 *  -------
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  $Revision: 1.5 $
 *
 *  ABOUT
 *  -----
 *
 *  A class for Kolab address management.
 *
 */

/** The basic Kolab object definition */
require_once('Kolab/Webadmin/object.php');

/**
 * This class provides methods to deal with global address book
 * entries for Kolab.
 *
 * $Header: /home/kroupware/jail/kolabrepository/server/php-kolab/Kolab_Webadmin/Webadmin/address.class.php,v 1.5 2007/09/18 06:08:48 gunnar Exp $
 *
 * @author  Steffen Hansen <steffen@klaralvdalens-datakonsult.se>
 * @author  Gunnar Wrobel  <wrobel@pardus.de>
 * @package Kolab_Webadmin
 */
class KolabAddress extends KolabObject {

    /**
     * The LDAP filter to retrieve this object type
     *
     * @var string
     */
    var $filter = '(&(objectclass=inetOrgPerson)(!(uid=*))(sn=*))';

    /**
     * Sort using this attribute by default
     *
     * @var string
     */
    var $sort = KOLAB_ATTR_SN;

    /**
     * The LDAP attributes fetched for listing
     *
     * @var array
     */
    var $list_attributes = array(
        KOLAB_ATTR_SN,
        KOLAB_ATTR_CN,
        KOLAB_ATTR_MAIL,
        KOLAB_ATTR_DELETED,
    );

    /**
     * The attributes supported by this class
     *
     * @var array
     */
    var $_supported_attributes = array(
        KOLAB_ATTR_SN,
        KOLAB_ATTR_FN,
        KOLAB_ATTR_MAIL,
        KOLAB_ATTR_DELETED,
    );

};

class KolabAddressListView extends KolabObjectListView {

    /**
     * Return a list title for this type of object
     *
     * @return 
     */
    function getTitle()
    {
        return _("Global addressbook");
    }

    /**
     * Return a list note for this type of object
     *
     * @return 
     */
    function getNote()
    {
        return _("only external addresses without a kolab user account");
    }


    /**
     * Return an array of table header entries for this type of object
     *
     * @return array The header entries
     */
    function _getHeader()
    {
        return array(_("Name"));
    }
    
    /**
     * Return an array of table row entries for this type of object
     *
     * @return array The row entries
     */
    function _getRow()
    {
        return array($this->_object->getName());
    }
}
/*
  Local variables:
  mode: php
  indent-tabs-mode: f
  tab-width: 4
  buffer-file-coding-system: utf-8
  End:
  vim:encoding=utf-8:
 */
?>
