#include "petsc.h"
#include "petscfix.h"
/* itfunc.c */
/* Fortran interface file */

/*
* This file was generated automatically by bfort from the C source
* file.  
 */

#ifdef PETSC_USE_POINTER_CONVERSION
#if defined(__cplusplus)
extern "C" { 
#endif 
extern void *PetscToPointer(void*);
extern int PetscFromPointer(void *);
extern void PetscRmPointer(void*);
#if defined(__cplusplus)
} 
#endif 

#else

#define PetscToPointer(a) (*(long *)(a))
#define PetscFromPointer(a) (long)(a)
#define PetscRmPointer(a)
#endif

#include "petscksp.h"
#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define kspcomputeextremesingularvalues_ PKSPCOMPUTEEXTREMESINGULARVALUES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define kspcomputeextremesingularvalues_ pkspcomputeextremesingularvalues
#else
#define kspcomputeextremesingularvalues_ pkspcomputeextremesingularvalues_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define kspcomputeextremesingularvalues_ KSPCOMPUTEEXTREMESINGULARVALUES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define kspcomputeextremesingularvalues_ kspcomputeextremesingularvalues
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define kspcomputeeigenvalues_ PKSPCOMPUTEEIGENVALUES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define kspcomputeeigenvalues_ pkspcomputeeigenvalues
#else
#define kspcomputeeigenvalues_ pkspcomputeeigenvalues_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define kspcomputeeigenvalues_ KSPCOMPUTEEIGENVALUES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define kspcomputeeigenvalues_ kspcomputeeigenvalues
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define kspsetuponblocks_ PKSPSETUPONBLOCKS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define kspsetuponblocks_ pkspsetuponblocks
#else
#define kspsetuponblocks_ pkspsetuponblocks_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define kspsetuponblocks_ KSPSETUPONBLOCKS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define kspsetuponblocks_ kspsetuponblocks
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define kspsetup_ PKSPSETUP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define kspsetup_ pkspsetup
#else
#define kspsetup_ pkspsetup_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define kspsetup_ KSPSETUP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define kspsetup_ kspsetup
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define kspsolve_ PKSPSOLVE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define kspsolve_ pkspsolve
#else
#define kspsolve_ pkspsolve_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define kspsolve_ KSPSOLVE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define kspsolve_ kspsolve
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define kspsolvetranspose_ PKSPSOLVETRANSPOSE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define kspsolvetranspose_ pkspsolvetranspose
#else
#define kspsolvetranspose_ pkspsolvetranspose_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define kspsolvetranspose_ KSPSOLVETRANSPOSE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define kspsolvetranspose_ kspsolvetranspose
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define kspsetpreconditionerside_ PKSPSETPRECONDITIONERSIDE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define kspsetpreconditionerside_ pkspsetpreconditionerside
#else
#define kspsetpreconditionerside_ pkspsetpreconditionerside_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define kspsetpreconditionerside_ KSPSETPRECONDITIONERSIDE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define kspsetpreconditionerside_ kspsetpreconditionerside
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define kspgettolerances_ PKSPGETTOLERANCES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define kspgettolerances_ pkspgettolerances
#else
#define kspgettolerances_ pkspgettolerances_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define kspgettolerances_ KSPGETTOLERANCES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define kspgettolerances_ kspgettolerances
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define kspsettolerances_ PKSPSETTOLERANCES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define kspsettolerances_ pkspsettolerances
#else
#define kspsettolerances_ pkspsettolerances_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define kspsettolerances_ KSPSETTOLERANCES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define kspsettolerances_ kspsettolerances
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define kspsetinitialguessnonzero_ PKSPSETINITIALGUESSNONZERO
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define kspsetinitialguessnonzero_ pkspsetinitialguessnonzero
#else
#define kspsetinitialguessnonzero_ pkspsetinitialguessnonzero_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define kspsetinitialguessnonzero_ KSPSETINITIALGUESSNONZERO
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define kspsetinitialguessnonzero_ kspsetinitialguessnonzero
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define kspgetinitialguessnonzero_ PKSPGETINITIALGUESSNONZERO
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define kspgetinitialguessnonzero_ pkspgetinitialguessnonzero
#else
#define kspgetinitialguessnonzero_ pkspgetinitialguessnonzero_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define kspgetinitialguessnonzero_ KSPGETINITIALGUESSNONZERO
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define kspgetinitialguessnonzero_ kspgetinitialguessnonzero
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define kspsetinitialguessknoll_ PKSPSETINITIALGUESSKNOLL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define kspsetinitialguessknoll_ pkspsetinitialguessknoll
#else
#define kspsetinitialguessknoll_ pkspsetinitialguessknoll_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define kspsetinitialguessknoll_ KSPSETINITIALGUESSKNOLL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define kspsetinitialguessknoll_ kspsetinitialguessknoll
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define kspgetinitialguessknoll_ PKSPGETINITIALGUESSKNOLL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define kspgetinitialguessknoll_ pkspgetinitialguessknoll
#else
#define kspgetinitialguessknoll_ pkspgetinitialguessknoll_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define kspgetinitialguessknoll_ KSPGETINITIALGUESSKNOLL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define kspgetinitialguessknoll_ kspgetinitialguessknoll
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define kspgetcomputesingularvalues_ PKSPGETCOMPUTESINGULARVALUES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define kspgetcomputesingularvalues_ pkspgetcomputesingularvalues
#else
#define kspgetcomputesingularvalues_ pkspgetcomputesingularvalues_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define kspgetcomputesingularvalues_ KSPGETCOMPUTESINGULARVALUES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define kspgetcomputesingularvalues_ kspgetcomputesingularvalues
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define kspsetcomputesingularvalues_ PKSPSETCOMPUTESINGULARVALUES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define kspsetcomputesingularvalues_ pkspsetcomputesingularvalues
#else
#define kspsetcomputesingularvalues_ pkspsetcomputesingularvalues_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define kspsetcomputesingularvalues_ KSPSETCOMPUTESINGULARVALUES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define kspsetcomputesingularvalues_ kspsetcomputesingularvalues
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define kspgetcomputeeigenvalues_ PKSPGETCOMPUTEEIGENVALUES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define kspgetcomputeeigenvalues_ pkspgetcomputeeigenvalues
#else
#define kspgetcomputeeigenvalues_ pkspgetcomputeeigenvalues_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define kspgetcomputeeigenvalues_ KSPGETCOMPUTEEIGENVALUES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define kspgetcomputeeigenvalues_ kspgetcomputeeigenvalues
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define kspsetcomputeeigenvalues_ PKSPSETCOMPUTEEIGENVALUES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define kspsetcomputeeigenvalues_ pkspsetcomputeeigenvalues
#else
#define kspsetcomputeeigenvalues_ pkspsetcomputeeigenvalues_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define kspsetcomputeeigenvalues_ KSPSETCOMPUTEEIGENVALUES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define kspsetcomputeeigenvalues_ kspsetcomputeeigenvalues
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define kspsetpc_ PKSPSETPC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define kspsetpc_ pkspsetpc
#else
#define kspsetpc_ pkspsetpc_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define kspsetpc_ KSPSETPC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define kspsetpc_ kspsetpc
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define kspclearmonitor_ PKSPCLEARMONITOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define kspclearmonitor_ pkspclearmonitor
#else
#define kspclearmonitor_ pkspclearmonitor_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define kspclearmonitor_ KSPCLEARMONITOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define kspclearmonitor_ kspclearmonitor
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define kspsetresidualhistory_ PKSPSETRESIDUALHISTORY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define kspsetresidualhistory_ pkspsetresidualhistory
#else
#define kspsetresidualhistory_ pkspsetresidualhistory_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define kspsetresidualhistory_ KSPSETRESIDUALHISTORY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define kspsetresidualhistory_ kspsetresidualhistory
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define kspsetdiagonalscale_ PKSPSETDIAGONALSCALE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define kspsetdiagonalscale_ pkspsetdiagonalscale
#else
#define kspsetdiagonalscale_ pkspsetdiagonalscale_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define kspsetdiagonalscale_ KSPSETDIAGONALSCALE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define kspsetdiagonalscale_ kspsetdiagonalscale
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define kspsetdiagonalscalefix_ PKSPSETDIAGONALSCALEFIX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define kspsetdiagonalscalefix_ pkspsetdiagonalscalefix
#else
#define kspsetdiagonalscalefix_ pkspsetdiagonalscalefix_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define kspsetdiagonalscalefix_ KSPSETDIAGONALSCALEFIX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define kspsetdiagonalscalefix_ kspsetdiagonalscalefix
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define kspgetdiagonalscalefix_ PKSPGETDIAGONALSCALEFIX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define kspgetdiagonalscalefix_ pkspgetdiagonalscalefix
#else
#define kspgetdiagonalscalefix_ pkspgetdiagonalscalefix_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define kspgetdiagonalscalefix_ KSPGETDIAGONALSCALEFIX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define kspgetdiagonalscalefix_ kspgetdiagonalscalefix
#endif
#endif



/* Definitions of Fortran Wrapper routines */
#if defined(__cplusplus)
extern "C" {
#endif
void PETSC_STDCALL   kspcomputeextremesingularvalues_(KSP ksp,PetscReal *emax,PetscReal *emin, int *__ierr ){
*__ierr = KSPComputeExtremeSingularValues(
	(KSP)PetscToPointer((ksp) ),emax,emin);
}
void PETSC_STDCALL   kspcomputeeigenvalues_(KSP ksp,PetscInt *n,PetscReal *r,PetscReal *c,PetscInt *neig, int *__ierr ){
*__ierr = KSPComputeEigenvalues(
	(KSP)PetscToPointer((ksp) ),*n,r,c,neig);
}
void PETSC_STDCALL   kspsetuponblocks_(KSP ksp, int *__ierr ){
*__ierr = KSPSetUpOnBlocks(
	(KSP)PetscToPointer((ksp) ));
}
void PETSC_STDCALL   kspsetup_(KSP ksp, int *__ierr ){
*__ierr = KSPSetUp(
	(KSP)PetscToPointer((ksp) ));
}
void PETSC_STDCALL   kspsolve_(KSP ksp,Vec b,Vec x, int *__ierr ){
*__ierr = KSPSolve(
	(KSP)PetscToPointer((ksp) ),
	(Vec)PetscToPointer((b) ),
	(Vec)PetscToPointer((x) ));
}
void PETSC_STDCALL   kspsolvetranspose_(KSP ksp,Vec b,Vec x, int *__ierr ){
*__ierr = KSPSolveTranspose(
	(KSP)PetscToPointer((ksp) ),
	(Vec)PetscToPointer((b) ),
	(Vec)PetscToPointer((x) ));
}
void PETSC_STDCALL   kspsetpreconditionerside_(KSP ksp,PCSide *side, int *__ierr ){
*__ierr = KSPSetPreconditionerSide(
	(KSP)PetscToPointer((ksp) ),*side);
}
void PETSC_STDCALL   kspgettolerances_(KSP ksp,PetscReal *rtol,PetscReal *abstol,PetscReal *dtol,PetscInt *maxits, int *__ierr ){
*__ierr = KSPGetTolerances(
	(KSP)PetscToPointer((ksp) ),rtol,abstol,dtol,maxits);
}
void PETSC_STDCALL   kspsettolerances_(KSP ksp,PetscReal *rtol,PetscReal *abstol,PetscReal *dtol,PetscInt *maxits, int *__ierr ){
*__ierr = KSPSetTolerances(
	(KSP)PetscToPointer((ksp) ),*rtol,*abstol,*dtol,*maxits);
}
void PETSC_STDCALL   kspsetinitialguessnonzero_(KSP ksp,PetscTruth *flg, int *__ierr ){
*__ierr = KSPSetInitialGuessNonzero(
	(KSP)PetscToPointer((ksp) ),*flg);
}
void PETSC_STDCALL   kspgetinitialguessnonzero_(KSP ksp,PetscTruth *flag, int *__ierr ){
*__ierr = KSPGetInitialGuessNonzero(
	(KSP)PetscToPointer((ksp) ),flag);
}
void PETSC_STDCALL   kspsetinitialguessknoll_(KSP ksp,PetscTruth *flg, int *__ierr ){
*__ierr = KSPSetInitialGuessKnoll(
	(KSP)PetscToPointer((ksp) ),*flg);
}
void PETSC_STDCALL   kspgetinitialguessknoll_(KSP ksp,PetscTruth *flag, int *__ierr ){
*__ierr = KSPGetInitialGuessKnoll(
	(KSP)PetscToPointer((ksp) ),flag);
}
void PETSC_STDCALL   kspgetcomputesingularvalues_(KSP ksp,PetscTruth *flg, int *__ierr ){
*__ierr = KSPGetComputeSingularValues(
	(KSP)PetscToPointer((ksp) ),flg);
}
void PETSC_STDCALL   kspsetcomputesingularvalues_(KSP ksp,PetscTruth *flg, int *__ierr ){
*__ierr = KSPSetComputeSingularValues(
	(KSP)PetscToPointer((ksp) ),*flg);
}
void PETSC_STDCALL   kspgetcomputeeigenvalues_(KSP ksp,PetscTruth *flg, int *__ierr ){
*__ierr = KSPGetComputeEigenvalues(
	(KSP)PetscToPointer((ksp) ),flg);
}
void PETSC_STDCALL   kspsetcomputeeigenvalues_(KSP ksp,PetscTruth *flg, int *__ierr ){
*__ierr = KSPSetComputeEigenvalues(
	(KSP)PetscToPointer((ksp) ),*flg);
}
void PETSC_STDCALL   kspsetpc_(KSP ksp,PC pc, int *__ierr ){
*__ierr = KSPSetPC(
	(KSP)PetscToPointer((ksp) ),
	(PC)PetscToPointer((pc) ));
}
void PETSC_STDCALL   kspclearmonitor_(KSP ksp, int *__ierr ){
*__ierr = KSPClearMonitor(
	(KSP)PetscToPointer((ksp) ));
}
void PETSC_STDCALL   kspsetresidualhistory_(KSP ksp,PetscReal a[],PetscInt *na,PetscTruth *reset, int *__ierr ){
*__ierr = KSPSetResidualHistory(
	(KSP)PetscToPointer((ksp) ),a,*na,*reset);
}
void PETSC_STDCALL   kspsetdiagonalscale_(KSP ksp,PetscTruth *scale, int *__ierr ){
*__ierr = KSPSetDiagonalScale(
	(KSP)PetscToPointer((ksp) ),*scale);
}
void PETSC_STDCALL   kspsetdiagonalscalefix_(KSP ksp,PetscTruth *fix, int *__ierr ){
*__ierr = KSPSetDiagonalScaleFix(
	(KSP)PetscToPointer((ksp) ),*fix);
}
void PETSC_STDCALL   kspgetdiagonalscalefix_(KSP ksp,PetscTruth *fix, int *__ierr ){
*__ierr = KSPGetDiagonalScaleFix(
	(KSP)PetscToPointer((ksp) ),fix);
}
#if defined(__cplusplus)
}
#endif
