/******************************************************
 *
 * zexy - implementation file
 *
 * copyleft (c) IOhannes m zmlnig
 *
 *   1999:forum::fr::umlute:2004
 *
 *   institute of electronic music and acoustics (iem)
 *
 ******************************************************
 *
 * license: GNU General Public License v.2
 *
 ******************************************************/

/*
  1110:forum::fr::umlute:1999
*/

#include "zexy.h"

/* ------------------------ blockmirror~ ----------------------------- */

/* mirrors a signalblock around it's center:
   {x[0], x[1], ... x[n-1]} --> {x[n-1], x[n-2], ... x[0]}
*/

static t_class *blockmirror_class;

typedef struct _blockmirror
{
  t_object x_obj;
  int doit;
  int blocksize;
  t_float *blockbuffer;
} t_blockmirror;

static void blockmirror_float(t_blockmirror *x, t_floatarg f)
{
  x->doit = (f != 0);
}

static t_int *blockmirror_perform(t_int *w)
{
  t_blockmirror	*x = (t_blockmirror *)(w[1]);
  t_float *in = (t_float *)(w[2]);
  t_float *out = (t_float *)(w[3]);
  int n = (int)(w[4]);
  if (x->doit) {
    if (in==out){
      int N=n;
      t_float *dummy=x->blockbuffer;
      while(n--)*dummy++=*in++;
      dummy--;
      while(N--)*out++=*dummy--;
    } else {
      in+=n-1;
      while(n--)*out++=*in--;
    }
  } else while (n--) *out++ = *in++;
  return (w+5);
}

static void blockmirror_dsp(t_blockmirror *x, t_signal **sp)
{
  if (x->blocksize<sp[0]->s_n){
    if(x->blockbuffer)freebytes(x->blockbuffer, sizeof(t_float)*x->blocksize);
    x->blocksize = sp[0]->s_n;
    x->blockbuffer = getbytes(sizeof(t_float)*x->blocksize);
  }
  dsp_add(blockmirror_perform, 4, x, sp[0]->s_vec, sp[1]->s_vec, sp[0]->s_n);
}

static void blockmirror_helper(void)
{
  post("\n%c blockmirror~-object for reverting a signal", HEARTSYMBOL);
  post("'help' : view this\n"
       "signal~");
  post("outlet : signal~");
}

static void *blockmirror_new(void)
{
  t_blockmirror *x = (t_blockmirror *)pd_new(blockmirror_class);
  outlet_new(&x->x_obj, gensym("signal"));
  x->doit = 1;
  x->blocksize=0;
  return (x);
}

void blockmirror_tilde_setup(void)
{
  blockmirror_class = class_new(gensym("blockmirror~"), (t_newmethod)blockmirror_new, 0,
			 sizeof(t_blockmirror), 0, A_NULL);
  class_addmethod(blockmirror_class, nullfn, gensym("signal"), 0);
  class_addmethod(blockmirror_class, (t_method)blockmirror_dsp, gensym("dsp"), 0);
  
  class_addfloat(blockmirror_class, blockmirror_float);
  
  class_addmethod(blockmirror_class, (t_method)blockmirror_helper, gensym("help"), 0);
  class_sethelpsymbol(blockmirror_class, gensym("zexy/blockmirror~"));
  zexy_register("blockmirror~");
}

void z_blockmirror__setup(void)
{
  blockmirror_tilde_setup();
}
