#!/bin/sh
kvers=$(cd kernel-image && dh_listpackages | grep ^kernel-headers \
    | head -1 | sed 's/^kernel-headers-\(.*\)$/\1/')
kvers_base=$(echo $kvers | sed 's/-[^-]*$//')
ktvers=$(sed -n 's/.*kernel-tree-\([^,]*\).*/\1/p; t e; b; :e q' \
    kernel-image/debian/control)
flavours=$(find kernel-image/config -maxdepth 1 -type f ! -name default \
    -printf '%f\n')

sed \
    -e 's/\${kvers}/'$kvers'/g' \
    -e 's/\${kvers_base}/'$kvers_base'/' \
    -e 's/\${ktvers}/'$ktvers'/g' \
    debian/control.in.source >debian/control

for flavour in $flavours; do
    sed \
	-e 's/\${kvers}/'$kvers'/g' \
	-e 's/\${flavour}/'$flavour'/g' \
	debian/control.in.modules >>debian/control
done
