/*
**  Constants.h
**
**  Copyright (c) 2001, 2002, 2003
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**  
**  This library is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
**  Lesser General Public License for more details.
**  
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

#ifndef _Pantomime_H_Constants
#define _Pantomime_H_Constants

#ifdef MACOSX 
#define RETAIN(object)          [object retain]
#define RELEASE(object)         [object release]
#define AUTORELEASE(object)     [object autorelease]
#define TEST_RELEASE(object)    ({ if (object) [object release]; })
#define ASSIGN(object,value)    ({\
id __value = (id)(value); \
id __object = (id)(object); \
if (__value != __object) \
  { \
    if (__value != nil) \
      { \
        [__value retain]; \
      } \
    object = __value; \
    if (__object != nil) \
      { \
        [__object release]; \
      } \
  } \
})
#define DESTROY(object) ({ \
  if (object) \
    { \
      id __o = object; \
      object = nil; \
      [__o release]; \
    } \
})

#define NSLocalizedString(key, comment) \
  [[NSBundle mainBundle] localizedStringForKey:(key) value:@"" table:nil]

#define _(X) NSLocalizedString (X, @"")

#endif

#define PANTOMIME_VERSION @"1.1.2"

#ifdef MACOSX
#include <Pantomime/MacOSXGlue.h>
#endif

#define CRLF "\r\n"
#define LF "\n"

#define NONE            0
#define QUOTEDPRINTABLE 1
#define BASE64          2
#define EIGHTBIT        3
#define BINARY          4

#define FORMAT_UNKNOWN 0
#define FORMAT_FLOWED  1

//
// Flags/Name attributes for mailboxes/folders
//
enum
{
  PantomimeHoldsFolders = 1,
  PantomimeHoldsMessages = 2,
  PantomimeNoInferiors = 4,
  PantomimeNoSelect = 8,
  PantomimeMarked = 16,
  PantomimeUnmarked = 32
};


//
// Mask for Folder: -search: mask: options:
//
enum
{
  PantomimeFrom = 1,
  PantomimeTo = 2,
  PantomimeSubject = 4,
  PantomimeContent = 8
};


//
// Options for Folder: -search: mask: options:
//
enum
{
  PantomimeCaseInsensitiveSearch = 1,
  PantomimeRegularExpression = 2
};


//
// Modes for folder
//
enum
{
  PantomimeUnknownMode = 1,
  PantomimeReadOnlyMode = 2,
  PantomimeReadWriteMode = 3
};

//
// Exceptions
//
#define PantomimeReadTimeoutException    @"PantomimeReadTimeoutException"
#define PantomimeStopException           @"PantomimeStopException"
#define PantomimeWriteTimeoutException   @"PantomimeWriteTimeoutException"


#endif // _Pantomime_H_Constants
