# 1 "src/Text/Pandoc/Data.hsb"
{-# LANGUAGE OverloadedStrings #-}
-- to be processed using hsb2hs
module Text.Pandoc.Data (dataFiles) where
import qualified Data.ByteString as B

dataFiles :: [(FilePath, B.ByteString)]
dataFiles = [("default.csl","<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<style xmlns=\"http://purl.org/net/xbiblio/csl\" class=\"in-text\" version=\"1.0\" demote-non-dropping-particle=\"sort-only\">\n   <info>\n      <title>Chicago Manual of Style (Author-Date format)</title>\n      <id>http://www.zotero.org/styles/chicago-author-date</id>\n      <link href=\"http://www.zotero.org/styles/chicago-author-date\" rel=\"self\"/>\n      <author>\n         <name>Julian Onions</name>\n         <email>julian.onions@gmail.com</email>\n      </author>\n      <contributor>\n         <name>Sebastian Karcher</name>\n      </contributor>\n      <category citation-format=\"author-date\"/>\n      <category field=\"generic-base\"/>\n      <updated>2011-11-17T22:01:05+00:00</updated>\n      <summary>The author-date variant of the Chicago style</summary>\n      <link href=\"http://www.chicagomanualofstyle.org/tools_citationguide.html\" rel=\"documentation\"/>\n      <rights>This work is licensed under a Creative Commons Attribution-Share Alike 3.0 License: http://creativecommons.org/licenses/by-sa/3.0/</rights>\n   </info>\n   <macro name=\"secondary-contributors\">\n      <choose>\n         <if type=\"chapter paper-conference\" match=\"none\">\n            <group delimiter=\". \">\n               <choose>\n                  <if variable=\"author\">\n                     <names variable=\"editor\">\n                        <label form=\"verb-short\" text-case=\"capitalize-first\" suffix=\". \" strip-periods=\"true\"/>\n                        <name and=\"text\" delimiter=\", \"/>\n                     </names>\n                  </if>\n               </choose>\n               <choose>\n                  <if variable=\"author editor\" match=\"any\">\n                     <names variable=\"translator\">\n                        <label form=\"verb-short\" text-case=\"capitalize-first\" suffix=\". \" strip-periods=\"true\"/>\n                        <name and=\"text\" delimiter=\", \"/>\n                     </names>\n                  </if>\n               </choose>\n            </group>\n         </if>\n      </choose>\n   </macro>\n   <macro name=\"container-contributors\">\n      <choose>\n         <if type=\"chapter paper-conference\" match=\"any\">\n            <group prefix=\",\" delimiter=\", \">\n               <choose>\n                  <if variable=\"author\">\n                     <names variable=\"editor\">\n                        <label form=\"verb-short\" prefix=\" \" text-case=\"lowercase\" suffix=\". \" strip-periods=\"true\"/>\n                        <name and=\"text\" delimiter=\", \"/>\n                     </names>\n                     <choose>\n                        <if variable=\"container-author\">\n                           <group>\n                              <names variable=\"container-author\">\n                                 <label form=\"verb-short\" prefix=\" \" text-case=\"lowercase\" suffix=\" \" strip-periods=\"true\"/>\n                                 <name and=\"text\" delimiter=\", \"/>\n                              </names>\n                           </group>\n                        </if>\n                     </choose>\n                  </if>\n               </choose>\n               <choose>\n                  <if variable=\"author editor\" match=\"any\">\n                     <names variable=\"translator\">\n                        <label form=\"verb-short\" prefix=\" \" text-case=\"lowercase\" suffix=\". \" strip-periods=\"true\"/>\n                        <name and=\"text\" delimiter=\", \"/>\n                     </names>\n                  </if>\n               </choose>\n            </group>\n         </if>\n      </choose>\n   </macro>\n   <macro name=\"anon\">\n      <text term=\"anonymous\" form=\"short\" text-case=\"capitalize-first\" suffix=\".\" strip-periods=\"true\"/>\n   </macro>\n   <macro name=\"editor\">\n      <names variable=\"editor\">\n         <name name-as-sort-order=\"first\" and=\"text\" sort-separator=\", \" delimiter=\", \" delimiter-precedes-last=\"always\"/>\n         <label form=\"short\" prefix=\", \" suffix=\".\" strip-periods=\"true\"/>\n      </names>\n   </macro>\n   <macro name=\"translator\">\n      <names variable=\"translator\">\n         <name name-as-sort-order=\"first\" and=\"text\" sort-separator=\", \" delimiter=\", \" delimiter-precedes-last=\"always\"/>\n         <label form=\"verb-short\" prefix=\", \" suffix=\".\" strip-periods=\"true\"/>\n      </names>\n   </macro>\n   <macro name=\"recipient\">\n      <choose>\n         <if type=\"personal_communication\">\n            <choose>\n               <if variable=\"genre\">\n                  <text variable=\"genre\" text-case=\"capitalize-first\"/>\n               </if>\n               <else>\n                  <text term=\"letter\" text-case=\"capitalize-first\"/>\n               </else>\n            </choose>\n         </if>\n      </choose>\n      <names variable=\"recipient\" delimiter=\", \">\n         <label form=\"verb\" prefix=\" \" text-case=\"lowercase\" suffix=\" \"/>\n         <name and=\"text\" delimiter=\", \"/>\n      </names>\n   </macro>\n   <macro name=\"contributors\">\n      <names variable=\"author\">\n         <name and=\"text\" name-as-sort-order=\"first\" sort-separator=\", \" delimiter=\", \" delimiter-precedes-last=\"always\"/>\n         <label form=\"verb-short\" prefix=\", \" suffix=\".\" text-case=\"lowercase\" strip-periods=\"true\"/>\n         <substitute>\n            <text macro=\"editor\"/>\n            <text macro=\"translator\"/>\n            <text macro=\"anon\"/>\n         </substitute>\n      </names>\n      <text macro=\"recipient\"/>\n   </macro>\n   <macro name=\"contributors-short\">\n      <names variable=\"author\">\n         <name form=\"short\" and=\"text\" delimiter=\", \" initialize-with=\". \"/>\n         <substitute>\n            <names variable=\"editor\"/>\n            <names variable=\"translator\"/>\n            <text macro=\"anon\"/>\n         </substitute>\n      </names>\n   </macro>\n   <macro name=\"interviewer\">\n      <names variable=\"interviewer\" delimiter=\", \">\n         <label form=\"verb\" prefix=\" \" text-case=\"capitalize-first\" suffix=\" \"/>\n         <name and=\"text\" delimiter=\", \"/>\n      </names>\n   </macro>\n   <macro name=\"archive\">\n      <group delimiter=\". \">\n         <text variable=\"archive_location\" text-case=\"capitalize-first\"/>\n         <text variable=\"archive\"/>\n         <text variable=\"archive-place\"/>\n      </group>\n   </macro>\n   <macro name=\"access\">\n      <group delimiter=\". \">\n         <choose>\n            <if type=\"graphic report\" match=\"any\">\n               <text macro=\"archive\"/>\n            </if>\n            <else-if type=\"bill book graphic legal_case motion_picture report song article-magazine article-newspaper thesis chapter paper-conference\" match=\"none\">\n               <text macro=\"archive\"/>\n            </else-if>\n         </choose>\n         <text variable=\"DOI\" prefix=\"doi:\"/>\n         <choose>\n            <if type=\"legal_case\" match=\"none\">\n               <text variable=\"URL\"/>\n            </if>\n         </choose>\n      </group>\n   </macro>\n   <macro name=\"title\">\n      <choose>\n         <if variable=\"title\" match=\"none\">\n            <choose>\n               <if type=\"personal_communication\" match=\"none\">\n                  <text variable=\"genre\" text-case=\"capitalize-first\"/>\n               </if>\n            </choose>\n         </if>\n         <else-if type=\"bill book graphic legal_case motion_picture report song\" match=\"any\">\n            <text variable=\"title\" font-style=\"italic\"/>\n         </else-if>\n\t <else>\n            <text variable=\"title\" quotes=\"true\"/>\n         </else>\n      </choose>\n   </macro>\n   <macro name=\"edition\">\n      <choose>\n         <if type=\"bill book graphic legal_case motion_picture report song chapter paper-conference\" match=\"any\">\n            <choose>\n               <if is-numeric=\"edition\">\n                  <group delimiter=\" \">\n                     <number variable=\"edition\" form=\"ordinal\"/>\n                     <text term=\"edition\" form=\"short\" suffix=\".\" strip-periods=\"true\"/>\n                  </group>\n               </if>\n               <else>\n                  <text variable=\"edition\" suffix=\".\"/>\n               </else>\n            </choose>\n         </if>\n      </choose>\n   </macro>\n   <macro name=\"locators\">\n      <choose>\n         <if type=\"article-journal\">\n            <text variable=\"volume\" prefix=\" \"/>\n            <text variable=\"issue\" prefix=\" (\" suffix=\")\"/>\n         </if>\n         <else-if type=\"legal_case\">\n            <text variable=\"volume\" prefix=\", \"/>\n            <text variable=\"container-title\" prefix=\" \"/>\n            <text variable=\"page\" prefix=\" \"/>\n         </else-if>\n         <else-if type=\"bill book graphic legal_case motion_picture report song\" match=\"any\">\n            <group prefix=\". \" delimiter=\". \">\n               <group>\n                  <text term=\"volume\" form=\"short\" text-case=\"capitalize-first\" suffix=\". \" strip-periods=\"true\"/>\n                  <number variable=\"volume\" form=\"numeric\"/>\n               </group>\n               <group>\n                  <number variable=\"number-of-volumes\" form=\"numeric\"/>\n                  <text term=\"volume\" form=\"short\" prefix=\" \" suffix=\".\" plural=\"true\" strip-periods=\"true\"/>\n               </group>\n            </group>\n         </else-if>\n         <else-if type=\"chapter paper-conference\" match=\"any\">\n            <choose>\n               <if variable=\"page\" match=\"none\">\n                  <group prefix=\". \">\n                     <text term=\"volume\" form=\"short\" text-case=\"capitalize-first\" suffix=\". \" strip-periods=\"true\"/>\n                     <number variable=\"volume\" form=\"numeric\"/>\n                  </group>\n               </if>\n            </choose>\n         </else-if>\n      </choose>\n   </macro>\n   <macro name=\"locators-chapter\">\n      <choose>\n         <if type=\"chapter paper-conference\" match=\"any\">\n            <choose>\n               <if variable=\"page\">\n                  <group prefix=\", \">\n                     <text variable=\"volume\" suffix=\":\"/>\n                     <text variable=\"page\"/>\n                  </group>\n               </if>\n            </choose>\n         </if>\n      </choose>\n   </macro>\n   <macro name=\"locators-article\">\n      <choose>\n         <if type=\"article-newspaper\">\n            <group prefix=\", \" delimiter=\", \">\n               <group>\n                  <text variable=\"edition\" suffix=\" \"/>\n                  <text term=\"edition\" prefix=\" \"/>\n               </group>\n               <group>\n                  <text term=\"section\" form=\"short\" suffix=\". \" strip-periods=\"true\"/>\n                  <text variable=\"section\"/>\n               </group>\n            </group>\n         </if>\n         <else-if type=\"article-journal\">\n            <text variable=\"page\" prefix=\": \"/>\n         </else-if>\n      </choose>\n   </macro>\n   <macro name=\"point-locators\">\n      <choose>\n         <if variable=\"locator\">\n            <choose>\n               <if locator=\"page\" match=\"none\">\n                  <choose>\n                     <if type=\"bill book graphic legal_case motion_picture report song\" match=\"any\">\n                        <choose>\n                           <if variable=\"volume\">\n                              <group>\n                                 <text term=\"volume\" form=\"short\" text-case=\"lowercase\" suffix=\". \" strip-periods=\"true\"/>\n                                 <number variable=\"volume\" form=\"numeric\"/>\n                                 <label variable=\"locator\" form=\"short\" prefix=\", \" suffix=\" \"/>\n                              </group>\n                           </if>\n                           <else>\n                              <label variable=\"locator\" form=\"short\" suffix=\" \"/>\n                           </else>\n                        </choose>\n                     </if>\n                  </choose>\n               </if>\n               <else-if type=\"bill book graphic legal_case motion_picture report song\" match=\"any\">\n                  <number variable=\"volume\" form=\"numeric\" suffix=\":\"/>\n               </else-if>\n            </choose>\n            <text variable=\"locator\"/>\n         </if>\n      </choose>\n   </macro>\n   <macro name=\"container-prefix\">\n      <text term=\"in\" text-case=\"capitalize-first\"/>\n   </macro>\n   <macro name=\"container-title\">\n      <choose>\n         <if type=\"chapter paper-conference\" match=\"any\">\n            <text macro=\"container-prefix\" suffix=\" \"/>\n         </if>\n      </choose>\n      <choose>\n         <if type=\"legal_case\" match=\"none\">\n            <text variable=\"container-title\" font-style=\"italic\"/>\n         </if>\n      </choose>\n   </macro>\n   <macro name=\"publisher\">\n      <group delimiter=\": \">\n         <text variable=\"publisher-place\"/>\n         <text variable=\"publisher\"/>\n      </group>\n   </macro>\n   <macro name=\"date\">\n      <date variable=\"issued\">\n         <date-part name=\"year\"/>\n      </date>\n   </macro>\n   <macro name=\"day-month\">\n      <date variable=\"issued\">\n         <date-part name=\"month\"/>\n         <date-part name=\"day\" prefix=\" \"/>\n      </date>\n   </macro>\n   <macro name=\"collection-title\">\n      <text variable=\"collection-title\"/>\n      <text variable=\"collection-number\" prefix=\" \"/>\n   </macro>\n   <macro name=\"event\">\n      <group>\n         <text term=\"presented at\" suffix=\" \"/>\n         <text variable=\"event\"/>\n      </group>\n   </macro>\n   <macro name=\"description\">\n      <choose>\n         <if type=\"interview\">\n            <group delimiter=\". \">\n               <text macro=\"interviewer\"/>\n               <text variable=\"medium\" text-case=\"capitalize-first\"/>\n            </group>\n         </if>\n         <else>\n            <text variable=\"medium\" text-case=\"capitalize-first\" prefix=\". \"/>\n         </else>\n      </choose>\n      <choose>\n         <if variable=\"title\" match=\"none\"/>\n         <else-if type=\"thesis\"/>\n         <else>\n            <text variable=\"genre\" text-case=\"capitalize-first\" prefix=\". \"/>\n         </else>\n      </choose>\n   </macro>\n   <macro name=\"issue\">\n      <choose>\n         <if type=\"article-journal\">\n            <text macro=\"day-month\" prefix=\" (\" suffix=\")\"/>\n         </if>\n         <else-if type=\"legal_case\">\n            <text variable=\"authority\" prefix=\". \"/>\n         </else-if>\n         <else-if type=\"speech\">\n            <group prefix=\" \" delimiter=\", \">\n               <text macro=\"event\"/>\n               <text macro=\"day-month\"/>\n               <text variable=\"event-place\"/>\n            </group>\n         </else-if>\n         <else-if type=\"article-newspaper article-magazine\" match=\"any\">\n            <text macro=\"day-month\" prefix=\", \"/>\n         </else-if>\n         <else>\n            <group prefix=\". \" delimiter=\", \">\n               <choose>\n                  <if type=\"thesis\">\n                     <text variable=\"genre\" text-case=\"capitalize-first\"/>\n                  </if>\n               </choose>\n               <text macro=\"publisher\"/>\n               </group>\n         </else>\n      </choose>\n   </macro>\n   <citation et-al-min=\"4\" et-al-use-first=\"1\" disambiguate-add-year-suffix=\"true\" disambiguate-add-names=\"true\" disambiguate-add-givenname=\"true\" givenname-disambiguation-rule=\"primary-name\">\n      <layout prefix=\"(\" suffix=\")\" delimiter=\"; \">\n         <group delimiter=\", \">\n            <group delimiter=\" \">\n               <text macro=\"contributors-short\"/>\n               <text macro=\"date\"/>\n            </group>\n            <text macro=\"point-locators\"/>\n         </group>\n      </layout>\n   </citation>\n   <bibliography hanging-indent=\"true\" et-al-min=\"11\" et-al-use-first=\"7\" subsequent-author-substitute=\"\226\128\148\226\128\148\226\128\148\" entry-spacing=\"0\">\n      <sort>\n         <key macro=\"contributors\"/>\n         <key variable=\"issued\"/>\n      </sort>\n      <layout suffix=\".\">\n         <text macro=\"contributors\" suffix=\". \"/>\n         <text macro=\"date\" suffix=\". \"/>\n         <text macro=\"title\"/>\n         <text macro=\"description\"/>\n         <text macro=\"secondary-contributors\" prefix=\". \"/>\n         <text macro=\"container-title\" prefix=\". \"/>\n         <text macro=\"container-contributors\"/>\n         <text macro=\"locators-chapter\"/>\n         <text macro=\"edition\" prefix=\". \"/>\n         <text macro=\"locators\"/>\n         <text macro=\"collection-title\" prefix=\". \"/>\n         <text macro=\"issue\"/>\n         <text macro=\"locators-article\"/>\n         <text macro=\"access\" prefix=\". \"/>\n      </layout>\n   </bibliography>\n</style>"),("epub.css","/* This defines styles and classes used in the book */\nbody { margin-left: 5%; margin-right: 5%; margin-top: 5%; margin-bottom: 5%; text-align: justify; font-size: medium; }\ncode { font-family: monospace; }\nh1 { text-align: left; }\nh2 { text-align: left; }\nh3 { text-align: left; }\nh4 { text-align: left; }\nh5 { text-align: left; }\nh6 { text-align: left; }\nh1.title { }\nh2.author { }\nh3.date { }\nol.toc { padding: 0; margin-left: 1em; }\nol.toc li { list-style-type: none; margin: 0; padding: 0; }\n/* For source-code highlighting */\ntable.sourceCode, tr.sourceCode, td.lineNumbers, td.sourceCode, table.sourceCode pre\n   { margin: 0; padding: 0; border: 0; vertical-align: baseline; border: none; }\ntd.lineNumbers { border-right: 1px solid #AAAAAA; text-align: right; color: #AAAAAA; padding-right: 5px; padding-left: 5px; }\ntd.sourceCode { padding-left: 5px; }\npre.sourceCode { }\ncode.sourceCode span.kw { color: #007020; font-weight: bold; }\ncode.sourceCode span.dt { color: #902000; }\ncode.sourceCode span.dv { color: #40a070; }\ncode.sourceCode span.bn { color: #40a070; }\ncode.sourceCode span.fl { color: #40a070; }\ncode.sourceCode span.ch { color: #4070a0; }\ncode.sourceCode span.st { color: #4070a0; }\ncode.sourceCode span.co { color: #60a0b0; font-style: italic; }\ncode.sourceCode span.ot { color: #007020; }\ncode.sourceCode span.al { color: red; font-weight: bold; }\ncode.sourceCode span.fu { color: #06287e; }\ncode.sourceCode span.re { }\ncode.sourceCode span.er { color: red; font-weight: bold; }\n"),("LaTeXMathML.js","/*\nLaTeXMathML.js from http://math.etsu.edu/LaTeXMathML/\nAdapted by Jeff Knisely and Douglas Woodall from ASCIIMathML.js v. 1.4.7,\n(c) 2005 Peter Jipsen http://www.chapman.edu/~jipsen.\nReleased under the GNU General Public License version 2 or later.\nSee the GNU General Public License (at http://www.gnu.org/copyleft/gpl.html)\nfor more details.\n*/\nvar checkForMathML=true;var notifyIfNoMathML=true;var alertIfNoMathML=false;var mathcolor=\"\";var mathfontfamily=\"\";var showasciiformulaonhover=true;var isIE=document.createElementNS==null;if(document.getElementById==null)\nalert(\"This webpage requires a recent browser such as \\nMozilla/Netscape 7+ or Internet Explorer 6+MathPlayer\")\nfunction AMcreateElementXHTML(t){if(isIE)return document.createElement(t);else return document.createElementNS(\"http://www.w3.org/1999/xhtml\",t);}\nfunction AMnoMathMLNote(){var nd=AMcreateElementXHTML(\"h3\");nd.setAttribute(\"align\",\"center\")\nnd.appendChild(AMcreateElementXHTML(\"p\"));nd.appendChild(document.createTextNode(\"To view the \"));var an=AMcreateElementXHTML(\"a\");an.appendChild(document.createTextNode(\"LaTeXMathML\"));an.setAttribute(\"href\",\"http://www.maths.nott.ac.uk/personal/drw/lm.html\");nd.appendChild(an);nd.appendChild(document.createTextNode(\" notation use Internet Explorer 6+\"));an=AMcreateElementXHTML(\"a\");an.appendChild(document.createTextNode(\"MathPlayer\"));an.setAttribute(\"href\",\"http://www.dessci.com/en/products/mathplayer/download.htm\");nd.appendChild(an);nd.appendChild(document.createTextNode(\" or Netscape/Mozilla/Firefox\"));nd.appendChild(AMcreateElementXHTML(\"p\"));return nd;}\nfunction AMisMathMLavailable(){if(navigator.appName.slice(0,8)==\"Netscape\")\nif(navigator.appVersion.slice(0,1)>=\"5\")return null;else return AMnoMathMLNote();else if(navigator.appName.slice(0,9)==\"Microsoft\")\ntry{var ActiveX=new ActiveXObject(\"MathPlayer.Factory.1\");return null;}catch(e){return AMnoMathMLNote();}\nelse return AMnoMathMLNote();}\nvar AMcal=[0xEF35,0x212C,0xEF36,0xEF37,0x2130,0x2131,0xEF38,0x210B,0x2110,0xEF39,0xEF3A,0x2112,0x2133,0xEF3B,0xEF3C,0xEF3D,0xEF3E,0x211B,0xEF3F,0xEF40,0xEF41,0xEF42,0xEF43,0xEF44,0xEF45,0xEF46];var AMfrk=[0xEF5D,0xEF5E,0x212D,0xEF5F,0xEF60,0xEF61,0xEF62,0x210C,0x2111,0xEF63,0xEF64,0xEF65,0xEF66,0xEF67,0xEF68,0xEF69,0xEF6A,0x211C,0xEF6B,0xEF6C,0xEF6D,0xEF6E,0xEF6F,0xEF70,0xEF71,0x2128];var AMbbb=[0xEF8C,0xEF8D,0x2102,0xEF8E,0xEF8F,0xEF90,0xEF91,0x210D,0xEF92,0xEF93,0xEF94,0xEF95,0xEF96,0x2115,0xEF97,0x2119,0x211A,0x211D,0xEF98,0xEF99,0xEF9A,0xEF9B,0xEF9C,0xEF9D,0xEF9E,0x2124];var CONST=0,UNARY=1,BINARY=2,INFIX=3,LEFTBRACKET=4,RIGHTBRACKET=5,SPACE=6,UNDEROVER=7,DEFINITION=8,TEXT=9,BIG=10,LONG=11,STRETCHY=12,MATRIX=13;var AMsqrt={input:\"\\\\sqrt\",tag:\"msqrt\",output:\"sqrt\",ttype:UNARY},AMroot={input:\"\\\\root\",tag:\"mroot\",output:\"root\",ttype:BINARY},AMfrac={input:\"\\\\frac\",tag:\"mfrac\",output:\"/\",ttype:BINARY},AMover={input:\"\\\\stackrel\",tag:\"mover\",output:\"stackrel\",ttype:BINARY},AMatop={input:\"\\\\atop\",tag:\"mfrac\",output:\"\",ttype:INFIX},AMchoose={input:\"\\\\choose\",tag:\"mfrac\",output:\"\",ttype:INFIX},AMsub={input:\"_\",tag:\"msub\",output:\"_\",ttype:INFIX},AMsup={input:\"^\",tag:\"msup\",output:\"^\",ttype:INFIX},AMtext={input:\"\\\\mathrm\",tag:\"mtext\",output:\"text\",ttype:TEXT},AMmbox={input:\"\\\\mbox\",tag:\"mtext\",output:\"mbox\",ttype:TEXT};var AMsymbols=[{input:\"\\\\alpha\",tag:\"mi\",output:\"\\u03B1\",ttype:CONST},{input:\"\\\\beta\",tag:\"mi\",output:\"\\u03B2\",ttype:CONST},{input:\"\\\\gamma\",tag:\"mi\",output:\"\\u03B3\",ttype:CONST},{input:\"\\\\delta\",tag:\"mi\",output:\"\\u03B4\",ttype:CONST},{input:\"\\\\epsilon\",tag:\"mi\",output:\"\\u03B5\",ttype:CONST},{input:\"\\\\varepsilon\",tag:\"mi\",output:\"\\u025B\",ttype:CONST},{input:\"\\\\zeta\",tag:\"mi\",output:\"\\u03B6\",ttype:CONST},{input:\"\\\\eta\",tag:\"mi\",output:\"\\u03B7\",ttype:CONST},{input:\"\\\\theta\",tag:\"mi\",output:\"\\u03B8\",ttype:CONST},{input:\"\\\\vartheta\",tag:\"mi\",output:\"\\u03D1\",ttype:CONST},{input:\"\\\\iota\",tag:\"mi\",output:\"\\u03B9\",ttype:CONST},{input:\"\\\\kappa\",tag:\"mi\",output:\"\\u03BA\",ttype:CONST},{input:\"\\\\lambda\",tag:\"mi\",output:\"\\u03BB\",ttype:CONST},{input:\"\\\\mu\",tag:\"mi\",output:\"\\u03BC\",ttype:CONST},{input:\"\\\\nu\",tag:\"mi\",output:\"\\u03BD\",ttype:CONST},{input:\"\\\\xi\",tag:\"mi\",output:\"\\u03BE\",ttype:CONST},{input:\"\\\\pi\",tag:\"mi\",output:\"\\u03C0\",ttype:CONST},{input:\"\\\\varpi\",tag:\"mi\",output:\"\\u03D6\",ttype:CONST},{input:\"\\\\rho\",tag:\"mi\",output:\"\\u03C1\",ttype:CONST},{input:\"\\\\varrho\",tag:\"mi\",output:\"\\u03F1\",ttype:CONST},{input:\"\\\\varsigma\",tag:\"mi\",output:\"\\u03C2\",ttype:CONST},{input:\"\\\\sigma\",tag:\"mi\",output:\"\\u03C3\",ttype:CONST},{input:\"\\\\tau\",tag:\"mi\",output:\"\\u03C4\",ttype:CONST},{input:\"\\\\upsilon\",tag:\"mi\",output:\"\\u03C5\",ttype:CONST},{input:\"\\\\phi\",tag:\"mi\",output:\"\\u03C6\",ttype:CONST},{input:\"\\\\varphi\",tag:\"mi\",output:\"\\u03D5\",ttype:CONST},{input:\"\\\\chi\",tag:\"mi\",output:\"\\u03C7\",ttype:CONST},{input:\"\\\\psi\",tag:\"mi\",output:\"\\u03C8\",ttype:CONST},{input:\"\\\\omega\",tag:\"mi\",output:\"\\u03C9\",ttype:CONST},{input:\"\\\\Gamma\",tag:\"mo\",output:\"\\u0393\",ttype:CONST},{input:\"\\\\Delta\",tag:\"mo\",output:\"\\u0394\",ttype:CONST},{input:\"\\\\Theta\",tag:\"mo\",output:\"\\u0398\",ttype:CONST},{input:\"\\\\Lambda\",tag:\"mo\",output:\"\\u039B\",ttype:CONST},{input:\"\\\\Xi\",tag:\"mo\",output:\"\\u039E\",ttype:CONST},{input:\"\\\\Pi\",tag:\"mo\",output:\"\\u03A0\",ttype:CONST},{input:\"\\\\Sigma\",tag:\"mo\",output:\"\\u03A3\",ttype:CONST},{input:\"\\\\Upsilon\",tag:\"mo\",output:\"\\u03A5\",ttype:CONST},{input:\"\\\\Phi\",tag:\"mo\",output:\"\\u03A6\",ttype:CONST},{input:\"\\\\Psi\",tag:\"mo\",output:\"\\u03A8\",ttype:CONST},{input:\"\\\\Omega\",tag:\"mo\",output:\"\\u03A9\",ttype:CONST},{input:\"\\\\frac12\",tag:\"mo\",output:\"\\u00BD\",ttype:CONST},{input:\"\\\\frac14\",tag:\"mo\",output:\"\\u00BC\",ttype:CONST},{input:\"\\\\frac34\",tag:\"mo\",output:\"\\u00BE\",ttype:CONST},{input:\"\\\\frac13\",tag:\"mo\",output:\"\\u2153\",ttype:CONST},{input:\"\\\\frac23\",tag:\"mo\",output:\"\\u2154\",ttype:CONST},{input:\"\\\\frac15\",tag:\"mo\",output:\"\\u2155\",ttype:CONST},{input:\"\\\\frac25\",tag:\"mo\",output:\"\\u2156\",ttype:CONST},{input:\"\\\\frac35\",tag:\"mo\",output:\"\\u2157\",ttype:CONST},{input:\"\\\\frac45\",tag:\"mo\",output:\"\\u2158\",ttype:CONST},{input:\"\\\\frac16\",tag:\"mo\",output:\"\\u2159\",ttype:CONST},{input:\"\\\\frac56\",tag:\"mo\",output:\"\\u215A\",ttype:CONST},{input:\"\\\\frac18\",tag:\"mo\",output:\"\\u215B\",ttype:CONST},{input:\"\\\\frac38\",tag:\"mo\",output:\"\\u215C\",ttype:CONST},{input:\"\\\\frac58\",tag:\"mo\",output:\"\\u215D\",ttype:CONST},{input:\"\\\\frac78\",tag:\"mo\",output:\"\\u215E\",ttype:CONST},{input:\"\\\\pm\",tag:\"mo\",output:\"\\u00B1\",ttype:CONST},{input:\"\\\\mp\",tag:\"mo\",output:\"\\u2213\",ttype:CONST},{input:\"\\\\triangleleft\",tag:\"mo\",output:\"\\u22B2\",ttype:CONST},{input:\"\\\\triangleright\",tag:\"mo\",output:\"\\u22B3\",ttype:CONST},{input:\"\\\\cdot\",tag:\"mo\",output:\"\\u22C5\",ttype:CONST},{input:\"\\\\star\",tag:\"mo\",output:\"\\u22C6\",ttype:CONST},{input:\"\\\\ast\",tag:\"mo\",output:\"\\u002A\",ttype:CONST},{input:\"\\\\times\",tag:\"mo\",output:\"\\u00D7\",ttype:CONST},{input:\"\\\\div\",tag:\"mo\",output:\"\\u00F7\",ttype:CONST},{input:\"\\\\circ\",tag:\"mo\",output:\"\\u2218\",ttype:CONST},{input:\"\\\\bullet\",tag:\"mo\",output:\"\\u2022\",ttype:CONST},{input:\"\\\\oplus\",tag:\"mo\",output:\"\\u2295\",ttype:CONST},{input:\"\\\\ominus\",tag:\"mo\",output:\"\\u2296\",ttype:CONST},{input:\"\\\\otimes\",tag:\"mo\",output:\"\\u2297\",ttype:CONST},{input:\"\\\\bigcirc\",tag:\"mo\",output:\"\\u25CB\",ttype:CONST},{input:\"\\\\oslash\",tag:\"mo\",output:\"\\u2298\",ttype:CONST},{input:\"\\\\odot\",tag:\"mo\",output:\"\\u2299\",ttype:CONST},{input:\"\\\\land\",tag:\"mo\",output:\"\\u2227\",ttype:CONST},{input:\"\\\\wedge\",tag:\"mo\",output:\"\\u2227\",ttype:CONST},{input:\"\\\\lor\",tag:\"mo\",output:\"\\u2228\",ttype:CONST},{input:\"\\\\vee\",tag:\"mo\",output:\"\\u2228\",ttype:CONST},{input:\"\\\\cap\",tag:\"mo\",output:\"\\u2229\",ttype:CONST},{input:\"\\\\cup\",tag:\"mo\",output:\"\\u222A\",ttype:CONST},{input:\"\\\\sqcap\",tag:\"mo\",output:\"\\u2293\",ttype:CONST},{input:\"\\\\sqcup\",tag:\"mo\",output:\"\\u2294\",ttype:CONST},{input:\"\\\\uplus\",tag:\"mo\",output:\"\\u228E\",ttype:CONST},{input:\"\\\\amalg\",tag:\"mo\",output:\"\\u2210\",ttype:CONST},{input:\"\\\\bigtriangleup\",tag:\"mo\",output:\"\\u25B3\",ttype:CONST},{input:\"\\\\bigtriangledown\",tag:\"mo\",output:\"\\u25BD\",ttype:CONST},{input:\"\\\\dag\",tag:\"mo\",output:\"\\u2020\",ttype:CONST},{input:\"\\\\dagger\",tag:\"mo\",output:\"\\u2020\",ttype:CONST},{input:\"\\\\ddag\",tag:\"mo\",output:\"\\u2021\",ttype:CONST},{input:\"\\\\ddagger\",tag:\"mo\",output:\"\\u2021\",ttype:CONST},{input:\"\\\\lhd\",tag:\"mo\",output:\"\\u22B2\",ttype:CONST},{input:\"\\\\rhd\",tag:\"mo\",output:\"\\u22B3\",ttype:CONST},{input:\"\\\\unlhd\",tag:\"mo\",output:\"\\u22B4\",ttype:CONST},{input:\"\\\\unrhd\",tag:\"mo\",output:\"\\u22B5\",ttype:CONST},{input:\"\\\\sum\",tag:\"mo\",output:\"\\u2211\",ttype:UNDEROVER},{input:\"\\\\prod\",tag:\"mo\",output:\"\\u220F\",ttype:UNDEROVER},{input:\"\\\\bigcap\",tag:\"mo\",output:\"\\u22C2\",ttype:UNDEROVER},{input:\"\\\\bigcup\",tag:\"mo\",output:\"\\u22C3\",ttype:UNDEROVER},{input:\"\\\\bigwedge\",tag:\"mo\",output:\"\\u22C0\",ttype:UNDEROVER},{input:\"\\\\bigvee\",tag:\"mo\",output:\"\\u22C1\",ttype:UNDEROVER},{input:\"\\\\bigsqcap\",tag:\"mo\",output:\"\\u2A05\",ttype:UNDEROVER},{input:\"\\\\bigsqcup\",tag:\"mo\",output:\"\\u2A06\",ttype:UNDEROVER},{input:\"\\\\coprod\",tag:\"mo\",output:\"\\u2210\",ttype:UNDEROVER},{input:\"\\\\bigoplus\",tag:\"mo\",output:\"\\u2A01\",ttype:UNDEROVER},{input:\"\\\\bigotimes\",tag:\"mo\",output:\"\\u2A02\",ttype:UNDEROVER},{input:\"\\\\bigodot\",tag:\"mo\",output:\"\\u2A00\",ttype:UNDEROVER},{input:\"\\\\biguplus\",tag:\"mo\",output:\"\\u2A04\",ttype:UNDEROVER},{input:\"\\\\int\",tag:\"mo\",output:\"\\u222B\",ttype:CONST},{input:\"\\\\oint\",tag:\"mo\",output:\"\\u222E\",ttype:CONST},{input:\":=\",tag:\"mo\",output:\":=\",ttype:CONST},{input:\"\\\\lt\",tag:\"mo\",output:\"<\",ttype:CONST},{input:\"\\\\gt\",tag:\"mo\",output:\">\",ttype:CONST},{input:\"\\\\ne\",tag:\"mo\",output:\"\\u2260\",ttype:CONST},{input:\"\\\\neq\",tag:\"mo\",output:\"\\u2260\",ttype:CONST},{input:\"\\\\le\",tag:\"mo\",output:\"\\u2264\",ttype:CONST},{input:\"\\\\leq\",tag:\"mo\",output:\"\\u2264\",ttype:CONST},{input:\"\\\\leqslant\",tag:\"mo\",output:\"\\u2264\",ttype:CONST},{input:\"\\\\ge\",tag:\"mo\",output:\"\\u2265\",ttype:CONST},{input:\"\\\\geq\",tag:\"mo\",output:\"\\u2265\",ttype:CONST},{input:\"\\\\geqslant\",tag:\"mo\",output:\"\\u2265\",ttype:CONST},{input:\"\\\\equiv\",tag:\"mo\",output:\"\\u2261\",ttype:CONST},{input:\"\\\\ll\",tag:\"mo\",output:\"\\u226A\",ttype:CONST},{input:\"\\\\gg\",tag:\"mo\",output:\"\\u226B\",ttype:CONST},{input:\"\\\\doteq\",tag:\"mo\",output:\"\\u2250\",ttype:CONST},{input:\"\\\\prec\",tag:\"mo\",output:\"\\u227A\",ttype:CONST},{input:\"\\\\succ\",tag:\"mo\",output:\"\\u227B\",ttype:CONST},{input:\"\\\\preceq\",tag:\"mo\",output:\"\\u227C\",ttype:CONST},{input:\"\\\\succeq\",tag:\"mo\",output:\"\\u227D\",ttype:CONST},{input:\"\\\\subset\",tag:\"mo\",output:\"\\u2282\",ttype:CONST},{input:\"\\\\supset\",tag:\"mo\",output:\"\\u2283\",ttype:CONST},{input:\"\\\\subseteq\",tag:\"mo\",output:\"\\u2286\",ttype:CONST},{input:\"\\\\supseteq\",tag:\"mo\",output:\"\\u2287\",ttype:CONST},{input:\"\\\\sqsubset\",tag:\"mo\",output:\"\\u228F\",ttype:CONST},{input:\"\\\\sqsupset\",tag:\"mo\",output:\"\\u2290\",ttype:CONST},{input:\"\\\\sqsubseteq\",tag:\"mo\",output:\"\\u2291\",ttype:CONST},{input:\"\\\\sqsupseteq\",tag:\"mo\",output:\"\\u2292\",ttype:CONST},{input:\"\\\\sim\",tag:\"mo\",output:\"\\u223C\",ttype:CONST},{input:\"\\\\simeq\",tag:\"mo\",output:\"\\u2243\",ttype:CONST},{input:\"\\\\approx\",tag:\"mo\",output:\"\\u2248\",ttype:CONST},{input:\"\\\\cong\",tag:\"mo\",output:\"\\u2245\",ttype:CONST},{input:\"\\\\Join\",tag:\"mo\",output:\"\\u22C8\",ttype:CONST},{input:\"\\\\bowtie\",tag:\"mo\",output:\"\\u22C8\",ttype:CONST},{input:\"\\\\in\",tag:\"mo\",output:\"\\u2208\",ttype:CONST},{input:\"\\\\ni\",tag:\"mo\",output:\"\\u220B\",ttype:CONST},{input:\"\\\\owns\",tag:\"mo\",output:\"\\u220B\",ttype:CONST},{input:\"\\\\propto\",tag:\"mo\",output:\"\\u221D\",ttype:CONST},{input:\"\\\\vdash\",tag:\"mo\",output:\"\\u22A2\",ttype:CONST},{input:\"\\\\dashv\",tag:\"mo\",output:\"\\u22A3\",ttype:CONST},{input:\"\\\\models\",tag:\"mo\",output:\"\\u22A8\",ttype:CONST},{input:\"\\\\perp\",tag:\"mo\",output:\"\\u22A5\",ttype:CONST},{input:\"\\\\smile\",tag:\"mo\",output:\"\\u2323\",ttype:CONST},{input:\"\\\\frown\",tag:\"mo\",output:\"\\u2322\",ttype:CONST},{input:\"\\\\asymp\",tag:\"mo\",output:\"\\u224D\",ttype:CONST},{input:\"\\\\notin\",tag:\"mo\",output:\"\\u2209\",ttype:CONST},{input:\"\\\\begin{eqnarray}\",output:\"X\",ttype:MATRIX,invisible:true},{input:\"\\\\begin{array}\",output:\"X\",ttype:MATRIX,invisible:true},{input:\"\\\\\\\\\",output:\"}&{\",ttype:DEFINITION},{input:\"\\\\end{eqnarray}\",output:\"}}\",ttype:DEFINITION},{input:\"\\\\end{array}\",output:\"}}\",ttype:DEFINITION},{input:\"\\\\big\",tag:\"mo\",output:\"X\",atval:\"1.2\",ieval:\"2.2\",ttype:BIG},{input:\"\\\\Big\",tag:\"mo\",output:\"X\",atval:\"1.6\",ieval:\"2.6\",ttype:BIG},{input:\"\\\\bigg\",tag:\"mo\",output:\"X\",atval:\"2.2\",ieval:\"3.2\",ttype:BIG},{input:\"\\\\Bigg\",tag:\"mo\",output:\"X\",atval:\"2.9\",ieval:\"3.9\",ttype:BIG},{input:\"\\\\left\",tag:\"mo\",output:\"X\",ttype:LEFTBRACKET},{input:\"\\\\right\",tag:\"mo\",output:\"X\",ttype:RIGHTBRACKET},{input:\"{\",output:\"{\",ttype:LEFTBRACKET,invisible:true},{input:\"}\",output:\"}\",ttype:RIGHTBRACKET,invisible:true},{input:\"(\",tag:\"mo\",output:\"(\",atval:\"1\",ttype:STRETCHY},{input:\"[\",tag:\"mo\",output:\"[\",atval:\"1\",ttype:STRETCHY},{input:\"\\\\lbrack\",tag:\"mo\",output:\"[\",atval:\"1\",ttype:STRETCHY},{input:\"\\\\{\",tag:\"mo\",output:\"{\",atval:\"1\",ttype:STRETCHY},{input:\"\\\\lbrace\",tag:\"mo\",output:\"{\",atval:\"1\",ttype:STRETCHY},{input:\"\\\\langle\",tag:\"mo\",output:\"\\u2329\",atval:\"1\",ttype:STRETCHY},{input:\"\\\\lfloor\",tag:\"mo\",output:\"\\u230A\",atval:\"1\",ttype:STRETCHY},{input:\"\\\\lceil\",tag:\"mo\",output:\"\\u2308\",atval:\"1\",ttype:STRETCHY},{input:\")\",tag:\"mo\",output:\")\",rtag:\"mi\",atval:\"1\",ttype:STRETCHY},{input:\"]\",tag:\"mo\",output:\"]\",rtag:\"mi\",atval:\"1\",ttype:STRETCHY},{input:\"\\\\rbrack\",tag:\"mo\",output:\"]\",rtag:\"mi\",atval:\"1\",ttype:STRETCHY},{input:\"\\\\}\",tag:\"mo\",output:\"}\",rtag:\"mi\",atval:\"1\",ttype:STRETCHY},{input:\"\\\\rbrace\",tag:\"mo\",output:\"}\",rtag:\"mi\",atval:\"1\",ttype:STRETCHY},{input:\"\\\\rangle\",tag:\"mo\",output:\"\\u232A\",rtag:\"mi\",atval:\"1\",ttype:STRETCHY},{input:\"\\\\rfloor\",tag:\"mo\",output:\"\\u230B\",rtag:\"mi\",atval:\"1\",ttype:STRETCHY},{input:\"\\\\rceil\",tag:\"mo\",output:\"\\u2309\",rtag:\"mi\",atval:\"1\",ttype:STRETCHY},{input:\"|\",tag:\"mo\",output:\"\\u2223\",atval:\"1\",ttype:STRETCHY},{input:\"\\\\|\",tag:\"mo\",output:\"\\u2225\",atval:\"1\",ttype:STRETCHY},{input:\"\\\\vert\",tag:\"mo\",output:\"\\u2223\",atval:\"1\",ttype:STRETCHY},{input:\"\\\\Vert\",tag:\"mo\",output:\"\\u2225\",atval:\"1\",ttype:STRETCHY},{input:\"\\\\mid\",tag:\"mo\",output:\"\\u2223\",atval:\"1\",ttype:STRETCHY},{input:\"\\\\parallel\",tag:\"mo\",output:\"\\u2225\",atval:\"1\",ttype:STRETCHY},{input:\"/\",tag:\"mo\",output:\"/\",atval:\"1.01\",ttype:STRETCHY},{input:\"\\\\backslash\",tag:\"mo\",output:\"\\u2216\",atval:\"1\",ttype:STRETCHY},{input:\"\\\\setminus\",tag:\"mo\",output:\"\\\\\",ttype:CONST},{input:\"\\\\!\",tag:\"mspace\",atname:\"width\",atval:\"-0.167em\",ttype:SPACE},{input:\"\\\\,\",tag:\"mspace\",atname:\"width\",atval:\"0.167em\",ttype:SPACE},{input:\"\\\\>\",tag:\"mspace\",atname:\"width\",atval:\"0.222em\",ttype:SPACE},{input:\"\\\\:\",tag:\"mspace\",atname:\"width\",atval:\"0.222em\",ttype:SPACE},{input:\"\\\\;\",tag:\"mspace\",atname:\"width\",atval:\"0.278em\",ttype:SPACE},{input:\"~\",tag:\"mspace\",atname:\"width\",atval:\"0.333em\",ttype:SPACE},{input:\"\\\\quad\",tag:\"mspace\",atname:\"width\",atval:\"1em\",ttype:SPACE},{input:\"\\\\qquad\",tag:\"mspace\",atname:\"width\",atval:\"2em\",ttype:SPACE},{input:\"\\\\prime\",tag:\"mo\",output:\"\\u2032\",ttype:CONST},{input:\"'\",tag:\"mo\",output:\"\\u02B9\",ttype:CONST},{input:\"''\",tag:\"mo\",output:\"\\u02BA\",ttype:CONST},{input:\"'''\",tag:\"mo\",output:\"\\u2034\",ttype:CONST},{input:\"''''\",tag:\"mo\",output:\"\\u2057\",ttype:CONST},{input:\"\\\\ldots\",tag:\"mo\",output:\"\\u2026\",ttype:CONST},{input:\"\\\\cdots\",tag:\"mo\",output:\"\\u22EF\",ttype:CONST},{input:\"\\\\vdots\",tag:\"mo\",output:\"\\u22EE\",ttype:CONST},{input:\"\\\\ddots\",tag:\"mo\",output:\"\\u22F1\",ttype:CONST},{input:\"\\\\forall\",tag:\"mo\",output:\"\\u2200\",ttype:CONST},{input:\"\\\\exists\",tag:\"mo\",output:\"\\u2203\",ttype:CONST},{input:\"\\\\Re\",tag:\"mo\",output:\"\\u211C\",ttype:CONST},{input:\"\\\\Im\",tag:\"mo\",output:\"\\u2111\",ttype:CONST},{input:\"\\\\aleph\",tag:\"mo\",output:\"\\u2135\",ttype:CONST},{input:\"\\\\hbar\",tag:\"mo\",output:\"\\u210F\",ttype:CONST},{input:\"\\\\ell\",tag:\"mo\",output:\"\\u2113\",ttype:CONST},{input:\"\\\\wp\",tag:\"mo\",output:\"\\u2118\",ttype:CONST},{input:\"\\\\emptyset\",tag:\"mo\",output:\"\\u2205\",ttype:CONST},{input:\"\\\\infty\",tag:\"mo\",output:\"\\u221E\",ttype:CONST},{input:\"\\\\surd\",tag:\"mo\",output:\"\\\\sqrt{}\",ttype:DEFINITION},{input:\"\\\\partial\",tag:\"mo\",output:\"\\u2202\",ttype:CONST},{input:\"\\\\nabla\",tag:\"mo\",output:\"\\u2207\",ttype:CONST},{input:\"\\\\triangle\",tag:\"mo\",output:\"\\u25B3\",ttype:CONST},{input:\"\\\\therefore\",tag:\"mo\",output:\"\\u2234\",ttype:CONST},{input:\"\\\\angle\",tag:\"mo\",output:\"\\u2220\",ttype:CONST},{input:\"\\\\diamond\",tag:\"mo\",output:\"\\u22C4\",ttype:CONST},{input:\"\\\\Diamond\",tag:\"mo\",output:\"\\u25C7\",ttype:CONST},{input:\"\\\\neg\",tag:\"mo\",output:\"\\u00AC\",ttype:CONST},{input:\"\\\\lnot\",tag:\"mo\",output:\"\\u00AC\",ttype:CONST},{input:\"\\\\bot\",tag:\"mo\",output:\"\\u22A5\",ttype:CONST},{input:\"\\\\top\",tag:\"mo\",output:\"\\u22A4\",ttype:CONST},{input:\"\\\\square\",tag:\"mo\",output:\"\\u25AB\",ttype:CONST},{input:\"\\\\Box\",tag:\"mo\",output:\"\\u25A1\",ttype:CONST},{input:\"\\\\wr\",tag:\"mo\",output:\"\\u2240\",ttype:CONST},{input:\"\\\\arccos\",tag:\"mi\",output:\"arccos\",ttype:UNARY,func:true},{input:\"\\\\arcsin\",tag:\"mi\",output:\"arcsin\",ttype:UNARY,func:true},{input:\"\\\\arctan\",tag:\"mi\",output:\"arctan\",ttype:UNARY,func:true},{input:\"\\\\arg\",tag:\"mi\",output:\"arg\",ttype:UNARY,func:true},{input:\"\\\\cos\",tag:\"mi\",output:\"cos\",ttype:UNARY,func:true},{input:\"\\\\cosh\",tag:\"mi\",output:\"cosh\",ttype:UNARY,func:true},{input:\"\\\\cot\",tag:\"mi\",output:\"cot\",ttype:UNARY,func:true},{input:\"\\\\coth\",tag:\"mi\",output:\"coth\",ttype:UNARY,func:true},{input:\"\\\\csc\",tag:\"mi\",output:\"csc\",ttype:UNARY,func:true},{input:\"\\\\deg\",tag:\"mi\",output:\"deg\",ttype:UNARY,func:true},{input:\"\\\\det\",tag:\"mi\",output:\"det\",ttype:UNARY,func:true},{input:\"\\\\dim\",tag:\"mi\",output:\"dim\",ttype:UNARY,func:true},{input:\"\\\\exp\",tag:\"mi\",output:\"exp\",ttype:UNARY,func:true},{input:\"\\\\gcd\",tag:\"mi\",output:\"gcd\",ttype:UNARY,func:true},{input:\"\\\\hom\",tag:\"mi\",output:\"hom\",ttype:UNARY,func:true},{input:\"\\\\inf\",tag:\"mo\",output:\"inf\",ttype:UNDEROVER},{input:\"\\\\ker\",tag:\"mi\",output:\"ker\",ttype:UNARY,func:true},{input:\"\\\\lg\",tag:\"mi\",output:\"lg\",ttype:UNARY,func:true},{input:\"\\\\lim\",tag:\"mo\",output:\"lim\",ttype:UNDEROVER},{input:\"\\\\liminf\",tag:\"mo\",output:\"liminf\",ttype:UNDEROVER},{input:\"\\\\limsup\",tag:\"mo\",output:\"limsup\",ttype:UNDEROVER},{input:\"\\\\ln\",tag:\"mi\",output:\"ln\",ttype:UNARY,func:true},{input:\"\\\\log\",tag:\"mi\",output:\"log\",ttype:UNARY,func:true},{input:\"\\\\max\",tag:\"mo\",output:\"max\",ttype:UNDEROVER},{input:\"\\\\min\",tag:\"mo\",output:\"min\",ttype:UNDEROVER},{input:\"\\\\Pr\",tag:\"mi\",output:\"Pr\",ttype:UNARY,func:true},{input:\"\\\\sec\",tag:\"mi\",output:\"sec\",ttype:UNARY,func:true},{input:\"\\\\sin\",tag:\"mi\",output:\"sin\",ttype:UNARY,func:true},{input:\"\\\\sinh\",tag:\"mi\",output:\"sinh\",ttype:UNARY,func:true},{input:\"\\\\sup\",tag:\"mo\",output:\"sup\",ttype:UNDEROVER},{input:\"\\\\tan\",tag:\"mi\",output:\"tan\",ttype:UNARY,func:true},{input:\"\\\\tanh\",tag:\"mi\",output:\"tanh\",ttype:UNARY,func:true},{input:\"\\\\gets\",tag:\"mo\",output:\"\\u2190\",ttype:CONST},{input:\"\\\\leftarrow\",tag:\"mo\",output:\"\\u2190\",ttype:CONST},{input:\"\\\\to\",tag:\"mo\",output:\"\\u2192\",ttype:CONST},{input:\"\\\\rightarrow\",tag:\"mo\",output:\"\\u2192\",ttype:CONST},{input:\"\\\\leftrightarrow\",tag:\"mo\",output:\"\\u2194\",ttype:CONST},{input:\"\\\\uparrow\",tag:\"mo\",output:\"\\u2191\",ttype:CONST},{input:\"\\\\downarrow\",tag:\"mo\",output:\"\\u2193\",ttype:CONST},{input:\"\\\\updownarrow\",tag:\"mo\",output:\"\\u2195\",ttype:CONST},{input:\"\\\\Leftarrow\",tag:\"mo\",output:\"\\u21D0\",ttype:CONST},{input:\"\\\\Rightarrow\",tag:\"mo\",output:\"\\u21D2\",ttype:CONST},{input:\"\\\\Leftrightarrow\",tag:\"mo\",output:\"\\u21D4\",ttype:CONST},{input:\"\\\\iff\",tag:\"mo\",output:\"~\\\\Longleftrightarrow~\",ttype:DEFINITION},{input:\"\\\\Uparrow\",tag:\"mo\",output:\"\\u21D1\",ttype:CONST},{input:\"\\\\Downarrow\",tag:\"mo\",output:\"\\u21D3\",ttype:CONST},{input:\"\\\\Updownarrow\",tag:\"mo\",output:\"\\u21D5\",ttype:CONST},{input:\"\\\\mapsto\",tag:\"mo\",output:\"\\u21A6\",ttype:CONST},{input:\"\\\\longleftarrow\",tag:\"mo\",output:\"\\u2190\",ttype:LONG},{input:\"\\\\longrightarrow\",tag:\"mo\",output:\"\\u2192\",ttype:LONG},{input:\"\\\\longleftrightarrow\",tag:\"mo\",output:\"\\u2194\",ttype:LONG},{input:\"\\\\Longleftarrow\",tag:\"mo\",output:\"\\u21D0\",ttype:LONG},{input:\"\\\\Longrightarrow\",tag:\"mo\",output:\"\\u21D2\",ttype:LONG},{input:\"\\\\Longleftrightarrow\",tag:\"mo\",output:\"\\u21D4\",ttype:LONG},{input:\"\\\\longmapsto\",tag:\"mo\",output:\"\\u21A6\",ttype:CONST},AMsqrt,AMroot,AMfrac,AMover,AMsub,AMsup,AMtext,AMmbox,AMatop,AMchoose,{input:\"\\\\acute\",tag:\"mover\",output:\"\\u00B4\",ttype:UNARY,acc:true},{input:\"\\\\grave\",tag:\"mover\",output:\"\\u0060\",ttype:UNARY,acc:true},{input:\"\\\\breve\",tag:\"mover\",output:\"\\u02D8\",ttype:UNARY,acc:true},{input:\"\\\\check\",tag:\"mover\",output:\"\\u02C7\",ttype:UNARY,acc:true},{input:\"\\\\dot\",tag:\"mover\",output:\".\",ttype:UNARY,acc:true},{input:\"\\\\ddot\",tag:\"mover\",output:\"..\",ttype:UNARY,acc:true},{input:\"\\\\mathring\",tag:\"mover\",output:\"\\u00B0\",ttype:UNARY,acc:true},{input:\"\\\\vec\",tag:\"mover\",output:\"\\u20D7\",ttype:UNARY,acc:true},{input:\"\\\\overrightarrow\",tag:\"mover\",output:\"\\u20D7\",ttype:UNARY,acc:true},{input:\"\\\\overleftarrow\",tag:\"mover\",output:\"\\u20D6\",ttype:UNARY,acc:true},{input:\"\\\\hat\",tag:\"mover\",output:\"\\u005E\",ttype:UNARY,acc:true},{input:\"\\\\widehat\",tag:\"mover\",output:\"\\u0302\",ttype:UNARY,acc:true},{input:\"\\\\tilde\",tag:\"mover\",output:\"~\",ttype:UNARY,acc:true},{input:\"\\\\widetilde\",tag:\"mover\",output:\"\\u02DC\",ttype:UNARY,acc:true},{input:\"\\\\bar\",tag:\"mover\",output:\"\\u203E\",ttype:UNARY,acc:true},{input:\"\\\\overbrace\",tag:\"mover\",output:\"\\uFE37\",ttype:UNARY,acc:true},{input:\"\\\\overbracket\",tag:\"mover\",output:\"\\u23B4\",ttype:UNARY,acc:true},{input:\"\\\\overline\",tag:\"mover\",output:\"\\u00AF\",ttype:UNARY,acc:true},{input:\"\\\\underbrace\",tag:\"munder\",output:\"\\uFE38\",ttype:UNARY,acc:true},{input:\"\\\\underbracket\",tag:\"munder\",output:\"\\u23B5\",ttype:UNARY,acc:true},{input:\"\\\\underline\",tag:\"munder\",output:\"\\u00AF\",ttype:UNARY,acc:true},{input:\"\\\\displaystyle\",tag:\"mstyle\",atname:\"displaystyle\",atval:\"true\",ttype:UNARY},{input:\"\\\\textstyle\",tag:\"mstyle\",atname:\"displaystyle\",atval:\"false\",ttype:UNARY},{input:\"\\\\scriptstyle\",tag:\"mstyle\",atname:\"scriptlevel\",atval:\"1\",ttype:UNARY},{input:\"\\\\scriptscriptstyle\",tag:\"mstyle\",atname:\"scriptlevel\",atval:\"2\",ttype:UNARY},{input:\"\\\\textrm\",tag:\"mstyle\",output:\"\\\\mathrm\",ttype:DEFINITION},{input:\"\\\\mathbf\",tag:\"mstyle\",atname:\"mathvariant\",atval:\"bold\",ttype:UNARY},{input:\"\\\\textbf\",tag:\"mstyle\",atname:\"mathvariant\",atval:\"bold\",ttype:UNARY},{input:\"\\\\mathit\",tag:\"mstyle\",atname:\"mathvariant\",atval:\"italic\",ttype:UNARY},{input:\"\\\\textit\",tag:\"mstyle\",atname:\"mathvariant\",atval:\"italic\",ttype:UNARY},{input:\"\\\\mathtt\",tag:\"mstyle\",atname:\"mathvariant\",atval:\"monospace\",ttype:UNARY},{input:\"\\\\texttt\",tag:\"mstyle\",atname:\"mathvariant\",atval:\"monospace\",ttype:UNARY},{input:\"\\\\mathsf\",tag:\"mstyle\",atname:\"mathvariant\",atval:\"sans-serif\",ttype:UNARY},{input:\"\\\\mathbb\",tag:\"mstyle\",atname:\"mathvariant\",atval:\"double-struck\",ttype:UNARY,codes:AMbbb},{input:\"\\\\mathcal\",tag:\"mstyle\",atname:\"mathvariant\",atval:\"script\",ttype:UNARY,codes:AMcal},{input:\"\\\\mathfrak\",tag:\"mstyle\",atname:\"mathvariant\",atval:\"fraktur\",ttype:UNARY,codes:AMfrk},{input:\"\\\\textcolor\",tag:\"mstyle\",atname:\"mathvariant\",atval:\"mathcolor\",ttype:BINARY},{input:\"\\\\colorbox\",tag:\"mstyle\",atname:\"mathvariant\",atval:\"background\",ttype:BINARY}];function compareNames(s1,s2){if(s1.input>s2.input)return 1\nelse return-1;}\nvar AMnames=[];function AMinitSymbols(){AMsymbols.sort(compareNames);for(i=0;i<AMsymbols.length;i++)AMnames[i]=AMsymbols[i].input;}\nvar AMmathml=\"http://www.w3.org/1998/Math/MathML\";function AMcreateElementMathML(t){if(isIE)return document.createElement(\"m:\"+t);else return document.createElementNS(AMmathml,t);}\nfunction AMcreateMmlNode(t,frag){if(isIE)var node=document.createElement(\"m:\"+t);else var node=document.createElementNS(AMmathml,t);node.appendChild(frag);return node;}\nfunction newcommand(oldstr,newstr){AMsymbols=AMsymbols.concat([{input:oldstr,tag:\"mo\",output:newstr,ttype:DEFINITION}]);}\nfunction AMremoveCharsAndBlanks(str,n){var st;st=str.slice(n);for(var i=0;i<st.length&&st.charCodeAt(i)<=32;i=i+1);return st.slice(i);}\nfunction AMposition(arr,str,n){if(n==0){var h,m;n=-1;h=arr.length;while(n+1<h){m=(n+h)>>1;if(arr[m]<str)n=m;else h=m;}\nreturn h;}else\nfor(var i=n;i<arr.length&&arr[i]<str;i++);return i;}\nfunction AMgetSymbol(str){var k=0;var j=0;var mk;var st;var tagst;var match=\"\";var more=true;for(var i=1;i<=str.length&&more;i++){st=str.slice(0,i);j=k;k=AMposition(AMnames,st,j);if(k<AMnames.length&&str.slice(0,AMnames[k].length)==AMnames[k]){match=AMnames[k];mk=k;i=match.length;}\nmore=k<AMnames.length&&str.slice(0,AMnames[k].length)>=AMnames[k];}\nAMpreviousSymbol=AMcurrentSymbol;if(match!=\"\"){AMcurrentSymbol=AMsymbols[mk].ttype;return AMsymbols[mk];}\nAMcurrentSymbol=CONST;k=1;st=str.slice(0,1);if(\"0\"<=st&&st<=\"9\")tagst=\"mn\";else tagst=((\"A\">st||st>\"Z\")&&(\"a\">st||st>\"z\")?\"mo\":\"mi\");return{input:st,tag:tagst,output:st,ttype:CONST};}\nvar AMpreviousSymbol,AMcurrentSymbol;function AMparseSexpr(str){var symbol,node,result,result2,i,st,newFrag=document.createDocumentFragment();str=AMremoveCharsAndBlanks(str,0);symbol=AMgetSymbol(str);if(symbol==null||symbol.ttype==RIGHTBRACKET)\nreturn[null,str,null];if(symbol.ttype==DEFINITION){str=symbol.output+AMremoveCharsAndBlanks(str,symbol.input.length);symbol=AMgetSymbol(str);if(symbol==null||symbol.ttype==RIGHTBRACKET)\nreturn[null,str,null];}\nstr=AMremoveCharsAndBlanks(str,symbol.input.length);switch(symbol.ttype){case SPACE:node=AMcreateElementMathML(symbol.tag);node.setAttribute(symbol.atname,symbol.atval);return[node,str,symbol.tag];case UNDEROVER:if(isIE){if(symbol.input.substr(0,4)==\"\\\\big\"){str=\"\\\\\"+symbol.input.substr(4)+str;symbol=AMgetSymbol(str);symbol.ttype=UNDEROVER;str=AMremoveCharsAndBlanks(str,symbol.input.length);}}\nreturn[AMcreateMmlNode(symbol.tag,document.createTextNode(symbol.output)),str,symbol.tag];case CONST:var output=symbol.output;if(isIE){if(symbol.input==\"'\")\noutput=\"\\u2032\";else if(symbol.input==\"''\")\noutput=\"\\u2033\";else if(symbol.input==\"'''\")\noutput=\"\\u2033\\u2032\";else if(symbol.input==\"''''\")\noutput=\"\\u2033\\u2033\";else if(symbol.input==\"\\\\square\")\noutput=\"\\u25A1\";else if(symbol.input.substr(0,5)==\"\\\\frac\"){var denom=symbol.input.substr(6,1);if(denom==\"5\"||denom==\"6\"){str=symbol.input.replace(/\\\\frac/,\"\\\\frac \")+str;return[node,str,symbol.tag];}}}\nnode=AMcreateMmlNode(symbol.tag,document.createTextNode(output));return[node,str,symbol.tag];case LONG:node=AMcreateMmlNode(symbol.tag,document.createTextNode(symbol.output));node.setAttribute(\"minsize\",\"1.5\");node.setAttribute(\"maxsize\",\"1.5\");node=AMcreateMmlNode(\"mover\",node);node.appendChild(AMcreateElementMathML(\"mspace\"));return[node,str,symbol.tag];case STRETCHY:if(isIE&&symbol.input==\"\\\\backslash\")\nsymbol.output=\"\\\\\";node=AMcreateMmlNode(symbol.tag,document.createTextNode(symbol.output));if(symbol.input==\"|\"||symbol.input==\"\\\\vert\"||symbol.input==\"\\\\|\"||symbol.input==\"\\\\Vert\"){node.setAttribute(\"lspace\",\"0em\");node.setAttribute(\"rspace\",\"0em\");}\nnode.setAttribute(\"maxsize\",symbol.atval);if(symbol.rtag!=null)\nreturn[node,str,symbol.rtag];else\nreturn[node,str,symbol.tag];case BIG:var atval=symbol.atval;if(isIE)\natval=symbol.ieval;symbol=AMgetSymbol(str);if(symbol==null)\nreturn[null,str,null];str=AMremoveCharsAndBlanks(str,symbol.input.length);node=AMcreateMmlNode(symbol.tag,document.createTextNode(symbol.output));if(isIE){var space=AMcreateElementMathML(\"mspace\");space.setAttribute(\"height\",atval+\"ex\");node=AMcreateMmlNode(\"mrow\",node);node.appendChild(space);}else{node.setAttribute(\"minsize\",atval);node.setAttribute(\"maxsize\",atval);}\nreturn[node,str,symbol.tag];case LEFTBRACKET:if(symbol.input==\"\\\\left\"){symbol=AMgetSymbol(str);if(symbol!=null){if(symbol.input==\".\")\nsymbol.invisible=true;str=AMremoveCharsAndBlanks(str,symbol.input.length);}}\nresult=AMparseExpr(str,true,false);if(symbol==null||(typeof symbol.invisible==\"boolean\"&&symbol.invisible))\nnode=AMcreateMmlNode(\"mrow\",result[0]);else{node=AMcreateMmlNode(\"mo\",document.createTextNode(symbol.output));node=AMcreateMmlNode(\"mrow\",node);node.appendChild(result[0]);}\nreturn[node,result[1],result[2]];case MATRIX:if(symbol.input==\"\\\\begin{array}\"){var mask=\"\";symbol=AMgetSymbol(str);str=AMremoveCharsAndBlanks(str,0);if(symbol==null)\nmask=\"l\";else{str=AMremoveCharsAndBlanks(str,symbol.input.length);if(symbol.input!=\"{\")\nmask=\"l\";else do{symbol=AMgetSymbol(str);if(symbol!=null){str=AMremoveCharsAndBlanks(str,symbol.input.length);if(symbol.input!=\"}\")\nmask=mask+symbol.input;}}while(symbol!=null&&symbol.input!=\"\"&&symbol.input!=\"}\");}\nresult=AMparseExpr(\"{\"+str,true,true);node=AMcreateMmlNode(\"mtable\",result[0]);mask=mask.replace(/l/g,\"left \");mask=mask.replace(/r/g,\"right \");mask=mask.replace(/c/g,\"center \");node.setAttribute(\"columnalign\",mask);node.setAttribute(\"displaystyle\",\"false\");if(isIE)\nreturn[node,result[1],null];var lspace=AMcreateElementMathML(\"mspace\");lspace.setAttribute(\"width\",\"0.167em\");var rspace=AMcreateElementMathML(\"mspace\");rspace.setAttribute(\"width\",\"0.167em\");var node1=AMcreateMmlNode(\"mrow\",lspace);node1.appendChild(node);node1.appendChild(rspace);return[node1,result[1],null];}else{result=AMparseExpr(\"{\"+str,true,true);node=AMcreateMmlNode(\"mtable\",result[0]);if(isIE)\nnode.setAttribute(\"columnspacing\",\"0.25em\");else\nnode.setAttribute(\"columnspacing\",\"0.167em\");node.setAttribute(\"columnalign\",\"right center left\");node.setAttribute(\"displaystyle\",\"true\");node=AMcreateMmlNode(\"mrow\",node);return[node,result[1],null];}\ncase TEXT:if(str.charAt(0)==\"{\")i=str.indexOf(\"}\");else i=0;if(i==-1)\ni=str.length;st=str.slice(1,i);if(st.charAt(0)==\" \"){node=AMcreateElementMathML(\"mspace\");node.setAttribute(\"width\",\"0.33em\");newFrag.appendChild(node);}\nnewFrag.appendChild(AMcreateMmlNode(symbol.tag,document.createTextNode(st)));if(st.charAt(st.length-1)==\" \"){node=AMcreateElementMathML(\"mspace\");node.setAttribute(\"width\",\"0.33em\");newFrag.appendChild(node);}\nstr=AMremoveCharsAndBlanks(str,i+1);return[AMcreateMmlNode(\"mrow\",newFrag),str,null];case UNARY:result=AMparseSexpr(str);if(result[0]==null)return[AMcreateMmlNode(symbol.tag,document.createTextNode(symbol.output)),str];if(typeof symbol.func==\"boolean\"&&symbol.func){st=str.charAt(0);if(st==\"^\"||st==\"_\"||st==\",\"){return[AMcreateMmlNode(symbol.tag,document.createTextNode(symbol.output)),str,symbol.tag];}else{node=AMcreateMmlNode(\"mrow\",AMcreateMmlNode(symbol.tag,document.createTextNode(symbol.output)));if(isIE){var space=AMcreateElementMathML(\"mspace\");space.setAttribute(\"width\",\"0.167em\");node.appendChild(space);}\nnode.appendChild(result[0]);return[node,result[1],symbol.tag];}}\nif(symbol.input==\"\\\\sqrt\"){if(isIE){var space=AMcreateElementMathML(\"mspace\");space.setAttribute(\"height\",\"1.2ex\");space.setAttribute(\"width\",\"0em\");node=AMcreateMmlNode(symbol.tag,result[0])\nnode.appendChild(space);return[node,result[1],symbol.tag];}else\nreturn[AMcreateMmlNode(symbol.tag,result[0]),result[1],symbol.tag];}else if(typeof symbol.acc==\"boolean\"&&symbol.acc){node=AMcreateMmlNode(symbol.tag,result[0]);var output=symbol.output;if(isIE){if(symbol.input==\"\\\\hat\")\noutput=\"\\u0302\";else if(symbol.input==\"\\\\widehat\")\noutput=\"\\u005E\";else if(symbol.input==\"\\\\bar\")\noutput=\"\\u00AF\";else if(symbol.input==\"\\\\grave\")\noutput=\"\\u0300\";else if(symbol.input==\"\\\\tilde\")\noutput=\"\\u0303\";}\nvar node1=AMcreateMmlNode(\"mo\",document.createTextNode(output));if(symbol.input==\"\\\\vec\"||symbol.input==\"\\\\check\")\nnode1.setAttribute(\"maxsize\",\"1.2\");if(isIE&&symbol.input==\"\\\\bar\")\nnode1.setAttribute(\"maxsize\",\"0.5\");if(symbol.input==\"\\\\underbrace\"||symbol.input==\"\\\\underline\")\nnode1.setAttribute(\"accentunder\",\"true\");else\nnode1.setAttribute(\"accent\",\"true\");node.appendChild(node1);if(symbol.input==\"\\\\overbrace\"||symbol.input==\"\\\\underbrace\")\nnode.ttype=UNDEROVER;return[node,result[1],symbol.tag];}else{if(!isIE&&typeof symbol.codes!=\"undefined\"){for(i=0;i<result[0].childNodes.length;i++)\nif(result[0].childNodes[i].nodeName==\"mi\"||result[0].nodeName==\"mi\"){st=(result[0].nodeName==\"mi\"?result[0].firstChild.nodeValue:result[0].childNodes[i].firstChild.nodeValue);var newst=[];for(var j=0;j<st.length;j++)\nif(st.charCodeAt(j)>64&&st.charCodeAt(j)<91)newst=newst+\nString.fromCharCode(symbol.codes[st.charCodeAt(j)-65]);else newst=newst+st.charAt(j);if(result[0].nodeName==\"mi\")\nresult[0]=AMcreateElementMathML(\"mo\").appendChild(document.createTextNode(newst));else result[0].replaceChild(AMcreateElementMathML(\"mo\").appendChild(document.createTextNode(newst)),result[0].childNodes[i]);}}\nnode=AMcreateMmlNode(symbol.tag,result[0]);node.setAttribute(symbol.atname,symbol.atval);if(symbol.input==\"\\\\scriptstyle\"||symbol.input==\"\\\\scriptscriptstyle\")\nnode.setAttribute(\"displaystyle\",\"false\");return[node,result[1],symbol.tag];}\ncase BINARY:result=AMparseSexpr(str);if(result[0]==null)return[AMcreateMmlNode(\"mo\",document.createTextNode(symbol.input)),str,null];result2=AMparseSexpr(result[1]);if(result2[0]==null)return[AMcreateMmlNode(\"mo\",document.createTextNode(symbol.input)),str,null];if(symbol.input==\"\\\\textcolor\"||symbol.input==\"\\\\colorbox\"){var tclr=str.match(/\\{\\s*([#\\w]+)\\s*\\}/);str=str.replace(/\\{\\s*[#\\w]+\\s*\\}/,\"\");if(tclr!=null){if(IsColorName.test(tclr[1].toLowerCase())){tclr=LaTeXColor[tclr[1].toLowerCase()];}else{tclr=tclr[1];}\nnode=AMcreateElementMathML(\"mstyle\");node.setAttribute(symbol.atval,tclr);node.appendChild(result2[0]);return[node,result2[1],symbol.tag];}}\nif(symbol.input==\"\\\\root\"||symbol.input==\"\\\\stackrel\")newFrag.appendChild(result2[0]);newFrag.appendChild(result[0]);if(symbol.input==\"\\\\frac\")newFrag.appendChild(result2[0]);return[AMcreateMmlNode(symbol.tag,newFrag),result2[1],symbol.tag];case INFIX:str=AMremoveCharsAndBlanks(str,symbol.input.length);return[AMcreateMmlNode(\"mo\",document.createTextNode(symbol.output)),str,symbol.tag];default:return[AMcreateMmlNode(symbol.tag,document.createTextNode(symbol.output)),str,symbol.tag];}}\nfunction AMparseIexpr(str){var symbol,sym1,sym2,node,result,tag,underover;str=AMremoveCharsAndBlanks(str,0);sym1=AMgetSymbol(str);result=AMparseSexpr(str);node=result[0];str=result[1];tag=result[2];symbol=AMgetSymbol(str);if(symbol.ttype==INFIX){str=AMremoveCharsAndBlanks(str,symbol.input.length);result=AMparseSexpr(str);if(result[0]==null)\nresult[0]=AMcreateMmlNode(\"mo\",document.createTextNode(\"\\u25A1\"));str=result[1];tag=result[2];if(symbol.input==\"_\"||symbol.input==\"^\"){sym2=AMgetSymbol(str);tag=null;underover=((sym1.ttype==UNDEROVER)||(node.ttype==UNDEROVER));if(symbol.input==\"_\"&&sym2.input==\"^\"){str=AMremoveCharsAndBlanks(str,sym2.input.length);var res2=AMparseSexpr(str);str=res2[1];tag=res2[2];node=AMcreateMmlNode((underover?\"munderover\":\"msubsup\"),node);node.appendChild(result[0]);node.appendChild(res2[0]);}else if(symbol.input==\"_\"){node=AMcreateMmlNode((underover?\"munder\":\"msub\"),node);node.appendChild(result[0]);}else{node=AMcreateMmlNode((underover?\"mover\":\"msup\"),node);node.appendChild(result[0]);}\nnode=AMcreateMmlNode(\"mrow\",node);}else{node=AMcreateMmlNode(symbol.tag,node);if(symbol.input==\"\\\\atop\"||symbol.input==\"\\\\choose\")\nnode.setAttribute(\"linethickness\",\"0ex\");node.appendChild(result[0]);if(symbol.input==\"\\\\choose\")\nnode=AMcreateMmlNode(\"mfenced\",node);}}\nreturn[node,str,tag];}\nfunction AMparseExpr(str,rightbracket,matrix){var symbol,node,result,i,tag,newFrag=document.createDocumentFragment();do{str=AMremoveCharsAndBlanks(str,0);result=AMparseIexpr(str);node=result[0];str=result[1];tag=result[2];symbol=AMgetSymbol(str);if(node!=undefined){if((tag==\"mn\"||tag==\"mi\")&&symbol!=null&&typeof symbol.func==\"boolean\"&&symbol.func){var space=AMcreateElementMathML(\"mspace\");space.setAttribute(\"width\",\"0.167em\");node=AMcreateMmlNode(\"mrow\",node);node.appendChild(space);}\nnewFrag.appendChild(node);}}while((symbol.ttype!=RIGHTBRACKET)&&symbol!=null&&symbol.output!=\"\");tag=null;if(symbol.ttype==RIGHTBRACKET){if(symbol.input==\"\\\\right\"){str=AMremoveCharsAndBlanks(str,symbol.input.length);symbol=AMgetSymbol(str);if(symbol!=null&&symbol.input==\".\")\nsymbol.invisible=true;if(symbol!=null)\ntag=symbol.rtag;}\nif(symbol!=null)\nstr=AMremoveCharsAndBlanks(str,symbol.input.length);var len=newFrag.childNodes.length;if(matrix&&len>0&&newFrag.childNodes[len-1].nodeName==\"mrow\"&&len>1&&newFrag.childNodes[len-2].nodeName==\"mo\"&&newFrag.childNodes[len-2].firstChild.nodeValue==\"&\"){var pos=[];var m=newFrag.childNodes.length;for(i=0;matrix&&i<m;i=i+2){pos[i]=[];node=newFrag.childNodes[i];for(var j=0;j<node.childNodes.length;j++)\nif(node.childNodes[j].firstChild.nodeValue==\"&\")\npos[i][pos[i].length]=j;}\nvar row,frag,n,k,table=document.createDocumentFragment();for(i=0;i<m;i=i+2){row=document.createDocumentFragment();frag=document.createDocumentFragment();node=newFrag.firstChild;n=node.childNodes.length;k=0;for(j=0;j<n;j++){if(typeof pos[i][k]!=\"undefined\"&&j==pos[i][k]){node.removeChild(node.firstChild);row.appendChild(AMcreateMmlNode(\"mtd\",frag));k++;}else frag.appendChild(node.firstChild);}\nrow.appendChild(AMcreateMmlNode(\"mtd\",frag));if(newFrag.childNodes.length>2){newFrag.removeChild(newFrag.firstChild);newFrag.removeChild(newFrag.firstChild);}\ntable.appendChild(AMcreateMmlNode(\"mtr\",row));}\nreturn[table,str];}\nif(typeof symbol.invisible!=\"boolean\"||!symbol.invisible){node=AMcreateMmlNode(\"mo\",document.createTextNode(symbol.output));newFrag.appendChild(node);}}\nreturn[newFrag,str,tag];}\nfunction AMparseMath(str){var result,node=AMcreateElementMathML(\"mstyle\");var cclr=str.match(/\\\\color\\s*\\{\\s*([#\\w]+)\\s*\\}/);str=str.replace(/\\\\color\\s*\\{\\s*[#\\w]+\\s*\\}/g,\"\");if(cclr!=null){if(IsColorName.test(cclr[1].toLowerCase())){cclr=LaTeXColor[cclr[1].toLowerCase()];}else{cclr=cclr[1];}\nnode.setAttribute(\"mathcolor\",cclr);}else{if(mathcolor!=\"\")node.setAttribute(\"mathcolor\",mathcolor);};if(mathfontfamily!=\"\")node.setAttribute(\"fontfamily\",mathfontfamily);node.appendChild(AMparseExpr(str.replace(/^\\s+/g,\"\"),false,false)[0]);node=AMcreateMmlNode(\"math\",node);if(showasciiformulaonhover)\nnode.setAttribute(\"title\",str.replace(/\\s+/g,\" \"));if(false){var fnode=AMcreateElementXHTML(\"font\");fnode.setAttribute(\"face\",mathfontfamily);fnode.appendChild(node);return fnode;}\nreturn node;}\nfunction AMstrarr2docFrag(arr,linebreaks){var newFrag=document.createDocumentFragment();var expr=false;for(var i=0;i<arr.length;i++){if(expr)newFrag.appendChild(AMparseMath(arr[i]));else{var arri=(linebreaks?arr[i].split(\"\\n\\n\"):[arr[i]]);newFrag.appendChild(AMcreateElementXHTML(\"span\").appendChild(document.createTextNode(arri[0])));for(var j=1;j<arri.length;j++){newFrag.appendChild(AMcreateElementXHTML(\"p\"));newFrag.appendChild(AMcreateElementXHTML(\"span\").appendChild(document.createTextNode(arri[j])));}}\nexpr=!expr;}\nreturn newFrag;}\nfunction AMprocessNodeR(n,linebreaks){var mtch,str,arr,frg,i;if(n.childNodes.length==0){if((n.nodeType!=8||linebreaks)&&n.parentNode.nodeName!=\"form\"&&n.parentNode.nodeName!=\"FORM\"&&n.parentNode.nodeName!=\"textarea\"&&n.parentNode.nodeName!=\"TEXTAREA\"&&n.parentNode.nodeName!=\"pre\"&&n.parentNode.nodeName!=\"PRE\"){str=n.nodeValue;if(!(str==null)){str=str.replace(/\\r\\n\\r\\n/g,\"\\n\\n\");str=str.replace(/\\x20+/g,\" \");str=str.replace(/\\s*\\r\\n/g,\" \");mtch=(str.indexOf(\"\\$\")==-1?false:true);str=str.replace(/([^\\\\])\\$/g,\"$1 \\$\");str=str.replace(/^\\$/,\" \\$\");arr=str.split(\" \\$\");for(i=0;i<arr.length;i++)\narr[i]=arr[i].replace(/\\\\\\$/g,\"\\$\");if(arr.length>1||mtch){if(checkForMathML){checkForMathML=false;var nd=AMisMathMLavailable();AMnoMathML=nd!=null;if(AMnoMathML&&notifyIfNoMathML)\nif(alertIfNoMathML)\nalert(\"To view the ASCIIMathML notation use Internet Explorer 6 +\\nMathPlayer (free from www.dessci.com)\\nor Firefox/Mozilla/Netscape\");else AMbody.insertBefore(nd,AMbody.childNodes[0]);}\nif(!AMnoMathML){frg=AMstrarr2docFrag(arr,n.nodeType==8);var len=frg.childNodes.length;n.parentNode.replaceChild(frg,n);return len-1;}else return 0;}}}else return 0;}else if(n.nodeName!=\"math\"){for(i=0;i<n.childNodes.length;i++)\ni+=AMprocessNodeR(n.childNodes[i],linebreaks);}\nreturn 0;}\nfunction AMprocessNode(n,linebreaks,spanclassAM){var frag,st;if(spanclassAM!=null){frag=document.getElementsByTagName(\"span\")\nfor(var i=0;i<frag.length;i++)\nif(frag[i].className==\"AM\")\nAMprocessNodeR(frag[i],linebreaks);}else{try{st=n.innerHTML;}catch(err){}\nif(st==null||st.indexOf(\"\\$\")!=-1)\nAMprocessNodeR(n,linebreaks);}\nif(isIE){frag=document.getElementsByTagName('math');for(var i=0;i<frag.length;i++)frag[i].update()}}\nvar inAppendix=false;var sectionCntr=0;var IEcommentWarning=true;var biblist=[];var bibcntr=0;var LaTeXCounter=[];LaTeXCounter[\"definition\"]=0;LaTeXCounter[\"proposition\"]=0;LaTeXCounter[\"lemma\"]=0;LaTeXCounter[\"theorem\"]=0;LaTeXCounter[\"corollary\"]=0;LaTeXCounter[\"example\"]=0;LaTeXCounter[\"exercise\"]=0;LaTeXCounter[\"subsection\"]=0;LaTeXCounter[\"subsubsection\"]=0;LaTeXCounter[\"figure\"]=0;LaTeXCounter[\"equation\"]=0;LaTeXCounter[\"table\"]=0;var LaTeXColor=[];LaTeXColor[\"greenyellow\"]=\"#D9FF4F\";LaTeXColor[\"yellow\"]=\"#FFFF00\";LaTeXColor[\"goldenrod\"]=\"#FFE529\";LaTeXColor[\"dandelion\"]=\"#FFB529\";LaTeXColor[\"apricot\"]=\"#FFAD7A\";LaTeXColor[\"peach\"]=\"#FF804D\";LaTeXColor[\"melon\"]=\"#FF8A80\";LaTeXColor[\"yelloworange\"]=\"#FF9400\";LaTeXColor[\"orange\"]=\"#FF6321\";LaTeXColor[\"burntorange\"]=\"#FF7D00\";LaTeXColor[\"bittersweet\"]=\"#C20300\";LaTeXColor[\"redorange\"]=\"#FF3B21\";LaTeXColor[\"mahogany\"]=\"#A60000\";LaTeXColor[\"maroon\"]=\"#AD0000\";LaTeXColor[\"brickred\"]=\"#B80000\";LaTeXColor[\"red\"]=\"#FF0000\";LaTeXColor[\"orangered\"]=\"#FF0080\";LaTeXColor[\"rubinered\"]=\"#FF00DE\";LaTeXColor[\"wildstrawberry\"]=\"#FF0A9C\";LaTeXColor[\"salmon\"]=\"#FF789E\";LaTeXColor[\"carnationpink\"]=\"#FF5EFF\";LaTeXColor[\"magenta\"]=\"#FF00FF\";LaTeXColor[\"violetred\"]=\"#FF30FF\";LaTeXColor[\"rhodamine\"]=\"#FF2EFF\";LaTeXColor[\"mulberry\"]=\"#A314FA\";LaTeXColor[\"redviolet\"]=\"#9600A8\";LaTeXColor[\"fuchsia\"]=\"#7303EB\";LaTeXColor[\"lavender\"]=\"#FF85FF\";LaTeXColor[\"thistle\"]=\"#E069FF\";LaTeXColor[\"orchid\"]=\"#AD5CFF\";LaTeXColor[\"darkorchid\"]=\"#9933CC\";LaTeXColor[\"purple\"]=\"#8C24FF\";LaTeXColor[\"plum\"]=\"#8000FF\";LaTeXColor[\"violet\"]=\"#361FFF\";LaTeXColor[\"royalpurple\"]=\"#401AFF\";LaTeXColor[\"blueviolet\"]=\"#1A0DF5\";LaTeXColor[\"periwinkle\"]=\"#6E73FF\";LaTeXColor[\"cadetblue\"]=\"#616EC4\";LaTeXColor[\"cornflowerblue\"]=\"#59DEFF\";LaTeXColor[\"midnightblue\"]=\"#007091\";LaTeXColor[\"navyblue\"]=\"#0F75FF\";LaTeXColor[\"royalblue\"]=\"#0080FF\";LaTeXColor[\"blue\"]=\"#0000FF\";LaTeXColor[\"cerulean\"]=\"#0FE3FF\";LaTeXColor[\"cyan\"]=\"#00FFFF\";LaTeXColor[\"processblue\"]=\"#0AFFFF\";LaTeXColor[\"skyblue\"]=\"#61FFE0\";LaTeXColor[\"turquoise\"]=\"#26FFCC\";LaTeXColor[\"tealblue\"]=\"#1FFAA3\";LaTeXColor[\"aquamarine\"]=\"#2EFFB2\";LaTeXColor[\"bluegreen\"]=\"#26FFAB\";LaTeXColor[\"emerald\"]=\"#00FF80\";LaTeXColor[\"junglegreen\"]=\"#03FF7A\";LaTeXColor[\"seagreen\"]=\"#4FFF80\";LaTeXColor[\"green\"]=\"#00FF00\";LaTeXColor[\"forestgreen\"]=\"#00E000\";LaTeXColor[\"pinegreen\"]=\"#00BF29\";LaTeXColor[\"limegreen\"]=\"#80FF00\";LaTeXColor[\"yellowgreen\"]=\"#8FFF42\";LaTeXColor[\"springgreen\"]=\"#BDFF3D\";LaTeXColor[\"olivegreen\"]=\"#009900\";LaTeXColor[\"rawsienna\"]=\"#8C0000\";LaTeXColor[\"sepia\"]=\"#4D0000\";LaTeXColor[\"brown\"]=\"#660000\";LaTeXColor[\"tan\"]=\"#DB9470\";LaTeXColor[\"gray\"]=\"#808080\";LaTeXColor[\"grey\"]=\"#808080\";LaTeXColor[\"black\"]=\"#000000\";LaTeXColor[\"white\"]=\"#FFFFFF\";var IsColorName=/^(?:greenyellow|yellow|goldenrod|dandelion|apricot|peach|melon|yelloworange|orange|burntorange|bittersweet|redorange|mahogany|maroon|brickred|red|orangered|rubinered|wildstrawberry|salmon|carnationpink|magenta|violetred|rhodamine|mulberry|redviolet|fuchsia|lavender|thistle|orchid|darkorchid|purple|plum|violet|royalpurple|blueviolet|periwinkle|cadetblue|cornflowerblue|midnightblue|navyblue|royalblue|blue|cerulean|cyan|processblue|skyblue|turquoise|tealblue|aquamarine|bluegreen|emerald|junglegreen|seagreen|green|forestgreen|pinegreen|limegreen|yellowgreen|springgreen|olivegreen|rawsienna|sepia|brown|tan|gray|grey|black|white)$/;var IsCounter=/^(?:definition|proposition|lemma|theorem|corollary|example|exercise|subsection|subsubsection|figure|equation|table)$/;var IsLaTeXElement=/^(?:displayequation|title|author|address|date|abstract|keyword|section|subsection|subsubsection|ref|cite|thebibliography|definition|proposition|lemma|theorem|corollary|example|exercise|itemize|enumerate|enddefinition|endproposition|endlemma|endtheorem|endcorollary|endexample|endexercise|enditemize|endenumerate|LaTeXMathMLlabel|LaTeXMathML|smallskip|medskip|bigskip|quote|quotation|endquote|endquotation|center|endcenter|description|enddescription|inlinemath)$/;var IsTextOnlyArea=/^(?:form|textarea|pre)$/i;var tableid=0;function makeNumberString(cntr){if(sectionCntr>0){if(inAppendix){return\"A\"+sectionCntr+\".\"+cntr;}else{return sectionCntr+\".\"+cntr;}}else{return\"\"+cntr;}};function LaTeXpreProcess(thebody){var TheBody=thebody;if(TheBody.hasChildNodes()){if(!(IsLaTeXElement.test(TheBody.className)))\n{for(var i=0;i<TheBody.childNodes.length;i++){LaTeXpreProcess(TheBody.childNodes[i])}}}\nelse{if(TheBody.nodeType==3&&!(IsTextOnlyArea.test(TheBody.parentNode.nodeName)))\n{var str=TheBody.nodeValue;if(!(str==null)){str=str.replace(/\\\\%/g,\"<per>\");str=str.replace(/%[^\\n]*(?=\\n)/g,\"\");str=str.replace(/%[^\\r]*(?=\\r)/g,\"\");str=str.replace(/%[^\\n]*$/,\"\")\nif(isIE&&str.match(/%/g)!=null&&IEcommentWarning){alert(\"Comments may not have parsed properly.  Try putting in <pre class='LaTeX><div>..</div></pre> structure.\");IEcommentWarning=false;}\nstr=str.replace(/<per>/g,\"%\");if(str.match(/XXX[\\s\\S]*/)!=null){var tmp=str.match(/XXX[\\s\\S]*/)[0];var tmpstr=tmp.charCodeAt(7)+\"::\"+tmp.charCodeAt(8)+\"::\"+tmp.charCodeAt(9)+\"::\"+tmp.charCodeAt(10)+\"::\"+tmp.charCodeAt(11)+\"::\"+tmp.charCodeAt(12)+\"::\"+tmp.charCodeAt(13);alert(tmpstr);}\nstr=str.replace(/([^\\\\])\\\\(\\s)/g,\"$1\\u00A0$2\");str=str.replace(/\\\\quad/g,\"\\u2001\");str=str.replace(/\\\\qquad/g,\"\\u2001\\u2001\");str=str.replace(/\\\\enspace/g,\"\\u2002\");str=str.replace(/\\\\;/g,\"\\u2004\");str=str.replace(/\\\\:/g,\"\\u2005\");str=str.replace(/\\\\,/g,\"\\u2006\");str=str.replace(/\\\\thinspace/g,\"\\u200A\");str=str.replace(/([^\\\\])~/g,\"$1\\u00A0\");str=str.replace(/\\\\~/g,\"~\");str=str.replace(/\\\\\\[/g,\" <DEQ> $\\\\displaystyle{\");str=str.replace(/\\\\\\]/g,\"}$ <DEQ> \");str=str.replace(/\\$\\$/g,\"${$<DEQ>$}$\");str=str.replace(/\\\\begin\\s*\\{\\s*array\\s*\\}/g,\"\\\\begin{array}\");str=str.replace(/\\\\end\\s*\\{\\s*array\\s*\\}/g,\"\\\\end{array}\");str=str.replace(/\\\\begin\\s*\\{\\s*eqnarray\\s*\\}/g,\"  <DEQ>eqno$\\\\begin{eqnarray}\");str=str.replace(/\\\\end\\s*\\{\\s*eqnarray\\s*\\}/g,\"\\\\end{eqnarray}$<DEQ>  \");str=str.replace(/\\\\begin\\s*\\{\\s*eqnarray\\*\\s*\\}/g,\"  <DEQ>$\\\\begin{eqnarray}\");str=str.replace(/\\\\end\\s*\\{\\s*eqnarray\\*\\s*\\}/g,\"\\\\end{eqnarray}$<DEQ>  \");str=str.replace(/\\\\begin\\s*\\{\\s*displaymath\\s*\\}/g,\" <DEQ> $\\\\displaystyle{\");str=str.replace(/\\\\end\\s*\\{\\s*displaymath\\s*\\}/g,\"}$ <DEQ> \");str=str.replace(/\\\\begin\\s*\\{\\s*equation\\s*\\*\\s*\\}/g,\" <DEQ> $\\\\displaystyle{\");str=str.replace(/\\\\end\\s*\\{\\s*equation\\s*\\*\\s*\\}/g,\"}$ <DEQ> \");str=str.replace(/\\\\begin\\s*\\{\\s*equation\\s*\\}/g,\" <DEQ>eqno$\\\\displaystyle{\");str=str.replace(/\\\\end\\s*\\{\\s*equation\\s*\\}/g,\"}$ <DEQ> \");str=str.split(\"<DEQ>\");var newFrag=document.createDocumentFragment();for(var i=0;i<str.length;i++){if(i%2){var DEQtable=document.createElement(\"table\");DEQtable.className='displayequation';var DEQtbody=document.createElement(\"tbody\");var DEQtr=document.createElement(\"tr\");var DEQtdeq=document.createElement(\"td\");DEQtdeq.className='eq';str[i]=str[i].replace(/\\$\\}\\$/g,\"$\\\\displaystyle{\");str[i]=str[i].replace(/\\$\\{\\$/g,\"}\");var lbl=str[i].match(/\\\\label\\s*\\{\\s*(\\w+)\\s*\\}/);var ISeqno=str[i].match(/^eqno/);str[i]=str[i].replace(/^eqno/,\" \");str[i]=str[i].replace(/\\\\label\\s*\\{\\s*\\w+\\s*\\}/,\" \");DEQtdeq.appendChild(document.createTextNode(str[i]));DEQtr.appendChild(DEQtdeq);str[i]=str[i].replace(/\\\\nonumber/g,\"\");if(ISeqno!=null||lbl!=null){var DEQtdno=document.createElement(\"td\");DEQtdno.className='eqno';LaTeXCounter[\"equation\"]++;var eqnoString=makeNumberString(LaTeXCounter[\"equation\"]);var DEQanchor=document.createElement(\"a\");if(lbl!=null){DEQanchor.id=lbl[1]};DEQanchor.className=\"eqno\";var anchorSpan=document.createElement(\"span\");anchorSpan.className=\"eqno\";anchorSpan.style.display=\"none\";anchorSpan.appendChild(document.createTextNode(eqnoString));DEQanchor.appendChild(anchorSpan);DEQtdno.appendChild(DEQanchor);var DEQspan=document.createElement(\"span\");DEQspan.className=\"eqno\";DEQspan.appendChild(document.createTextNode(\"(\"+eqnoString+\")\"));DEQtdno.appendChild(DEQspan);DEQtr.appendChild(DEQtdno);}\nDEQtbody.appendChild(DEQtr);DEQtable.appendChild(DEQtbody);newFrag.appendChild(DEQtable);}\nelse{str[i]=str[i].replace(/\\$\\}\\$/g,\"\");str[i]=str[i].replace(/\\$\\{\\$/g,\"\");str[i]=str[i].replace(/\\\\maketitle/g,\"\");str[i]=str[i].replace(/\\\\begin\\s*\\{\\s*document\\s*\\}/g,\"\");str[i]=str[i].replace(/\\\\end\\s*\\{\\s*document\\s*\\}/g,\"\");str[i]=str[i].replace(/\\\\documentclass[^\\}]*?\\}/g,\"\");str[i]=str[i].replace(/\\\\usepackage[^\\}]*?\\}/g,\"\");str[i]=str[i].replace(/\\\\noindent/g,\"\");str[i]=str[i].replace(/\\\\notag/g,\"\");str[i]=str[i].replace(/\\\\ref\\s*\\{\\s*(\\w+)\\}/g,\" \\\\[ref\\\\]$1\\\\[ \");str[i]=str[i].replace(/\\\\url\\s*\\{\\s*([^\\}\\n]+)\\}/g,\" \\\\[url\\\\]$1\\\\[ \");str[i]=str[i].replace(/\\\\href\\s*\\{\\s*([^\\}]+)\\}\\s*\\{\\s*([^\\}]+)\\}/g,\" \\\\[href\\\\]$1\\\\]$2\\\\[ \");str[i]=str[i].replace(/\\\\cite\\s*\\{\\s*(\\w+)\\}/g,\" \\\\[cite\\\\]$1\\\\[ \");str[i]=str[i].replace(/\\\\qed/g,\"\\u220E\");str[i]=str[i].replace(/\\\\endproof/g,\"\\u220E\");str[i]=str[i].replace(/\\\\proof/g,\"\\\\textbf{Proof: }\");str[i]=str[i].replace(/\\\\n(?=\\s)/g,\" \\\\[br\\\\] \\\\[ \");str[i]=str[i].replace(/\\\\newline/g,\" \\\\[br\\\\] \\\\[ \");str[i]=str[i].replace(/\\\\linebreak/g,\" \\\\[br\\\\] \\\\[ \");str[i]=str[i].replace(/\\\\smallskip/g,\" \\\\[logicalbreak\\\\]smallskip\\\\[ \");str[i]=str[i].replace(/\\\\medskip/g,\" \\\\[logicalbreak\\\\]medskip\\\\[ \");str[i]=str[i].replace(/\\\\bigskip/g,\" \\\\[logicalbreak\\\\]bigskip\\\\[ \");str[i]=str[i].replace(/[\\n\\r]+[ \\f\\n\\r\\t\\v\\u2028\\u2029]*[\\n\\r]+/g,\" \\\\[logicalbreak\\\\]LaTeXMathML\\\\[ \");if(isIE){str[i]=str[i].replace(/\\r/g,\" \");}\nstr[i]=str[i].replace(/\\\\bibitem\\s*([^\\{]*\\{\\s*\\w*\\s*\\})/g,\" \\\\[bibitem\\\\]$1\\\\[ \");str[i]=str[i].replace(/\\\\bibitem\\s*/g,\" \\\\[bibitem\\\\] \\\\[ \");str[i]=str[i].replace(/\\\\item\\s*\\[\\s*(\\w+)\\s*\\]/g,\" \\\\[alistitem\\\\]$1\\\\[ \");str[i]=str[i].replace(/\\\\item\\s*/g,\" \\\\[alistitem\\\\] \\\\[ \");str[i]=str[i].replace(/\\\\appendix/g,\" \\\\[appendix\\\\] \\\\[ \");str[i]=str[i].replace(/\\\\begin\\s*\\{\\s*figure\\s*\\}([\\s\\S]+?)\\\\end\\s*\\{\\s*figure\\s*\\}/g,\" \\\\[figure\\\\]$1\\\\[ \");str[i]=str[i].replace(/\\\\begin\\s*\\{\\s*table\\s*\\}([\\s\\S]+?)\\\\end\\s*\\{\\s*table\\s*\\}/g,\" \\\\[table\\\\]$1\\\\[ \");str[i]=str[i].replace(/\\\\begin\\s*\\{\\s*theorem\\s*\\}/g,\" \\\\[theorem\\\\]Theorem \\\\[ \");str[i]=str[i].replace(/\\\\end\\s*\\{\\s*theorem\\s*\\}/g,\" \\\\[endtheorem\\\\] \\\\[ \");str[i]=str[i].replace(/\\\\begin\\s*\\{\\s*definition\\s*\\}/g,\" \\\\[definition\\\\]Definition \\\\[ \");str[i]=str[i].replace(/\\\\end\\s*\\{\\s*definition\\s*\\}/g,\" \\\\[enddefinition\\\\] \\\\[ \");str[i]=str[i].replace(/\\\\begin\\s*\\{\\s*lemma\\s*\\}/g,\" \\\\[lemma\\\\]Lemma \\\\[ \");str[i]=str[i].replace(/\\\\end\\s*\\{\\s*lemma\\s*\\}/g,\" \\\\[endlemma\\\\] \\\\[ \");str[i]=str[i].replace(/\\\\begin\\s*\\{\\s*corollary\\s*\\}/g,\" \\\\[corollary\\\\]Corollary \\\\[ \");str[i]=str[i].replace(/\\\\end\\s*\\{\\s*corollary\\s*\\}/g,\" \\\\[endcorollary\\\\] \\\\[ \");str[i]=str[i].replace(/\\\\begin\\s*\\{\\s*proposition\\s*\\}/g,\" \\\\[proposition\\\\]Proposition \\\\[ \");str[i]=str[i].replace(/\\\\end\\s*\\{\\s*proposition\\s*\\}/g,\" \\\\[endproposition\\\\] \\\\[ \");str[i]=str[i].replace(/\\\\begin\\s*\\{\\s*example\\s*\\}/g,\" \\\\[example\\\\]Example \\\\[ \");str[i]=str[i].replace(/\\\\end\\s*\\{\\s*example\\s*\\}/g,\" \\\\[endexample\\\\] \\\\[ \");str[i]=str[i].replace(/\\\\begin\\s*\\{\\s*exercise\\s*\\}/g,\" \\\\[exercise\\\\]Exercise \\\\[ \");str[i]=str[i].replace(/\\\\end\\s*\\{\\s*exercise\\s*\\}/g,\" \\\\[endexercise\\\\] \\\\[ \");str[i]=str[i].replace(/\\\\begin\\s*\\{\\s*thebibliography\\s*\\}\\s*\\{\\s*\\w+\\s*\\}/g,\" \\\\[thebibliography\\\\]References \\\\[ \");str[i]=str[i].replace(/\\\\begin\\s*\\{\\s*thebibliography\\s*\\}/g,\" \\\\[thebibliography\\\\]References \\\\[ \");str[i]=str[i].replace(/\\\\end\\s*\\{\\s*thebibliography\\s*\\}/g,\" \\\\[endthebibliography\\\\]References \\\\[ \");str[i]=str[i].replace(/\\\\begin\\s*\\{\\s*proof\\s*\\}/g,\" \\\\[proof\\\\]Proof: \\\\[ \");if(isIE){str[i]=str[i].replace(/\\\\end\\s*\\{\\s*proof\\s*\\}/g,\"\\u220E \\\\[endproof\\\\] \\\\[ \");}else{str[i]=str[i].replace(/\\\\end\\s*\\{\\s*proof\\s*\\}/g,\" \\\\[endproof\\\\] \\\\[ \");}\nstr[i]=str[i].replace(/\\\\title\\s*\\{\\s*([^\\}]+)\\}/g,\" \\\\[title\\\\] \\\\[$1 \\\\[endtitle\\\\] \\\\[ \");str[i]=str[i].replace(/\\\\author\\s*\\{\\s*([^\\}]+)\\}/g,\" \\\\[author\\\\] \\\\[$1 \\\\[endauthor\\\\] \\\\[ \");str[i]=str[i].replace(/\\\\address\\s*\\{\\s*([^\\}]+)\\}/g,\" \\\\[address\\\\] \\\\[$1 \\\\[endaddress\\\\] \\\\[ \");str[i]=str[i].replace(/\\\\date\\s*\\{\\s*([^\\}]+)\\}/g,\" \\\\[date\\\\] \\\\[$1 \\\\[enddate\\\\] \\\\[ \");str[i]=str[i].replace(/\\\\begin\\s*\\{\\s*keyword\\s*\\}/g,\" \\\\[keyword\\\\] \\\\[ \");str[i]=str[i].replace(/\\\\end\\s*\\{\\s*keyword\\s*\\}/g,\" \\\\[endkeyword\\\\] \\\\[ \");str[i]=str[i].replace(/\\\\begin\\s*\\{\\s*abstract\\s*\\}/g,\" \\\\[abstract\\\\] \\\\[ \");str[i]=str[i].replace(/\\\\end\\s*\\{\\s*abstract\\s*\\}/g,\" \\\\[endabstract\\\\] \\\\[ \");str[i]=str[i].replace(/\\\\begin\\s*\\{\\s*(?!array|tabular)(\\w+)\\s*\\}/g,\" \\\\[$1\\\\] \\\\[ \");str[i]=str[i].replace(/\\\\end\\s*\\{\\s*(?!array|tabular)(\\w+)\\s*\\}/g,\" \\\\[end$1\\\\] \\\\[ \");var sectionIndex=str[i].search(/\\\\section\\s*\\{\\s*[\\s\\S]+\\}/);while(sectionIndex>=0){str[i]=str[i].replace(/\\\\section\\s*\\{/,\" \\\\[section\\\\]\");var delimcnt=1;for(var ii=sectionIndex;ii<str[i].length;ii++){if(str[i].charAt(ii)==\"{\"){delimcnt++};if(str[i].charAt(ii)==\"}\"){delimcnt--};if(delimcnt==0){str[i]=str[i].substring(0,ii)+\"\\\\[ \"+str[i].substring(ii+1,str[i].length);break;}};sectionIndex=str[i].search(/\\\\section\\s*\\{\\s*[\\s\\S]+\\}/);}\nsectionIndex=str[i].search(/\\\\subsection\\s*\\{\\s*[\\s\\S]+\\}/);while(sectionIndex>=0){str[i]=str[i].replace(/\\\\subsection\\s*\\{/,\" \\\\[subsection\\\\]\");var delimcnt=1;for(var ii=sectionIndex;ii<str[i].length;ii++){if(str[i].charAt(ii)==\"{\"){delimcnt++};if(str[i].charAt(ii)==\"}\"){delimcnt--};if(delimcnt==0){str[i]=str[i].substring(0,ii)+\"\\\\[ \"+str[i].substring(ii+1,str[i].length);break;}};sectionIndex=str[i].search(/\\\\subsection\\s*\\{\\s*[\\s\\S]+\\}/);}\nsectionIndex=str[i].search(/\\\\subsubsection\\s*\\{\\s*[\\s\\S]+\\}/);while(sectionIndex>=0){str[i]=str[i].replace(/\\\\subsubsection\\s*\\{/,\" \\\\[subsubsection\\\\]\");var delimcnt=1;for(var ii=sectionIndex;ii<str[i].length;ii++){if(str[i].charAt(ii)==\"{\"){delimcnt++};if(str[i].charAt(ii)==\"}\"){delimcnt--};if(delimcnt==0){str[i]=str[i].substring(0,ii)+\"\\\\[ \"+str[i].substring(ii+1,str[i].length);break;}};sectionIndex=str[i].search(/\\\\subsubsection\\s*\\{\\s*[\\s\\S]+\\}/);}\nvar CatToNextEven=\"\";var strtmp=str[i].split(\"\\\\[\");for(var j=0;j<strtmp.length;j++){if(j%2){var strtmparray=strtmp[j].split(\"\\\\]\");switch(strtmparray[0]){case\"section\":var nodeTmp=document.createElement(\"H2\");nodeTmp.className='section';sectionCntr++;for(var div in LaTeXCounter){LaTeXCounter[div]=0};var nodeAnchor=document.createElement(\"a\");if(inAppendix){nodeAnchor.className='appendixsection';}else{nodeAnchor.className='section';}\nvar nodeNumString=makeNumberString(\"\");var anchorSpan=document.createElement(\"span\");anchorSpan.className=\"section\";anchorSpan.style.display=\"none\";anchorSpan.appendChild(document.createTextNode(nodeNumString));nodeAnchor.appendChild(anchorSpan);nodeTmp.appendChild(nodeAnchor);var nodeSpan=document.createElement(\"span\");nodeSpan.className='section';nodeSpan.appendChild(document.createTextNode(nodeNumString+\" \"));nodeTmp.appendChild(nodeSpan);nodeTmp.appendChild(document.createTextNode(strtmparray[1]));newFrag.appendChild(nodeTmp);break;case\"subsection\":var nodeTmp=document.createElement(\"H3\");nodeTmp.className='subsection';LaTeXCounter[\"subsection\"]++;LaTeXCounter[\"subsubsection\"]=0;var nodeAnchor=document.createElement(\"a\");nodeAnchor.className='subsection';var nodeNumString=makeNumberString(LaTeXCounter[\"subsection\"]);var anchorSpan=document.createElement(\"span\");anchorSpan.className=\"subsection\";anchorSpan.style.display=\"none\";anchorSpan.appendChild(document.createTextNode(nodeNumString));nodeAnchor.appendChild(anchorSpan);nodeTmp.appendChild(nodeAnchor);var nodeSpan=document.createElement(\"span\");nodeSpan.className='subsection';nodeSpan.appendChild(document.createTextNode(nodeNumString+\". \"));nodeTmp.appendChild(nodeSpan);nodeTmp.appendChild(document.createTextNode(strtmparray[1]));newFrag.appendChild(nodeTmp);break;case\"subsubsection\":var nodeTmp=document.createElement(\"H4\");nodeTmp.className='subsubsection';LaTeXCounter[\"subsubsection\"]++;var nodeAnchor=document.createElement(\"a\");nodeAnchor.className='subsubsection';var nodeNumString=makeNumberString(LaTeXCounter[\"subsection\"]+\".\"+LaTeXCounter[\"subsubsection\"]);var anchorSpan=document.createElement(\"span\");anchorSpan.className=\"subsubsection\";anchorSpan.style.display=\"none\";anchorSpan.appendChild(document.createTextNode(nodeNumString));nodeAnchor.appendChild(anchorSpan);nodeTmp.appendChild(nodeAnchor);var nodeSpan=document.createElement(\"span\");nodeSpan.className='subsubsection';nodeSpan.appendChild(document.createTextNode(nodeNumString+\". \"));nodeTmp.appendChild(nodeSpan);nodeTmp.appendChild(document.createTextNode(strtmparray[1]));newFrag.appendChild(nodeTmp);break;case\"href\":var nodeTmp=document.createElement(\"a\");nodeTmp.className='LaTeXMathML';nodeTmp.href=strtmparray[1];nodeTmp.appendChild(document.createTextNode(strtmparray[2]));newFrag.appendChild(nodeTmp);break;case\"url\":var nodeTmp=document.createElement(\"a\");nodeTmp.className='LaTeXMathML';nodeTmp.href=strtmparray[1];nodeTmp.appendChild(document.createTextNode(strtmparray[1]));newFrag.appendChild(nodeTmp);break;case\"figure\":var nodeTmp=document.createElement(\"table\");nodeTmp.className='figure';var FIGtbody=document.createElement(\"tbody\");var FIGlbl=strtmparray[1].match(/\\\\label\\s*\\{\\s*(\\w+)\\s*\\}/);strtmparray[1]=strtmparray[1].replace(/\\\\label\\s*\\{\\w+\\}/g,\"\");var capIndex=strtmparray[1].search(/\\\\caption\\s*\\{[\\s\\S]+\\}/);var FIGcap=\"\";if(capIndex>=0){var tmp=strtmparray[1];var delimcnt=0;var capstart=-1;for(var pos=capIndex;pos<tmp.length;pos++){if(tmp.charAt(pos)==\"{\"){delimcnt++};if(tmp.charAt(pos)==\"}\"){delimcnt--};if(delimcnt==1&&capstart<0){capstart=pos+1};if(delimcnt==0&&capstart>0){capend=pos-1;FIGcap=tmp.substring(capstart,pos);break}}}\nvar FIGtr2=document.createElement(\"tr\");var FIGtd2=document.createElement(\"td\");FIGtd2.className=\"caption\";var FIGanchor=document.createElement(\"a\");FIGanchor.className=\"figure\";if(FIGlbl!=null){FIGanchor.id=FIGlbl[1];}\nLaTeXCounter[\"figure\"]++;var fignmbr=makeNumberString(LaTeXCounter[\"figure\"]);var anchorSpan=document.createElement(\"span\");anchorSpan.className=\"figure\";anchorSpan.style.display=\"none\";anchorSpan.appendChild(document.createTextNode(fignmbr));FIGanchor.appendChild(anchorSpan);FIGtd2.appendChild(FIGanchor);var FIGspan=document.createElement(\"span\");FIGspan.className=\"figure\";FIGspan.appendChild(document.createTextNode(\"Figure \"+fignmbr+\". \"));FIGtd2.appendChild(FIGspan);FIGtd2.appendChild(document.createTextNode(\"\"+FIGcap));FIGtr2.appendChild(FIGtd2);FIGtbody.appendChild(FIGtr2);var IsSpecial=false;var FIGinfo=strtmparray[1].match(/\\\\includegraphics\\s*\\{([^\\}]+)\\}/);if(FIGinfo==null){FIGinfo=strtmparray[1].match(/\\\\includegraphics\\s*\\[[^\\]]*\\]\\s*\\{\\s*([^\\}]+)\\s*\\}/);}\nif(FIGinfo==null){FIGinfo=strtmparray[1].match(/\\\\special\\s*\\{\\s*([^\\}]+)\\}/);IsSpecial=true};if(FIGinfo!=null){var FIGtr1=document.createElement(\"tr\");var FIGtd1=document.createElement(\"td\");FIGtd1.className=\"image\";var FIGimg=document.createElement(\"img\");var FIGsrc=FIGinfo[1];FIGimg.src=FIGsrc;FIGimg.alt=\"Figure \"+FIGsrc+\" did not load\";FIGimg.title=\"Figure \"+fignmbr+\". \"+FIGcap;FIGimg.id=\"figure\"+fignmbr;FIGtd1.appendChild(FIGimg);FIGtr1.appendChild(FIGtd1);FIGtbody.appendChild(FIGtr1);}\nnodeTmp.appendChild(FIGtbody);newFrag.appendChild(nodeTmp);break;case\"table\":var nodeTmp=document.createElement(\"table\");if(strtmparray[1].search(/\\\\centering/)>=0){nodeTmp.className='LaTeXtable centered';nodeTmp.align=\"center\";}else{nodeTmp.className='LaTeXtable';};tableid++;nodeTmp.id=\"LaTeXtable\"+tableid;var TABlbl=strtmparray[1].match(/\\\\label\\s*\\{\\s*(\\w+)\\s*\\}/);strtmparray[1]=strtmparray[1].replace(/\\\\label\\s*\\{\\w+\\}/g,\"\");var capIndex=strtmparray[1].search(/\\\\caption\\s*\\{[\\s\\S]+\\}/);var TABcap=\"\";if(capIndex>=0){var tmp=strtmparray[1];var delimcnt=0;var capstart=-1;for(var pos=capIndex;pos<tmp.length;pos++){if(tmp.charAt(pos)==\"{\"){delimcnt++};if(tmp.charAt(pos)==\"}\"){delimcnt--};if(delimcnt==1&&capstart<0){capstart=pos+1};if(delimcnt==0&&capstart>0){capend=pos-1;TABcap=tmp.substring(capstart,pos);break}}}\nif(TABcap!=\"\"){var TABtbody=document.createElement(\"tbody\");var TABcaption=document.createElement(\"caption\");TABcaption.className=\"LaTeXtable centered\";var TABanchor=document.createElement(\"a\");TABanchor.className=\"LaTeXtable\";if(TABlbl!=null){TABanchor.id=TABlbl[1];}\nLaTeXCounter[\"table\"]++;var tabnmbr=makeNumberString(LaTeXCounter[\"table\"]);var anchorSpan=document.createElement(\"span\");anchorSpan.className=\"LaTeXtable\";anchorSpan.style.display=\"none\";anchorSpan.appendChild(document.createTextNode(tabnmbr));TABanchor.appendChild(anchorSpan);TABcaption.appendChild(TABanchor);var TABspan=document.createElement(\"span\");TABspan.className=\"LaTeXtable\";TABspan.appendChild(document.createTextNode(\"Table \"+tabnmbr+\". \"));TABcaption.appendChild(TABspan);TABcaption.appendChild(document.createTextNode(\"\"+TABcap));nodeTmp.appendChild(TABcaption);}\nvar TABinfo=strtmparray[1].match(/\\\\begin\\s*\\{\\s*tabular\\s*\\}([\\s\\S]+)\\\\end\\s*\\{\\s*tabular\\s*\\}/);if(TABinfo!=null){var TABtbody=document.createElement('tbody');var TABrow=null;var TABcell=null;var row=0;var col=0;var TABalign=TABinfo[1].match(/^\\s*\\{([^\\}]+)\\}/);TABinfo=TABinfo[1].replace(/^\\s*\\{[^\\}]+\\}/,\"\");TABinfo=TABinfo.replace(/\\\\hline/g,\"\");TABalign[1]=TABalign[1].replace(/\\|/g,\"\");TABalign[1]=TABalign[1].replace(/\\s/g,\"\");TABinfo=TABinfo.split(\"\\\\\\\\\");for(row=0;row<TABinfo.length;row++){TABrow=document.createElement(\"tr\");TABinfo[row]=TABinfo[row].split(\"&\");for(col=0;col<TABinfo[row].length;col++){TABcell=document.createElement(\"td\");switch(TABalign[1].charAt(col)){case\"l\":TABcell.align=\"left\";break;case\"c\":TABcell.align=\"center\";break;case\"r\":TABcell.align=\"right\";break;default:TABcell.align=\"left\";};TABcell.appendChild(document.createTextNode(TABinfo[row][col]));TABrow.appendChild(TABcell);}\nTABtbody.appendChild(TABrow);}\nnodeTmp.appendChild(TABtbody);}\nnewFrag.appendChild(nodeTmp);break;case\"logicalbreak\":var nodeTmp=document.createElement(\"p\");nodeTmp.className=strtmparray[1];nodeTmp.appendChild(document.createTextNode(\"\\u00A0\"));newFrag.appendChild(nodeTmp);break;case\"appendix\":inAppendix=true;sectionCntr=0;break;case\"alistitem\":var EndDiv=document.createElement(\"div\");EndDiv.className=\"endlistitem\";newFrag.appendChild(EndDiv);var BegDiv=document.createElement(\"div\");BegDiv.className=\"listitem\";if(strtmparray[1]!=\" \"){var BegSpan=document.createElement(\"span\");BegSpan.className=\"listitemmarker\";var boldBegSpan=document.createElement(\"b\");boldBegSpan.appendChild(document.createTextNode(strtmparray[1]+\" \"));BegSpan.appendChild(boldBegSpan);BegDiv.appendChild(BegSpan);}\nnewFrag.appendChild(BegDiv);break;case\"br\":newFrag.appendChild(document.createElement(\"br\"));break;case\"bibitem\":newFrag.appendChild(document.createElement(\"br\"));var nodeTmp=document.createElement(\"a\");nodeTmp.className='bibitem';var nodeSpan=document.createElement(\"span\");nodeSpan.className='bibitem';bibcntr++;var lbl=strtmparray[1].match(/\\{\\s*(\\w+)\\s*\\}/);strtmparray[1]=strtmparray[1].replace(/\\s*\\{\\s*\\w+\\s*\\}/g,\"\");strtmparray[1]=strtmparray[1].replace(/^\\s*\\[/,\"\");strtmparray[1]=strtmparray[1].replace(/\\s*\\]$/,\"\");strtmparray[1]=strtmparray[1].replace(/^\\s+|\\s+$/g,\"\");if(lbl==null){biblist[bibcntr]=\"bibitem\"+bibcntr}else{biblist[bibcntr]=lbl[1];};nodeTmp.name=biblist[bibcntr];nodeTmp.id=biblist[bibcntr];if(strtmparray[1]!=\"\"){nodeSpan.appendChild(document.createTextNode(strtmparray[1]));}else{nodeSpan.appendChild(document.createTextNode(\"[\"+bibcntr+\"]\"));}\nnodeTmp.appendChild(nodeSpan);newFrag.appendChild(nodeTmp);break;case\"cite\":var nodeTmp=document.createElement(\"a\");nodeTmp.className='cite';nodeTmp.name='cite';nodeTmp.href=\"#\"+strtmparray[1];newFrag.appendChild(nodeTmp);break;case\"ref\":var nodeTmp=document.createElement(\"a\");nodeTmp.className='ref';nodeTmp.name='ref';nodeTmp.href=\"#\"+strtmparray[1];newFrag.appendChild(nodeTmp);break;default:var nodeTmp=document.createElement(\"div\");nodeTmp.className=strtmparray[0];if(IsCounter.test(strtmparray[0])){LaTeXCounter[strtmparray[0]]++;var nodeAnchor=document.createElement(\"a\");nodeAnchor.className=strtmparray[0];var divnum=makeNumberString(LaTeXCounter[strtmparray[0]]);var anchorSpan=document.createElement(\"span\");anchorSpan.className=strtmparray[0];anchorSpan.appendChild(document.createTextNode(divnum));anchorSpan.style.display=\"none\";nodeAnchor.appendChild(anchorSpan);nodeTmp.appendChild(nodeAnchor);var nodeSpan=document.createElement(\"span\");nodeSpan.className=strtmparray[0];nodeSpan.appendChild(document.createTextNode(strtmparray[1]+\" \"+divnum+\". \"));nodeTmp.appendChild(nodeSpan);}\nif(isIE){if(strtmparray[0]==(\"thebibliography\"||\"abstract\"||\"keyword\"||\"proof\")){var nodeSpan=document.createElement(\"span\");nodeSpan.className=strtmparray[0];nodeSpan.appendChild(document.createTextNode(strtmparray[1]));nodeTmp.appendChild(nodeSpan);}}\nif(strtmparray[0]==\"endenumerate\"||strtmparray[0]==\"enditemize\"||strtmparray[0]==\"enddescription\"){var endDiv=document.createElement(\"div\");endDiv.className=\"endlistitem\";newFrag.appendChild(endDiv);}\nnewFrag.appendChild(nodeTmp);if(strtmparray[0]==\"enumerate\"||strtmparray[0]==\"itemize\"||strtmparray[0]==\"description\"){var endDiv=document.createElement(\"div\");endDiv.className=\"listitem\";newFrag.appendChild(endDiv);}}}else{strtmp[j]=strtmp[j].replace(/\\\\\\$/g,\"<per>\");strtmp[j]=strtmp[j].replace(/\\$([^\\$]+)\\$/g,\" \\\\[$1\\\\[ \");strtmp[j]=strtmp[j].replace(/<per>/g,\"\\\\$\");strtmp[j]=strtmp[j].replace(/\\\\begin\\s*\\{\\s*math\\s*\\}([\\s\\S]+?)\\\\end\\s*\\{\\s*math\\s*\\}/g,\" \\\\[$1\\\\[ \");var strtmptmp=strtmp[j].split(\"\\\\[\");for(var jjj=0;jjj<strtmptmp.length;jjj++){if(jjj%2){var nodeTmp=document.createElement(\"span\");nodeTmp.className='inlinemath';nodeTmp.appendChild(document.createTextNode(\"$\"+strtmptmp[jjj]+\"$\"));newFrag.appendChild(nodeTmp);}else{var TagIndex=strtmptmp[jjj].search(/\\\\\\w+/);var tmpIndex=TagIndex;while(tmpIndex>-1){if(/^\\\\textcolor/.test(strtmptmp[jjj].substring(TagIndex,strtmptmp[jjj].length))){strtmptmp[jjj]=strtmptmp[jjj].replace(/\\\\textcolor\\s*\\{\\s*(\\w+)\\s*\\}\\s*/,\" \\\\[textcolor\\\\]$1\\\\]|\");}else{if(/^\\\\colorbox/.test(strtmptmp[jjj].substring(TagIndex,strtmptmp[jjj].length))){strtmptmp[jjj]=strtmptmp[jjj].replace(/\\\\colorbox\\s*\\{\\s*(\\w+)\\s*\\}\\s*/,\" \\\\[colorbox\\\\]$1\\\\]|\");}else{strtmptmp[jjj]=strtmptmp[jjj].substring(0,TagIndex)+strtmptmp[jjj].substring(TagIndex,strtmptmp[jjj].length).replace(/\\\\\\s*(\\w+)\\s*/,\" \\\\[$1\\\\]|\");}}\nTagIndex+=strtmptmp[jjj].substring(TagIndex,strtmptmp[jjj].length).search(/\\|/);TagIndex++;strtmptmp[jjj]=strtmptmp[jjj].replace(/\\\\\\]\\|/,\"\\\\] \");if(strtmptmp[jjj].charAt(TagIndex)==\"{\"){strtmptmp[jjj]=strtmptmp[jjj].substring(0,TagIndex)+strtmptmp[jjj].substring(TagIndex+1,strtmptmp[jjj].length);var delimcnt=1;for(var kk=TagIndex;kk<strtmptmp[jjj].length;kk++){if(strtmptmp[jjj].charAt(kk)==\"{\"){delimcnt++};if(strtmptmp[jjj].charAt(kk)==\"}\"){delimcnt--};if(delimcnt==0){break;}}\nstrtmptmp[jjj]=strtmptmp[jjj].substring(0,kk)+\"\\\\[ \"+strtmptmp[jjj].substring(kk+1,strtmptmp[jjj].length);TagIndex=kk+3;}else{strtmptmp[jjj]=strtmptmp[jjj].substring(0,TagIndex)+\"\\\\[ \"+strtmptmp[jjj].substring(TagIndex+1,strtmptmp[jjj].length);TagIndex=TagIndex+3;}\nif(TagIndex<strtmptmp[jjj].length){tmpIndex=strtmptmp[jjj].substring(TagIndex,strtmptmp[jjj].length).search(/\\\\\\w+/);}\nelse{tmpIndex=-1};TagIndex+=tmpIndex;}\nstrtmptmp[jjj]=strtmptmp[jjj].replace(/\\\\\\\\\\s*\\\\\\\\/g,\"\\\\\\\\\");strtmptmp[jjj]=strtmptmp[jjj].replace(/\\\\\\\\/g,\" \\\\[br\\\\] \\\\[ \");strtmptmp[jjj]=strtmptmp[jjj].replace(/\\\\label\\s*\\{\\s*(\\w+)\\s*\\}/g,\" \\\\[a\\\\]$1\\\\[ \");var strlbls=strtmptmp[jjj].split(\"\\\\[\");for(var jj=0;jj<strlbls.length;jj++){if(jj%2){var strtmparray=strlbls[jj].split(\"\\\\]\");switch(strtmparray[0]){case\"textcolor\":var nodeTmp=document.createElement(\"span\");nodeTmp.className='LaTeXColor';if(IsColorName.test(strtmparray[1].toLowerCase())){nodeTmp.style.color=LaTeXColor[strtmparray[1].toLowerCase()];}else{nodeTmp.style.color=strtmparray[1];};nodeTmp.appendChild(document.createTextNode(strtmparray[2]));newFrag.appendChild(nodeTmp);break;case\"colorbox\":var nodeTmp=document.createElement(\"span\");nodeTmp.className='LaTeXColor';if(IsColorName.test(strtmparray[1].toLowerCase())){nodeTmp.style.background=LaTeXColor[strtmparray[1].toLowerCase()];}else{nodeTmp.style.background=strtmparray[1];};nodeTmp.appendChild(document.createTextNode(strtmparray[2]));newFrag.appendChild(nodeTmp);break;case\"br\":newFrag.appendChild(document.createElement(\"br\"));break;case\"a\":var nodeTmp=document.createElement(\"a\");nodeTmp.className='LaTeXMathMLlabel';nodeTmp.id=strtmparray[1];nodeTmp.style.display=\"none\";newFrag.appendChild(nodeTmp);break;default:var nodeTmp=document.createElement(\"span\");nodeTmp.className=strtmparray[0];nodeTmp.appendChild(document.createTextNode(strtmparray[1]))\nnewFrag.appendChild(nodeTmp);}}else{newFrag.appendChild(document.createTextNode(strlbls[jj]));}}}}}}}};TheBody.parentNode.replaceChild(newFrag,TheBody);}}}\nreturn TheBody;}\nfunction LaTeXDivsAndRefs(thebody){var TheBody=thebody;var EndDivClass=null;var AllDivs=TheBody.getElementsByTagName(\"div\");var lbl2id=\"\";var lblnode=null;for(var i=AllDivs.length-1;i>=0;i--){EndDivClass=AllDivs[i].className.match(/end\\w+/);if(EndDivClass!=null){EndDivClass=EndDivClass[0];var DivClass=EndDivClass.substring(3,EndDivClass.length);var EndDivNode=AllDivs[i];break;}}\nwhile(EndDivClass!=null){var newFrag=document.createDocumentFragment();var RootNode=EndDivNode.parentNode;var ClassCount=1;while(EndDivNode.previousSibling!=null&&ClassCount>0){switch(EndDivNode.previousSibling.className){case EndDivClass:ClassCount++;newFrag.insertBefore(EndDivNode.previousSibling,newFrag.firstChild);break;case DivClass:if(EndDivNode.previousSibling.nodeName==\"DIV\"){ClassCount--;if(lbl2id!=\"\"){EndDivNode.previousSibling.id=lbl2id;lbl2id=\"\"}\nif(ClassCount==0){RootNode=EndDivNode.previousSibling;}else{newFrag.insertBefore(EndDivNode.previousSibling,newFrag.firstChild);}};break;case'LaTeXMathMLlabel':lbl2id=EndDivNode.previousSibling.id;EndDivNode.parentNode.removeChild(EndDivNode.previousSibling);break;default:newFrag.insertBefore(EndDivNode.previousSibling,newFrag.firstChild);}}\nRootNode.appendChild(newFrag);EndDivNode.parentNode.removeChild(EndDivNode);AllDivs=TheBody.getElementsByTagName(\"DIV\");for(i=AllDivs.length-1;i>=0;i--){EndDivClass=AllDivs[i].className.match(/end\\w+/);if(EndDivClass!=null){ClassCount=0;EndDivClass=EndDivClass[0];DivClass=EndDivClass.substring(3,EndDivClass.length);EndDivNode=AllDivs[i];RootNode=EndDivNode.parentNode;break;}}}\nvar AllDivs=TheBody.getElementsByTagName(\"div\");var DIV2LI=null;for(var i=0;i<AllDivs.length;i++){if(AllDivs[i].className==\"itemize\"||AllDivs[i].className==\"enumerate\"||AllDivs[i].className==\"description\"){if(AllDivs[i].className==\"itemize\"){RootNode=document.createElement(\"UL\");}else{RootNode=document.createElement(\"OL\");}\nRootNode.className='LaTeXMathML';if(AllDivs[i].hasChildNodes()){AllDivs[i].removeChild(AllDivs[i].firstChild)};while(AllDivs[i].hasChildNodes()){if(AllDivs[i].firstChild.hasChildNodes()){DIV2LI=document.createElement(\"LI\");while(AllDivs[i].firstChild.hasChildNodes()){DIV2LI.appendChild(AllDivs[i].firstChild.firstChild);}\nif(DIV2LI.firstChild.className==\"listitemmarker\"){DIV2LI.style.listStyleType=\"none\";}\nRootNode.appendChild(DIV2LI)}\nAllDivs[i].removeChild(AllDivs[i].firstChild);}\nAllDivs[i].appendChild(RootNode);}}\nvar AllAnchors=TheBody.getElementsByTagName(\"a\");for(var i=0;i<AllAnchors.length;i++){if(AllAnchors[i].className==\"ref\"||AllAnchors[i].className==\"cite\"){var label=AllAnchors[i].href.match(/\\#(\\w+)/);if(label!=null){var labelNode=document.getElementById(label[1]);if(labelNode!=null){var TheSpans=labelNode.getElementsByTagName(\"SPAN\");if(TheSpans!=null){var refNode=TheSpans[0].cloneNode(true);refNode.style.display=\"inline\"\nrefNode.className=AllAnchors[i].className;AllAnchors[i].appendChild(refNode);}}}}}\nreturn TheBody;}\nvar AMbody;var AMnoMathML=false,AMtranslated=false;function translate(spanclassAM){if(!AMtranslated){AMtranslated=true;AMinitSymbols();var LaTeXContainers=[];var AllContainers=document.getElementsByTagName('*');var ExtendName=\"\";for(var k=0,l=0;k<AllContainers.length;k++){ExtendName=\" \"+AllContainers[k].className+\" \";if(ExtendName.match(/\\sLaTeX\\s/)!=null){LaTeXContainers[l]=AllContainers[k];l++;}};if(LaTeXContainers.length>0){for(var m=0;m<LaTeXContainers.length;m++){AMbody=LaTeXContainers[m];try{AMbody=LaTeXDivsAndRefs(LaTeXpreProcess(AMbody));}catch(err){alert(\"Unknown Error: Defaulting to Original LaTeXMathML\");}\nif(AMbody.tagName==\"PRE\"){var PreChilds=document.createDocumentFragment();var DivChilds=document.createElement(\"DIV\");while(AMbody.hasChildNodes()){DivChilds.appendChild(AMbody.firstChild);}\nPreChilds.appendChild(DivChilds);AMbody.parentNode.replaceChild(PreChilds,AMbody);AMbody=DivChilds;}\nAMprocessNode(AMbody,false,spanclassAM);}}else{AMbody=document.getElementsByTagName(\"body\")[0];try{AMbody=LaTeXDivsAndRefs(LaTeXpreProcess(AMbody));}catch(err){alert(\"Unknown Error: Defaulting to Original LaTeXMathML\");}\nAMprocessNode(AMbody,false,spanclassAM);}}}\nif(isIE){document.write(\"<object id=\\\"mathplayer\\\" classid=\\\"clsid:32F66A20-7614-11D4-BD11-00104BD3F987\\\"></object>\");document.write(\"<?import namespace=\\\"m\\\" implementation=\\\"#mathplayer\\\"?>\");}\nfunction generic()\n{translate();};if(typeof window.addEventListener!='undefined')\n{window.addEventListener('load',generic,false);}\nelse if(typeof document.addEventListener!='undefined')\n{document.addEventListener('load',generic,false);}\nelse if(typeof window.attachEvent!='undefined')\n{window.attachEvent('onload',generic);}\nelse\n{if(typeof window.onload=='function')\n{var existing=onload;window.onload=function()\n{existing();generic();};}\nelse\n{window.onload=generic;}}\n"),("MathMLinHTML.js","/* \nMarch 19, 2004 MathHTML (c) Peter Jipsen http://www.chapman.edu/~jipsen\nReleased under the GNU General Public License version 2 or later.\nSee the GNU General Public License (at http://www.gnu.org/copyleft/gpl.html)\nfor more details.\n*/\n\nfunction convertMath(node) {// for Gecko\n  if (node.nodeType==1) {\n    var newnode = \n      document.createElementNS(\"http://www.w3.org/1998/Math/MathML\",\n        node.nodeName.toLowerCase());\n    for(var i=0; i < node.attributes.length; i++)\n      newnode.setAttribute(node.attributes[i].nodeName,\n        node.attributes[i].nodeValue);\n    for (var i=0; i<node.childNodes.length; i++) {\n      var st = node.childNodes[i].nodeValue;\n      if (st==null || st.slice(0,1)!=\" \" && st.slice(0,1)!=\"\\n\") \n        newnode.appendChild(convertMath(node.childNodes[i]));\n    }\n    return newnode;\n  }\n  else return node;\n}\n\nfunction convert() {\n  var mmlnode = document.getElementsByTagName(\"math\");\n  var st,str,node,newnode;\n  for (var i=0; i<mmlnode.length; i++)\n    if (document.createElementNS!=null)\n      mmlnode[i].parentNode.replaceChild(convertMath(mmlnode[i]),mmlnode[i]);\n    else { // convert for IE\n      str = \"\";\n      node = mmlnode[i];\n      while (node.nodeName!=\"/MATH\") {\n        st = node.nodeName.toLowerCase();\n        if (st==\"#text\") str += node.nodeValue;\n        else {\n          str += (st.slice(0,1)==\"/\" ? \"</m:\"+st.slice(1) : \"<m:\"+st);\n          if (st.slice(0,1)!=\"/\") \n             for(var j=0; j < node.attributes.length; j++)\n               if (node.attributes[j].nodeValue!=\"italic\" &&\n                 node.attributes[j].nodeValue!=\"\" &&\n                 node.attributes[j].nodeValue!=\"inherit\" &&\n                 node.attributes[j].nodeValue!=undefined)\n                 str += \" \"+node.attributes[j].nodeName+\"=\"+\n                     \"\\\"\"+node.attributes[j].nodeValue+\"\\\"\";\n          str += \">\";\n        }\n        node = node.nextSibling;\n        node.parentNode.removeChild(node.previousSibling);\n      }\n      str += \"</m:math>\";\n      newnode = document.createElement(\"span\");\n      node.parentNode.replaceChild(newnode,node);\n      newnode.innerHTML = str;\n    }\n}\n\nif (document.createElementNS==null) {\n  document.write(\"<object id=\\\"mathplayer\\\"\\\n  classid=\\\"clsid:32F66A20-7614-11D4-BD11-00104BD3F987\\\"></object>\");\n  document.write(\"<?import namespace=\\\"m\\\" implementation=\\\"#mathplayer\\\"?>\");\n}\nif(typeof window.addEventListener != 'undefined'){\n  window.addEventListener('load', convert, false);\n}\nif(typeof window.attachEvent != 'undefined') {\n  window.attachEvent('onload', convert);\n}\n"),("reference.docx","PK\ETX\EOT\DC4\NUL\NUL\NUL\b\NUL\NAK\184WB\179M\143\225m\SOH\NUL\NUL*\a\NUL\NUL\DC3\NUL\FS\NUL[Content_Types].xmlUT\t\NUL\ETX\153\186)Q\153\186)Qux\v\NUL\SOH\EOT\245\SOH\NUL\NUL\EOT\DC4\NUL\NUL\NUL\181\149\203n\131\&0\DLEE\247\249\n\196\182\STX\167]tQ\133n\218n\219H\205\SI8f n\253\146=y\253}\199P\161\144E \175\r\210\216\190\231^\198\131\152-\246\SOB\178\211\202\132\"]!\186\ETB\198\130X\129\230!\183\SO\f\237T\214k\142T\250\154\&9.~y\r\236i:}f\194\SUB\EOT\131\EMFF\250:I\146\217\215\ACK\188\151%$s\238\241\147k(R\182\181\190d[X~\ETX\162\&4u\200\137\153&o\173\&8\250\ETB)wNI\193QZ\195\&6\166<r\206lUI\SOH\165\NAKkM\146<\STX\157\183\STXB \158V\249\SOH\252!\194\217\233,f\173\151\224\233\244\237\147t\232\&19\194\221\SUB\DC2\206\232\ACK\210eC\251|\188:I\131\EM\227Z\145\199\130/\NAK\220\254\229;\244@\SO\"\204\189u\129\145\223\213)`G\202\DC2\202\140\162\&8\240(a\168\249\157\189\176\254\130.\252\DEL\137yT\143\&7m\231\SO\247\n\238\&1u\rwL\130\142q\243\f\221\142\230\210\140\ESCD\139\198\226=\250\209\161\SIr\188C\197\215\n/\186j\SI\170\&9\DC3V\210\181\204\228#\142]\160\181\"\165\221\&0\214\228X{F>WV=i\172OH\165\142\191\139]\ACK\186/\139\245\160\204\153\186\239E\245\160\232\199A_\213,\f\202j\217\SI\CANk\DC2\205X\243\135|\157\252\SOHPK\ETX\EOT\n\NUL\NUL\NUL\NUL\NULN\161%B\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\ACK\NUL\FS\NUL_rels/UT\t\NUL\ETX4\249\232P\173\250\232Pux\v\NUL\SOH\EOT\245\SOH\NUL\NUL\EOT\DC4\NUL\NUL\NULPK\ETX\EOT\DC4\NUL\NUL\NUL\b\NULzn#@5\145\&2W\238\NUL\NUL\NULj\STX\NUL\NUL\v\NUL\FS\NUL_rels/.relsUT\t\NUL\ETXxx\ETXO\CAN\250\232Pux\v\NUL\SOH\EOT\245\SOH\NUL\NUL\EOT\DC4\NUL\NUL\NUL\173\146\193J\196\&0\DLE\134\207.\236;\132\185o\211U\DC1\145\198\189\136\176\&7\145\250\NULCf\218\ACK\219$$\163\238\190\189\DC1\EOT\183 U\193c\254\204|\243MH\179;L\163z\229\148]\240\ACK\182U\r\138\189\r\228|o\224\169\189\223\\\131\202\130\158p\f\158\r\FS9\195\238v\189j\RSyD)Myp1\171B\241\217\192 \DC2o\180\206v\224\ts\NAK\"\251r\211\133\&4\161\148c\234uD\251\140=\235\243\186\190\210\233\148\SOH\133\186^\157\205\192jO\ACK\210\158.A\181\199\200\191\EM\DLE\186\206Y\190\v\246eb/\223\204\209|\DLE\246\196\180\137\169\244'qe%\213b\234Y\fP\176\SI%\206\SUBc\172\n\SUB\244\130\214\246?\181\230\NAK_Fo!\145\166\207\248G\165\139\191*\209\130\210\196\130\132\130\218\134\196\203\207\245Qq\"\215\232\217\255(\217;PK\ETX\EOT\n\NUL\NUL\NUL\NUL\NULN\161%B\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\t\NUL\FS\NULdocProps/UT\t\NUL\ETX4\249\232P\173\250\232Pux\v\NUL\SOH\EOT\245\SOH\NUL\NUL\EOT\DC4\NUL\NUL\NULPK\ETX\EOT\DC4\NUL\NUL\NUL\b\NUL\229[#@,,\fwJ\SOH\NUL\NUL\174\STX\NUL\NUL\DLE\NUL\FS\NULdocProps/app.xmlUT\t\NUL\ETX~W\ETXO\CAN\250\232Pux\v\NUL\SOH\EOT\245\SOH\NUL\NUL\EOT\DC4\NUL\NUL\NUL\157R\193N\195\&0\f\189\239+\170\221i\198`\ETXM!\DC2\218\SO\FS\NULMZa\231(u\219hi\DC2%\EM\218\254\RS{\221J'8\209\147\253\158\223\179\251Z\190\SO\206CH\SUBbvh\141\141O\227&%\191`,\170\ACKZ\EMs\164-2\149\v\173L\216\134\154\185\170\210\nVN\237[\176\137M'\147\&9\131C\STX[By\227{\195q\231\184\248J\255\&5-\157\162\251\226gq\244\232'FY\198\183.\148Q<\222q\214U\132m\SUB\EM\160D\173\168\164\137\192\217\SI@\244\v\170\131\209v\ETB\151\141\180\&5\148\151\177\223\EOT\141\191j\vQ\220N9\235*\194\158\189\255\132\DLE\181\179H\228\DC3|8\ESC`g\217.~\248\194\173d\130\203\134k\240\236d\180\146\137doZ\ENQ\ETB]\149\&2z\151\140\156\243\206\184\US!\t\RS\ETB\164J\184k\171S\179\241R\225U3\138\224O\134$\ENQ\180\222\208\202w\138\216\228\165K-g=J#\152\206\ACK\212>\232t\DC4\184t\216\158\FS\\\146\166\208-\136\&9\n\251\230\DC4\183\146\ACK\150\248a\250\184{\224\250\\q\255\&0\ESC\RSy\162\215\216\213A\250\ACK\191\"g\131\174#k\202\158p*FX\244\255\147\CAN}\ETXPK\ETX\EOT\DC4\NUL\NUL\NUL\b\NULan#@\177\t\162\248S\SOH\NUL\NUL\175\ETX\NUL\NUL\DC1\NUL\FS\NULdocProps/core.xmlUT\t\NUL\ETXFx\ETXO\CAN\250\232Pux\v\NUL\SOH\EOT\245\SOH\NUL\NUL\EOT\DC4\NUL\NUL\NUL\205\147?O\195\&0\DLE\197\247~\138({\234\&8\165\fQ\155\SOH\DLE\DC3\149*Q\t\196f\236kk\154\216\209\249J\218o\143\ESC\236\136 \150n\140\231\247\238\231w\254\179\&0./\165EX\163m\SOHI\131KNMm\\\233\133e\186'jK\198\156\220C#\220\212[\140W\183\SYN\ESCA\190\196\GSk\133<\136\GS\176\"\207oY\ETX$\148 \193.\196\172\GS\144i5I\146\133\146%i\170!l\160\228\192o\143X\247\&4%\EM\212\208\128!\199\248\148\179\180Z\v\163\172L\DLE\182\128`$$\190:-XdE\176;\190\DEL\128\164\171\208=%4F\142D\DLEd\241zNh\236\&9\151\&3=\192\185\179\168\156WGe\212k\225he\149\222jPw\231\224\250\181\CAN\189\b\159\218ik*\254m\ESC\234h\144\130`g1b\134\&2\f\165\192I\212-\249\150\235\a\251\209\FSx\EOT\216\184\239\129A\ENQ\224\201\233\129\216u\221\180\155\245L\255*8{]==\247\SI(\211\198\145\240\151\152\SO1z\214\159Yz\133y\167\211%\157[X\166q\231\151\217\253\195\230\&1\173\138\156\ETBY\206\179|\182\225\188,\230\229\252\230\237\DC2y\148o\148\185\tg\251oC\199\128\213$\220\228\232gV\147/PK\ETX\EOT\n\NUL\NUL\NUL\NUL\NUL\193\161%B\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\ENQ\NUL\FS\NULword/UT\t\NUL\ETX\n\250\232P\173\250\232Pux\v\NUL\SOH\EOT\245\SOH\NUL\NUL\EOT\DC4\NUL\NUL\NULPK\ETX\EOT\n\NUL\NUL\NUL\NUL\NUL\200\161%B\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\v\NUL\FS\NULword/_rels/UT\t\NUL\ETX\ETB\250\232P\173\250\232Pux\v\NUL\SOH\EOT\245\SOH\NUL\NUL\EOT\DC4\NUL\NUL\NULPK\ETX\EOT\DC4\NUL\NUL\NUL\b\NUL\135\161%B\198UX\DEL\226\NUL\NUL\NUL.\EOT\NUL\NUL\FS\NUL\FS\NULword/_rels/document.xml.relsUT\t\NUL\ETX\157\249\232P\CAN\250\232Pux\v\NUL\SOH\EOT\245\SOH\NUL\NUL\EOT\DC4\NUL\NUL\NUL\189\212K\SO\194 \DC4\ENQ\208\185\171 ,@\180\254\DC2\211:r\226T\187\SOHZ_?\177|\STX\207\168\187\151\168i\159\209\129\DC3\EM\146\v\151\ETX!\164{\232$\182F\251\166\181\158]U\167}\198\ESCD\187\SYN\194\151\r(\233\199\198\130\SOIe\156\146\CAN\134\174\SYNV\150'Y\131H&\147\165p\180\131oF\140\165\180\150\229\&7\v\191\148\154\170jK\216\154\242\172@\227\151n\161\207\170\NUL\215\234\154\135Mv\199\140\187\221q\202Y.]\r\152\241>\RS\135f\206\196?)\RSo\GSx\226H\ACK\199\&3\139\129\NUL\196p\\\202\152\DC1\198+\141\NUL\185@q\248\180\204\a\v\153\DLE\129S\EM\141\185,: \152\197\128\233\227\b\DC4\fk)c90\RS\209s\194\&4\202\165\CAN\212\ACK\223\RS\237\138^\202+\238)\169x\251\GS6\163;PK\ETX\EOT\DC4\NUL\NUL\NUL\b\NUL\194n#@R\138\243\174\157\NUL\NUL\NUL\227\NUL\NUL\NUL\DC1\NUL\FS\NULword/document.xmlUT\t\NUL\ETX\252x\ETXO\CAN\250\232Pux\v\NUL\SOH\EOT\245\SOH\NUL\NUL\EOT\DC4\NUL\NUL\NULE\142I\SO\194\&0\fE\247=\133\149=Ma\129P\213a\203\&5B\226\SOR\DC2GIJ\225\246\184\131\196\234?\235\235?\185\233?\206\194\ESCc\154\201\183\226ZV\STX\208k2\179\US[\177\228\225\242\DLE\208wE\179\214\134\244\226\208g\224\133O\245\218\138)\231PK\153\244\132N\165\146\STXz\238\ACK\138Ne>\227(W\138&D\210\152\DC2\v\157\149\183\170\186K\167f/v\231\139\204w\135\208\NAK\NUL\156q\203\157\242A\NULO\180\150\128M\214\148G)\207v\ETX\RSl\DC1\142\&8}\242\255mW\252\NULPK\ETX\EOT\DC4\NUL\NUL\NUL\b\NULTK#@jp<\224\155\SOH\NUL\NUL\229\b\NUL\NUL\DC2\NUL\FS\NULword/fontTable.xmlUT\t\NUL\ETXP:\ETXO\CAN\250\232Pux\v\NUL\SOH\EOT\245\SOH\NUL\NUL\EOT\DC4\NUL\NUL\NUL\229\149MK\195@\DLE\134\207\n\254\135\176w\155MZ5\150F\209J\143\RS\252\192\243\&4\221\&4\v\251\DC1v\182\141\253\247N\210\134\182\168Q\EOTO\t,l\222wvvx\152I&\183\239Z\ENQk\225PZ\147\178h\192Y Lf\ETB\210,S\246\250\&2;OX\128\RS\204\STX\148\&5\"e\ESC\129\236\246\230\236tR\141sk<\ACKt\222\224\216\165\172\240\190\FS\135!f\133\208\128\ETX[\nC^n\157\ACKO\175n\EM\218<\151\153x\176\217J\v\227\195\152\243\203\208\t\ENQ\158\238\198B\150\200v\217\170\223d\171\172[\148\206f\STX\145\138\213j\155O\131\&4\140\234;\217\NAK\CANTc\ETX\154\n\DEL\222\232\185U\141U{%\CAN\139\"\"{\r*e\156\SO\243\v~\244\176\176\r\206\np(\252>xo\229\160\165\218\180\SO\172\188\221{\165\244Y\209Zkp\DC2\230J\236m\148K2W8\231\148\178\189s\171D\159\148\184Q\162\ETXex\FS\147\&5y\146c\229\&0Os\239$\220b\249\138\208\139\212\STX\131GQ\ENQOV\131\233@\NAK\243K>$\\#Z1\237F\223\163\226\255\133j\248\ETX\170C\229KT;!\250\v\170\169]9)\\\r\171\ETX\211\NAK\161\185np\213\152F\253\195\244F\131Y\DELI\240[H5\152\168Y\t\SOHJ\bY\210\183\177\155\130\158S\141\GS}T\143\217v\220\234\177\139\251\215GSP\146\CANu \154\&5\157\DC47\176z\137\232\142\n\236\250\187\221S\239\140v\136\226\RS\NULj\183H\251\SIPK\ETX\EOT\DC4\NUL\NUL\NUL\b\NUL\174\161%B\245\143\150\206\228\NUL\NUL\NUL\165\STX\NUL\NUL\DC2\NUL\FS\NULword/footnotes.xmlUT\t\NUL\ETX\232\249\232P\CAN\250\232Pux\v\NUL\SOH\EOT\245\SOH\NUL\NUL\EOT\DC4\NUL\NUL\NUL\157\146\193j\195\&0\f\134\239y\138\224{\234t\135\&1L\211^\202\158`{\NUL\227\216\141!\182\140\164\196{\252y\180\ETX\247RB|\DC1F\250?\161\159\255t\249\ts\187Z$\SIq\DLE\199C/Z\ESC\r\140>\222\ACK\241\253\245\217}\136\203\185\&9e\229\NUL8\STX[j\218\242\138*\146\202\131\152\152\147\146\146\204d\131\166\ETX$\ESCK\207\SOH\ACK\205\229\139\&7\153\SOH\199\132`,Q\129\134Y\190\245\253\187\f\218GQ\161\194\SYN\DC48\231\141\189\130Y\130\141\252\SI\226\169\ACK\225^\DLE\218Ysq\129&\159\168&\194 \SYN\140\234\129\235\130\&7\b\EOT\142;\ETXA\221I\143R\171\214W\170\&5\204\245l>\246\ESCv\252\EMY\171\244\150KG\212\249\133\237\201\155\GS\148\162\226\ENQ\159\206\205i\a\231\&9\SUB\215{S\148\184\201*o\231\230\ETBPK\ETX\EOT\DC4\NUL\NUL\NUL\b\NUL\184M2@0\SUB]B\168\ETX\NUL\NUL\a\RS\NUL\NUL\DC2\NUL\FS\NULword/numbering.xmlUT\t\NUL\ETXK\ENQ\ETBO\CAN\250\232Pux\v\NUL\SOH\EOT\245\SOH\NUL\NUL\EOT\DC4\NUL\NUL\NUL\213\153\221N\219\&0\DC4\199\175\199ST\145v\t\249\254hE\139\DLEPi\DC3b\147\198\180\235\&4q\169\&5\DELDv\218\194\237\246\&0{\132I{\169\189\194\236\164\t)\DC4\226RGk\185\169\227s\206\223'?;\246\177\&8=\187\199\168\183\NUL\140CJ\134\134}b\EM=@\DC2\154Br74\190\222\142\143#\163\199\243\152\164\&1\162\EOT\f\141\a\192\141\179\209\209\233r@\230x\STX\152\240\235\t\t\194\ax14\230\140\fx2\ETX8\230\199\CAN&\140r:\205\143\DC3\138\a8N\ACK\v\140\140\202\153\SO\141Y\158g\ETX\211\\\249\159\212\254'\194\223\164\211)L\128)\194\170\166cY\145x\134\164\210X\128g\SUB4\ETXD\CAN\167\148\225\&8\ETB\143\236ND\176\239\243L\230\144\197\&9\156@\EOT\243\a\169\NAKT2\244\181\180\203\177W?U\EOTS\EM\183\f\185\164\201\FS\ETX\146\ETB#\154\f \145\ETX%|\ACK3^\163x\171\154\&0\206j\SYN\175\189D\131\251\210\182\DC4^wIYZG\168\164'\ETX2F\DC3\192\185X\DLE\CANU\t>N\214\146<\159\173\141\&3.\165\202p\217jd\158\169$\146\178x\217\200`=\175\203\210h\140\142\222\137\245\ESCOx\206\226$\191\153\227\222\218\211\135thX\210Iz\DC1\SOSa^\196hh\140\139?\251\210\&0WF<G9\188\ACK\v\128n\US2P\185\NAK\189H\246\214\142\&9\206Pe\190\180<\171\DEL\DC1^\212F\180\144\&6(~\170qe\175\248\232X^\197\216\165\243\187\242\179\ESC\227\218\&0\153#\EOT\242G\171\DLE\185\ENQ\247\181y\205\240\&1\169\186\DC1\152\&6b\178\207\172h\SYN\137\n\SO\229\195\234\169\n\DC1\195\SUB\162\157Q.\147\&4W\SOHf3B\EOT@\"aIy\233%\154S\200x~\r\229\228WQ2\168\SUBR\132\176\198\232lLI\206\229l\240\EOT\194\161\241\229\SOHO(\146:\179s1\DC1k\GS\144\136\&1R0\141\ENQ\237\134\242JN6\197+o l\235%\252\247\199\239n \135\142\SUBf\219\138\n\210\179\152\220\NAK\155\182\ESC\236\tiG/i\218\rg\219\243\DC4AG\150\ACK\208\ETBt\206 `\189\ESC\176l\208~\218\251V\228\174\238\197\253\171\ESC\232\142\GS\168Aw|G\ETX\244o\"TV4\188\129|\189\239\173\192=\205\192\DEL\254\233\bx\DC4\169\SOHw\GSo\175\129\251\a\178}\vl\138\192\251\193\158\238\223\193A\236\223\158\171xPz\129\142\131\178\219\253;<\144\253\219\183\DC4\SIM\223\211qhv\183\157D\a\178\DEL\251\161\226\129\EM\216\251u`\202V\227n5j\191z\217\155\174^\174\229G~?tw\187z\157{\225\149\237_\\i\185z\165 \129\&8F/\174\133\247\246\201\255\189\EM\132OV\194c\\c%\232\187(\181\242p:\226\161^\193{\222ND\182\189\208\180\DC2q;\"\162^^\219\193ND\182\189o\180\DC2\241\186\"\162Z\255\SYN\142;\DLE\217\246B\208J\196\239\136\136z\129\SUBX;\DC1\217\182bo%\DC2tDD\189\146tw\219Y\183-\172[\137\132\GS\DC1Q/\243\172\221v\214m\235\222V\"QWDT\235\176\194q\a\"\219\SYN\166\173D\250\GS\DC1\t<\197\157\181p\220\130\200\198\202\145\DC4\NAK#yR)\174U\144U\146\165\184T!\ESC\163\157W\163\237f\141\248i\SOH\CAN\131)x\169Vl\216\215\130\205\181\232W\244l\205z\142f=W\179\158\167Y\207\215\172\ETBh\214\v5\235Eo\212\171\191\134U\163\252\a\238\232\232\USPK\ETX\EOT\DC4\NUL\NUL\NUL\b\NULTK#@>\166j\135\245\STX\NUL\NUL\224\a\NUL\NUL\DC1\NUL\FS\NULword/settings.xmlUT\t\NUL\ETXP:\ETXO\CAN\250\232Pux\v\NUL\SOH\EOT\245\SOH\NUL\NUL\EOT\DC4\NUL\NUL\NUL\157UMs\218\&0\DLE\189\231Wx|.\177\249\ACK\SI$S $\a\210a\226\164wY^\131\ACK\201\242H\STX\151\254\250\174\193\178=M\157dzBzo\223j\181\214>f\247\191\EOTwN\160\&4\147\233\220\237\222\250\174\ETX)\149\&1Kws\247\237u\221\153\184\142\&6$\141\t\151)\204\221\&3h\247\254\238f\150\a\SUB\140\193(\237`\134T\ar\238\RSU\SUBh\186\aAtG0\170\164\150\137\233P)\STX\153$\140B\249\227\150\n5w\247\198d\129\231\149\162[\153A\138\\\"\149 \ACK\183j\231]%+I\143\STXR\227\245|\DEL\228)\224\196`\189z\207\&2m\179\137\255\205\134\228\222&9}t\137\147\224\&6.\239\250_\184n.U\\)\190R^!\200\148\164\160\&5vVp[ Km\SUB\205\191\146\231JmX\164\136:7\146\220\221\&8\SO~\185\223R\n'\SI2P\DC4\187\&0w\167\190\235\149\DC4\136\b\226\240\172\r\136\181L\141\182\&8V%\147\208\DLE\ETX(\212\EMp~y \148\ETX\193\218\242`\167\136\DLEDY\196\202\180\&9s\216\146\DC4\214\151\234\214\140\ESCP\CAN~\"x\SI\223\247\aUd,\DELH\243\170\b=<\203\DC3T\231\198\144\144#7\175$\n\141\204\172r\220\171+\142\NAK\201\177\150G\197\226'\169\216o\172\154\240\&0#\DC4A\ESC\223\US\253\&3\254'(\195\232\199\209Lg\156\156\235\204\171Z\254\128cs\174.\243\183\196&\255\\@\247\EOT\239\141\141)\235X\226AJr\ESCx\233\204R\138L\225\179\168;KN\176Upb\144o\EM5G\ENQ\150\193Q\142u\177\174v/R\154\186\233\195\169\191\242\199\215DUH\227\155t\187\203\201\162\149\RS<\244\166\139~+\253I\242\241d\176\SUBNZ\233\201j4\EM\181'_LF\139\241\176\157^\SO&\171vz\217\US\245\198\211V\250\161\223\GS~/\207\158y\141\&6\206DPX\196V\149\194\235\182\152\SOG\\\197\155#e1q\RS\NAK\218$T\a\136 R\135\ENQKmT\EOT8\162\239\233\240\CAN\217\136N\167\193jA8_\227\195\176lB\184n\202\139w\182\130\164\141\230\207D\237\234\211\253\ACK\165\218\169\\\145\236\133\237\246\166\134Xj6L\216`}\140\194c\214P\164h1-\252\204k\182\SO;n\208\150\160\232\220\134\212\227\ACKi\231-\172\135\129\171\176p/x&Yv\GS\202h\215\157\187\188(\170[X\141\193]L\212\225\178\137v\189\146\235]\184\222\149\187l\b-\236\r\163\203E\141\245,\214\136\235[\172_c\ETX\139\rjlh\177a\141\141,6*\176\253\EM\157\NAK\253\241\128Vm\151\ENQ\158H\206e\SO\241S\205\191\131j\ETB\SOH\202\240\ENQ\132g\DC1\213Vp[\209\156i\DC3B\134\198ade\168\223\n\186x\187\246\175\249\238\230\SIPK\ETX\EOT\DC4\NUL\NUL\NUL\b\NUL\233\173ZB\230\131\166\136\167\EOT\NUL\NUL\181\"\NUL\NUL\SI\NUL\FS\NULword/styles.xmlUT\t\NUL\ETX\230\157-Q\230\157-Qux\v\NUL\SOH\EOT\245\SOH\NUL\NUL\EOT\DC4\NUL\NUL\NUL\237Y_s\226\&6\DLE\DEL\231Sx\252\158\ETX\DC3\146R&\228\134\144f\146\153\244\154+\164}\SYN\178\140u\177%W\146C\232\167\239J\182\193\&6\182\225\b\205]2\188\161\221\213\254\253\237J\SYN\ETB\159_\194\192z&BR\206\134\182\243\169c[\132a\238R6\US\218\177\242N\250\182%\NAKb.\n8#C{I\164\253\249\178u\177\CANH\181\f\136\180`?\147\ETX1\180}\165\162A\187-\177OB$?\241\136\&0\224y\\\132H\193R\204\219\220\243(&\215\FS\199!a\170\221\237t\206\219\130\EOTH\129m\233\211H\218\173D\219b\ETBm\v.\220HpL\164\EOTg\195 \209\ETB\"\202\236\203\150e\129\135.\199\215\196Cq\160\164\166\CAN\154x\DLE)-!e\196l\149\172o8S\210Z\f\144\196\148N\193\ENQ\136<\164\140\139\219\DC1\147\212^\201.\ACK\EOTI5\146\DC4m\n\SOH\211\215?\SUB\183c\169r\236+\234\194\190v\193\ETB\249/\136=\163`hw{\155\188\177\172\231\ACK\136\205\&3.a'\143\DC3;\231o\142\&4\ETX\171C\ESC\137\147\201(\167\226\162\157\203K\186(d\SO,DU\201\140J\201\148\DC1\194\212x\130<E\NUL(P\167\146\157(o\167\168TSJu4\161)@\208$A \b\DLE\239\158\227'\226N\DC40\134v\199N\136\143w\SI\130rA\213R\211ZVB\157\144\144\222R\215%,'\201|\234\146\191}\194\RS%q\215\244\175\&7\ACKq\171\237\152\199\fV\221_\206\211\DLE\178F\NUL\158ZF`;B\STX\205\ENQ\138\252T\131v\ESC\SUBK\175\140\224\GSh\255\162\149\ACK\246*\143\f\133$\171T\202\203\DC2\EOT\220\DEL\DC2\USR{\237T\207v\227+sS\170\STXRm-a\229\140\205\DLE\196\255\a\171\247\134\145\ETB\181\163\175e8\192\234\137\144\232\139\214\208.\DC1\239)\131R\230\169k\220\204\b\244=D\215\235\155\178d0\234\NAK`\180\CAN|\195\153_\CAN\192A\196\218\175\STX\196\n\237^\219\236\232[\169[7[]\139\252\150\210\&6\186\189b\255\186\215\&5\179\212\235:\245\197\213\184\152\SO\204\ETX.\178\NULO{g\163\254H\ESC5*\199\154\a-\140u\224\206\218\162aN|\228\130\209\171\179\162\181\245\\9=/s\214S%\199\203\r\132}@8\138\149\207\133\172\134a\198\252\DC18\219\ENQ6\251\EOT|\r\163\168:Z\195\249H\161\222\DC2\164/\fNu\184)\215r\SO8gb\154M\246L\230\215\US4\134JC\136\199*\NUL\GS\247\207A\230X\231\&8\135~\166\&9\148\162\177\219\140\213\238\219a5.\\=\222\n\196\230\DC2\182;\136\157\SI\f\226\222M\223\185\186\174\ETXq\GSX\187\r`\237\RS\CAN\172\167\205`==\130\245\b\214&\176v\251\245`\205\241\SO\ETX\214^3X{G\176\RS\193\218\b\214^\ETXX{\a\ACK\235Y3X\207\142`}\223`\165\197\213;\ENQ\235U\192\241\211\215\152\215}P\SUB\190\149\b\252\252\128\221D\161S@\161\211y\DEL\159L%`\229\NUL\210i\NULH\231\251\SOH\130}@\b6\223\238\133\231\197\150Ux{H\CAN\SI\EM\154t\158j\222\"\DC2Ik%j\EM\217\\\241\228\234\185tK\241\155\GSWh\166_\SUBk\223D\167\154\191\253a\212\154&z\246\240\175\ACK\156j\SYN\DC4@\ENQ\235;\230\130\213E\250\f\156\248\239\190\160b%AnL\130\224wT|\238V<\218\178\215\136\ENQ\196S\137\156\211\233\&7J\206\184R<\220E\167\160s\DEL\187R]\166\178\239)\237\NAK\143]\196\163\140\234?r\166D\132\181PKe,#\180\239\164Z\235\177kg\204^\135\226\198)\216<}f\a\154\238\185x\182\228m\215\148\237u\198pw9\133\140\213\156\&0\192\181\f\251{\170\ACK\183\135\167\188\ACK\173`\f\ETX\172\190n\ESC\197p\186\149\229\216\235o\DLE=9\198(\170\207\180\145\176\&2\145\183\138\&4;\ENQ\vg`u\216\NAK(\164\aB\225]\136\230\205\217\&1\DC2\US>;\133\ETX\SYN\199\DC2f\175\249\159q\243\144-D\210\220\&5V9\218R\202*\207\235-\t\220\169\215w\143\230/\"fH\209\176>\154Lb[0u\NAKn\186\187\r\237\&1g\146\aH\174\174cyR\205\221j\143w\182\221\DC3r\195\185bp\163\254\147x\213\249\200\EOT,-\241\218t<\DC3\161F\SOH\157\175\182\201\&8\"BbA#\245\DELF\t\231\225Sux\134\243\218\176\246\248\194\170\SOr\245S^\182\254\ETXPK\ETX\EOT\n\NUL\NUL\NUL\NUL\NULN\161%B\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\v\NUL\FS\NULword/theme/UT\t\NUL\ETX4\249\232P\173\250\232Pux\v\NUL\SOH\EOT\245\SOH\NUL\NUL\EOT\DC4\NUL\NUL\NULPK\ETX\EOT\DC4\NUL\NUL\NUL\b\NULTK#@\157\\\139\190\"\ACK\NUL\NUL\135\GS\NUL\NUL\NAK\NUL\FS\NULword/theme/theme1.xmlUT\t\NUL\ETXP:\ETXO\CAN\250\232Pux\v\NUL\SOH\EOT\245\SOH\NUL\NUL\EOT\DC4\NUL\NUL\NUL\237YMo\219\&6\CAN\190\SI\216\DEL to\229/\165NP\167\136\GS\187\221\154\180A\226v\232\145\150h\137\r%\n$\157\196\183\161=\SO\CAN0\172\ESCvX\129\221v\CAN\182\NAKh\129]\186_\147\173\195\214\SOH\253\v{\245a\153\178\233\196I\211\173C\155\131#R\207\251\253\242!i_\189v\DC42t@\132\164<jY\213\203\NAK\v\145\200\229\RS\141\252\150u\167\223\187\212\180\144T8\242\&0\227\DC1iYc\"\173k\235\US~p\NAK\175\169\128\132\EOT\129|$\215p\203\n\148\138\215l[\186\&0\141\229e\RS\147\b\222\r\185\b\177\130\161\240mO\224C\208\ESC2\187V\169\172\216!\166\145\133\"\FS\130\218\219\195!u\t\234'*\173\245\137\242.\131\143H\201d\194eb\207M-\234\DC2)\214\219\175&\255\228Xv\152@\a\152\181,\176\227\241\195>9R\SYNbX*x\209\178*\233\159e\175_\181\v!\166\SYN\200jr\189\244/\151\203\ENQ\188\253Z*'\252A!X\237\&5V\175l\SYN\250k\153\254y\\\183\219\237t\171\133\190\DC4\128]\ETB\"\173\206a\ESC\189f\181=\209\169\129\178\199y\221\157\138Si\148\241\154\254\250\FS~\181\221n;\171%|}\138o\204\225\155\149\149\198F\173\132oL\241\206\188\255\237\141Ng\165\132w\166\248\149\&9|\239\202\234J\163\140OA\SOH\163\209\254\FS:\169gQ\153\STX2\228\236\134\DC1\222\EOTxs\210\NULS\148\173uW&\US\169E\189\SYN\226\251\\\244\NUL\144\SYN\ETB+\SUB!5\142\201\DLE\187\128\235`F\a\130&\ACK\240\SUB\193\218\155l\202\149sS\137-$]Ac\213\178>\142\&1\172\136)\228\213\243\US_=\DEL\138\142\US<;~\240\203\241\195\135\199\SI~6H\221\192\145\175K\189\252\254\139\191\US\DEL\138\254z\250\221\203G_\153\241R\199\255\254\211g\191\253\250\165\EM\168t\224\139\175\159\252\241\236\201\139o>\255\243\135G\ACK\248\134\192\ETX\GS\222\167!\145\232\SYN9D\187<\132\192\f\ACK\200@\156M\162\US`\170KlD\190\196\DC1Nd\f\232\174\nJ\232[c\204\176\SOH\215&\229\f\222\NAK@\SOH&\224\245\209\253\146\195{\129\CAN)j\NUL\222\f\194\DC2p\155s\214\230\194\CAN\211\205\196\150\158\133Q\228\155\141\139\145\142\219\197\248\192d\187\&3S\223\238(\134^\166&\149\157\128\148\220\220aPr\236\147\136(\148\188\227\251\132\CAN\196\238QZ\202\235\&6u\ENQ\151|\168\208=\138\218\152\SUBS\210\167\ETXe\SYN\186AC\168\203\216\228 \212\187\148\155\237\187\168\205\153I\253&9(#aU`fRIX)\141\215\241H\225\208\232\&1\SO\153\142\220\194*09\185\&7\SYNn)\225RA\165}\194\&8\234zDJ\147\204m1.\185{\DC3\168\195\\\246m6\SO\203H\161\232\190\t\185\133\&9\215\145\155|\191\DC3\224\&06\250L\163@\199~$\247\161E1\218\225\202\232\EOT/\175\144d\fu\192\209\194r\223\165D\157mm\223\161~`n\144\228\205H\228\188]b\224\144F'\209q\bl\140/\154\142\129\NUL_|\251\248\DELD\196\ESC\144\EOT\211J\152\165\223E\184Y\210\237p\225\209\183\159s7\241(\218!\208\230\239)\247=\229\190\139\148\187h=/K\180Sn\181\245Cq\170/\\xB\RSR\198\246\212\152\145-\153\178\178\EOT\167\189\RSL\166\131T\168\&8\144\199\SOH<\230\230J8_\224\244\EM\t\174>\161*\216\vp\ff\170\169\ENQ_\230\170}\137b.\225\SUB`-\212\157\222%)\EOT\159\206\&9\147\v \160\177\218\230^6]\215/\134\133\154t\228K\221P=Q\176\172\177\250\149\215\&3V\205\128KZ\171:fk\206\137\214l-\155\176\SUB\DLEN\174\253\213\149Zf\SUB:\ACK3\226%y\207\DC4L\202\242\ACKKT\173h5\n\176G\f\211Z|\213\250\ESC\201\166s&'.&\201\149\185$\219\243\171\137E\229\DC1:\132;\188Ss,\228\226\184e\r\225\f\EOT\143a\f\250d\194\US\152\249Q\203rU\SYN\224\233kq&\226UsWU+\206\162\128K&b!\213&\150A&\149\190\154|\237\DC1M\253\175\&9\141$\SI\ETB\DC3\128\129L\150\243\162\222\172\254\135^\216\179\165%\195!q\213\130\153\233\&0\DEL\199G\138\136\189\192;D\ETX6\DC2\187\CAN\252nd\221\229Q\t\148_\155\f\EOT\244v#o\188\242\194\205\215\198\236\215+\249\154\193,\SOp\222\237M\173\246\EM<}.|HG\154{\246\STX\223\207\EMJ\253\STXCq\222\221P\146\206\133Sg\221K\175B\176\139\v\140\146\RSmY\\\168\128\ETX\v\197\SOHu{\STX\246\253\212\SYN\248\133`Y$.!\150|Y\156\248J\SO\166\188\149\233\200H\206\SI\212.\245\145\160\192t*\DLE\132\236\168<\206S\148Uk\250\246\&8Q\148\243L\225\174\140\179\255\ETXr@X?Y\189+I\252\SYN\n&l\146'\"\197\205\SYN\205\&6\173\174\129\223{\139\SI.\141sm<SC\141\179l~\r\141\244\181\173`\245\245\\Xf\ETX\214\204\213\204\DC1\215\156\133;\207\236V\ESC\195\221\SOH%\US@\220T\184lz<\237\243]\168>*\246y\EOT\141x\169\153/\191br\NUL>7\181\224\DC2U\255\214)\168\185\160\222\ETByv\212\146]_\144\236\147\205\157?\217\142!\215\206\201\169\182\231\151\168\173\221C\210\209\220\143F|p\USlo\194=g\196\178\EM\EM\195({\216\DC1i\192\ETX\238\141\243G&3J\200\DC21\161t\SYN\237\146!\162\222\209\164\172\&3\EM\205\DEL\149)6\243\221\204@\DC2{!X?]0\199O7\145B\184v\186p!1\185\236\NAK\194\233-\206\164\128M-g\248\172\202\ENQE\SYN\153b\209\235\164l\t\231\205)3v\239\178)[\162P\231H\153::9ey\166lS\227\145#%pg\242\&3\DC3\244\175=m\217\245\DEL\NULPK\ETX\EOT\DC4\NUL\NUL\NUL\b\NUL\229[#@\204d$|\129\NUL\NUL\NUL\159\NUL\NUL\NUL\DC4\NUL\FS\NULword/webSettings.xmlUT\t\NUL\ETX~W\ETXO\CAN\250\232Pux\v\NUL\SOH\EOT\245\SOH\NUL\NUL\EOT\DC4\NUL\NUL\NUL]\142\&1\SO\194\&0\DLE\EOT\251\188\194\202\ETX8\139\130\194\&2\145h\160\139\144\252\STX\147\FS\137\165\179\207\242Y\152\231c\SUB\n\202\157\213\172\214&\209\166\225\195a\173!m\162\222\145\146\152N\207\227^k6\NUL\178\236\CAN\189\FS8c\234\237\147K\244\181\199\178A\227\178\230\194\v\138t9\DC2\FS\181>A\244!\141\211\160\148\253\142{\"n\247\249\ACK?\178\242\204\213\249\ETB^\196u\141\240\SUB\b{m\225\239\204\&4|\NULPK\SOH\STX\RS\ETX\DC4\NUL\NUL\NUL\b\NUL\NAK\184WB\179M\143\225m\SOH\NUL\NUL*\a\NUL\NUL\DC3\NUL\CAN\NUL\NUL\NUL\NUL\NUL\SOH\NUL\NUL\NUL\128\129\NUL\NUL\NUL\NUL[Content_Types].xmlUT\ENQ\NUL\ETX\153\186)Qux\v\NUL\SOH\EOT\245\SOH\NUL\NUL\EOT\DC4\NUL\NUL\NULPK\SOH\STX\RS\ETX\n\NUL\NUL\NUL\NUL\NULN\161%B\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\ACK\NUL\CAN\NUL\NUL\NUL\NUL\NUL\NUL\NUL\DLE\NUL\237A\186\SOH\NUL\NUL_rels/UT\ENQ\NUL\ETX4\249\232Pux\v\NUL\SOH\EOT\245\SOH\NUL\NUL\EOT\DC4\NUL\NUL\NULPK\SOH\STX\RS\ETX\DC4\NUL\NUL\NUL\b\NULzn#@5\145\&2W\238\NUL\NUL\NULj\STX\NUL\NUL\v\NUL\CAN\NUL\NUL\NUL\NUL\NUL\SOH\NUL\NUL\NUL\164\129\250\SOH\NUL\NUL_rels/.relsUT\ENQ\NUL\ETXxx\ETXOux\v\NUL\SOH\EOT\245\SOH\NUL\NUL\EOT\DC4\NUL\NUL\NULPK\SOH\STX\RS\ETX\n\NUL\NUL\NUL\NUL\NULN\161%B\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\t\NUL\CAN\NUL\NUL\NUL\NUL\NUL\NUL\NUL\DLE\NUL\237A-\ETX\NUL\NULdocProps/UT\ENQ\NUL\ETX4\249\232Pux\v\NUL\SOH\EOT\245\SOH\NUL\NUL\EOT\DC4\NUL\NUL\NULPK\SOH\STX\RS\ETX\DC4\NUL\NUL\NUL\b\NUL\229[#@,,\fwJ\SOH\NUL\NUL\174\STX\NUL\NUL\DLE\NUL\CAN\NUL\NUL\NUL\NUL\NUL\SOH\NUL\NUL\NUL\128\129p\ETX\NUL\NULdocProps/app.xmlUT\ENQ\NUL\ETX~W\ETXOux\v\NUL\SOH\EOT\245\SOH\NUL\NUL\EOT\DC4\NUL\NUL\NULPK\SOH\STX\RS\ETX\DC4\NUL\NUL\NUL\b\NULan#@\177\t\162\248S\SOH\NUL\NUL\175\ETX\NUL\NUL\DC1\NUL\CAN\NUL\NUL\NUL\NUL\NUL\SOH\NUL\NUL\NUL\128\129\EOT\ENQ\NUL\NULdocProps/core.xmlUT\ENQ\NUL\ETXFx\ETXOux\v\NUL\SOH\EOT\245\SOH\NUL\NUL\EOT\DC4\NUL\NUL\NULPK\SOH\STX\RS\ETX\n\NUL\NUL\NUL\NUL\NUL\193\161%B\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\ENQ\NUL\CAN\NUL\NUL\NUL\NUL\NUL\NUL\NUL\DLE\NUL\237A\162\ACK\NUL\NULword/UT\ENQ\NUL\ETX\n\250\232Pux\v\NUL\SOH\EOT\245\SOH\NUL\NUL\EOT\DC4\NUL\NUL\NULPK\SOH\STX\RS\ETX\n\NUL\NUL\NUL\NUL\NUL\200\161%B\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\v\NUL\CAN\NUL\NUL\NUL\NUL\NUL\NUL\NUL\DLE\NUL\237A\225\ACK\NUL\NULword/_rels/UT\ENQ\NUL\ETX\ETB\250\232Pux\v\NUL\SOH\EOT\245\SOH\NUL\NUL\EOT\DC4\NUL\NUL\NULPK\SOH\STX\RS\ETX\DC4\NUL\NUL\NUL\b\NUL\135\161%B\198UX\DEL\226\NUL\NUL\NUL.\EOT\NUL\NUL\FS\NUL\CAN\NUL\NUL\NUL\NUL\NUL\SOH\NUL\NUL\NUL\164\129&\a\NUL\NULword/_rels/document.xml.relsUT\ENQ\NUL\ETX\157\249\232Pux\v\NUL\SOH\EOT\245\SOH\NUL\NUL\EOT\DC4\NUL\NUL\NULPK\SOH\STX\RS\ETX\DC4\NUL\NUL\NUL\b\NUL\194n#@R\138\243\174\157\NUL\NUL\NUL\227\NUL\NUL\NUL\DC1\NUL\CAN\NUL\NUL\NUL\NUL\NUL\SOH\NUL\NUL\NUL\128\129^\b\NUL\NULword/document.xmlUT\ENQ\NUL\ETX\252x\ETXOux\v\NUL\SOH\EOT\245\SOH\NUL\NUL\EOT\DC4\NUL\NUL\NULPK\SOH\STX\RS\ETX\DC4\NUL\NUL\NUL\b\NULTK#@jp<\224\155\SOH\NUL\NUL\229\b\NUL\NUL\DC2\NUL\CAN\NUL\NUL\NUL\NUL\NUL\SOH\NUL\NUL\NUL\164\129F\t\NUL\NULword/fontTable.xmlUT\ENQ\NUL\ETXP:\ETXOux\v\NUL\SOH\EOT\245\SOH\NUL\NUL\EOT\DC4\NUL\NUL\NULPK\SOH\STX\RS\ETX\DC4\NUL\NUL\NUL\b\NUL\174\161%B\245\143\150\206\228\NUL\NUL\NUL\165\STX\NUL\NUL\DC2\NUL\CAN\NUL\NUL\NUL\NUL\NUL\SOH\NUL\NUL\NUL\164\129-\v\NUL\NULword/footnotes.xmlUT\ENQ\NUL\ETX\232\249\232Pux\v\NUL\SOH\EOT\245\SOH\NUL\NUL\EOT\DC4\NUL\NUL\NULPK\SOH\STX\RS\ETX\DC4\NUL\NUL\NUL\b\NUL\184M2@0\SUB]B\168\ETX\NUL\NUL\a\RS\NUL\NUL\DC2\NUL\CAN\NUL\NUL\NUL\NUL\NUL\SOH\NUL\NUL\NUL\164\129]\f\NUL\NULword/numbering.xmlUT\ENQ\NUL\ETXK\ENQ\ETBOux\v\NUL\SOH\EOT\245\SOH\NUL\NUL\EOT\DC4\NUL\NUL\NULPK\SOH\STX\RS\ETX\DC4\NUL\NUL\NUL\b\NULTK#@>\166j\135\245\STX\NUL\NUL\224\a\NUL\NUL\DC1\NUL\CAN\NUL\NUL\NUL\NUL\NUL\SOH\NUL\NUL\NUL\164\129Q\DLE\NUL\NULword/settings.xmlUT\ENQ\NUL\ETXP:\ETXOux\v\NUL\SOH\EOT\245\SOH\NUL\NUL\EOT\DC4\NUL\NUL\NULPK\SOH\STX\RS\ETX\DC4\NUL\NUL\NUL\b\NUL\233\173ZB\230\131\166\136\167\EOT\NUL\NUL\181\"\NUL\NUL\SI\NUL\CAN\NUL\NUL\NUL\NUL\NUL\SOH\NUL\NUL\NUL\164\129\145\DC3\NUL\NULword/styles.xmlUT\ENQ\NUL\ETX\230\157-Qux\v\NUL\SOH\EOT\245\SOH\NUL\NUL\EOT\DC4\NUL\NUL\NULPK\SOH\STX\RS\ETX\n\NUL\NUL\NUL\NUL\NULN\161%B\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\v\NUL\CAN\NUL\NUL\NUL\NUL\NUL\NUL\NUL\DLE\NUL\237A\129\CAN\NUL\NULword/theme/UT\ENQ\NUL\ETX4\249\232Pux\v\NUL\SOH\EOT\245\SOH\NUL\NUL\EOT\DC4\NUL\NUL\NULPK\SOH\STX\RS\ETX\DC4\NUL\NUL\NUL\b\NULTK#@\157\\\139\190\"\ACK\NUL\NUL\135\GS\NUL\NUL\NAK\NUL\CAN\NUL\NUL\NUL\NUL\NUL\SOH\NUL\NUL\NUL\164\129\198\CAN\NUL\NULword/theme/theme1.xmlUT\ENQ\NUL\ETXP:\ETXOux\v\NUL\SOH\EOT\245\SOH\NUL\NUL\EOT\DC4\NUL\NUL\NULPK\SOH\STX\RS\ETX\DC4\NUL\NUL\NUL\b\NUL\229[#@\204d$|\129\NUL\NUL\NUL\159\NUL\NUL\NUL\DC4\NUL\CAN\NUL\NUL\NUL\NUL\NUL\SOH\NUL\NUL\NUL\128\129\&7\US\NUL\NULword/webSettings.xmlUT\ENQ\NUL\ETX~W\ETXOux\v\NUL\SOH\EOT\245\SOH\NUL\NUL\EOT\DC4\NUL\NUL\NULPK\ENQ\ACK\NUL\NUL\NUL\NUL\DC2\NUL\DC2\NUL\SOH\ACK\NUL\NUL\ACK \NUL\NUL\NUL\NUL"),("reference.odt","PK\ETX\EOT\n\NUL\NUL\NUL\NUL\NUL'\186\241>\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\t\NUL\FS\NULMETA-INF/UT\t\NUL\ETX\233\207#N\246\207#Nux\v\NUL\SOH\EOT\245\SOH\NUL\NUL\EOT\245\SOH\NUL\NULPK\ETX\EOT\DC4\NUL\NUL\NUL\b\NUL\188\184\241>\224\&5d\200\233\NUL\NUL\NUL+\ETX\NUL\NUL\NAK\NUL\FS\NULMETA-INF/manifest.xmlUT\t\NUL\ETXC\205#N\232\207#Nux\v\NUL\SOH\EOT\245\SOH\NUL\NUL\EOT\245\SOH\NUL\NUL\173\146An\195 \DLEE\247>\ENQboh\187\170\144\237\236r\130\244\NUL\DC4\143\GS$\CAN\144\EMG\241\237\v\149\DC2\187j\164*\149w\ETX\250\243\254\159\209\&4\135\171w\236\STXS\178\SOH[\254*^8\ETX4\161\183\&8\182\252\227t\172\223\249\161\171\SUB\175\209\SO\144H\221\n\150\251\&0\221\159-\159'TA'\155\DC4j\SII\145Q!\STX\246\193\204\RS\144\212O\189*N]\197V\240`\GS\212Y8-l5\131\222\234\154\150\b-\215\&1:k4\229\156\242\130\189\248\246\DC2[\vAp%\190vo\166z\219|\SI\179su\212tn\185\228\242\169\f\197@\230A\RS\211L@*1\138`On\162\197A\218\GS\235\129\244?\160\214\235\DC1d\196\241\&1\245t\158\253'j\235\146\164[)\138\250\&9\151?\225\251n\CAN\136\242\193\223w\220\200_\247\222U_PK\ETX\EOT\n\NUL\NUL\NUL\NUL\NUL)\184\241>\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\v\NUL\FS\NULThumbnails/UT\t\NUL\ETX.\204#N\246\207#Nux\v\NUL\SOH\EOT\245\SOH\NUL\NUL\EOT\245\SOH\NUL\NULPK\ETX\EOT\DC4\NUL\NUL\NUL\b\NUL\128\171j>\205_\234<\137\NUL\NUL\NUL\230\STX\NUL\NUL\CAN\NUL\FS\NULThumbnails/thumbnail.pngUT\t\NUL\ETX\224\178yM.\204#Nux\v\NUL\SOH\EOT\245\SOH\NUL\NUL\EOT\245\SOH\NUL\NUL\235\f\240s\231\229\146\226b``\224\245\244p\t\STX\210\199\CAN\CAN\CAN\EM8\216\128\172\ETB\177\156\SO\f\fLk=]\FSC*\230\188\189\182\145\243\128\129\NUL\139#\247\149\250\211\155\130\SI?\251\149\176\172\201[,o~\177\220\131\252\251r\f\194\156\204M\ACK\n\FS\163\196(A\"\193\SYN\153=\247\252\174\189\204\137\SOBl,\137<\143\220\206*\242p\FSjP \135\208\ETB\185\193\251GO\234n\DC20\253\&2x\186\250\185\172sJh\STX\NULPK\ETX\EOT\DC4\NUL\NUL\NUL\b\NUL\CAN\186\241>\159\205o\152\239\SOH\NUL\NUL\215\ACK\NUL\NUL\v\NUL\FS\NULcontent.xmlUT\t\NUL\ETX\208\207#N\210\207#Nux\v\NUL\SOH\EOT\245\SOH\NUL\NUL\EOT\245\SOH\NUL\NUL\141\149M\147\SUB!\DLE\134\239\254\138\201\228<\226hR\181R\234^sXO9$W\EOTF\169\240\&1\ENQ\232\204\254\251\240\161\136fg\195e\166h\158\151n\186\ESC\216\188\142\130W\ETB\170\rSr[\183\243E]Q\137\NAKa\242\184\173\207\182k^\234\215\221l\163\186\142a\n\137\194gA\165m\176\146\214\253+\167\150\ACK\198Y\199k\t\NAK2\204@\137\EOT5\208b\168z*o*\152\211\208\251\154E\139\177\239\188X\RS\224\\m\233hK\197\158}\208\162C\185\231\NUL\231j\162\209P*\246\172Kj.\239T\169x4\188\233\148\203\186\232\145eOQ\140\156\201?\219\250dm\SI\SOH\CAN\134a>\172\230J\USA\187^\175A\152M\SOH\227\196\245g\205\ETXE0\160\156zg\ACK\180\243\SYN\220XA-*\141\207\179yH\242,\SOT\ETB\167\ACKY\244OU\205\229X\220\DC1\151\227Dj\240\t\233\226\222\b\240cyW\164\188\188+\146k\ENQ\178\167\137\154\188\128\189\155\f\159\253\219\189\ETB\180(\245\229\217\135Ta\205\250\226mF:\215+\165R\168^\DLE\SIh\bw\185X|\ETXq\156\209\195\167\248\160\153\165:\195\241\167\&8F\FS\167\140+\241Q\210\FS\215\STXG4\244\226\219\&45\190O\132\153\DLE,A\156N\176!\147K\255\222\191\253\196'*\208\GSf\255\135\ESC&\141E\242\158\EM\237\139\&0\185\211\239@\211^i\155\DC2\211\149_\152\174Z\203\228\133t(\185q\164\153\135\NAK\SUB/\f\190\242\NAK\128?\153\192K\190\166Nc\148\223\218:\ENQy\245O\199\158j\230\133\136\251\202\&5\194\184]\186j\170\RSf\234\216<We\246x,\235\221\172\170n\143\197A\145w?\190[\252\237\ESC-\206\SYN\174\226~\247\131r\174\170_Js\242e\ETX\174\198\168\STXO\178d\136+\167\225\243\171\180\155\253\ENQPK\ETX\EOT\DC4\NUL\NUL\NUL\b\NUL\227\185\241>G{\214t\181\NUL\NUL\NULV\SOH\NUL\NUL\b\NUL\FS\NULmeta.xmlUT\t\NUL\ETXj\207#Nl\207#Nux\v\NUL\SOH\EOT\245\SOH\NUL\NUL\EOT\245\SOH\NUL\NUL\141\144\193\SO\130@\fD\239|\ENQ\217;\DC4\208\131\&4\162\223B\150\130\ESC\161%\236\"|\190,\b\225\232\177\157\&7\153i\239\207\185k\195\SI\r\214\b\ETB*\141\DC3\NAK\DC2k\169\f7\133\SUB]\GS\221\212\243\DC1\220\165\174\141&\172D\143\GS\177\139:re\184X\217\226&-\240\192(\165\&5\SYN\185\236\200\162\211(=\241n\193\&3\141>(\216\&6sk\248]\168\151s=\STXL\211\DC4O\151X\134\ACK\210<\207aUw\180\210\a\215\143C\187R\149\ACKj\201'XH\227\DC4v\214\&7\252\183\148g\207\149D\228\b\242\248Vz\141\203\146\228\n\219\172\130\223\&1\167\247e*\132G\240\ENQPK\ETX\EOT\n\NUL\NUL\NUL\NUL\NUL\128\171j>^\198\&2\f'\NUL\NUL\NUL'\NUL\NUL\NUL\b\NUL\FS\NULmimetypeUT\t\NUL\ETX\224\178yMA\204#Nux\v\NUL\SOH\EOT\245\SOH\NUL\NUL\EOT\245\SOH\NUL\NULapplication/vnd.oasis.opendocument.textPK\ETX\EOT\DC4\NUL\NUL\NUL\b\NUL\224\185\241>!\SOH\STX\158\166\NUL\NUL\NUL2\SOH\NUL\NUL\f\NUL\FS\NULsettings.xmlUT\t\NUL\ETXd\207#No\207#Nux\v\NUL\SOH\EOT\245\SOH\NUL\NUL\EOT\245\SOH\NUL\NUL\141\144K\SO\131\&0\f\ENQ\247\156\"\202\RS\STX\180\139b\241\&9\v\n\t\141\n6\"\161\225\248\ENQR*\150]\218o\158\198r\217\172\227\192\222j\182\134\176\226Y\146r\166PRg\176\175\248\226t\252\224M\GS\149\164\181\145\n:\146\203\168\208\197V9\183!\150mu\180\DLE\226\173\&0#Pk\141\ENQlGe\193I\160I\225Y\131+\r\187,\n\155u0\248\170\248\211\185\t\132\240\222'\254\150\208\220\139\172(\nq\164'*\t\181\233\255U\ENQ\250\170\"\162\159h/\132c\SOY\158\166w\DC1f\RS}\143\188\188&\231L\212\209\aPK\ETX\EOT\DC4\NUL\NUL\NUL\b\NUL\226\185\241>\"\150]\t5\DC1\NUL\NUL\"\209\NUL\NUL\n\NUL\FS\NULstyles.xmlUT\t\NUL\ETXg\207#Nr\207#Nux\v\NUL\SOH\EOT\245\SOH\NUL\NUL\EOT\245\SOH\NUL\NUL\237]\221\142\227\182\NAK\190\207S\CAN^\EOTA/d[\254\ESC{\176\147 \221\&4H\128M\154v7\215\SOH-\209\182\178\178(P\212x&W\185(z_\DC4h{Q\DC4h\US\173\SI\208g\232!\245G\253\154\182\228\&1g\214)\208\197\154\135\228\225w\190sx\SOEi_\DEL\241\176s{\247\152\ACK\SO\241\238\250\230`\212\239a\207\"\182\227m\238\250![\ESC\139\254\ETB\159\DEL\242\154\172\215\142\133omb\133;\236\&1#`\143.\SOz\208\217\vn\163F\DLE\167\222-A\129\DC3\220zh\135\131[f\221\DC2\US{I\167[Y\250\150O\245I\244\139\CANL\181\187\DLE\150{3\252\192T;s\217\\_\180R\159Y\b\203\189m\138\246\170\157\185,`*w_\DC3\213\206\SI\129k\172\137a\145\157\143\152S\208\226\193u\188\SIw\253-c\254\237p\184\223\239\a\251\201\128\208\205\208\\.\151C\209\154*l\165r~H]!e[C\236b>Y04\a\230\&0\145\221a\134T\245\227\178\178J^\184[a\170\f\rb\168d\213\224~\163\204\136\251M\r4\214\SYNQen\b\225\188y'\182\186y'\182\220w\135\216\182\198&\139\225w\208(\254\239\187\183\EM\ETB\232Nu..\155\131\202\162\142\175\188\204HZ\238O\bIU\229\GS\"\a\NAK\234\142G\163\233\&0\250\187$\189o\DC4\223S\135a*\137[\141\226\SYNr\173\DC4q\178\171\STX\r\228\204!H\CAN\248\158\211\&4\145\166|\209\181#\207\134\DC4\251\132\178T\145\181z\128\STXt\198\233,\246\SUB\165\211\128d0\DLE#\CAN\188\163\152K\RSa\200=a\200\187\188\234\DEL\DC2\a:)\184\142\251\159\DEL\210\235%\193tM \144\174\145\133\r\ESC[n\192\155\160\&1\242\132\180\173\ETB\253\157\235{\215\DEL\199\DLE}\247\184[\DC1\183/\132\129\249\137\228\206q\USs\STX\189\161\194\128\239\209\150\236\144Y3Z\212\170\&6\210\ESC\DC2R\a\211\222\247x_3\218g\146\200g\177\140< \151\&26\216\195\212\SOH\198\236\136\141\169\215\151E|\135Y\224Tk\231\SOH\219\138\203s\192\202|\190\222\USa!^\157b\ENQ\177\195\202Qi\180\146~\247\136:|\167PS\241K\DLE\ACKc\149\148\138~?\164H\176w\130\160\ESCE\222\134\150c\163\222;\228\ENQ\189\US=\aR\NUL\\\135W\133\232a\204\130\199\128\225]7\186&\196\172cl\167\186\188\RS\214\251k\226\202Q:\148\211\220\198k\DC4\186q\166\148\204\DC2\171\185\161\200\223:V?\234\144v\137\DEL6|\n1\133\&2\aH\201\211\134\219`\139l\178\&7`\174\NUL3\227\225\174?\SUBL\172X\253^\149\200c\165\b\196\ACKf@:\128\141\192G\SYN$#\198\150P\231\ETBX\NAKry\135\241B\161\203=W\204\170\235\NUL\145\240\184\EMJ\GSj\199\143\DC1ta\149{\135m\141(\237[#7\200H\147\"\233#\138\EOT\154\&2\150Q\DC3\239g\160\144\DC1>#p\201\177\&1\137D\145\235oQ~:\161\218\138b\EOT\tV\192\128;,\137H|\151\227\250\242\&8u\215w\169\193V\ENQM9[\FS\207\198|{\224)\179\188\204D\241D\237Tq\200\&1\129\&1\196\SI\164%\r\235\215TX\182X[i\197a\128\SOH2\143\243C(e\DC1\151@r\198h\136\DC3\149\215$\210\&7p~\129\213\152c\US\214\t\191\185\200\219\132h\ETX?aO\252`\145\208c\DC4\232\245\227\187\STXP\152\193\166o|\128\152-\150'\ACK\151\145\224#\ESC\176q\"/\RS?\223=\158(\145\248\229\225!\233\GSO\153\180x\196\195\NAK@\139\225y\DC2\232\226\135d\SOH\133\161\211V>xn\132d\138TBL\146F\162a\133C+\187zj\181\162\179WR\DC4 \222>\250[\236A.K<\195E6\236\130\134\208\143k\ENQ\FS\218\&9\ENQ\232\142\226\179\USz\SYN\v\163\193\247 \EOT\137\r\192\ETX\SYN\235\215\DC3>?[\204O\195v 8x|BHkff\209O\243\238\225\ETX\254e'=\153\173\146\221\171\247\249*>gLodu\DC3\159\171\167O\152Y\187\129\150\137*\251A\131\aT\146T\246\131\146*)\131\229\141\240\236\142\"\177\SYN'\145-\131[&4\197;\228x\ACK/\181\DC2V\143kD\253\&0\216\SYN\EOT\187\241HQ\198\ETB\189Q\252(\147\&1*\246W\132r\a\228,\134\GS\t\168\232\"?\DLE\238\210\157*\ACK%\251ju\160\161\DLE\FS>`\236\ESC\140l0\219\242\250\154\187\253\DC1\170\200*\164\ENQ\133g#j\247k\163\150\148#Y.\n\STXP\SUB\220\182\152\166\149G\254\ACK#[\138+\141\ETX\195\143\233\153\146QPL\DC2\243x\188\144\133\222\195\SI?\141G?\173\136\253\216\175PR1\226\238\DLE\133\DLE\b\176\250<\233\152\142\165\164#k]\DC1\198xu\nY\137\&9\ACK\129\212\SUB\"\EM\241D2\130\220=z\fT\ETX\157\DC4\191\164d\191\180\ETBO\139{e\ETB\129g\154\185}\139\224!F)\176O\133u9\187I\ACK\134=\197w\209\163d\221\158l\218\147\&9\212\NAK5\204\217\184\153\SUB\145\192)\144\188\133\237\244\212u6\184\129\203\135=\142\141E\SUB\152'\173\231\r\242y\DC4\239\216t\160\&9E\167\217.\242\218\195n-N\136\163\243K\145\177\a\133\rM\180\139,)9\228\FS\GSv\248\198t$j\225\253 y\131B\t\234B\245\196\&9\235\156\200\196C\212\132\140\146q\149\&2\132\186)S\169D\239\DC3\152\242-TG\SI\GS\243\196\DC1c\170\240\228,\230>\139G\197\ESC*wt\179>h\198R=\243TD\147}[y\223\149U\137\&3\SI\DC22\SOH\153\139\239y\218d*\EOT\224\ETX\RSc\206>-z\204\RS;\155-l\186+\226\218\245\SO#u\148D\162\190\137P\245\b\153\a4\142\145\138E\163\180\&3\236\248\176a\199\SUB\EMv\220\222\176\211\131\161\176\210\222G\166\&7j\SOH\242\&8VT\231e\213q\241i\216\&39\204\158\137F\236\153\156\133=ja\161\218x]\DLE\224\FS\134\157\RS6\236T#\195N[\ESCvQ\SO\247\237\163\STX\US\244\204AaQ\185S\\2&\204\SOSg\166\DC1uf\231\160\142RH\168\&6]\a\214?\135U\231\135\173:\215\200\170\243\214V\189\&9\209\170\&7\237\173\218\&8D{\171\254!$L\FSx\ACK\GS\215@[\182s\143,\149]\188\ACK@\205\170:\153F`\155\241\201W\161\182\158M\SI\212\214B\128\&7\t3;\226\129\CAN4\DC4\159\SUB\240\243L#'\146\DEL\190w\f\176?P\204/\202 \198\176\205\185\202\&9[\239\&6\178tO\136^\220\SUB\DC1\184\141\192J\135M\234\135\141\165\155\SUB\165#\199Q\213\233`\236-\NAK\189\235\146\172Q\253\201e\234\&7\n\195e\EM\215\232\196\243\198\175\240\218\241\FS\238d\DC1\DC1\232\174\158\b\153lO\b\182\165AS\CAN\205\235\149\253M\187\211\201ZEU`\172\SYN/\ETX\218\DC2\204\220\158tR\220\ESC\140o\SUBB\223\232\201#\216{\254\DLE\136/\233\r\248Bt\241\173\SOn!\218K\229.\DEL\234\SUBA:\SUB\140n\230M\152\198\237-pms\128w\146\&1*\242\163*[\180|\254\213h\251\167\183\vT,\ESC\143\223\b@\180\DLE\211\DEL\SO\ETX\230\172\US\r\254T\DC4\180\223\DC3j\167\182\&9\221\170\177\NAK\196\165\166\252\157\143Z{\183;\153?PGVd\140g\204\t\191&\132y\132a\141\252x\186\\\RS\ESC\ESC\141B\175\&3:\178\234yQuF\162\144\180t\148\136p\195bz1\179\158\STXq\253\r\181\172\165\212\150\172\129\EOTb\223\135\210\CANJ\128YF\133l\153\236\209\135\149Y\176T\142\203\240\152\&1\205\249@\190wT\FSSP37db\169\210\n\SO\223\176k\151m\138?\133:\170ig\175$\222y\190T\151\211e\202\158\246\156ut\232\250\132\DLE\232\&2\v=\SO^\EM\233N@>c\174y\\%\248\164\201\233W\168\131\253\233\212|\190\&6\204\243\214VO\163\191\f\217\150t\SYN\161\203N\199Q\147\198\216\161\128_3\228\247#c\t%:%M\155,R\231\174\130=\SOHP\223\164\ETB\187\185\145\222:\RS\174\247\190L\182'\EOT\159\140\&6Oq\ACKS\149\228\196\215\ACK\197V\186wl\182\149\196G#\168\194{\240\231d\SYN\253\&9\202\151\237>\178\163\151/\DC3\159N\ACK\DC3\129#\189p\EM\255\SUB\a\f9C\206\SUB\133\246\213M\146>\DC3P\191g\147\144W-\175\SYN#\254\191\211\146\237|]@\EOTH|\178\218[\250\205\217\218\252`\178\&6/>\230\205ei\243S\147\&4\135\ACK\130B\149\188\204\&3[\200\246J\219\197En;\RS\188\146\249\189\176T\252\b!zK\172\225H!\149\238%\162\133\197\169M\250\219\208u1S\154\&1\DC2m\156\238\216\179\206\226\vs\197\163\206e\195Ig\185o\r\r\151\n\231\156\135\aKE\151'\242\246w;\DEL\203\223L<\ENQ\184\234}\161BS\193\199C\207L#\169..\135\189c\148D|MWWK\159H\182\215\ENQ\fZ\157\ACK\192\186\156\SI\152\132\165G\DC2\234\RS!~\NAK\209\154m)\t7\219\196\208\SOHq\157\DC3\181\na\138\232]\226\150ze\NAK]\192\199\236\205\SYN\159\158\168\209\170s}V'k\243\198\137\RS\235\189$o|\143!>Cq\221Ihn~\242\163\254\200\169\254y\210i\183Q!\US\247\162\r+\250rB]\184I${B\236\&4+\199\239\&6\189\SUB\193\DEL\139B\STX%\196C\168\211h\244\226\160\236\176M\130\"\223\140\235\129&\185x\238\236\GS\171VG\149\217\ACK\223\144,\197\178\189\228\r\245S\242\tyB\228Y\188X;<a,\168G\156\146\158\135\&5\" R\236\228&Ey\152\223G-\217\STXr\242\226\230E\220+\202\213\vwq!m7\162'\222R\205\153j\205\223\ESC\136\199(\158\US\238\248!\ACKZAK\246\n\224h0Y\152\249\135\209\195:u\142\211w\252\204\244\157<3}\167\207L\223\217\&3\211w\254\204\244\189yf\250.\158\153\190\203g\166\175Y\200J.\172v\161]n\137O\164\STXV\177W\230N>\SUB\222\158\201\206<\204\194\190*\173,\202\167\163c\175\194\222*\US\155\197b\245'/\DC2\162A\184^;\144\189\SO\234\193\&6OD;N\a\147c\202\DC2\212\&5\v;~\245c}V/\190\132`\172\248\141>\193\178\217(\247\156\240R\bMtEH\vt\166\218\162\163\v\DELf\186\"4\214\SOH\157\185\182\232\232\194\159\ESC]\DC1\154\fFz \180\208\ETB\161\217H\v/[\234\138\208T\ETB\SO\153#}!:#\137d\153\147\210\242\134w\159\179\180|\252\164i\249G\144{gK\204\143\192\191\251w\143\220\144\239_\173r\239\220\237\136\231\152{+ 4i\133\208r\185\&8\140Pe\153\172A\238\173\128\206\180U\238\173\134N\252\t:\GSso\ENQ\132f\173\&2\131\241T\193\195L\141\243o\ENQ\132\230\173\182\189\155\169\DC2\135\SYN\163\243r\232\244\252[\SOH\161\155\SYN\b\205\a3\NAK\SO\141\a\DC3M\179o\ENQ|\SYN-\240Y\f\SYNj\248\204\&5\205\189\NAK\240Y\182\137\210\DLE]\212\NUL:\183\139\181H\190\NAK02+^\135P\ai\n\155\212a\140&\ETX\243\EOT\140Zg\223\r\223\142\201\178\239\201s\204\190\207\ESC\179\180\205\188\NAK\207T\206\139\142\182Y\247\\\at\180\205\186\151\249K\233\151AG\219\140\219\FS\235\NUL\143\182\233\182\&9\211\SOH\RSmsms\SOH\240L.\r\143\182\169\246\216\212\SOH\RSm3\237\241T\ax4\206\178\199\&7\NUL\208\244\FS\NUL\181N\177\ESC\190\226\151\165\216\211'M\177\NAK\RS8|\251r\207\190\149V\223\249\129\184&\SI\131\207z\EM\165\DC2\182\&6\249\186\SYN\144\157\245\134J%d\237\142\206\&5a\218Y\175\173T\194\214&\187\215\226)\251Y\239\178TB\214&\227\255\&8.\184T\194\214\166\DC2\248\&8n\189T\194\214\166B\248\&8\174\194T\194\214\166r\248H\238\199T\226\214\170\162\208\251\214L\195\247\157\179\162b\166[Q\209\254B\205\243-)\204\234\146B\158\&1\177\163P'h}\ETXG\225\169\211h0?\243\ENQ\138\246\245\198o\234\&1E\157\215\ESC\ETX\181X9\235\SO\179U\244\245\139\&6\ENQ\135\DLE\139\198\DC1\255r\222]\255\191\191\254\167\NAK\n\243\145\DC2y&\203<\DLE\233T\188\131\234\a:\SO\227\CAN-\237x\FS\143\173@\186\198Qi\251\208\FS\195cK\146\206\&1\140\SOHz\238\&8\RS[\163t\143\227\205R)\182i\142\227\177EK\215\&8N\ACK\230b\254\STXp<\182\138\233\RS\199\217\226%\240\241\232\178\166{ \151\&7\186\DC2\242\148\&2\231\173\DC3}\133\173\225u].r\248M\221*c=\185\173\SO\214\&0\154\209\249\216\DC2\168k6\ETX<\138\199\NAK:\163xl\209\211=\138\&7\138\175_\232\140\226\229\203 \181\243\US\157\&1\188t\td\SO\148\246&\173\&1\188|\t\164z\132\171\&3\138\151/\128&/ &^\186\252\EM\SI\DC4^\169\209\FS\195\203\151>\207\DEL_\209\160\236\153k\SUB\DC4\219\DC4=\r/C\139\162\231\224{\208g*z\254\218\182\232\153\232L\230.\138\158\227\DLE*\166\235\nW;5\199\176\139\146\167\GS\134j\135 :c\216E\193\211\SO\195\133Z\138\164\&5\138]\148<mP4\a\230\v@\177\139\162\167\GS\138\138_\144\208\SUB\197.\138\158v(.\212\178$\173Q\236\162\232i\131\226\&8~7\247y\163\216E\217\211\SOE\197\163]\173Q\236\164\240i\a\227\141\150 \182){\SUB\222B\ETBe\207\193\ETB\208\207S\246\252\227/\173\203\RS\189\US^vP\248\252\237\223\237\n\159\ETBq\185\163\131\226\231\197s\173\131\226\230\202\181n\202\155\ETB\207\181\SO\138\151+\215\186)_^<\215:(N\174\\\235\166<y\241\\\235\162\248x\177dkS\128\&4\188\163/\n\144\131\175\231\159\167\NUL\249\215\245\178Y3B\255\251\245\207\215\203f\GS\160\248\167\235e\179\v\163x\189l\214\ENQ\134\215\203fm1\188^6\235\ACK\197\235e\179.P\188^6k\139\225\245\178Y' \190\196\203f\r\223\DLE\DLEE\207\193\207\a\156\167\232\249\231\223\175EO\167\b]\139\158s\160x-z\218\163x-z\186\192\240Z\244\180\197\240Z\244t\131\226\181\232\233\STX\197k\209\211\SYN\195k\209\211\t\136\207\178\232\241\b\195\129a\DC1o\237lB\138\152C\188^\218`X.\n\130\187\254\154\DLE\198\255\RS-N4[\SO\DC3\194\134\140\244\215\177\\\ACKtU\143\NAK\177\USk\187!\207\218\DC2*\151Z\a\191\n6\146&I4\r\f\159\EOT\SO\159\238\174\239\163\141\172y\212\215KHa\240qmb\133;\236\177\DC4\217#\192\193\158\157aSV\217\169V9?\DC1\255g\218\&3\141\170&\DC4\141\ACK\151\227\246@n /\137\172\215\SOHf\210\215\245\170\144\203\196\227\193\&2\132\\\188f\177\154\142gQ\204\161\224\169Z\164\228\235!\140\239X8r\170@\252\DC4\255\130BF`x\199\&2\178\182\148\209\229R\250\187\US\204D\183\&5\218\&9\238#7\SOE\ESC\138\252\173\140\US\252\b\SUB\148\&8\130iVb\167\130Qo\217s\214$r&\228:\ESCX\156\ENQCa\154\255*\218\207a\192\156\&5\176\DLE\224\134)\246\132\218\t\170\169a\134\210*r\235\226|\STX\167~$!\203\175\206\223\153e\ENQS\217\130\138\162%\249\ETB\159\204\193LJ\ENQ\146\214-v6[&\190\214\190\156\&6\154\&5\ENQ\SO\248\195\fB\GSX3\138\217O(\163\200\SOH\251\194\176;D7\DLE\145\CAN\241\197\247h\167\185\&9\227\198\NAKa`\212\180]j\225\&4\169\239Gce\227n\145B{\n\DC4\ETXJ\239\136\r\b\185\212`\171\188\198\137\195\SUB;\244\144.x\EOT\ETX\148\STXd*\EM`?\EM=\137\169#3\151\ENQ\164g4\f\194I\DC2\162y?.[\184\156^\144Ek K^4\SYNA6gM\228\SUB\194a\nC\208,\200\143g\159&\189,\226\DC2\216[^\141\196\DEL\185\200\221\196\144\STX\141\182\CAN\217\\-\225Q\195B\227Z\184\134\FS\218\203=c\153<\ENQ\249\230\148@n\STX\134\185\202\168h\246Q\158\v4\179TE\ETBA0\254\DC1\247E\134\159\253\bn\194#\ENQl\155@\137\162\191e\136\148\215S\129U.0U\133\161$D\237P\144\142\150\143Oq\v\US4\231\199\176\209z6\162v>\"eV\170\247\246Hs\201\ACK\"\164\250\229\148\132\a\194L,\NAK\228\147\200\US\133\f\176\139-&4\132\&8\SYNR\RS\NAKs\253\204xo\151zJ\179\199m\213\248\230\145\149\176\200![@/\253=\217\&0\211\150\255\ETXPK\SOH\STX\RS\ETX\n\NUL\NUL\NUL\NUL\NUL'\186\241>\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\t\NUL\CAN\NUL\NUL\NUL\NUL\NUL\NUL\NUL\DLE\NUL\237A\NUL\NUL\NUL\NULMETA-INF/UT\ENQ\NUL\ETX\233\207#Nux\v\NUL\SOH\EOT\245\SOH\NUL\NUL\EOT\245\SOH\NUL\NULPK\SOH\STX\RS\ETX\DC4\NUL\NUL\NUL\b\NUL\188\184\241>\224\&5d\200\233\NUL\NUL\NUL+\ETX\NUL\NUL\NAK\NUL\CAN\NUL\NUL\NUL\NUL\NUL\SOH\NUL\NUL\NUL\164\129C\NUL\NUL\NULMETA-INF/manifest.xmlUT\ENQ\NUL\ETXC\205#Nux\v\NUL\SOH\EOT\245\SOH\NUL\NUL\EOT\245\SOH\NUL\NULPK\SOH\STX\RS\ETX\n\NUL\NUL\NUL\NUL\NUL)\184\241>\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\v\NUL\CAN\NUL\NUL\NUL\NUL\NUL\NUL\NUL\DLE\NUL\237A{\SOH\NUL\NULThumbnails/UT\ENQ\NUL\ETX.\204#Nux\v\NUL\SOH\EOT\245\SOH\NUL\NUL\EOT\245\SOH\NUL\NULPK\SOH\STX\RS\ETX\DC4\NUL\NUL\NUL\b\NUL\128\171j>\205_\234<\137\NUL\NUL\NUL\230\STX\NUL\NUL\CAN\NUL\CAN\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\164\129\192\SOH\NUL\NULThumbnails/thumbnail.pngUT\ENQ\NUL\ETX\224\178yMux\v\NUL\SOH\EOT\245\SOH\NUL\NUL\EOT\245\SOH\NUL\NULPK\SOH\STX\RS\ETX\DC4\NUL\NUL\NUL\b\NUL\CAN\186\241>\159\205o\152\239\SOH\NUL\NUL\215\ACK\NUL\NUL\v\NUL\CAN\NUL\NUL\NUL\NUL\NUL\SOH\NUL\NUL\NUL\164\129\155\STX\NUL\NULcontent.xmlUT\ENQ\NUL\ETX\208\207#Nux\v\NUL\SOH\EOT\245\SOH\NUL\NUL\EOT\245\SOH\NUL\NULPK\SOH\STX\RS\ETX\DC4\NUL\NUL\NUL\b\NUL\227\185\241>G{\214t\181\NUL\NUL\NULV\SOH\NUL\NUL\b\NUL\CAN\NUL\NUL\NUL\NUL\NUL\SOH\NUL\NUL\NUL\164\129\207\EOT\NUL\NULmeta.xmlUT\ENQ\NUL\ETXj\207#Nux\v\NUL\SOH\EOT\245\SOH\NUL\NUL\EOT\245\SOH\NUL\NULPK\SOH\STX\RS\ETX\n\NUL\NUL\NUL\NUL\NUL\128\171j>^\198\&2\f'\NUL\NUL\NUL'\NUL\NUL\NUL\b\NUL\CAN\NUL\NUL\NUL\NUL\NUL\SOH\NUL\NUL\NUL\164\129\198\ENQ\NUL\NULmimetypeUT\ENQ\NUL\ETX\224\178yMux\v\NUL\SOH\EOT\245\SOH\NUL\NUL\EOT\245\SOH\NUL\NULPK\SOH\STX\RS\ETX\DC4\NUL\NUL\NUL\b\NUL\224\185\241>!\SOH\STX\158\166\NUL\NUL\NUL2\SOH\NUL\NUL\f\NUL\CAN\NUL\NUL\NUL\NUL\NUL\SOH\NUL\NUL\NUL\164\129/\ACK\NUL\NULsettings.xmlUT\ENQ\NUL\ETXd\207#Nux\v\NUL\SOH\EOT\245\SOH\NUL\NUL\EOT\245\SOH\NUL\NULPK\SOH\STX\RS\ETX\DC4\NUL\NUL\NUL\b\NUL\226\185\241>\"\150]\t5\DC1\NUL\NUL\"\209\NUL\NUL\n\NUL\CAN\NUL\NUL\NUL\NUL\NUL\SOH\NUL\NUL\NUL\164\129\ESC\a\NUL\NULstyles.xmlUT\ENQ\NUL\ETXg\207#Nux\v\NUL\SOH\EOT\245\SOH\NUL\NUL\EOT\245\SOH\NUL\NULPK\ENQ\ACK\NUL\NUL\NUL\NUL\t\NUL\t\NUL\232\STX\NUL\NUL\148\CAN\NUL\NUL\NUL\NUL"),("dzslides/template.html","<!DOCTYPE html>\n\n<meta charset=\"utf-8\">\n<title>The Title Of Your Presentation</title>\n\n<!-- Your Slides -->\n<!-- One section is one slide -->\n\n<section>\n    <!-- This is the first slide -->\n    <h1>My Presentation</h1>\n    <footer>by John Doe</footer>\n</section>\n\n<section>\n    <p>Some random text: But I've never been to the moon! You can see how I lived before I met you. Also Zoidberg.\n    I could if you hadn't turned on the light and shut off my stereo.</p>\n</section>\n\n<section>\n    <h3>An incremental list</h3>\n    <ul class=\"incremental\">\n      <li>Item 1\n      <li>Item 2\n      <li>Item 3\n    </ul>\n    <details>Some notes. They are only visible using onstage shell.</details>\n</section>\n\n<section>\n  <q>\n    Who's brave enough to fly into something we all keep calling a death sphere?\n  </q>\n</section>\n\n<section>\n    <h2>Part two</h2>\n</section>\n\n<section>\n    <figure> <!-- Figures are used to display images and videos fullpage -->\n      <img src=\"http://placekitten.com/g/800/600\">\n      <figcaption>An image</figcaption>\n    </figure>\n    <details>Kittens are so cute!</details>\n</section>\n\n<section>\n    <figure> <!-- Videos are automatically played -->\n      <video src=\"http://videos-cdn.mozilla.net/brand/Mozilla_Firefox_Manifesto_v0.2_640.webm\" poster=\"http://www.mozilla.org/images/about/poster.jpg\"></video>\n      <figcaption>A video</figcaption>\n    </figure>\n</section>\n\n<section>\n    <h2>End!</h2>\n</section>\n\n<!-- Your Style -->\n<!-- Define the style of your presentation -->\n\n<!-- Maybe a font from http://www.google.com/webfonts ? -->\n<link href='http://fonts.googleapis.com/css?family=Oswald' rel='stylesheet'>\n\n<style>\n  html { background-color: black; }\n  body { background-color: white; border-radius: 12px}\n  /* A section is a slide. It's size is 800x600, and this will never change */\n  section {\n      /* The font from Google */\n      font-family: 'Oswald', arial, serif;\n      font-size: 30px;\n  }\n  h1, h2 {\n    margin-top: 200px;\n    text-align: center;\n    font-size: 80px;\n  }\n  h3 {\n    margin: 100px 0 50px 100px;\n  }\n\n  ul {\n      margin: 50px 200px;\n  }\n\n  p {\n    margin: 75px;\n    font-size: 50px;\n  }\n\n  q {\n    display: block;\n    width: 100%;\n    height: 100%;\n    background-color: black;\n    color: white;\n    font-size: 60px;\n    padding: 50px;\n  }\n\n  /* Figures are displayed full-page, with the caption\n     on top of the image/video */\n  figure {\n    background-color: black;\n  }\n  figcaption {\n    margin: 70px;\n    font-size: 50px;\n  }\n\n  footer {\n    position: absolute;\n    bottom: 0;\n    width: 100%;\n    padding: 40px;\n    text-align: right;\n    background-color: #F3F4F8;\n    border-top: 1px solid #CCC;\n  }\n\n  /* Transition effect */\n  /* Feel free to change the transition effect for original\n     animations. See here:\n     https://developer.mozilla.org/en/CSS/CSS_transitions\n     How to use CSS3 Transitions: */\n  section {\n      -moz-transition: left 400ms linear 0s;\n      -webkit-transition: left 400ms linear 0s;\n      -ms-transition: left 400ms linear 0s;\n      transition: left 400ms linear 0s;\n  }\n\n  /* Before */\n  section { left: -150%; }\n  /* Now */\n  section[aria-selected] { left: 0; }\n  /* After */\n  section[aria-selected] ~ section { left: +150%; }\n\n  /* Incremental elements */\n\n  /* By default, visible */\n  .incremental > * { opacity: 1; }\n\n  /* The current item */\n  .incremental > *[aria-selected] { opacity: 1; }\n\n  /* The items to-be-selected */\n  .incremental > *[aria-selected] ~ * { opacity: 0; }\n\n  /* The progressbar, at the bottom of the slides, show the global\n     progress of the presentation. */\n  #progress-bar {\n    height: 2px;\n    background: #AAA;\n  }\n</style>\n\n<!-- {{{{ dzslides core\n#\n#\n#     __  __  __       .  __   ___  __\n#    |  \\  / /__` |    | |  \\ |__  /__`\n#    |__/ /_ .__/ |___ | |__/ |___ .__/ core :\226\130\172\n#\n#\n# The following block of code is not supposed to be edited.\n# But if you want to change the behavior of these slides,\n# feel free to hack it!\n#\n-->\n\n<div id=\"progress-bar\"></div>\n\n<!-- Default Style -->\n<style>\n  * { margin: 0; padding: 0; -moz-box-sizing: border-box; -webkit-box-sizing: border-box; box-sizing: border-box; }\n  details { display: none; }\n  body {\n    width: 800px; height: 600px;\n    margin-left: -400px; margin-top: -300px;\n    position: absolute; top: 50%; left: 50%;\n    overflow: hidden;\n  }\n  section {\n    position: absolute;\n    pointer-events: none;\n    width: 100%; height: 100%;\n  }\n  section[aria-selected] { pointer-events: auto; }\n  html { overflow: hidden; }\n  body { display: none; }\n  body.loaded { display: block; }\n  .incremental {visibility: hidden; }\n  .incremental[active] {visibility: visible; }\n  #progress-bar{\n    bottom: 0;\n    position: absolute;\n    -moz-transition: width 400ms linear 0s;\n    -webkit-transition: width 400ms linear 0s;\n    -ms-transition: width 400ms linear 0s;\n    transition: width 400ms linear 0s;\n  }\n  figure {\n    width: 100%;\n    height: 100%;\n  }\n  figure > * {\n    position: absolute;\n  }\n  figure > img, figure > video {\n    width: 100%; height: 100%;\n  }\n</style>\n\n<script>\n  var Dz = {\n    remoteWindows: [],\n    idx: -1,\n    step: 0,\n    slides: null,\n    progressBar : null,\n    params: {\n      autoplay: \"1\"\n    }\n  };\n\n  Dz.init = function() {\n    document.body.className = \"loaded\";\n    this.slides = $$(\"body > section\");\n    this.progressBar = $(\"#progress-bar\");\n    this.setupParams();\n    this.onhashchange();\n    this.setupTouchEvents();\n    this.onresize();\n  }\n  \n  Dz.setupParams = function() {\n    var p = window.location.search.substr(1).split('&');\n    p.forEach(function(e, i, a) {\n      var keyVal = e.split('=');\n      Dz.params[keyVal[0]] = decodeURIComponent(keyVal[1]);\n    });\n  // Specific params handling\n    if (!+this.params.autoplay)\n      $$.forEach($$(\"video\"), function(v){ v.controls = true });\n  }\n\n  Dz.onkeydown = function(aEvent) {\n    // Don't intercept keyboard shortcuts\n    if (aEvent.altKey\n      || aEvent.ctrlKey\n      || aEvent.metaKey\n      || aEvent.shiftKey) {\n      return;\n    }\n    if ( aEvent.keyCode == 37 // left arrow\n      || aEvent.keyCode == 38 // up arrow\n      || aEvent.keyCode == 33 // page up\n    ) {\n      aEvent.preventDefault();\n      this.back();\n    }\n    if ( aEvent.keyCode == 39 // right arrow\n      || aEvent.keyCode == 40 // down arrow\n      || aEvent.keyCode == 34 // page down\n    ) {\n      aEvent.preventDefault();\n      this.forward();\n    }\n    if (aEvent.keyCode == 35) { // end\n      aEvent.preventDefault();\n      this.goEnd();\n    }\n    if (aEvent.keyCode == 36) { // home\n      aEvent.preventDefault();\n      this.goStart();\n    }\n    if (aEvent.keyCode == 32) { // space\n      aEvent.preventDefault();\n      this.toggleContent();\n    }\n    if (aEvent.keyCode == 70) { // f\n      aEvent.preventDefault();\n      this.goFullscreen();\n    }\n  }\n\n  /* Touch Events */\n\n  Dz.setupTouchEvents = function() {\n    var orgX, newX;\n    var tracking = false;\n\n    var db = document.body;\n    db.addEventListener(\"touchstart\", start.bind(this), false);\n    db.addEventListener(\"touchmove\", move.bind(this), false);\n\n    function start(aEvent) {\n      aEvent.preventDefault();\n      tracking = true;\n      orgX = aEvent.changedTouches[0].pageX;\n    }\n\n    function move(aEvent) {\n      if (!tracking) return;\n      newX = aEvent.changedTouches[0].pageX;\n      if (orgX - newX > 100) {\n        tracking = false;\n        this.forward();\n      } else {\n        if (orgX - newX < -100) {\n          tracking = false;\n          this.back();\n        }\n      }\n    }\n  }\n\n  /* Adapt the size of the slides to the window */\n\n  Dz.onresize = function() {\n    var db = document.body;\n    var sx = db.clientWidth / window.innerWidth;\n    var sy = db.clientHeight / window.innerHeight;\n    var transform = \"scale(\" + (1/Math.max(sx, sy)) + \")\";\n\n    db.style.MozTransform = transform;\n    db.style.WebkitTransform = transform;\n    db.style.OTransform = transform;\n    db.style.msTransform = transform;\n    db.style.transform = transform;\n  }\n\n\n  Dz.getDetails = function(aIdx) {\n    var s = $(\"section:nth-of-type(\" + aIdx + \")\");\n    var d = s.$(\"details\");\n    return d ? d.innerHTML : \"\";\n  }\n\n  Dz.onmessage = function(aEvent) {\n    var argv = aEvent.data.split(\" \"), argc = argv.length;\n    argv.forEach(function(e, i, a) { a[i] = decodeURIComponent(e) });\n    var win = aEvent.source;\n    if (argv[0] === \"REGISTER\" && argc === 1) {\n      this.remoteWindows.push(win);\n      this.postMsg(win, \"REGISTERED\", document.title, this.slides.length);\n      this.postMsg(win, \"CURSOR\", this.idx + \".\" + this.step);\n      return;\n    }\n    if (argv[0] === \"BACK\" && argc === 1)\n      this.back();\n    if (argv[0] === \"FORWARD\" && argc === 1)\n      this.forward();\n    if (argv[0] === \"START\" && argc === 1)\n      this.goStart();\n    if (argv[0] === \"END\" && argc === 1)\n      this.goEnd();\n    if (argv[0] === \"TOGGLE_CONTENT\" && argc === 1)\n      this.toggleContent();\n    if (argv[0] === \"SET_CURSOR\" && argc === 2)\n      window.location.hash = \"#\" + argv[1];\n    if (argv[0] === \"GET_CURSOR\" && argc === 1)\n      this.postMsg(win, \"CURSOR\", this.idx + \".\" + this.step);\n    if (argv[0] === \"GET_NOTES\" && argc === 1)\n      this.postMsg(win, \"NOTES\", this.getDetails(this.idx));\n  }\n\n  Dz.toggleContent = function() {\n    // If a Video is present in this new slide, play it.\n    // If a Video is present in the previous slide, stop it.\n    var s = $(\"section[aria-selected]\");\n    if (s) {\n      var video = s.$(\"video\");\n      if (video) {\n        if (video.ended || video.paused) {\n          video.play();\n        } else {\n          video.pause();\n        }\n      }\n    }\n  }\n\n  Dz.setCursor = function(aIdx, aStep) {\n    // If the user change the slide number in the URL bar, jump\n    // to this slide.\n    aStep = (aStep != 0 && typeof aStep !== \"undefined\") ? \".\" + aStep : \".0\";\n    window.location.hash = \"#\" + aIdx + aStep;\n  }\n\n  Dz.onhashchange = function() {\n    var cursor = window.location.hash.split(\"#\"),\n        newidx = 1,\n        newstep = 0;\n    if (cursor.length == 2) {\n      newidx = ~~cursor[1].split(\".\")[0];\n      newstep = ~~cursor[1].split(\".\")[1];\n      if (newstep > Dz.slides[newidx - 1].$$('.incremental > *').length) {\n        newstep = 0;\n        newidx++;\n      }\n    }\n    this.setProgress(newidx, newstep);\n    if (newidx != this.idx) {\n      this.setSlide(newidx);\n    }\n    if (newstep != this.step) {\n      this.setIncremental(newstep);\n    }\n    for (var i = 0; i < this.remoteWindows.length; i++) {\n      this.postMsg(this.remoteWindows[i], \"CURSOR\", this.idx + \".\" + this.step);\n    }\n  }\n\n  Dz.back = function() {\n    if (this.idx == 1 && this.step == 0) {\n      return;\n    }\n    if (this.step == 0) {\n      this.setCursor(this.idx - 1,\n                     this.slides[this.idx - 2].$$('.incremental > *').length);\n    } else {\n      this.setCursor(this.idx, this.step - 1);\n    }\n  }\n\n  Dz.forward = function() {\n    if (this.idx >= this.slides.length &&\n        this.step >= this.slides[this.idx - 1].$$('.incremental > *').length) {\n        return;\n    }\n    if (this.step >= this.slides[this.idx - 1].$$('.incremental > *').length) {\n      this.setCursor(this.idx + 1, 0);\n    } else {\n      this.setCursor(this.idx, this.step + 1);\n    }\n  }\n\n  Dz.goStart = function() {\n    this.setCursor(1, 0);\n  }\n\n  Dz.goEnd = function() {\n    var lastIdx = this.slides.length;\n    var lastStep = this.slides[lastIdx - 1].$$('.incremental > *').length;\n    this.setCursor(lastIdx, lastStep);\n  }\n\n  Dz.setSlide = function(aIdx) {\n    this.idx = aIdx;\n    var old = $(\"section[aria-selected]\");\n    var next = $(\"section:nth-of-type(\"+ this.idx +\")\");\n    if (old) {\n      old.removeAttribute(\"aria-selected\");\n      var video = old.$(\"video\");\n      if (video) {\n        video.pause();\n      }\n    }\n    if (next) {\n      next.setAttribute(\"aria-selected\", \"true\");\n      var video = next.$(\"video\");\n      if (video && !!+this.params.autoplay) {\n        video.play();\n      }\n    } else {\n      // That should not happen\n      this.idx = -1;\n      // console.warn(\"Slide doesn't exist.\");\n    }\n  }\n\n  Dz.setIncremental = function(aStep) {\n    this.step = aStep;\n    var old = this.slides[this.idx - 1].$('.incremental > *[aria-selected]');\n    if (old) {\n      old.removeAttribute('aria-selected');\n    }\n    var incrementals = $$('.incremental');\n    if (this.step <= 0) {\n      $$.forEach(incrementals, function(aNode) {\n        aNode.removeAttribute('active');\n      });\n      return;\n    }\n    var next = this.slides[this.idx - 1].$$('.incremental > *')[this.step - 1];\n    if (next) {\n      next.setAttribute('aria-selected', true);\n      next.parentNode.setAttribute('active', true);\n      var found = false;\n      $$.forEach(incrementals, function(aNode) {\n        if (aNode != next.parentNode)\n          if (found)\n            aNode.removeAttribute('active');\n          else\n            aNode.setAttribute('active', true);\n        else\n          found = true;\n      });\n    } else {\n      setCursor(this.idx, 0);\n    }\n    return next;\n  }\n\n  Dz.goFullscreen = function() {\n    var html = $('html'),\n        requestFullscreen = html.requestFullscreen || html.requestFullScreen || html.mozRequestFullScreen || html.webkitRequestFullScreen;\n    if (requestFullscreen) {\n      requestFullscreen.apply(html);\n    }\n  }\n  \n  Dz.setProgress = function(aIdx, aStep) {\n    var slide = $(\"section:nth-of-type(\"+ aIdx +\")\");\n    if (!slide)\n      return;\n    var steps = slide.$$('.incremental > *').length + 1,\n        slideSize = 100 / (this.slides.length - 1),\n        stepSize = slideSize / steps;\n    this.progressBar.style.width = ((aIdx - 1) * slideSize + aStep * stepSize) + '%';\n  }\n  \n  Dz.postMsg = function(aWin, aMsg) { // [arg0, [arg1...]]\n    aMsg = [aMsg];\n    for (var i = 2; i < arguments.length; i++)\n      aMsg.push(encodeURIComponent(arguments[i]));\n    aWin.postMessage(aMsg.join(\" \"), \"*\");\n  }\n  \n  function init() {\n    Dz.init();\n    window.onkeydown = Dz.onkeydown.bind(Dz);\n    window.onresize = Dz.onresize.bind(Dz);\n    window.onhashchange = Dz.onhashchange.bind(Dz);\n    window.onmessage = Dz.onmessage.bind(Dz);\n  }\n\n  window.onload = init;\n</script>\n\n\n<script> // Helpers\n  if (!Function.prototype.bind) {\n    Function.prototype.bind = function (oThis) {\n\n      // closest thing possible to the ECMAScript 5 internal IsCallable\n      // function \n      if (typeof this !== \"function\")\n      throw new TypeError(\n        \"Function.prototype.bind - what is trying to be fBound is not callable\"\n      );\n\n      var aArgs = Array.prototype.slice.call(arguments, 1),\n          fToBind = this,\n          fNOP = function () {},\n          fBound = function () {\n            return fToBind.apply( this instanceof fNOP ? this : oThis || window,\n                   aArgs.concat(Array.prototype.slice.call(arguments)));\n          };\n\n      fNOP.prototype = this.prototype;\n      fBound.prototype = new fNOP();\n\n      return fBound;\n    };\n  }\n\n  var $ = (HTMLElement.prototype.$ = function(aQuery) {\n    return this.querySelector(aQuery);\n  }).bind(document);\n\n  var $$ = (HTMLElement.prototype.$$ = function(aQuery) {\n    return this.querySelectorAll(aQuery);\n  }).bind(document);\n\n  $$.forEach = function(nodeList, fun) {\n    Array.prototype.forEach.call(nodeList, fun);\n  }\n\n</script>\n<!-- vim: set fdm=marker: }}} -->\n"),("reference_docx/[Content_Types].xml","<Types xmlns=\"http://schemas.openxmlformats.org/package/2006/content-types\">\n  <Override PartName=\"/word/webSettings.xml\" ContentType=\"application/vnd.openxmlformats-officedocument.wordprocessingml.webSettings+xml\"/>\n  <Override PartName=\"/word/numbering.xml\" ContentType=\"application/vnd.openxmlformats-officedocument.wordprocessingml.numbering+xml\"/>\n  <Override PartName=\"/word/settings.xml\" ContentType=\"application/vnd.openxmlformats-officedocument.wordprocessingml.settings+xml\"/>\n  <Override PartName=\"/word/theme/theme1.xml\" ContentType=\"application/vnd.openxmlformats-officedocument.theme+xml\"/>\n  <Override PartName=\"/word/fontTable.xml\" ContentType=\"application/vnd.openxmlformats-officedocument.wordprocessingml.fontTable+xml\"/>\n  <Override PartName=\"/docProps/app.xml\" ContentType=\"application/vnd.openxmlformats-officedocument.extended-properties+xml\"/>\n  <Override PartName=\"/docProps/core.xml\" ContentType=\"application/vnd.openxmlformats-package.core-properties+xml\"/>\n  <Override PartName=\"/word/styles.xml\" ContentType=\"application/vnd.openxmlformats-officedocument.wordprocessingml.styles+xml\"/>\n  <Override PartName=\"/word/document.xml\" ContentType=\"application/vnd.openxmlformats-officedocument.wordprocessingml.document.main+xml\"/>\n  <Override PartName=\"/word/footnotes.xml\" ContentType=\"application/vnd.openxmlformats-officedocument.wordprocessingml.footnotes+xml\"/>\n  <Default ContentType=\"application/vnd.openxmlformats-package.relationships+xml\" Extension=\"rels\"/>\n  <Default ContentType=\"application/xml\" Extension=\"xml\"/>\n  <Default ContentType=\"application/pdf\" Extension=\"pdf\"/>\n  <Default ContentType=\"image/x-emf\" Extension=\"emf\"/>\n  <Default ContentType=\"image/png\" Extension=\"png\"/>\n  <Default ContentType=\"image/jpeg\" Extension=\"jpeg\"/>\n  <Default ContentType=\"image/gif\" Extension=\"gif\"/>\n</Types>\n"),("reference_docx/docProps/app.xml","<Properties xmlns=\"http://schemas.openxmlformats.org/officeDocument/2006/extended-properties\" xmlns:vt=\"http://schemas.openxmlformats.org/officeDocument/2006/docPropsVTypes\">\n  <Words>83</Words>\n  <SharedDoc>false</SharedDoc>\n  <HyperlinksChanged>false</HyperlinksChanged>\n  <Lines>12</Lines>\n  <AppVersion>12.0000</AppVersion>\n  <LinksUpToDate>false</LinksUpToDate>\n  <Application>Microsoft Word 12.0.0</Application>\n  <CharactersWithSpaces>583</CharactersWithSpaces>\n  <Template>Normal.dotm</Template>\n  <DocSecurity>0</DocSecurity>\n  <TotalTime>6</TotalTime>\n  <ScaleCrop>false</ScaleCrop>\n  <Characters>475</Characters>\n  <Paragraphs>8</Paragraphs>\n  <Pages>1</Pages>\n</Properties>\n"),("reference_docx/docProps/core.xml","<ns0:coreProperties xmlns:ns0=\"http://schemas.openxmlformats.org/package/2006/metadata/core-properties\">\n  <dc:title xmlns:dc=\"http://purl.org/dc/elements/1.1/\">Pandoc reference docx</dc:title>\n  <dc:subject xmlns:dc=\"http://purl.org/dc/elements/1.1/\"></dc:subject>\n  <dc:creator xmlns:dc=\"http://purl.org/dc/elements/1.1/\"></dc:creator>\n  <ns0:keywords></ns0:keywords>\n  <ns0:lastModifiedBy></ns0:lastModifiedBy>\n  <ns0:revision>1</ns0:revision>\n  <ns0:category></ns0:category>\n  <dc:description xmlns:dc=\"http://purl.org/dc/elements/1.1/\"></dc:description>\n  <dcterms:created xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xsi:type=\"dcterms:W3CDTF\">2012-01-03T11:25:54Z</dcterms:created>\n  <dcterms:modified xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xsi:type=\"dcterms:W3CDTF\">2012-01-03T11:25:54Z</dcterms:modified>\n</ns0:coreProperties>\n"),("reference_docx/word/document.xml","<?xml version=\"1.0\" encoding=\"utf-8\" ?>\n<w:document xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\">\n<w:body>\n<w:p>\n  <w:r>\n    <w:t>\n      Hello world.\n    </w:t>\n  </w:r>\n</w:p>\n</w:body>\n</w:document>\n"),("reference_docx/word/fontTable.xml","<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\r\n<w:fonts xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\" xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\">\r\n\t<w:font w:name=\"Symbol\">\r\n\t\t<w:panose1 w:val=\"02000500000000000000\"/>\r\n\t\t<w:charset w:val=\"02\"/>\r\n\t\t<w:family w:val=\"auto\"/>\r\n\t\t<w:pitch w:val=\"variable\"/>\r\n\t\t<w:sig w:usb0=\"00000000\" w:usb1=\"00000000\" w:usb2=\"00010000\" w:usb3=\"00000000\" w:csb0=\"80000000\" w:csb1=\"00000000\"/>\r\n\t</w:font>\r\n\t<w:font w:name=\"Times New Roman\">\r\n\t\t<w:panose1 w:val=\"02020603050405020304\"/>\r\n\t\t<w:charset w:val=\"00\"/>\r\n\t\t<w:family w:val=\"auto\"/>\r\n\t\t<w:pitch w:val=\"variable\"/>\r\n\t\t<w:sig w:usb0=\"00000003\" w:usb1=\"00000000\" w:usb2=\"00000000\" w:usb3=\"00000000\" w:csb0=\"00000001\" w:csb1=\"00000000\"/>\r\n\t</w:font>\r\n\t<w:font w:name=\"Courier New\">\r\n\t\t<w:panose1 w:val=\"02070309020205020404\"/>\r\n\t\t<w:charset w:val=\"00\"/>\r\n\t\t<w:family w:val=\"auto\"/>\r\n\t\t<w:pitch w:val=\"variable\"/>\r\n\t\t<w:sig w:usb0=\"00000003\" w:usb1=\"00000000\" w:usb2=\"00000000\" w:usb3=\"00000000\" w:csb0=\"00000001\" w:csb1=\"00000000\"/>\r\n\t</w:font>\r\n\t<w:font w:name=\"Wingdings\">\r\n\t\t<w:panose1 w:val=\"05020102010804080708\"/>\r\n\t\t<w:charset w:val=\"02\"/>\r\n\t\t<w:family w:val=\"auto\"/>\r\n\t\t<w:pitch w:val=\"variable\"/>\r\n\t\t<w:sig w:usb0=\"00000000\" w:usb1=\"00000000\" w:usb2=\"00010000\" w:usb3=\"00000000\" w:csb0=\"80000000\" w:csb1=\"00000000\"/>\r\n\t</w:font>\r\n\t<w:font w:name=\"Cambria\">\r\n\t\t<w:panose1 w:val=\"02040503050406030204\"/>\r\n\t\t<w:charset w:val=\"00\"/>\r\n\t\t<w:family w:val=\"auto\"/>\r\n\t\t<w:pitch w:val=\"variable\"/>\r\n\t\t<w:sig w:usb0=\"00000003\" w:usb1=\"00000000\" w:usb2=\"00000000\" w:usb3=\"00000000\" w:csb0=\"00000001\" w:csb1=\"00000000\"/>\r\n\t</w:font>\r\n\t<w:font w:name=\"Calibri\">\r\n\t\t<w:panose1 w:val=\"020F0502020204030204\"/>\r\n\t\t<w:charset w:val=\"00\"/>\r\n\t\t<w:family w:val=\"auto\"/>\r\n\t\t<w:pitch w:val=\"variable\"/>\r\n\t\t<w:sig w:usb0=\"00000003\" w:usb1=\"00000000\" w:usb2=\"00000000\" w:usb3=\"00000000\" w:csb0=\"00000001\" w:csb1=\"00000000\"/>\r\n\t</w:font>\r\n\t<w:font w:name=\"Arial\">\r\n\t\t<w:panose1 w:val=\"020B0604020202020204\"/>\r\n\t\t<w:charset w:val=\"00\"/>\r\n\t\t<w:family w:val=\"auto\"/>\r\n\t\t<w:pitch w:val=\"variable\"/>\r\n\t\t<w:sig w:usb0=\"00000003\" w:usb1=\"00000000\" w:usb2=\"00000000\" w:usb3=\"00000000\" w:csb0=\"00000001\" w:csb1=\"00000000\"/>\r\n\t</w:font>\r\n</w:fonts>\r\n"),("reference_docx/word/footnotes.xml","<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<w:footnotes\n    xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\"\n    xmlns:m=\"http://schemas.openxmlformats.org/officeDocument/2006/math\"\n    xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\"\n    xmlns:o=\"urn:schemas-microsoft-com:office:office\"\n    xmlns:v=\"urn:schemas-microsoft-com:vml\"\n    xmlns:w10=\"urn:schemas-microsoft-com:office:word\"\n    xmlns:a=\"http://schemas.openxmlformats.org/drawingml/2006/main\"\n    xmlns:pic=\"http://schemas.openxmlformats.org/drawingml/2006/picture\"\n    xmlns:wp=\"http://schemas.openxmlformats.org/drawingml/2006/wordprocessingDrawing\">\n</w:footnotes>\n"),("reference_docx/word/numbering.xml","<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<w:numbering xmlns:mv=\"urn:schemas-microsoft-com:mac:vml\" xmlns:mo=\"http://schemas.microsoft.com/office/mac/office/2008/main\" xmlns:ve=\"http://schemas.openxmlformats.org/markup-compatibility/2006\" xmlns:o=\"urn:schemas-microsoft-com:office:office\" xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\" xmlns:m=\"http://schemas.openxmlformats.org/officeDocument/2006/math\" xmlns:v=\"urn:schemas-microsoft-com:vml\" xmlns:w10=\"urn:schemas-microsoft-com:office:word\" xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\" xmlns:wne=\"http://schemas.microsoft.com/office/word/2006/wordml\" xmlns:wp=\"http://schemas.openxmlformats.org/drawingml/2006/wordprocessingDrawing\">\n\t<w:abstractNum w:abstractNumId=\"0\">\n\t\t<w:nsid w:val=\"FFFFFF1D\"/>\n\t\t<w:multiLevelType w:val=\"multilevel\"/>\n\t\t<w:tmpl w:val=\"D0409C7C\"/>\n\t\t<w:lvl w:ilvl=\"0\">\n\t\t\t<w:start w:val=\"1\"/>\n\t\t\t<w:numFmt w:val=\"bullet\"/>\n\t\t\t<w:lvlText w:val=\"\"/>\n\t\t\t<w:lvlJc w:val=\"left\"/>\n\t\t\t<w:pPr>\n\t\t\t\t<w:tabs>\n\t\t\t\t\t<w:tab w:val=\"num\" w:pos=\"0\"/>\n\t\t\t\t</w:tabs>\n\t\t\t\t<w:ind w:left=\"0\" w:firstLine=\"0\"/>\n\t\t\t</w:pPr>\n\t\t\t<w:rPr>\n\t\t\t\t<w:rFonts w:ascii=\"Symbol\" w:hAnsi=\"Symbol\" w:hint=\"default\"/>\n\t\t\t</w:rPr>\n\t\t</w:lvl>\n\t\t<w:lvl w:ilvl=\"1\">\n\t\t\t<w:start w:val=\"1\"/>\n\t\t\t<w:numFmt w:val=\"bullet\"/>\n\t\t\t<w:lvlText w:val=\"\239\130\183\"/>\n\t\t\t<w:lvlJc w:val=\"left\"/>\n\t\t\t<w:pPr>\n\t\t\t\t<w:tabs>\n\t\t\t\t\t<w:tab w:val=\"num\" w:pos=\"720\"/>\n\t\t\t\t</w:tabs>\n\t\t\t\t<w:ind w:left=\"1080\" w:hanging=\"360\"/>\n\t\t\t</w:pPr>\n\t\t\t<w:rPr>\n\t\t\t\t<w:rFonts w:ascii=\"Symbol\" w:hAnsi=\"Symbol\" w:hint=\"default\"/>\n\t\t\t</w:rPr>\n\t\t</w:lvl>\n\t\t<w:lvl w:ilvl=\"2\">\n\t\t\t<w:start w:val=\"1\"/>\n\t\t\t<w:numFmt w:val=\"bullet\"/>\n\t\t\t<w:lvlText w:val=\"o\"/>\n\t\t\t<w:lvlJc w:val=\"left\"/>\n\t\t\t<w:pPr>\n\t\t\t\t<w:tabs>\n\t\t\t\t\t<w:tab w:val=\"num\" w:pos=\"1440\"/>\n\t\t\t\t</w:tabs>\n\t\t\t\t<w:ind w:left=\"1800\" w:hanging=\"360\"/>\n\t\t\t</w:pPr>\n\t\t\t<w:rPr>\n\t\t\t\t<w:rFonts w:ascii=\"Courier New\" w:hAnsi=\"Courier New\" w:hint=\"default\"/>\n\t\t\t</w:rPr>\n\t\t</w:lvl>\n\t\t<w:lvl w:ilvl=\"3\">\n\t\t\t<w:start w:val=\"1\"/>\n\t\t\t<w:numFmt w:val=\"bullet\"/>\n\t\t\t<w:lvlText w:val=\"\239\130\167\"/>\n\t\t\t<w:lvlJc w:val=\"left\"/>\n\t\t\t<w:pPr>\n\t\t\t\t<w:tabs>\n\t\t\t\t\t<w:tab w:val=\"num\" w:pos=\"2160\"/>\n\t\t\t\t</w:tabs>\n\t\t\t\t<w:ind w:left=\"2520\" w:hanging=\"360\"/>\n\t\t\t</w:pPr>\n\t\t\t<w:rPr>\n\t\t\t\t<w:rFonts w:ascii=\"Wingdings\" w:hAnsi=\"Wingdings\" w:hint=\"default\"/>\n\t\t\t</w:rPr>\n\t\t</w:lvl>\n\t\t<w:lvl w:ilvl=\"4\">\n\t\t\t<w:start w:val=\"1\"/>\n\t\t\t<w:numFmt w:val=\"bullet\"/>\n\t\t\t<w:lvlText w:val=\"\239\131\186\"/>\n\t\t\t<w:lvlJc w:val=\"left\"/>\n\t\t\t<w:pPr>\n\t\t\t\t<w:tabs>\n\t\t\t\t\t<w:tab w:val=\"num\" w:pos=\"2880\"/>\n\t\t\t\t</w:tabs>\n\t\t\t\t<w:ind w:left=\"3240\" w:hanging=\"360\"/>\n\t\t\t</w:pPr>\n\t\t\t<w:rPr>\n\t\t\t\t<w:rFonts w:ascii=\"Wingdings\" w:hAnsi=\"Wingdings\" w:hint=\"default\"/>\n\t\t\t</w:rPr>\n\t\t</w:lvl>\n\t\t<w:lvl w:ilvl=\"5\">\n\t\t\t<w:start w:val=\"1\"/>\n\t\t\t<w:numFmt w:val=\"bullet\"/>\n\t\t\t<w:lvlText w:val=\"\239\130\183\"/>\n\t\t\t<w:lvlJc w:val=\"left\"/>\n\t\t\t<w:pPr>\n\t\t\t\t<w:tabs>\n\t\t\t\t\t<w:tab w:val=\"num\" w:pos=\"3600\"/>\n\t\t\t\t</w:tabs>\n\t\t\t\t<w:ind w:left=\"3960\" w:hanging=\"360\"/>\n\t\t\t</w:pPr>\n\t\t\t<w:rPr>\n\t\t\t\t<w:rFonts w:ascii=\"Symbol\" w:hAnsi=\"Symbol\" w:hint=\"default\"/>\n\t\t\t</w:rPr>\n\t\t</w:lvl>\n\t\t<w:lvl w:ilvl=\"6\">\n\t\t\t<w:start w:val=\"1\"/>\n\t\t\t<w:numFmt w:val=\"bullet\"/>\n\t\t\t<w:lvlText w:val=\"o\"/>\n\t\t\t<w:lvlJc w:val=\"left\"/>\n\t\t\t<w:pPr>\n\t\t\t\t<w:tabs>\n\t\t\t\t\t<w:tab w:val=\"num\" w:pos=\"4320\"/>\n\t\t\t\t</w:tabs>\n\t\t\t\t<w:ind w:left=\"4680\" w:hanging=\"360\"/>\n\t\t\t</w:pPr>\n\t\t\t<w:rPr>\n\t\t\t\t<w:rFonts w:ascii=\"Courier New\" w:hAnsi=\"Courier New\" w:hint=\"default\"/>\n\t\t\t</w:rPr>\n\t\t</w:lvl>\n\t\t<w:lvl w:ilvl=\"7\">\n\t\t\t<w:start w:val=\"1\"/>\n\t\t\t<w:numFmt w:val=\"bullet\"/>\n\t\t\t<w:lvlText w:val=\"\239\130\167\"/>\n\t\t\t<w:lvlJc w:val=\"left\"/>\n\t\t\t<w:pPr>\n\t\t\t\t<w:tabs>\n\t\t\t\t\t<w:tab w:val=\"num\" w:pos=\"5040\"/>\n\t\t\t\t</w:tabs>\n\t\t\t\t<w:ind w:left=\"5400\" w:hanging=\"360\"/>\n\t\t\t</w:pPr>\n\t\t\t<w:rPr>\n\t\t\t\t<w:rFonts w:ascii=\"Wingdings\" w:hAnsi=\"Wingdings\" w:hint=\"default\"/>\n\t\t\t</w:rPr>\n\t\t</w:lvl>\n\t\t<w:lvl w:ilvl=\"8\">\n\t\t\t<w:start w:val=\"1\"/>\n\t\t\t<w:numFmt w:val=\"bullet\"/>\n\t\t\t<w:lvlText w:val=\"\239\131\186\"/>\n\t\t\t<w:lvlJc w:val=\"left\"/>\n\t\t\t<w:pPr>\n\t\t\t\t<w:tabs>\n\t\t\t\t\t<w:tab w:val=\"num\" w:pos=\"5760\"/>\n\t\t\t\t</w:tabs>\n\t\t\t\t<w:ind w:left=\"6120\" w:hanging=\"360\"/>\n\t\t\t</w:pPr>\n\t\t\t<w:rPr>\n\t\t\t\t<w:rFonts w:ascii=\"Wingdings\" w:hAnsi=\"Wingdings\" w:hint=\"default\"/>\n\t\t\t</w:rPr>\n\t\t</w:lvl>\n\t</w:abstractNum>\n\t<w:abstractNum w:abstractNumId=\"1\">\n\t\t<w:nsid w:val=\"30585973\"/>\n\t\t<w:multiLevelType w:val=\"multilevel\"/>\n\t\t<w:tmpl w:val=\"A47E15CE\"/>\n\t\t<w:lvl w:ilvl=\"0\">\n\t\t\t<w:start w:val=\"1\"/>\n\t\t\t<w:numFmt w:val=\"decimal\"/>\n\t\t\t<w:lvlText w:val=\"%1.\"/>\n\t\t\t<w:lvlJc w:val=\"left\"/>\n\t\t\t<w:pPr>\n\t\t\t\t<w:tabs>\n\t\t\t\t\t<w:tab w:val=\"num\" w:pos=\"720\"/>\n\t\t\t\t</w:tabs>\n\t\t\t\t<w:ind w:left=\"720\" w:hanging=\"720\"/>\n\t\t\t</w:pPr>\n\t\t</w:lvl>\n\t\t<w:lvl w:ilvl=\"1\">\n\t\t\t<w:start w:val=\"1\"/>\n\t\t\t<w:numFmt w:val=\"decimal\"/>\n\t\t\t<w:lvlText w:val=\"%2.\"/>\n\t\t\t<w:lvlJc w:val=\"left\"/>\n\t\t\t<w:pPr>\n\t\t\t\t<w:tabs>\n\t\t\t\t\t<w:tab w:val=\"num\" w:pos=\"1440\"/>\n\t\t\t\t</w:tabs>\n\t\t\t\t<w:ind w:left=\"1440\" w:hanging=\"720\"/>\n\t\t\t</w:pPr>\n\t\t</w:lvl>\n\t\t<w:lvl w:ilvl=\"2\">\n\t\t\t<w:start w:val=\"1\"/>\n\t\t\t<w:numFmt w:val=\"decimal\"/>\n\t\t\t<w:lvlText w:val=\"%3.\"/>\n\t\t\t<w:lvlJc w:val=\"left\"/>\n\t\t\t<w:pPr>\n\t\t\t\t<w:tabs>\n\t\t\t\t\t<w:tab w:val=\"num\" w:pos=\"2160\"/>\n\t\t\t\t</w:tabs>\n\t\t\t\t<w:ind w:left=\"2160\" w:hanging=\"720\"/>\n\t\t\t</w:pPr>\n\t\t</w:lvl>\n\t\t<w:lvl w:ilvl=\"3\">\n\t\t\t<w:start w:val=\"1\"/>\n\t\t\t<w:numFmt w:val=\"decimal\"/>\n\t\t\t<w:lvlText w:val=\"%4.\"/>\n\t\t\t<w:lvlJc w:val=\"left\"/>\n\t\t\t<w:pPr>\n\t\t\t\t<w:tabs>\n\t\t\t\t\t<w:tab w:val=\"num\" w:pos=\"2880\"/>\n\t\t\t\t</w:tabs>\n\t\t\t\t<w:ind w:left=\"2880\" w:hanging=\"720\"/>\n\t\t\t</w:pPr>\n\t\t</w:lvl>\n\t\t<w:lvl w:ilvl=\"4\">\n\t\t\t<w:start w:val=\"1\"/>\n\t\t\t<w:numFmt w:val=\"decimal\"/>\n\t\t\t<w:lvlText w:val=\"%5.\"/>\n\t\t\t<w:lvlJc w:val=\"left\"/>\n\t\t\t<w:pPr>\n\t\t\t\t<w:tabs>\n\t\t\t\t\t<w:tab w:val=\"num\" w:pos=\"3600\"/>\n\t\t\t\t</w:tabs>\n\t\t\t\t<w:ind w:left=\"3600\" w:hanging=\"720\"/>\n\t\t\t</w:pPr>\n\t\t</w:lvl>\n\t\t<w:lvl w:ilvl=\"5\">\n\t\t\t<w:start w:val=\"1\"/>\n\t\t\t<w:numFmt w:val=\"decimal\"/>\n\t\t\t<w:lvlText w:val=\"%6.\"/>\n\t\t\t<w:lvlJc w:val=\"left\"/>\n\t\t\t<w:pPr>\n\t\t\t\t<w:tabs>\n\t\t\t\t\t<w:tab w:val=\"num\" w:pos=\"4320\"/>\n\t\t\t\t</w:tabs>\n\t\t\t\t<w:ind w:left=\"4320\" w:hanging=\"720\"/>\n\t\t\t</w:pPr>\n\t\t</w:lvl>\n\t\t<w:lvl w:ilvl=\"6\">\n\t\t\t<w:start w:val=\"1\"/>\n\t\t\t<w:numFmt w:val=\"decimal\"/>\n\t\t\t<w:lvlText w:val=\"%7.\"/>\n\t\t\t<w:lvlJc w:val=\"left\"/>\n\t\t\t<w:pPr>\n\t\t\t\t<w:tabs>\n\t\t\t\t\t<w:tab w:val=\"num\" w:pos=\"5040\"/>\n\t\t\t\t</w:tabs>\n\t\t\t\t<w:ind w:left=\"5040\" w:hanging=\"720\"/>\n\t\t\t</w:pPr>\n\t\t</w:lvl>\n\t\t<w:lvl w:ilvl=\"7\">\n\t\t\t<w:start w:val=\"1\"/>\n\t\t\t<w:numFmt w:val=\"decimal\"/>\n\t\t\t<w:lvlText w:val=\"%8.\"/>\n\t\t\t<w:lvlJc w:val=\"left\"/>\n\t\t\t<w:pPr>\n\t\t\t\t<w:tabs>\n\t\t\t\t\t<w:tab w:val=\"num\" w:pos=\"5760\"/>\n\t\t\t\t</w:tabs>\n\t\t\t\t<w:ind w:left=\"5760\" w:hanging=\"720\"/>\n\t\t\t</w:pPr>\n\t\t</w:lvl>\n\t\t<w:lvl w:ilvl=\"8\">\n\t\t\t<w:start w:val=\"1\"/>\n\t\t\t<w:numFmt w:val=\"decimal\"/>\n\t\t\t<w:lvlText w:val=\"%9.\"/>\n\t\t\t<w:lvlJc w:val=\"left\"/>\n\t\t\t<w:pPr>\n\t\t\t\t<w:tabs>\n\t\t\t\t\t<w:tab w:val=\"num\" w:pos=\"6480\"/>\n\t\t\t\t</w:tabs>\n\t\t\t\t<w:ind w:left=\"6480\" w:hanging=\"720\"/>\n\t\t\t</w:pPr>\n\t\t</w:lvl>\n\t</w:abstractNum>\n\t<w:num w:numId=\"1\">\n\t\t<w:abstractNumId w:val=\"0\"/>\n\t</w:num>\n\t<w:num w:numId=\"2\">\n\t\t<w:abstractNumId w:val=\"1\"/>\n\t\t<w:lvlOverride w:ilvl=\"0\">\n\t\t\t<w:startOverride w:val=\"1\"/>\n\t\t</w:lvlOverride>\n\t\t<w:lvlOverride w:ilvl=\"1\">\n\t\t\t<w:startOverride w:val=\"1\"/>\n\t\t</w:lvlOverride>\n\t\t<w:lvlOverride w:ilvl=\"2\">\n\t\t\t<w:startOverride w:val=\"1\"/>\n\t\t</w:lvlOverride>\n\t\t<w:lvlOverride w:ilvl=\"3\">\n\t\t\t<w:startOverride w:val=\"1\"/>\n\t\t</w:lvlOverride>\n\t\t<w:lvlOverride w:ilvl=\"4\">\n\t\t\t<w:startOverride w:val=\"1\"/>\n\t\t</w:lvlOverride>\n\t\t<w:lvlOverride w:ilvl=\"5\">\n\t\t\t<w:startOverride w:val=\"1\"/>\n\t\t</w:lvlOverride>\n\t\t<w:lvlOverride w:ilvl=\"6\">\n\t\t\t<w:startOverride w:val=\"1\"/>\n\t\t</w:lvlOverride>\n\t\t<w:lvlOverride w:ilvl=\"7\">\n\t\t\t<w:startOverride w:val=\"1\"/>\n\t\t</w:lvlOverride>\n\t\t<w:lvlOverride w:ilvl=\"8\">\n\t\t\t<w:startOverride w:val=\"1\"/>\n\t\t</w:lvlOverride>\n\t</w:num>\n</w:numbering>\n"),("reference_docx/word/settings.xml","<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<w:settings xmlns:o=\"urn:schemas-microsoft-com:office:office\" xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\" xmlns:m=\"http://schemas.openxmlformats.org/officeDocument/2006/math\" xmlns:v=\"urn:schemas-microsoft-com:vml\" xmlns:w10=\"urn:schemas-microsoft-com:office:word\" xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\" xmlns:sl=\"http://schemas.openxmlformats.org/schemaLibrary/2006/main\">\n  <w:zoom w:percent=\"90\"/>\n  <w:embedSystemFonts/>\n  <w:proofState w:spelling=\"clean\" w:grammar=\"clean\"/>\n  <w:stylePaneFormatFilter w:val=\"0004\"/>\n  <w:doNotTrackMoves/>\n  <w:defaultTabStop w:val=\"720\"/>\n  <w:drawingGridHorizontalSpacing w:val=\"360\"/>\n  <w:drawingGridVerticalSpacing w:val=\"360\"/>\n  <w:displayHorizontalDrawingGridEvery w:val=\"0\"/>\n  <w:displayVerticalDrawingGridEvery w:val=\"0\"/>\n  <w:characterSpacingControl w:val=\"doNotCompress\"/>\n  <w:savePreviewPicture/>\n  <w:rsids>\n    <w:rsidRoot w:val=\"00590D07\"/>\n    <w:rsid w:val=\"00011C8B\"/>\n    <w:rsid w:val=\"004E29B3\"/>\n    <w:rsid w:val=\"00590D07\"/>\n    <w:rsid w:val=\"00784D58\"/>\n    <w:rsid w:val=\"008D6863\"/>\n    <w:rsid w:val=\"00B86B75\"/>\n    <w:rsid w:val=\"00BC48D5\"/>\n    <w:rsid w:val=\"00C36279\"/>\n    <w:rsid w:val=\"00E315A3\"/>\n  </w:rsids>\n  <m:mathPr>\n    <m:mathFont m:val=\"Lucida Grande\"/>\n    <m:brkBin m:val=\"before\"/>\n    <m:brkBinSub m:val=\"--\"/>\n    <m:smallFrac m:val=\"false\"/>\n    <m:dispDef m:val=\"false\"/>\n    <m:lMargin m:val=\"0\"/>\n    <m:rMargin m:val=\"0\"/>\n    <m:wrapRight/>\n    <m:intLim m:val=\"subSup\"/>\n    <m:naryLim m:val=\"subSup\"/>\n  </m:mathPr>\n  <w:themeFontLang w:val=\"en-US\"/>\n  <w:clrSchemeMapping w:bg1=\"light1\" w:t1=\"dark1\" w:bg2=\"light2\" w:t2=\"dark2\" w:accent1=\"accent1\" w:accent2=\"accent2\" w:accent3=\"accent3\" w:accent4=\"accent4\" w:accent5=\"accent5\" w:accent6=\"accent6\" w:hyperlink=\"hyperlink\" w:followedHyperlink=\"followedHyperlink\"/>\n  <w:decimalSymbol w:val=\".\"/>\n  <w:listSeparator w:val=\",\"/>\n</w:settings>\n"),("reference_docx/word/styles.xml","<?xml version=\"1.0\" encoding=\"utf-8\" standalone=\"yes\"?>\n<w:styles xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\"\nxmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\">\n  <w:docDefaults>\n    <w:rPrDefault>\n      <w:rPr>\n        <w:rFonts w:asciiTheme=\"minorHAnsi\"\n        w:eastAsiaTheme=\"minorHAnsi\" w:hAnsiTheme=\"minorHAnsi\"\n        w:cstheme=\"minorBidi\" />\n        <w:sz w:val=\"24\" />\n        <w:szCs w:val=\"24\" />\n        <w:lang w:val=\"en-US\" w:eastAsia=\"en-US\" w:bidi=\"ar-SA\" />\n      </w:rPr>\n    </w:rPrDefault>\n    <w:pPrDefault>\n      <w:pPr>\n        <w:spacing w:after=\"200\" />\n      </w:pPr>\n    </w:pPrDefault>\n  </w:docDefaults>\n  <w:latentStyles w:defLockedState=\"0\" w:defUIPriority=\"0\"\n  w:defSemiHidden=\"0\" w:defUnhideWhenUsed=\"0\" w:defQFormat=\"0\"\n  w:count=\"276\" />\n  <w:style w:type=\"paragraph\" w:default=\"1\" w:styleId=\"Normal\">\n    <w:name w:val=\"Normal\" />\n    <w:qFormat />\n  </w:style>\n  <w:style w:type=\"paragraph\" w:styleId=\"Title\">\n    <w:name w:val=\"Title\" />\n    <w:basedOn w:val=\"Normal\" />\n    <w:next w:val=\"Normal\" />\n    <w:qFormat />\n    <w:pPr>\n      <w:keepNext />\n      <w:keepLines />\n      <w:spacing w:before=\"480\" w:after=\"240\" />\n      <w:jc w:val=\"center\" />\n    </w:pPr>\n    <w:rPr>\n      <w:rFonts w:asciiTheme=\"majorHAnsi\"\n      w:eastAsiaTheme=\"majorEastAsia\" w:hAnsiTheme=\"majorHAnsi\"\n      w:cstheme=\"majorBidi\" />\n      <w:b />\n      <w:bCs />\n      <w:color w:val=\"345A8A\" w:themeColor=\"accent1\"\n      w:themeShade=\"B5\" />\n      <w:sz w:val=\"36\" />\n      <w:szCs w:val=\"36\" />\n    </w:rPr>\n  </w:style>\n  <w:style w:type=\"paragraph\" w:styleId=\"Authors\">\n    <w:name w:val=\"Authors\" />\n    <w:next w:val=\"Normal\" />\n    <w:qFormat />\n    <w:pPr>\n      <w:keepNext />\n      <w:keepLines />\n      <w:jc w:val=\"center\" />\n    </w:pPr>\n  </w:style>\n  <w:style w:type=\"paragraph\" w:styleId=\"Date\">\n    <w:name w:val=\"Date\" />\n    <w:next w:val=\"Normal\" />\n    <w:qFormat />\n    <w:pPr>\n      <w:keepNext />\n      <w:keepLines />\n      <w:jc w:val=\"center\" />\n    </w:pPr>\n  </w:style>\n  <w:style w:type=\"paragraph\" w:styleId=\"Heading1\">\n    <w:name w:val=\"Heading 1\" />\n    <w:basedOn w:val=\"Normal\" />\n    <w:next w:val=\"Normal\" />\n    <w:uiPriority w:val=\"9\" />\n    <w:qFormat />\n    <w:pPr>\n      <w:keepNext />\n      <w:keepLines />\n      <w:spacing w:before=\"480\" w:after=\"0\" />\n      <w:outlineLvl w:val=\"0\" />\n    </w:pPr>\n    <w:rPr>\n      <w:rFonts w:asciiTheme=\"majorHAnsi\"\n      w:eastAsiaTheme=\"majorEastAsia\" w:hAnsiTheme=\"majorHAnsi\"\n      w:cstheme=\"majorBidi\" />\n      <w:b />\n      <w:bCs />\n      <w:color w:val=\"345A8A\" w:themeColor=\"accent1\"\n      w:themeShade=\"B5\" />\n      <w:sz w:val=\"36\" />\n      <w:szCs w:val=\"36\" />\n    </w:rPr>\n  </w:style>\n  <w:style w:type=\"paragraph\" w:styleId=\"Heading2\">\n    <w:name w:val=\"Heading 2\" />\n    <w:basedOn w:val=\"Normal\" />\n    <w:next w:val=\"Normal\" />\n    <w:uiPriority w:val=\"9\" />\n    <w:unhideWhenUsed />\n    <w:qFormat />\n    <w:pPr>\n      <w:keepNext />\n      <w:keepLines />\n      <w:spacing w:before=\"200\" w:after=\"0\" />\n      <w:outlineLvl w:val=\"1\" />\n    </w:pPr>\n    <w:rPr>\n      <w:rFonts w:asciiTheme=\"majorHAnsi\"\n      w:eastAsiaTheme=\"majorEastAsia\" w:hAnsiTheme=\"majorHAnsi\"\n      w:cstheme=\"majorBidi\" />\n      <w:b />\n      <w:bCs />\n      <w:color w:val=\"4F81BD\" w:themeColor=\"accent1\" />\n      <w:sz w:val=\"32\" />\n      <w:szCs w:val=\"32\" />\n    </w:rPr>\n  </w:style>\n  <w:style w:type=\"paragraph\" w:styleId=\"Heading3\">\n    <w:name w:val=\"Heading 3\" />\n    <w:basedOn w:val=\"Normal\" />\n    <w:next w:val=\"Normal\" />\n    <w:uiPriority w:val=\"9\" />\n    <w:unhideWhenUsed />\n    <w:qFormat />\n    <w:pPr>\n      <w:keepNext />\n      <w:keepLines />\n      <w:spacing w:before=\"200\" w:after=\"0\" />\n      <w:outlineLvl w:val=\"1\" />\n    </w:pPr>\n    <w:rPr>\n      <w:rFonts w:asciiTheme=\"majorHAnsi\"\n      w:eastAsiaTheme=\"majorEastAsia\" w:hAnsiTheme=\"majorHAnsi\"\n      w:cstheme=\"majorBidi\" />\n      <w:b />\n      <w:bCs />\n      <w:color w:val=\"4F81BD\" w:themeColor=\"accent1\" />\n      <w:sz w:val=\"28\" />\n      <w:szCs w:val=\"28\" />\n    </w:rPr>\n  </w:style>\n  <w:style w:type=\"paragraph\" w:styleId=\"Heading4\">\n    <w:name w:val=\"Heading 4\" />\n    <w:basedOn w:val=\"Normal\" />\n    <w:next w:val=\"Normal\" />\n    <w:uiPriority w:val=\"9\" />\n    <w:unhideWhenUsed />\n    <w:qFormat />\n    <w:pPr>\n      <w:keepNext />\n      <w:keepLines />\n      <w:spacing w:before=\"200\" w:after=\"0\" />\n      <w:outlineLvl w:val=\"1\" />\n    </w:pPr>\n    <w:rPr>\n      <w:rFonts w:asciiTheme=\"majorHAnsi\"\n      w:eastAsiaTheme=\"majorEastAsia\" w:hAnsiTheme=\"majorHAnsi\"\n      w:cstheme=\"majorBidi\" />\n      <w:b />\n      <w:bCs />\n      <w:color w:val=\"4F81BD\" w:themeColor=\"accent1\" />\n      <w:sz w:val=\"24\" />\n      <w:szCs w:val=\"24\" />\n    </w:rPr>\n  </w:style>\n  <w:style w:type=\"paragraph\" w:styleId=\"Heading5\">\n    <w:name w:val=\"Heading 5\" />\n    <w:basedOn w:val=\"Normal\" />\n    <w:next w:val=\"Normal\" />\n    <w:uiPriority w:val=\"9\" />\n    <w:unhideWhenUsed />\n    <w:qFormat />\n    <w:pPr>\n      <w:keepNext />\n      <w:keepLines />\n      <w:spacing w:before=\"200\" w:after=\"0\" />\n      <w:outlineLvl w:val=\"1\" />\n    </w:pPr>\n    <w:rPr>\n      <w:rFonts w:asciiTheme=\"majorHAnsi\"\n      w:eastAsiaTheme=\"majorEastAsia\" w:hAnsiTheme=\"majorHAnsi\"\n      w:cstheme=\"majorBidi\" />\n      <w:i />\n      <w:iCs />\n      <w:color w:val=\"4F81BD\" w:themeColor=\"accent1\" />\n      <w:sz w:val=\"24\" />\n      <w:szCs w:val=\"24\" />\n    </w:rPr>\n  </w:style>\n  <w:style w:type=\"paragraph\" w:styleId=\"BlockQuote\">\n    <w:name w:val=\"Block Quote\" />\n    <w:basedOn w:val=\"Normal\" />\n    <w:next w:val=\"Normal\" />\n    <w:uiPriority w:val=\"9\" />\n    <w:unhideWhenUsed />\n    <w:qFormat />\n    <w:pPr>\n      <w:spacing w:before=\"100\" w:after=\"100\" />\n    </w:pPr>\n    <w:rPr>\n      <w:rFonts w:asciiTheme=\"majorHAnsi\"\n      w:eastAsiaTheme=\"majorEastAsia\" w:hAnsiTheme=\"majorHAnsi\"\n      w:cstheme=\"majorBidi\" />\n      <w:bCs />\n      <w:sz w:val=\"20\" />\n      <w:szCs w:val=\"20\" />\n    </w:rPr>\n  </w:style>\n  <w:style w:type=\"character\" w:default=\"1\"\n  w:styleId=\"DefaultParagraphFont\">\n    <w:name w:val=\"Default Paragraph Font\" />\n    <w:semiHidden />\n    <w:unhideWhenUsed />\n  </w:style>\n  <w:style w:type=\"table\" w:default=\"1\" w:styleId=\"TableNormal\">\n    <w:name w:val=\"Normal Table\" />\n    <w:semiHidden />\n    <w:unhideWhenUsed />\n    <w:qFormat />\n    <w:tblPr>\n      <w:tblInd w:w=\"0\" w:type=\"dxa\" />\n      <w:tblCellMar>\n        <w:top w:w=\"0\" w:type=\"dxa\" />\n        <w:left w:w=\"108\" w:type=\"dxa\" />\n        <w:bottom w:w=\"0\" w:type=\"dxa\" />\n        <w:right w:w=\"108\" w:type=\"dxa\" />\n      </w:tblCellMar>\n    </w:tblPr>\n  </w:style>\n  <w:style w:type=\"paragraph\" w:styleId=\"DefinitionTerm\">\n    <w:name w:val=\"Definition Term\" />\n    <w:basedOn w:val=\"Normal\" />\n    <w:next w:val=\"Definition\" />\n    <w:pPr>\n      <w:keepNext />\n      <w:keepLines />\n      <w:spacing w:after=\"0\" />\n    </w:pPr>\n    <w:rPr>\n      <w:b />\n    </w:rPr>\n  </w:style>\n  <w:style w:type=\"paragraph\" w:styleId=\"Definition\">\n    <w:name w:val=\"Definition\" />\n    <w:basedOn w:val=\"Normal\" />\n  </w:style>\n  <w:style w:type=\"paragraph\" w:styleId=\"BodyText\">\n    <w:name w:val=\"Body Text\" />\n    <w:basedOn w:val=\"Normal\" />\n    <w:link w:val=\"BodyTextChar\" />\n    <w:pPr>\n      <w:spacing w:after=\"120\" />\n    </w:pPr>\n  </w:style>\n  <w:style w:type=\"paragraph\" w:styleId=\"TableCaption\">\n    <w:name w:val=\"Table Caption\" />\n    <w:basedOn w:val=\"Normal\" />\n    <w:link w:val=\"BodyTextChar\" />\n    <w:pPr>\n      <w:spacing w:before=\"0\" w:after=\"120\" />\n    </w:pPr>\n    <w:rPr>\n      <w:i />\n    </w:rPr>\n  </w:style>\n  <w:style w:type=\"paragraph\" w:styleId=\"ImageCaption\">\n    <w:name w:val=\"Image Caption\" />\n    <w:basedOn w:val=\"Normal\" />\n    <w:link w:val=\"BodyTextChar\" />\n    <w:pPr>\n      <w:spacing w:before=\"0\" w:after=\"120\" />\n    </w:pPr>\n    <w:rPr>\n      <w:i />\n    </w:rPr>\n  </w:style>\n  <w:style w:type=\"character\" w:customStyle=\"1\"\n  w:styleId=\"BodyTextChar\">\n    <w:name w:val=\"Body Text Char\" />\n    <w:basedOn w:val=\"DefaultParagraphFont\" />\n    <w:link w:val=\"BodyText\" />\n  </w:style>\n  <w:style w:type=\"character\" w:customStyle=\"1\"\n  w:styleId=\"VerbatimChar\">\n    <w:name w:val=\"Verbatim Char\" />\n    <w:basedOn w:val=\"BodyTextChar\" />\n    <w:rPr>\n      <w:rFonts w:ascii=\"Consolas\" w:hAnsi=\"Consolas\" />\n      <w:sz w:val=\"22\" />\n    </w:rPr>\n  </w:style>\n  <w:style w:type=\"character\" w:customStyle=\"1\"\n  w:styleId=\"FootnoteReference\">\n    <w:name w:val=\"Footnote Reference\" />\n    <w:basedOn w:val=\"BodyTextChar\" />\n    <w:rPr>\n      <w:vertAlign w:val=\"superscript\" />\n    </w:rPr>\n  </w:style>\n  <w:style w:type=\"character\" w:customStyle=\"1\"\n  w:styleId=\"Hyperlink\">\n    <w:name w:val=\"Hyperlink\" />\n    <w:basedOn w:val=\"BodyTextChar\" />\n    <w:rPr>\n      <w:color w:val=\"4F81BD\" w:themeColor=\"accent1\" />\n    </w:rPr>\n  </w:style>\n</w:styles>\n"),("reference_docx/word/webSettings.xml","<ns0:webSettings xmlns:ns0=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\">\n  <ns0:allowPNG/>\n  <ns0:doNotSaveAsSingleFile/>\n</ns0:webSettings>\n"),("reference_docx/word/_rels/document.xml.rels","<Relationships xmlns=\"http://schemas.openxmlformats.org/package/2006/relationships\">\n  <Relationship Type=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships/numbering\"\n  Id=\"rId1\" Target=\"numbering.xml\" />\n  <Relationship Type=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships/styles\"\n  Id=\"rId2\" Target=\"styles.xml\" />\n  <Relationship Type=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships/settings\"\n  Id=\"rId3\" Target=\"settings.xml\" />\n  <Relationship Type=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships/webSettings\"\n  Id=\"rId4\" Target=\"webSettings.xml\" />\n  <Relationship Type=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships/fontTable\"\n  Id=\"rId5\" Target=\"fontTable.xml\" />\n  <Relationship Type=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships/theme\"\n  Id=\"rId6\" Target=\"theme/theme1.xml\" />\n  <Relationship Type=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships/footnotes\"\n  Id=\"rId7\" Target=\"footnotes.xml\" />\n</Relationships>\n"),("reference_docx/word/theme/theme1.xml","<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\r\n<a:theme xmlns:a=\"http://schemas.openxmlformats.org/drawingml/2006/main\" name=\"Office Theme\"><a:themeElements><a:clrScheme name=\"Office\"><a:dk1><a:sysClr val=\"windowText\" lastClr=\"000000\"/></a:dk1><a:lt1><a:sysClr val=\"window\" lastClr=\"FFFFFF\"/></a:lt1><a:dk2><a:srgbClr val=\"1F497D\"/></a:dk2><a:lt2><a:srgbClr val=\"EEECE1\"/></a:lt2><a:accent1><a:srgbClr val=\"4F81BD\"/></a:accent1><a:accent2><a:srgbClr val=\"C0504D\"/></a:accent2><a:accent3><a:srgbClr val=\"9BBB59\"/></a:accent3><a:accent4><a:srgbClr val=\"8064A2\"/></a:accent4><a:accent5><a:srgbClr val=\"4BACC6\"/></a:accent5><a:accent6><a:srgbClr val=\"F79646\"/></a:accent6><a:hlink><a:srgbClr val=\"0000FF\"/></a:hlink><a:folHlink><a:srgbClr val=\"800080\"/></a:folHlink></a:clrScheme><a:fontScheme name=\"Office\"><a:majorFont><a:latin typeface=\"Calibri\"/><a:ea typeface=\"\"/><a:cs typeface=\"\"/><a:font script=\"Jpan\" typeface=\"\239\188\173\239\188\179 \227\130\180\227\130\183\227\131\131\227\130\175\"/><a:font script=\"Hang\" typeface=\"\235\167\145\236\157\128 \234\179\160\235\148\149\"/><a:font script=\"Hans\" typeface=\"\229\174\139\228\189\147\"/><a:font script=\"Hant\" typeface=\"\230\150\176\231\180\176\230\152\142\233\171\148\"/><a:font script=\"Arab\" typeface=\"Times New Roman\"/><a:font script=\"Hebr\" typeface=\"Times New Roman\"/><a:font script=\"Thai\" typeface=\"Angsana New\"/><a:font script=\"Ethi\" typeface=\"Nyala\"/><a:font script=\"Beng\" typeface=\"Vrinda\"/><a:font script=\"Gujr\" typeface=\"Shruti\"/><a:font script=\"Khmr\" typeface=\"MoolBoran\"/><a:font script=\"Knda\" typeface=\"Tunga\"/><a:font script=\"Guru\" typeface=\"Raavi\"/><a:font script=\"Cans\" typeface=\"Euphemia\"/><a:font script=\"Cher\" typeface=\"Plantagenet Cherokee\"/><a:font script=\"Yiii\" typeface=\"Microsoft Yi Baiti\"/><a:font script=\"Tibt\" typeface=\"Microsoft Himalaya\"/><a:font script=\"Thaa\" typeface=\"MV Boli\"/><a:font script=\"Deva\" typeface=\"Mangal\"/><a:font script=\"Telu\" typeface=\"Gautami\"/><a:font script=\"Taml\" typeface=\"Latha\"/><a:font script=\"Syrc\" typeface=\"Estrangelo Edessa\"/><a:font script=\"Orya\" typeface=\"Kalinga\"/><a:font script=\"Mlym\" typeface=\"Kartika\"/><a:font script=\"Laoo\" typeface=\"DokChampa\"/><a:font script=\"Sinh\" typeface=\"Iskoola Pota\"/><a:font script=\"Mong\" typeface=\"Mongolian Baiti\"/><a:font script=\"Viet\" typeface=\"Times New Roman\"/><a:font script=\"Uigh\" typeface=\"Microsoft Uighur\"/></a:majorFont><a:minorFont><a:latin typeface=\"Cambria\"/><a:ea typeface=\"\"/><a:cs typeface=\"\"/><a:font script=\"Jpan\" typeface=\"\239\188\173\239\188\179 \230\152\142\230\156\157\"/><a:font script=\"Hang\" typeface=\"\235\167\145\236\157\128 \234\179\160\235\148\149\"/><a:font script=\"Hans\" typeface=\"\229\174\139\228\189\147\"/><a:font script=\"Hant\" typeface=\"\230\150\176\231\180\176\230\152\142\233\171\148\"/><a:font script=\"Arab\" typeface=\"Arial\"/><a:font script=\"Hebr\" typeface=\"Arial\"/><a:font script=\"Thai\" typeface=\"Cordia New\"/><a:font script=\"Ethi\" typeface=\"Nyala\"/><a:font script=\"Beng\" typeface=\"Vrinda\"/><a:font script=\"Gujr\" typeface=\"Shruti\"/><a:font script=\"Khmr\" typeface=\"DaunPenh\"/><a:font script=\"Knda\" typeface=\"Tunga\"/><a:font script=\"Guru\" typeface=\"Raavi\"/><a:font script=\"Cans\" typeface=\"Euphemia\"/><a:font script=\"Cher\" typeface=\"Plantagenet Cherokee\"/><a:font script=\"Yiii\" typeface=\"Microsoft Yi Baiti\"/><a:font script=\"Tibt\" typeface=\"Microsoft Himalaya\"/><a:font script=\"Thaa\" typeface=\"MV Boli\"/><a:font script=\"Deva\" typeface=\"Mangal\"/><a:font script=\"Telu\" typeface=\"Gautami\"/><a:font script=\"Taml\" typeface=\"Latha\"/><a:font script=\"Syrc\" typeface=\"Estrangelo Edessa\"/><a:font script=\"Orya\" typeface=\"Kalinga\"/><a:font script=\"Mlym\" typeface=\"Kartika\"/><a:font script=\"Laoo\" typeface=\"DokChampa\"/><a:font script=\"Sinh\" typeface=\"Iskoola Pota\"/><a:font script=\"Mong\" typeface=\"Mongolian Baiti\"/><a:font script=\"Viet\" typeface=\"Arial\"/><a:font script=\"Uigh\" typeface=\"Microsoft Uighur\"/></a:minorFont></a:fontScheme><a:fmtScheme name=\"Office\"><a:fillStyleLst><a:solidFill><a:schemeClr val=\"phClr\"/></a:solidFill><a:gradFill rotWithShape=\"1\"><a:gsLst><a:gs pos=\"0\"><a:schemeClr val=\"phClr\"><a:tint val=\"50000\"/><a:satMod val=\"300000\"/></a:schemeClr></a:gs><a:gs pos=\"35000\"><a:schemeClr val=\"phClr\"><a:tint val=\"37000\"/><a:satMod val=\"300000\"/></a:schemeClr></a:gs><a:gs pos=\"100000\"><a:schemeClr val=\"phClr\"><a:tint val=\"15000\"/><a:satMod val=\"350000\"/></a:schemeClr></a:gs></a:gsLst><a:lin ang=\"16200000\" scaled=\"1\"/></a:gradFill><a:gradFill rotWithShape=\"1\"><a:gsLst><a:gs pos=\"0\"><a:schemeClr val=\"phClr\"><a:tint val=\"100000\"/><a:shade val=\"100000\"/><a:satMod val=\"130000\"/></a:schemeClr></a:gs><a:gs pos=\"100000\"><a:schemeClr val=\"phClr\"><a:tint val=\"50000\"/><a:shade val=\"100000\"/><a:satMod val=\"350000\"/></a:schemeClr></a:gs></a:gsLst><a:lin ang=\"16200000\" scaled=\"0\"/></a:gradFill></a:fillStyleLst><a:lnStyleLst><a:ln w=\"9525\" cap=\"flat\" cmpd=\"sng\" algn=\"ctr\"><a:solidFill><a:schemeClr val=\"phClr\"><a:shade val=\"95000\"/><a:satMod val=\"105000\"/></a:schemeClr></a:solidFill><a:prstDash val=\"solid\"/></a:ln><a:ln w=\"25400\" cap=\"flat\" cmpd=\"sng\" algn=\"ctr\"><a:solidFill><a:schemeClr val=\"phClr\"/></a:solidFill><a:prstDash val=\"solid\"/></a:ln><a:ln w=\"38100\" cap=\"flat\" cmpd=\"sng\" algn=\"ctr\"><a:solidFill><a:schemeClr val=\"phClr\"/></a:solidFill><a:prstDash val=\"solid\"/></a:ln></a:lnStyleLst><a:effectStyleLst><a:effectStyle><a:effectLst><a:outerShdw blurRad=\"40000\" dist=\"20000\" dir=\"5400000\" rotWithShape=\"0\"><a:srgbClr val=\"000000\"><a:alpha val=\"38000\"/></a:srgbClr></a:outerShdw></a:effectLst></a:effectStyle><a:effectStyle><a:effectLst><a:outerShdw blurRad=\"40000\" dist=\"23000\" dir=\"5400000\" rotWithShape=\"0\"><a:srgbClr val=\"000000\"><a:alpha val=\"35000\"/></a:srgbClr></a:outerShdw></a:effectLst></a:effectStyle><a:effectStyle><a:effectLst><a:outerShdw blurRad=\"40000\" dist=\"23000\" dir=\"5400000\" rotWithShape=\"0\"><a:srgbClr val=\"000000\"><a:alpha val=\"35000\"/></a:srgbClr></a:outerShdw></a:effectLst><a:scene3d><a:camera prst=\"orthographicFront\"><a:rot lat=\"0\" lon=\"0\" rev=\"0\"/></a:camera><a:lightRig rig=\"threePt\" dir=\"t\"><a:rot lat=\"0\" lon=\"0\" rev=\"1200000\"/></a:lightRig></a:scene3d><a:sp3d><a:bevelT w=\"63500\" h=\"25400\"/></a:sp3d></a:effectStyle></a:effectStyleLst><a:bgFillStyleLst><a:solidFill><a:schemeClr val=\"phClr\"/></a:solidFill><a:gradFill rotWithShape=\"1\"><a:gsLst><a:gs pos=\"0\"><a:schemeClr val=\"phClr\"><a:tint val=\"40000\"/><a:satMod val=\"350000\"/></a:schemeClr></a:gs><a:gs pos=\"40000\"><a:schemeClr val=\"phClr\"><a:tint val=\"45000\"/><a:shade val=\"99000\"/><a:satMod val=\"350000\"/></a:schemeClr></a:gs><a:gs pos=\"100000\"><a:schemeClr val=\"phClr\"><a:shade val=\"20000\"/><a:satMod val=\"255000\"/></a:schemeClr></a:gs></a:gsLst><a:path path=\"circle\"><a:fillToRect l=\"50000\" t=\"-80000\" r=\"50000\" b=\"180000\"/></a:path></a:gradFill><a:gradFill rotWithShape=\"1\"><a:gsLst><a:gs pos=\"0\"><a:schemeClr val=\"phClr\"><a:tint val=\"80000\"/><a:satMod val=\"300000\"/></a:schemeClr></a:gs><a:gs pos=\"100000\"><a:schemeClr val=\"phClr\"><a:shade val=\"30000\"/><a:satMod val=\"200000\"/></a:schemeClr></a:gs></a:gsLst><a:path path=\"circle\"><a:fillToRect l=\"50000\" t=\"50000\" r=\"50000\" b=\"50000\"/></a:path></a:gradFill></a:bgFillStyleLst></a:fmtScheme></a:themeElements><a:objectDefaults><a:spDef><a:spPr/><a:bodyPr/><a:lstStyle/><a:style><a:lnRef idx=\"1\"><a:schemeClr val=\"accent1\"/></a:lnRef><a:fillRef idx=\"3\"><a:schemeClr val=\"accent1\"/></a:fillRef><a:effectRef idx=\"2\"><a:schemeClr val=\"accent1\"/></a:effectRef><a:fontRef idx=\"minor\"><a:schemeClr val=\"lt1\"/></a:fontRef></a:style></a:spDef><a:lnDef><a:spPr/><a:bodyPr/><a:lstStyle/><a:style><a:lnRef idx=\"2\"><a:schemeClr val=\"accent1\"/></a:lnRef><a:fillRef idx=\"0\"><a:schemeClr val=\"accent1\"/></a:fillRef><a:effectRef idx=\"1\"><a:schemeClr val=\"accent1\"/></a:effectRef><a:fontRef idx=\"minor\"><a:schemeClr val=\"tx1\"/></a:fontRef></a:style></a:lnDef></a:objectDefaults><a:extraClrSchemeLst/></a:theme>"),("s5/default/blank.gif","GIF89a\SOH\NUL\SOH\NUL\145\255\NUL\255\255\255\NUL\NUL\NUL\192\192\192\NUL\NUL\NUL!\249\EOT\SOH\NUL\NUL\STX\NUL,\NUL\NUL\NUL\NUL\SOH\NUL\SOH\NUL\NUL\STX\STXT\SOH\NUL;"),("s5/default/bodybg.gif","GIF89a\230\NULN\SOH\196\255\NUL\192\192\192\181\181\181\189\189\189\198\198\198\206\206\206\214\214\214\222\222\222\231\231\231\239\239\239\247\247\247\231\239\239\239\247\247\247\255\255\198\206\206\206\214\214\214\222\222\222\231\231\181\189\189\189\198\198\231\247\247\206\222\222\214\231\231\222\239\239\198\214\214\189\206\206\206\231\231\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL!\249\EOT\SOH\NUL\NUL\NUL\NUL,\NUL\NUL\NUL\NUL\230\NULN\SOH\NUL\ENQ\255\224!\RS\207u\EM\212\243@\142\154B\164\STX\204\244lM\128\181\212|?)\v\160B\214c(,\nFo\185\212\&1\SYN\150\EOT\179\166\192\SOH\142DEe\168\173\252,\211pm\STX\SYN\155g\199\217\162\210p\156\223\240\218\136\212\184<\n\170\186\195\209(8\f\SIe=\n\DC4\EM\bqXdK\tP\135q<\DLE8k:a\v\DC4D9U3\tG\f\DLE\r;W\NAK\EM[\143hQ[\t\EM\133\152L\f\NAKH5\v\EM2\179\DC4\130\166\185<s\"\SI\r*v\SI\"\128\128\SOR<kV\143X\DLEM\NAK\NAK\161\186\177\158H\154=\179\184\\E\DC4\DC45Ji\185P\NUL\DC3\205\226a\158A\NAK\215\234\150\ETB\205\186\240\&3\188$\SI\ACKm\194#\SI\DEL\239\178\180\b\184g\160(Y2$\158\r\"\DLE(QB\198o\198\132g\EOT%\fDvkJ4Y\208\222-\128\144\NUL \141#\v\US\150\162\177f\156\132\v\RS\r\255\190\225\165o^>\a\"\174A0\ETBg#\DC3p\241~\FST\a\141\199+\143\ESCu\FS\163A\225B\SIU\183*4\164Qm\201\198W\NULJ\214`\DC4\EOT\203P\NUL\140\&2\240P\NAKUB\n\149\166\230\180t\217\v\230\129\173\234tI\237\215Jm\218!\156\128\240P:\DC1\227\207h\NAK(\f|\150!\ETX\EOTu\t\210nE\162\fY\218\192\NUL\CAN$PL\202B,&\170\248\ENQ^\252\tC[\176b\230\CAN0KvsL\SUBP\225\173\221$\216 \130\n\156\202\CAN\241\134\186\238\212\153\140, x\b\202\194\179(\139\DC1c-\r\250\178+\n\163f\182\STX\169 \161OR4ZC\200 \193\&7\230%#\f\\ ;\STX\194\244\179\201]?Z\203 C\202p\183\181\&6\225h\230\EM\172\132\132,8X\176@7\214B\188U\242F\194-\195\213\SUB\NAK\246J\225\214@\251\243\RS\195pF\157g\216yr_8`@\132Y\255h6\245\DLE\201\129bts\197\ENQ%\161\246\159\CAN\ETB\177\a!Q\FSZP\b\SOH\ETB\134!\130u\212Uw\221&\226\EM\196\192\ETX\NULH\136\153\132\f\184X\195Bb\f\196Hw\US\233`a\136S,eF\138\148|\210@|<\STX \194u%\RS`\143\b2\132\166\146VN\170x\CAN@\218\152\DC1\216\DC3JU%\131\ENQ\DLE\204T$\FS\198M\145\223^;\208\210\128\143<\RS\128d\146$\236!^\138\ACK\189\249\"\rp\ACK\241\CAN\DC3\200!\167\212{\232Us\209\151bL\240g\SI\SI\216\&7\131p\SYN0\183\225\DEL\a4\192\166X\133\206 #<yI\nV\138N\ACK\197\EOT_i\193\137\165 \206\SOH*_(\221( A\ACK\r\136j\228\154\143\RS !\156\210,6\ETX\172\185\148&!#\165qi\219\&3\178j\ETB\CAN\145=\NUL\171*\FS=\NAKd&\139\128\158\208\234\FS\226ud\144\140\180\154\"\163:\175\176\243\ETX\255\ETB\236\181\&7E\148\&5\SO\251\236\172\NUL\252\&3\SOH(\128\SUB\176l>\142\180\CAN\SI\141\234\198S\154V\147\177\167k\168sE\235\173A\249\&5\129CA\132d \NUL\160\231\142\144*\157\241\192*\236\ESC\EM\212\197\235\&3h\134a\239\189\238\STX\144\223\142\&4< E\SUB\222\&9\240\GSX\SOH\US9\145{\210\242\144\&0<\228\205u\176\152\139BL\233d\249\146\137\134\STX\b\DC4\DC2A\202\241t\220\232UW\154r\195\\4\135\145/~\254\149\215\179\202+\207\176\133\DC1\ENQI\\-\170A\ESC\212\177\n=\232\181\204e\DC4\155\210SrC\a\155\&5\209\238\198U\NAK*\237-\231\192\201\186t\140\135vU\v\141\ACK\175\DC2o=c+W#\146\193\160\\\135\CAN\v9I@\SOH\197b\133H@\183\211\GSS\bI\220g\244\132\196b\208\DLE\254\198\157\135\254=\ENQ\227\222\238\141\134\227*\129s\237\DLE\tq\242\151\212\140v\188\222\140AQ.\139\255\ENQH\215\208\165\232\131l\EM\r\187f$\253\229\DC3\174\233\202\b\ENQ\ETB\DC1\130:\FSGH\161%\DC4\142!!\192\198e\a|\199}:p\137\250S\NUL@\208\150\135\183;\EOT\ACK\204\n\209\219\132\244\185\&86\208iR \237Xb\214+0\247\NAK\DC3\252\160\CANhn##\155\DC2zs\242L\DLE\rP\US\135\231\200\170\145\151\f\145\152\177\&3\STXI\204\168<\228L4X\141\f\174\v\b\240\224\160\147\143\NUL'\DEL/\179\202&\152\STX@0\204b\v\242\218\193\DC3\194\145\144Ph\162#\EM\152\NUL7:\183\172\205\196\143\f\178:\136\CAN\210\176\189\143\f\193\&1\212\147\\A\232\227>\146\&4\204\DC4C\b\194)\174\DLE\ENQ\222\137\206{@\224\199,\148g\167#4o+'\172\146c\SYNp\166\231\156\171\CAN\200Z\192\SOH\\\163\NUL\141M\161#\140@\224\f\155\&8\192\201L\177)o@^<\STX\211\192Y\bA~\138\v\ETXN\174\144\132\255\EOT\240\144\140(\220\196\NUL7q\132fh\SOH\DC3\132(\223\DC4\240\241\168\DC4\CAN\192\NUL3\164B\NAK\184\225\155\226\\a)ih\227\198\160\168\ACK\b0\224\US@X\163\SUB\155\246\ACK(>$\135Qy\161)\160\DLE@\166\192\168\"YL\v{4\210\ACK\204\b(Ic\201\163\SUB\202\240\143g0\160.B\137\STX\SI\192QJC.\225!\139\132B\ENQ%\137\DC1\131\&8\230\CAN\t G\145\156\213?\134a\233\rFP^T\EOTc\137\SYN\138\225\SO\173\ne$WY\134\&5\\\NUL8\236\209B9\226\179\150d\184\210\ESCry\ENQ#f\194\rE&\166dp\216\193\t\UST\183k\132\&02o\b\223\&47q\129\129\&9m,\160\&4\139\252\214A\131_Q !\169\164[\131\134\153\&3\146P\203BkH\192\ENQ\200F\ETX/\133\DC3\v~*\231\EM@\198\200a:\DC4+\SO\NUL\DC1\224\224\&9\160\DC3u\196?\253\220\205BFc\158\188\b\255\194\140\168\161\152\151\fz\165n\158\193\160\153\EOT\160B\US\DC1#RX\177\DC2\128\161\SYN\ENQ\"\160\146\151$\t\STXx8\203h|\STX\FS\211M\163\&8I\160\216h^\161\NAKhTEb\209\208\230\194\196X\201m\253r\165\248Bj\202l\162\ESC\nH\NULp\195`\213<H\180\155\&0\184'\154\\hcGW\145\ETB\228$\ACK\169\201S\158\SI\167\&21\251\216\171\135M\165\147:2\240\128=A\NAK3\163\136\144\165Z\DC4\NUL\172\RS\169\SO\NAK=\v\183\136bVO\212\135\v\133\176D^\184Q\136U0\150vZ\b\ENQ\SYNA\211\141BH\236\149\202\147S\189:uW\RS\133d\t8jW\ENQ\250\n\143\234\&8JM\238\&0\215<\166\131\NAK\131\153\&51\STX\197@!( [\198\214\&6Q}\161@\NUL\128\&3[\SOH` 0\v \ETX\221\NULcY\153\144\241\n\ETB1%f\250B\n%\156\146X\224*\DC24\188'\166\232\ACK\160\161\255\"\154\195i\245pG^8j\175FC\v7\130\226\128\162\204-\178kx\198\ETX\186\177\138\NUL\184\212\DC2\153@(.$\180A\180\EOT\183\f@j\r^k\NUL\156\247F\179\186}i\151g'\203\131W\EM\141\180\185\208n;G\208\206\DC3\168\224\SO\ETB(@\SO\134\"\152\217\186\151\STX\STX\240[\ENQO\147\134\191$`1\176*T\NUL\EOT\224\157\191\DLE\167\148\209%\197\164\236\ETX\139\151\DC1E\142bX\ENQ\NUL^\203\&0\DC4RM\155\EOTC\ACK\SUB.5\ENQ\205\n\NUL\187L`\176KL\208\128\"c@\US,\130\147*\144\195\141\188\228'\SOH\180\179\142Ui\167\131P<c\182\171\152H\ENQ$ \129!\GS\183=\182!Jq7\241\ETB\172D7\a?|\EOT\178\236\243a*|!\a\v\131\211(>&\156\STX\198\ETX\145L\160ow\140\146`\DC1\156V\187G\218\195\RST@\136\132\152\a\202\SOHp\239\140\245reX\244\235\168\DC2\211\255\175\196f[\136\&6\207@\NULC\240\139\ENQ$\DLE\NUL\ENQ-\SUB4\DLE\129\&2x'%\221\245\201\144\140\233\147\STX\132\\\164\149K\140Q4\156\DC3\153\DC2P\ETX\SOH\SOH\192X`\171\237n>|\161#\222^\249\CAN\221\&8t3/pB8[\154`\240\EM\ENQX=T\148\223- \STX=m\145\132F\209)\173\156z\198\DLE\155\215\DC1\200\241\SI1\160\ACK\204\&3N\SUB\CANpA\208\SUB\CANJkh\173\NUL\159\US!\228y8\128U\190\CAN\STX\ENQ&\240\225\162\FSC+\205\DC2\207\STX,C\134# `P\163\NUL\SO\175lc\156!L\160\148\208h\242\172\&6(\152=\185(\174\170J\131\fw\218\131]\157\STX\a\248\147\r\233\218\&6g\137\157[\SYN\147\235D\176v\144\145\NUL\164Y\RS~\134\129\187\235\161\153\f\DLE\219\216z\170Tt\215\&0\DC3\227\NUL\220\201)\154O\177\205(\SOHU\236Vi\163\192\165x~6\178\187f\212\NAKzL\152\DC4\255\236C#\bP@\n\132\163\164\159h7r\163\153\202\155r8\DC2u\222\173Z\DC2\EOT\NUL\a3a\128m\130\253\&3\165\ENQ\198\141)\249\v\139q\169\CAN\170DE\144\134\132r\EOT\FS\176g\n\135\205P;J\155B\205\216\220\"@\153\DC1\201\145\193#\219\166\133\142\244\164j0\v+\235\146Cr(\152\156\221#R\214\144\187\RS\136\245l$/\ETB\248\213P\feY\201\241\NUL\NAK\203\&9\ACK\181;\138\ENQ.\216\ACK}\DC20F\208\153\194\DC3\168[\249\228\162:\165\EM/\226\tXl$\172X\b\133'p`8\170\131\134\146Q\193\202\226sp\b$l\SUB\235(\ETB\193\US\\B \229[u\a\USVwz\241B\153f<\189\226P\232\201r\174\191\202\171d\191\&5\234\SO\204\247\240\211x\163\193\222[\137j\236\142\242\182\189k\207\160.3\161QG\198\141\t\b\164\235\243[\210\STX\185\224\&0\a\201\207\129\ENQ*'\GS\EM6\EOT\255\ETX!\SOH\198\DC37\168\240d\ESCG\ENQ\192\199<q\240a\182Ar\t\227t\209@H^\226~\157\229Y\247\ETBC\167\161\f;3=d\164\NUL\CAN\128|s\208\STX\188\192\STX\170%\GS\169W~\SYNp\SOH\255\128R\135\af\247\DC1V5Q\ETBk\176\DC1;\NUL\SOH\ETX\NUL\ENQ\151`~`v\ba\148\129\162\210\ENQ\DLE$B\EOTQ\ACKG }p\208u&X\130)\216N\r\128G\201C?\142v'\FSa{\178Q\EOTH\NULdjtB\\\194X\171\176%\DC20\SOH\ETB \RS\198\135\ENQ\153 \132\128\178\133&\244a\GS!A\DLE\151;z\243\vp\176|\202GGMh\GSz\240\NUL;\DLE\viT?ixK\211p-\255\211BA@sN\215Qe\ENQ@\DC2\176\ENQ@p\SUB\EM\a@\198\164\134\143p94\160\bj\132\NUL-\229\FS\DC2\247\133\205\195\STX\248\144SwxGPh\a\SO\144\DELi\152\138\213\224%:\160\ENQ\255\245q\t\142!(\CAN\178\FSj\213;\SUB\178\CAN\174c*\151\224X\142\&8n\200G\137\&5!\b\165SO\185\179(\146C\ACK'\176\DC2\174R\NUL$\192\140\a\128\a\190p\SOH|\DLE\f=\200/H\152\ENQ\142\150\t(tp\236\161\CAN\150 p\163\176<\133\208;0C7\132\NUL@\DC4P\a\132\144X\186\196\t\231\a\140\136p\EM\227\131!\236`\GSnp\ACK#\208\STX\240\164\SI\166\136\SOHH\132v4\132\ACK\172\160#\254\150\133\160\197\t\171\144\144\171\224@\182\247v\227\196?\182\240\fu\240+g$\n\240\248%z\163\vf\EOT\129Jh\ACKs\224\a\248P\STX\SI\150z\a\240\at\ETB\144~\DC4I\223(\137\251\148\CAN\247\247~\254t\ESC\210$\ETBqQ\ENQ\233\240\f\152`\DC3\v`\STX\236q\v9IK\ETB\185E\195w\ACK\175\160\CANy!Q\153!\GS\207D\am\128\a&\249\v\245\192\135\145\&4\DEL\SIUh\176\132\137\255F\227M\STX\DC1\ETB\144\241a\216\&0OP\230\&7\182\&1\DC44\DC1\148<\130R\210\242\DC3\ETXp\ACK\r \NULE\214\a,P\146\208\134\STX\190\128\SI\ACK\192\SO\t\168\ACK\179\NAKR\235d\ETX\\\STX\a\191R\CAN^\229\ETB\187\241\EOT\227Uf\243d\150_\242\&0b\128\CANG\208\USfp\STX\SOH\216\ACK\159\DLEa\146\249n\195\192\SO\183\208\DC1\205\DLE\EMkP-\SIu8\229\ACK\SIK\182\FS\234`\STX3\SYN\n \163\152\255\SOHqgPeZ\DLE?=\194|\CAN\240\a\DC1V\STXf\161VX\145^\240\STX\CAN\134\DC4j\234P\DLE\221\145\DC2\221\&1\154g@\n\ESCAl\222s\b\131\197\154<\SYN\SI\198\129a\RS\201|{pd\141R\STX#\192\NAKJUO\161\134\FS\147!\RS\197Q\150\145vY\255aJ\DLE\128\SOH\150\NUL/\140\233\156\186 \ETB\130i\n\227B3\159$\SYN\DC1`\NULN\183$1\209m|SO\SOH\182\"PB\vD\DLEe\255x\241d\198I,\221\240\t\150\128q\191\200\158\229A\158\238r\143S\160\148\159d\SI{`.\247\DLE\DC31\146\149\130AW\v')\224)\\X3\DLE\164\246J+d\RS1\182\ETX\STX\160A\154\197\160\152\&1\EOT\193\185\EOT\158\230\&3\b\SYNd\164x\130\SOH\224(\DELP\DC4\142\"a\SO5[\230\150\CAN\145\146<\226\225\147DPv\229\230\163\231f\RSd58A\208\FS\244\197\162\173\t\ENQd\224\CAN\DEL\DC1f\SO*&\255\146]\141\194\v\ACK\DLE\NUL\211!\GS\141\DC2\fD\176\DC1,\182\161\236\229\"Tg\b4D1c6B\236\177\ESC|\193X\146\162\ETB\209\231!-\146H\216\ACK\165\255q\b\237\177\NULFyYd\179\147\239\153uj\226]\v&\141t\233(h\138or\150\144tB\v\ETX\128\ETX\SO\CAN^\166P\SO\139Q(\204%p\240\145<\228B\v<\180\160z\SUB\a\234\240\ETB<\193H\159\160\165\DEL&\STX^\234\SO\255w\216\NUL)\128\t\191\&2\158D\161\DC4^\201\r\167x\v\bpU303D\210v\217\STX:iQv\RSG\n\223f\vW0\134\149\NAK\170k\168\SOavMM`kS\160|*\183\165\&7\186\165G\"\f\r\160dW\ACK+\248v\ESC\ENQ'\ETX\ETB \SOH\STX \NULk@j\213\STX\v\209VH\170\153\ETB\178i4W\198G\NUL\208W\222\241\142\202j?\134W\170^\181\131\209j\173ZW\173v \STX \153\173u!~\177\214\"\171\137\ETB\213\128\SUBE\231\174\245\EOT\DC4\222`4\220p\NAK\182\225\NULY\166n\b\240q\245z!Q\176\177\206\186)\161R\146g\242W\ap\163,\208\132\215i\174\&3\ACKu\tY\SUBAP\DC1\222s\CANlSV\245Dq\229\&17R\192\DC1\244\SOH\ACK\157F\175\EM\251\154\156\208\&3\n\NUL\153K@\SOH\246y$\ETB\DLE\NUL\DLE\DLE\SOHQ\232g\170Eh\ESCCmS!/\142q\v5\a\DC1\255\135w\fmg\165\185\240\ETB\DC1tT\210\bc=\139;\238\&8\148W\176\DEL=\160,\239Fd\155!y\172\218\v\186\178)=A;\217\215%\178ap\187I\172\&9\216\ETB\152*\172\210\224\136\128\152\NUL\150\DC1\182\170\178\DC1\139\194\NUL\SO\240\146\&40\GS&)\GSg\STX\DC3\255\138\a\211\138?\192\225\SUBJQV\133PWO\NULilu\DC1\203\193\179\211s\177;0.A\NUL\182\130\251\ACKr\241\&8\SI\224\US\RS\180\a\186\165\SI\155\193\a\194\224\DELQq\131\US\161lks5\132\208\139\\\130\181\166\147\131\158\235\ETXT\SYN\CAN\aD\182\165k\DLE\178h\DC1\135\187\EOT\230R\NUL'\224\NULsW\146\250P^w\NUL\SOH,WO\ETX\225=\190WP\186\231@\137\247}\196\147\189\255\161\&7{\164\156\147X\188\aU\t\ENQ\224\ESCEa\aDK\146&\248n*\192\188\194\&0\b\133\209/\243\182\155\FS\177\ACK\180\NULM\177\129\184\CAN\137\RS\255\t\160\142\160j\190\CANB9\vP\NUL)Q\NUL\221\165\143\250\216\188\245\NUL\191\230RH\168\DC1W\198\199\&6\221\&4P\DC4\152\138\SYN\177\NUL\179Q\ENQ\np \179p<\183\180e\229K\192\SOH\161\137a`\SOHR\184\v\249\240\v9\234\148+\224\v\251\DLE\NAKB\129C\203S\FS\233\STXe\t\t\FS\RS\162\137\222\&3~9@:F\160\DC4H\224t\137\181J=h%\ACKW_&\140\EM\185\244\134\SYN\209\177\201G\a\143k\STX\128\160\192\DC40\141Q\DC4\186I\140\ACK\180\&0\r\DC1\148\SOH\ETXP\a\207t\142y4N\152\196\193\&6\217\RS\138\248\197\SOH)F\176\192\ACKM\252\US\\\249D0\NUL /\129L\251\216\STX\197`T\178\177C\171\132\DC2k\ETX\ESC\RS\130\EOT&p\v\130\156\146_\176\177APA\133\148\ESC\207\165A@P\b\134\228\USF\192%\CAN0\199tL9\158\224#&\219&\244\144\SI\210X\SI\ACK\240\193^I\ETBH\236F\255\128\241M\208g*\205\145\RS4\209 \129\&1D\189a\ESCcZ\SOI1?\140p\USA\161\171\154\172\DC2\171!\ACK\DLE\176\194D1\159\243\NUL\b\160l\ENQ\ETBu\r\196:]>\244\129\137As;\153\&8\253S%$\193\RS\163\160\ETX\132\EM\EM:p\v7\DLEC\252$\200\191\\9f0\204\NUL\178\143m0\f\\j\amDV-\166\151\US\204Gz\DC3m\193\188\147\DC4rU\232t\DC4\161R\171\152\EOT\167\US\156<\255\DC3P\233:\206\&0\244\DC1\141\201:J\194\EM\210\SOH\DC3\vm\159\SI\198\188\179\187\CAN\b\DLE\174N1\150\222\131\EOT\135\160\n\142`\SOH\187\&5P]\245~r\EOTe\212\"1\142\252~O\231\ETB\RSM\208\ENQ\157\ENQ\r\ENQ3\187@\"\195\128\SOH\245\t\128\237\180\au\128\192\168\200\196(\226JJ\161\ENQ9P\b\ETB\139\132\t\ETBR\242SC\176\231RFsF\148`\t4\171\210#4\SO\137q\188A\147\146\255\ENQ\181|\v\205\a\SOHP\130\229U\a\SI\128\&9%\SYN#\n\STX\214\218\212\173]\145*O\a\ACK\170\160\195\226\SOH\214\191B\188(\147\149\255C:z1\162N\253\212W\176\t\193<\b\196l$\DEL\230\SO\237\DC4\SOH\188\208\STXu\144\173\233\CAN\SOH\RS\245a\175uY\150\181\FS\147C\t0\210\"\FSj)\250\ACK\148\155\DC2\n\153u\ENQ\255@\166u\173\SYNj\240\207\175\196\163\ENQu\GS\149\137Z\169\218(\172[\USB1\164\188\SOH\214;\ACK@\238\144\ETB\153<i\SOH6+\241bT\231w5\198'\217t\189\217L\160\fD0\168\&4\176\215|\192`\142\226(H+\SYN#\NUL\206\228\201\\\193\210\DLE` \SOH\179\193\RS}\229\163\162\149\&8\203\225X%\140Vh4c\FS\177\158\188M\ETX\135\240\219j FW\241nf\177]jR\218#\128\SYN\239b\ACK3\218W\175``\179\146\SYNj\229\154\194\156\ENQG`Y\187\253\221:\166\ACK\255y\221?\r\193\184\233\173u#\219usp'|a\216\149\181\158\226\FS\175s*`\139\195\ESCy\ENQ\130-\146\158y\202\223\&5\161-\SYNA\204\168\NAK\166\215\161\a\CAN0\SI]\221\r\187\242\ETB\187UT\a\243\ETX.BZ2v\225B\179\&4E\245\&0\177\160\191\230\193\133\CAN\RS|\128\183\225r\DLE\133DV\220*\ETB\NUL\206\200`\ETBM\170\EM\240x\171\247~\222\232\DLE\144=2\137\152\ETBJ\224)S\229a\"\250#z\185\RS\251}\227\200\128>\149\176D4P\168D\214`\142\194\STX\SOH \f\161\232\NAK\r \SOH\DC1\240L\164\&2Z^\186\nc\227\199\242\182f\180\195\r\179Fa'\195\198\238J3\EOT\168\205G\142\229\CAN\178P\a0\DC4j\194u\253\183\182\240\203\EM\139\165<\199\150\ETBP\167\136\218\214\ENQ\210\198\232\201A\231pP-\226G3\246\129?\b\144\NUL\205\225\231VB\NAK\139\146\NUL\129N\ETX\DEL\176\180\188\160,\255\210(\SOHt4\SO\NUL\151y\217\145\178\225\185m\181y\221\SO\240\158zw\SO1k\192r\173\EOT\DC1\144\221\188M\NAK~\234\no:\ETX\252\232*u\160Z\\g\146$\137\GS0\n\190\a\DC1M}\145z\SI\145\197\173\176}6\142\US\DC3\DC3\132\140gx\130\227\233\141\185@\144\&1\236\171\226AGb.\150i.[\GS\133\131\DLEp\DEL\195X.\218\r\251F1\137\242'\222\200\193v\182)\172\CAN*\197\&2\DC2\222\254DC\147\227F\178\SI\249(\f&h\138\128\128\SOHf;\ETXE\166\237\251\230LJA\SOv0\DC1\ACK9#\240\129O\183\148\194T\199?j\196\153\192\221\239H~l\225\222\229\159\f\189\208\v\195\"p\DC2WQ\SOH\DC1\DLE\NUL)\193\233\181\224\NUL#\184^\GS\v\136\f!\238\188\147\&2\194\164\241\226\128\RS\RS\239U\193~\SO\155.\SI\212\v\230\163L\SI%+\f\128\176>\222\DLE\192\193Iu\128+\ETX\185\244L\255\164\208GAx{\184\148\217\143#\137N!\EOT\SUB\223\243Hn\ACKFp\f\209\209\v\237\228\140\&0L\SOH\208[\ENQ\134\198\ACK\202\131\DC2+\180\142A\144\SOHc\243\179Y\SI\EM(\132Kd\ESCH)Q\r]\239\245\224\RS\ACKAo$%H\240\181y\135Q\217\STXa\213MV\149\ENQj\154\ETX\DC1 \NUL\247tJ\167;\b\ESCcz\vQ\199G(\158lT\196~_\tMsH\161 \202A\254\NUL$\169\SID\235\186o\250\EOT[\248\239|oh\209\240j\200`z\SYN\180\&1Z\STX!\170\DEL\237~\SO\242K\128\NUL\142\DLE \211J\a0\DC1\189\174\250\EM\189\145\147a\168\GS\135\200\t\130\146\SO\244\ACK\148Z\DC2\v\176/\v8\155\ESC\171D\217\222\SO;4\195\193\135\178\a.\241\NUL\181\169\STX\229\ENQ\141\147?C\r\130\r!\148\152Sq\SUB\141\132\209[(I[\t\r\CAN\187\154\157\SI\238\226\238\DC4\142`\135\">hm h\255\SUB\ETX\STX\n4\SOH\229R\SOHgY&\149\149\172\137\178\172L\229\178\153\181\242<\163(&\SYN\151m\215\&3eR\EMH\134\ACK`\188\142\210)\181j\189b\179\218\RS\236\153`t\165\bD\233`>\163\r\SO\199\195qh\191\129\nDEa\130\164P\188\132\197\t\CAN\150@@|\157\168$P\232\&00H%$)PT\180$\224\GS\241%\200,P\EOT\SOH\180ly~\130\134\138\166,\132Q-\216\SOH\160\173\RS\168A8P\CAN\168=\FS<)\244M\224-,\SOH\232y\149B\208X\204X\EOT\DEL\225\&5B\248\182@,\246\252\236,\236\&4\250r%Q\ETXPp&\141v{\DEL\DEL\154R%\212\170\178\158\169\157\173\&94<\164\138\228\149\&0@\230\220\EOT\SI\ETX\r\211\216\180\160\244\251D\146\STX\164\STX$JT\130\245\210\134\"\n\184\134\SO\US\154\144We\SOH\EMs\231\f\\8\ETX\161\r\ENQv\DC4\140p;\145\SOH\133\r\ESC<*\255H\ETX\226d\199\&5C\EM\180\157\244\195\131\STX\197\b\213\166\160\212\&4\SOH\ENQL\136>\DEL\130r\150@f\143\ENQ\229\206\153y\133\166\129:\ENQ\ETB\138\249\137Da*$g+\180\225\131\SUB0G\tn<\DLE\246\224v\193j\149&\143Px\ENQ\170v\237\148.\fJ\141;z\SO\STX\211\&3p\206\NULp\n\147\231\141\SUBz\134\254Y0\225V\159\DC4\214\NUL<H\ESCH&J\DEL#o\RS\153\145\225\229\f\182\150/\175(u\137l\209\138H\SIdl\149\SOM\t\ENQ\143\147$A\244\210\215H\CANS\229\b\154\162\173'\143\180\v\148\221\152\170X\n\ENQ\b4wc\SO\254\147\232\145\ENQp\145\214\ENQ\GS\154\244\157C\217\DC2\170\166\NUL\ACK\143\163\202\164 \ETXHRa\183\156\204'\230\165\182\226\136BE\225\230\DEL\138cD\227\\\242\209\171js\170\176\200\235\246\237\139\179\211V\209\ETX\166\244#\EMR\173p\rL\192\ENQXB\NUL\156\157\151\255\224\&7\v XT\EMK-w\128\ETX\DLE\156\195\131\&4\156\244\226_\CAN\248(\214IX\t\GSA\ESC\v\212\233A`^\143\136\168\160\138\163|Q\ENQ\CAN\139\160q\SOH\133\171D\136\215L\206\164\216\139\US;\164h\210I0d@\SYN*R\164\150\SOH\f[\DC1y\193\138KvC\\%\199Ix\129\SOH\172$\247\222I\206\200Gd\SI\131q\182[\DC2\SI\132q\219\DC4\f4\211_/\233\149\144#\147kb\SOH\131\147\&5\FS\176\136\ETXRN\185\n\EOTRV\248cWh\"\185'\ETBY\174 \USJ\ENQR!\232VFJ1(\155\139^\241\SYN\131h\198\128\NUL\fm\212hF\165\&6\ACK\186H\159z^\169\225\149Lt\SOHD\131g\222\224\EOTX\SYN\SUB\193\168\170\140\176\224\196[\b\SO\181H\SOH\180\224i\ACK;u\230\EM(\r\138\RS\193k\t\155\254\SUB\198\160\NAKL\224\196\160\np&\159\&2Q\201\&4\201\170\207\RS\SOH\134\ETB`\192\NAK\255-\131\136IH\203\156\r\204\248\EM\SI@\252\250\166\175\NUL\156\SUB\211\n\b\217c\199\160\213\ACK\202\a\175\SYN `\213\184\208>+m\139\163\130\SOH\ETX\EOT\179>p\SOH-\159\&1\ETB\238\137T\136\202\131\ENQ$\FSQ\216\185.\196\251\223\188\231\138 \147iv@\241&\189\171J;\SO\\l8P\NUL\192\172\CAN\172\174\197\228\202\EOT\SOH\128_!Ln\US\190\245\ACK\SOHCR83\140\193\f\SOr\177\205{\188\&8\ENQ\STX4l\244\239\199\SOH_\248\199\201=\140\176\135\ENQ\r\202\\\130\ENQ}X@\211\SYNI\255A\ACK\212\&7\223l1\ETX\146\"\230\241\207VJ\ETX\ETX\184\EOT\159<\245\183\NUL\222\146O\RS\169V\241\181\204?\fM5\180\EM\235L\131\207[\219xKih?3\181\221\SYNn\167\201\ne\139\160\192\rm\ETB5\140\DC1\224\154\236\182\219\144\150\176\&3\NUL\179\190\209\192\ENQ\237\252\204\tC{GF\DLE\218\152\167\240\STXg\bd\181\255\ETX\231\197\221\131G.B+N\245\ETB\144^=\169\228\ENQ\204x\215g\150\152\128\247\223\209\156\fz\f.Oq\155\&4\186\216\190\229\b\192\SI\150\250\197/*\210\162\DC4\DC4\169\210\173]n|&xf\216\233g!\NUL;\201\179\180HC\223\246O\245\189\a\163\135\152\198\211\187\186am]\r\192\SUB\ETBhm\ACKF\DC3\174\242\128\252\&3\200\&0\t\154\227\175\160\189\fvd\210G$\223\DEL\167/\223\171Dc\200\167\&8\CAN\152oy\NUL \131,\f ;\247]\192\SOH\rl\195\SUB\CAN\196\&4\236\&4\226\ENQz\NULB#\242B\ETX\ENQD\160\DC3>\218]J8a\GSFD\STX;\ACK\132\150\171\218\STX%\bB\207\f\148\154\211rH\SYN\190\NULm\135\ETB5\144\EOT\a\255\163\f\a\220\160/\209\178\SIW\198d$\NAK\174pU\132\&8E\139hx\129\201\197\208\NAKkPC]\152V\f>\244\130z\EOT\225\ETX\197T\178\DC3\205P\129\SOH\SI\240\255K\161Z`\162$\170\234\DC2\167H\133\SOH 0%\231%eB\233\160\128\132\128\NUL*\148(\163\131\217\168\202Bl'\130\&3\DC2\234\tj2I\ACK\198\136F\170]\139\DC1r\249X\EOTe(\191\188,-\n\136\154\135/r\148\SI\211\&0n&\223z\DC3$&sH\170\193\173(\139\220Z\ESC<f\130\DC3\f!G#4\SOHah\160&.\224\r8\246\t\192'\171\&6\142\ENQ>\232g\178\144\160\ETX\203f\f0\212\a\DC1\136\&0\228L\200\&6\178@^\ENQf\SI8P-m\ACK\131\ACK\173'\151\159ic\EOT_\209\DC1\194(c\b\145\CANUf\208\246\202\SI\129\211`\219\201d3\153\212\194J\NUL\198\"\159i\228+(\168\146R\CAN\137\156]\217d\SYN \179\ESC\n(\175\156\208\202\164\fV\192HK\173\195\fw+\215D\f\146\157,X2l\199\212\167\130\194\228\162r\168\&3F\146s\163\148bX\139a\DC4+\v\171\FS\DC2\SYN\255\NUL\NAK\150\152\149\135\161\139ZD\ETB\248\t \SUB5 9s\154\211*Fg\133U>\167\158\226\216\149\215\b'R&)O\DC1cZ`\ETBV\250D\\M\SO4\172p\135'R\132\168*D\"H\133\147\131\216n\170D\141\249\161\129\&3\218\214\182\224\CAN\anF\235e)\176i\166n \SO\233 `0\\u\234\154\242i\173\&0\168\227\167s\178*:\142v\133a\137\227a\ACK\131Dz\ACK\DC34\178\RSoT\t\192Z\t\250\197\134\STX\252\DC4`\CANY\168\178\128%W\165\241\129\160w\192\171\205B\EM\153\&0<\192\129\254bk\SUB\216\144I\211\144\233a\240\162\130\204\SO\203\216\155\&1\174u+XCd?\230F\248\DC1\140X\228R\172\229 \ENQ\174b\164\236\179\169\&3+\ETB\216%\v]\SYN\NUL~\DLE\237A\193\150F82\185VtM\149\237\205\FS\235\131X\249skl\b\216\244\222\&1\\2\189)h.%\174\234\158\DLE\255\&7\RS\NUL\172c\ACK\232\200\220\246\224\130P\r70\189;\\x\169K/\227\238\&0\164\159\153\NAKF\230v\NUL\147\DC1Fa\168\&4h\200z\a\143\223\153\215x:\133\EM\CAN\147;T\139\166\161\NUL\248\224\171\239\232\155\191\182A\SOH\190\130\211A~\141\&72\230}er\STX`\223\ESC\NUL\140\134\&6\DLE\240\174\188\GSZ>v\182\b\233\&5\216\193\227H\US\SI\NUL\235\175\ACKH \STX\146\131\158 &\136a\128\228\134\193<\208\GS)RrB\137\132x\182\209\197%\SI\"\216\NUL\232a\EOT\ETX*\150\FS\SOH\158\CAN\193\ah\STX\155.\216E\SO\140\240\157\EOT\228\130 7\206\177\SOHi@[\DC3\168\145\a\r\136\192\228\STX\192e7\CAN@r\179H\233\148\FS\224\203>\184i\EMz\160\228\v\140\DC3S*\175\144\159!\237\235\ETXRLQ\f\EOT\128\134l\200\&3\ENQ$ \208\198\&5\235%#9\201\217P\DC1[8\147/\157\207`\192n\US\180\175\NUL\255\228\EM\160\239}\226\ETX~\252gOT\128\DC2\229E\180\219\160\153e\236\" )a\134t\NULD\163\ACK\SOH\196\144\211p\142\238\156Y@\SO4P\b\STX\164\150Ri/\173\133K\184Y\213h\132\DC49\164\176\ACKFF@\NUL?\158\220TR\218\128F\217Ca\186N\244N\ESC]\STXv\144\154\212)}\175T\GS \SOH\t4\NUL\DC1.P\128\EOT~u\131A\ETB(_\193[vu\139\163h\236\246,\178\212\188@\180U<\171\142\DLEdN\CAN\216\129G\SI\SUB\168 \146\187\202m\137\151\DC4\232&\161`_\251\STX\218\254\203\183\233\145\239f\178\206\217\210\244\183\194\&9\129\213\131\235{y\173^\184\191!.\219\156q\225\220\216e8\166,\238T7\241\ETBR\FS\239\184\199E\154<\206\192\128\175G\CAN\185\173Knr\226\&8jT,o\184\203k\249\233\SUB\176k\229,\175\249\199\&9C-\139\205\156\231\f\GS\nm\243\197\184\160\v\189\255\150p\v\165\163\170\128\244\164\215\178ZV\201\215\196\253\203q\168\151\211\184Dw\250\206\177\142\240gh\\\231#\247z\212\139Cb*<\157\236q\142\214^\175\144v\181\147\143\&80\160\185\213\EM\SO\247\NAK:\233\vU\223\248\216\239n\192\153.\240\225\DC1\173\184\223SW\n\162\232\GS\vo/\252\197Jj=~\187\189\235\140\175Zz\188\150\133\197O\254\169\&0k\187\226%\159yz\209@&\US\212\STX\230??\210\202\243\184\243}7=\198X\149s+\148\158\245Kj\145)\230.\248\186\DC3^\246\140\202\251\217U\DELu\221\167\145,z\191=\238\233\ACK\252\145:\220\aW#>\197\141\DEL|&\145\148,\139\200\&5\233=\255\252\134\250<\229\242\236A\236\175\US\FS\179~\225-\159\232\190\247\&1\147Ojm\159\251\214/\255y\224\150r\230\ETB\DELk\236_Q\CAN\146\183w\174\175~\254\230\201'\STX\ETB\218\239\245\235\US[8\255\131\171$\RS(\144_\NUL>\EOT\STXY\ENQ\STX\221\US\254\253\RS\STXZ\ACK\181X\200\SI\136\194\SOHB`C\176\139\DC34\160\ETX\218\221\ENQ\178\133\&8\204\221(X\160\a\142\194~ED\234\EM \NUL\146`C\NUL\RS\221\249^\a\174 D\128`\227t\195\b\198\224\SYN\152 \134\168\130\&7\216\224\rb\129cY\153\255\193\158\n\250`PpAi|C\SI\SYN\225)\DC4\a'\b\225\DLE\230\223\DC2\134\194\f\230\ENQ8(\161\DC4\RS\161\242\241\148\NAK\DC2!\SYNZ\129\DC3\132\193\&3m`\245E\161\ETBf\129[\200\195\251\&5\196\NAK\154a\SO2 \252A\225\ETX\154\225\EM\130]\n\164\223\229u\225\FSf\225\RS\144\194C\176\225\DC2\210\214f\188\RS\SI\230\161\RS>\SOH\130L\223\DC3\146\161\FS\182\225\230\193\n'\140\225\248\NAK\"\tJ\139P,\STXz\181\200 &\225$\146\160\SUB\233\148\EOT\178\157\DC3\254\196\US\150\159\251\&9\RS\171p\158O\144\226\245\209\255\158u\129\FS\204$\"P\172\226\241\149\148\180\CANG\"U\194\DC3Db(\204\162\236\217\139q\184I\ETB\f\162-\222a\n\150!%\246\159\133\220\220\DC1\166\226(rb)>\DC3\204i\226>@\158,>#+\190\197\DC2\233\224\t:\200\SYN\174E/f\RSI)\SI`h\"\v\244![\128c\230\SOH\ACK\SUB~\161.^F:\134\163\248\181I\EM`\ACK<\SYN^\244m\159\DC3\224\":^\227\243\181\226\NAK\bc1\DC2\226\&1\178_\CANN\vz\197\192\223\b\135=b\221>\FS\162\149\165\NUL7\161\149y0$\212\ENQ$\174e#\DC3\"!E\246\227\231\157\162\ETB\132Vf\b$\ETB\DC2\228\243\201\163<\194E\SO\226\140(\158GE\214\\\255\GS^\SUB\"\228~U\227Bvd\225\&9d\SUB:\\\216%\159\&7\182\228M\SYN\RS\248\EM\GS\"\SO\160\"B\132K\146\GS\198\229\"K*\bRb\GS\237=\226\DC3\148c=\STX\229\231%\255\207>z\129<\212d\130\&8\229S\194\140<`%WV\165\223]\226fD\165\GS\174IWZ\FS\\TK\229\r\224HZcI\250\162\STX^\153\&9\158\210\162\168%\196\ENQ\227\152\b\133Q\242\163\\\234\RSB\246$\132\225\229X\170]h\149TX.I^B\FS\239\181\202\179\&0&\185A$\ETB8\195\171@\166az\165\220\213\192.\254$`\170#\245Y\SIX\194\161Mz&\227\129\225R:!\\\ACKGdr\154\147\248A\239A\vk\194\EM\154\212\USg\170\136l\230\216\149\213\166\219\224f\131\193\138\US\DLE\230\205\244&uM\223\RS\158#ob\166\197\145\148qNel&\231\193\217\162\SYN\222\165\241\f\167SUbz\192\141\227\144Ou\222\212\234\136\131R\170\FSu>\167\174\NAK]m\170fZ\142\167\170\129\160UP\196h2\nw\150\211\189\FSWej'\SUB\193\167\210M\159)L]s*\206}~RN\197\255\128P\132\167}\166'q%\146c-\157m\218\140\DEL\166\206'\"\215|\154\128\130.h\129~V\237\173d\171\184\231\197\&0\168\225\161\207\n\212\167>m\232\226\&8\162\135\158\231\132\150\230\178\229\157<\\\141_\246'\133\146\NAKv\134\193\206\176h\139\158(\149]\194P \158[\240g-\133\168\170\\\162u5a\171\148(\141\&2\226'e(3\186f\152\f(Y\245\232\&7\252h\t>\233\RS\212\223\142\234\DC3e\221V\SUB\180\145\v\SUB\143wf(B\138\222\SOH\f\233v\226\138\251\212\t\174\148\169\150v\SUB\v\156\220\173YY\131(\SUB0\134X+\160\195\ESC5\144\f\161\ETX\154\&6\150'\250A]\154]O\250\128\232\241\164l\189\ETB\133\152i\150N\201\ESCQ\219\DELb\153\133\&6\nm\158_\160\DC2\151\251\200\233\164\210\194\161\138\134\EM(\166q\170\ENQ\252U&>V\226d\170\a_\238\SOHh\198\169\251\DLE\234\140\208i+t\255\203\&6\182\ENQ\171\STX\ENQ\159\230\"\CAN\230\140\&8V\226q\149c\190D\202\140\&2\212\156\138\ACK\FSY\234\159\&1\136JF\132<\STX\ENQ\168\226\CAN\171\212@\DC3>\168\171\130]N\237L\152\&6\DC3+d\169\157D\214\140\196\192f\252\169(\158\230Ky\STX\242<\DC3\134\208&7Yb\182\142\137)P\EOT\180\150\DC3\221\164\170\179\213\159\&9\"\DLE\184\186\b\179\150\171\171\173\233\149-g[X(b\214f\166R\EM\195\225\n\171d$\237\185\EM\172\170\233<\226\\\150\173\142\220\233\NAKH\RS\162e>\131L\188\197V\234\SUB\230a\171\248\225h\193~\195?\202\231\RS:,'|\154\212-#\206\NAK\ENQ\169\146[\233\193\ENQ\255E\159\&7\172i\179\neb\SUBGY\190\b\191J\165\173\134l\201\DC2\225>\174\169`2Q\248}k \n\171\189(O)\164\236\214\153\155\144P\132\174RW\SI\226\234!~e(\166a\CAN\214\158\t\182\162\195\174\255\206\139d\210\235\237\NAK\149\170\154\DC2b\\\173V\237\249\249)r=S\242\236$\209)\194\181\216\v\134NK\239\b\USEHl\201]a\198\CAN\221\181\200\234fT\236r^\167\221f\229\214=\147\221Z-\250\208\214\209\RSi\191v!\193\SYN\197\141\RS\171\148\162\211\163\232$\222\246-Z\226k\SO\SUB\199\146&\157\ENQn\159[\NUL(\206\DC1\229\216F\EOT[\134\137\208\178\157J\RS-\186\DC2n\141\226`4j*\189\230K\218R\203[:b\237\GS\237\228\201&[\222\226!\154\143\197\130\145`\174\238\181\214n\230\&1\230\214\157&\226\218\225:\230d\185\230\220\207!\173\197\&1f\232\221\\\253\245-\177\246\206\205\229\203\203\234\222\242\n\227-6\203\168\&2\DC1\216\221\"\233B\\^\154\171\SO\186\202B\DC1\173w\156\171\247*\175\139\250\128(\nc\f\244\151z\164G\247\162/\220\170\175\249bY\DLE6\nQ\FS\RS\152\206o\205\185\255\164R\182\239\SI*\229V],\EOT\186$\174}\194\201\133a\236\174\224\255\194\161\209\165\ETB\201^\160\DEL\n\175\195\201h\255\222\GSw\130\162T\202/\SYN\246f\211\225\220\203\SUB\174\a\178\230\210\130\229\249\SUB\226\224\&9\USPL/\ETB(\NUL\255\166p\252U\142O\172l\171\132Z\242N0\133\254-\206yX\fO\129=\SO\240^\205\129\204\198p:\154%\174\141\129\214\SYN1Pf\163f\\e\247\SO\174\ETB\218\160f\244\151\"\128\193\179b\240\rb\158\213\222\168\207Mn\DC2G\241\DC2s\FS%X\177\220\130%\209\EM\199\SOHH\202\b\251\&0\RS\250[\ESC\EM\192\141*\160f\f\133\140\STXc\SYN\167\176`5\208\RS\v\148\NAKO.\246\226p\ESC+\222\RS\DC3\242\\\184Q\GS\159o\CAN\v\242\SYN\196ZR\136Zd\201O$\ETB\192$K\138\176.\178e8\144\ETX\205\202$\171\ESC\FS\187\145\EM\140\193%\171\200\225U\173(\155\242)\163\EOT\178'\132\NUL\NUL;"),("s5/default/framing.css","/* The following styles size, place, and layer the slide components.\n   Edit these if you want to change the overall slide layout.\n   The commented lines can be uncommented (and modified, if necessary) \n    to help you with the rearrangement process. */\n\n/* target = 1024x768 */\n\ndiv#header, div#footer, .slide {width: 100%; top: 0; left: 0;}\ndiv#header {top: 0; height: 3em; z-index: 1;}\ndiv#footer {top: auto; bottom: 0; height: 2.5em; z-index: 5;}\n.slide {top: 0; width: 92%; padding: 3.5em 4% 4%; z-index: 2;  list-style: none;}\ndiv#controls {left: 50%; bottom: 0; width: 50%; z-index: 100;}\ndiv#controls form {position: absolute; bottom: 0; right: 0; width: 100%;\n  margin: 0;}\n#currentSlide {position: absolute; width: 10%; left: 45%; bottom: 1em; z-index: 10;}\nhtml>body #currentSlide {position: fixed;}\n\n/*\ndiv#header {background: #FCC;}\ndiv#footer {background: #CCF;}\ndiv#controls {background: #BBD;}\ndiv#currentSlide {background: #FFC;}\n*/\n"),("s5/default/iepngfix.htc","<public:component>\r\n<public:attach event=\"onpropertychange\" onevent=\"doFix()\" />\r\n\r\n<script>\r\n\r\n// IE5.5+ PNG Alpha Fix v1.0 by Angus Turnbull http://www.twinhelix.com\r\n// Free usage permitted as long as this notice remains intact.\r\n\r\n// This must be a path to a blank image. That's all the configuration you need here.\r\nvar blankImg = 'ui/default/blank.gif';\r\n\r\nvar f = 'DXImageTransform.Microsoft.AlphaImageLoader';\r\n\r\nfunction filt(s, m) {\r\n if (filters[f]) {\r\n  filters[f].enabled = s ? true : false;\r\n  if (s) with (filters[f]) { src = s; sizingMethod = m }\r\n } else if (s) style.filter = 'progid:'+f+'(src=\"'+s+'\",sizingMethod=\"'+m+'\")';\r\n}\r\n\r\nfunction doFix() {\r\n if ((parseFloat(navigator.userAgent.match(/MSIE (\\S+)/)[1]) < 5.5) ||\r\n  (event && !/(background|src)/.test(event.propertyName))) return;\r\n\r\n if (tagName == 'IMG') {\r\n  if ((/\\.png$/i).test(src)) {\r\n   filt(src, 'image');  // was 'scale'\r\n   src = blankImg;\r\n  } else if (src.indexOf(blankImg) < 0) filt();\r\n } else if (style.backgroundImage) {\r\n  if (style.backgroundImage.match(/^url[(\"']+(.*\\.png)[)\"']+$/i)) {\r\n   var s = RegExp.$1;\r\n   style.backgroundImage = '';\r\n   filt(s, 'crop');\r\n  } else filt();\r\n }\r\n}\r\n\r\ndoFix();\r\n\r\n</script>\r\n</public:component>"),("s5/default/opera.css","/* DO NOT CHANGE THESE unless you really want to break Opera Show */\n.slide {\n\tvisibility: visible !important;\n\tposition: static !important;\n\tpage-break-before: always;\n}\n#slide0 {page-break-before: avoid;}\n"),("s5/default/outline.css","/* don't change this unless you want the layout stuff to show up in the outline view! */\n\n.layout div, #footer *, #controlForm * {display: none;}\n#footer, #controls, #controlForm, #navLinks, #toggle {\n  display: block; visibility: visible; margin: 0; padding: 0;}\n#toggle {float: right; padding: 0.5em;}\nhtml>body #toggle {position: fixed; top: 0; right: 0;}\n\n/* making the outline look pretty-ish */\n\n#slide0 h1, #slide0 h2, #slide0 h3, #slide0 h4 {border: none; margin: 0;}\n#slide0 h1 {padding-top: 1.5em;}\n.slide h1 {margin: 1.5em 0 0; padding-top: 0.25em;\n  border-top: 1px solid #888; border-bottom: 1px solid #AAA;}\n#toggle {border: 1px solid; border-width: 0 0 1px 1px; background: #FFF;}\n"),("s5/default/pretty.css","/* Following are the presentation styles -- edit away! */\n\nbody {background: #FFF url(bodybg.gif) -16px 0 no-repeat; color: #000; font-size: 2em;}\n:link, :visited {text-decoration: none; color: #00C;}\n#controls :active {color: #88A !important;}\n#controls :focus {outline: 1px dotted #227;}\nh1, h2, h3, h4 {font-size: 100%; margin: 0; padding: 0; font-weight: inherit;}\nul, pre {margin: 0; line-height: 1em;}\nhtml, body {margin: 0; padding: 0;}\n\nblockquote, q {font-style: italic;}\nblockquote {padding: 0 2em 0.5em; margin: 0 1.5em 0.5em; text-align: center; font-size: 1em;}\nblockquote p {margin: 0;}\nblockquote i {font-style: normal;}\nblockquote b {display: block; margin-top: 0.5em; font-weight: normal; font-size: smaller; font-style: normal;}\nblockquote b i {font-style: italic;}\n\nkbd {font-weight: bold; font-size: 1em;}\nsup {font-size: smaller; line-height: 1px;}\n\n.slide code {padding: 2px 0.25em; font-weight: bold; color: #533;}\n.slide code.bad, code del {color: red;}\n.slide code.old {color: silver;}\n.slide pre {padding: 0; margin: 0.25em 0 0.5em 0.5em; color: #533; font-size: 90%;}\n.slide pre code {display: block;}\n.slide ul {margin-left: 5%; margin-right: 7%; list-style: disc;}\n.slide li {margin-top: 0.75em; margin-right: 0;}\n.slide ul ul {line-height: 1;}\n.slide ul ul li {margin: .2em; font-size: 85%; list-style: square;}\n.slide img.leader {display: block; margin: 0 auto;}\n\ndiv#header, div#footer {background: #005; color: #AAB;\n  font-family: Verdana, Helvetica, sans-serif;}\ndiv#header {background: #005 url(bodybg.gif) -16px 0 no-repeat;\n  line-height: 1px;}\ndiv#footer {font-size: 0.5em; font-weight: bold; padding: 1em 0;}\n#footer h1, #footer h2 {display: block; padding: 0 1em;}\n#footer h2 {font-style: italic;}\n\ndiv.long {font-size: 0.75em;}\n.slide h1 {position: absolute; top: 0.7em; left: 87px; z-index: 1;\n  margin: 0; padding: 0.3em 0 0 50px; white-space: nowrap;\n  font: bold 150%/1em Helvetica, sans-serif; text-transform: capitalize;\n  color: #DDE; background: #005;}\n.slide h3 {font-size: 130%;}\nh1 abbr {font-variant: small-caps;}\n\ndiv#controls {position: absolute; left: 50%; bottom: 0;\n  width: 50%;\n  text-align: right; font: bold 0.9em Verdana, Helvetica, sans-serif;}\nhtml>body div#controls {position: fixed; padding: 0 0 1em 0;\n  top: auto;}\ndiv#controls form {position: absolute; bottom: 0; right: 0; width: 100%;\n  margin: 0; padding: 0;}\n#controls #navLinks a {padding: 0; margin: 0 0.5em; \n  background: #005; border: none; color: #779; \n  cursor: pointer;}\n#controls #navList {height: 1em;}\n#controls #navList #jumplist {position: absolute; bottom: 0; right: 0; background: #DDD; color: #227;}\n\n#currentSlide {text-align: center; font-size: 0.5em; color: #449;}\n\n#slide0 {padding-top: 3.5em; font-size: 90%;}\n#slide0 h1 {position: static; margin: 1em 0 0; padding: 0;\n   font: bold 2em Helvetica, sans-serif; white-space: normal;\n   color: #000; background: transparent;}\n#slide0 h2 {font: bold italic 1em Helvetica, sans-serif; margin: 0.25em;}\n#slide0 h3 {margin-top: 1.5em; font-size: 1.5em;}\n#slide0 h4 {margin-top: 0; font-size: 1em;}\n\nul.urls {list-style: none; display: inline; margin: 0;}\n.urls li {display: inline; margin: 0;}\n.note {display: none;}\n.external {border-bottom: 1px dotted gray;}\nhtml>body .external {border-bottom: none;}\n.external:after {content: \" \\274F\"; font-size: smaller; color: #77B;}\n\n.incremental, .incremental *, .incremental *:after {color: #DDE; visibility: visible;}\nimg.incremental {visibility: hidden;}\n.slide .current {color: #B02;}\n\n\n/* diagnostics\n\nli:after {content: \" [\" attr(class) \"]\"; color: #F88;}\n*/\n"),("s5/default/print.css","/* The following rule is necessary to have all slides appear in print! DO NOT REMOVE IT! */\n.slide, ul {page-break-inside: avoid; visibility: visible !important;}\nh1 {page-break-after: avoid;}\n\nbody {font-size: 12pt; background: white;}\n* {color: black;}\n\n#slide0 h1 {font-size: 200%; border: none; margin: 0.5em 0 0.25em;}\n#slide0 h3 {margin: 0; padding: 0;}\n#slide0 h4 {margin: 0 0 0.5em; padding: 0;}\n#slide0 {margin-bottom: 3em;}\n\nh1 {border-top: 2pt solid gray; border-bottom: 1px dotted silver;}\n.extra {background: transparent !important;}\ndiv.extra, pre.extra, .example {font-size: 10pt; color: #333;}\nul.extra a {font-weight: bold;}\np.example {display: none;}\n\n#header {display: none;}\n#footer h1 {margin: 0; border-bottom: 1px solid; color: gray; font-style: italic;}\n#footer h2, #controls {display: none;}\n\n/* The following rule keeps the layout stuff out of print.  Remove at your own risk! */\n.layout, .layout * {display: none !important;}\n"),("s5/default/s5-core.css","/* Do not edit or override these styles! The system will likely break if you do. */\n\ndiv#header, div#footer, div#controls, .slide {position: absolute;}\nhtml>body div#header, html>body div#footer, \n  html>body div#controls, html>body .slide {position: fixed;}\n.handout {display: none;}\n.layout {display: block;}\n.slide, .hideme, .incremental {visibility: hidden;}\n#slide0 {visibility: visible;}\n"),("s5/default/slides.css","@import url(s5-core.css); /* required to make the slide show run at all */\n@import url(framing.css); /* sets basic placement and size of slide components */\n@import url(pretty.css);  /* stuff that makes the slides look better than blah */"),("s5/default/slides.js","// S5 v1.1 slides.js -- released into the Public Domain\n//\n// Please see http://www.meyerweb.com/eric/tools/s5/credits.html for information \n// about all the wonderful and talented contributors to this code!\n\nvar undef;\nvar slideCSS = '';\nvar snum = 0;\nvar smax = 1;\nvar incpos = 0;\nvar number = undef;\nvar s5mode = true;\nvar defaultView = 'slideshow';\nvar controlVis = 'visible';\n\nvar isIE = navigator.appName == 'Microsoft Internet Explorer' && navigator.userAgent.indexOf('Opera') < 1 ? 1 : 0;\nvar isOp = navigator.userAgent.indexOf('Opera') > -1 ? 1 : 0;\nvar isGe = navigator.userAgent.indexOf('Gecko') > -1 && navigator.userAgent.indexOf('Safari') < 1 ? 1 : 0;\n\nfunction hasClass(object, className) {\n\tif (!object.className) return false;\n\treturn (object.className.search('(^|\\\\s)' + className + '(\\\\s|$)') != -1);\n}\n\nfunction hasValue(object, value) {\n\tif (!object) return false;\n\treturn (object.search('(^|\\\\s)' + value + '(\\\\s|$)') != -1);\n}\n\nfunction removeClass(object,className) {\n\tif (!object) return;\n\tobject.className = object.className.replace(new RegExp('(^|\\\\s)'+className+'(\\\\s|$)'), RegExp.$1+RegExp.$2);\n}\n\nfunction addClass(object,className) {\n\tif (!object || hasClass(object, className)) return;\n\tif (object.className) {\n\t\tobject.className += ' '+className;\n\t} else {\n\t\tobject.className = className;\n\t}\n}\n\nfunction GetElementsWithClassName(elementName,className) {\n\tvar allElements = document.getElementsByTagName(elementName);\n\tvar elemColl = new Array();\n\tfor (var i = 0; i< allElements.length; i++) {\n\t\tif (hasClass(allElements[i], className)) {\n\t\t\telemColl[elemColl.length] = allElements[i];\n\t\t}\n\t}\n\treturn elemColl;\n}\n\nfunction isParentOrSelf(element, id) {\n\tif (element == null || element.nodeName=='BODY') return false;\n\telse if (element.id == id) return true;\n\telse return isParentOrSelf(element.parentNode, id);\n}\n\nfunction nodeValue(node) {\n\tvar result = \"\";\n\tif (node.nodeType == 1) {\n\t\tvar children = node.childNodes;\n\t\tfor (var i = 0; i < children.length; ++i) {\n\t\t\tresult += nodeValue(children[i]);\n\t\t}\t\t\n\t}\n\telse if (node.nodeType == 3) {\n\t\tresult = node.nodeValue;\n\t}\n\treturn(result);\n}\n\nfunction slideLabel() {\n\tvar slideColl = GetElementsWithClassName('*','slide');\n\tvar list = document.getElementById('jumplist');\n\tsmax = slideColl.length;\n\tfor (var n = 0; n < smax; n++) {\n\t\tvar obj = slideColl[n];\n\n\t\tvar did = 'slide' + n.toString();\n\t\tobj.setAttribute('id',did);\n\t\tif (isOp) continue;\n\n\t\tvar otext = '';\n\t\tvar menu = obj.firstChild;\n\t\tif (!menu) continue; // to cope with empty slides\n\t\twhile (menu && menu.nodeType == 3) {\n\t\t\tmenu = menu.nextSibling;\n\t\t}\n\t \tif (!menu) continue; // to cope with slides with only text nodes\n\n\t\tvar menunodes = menu.childNodes;\n\t\tfor (var o = 0; o < menunodes.length; o++) {\n\t\t\totext += nodeValue(menunodes[o]);\n\t\t}\n\t\tlist.options[list.length] = new Option(n + ' : '  + otext, n);\n\t}\n}\n\nfunction currentSlide() {\n\tvar cs;\n\tif (document.getElementById) {\n\t\tcs = document.getElementById('currentSlide');\n\t} else {\n\t\tcs = document.currentSlide;\n\t}\n\tcs.innerHTML = '<span id=\"csHere\">' + snum + '<\\/span> ' + \n\t\t'<span id=\"csSep\">\\/<\\/span> ' + \n\t\t'<span id=\"csTotal\">' + (smax-1) + '<\\/span>';\n\tif (snum == 0) {\n\t\tcs.style.visibility = 'hidden';\n\t} else {\n\t\tcs.style.visibility = 'visible';\n\t}\n}\n\nfunction go(step) {\n\tif (document.getElementById('slideProj').disabled || step == 0) return;\n\tvar jl = document.getElementById('jumplist');\n\tvar cid = 'slide' + snum;\n\tvar ce = document.getElementById(cid);\n\tif (incrementals[snum].length > 0) {\n\t\tfor (var i = 0; i < incrementals[snum].length; i++) {\n\t\t\tremoveClass(incrementals[snum][i], 'current');\n\t\t\tremoveClass(incrementals[snum][i], 'incremental');\n\t\t}\n\t}\n\tif (step != 'j') {\n\t\tsnum += step;\n\t\tlmax = smax - 1;\n\t\tif (snum > lmax) snum = lmax;\n\t\tif (snum < 0) snum = 0;\n\t} else\n\t\tsnum = parseInt(jl.value);\n\tvar nid = 'slide' + snum;\n\tvar ne = document.getElementById(nid);\n\tif (!ne) {\n\t\tne = document.getElementById('slide0');\n\t\tsnum = 0;\n\t}\n\tif (step < 0) {incpos = incrementals[snum].length} else {incpos = 0;}\n\tif (incrementals[snum].length > 0 && incpos == 0) {\n\t\tfor (var i = 0; i < incrementals[snum].length; i++) {\n\t\t\tif (hasClass(incrementals[snum][i], 'current'))\n\t\t\t\tincpos = i + 1;\n\t\t\telse\n\t\t\t\taddClass(incrementals[snum][i], 'incremental');\n\t\t}\n\t}\n\tif (incrementals[snum].length > 0 && incpos > 0)\n\t\taddClass(incrementals[snum][incpos - 1], 'current');\n\tce.style.visibility = 'hidden';\n\tne.style.visibility = 'visible';\n\tjl.selectedIndex = snum;\n\tcurrentSlide();\n\tnumber = 0;\n}\n\nfunction goTo(target) {\n\tif (target >= smax || target == snum) return;\n\tgo(target - snum);\n}\n\nfunction subgo(step) {\n\tif (step > 0) {\n\t\tremoveClass(incrementals[snum][incpos - 1],'current');\n\t\tremoveClass(incrementals[snum][incpos], 'incremental');\n\t\taddClass(incrementals[snum][incpos],'current');\n\t\tincpos++;\n\t} else {\n\t\tincpos--;\n\t\tremoveClass(incrementals[snum][incpos],'current');\n\t\taddClass(incrementals[snum][incpos], 'incremental');\n\t\taddClass(incrementals[snum][incpos - 1],'current');\n\t}\n}\n\nfunction toggle() {\n\tvar slideColl = GetElementsWithClassName('*','slide');\n\tvar slides = document.getElementById('slideProj');\n\tvar outline = document.getElementById('outlineStyle');\n\tif (!slides.disabled) {\n\t\tslides.disabled = true;\n\t\toutline.disabled = false;\n\t\ts5mode = false;\n\t\tfontSize('1em');\n\t\tfor (var n = 0; n < smax; n++) {\n\t\t\tvar slide = slideColl[n];\n\t\t\tslide.style.visibility = 'visible';\n\t\t}\n\t} else {\n\t\tslides.disabled = false;\n\t\toutline.disabled = true;\n\t\ts5mode = true;\n\t\tfontScale();\n\t\tfor (var n = 0; n < smax; n++) {\n\t\t\tvar slide = slideColl[n];\n\t\t\tslide.style.visibility = 'hidden';\n\t\t}\n\t\tslideColl[snum].style.visibility = 'visible';\n\t}\n}\n\nfunction showHide(action) {\n\tvar obj = GetElementsWithClassName('*','hideme')[0];\n\tswitch (action) {\n\tcase 's': obj.style.visibility = 'visible'; break;\n\tcase 'h': obj.style.visibility = 'hidden'; break;\n\tcase 'k':\n\t\tif (obj.style.visibility != 'visible') {\n\t\t\tobj.style.visibility = 'visible';\n\t\t} else {\n\t\t\tobj.style.visibility = 'hidden';\n\t\t}\n\tbreak;\n\t}\n}\n\n// 'keys' code adapted from MozPoint (http://mozpoint.mozdev.org/)\nfunction keys(key) {\n\tif (!key) {\n\t\tkey = event;\n\t\tkey.which = key.keyCode;\n\t}\n\tif (key.which == 84) {\n\t\ttoggle();\n\t\treturn;\n\t}\n\tif (s5mode) {\n\t\tswitch (key.which) {\n\t\t\tcase 10: // return\n\t\t\tcase 13: // enter\n\t\t\t\tif (window.event && isParentOrSelf(window.event.srcElement, 'controls')) return;\n\t\t\t\tif (key.target && isParentOrSelf(key.target, 'controls')) return;\n\t\t\t\tif(number != undef) {\n\t\t\t\t\tgoTo(number);\n\t\t\t\t\tbreak;\n\t\t\t\t}\n\t\t\tcase 32: // spacebar\n\t\t\tcase 34: // page down\n\t\t\tcase 39: // rightkey\n\t\t\tcase 40: // downkey\n\t\t\t\tif(number != undef) {\n\t\t\t\t\tgo(number);\n\t\t\t\t} else if (!incrementals[snum] || incpos >= incrementals[snum].length) {\n\t\t\t\t\tgo(1);\n\t\t\t\t} else {\n\t\t\t\t\tsubgo(1);\n\t\t\t\t}\n\t\t\t\tbreak;\n\t\t\tcase 33: // page up\n\t\t\tcase 37: // leftkey\n\t\t\tcase 38: // upkey\n\t\t\t\tif(number != undef) {\n\t\t\t\t\tgo(-1 * number);\n\t\t\t\t} else if (!incrementals[snum] || incpos <= 0) {\n\t\t\t\t\tgo(-1);\n\t\t\t\t} else {\n\t\t\t\t\tsubgo(-1);\n\t\t\t\t}\n\t\t\t\tbreak;\n\t\t\tcase 36: // home\n\t\t\t\tgoTo(0);\n\t\t\t\tbreak;\n\t\t\tcase 35: // end\n\t\t\t\tgoTo(smax-1);\n\t\t\t\tbreak;\n\t\t\tcase 67: // c\n\t\t\t\tshowHide('k');\n\t\t\t\tbreak;\n\t\t}\n\t\tif (key.which < 48 || key.which > 57) {\n\t\t\tnumber = undef;\n\t\t} else {\n\t\t\tif (window.event && isParentOrSelf(window.event.srcElement, 'controls')) return;\n\t\t\tif (key.target && isParentOrSelf(key.target, 'controls')) return;\n\t\t\tnumber = (((number != undef) ? number : 0) * 10) + (key.which - 48);\n\t\t}\n\t}\n\treturn false;\n}\n\nfunction clicker(e) {\n\tnumber = undef;\n\tvar target;\n\tif (window.event) {\n\t\ttarget = window.event.srcElement;\n\t\te = window.event;\n\t} else target = e.target;\n\tif (target.getAttribute('href') != null || hasValue(target.rel, 'external') || isParentOrSelf(target, 'controls') || isParentOrSelf(target,'embed') || isParentOrSelf(target,'object')) return true;\n\tif (!e.which || e.which == 1) {\n\t\tif (!incrementals[snum] || incpos >= incrementals[snum].length) {\n\t\t\tgo(1);\n\t\t} else {\n\t\t\tsubgo(1);\n\t\t}\n\t}\n}\n\nfunction findSlide(hash) {\n\tvar target = null;\n\tvar slides = GetElementsWithClassName('*','slide');\n\tfor (var i = 0; i < slides.length; i++) {\n\t\tvar targetSlide = slides[i];\n\t\tif ( (targetSlide.name && targetSlide.name == hash)\n\t\t || (targetSlide.id && targetSlide.id == hash) ) {\n\t\t\ttarget = targetSlide;\n\t\t\tbreak;\n\t\t}\n\t}\n\twhile(target != null && target.nodeName != 'BODY') {\n\t\tif (hasClass(target, 'slide')) {\n\t\t\treturn parseInt(target.id.slice(5));\n\t\t}\n\t\ttarget = target.parentNode;\n\t}\n\treturn null;\n}\n\nfunction slideJump() {\n\tif (window.location.hash == null) return;\n\tvar sregex = /^#slide(\\d+)$/;\n\tvar matches = sregex.exec(window.location.hash);\n\tvar dest = null;\n\tif (matches != null) {\n\t\tdest = parseInt(matches[1]);\n\t} else {\n\t\tdest = findSlide(window.location.hash.slice(1));\n\t}\n\tif (dest != null)\n\t\tgo(dest - snum);\n}\n\nfunction fixLinks() {\n\tvar thisUri = window.location.href;\n\tthisUri = thisUri.slice(0, thisUri.length - window.location.hash.length);\n\tvar aelements = document.getElementsByTagName('A');\n\tfor (var i = 0; i < aelements.length; i++) {\n\t\tvar a = aelements[i].href;\n\t\tvar slideID = a.match('\\#slide[0-9]{1,2}');\n\t\tif ((slideID) && (slideID[0].slice(0,1) == '#')) {\n\t\t\tvar dest = findSlide(slideID[0].slice(1));\n\t\t\tif (dest != null) {\n\t\t\t\tif (aelements[i].addEventListener) {\n\t\t\t\t\taelements[i].addEventListener(\"click\", new Function(\"e\",\n\t\t\t\t\t\t\"if (document.getElementById('slideProj').disabled) return;\" +\n\t\t\t\t\t\t\"go(\"+dest+\" - snum); \" +\n\t\t\t\t\t\t\"if (e.preventDefault) e.preventDefault();\"), true);\n\t\t\t\t} else if (aelements[i].attachEvent) {\n\t\t\t\t\taelements[i].attachEvent(\"onclick\", new Function(\"\",\n\t\t\t\t\t\t\"if (document.getElementById('slideProj').disabled) return;\" +\n\t\t\t\t\t\t\"go(\"+dest+\" - snum); \" +\n\t\t\t\t\t\t\"event.returnValue = false;\"));\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n}\n\nfunction externalLinks() {\n\tif (!document.getElementsByTagName) return;\n\tvar anchors = document.getElementsByTagName('a');\n\tfor (var i=0; i<anchors.length; i++) {\n\t\tvar anchor = anchors[i];\n\t\tif (anchor.getAttribute('href') && hasValue(anchor.rel, 'external')) {\n\t\t\tanchor.target = '_blank';\n\t\t\taddClass(anchor,'external');\n\t\t}\n\t}\n}\n\nfunction createControls() {\n\tvar controlsDiv = document.getElementById(\"controls\");\n\tif (!controlsDiv) return;\n\tvar hider = ' onmouseover=\"showHide(\\'s\\');\" onmouseout=\"showHide(\\'h\\');\"';\n\tvar hideDiv, hideList = '';\n\tif (controlVis == 'hidden') {\n\t\thideDiv = hider;\n\t} else {\n\t\thideList = hider;\n\t}\n\tcontrolsDiv.innerHTML = '<form action=\"#\" id=\"controlForm\"' + hideDiv + '>' +\n\t'<div id=\"navLinks\">' +\n\t'<a accesskey=\"t\" id=\"toggle\" href=\"javascript:toggle();\">&#216;<\\/a>' +\n\t'<a accesskey=\"z\" id=\"prev\" href=\"javascript:go(-1);\">&laquo;<\\/a>' +\n\t'<a accesskey=\"x\" id=\"next\" href=\"javascript:go(1);\">&raquo;<\\/a>' +\n\t'<div id=\"navList\"' + hideList + '><select id=\"jumplist\" onchange=\"go(\\'j\\');\"><\\/select><\\/div>' +\n\t'<\\/div><\\/form>';\n\tif (controlVis == 'hidden') {\n\t\tvar hidden = document.getElementById('navLinks');\n\t} else {\n\t\tvar hidden = document.getElementById('jumplist');\n\t}\n\taddClass(hidden,'hideme');\n}\n\nfunction fontScale() {  // causes layout problems in FireFox that get fixed if browser's Reload is used; same may be true of other Gecko-based browsers\n\tif (!s5mode) return false;\n\tvar vScale = 22;  // both yield 32 (after rounding) at 1024x768\n\tvar hScale = 32;  // perhaps should auto-calculate based on theme's declared value?\n\tif (window.innerHeight) {\n\t\tvar vSize = window.innerHeight;\n\t\tvar hSize = window.innerWidth;\n\t} else if (document.documentElement.clientHeight) {\n\t\tvar vSize = document.documentElement.clientHeight;\n\t\tvar hSize = document.documentElement.clientWidth;\n\t} else if (document.body.clientHeight) {\n\t\tvar vSize = document.body.clientHeight;\n\t\tvar hSize = document.body.clientWidth;\n\t} else {\n\t\tvar vSize = 700;  // assuming 1024x768, minus chrome and such\n\t\tvar hSize = 1024; // these do not account for kiosk mode or Opera Show\n\t}\n\tvar newSize = Math.min(Math.round(vSize/vScale),Math.round(hSize/hScale));\n\tfontSize(newSize + 'px');\n\tif (isGe) {  // hack to counter incremental reflow bugs\n\t\tvar obj = document.getElementsByTagName('body')[0];\n\t\tobj.style.display = 'none';\n\t\tobj.style.display = 'block';\n\t}\n}\n\nfunction fontSize(value) {\n\tif (!(s5ss = document.getElementById('s5ss'))) {\n\t\tif (!isIE) {\n\t\t\tdocument.getElementsByTagName('head')[0].appendChild(s5ss = document.createElement('style'));\n\t\t\ts5ss.setAttribute('media','screen, projection');\n\t\t\ts5ss.setAttribute('id','s5ss');\n\t\t} else {\n\t\t\tdocument.createStyleSheet();\n\t\t\tdocument.s5ss = document.styleSheets[document.styleSheets.length - 1];\n\t\t}\n\t}\n\tif (!isIE) {\n\t\twhile (s5ss.lastChild) s5ss.removeChild(s5ss.lastChild);\n\t\ts5ss.appendChild(document.createTextNode('body {font-size: ' + value + ' !important;}'));\n\t} else {\n\t\tdocument.s5ss.addRule('body','font-size: ' + value + ' !important;');\n\t}\n}\n\nfunction notOperaFix() {\n\tslideCSS = document.getElementById('slideProj').href;\n\tvar slides = document.getElementById('slideProj');\n\tvar outline = document.getElementById('outlineStyle');\n\tslides.setAttribute('media','screen');\n\toutline.disabled = true;\n\tif (isGe) {\n\t\tslides.setAttribute('href','null');   // Gecko fix\n\t\tslides.setAttribute('href',slideCSS); // Gecko fix\n\t}\n\tif (isIE && document.styleSheets && document.styleSheets[0]) {\n\t\tdocument.styleSheets[0].addRule('img', 'behavior: url(ui/default/iepngfix.htc)');\n\t\tdocument.styleSheets[0].addRule('div', 'behavior: url(ui/default/iepngfix.htc)');\n\t\tdocument.styleSheets[0].addRule('.slide', 'behavior: url(ui/default/iepngfix.htc)');\n\t}\n}\n\nfunction getIncrementals(obj) {\n\tvar incrementals = new Array();\n\tif (!obj) \n\t\treturn incrementals;\n\tvar children = obj.childNodes;\n\tfor (var i = 0; i < children.length; i++) {\n\t\tvar child = children[i];\n\t\tif (hasClass(child, 'incremental')) {\n\t\t\tif (child.nodeName == 'OL' || child.nodeName == 'UL') {\n\t\t\t\tremoveClass(child, 'incremental');\n\t\t\t\tfor (var j = 0; j < child.childNodes.length; j++) {\n\t\t\t\t\tif (child.childNodes[j].nodeType == 1) {\n\t\t\t\t\t\taddClass(child.childNodes[j], 'incremental');\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t} else {\n\t\t\t\tincrementals[incrementals.length] = child;\n\t\t\t\tremoveClass(child,'incremental');\n\t\t\t}\n\t\t}\n\t\tif (hasClass(child, 'show-first')) {\n\t\t\tif (child.nodeName == 'OL' || child.nodeName == 'UL') {\n\t\t\t\tremoveClass(child, 'show-first');\n\t\t\t\tif (child.childNodes[isGe].nodeType == 1) {\n\t\t\t\t\tremoveClass(child.childNodes[isGe], 'incremental');\n\t\t\t\t}\n\t\t\t} else {\n\t\t\t\tincrementals[incrementals.length] = child;\n\t\t\t}\n\t\t}\n\t\tincrementals = incrementals.concat(getIncrementals(child));\n\t}\n\treturn incrementals;\n}\n\nfunction createIncrementals() {\n\tvar incrementals = new Array();\n\tfor (var i = 0; i < smax; i++) {\n\t\tincrementals[i] = getIncrementals(document.getElementById('slide'+i));\n\t}\n\treturn incrementals;\n}\n\nfunction defaultCheck() {\n\tvar allMetas = document.getElementsByTagName('meta');\n\tfor (var i = 0; i< allMetas.length; i++) {\n\t\tif (allMetas[i].name == 'defaultView') {\n\t\t\tdefaultView = allMetas[i].content;\n\t\t}\n\t\tif (allMetas[i].name == 'controlVis') {\n\t\t\tcontrolVis = allMetas[i].content;\n\t\t}\n\t}\n}\n\n// Key trap fix, new function body for trap()\nfunction trap(e) {\n\tif (!e) {\n\t\te = event;\n\t\te.which = e.keyCode;\n\t}\n\ttry {\n\t\tmodifierKey = e.ctrlKey || e.altKey || e.metaKey;\n\t}\n\tcatch(e) {\n\t\tmodifierKey = false;\n\t}\n\treturn modifierKey || e.which == 0;\n}\n\nfunction startup() {\n\tdefaultCheck();\n\tif (!isOp) \n\t\tcreateControls();\n\tslideLabel();\n\tfixLinks();\n\texternalLinks();\n\tfontScale();\n\tif (!isOp) {\n\t\tnotOperaFix();\n\t\tincrementals = createIncrementals();\n\t\tslideJump();\n\t\tif (defaultView == 'outline') {\n\t\t\ttoggle();\n\t\t}\n\t\tdocument.onkeyup = keys;\n\t\tdocument.onkeypress = trap;\n\t\tdocument.onclick = clicker;\n\t}\n}\n\nwindow.onload = startup;\nwindow.onresize = function(){setTimeout('fontScale()', 50);}"),("slideous/slideous.css","/*\tThis work is licensed under Creative Commons GNU LGPL License.\n\n\tLicense: http://creativecommons.org/licenses/LGPL/2.1/\n\tVersion: 1.0\n\n\tAuthor:  Stefan Goessner/2005\n\tWeb:     http://goessner.net/ \n*/\n@media screen, projection {\nbody {\n  background-color: #e3eee7;\n  padding: 0;\n  margin: 0;\n  color: #132; \n  border-color: #678; \n  font-size: 125%;\n}\n#statusbar {\n  display: none;\n  position: absolute; z-index: 10;\n  top: auto; bottom: 0; left: 0; right: 0;\n  height: 2em;\n  background-color: #f0fff8;\n  color: #132;\n  font-size: 75%;\n  padding: 0.5em 0.5em 0 2px;\n  border-top: solid 1px #000;\n}\n#statusbar button, #tocbox {\n  cursor: pointer; \n  color: #031;\n  background-color: #e0eee7;\n  margin: 1px;\n  padding: 0 0.5em;\n  border: inset 1px black;\n}\n#statusbar button:hover, #tocbox:hover {\n  color: #031;\n  background-color: #c0ccc6;\n  border: outset 1px black;\n}\n#tocbox {\n  width: 15em;\n}\n#eos {\n  visibility: hidden;\n  color: #021;\n  background-color: #fffafa;\n  border: inset 1px black;\n  font-size: 120%;\n}\ndiv.slide {\n   display: block;\n   margin: 0 0 2em 0;\n   padding: 0 150px;\n}\n\ndiv.slide h1 {\n  background: #a0aaa4;\n  color: #f0fff8;\n  padding: 0 0.5em 0 0.5em;\n  margin: 0 -150px;\n  font-size: 120%;\n  border-bottom: solid 1px black;\n}\n\ndiv.slide h1:before { content: \"# \"; }\ndiv.handout { display: block; }\n   \nbody>#statusbar {   /* ie6 hack for fixing the statusbar - in quirks mode */\n  position: fixed;  /* thanks to Anne van Kesteren and Arthur Steiner */\n}                   /* see http://limpid.nl/lab/css/fixed/footer */\n* html body {\n  overflow: hidden;\n}\n* html div.slide {\n  height: 100%;\n  padding-bottom: 2em;\n  overflow: auto;\n}                   /* end ie6-hack */\n\n} /* @media screen, projection */\n\n@media print {\nbody {\n  color: black;\n  font-family: sans-serif;\n  font-size: 11pt;\n}\n\n#statusbar { display: none; }\ndiv.slide { page-break-after: always; }\ndiv.handout { display: block; }\n\n} /* @media print */\n"),("slideous/slideous.js","/*\tThis work is licensed under Creative Commons GNU LGPL License.\n\n\tLicense: http://creativecommons.org/licenses/LGPL/2.1/\n\n\tAuthor:  Stefan Goessner/2005-2006\n\tWeb:     http://goessner.net/ \n*/\nvar Slideous = {\n   version: 1.0,\n   // == user customisable ===\n   clickables: { a: true, button: true, img: true, input: true, object: true, textarea: true, select: true, option: true },\n   incrementables: { blockquote: { filter: \"self, parent\" }, \n                     dd: { filter: \"self, parent\" },\n                     dt: { filter: \"self, parent\" },\n                     h2: { filter: \"self, parent\" },\n                     h3: { filter: \"self, parent\" },\n                     h4: { filter: \"self, parent\" },\n                     h5: { filter: \"self, parent\" },\n                     h6: { filter: \"self, parent\" },\n                     li: { filter: \"self, parent\" },\n                     p: { filter: \"self\" }, \n                     pre: { filter: \"self\" }, \n                     img: { filter: \"self, parent\" }, \n                     object: { filter: \"self, parent\" },\n                     table: { filter: \"self, parent\" },\n                     td: { filter: \"self, parent\" },\n                     th: { filter: \"self, parent\" },\n                     tr: { filter: \"parent, grandparent\" }\n                   },\n   autoincrementables: { ol: true, ul: true, dl: true },\n   autoincrement: false,\n   statusbar: true,\n   navbuttons: { incfontbutton:   function(){Slideous.changefontsize(+Slideous.fontdelta);},\n                 decfontbutton:   function(){Slideous.changefontsize(-Slideous.fontdelta);},\n                 contentbutton:   function(){Slideous.gotoslide(Slideous.tocidx(), true, true);},\n                 homebutton:      function(){Slideous.gotoslide(1, true, true);},\n                 prevslidebutton: function(){Slideous.previous(false);},\n                 previtembutton:  function(){Slideous.previous(true);},\n                 nextitembutton:  function(){Slideous.next(true);},\n                 nextslidebutton: function(){Slideous.next(false);},\n                 endbutton:       function(){Slideous.gotoslide(Slideous.count,true,true);} },\n   fontsize: 125,  // in percent, corresponding to body.font-size in css file\n   fontdelta: 5,   // increase/decrease fontsize by this value\n   mousesensitive: true,\n   tocidx: 0,\n   tocitems: { toc: \"<li><a href=\\\"#s{\\$slideidx}\\\">{\\$slidetitle}</a></li>\",\n               tocbox: \"<option value=\\\"#s{\\$slideidx}\\\" title=\\\"{\\$slidetitle}\\\">{\\$slidetitle}</option>\" },\n   keydown: function(evt) {\n      evt = evt || window.event;\n      var key = evt.keyCode || evt.which;\n      if (key && !evt.ctrlKey && !evt.altKey) {\n         switch (key) {\n            case 33: // page up  ... previous slide\n               Slideous.previous(false); evt.cancel = !Slideous.showall; break;\n            case 37: // left arrow ... previous item\n               Slideous.previous(true); evt.cancel = !Slideous.showall; break;\n            case 32: // space bar\n            case 39: // right arrow\n               Slideous.next(true); evt.cancel = !Slideous.showall; break;\n            case 13: // carriage return  ... next slide\n            case 34: // page down\n               Slideous.next(false); evt.cancel = !Slideous.showall; break;\n            case 35: // end  ... last slide (not recognised by opera)\n               Slideous.gotoslide(Slideous.count, true, true); evt.cancel = !Slideous.showall; break;\n            case 36: // home ... first slide (not recognised by opera)\n               Slideous.gotoslide(1, true, true); evt.cancel = !Slideous.showall; break;\n            case 65: // A ... show All\n            case 80: // P ... Print mode\n               Slideous.toggleshowall(!Slideous.showall); evt.cancel = true; break;\n            case 67: // C ... goto contents\n               Slideous.gotoslide(Slideous.tocidx, true, true); evt.cancel = true; break;\n            case 77: // M ... toggle mouse sensitivity\n               Slideous.mousenavigation(Slideous.mousesensitive = !Slideous.mousesensitive); evt.cancel = true; break;\n            case 83: // S ... toggle statusbar\n               Slideous.togglestatusbar(); evt.cancel = true; break;\n            case 61:  // + ... increase fontsize\n            case 107:\n               Slideous.changefontsize(+Slideous.fontdelta); evt.cancel = true; break;\n            case 109:  // - ... decrease fontsize\n               Slideous.changefontsize(-Slideous.fontdelta); evt.cancel = true; break;\n            default: break;\n         }\n         if (evt.cancel) evt.returnValue = false;\n      }\n      return !evt.cancel;\n   },\n\n   // == program logic ===\n   count: 0,                       // # of slides ..\n   curidx: 0,                      // current slide index ..\n   mousedownpos: null,             // last mouse down position ..\n   contentselected: false,         // indicates content selection ..\n   showall: true,\n   init: function() {\n      Slideous.curidx = 1;\n      Slideous.importproperties();\n      Slideous.registerslides();\n      document.body.innerHTML = Slideous.injectproperties(document.body.innerHTML);\n      Slideous.buildtocs();\n      Slideous.registeranchors();\n      Slideous.toggleshowall(false);\n      Slideous.updatestatus();\n      document.body.style.fontSize = Slideous.fontsize+\"%\";\n      document.getElementById(\"s1\").style.display = \"block\";\n      document.onkeydown = Slideous.keydown;\n      Slideous.mousenavigation(Slideous.mousesensitive);\n      Slideous.registerbuttons();\n      if (window.location.hash)\n         Slideous.gotoslide(window.location.hash.substr(2), true, true);\n   },\n   registerslides: function() {\n      var div = document.getElementsByTagName(\"div\");\n      Slideous.count = 0;\n      for (var i in div)\n         if (Slideous.hasclass(div[i], \"slide\"))\n            div[i].setAttribute(\"id\", \"s\"+(++Slideous.count));\n   },\n   registeranchors: function() {\n      var a = document.getElementsByTagName(\"a\"),\n          loc = (window.location.hostname+window.location.pathname).replace(/\\\\/g, \"/\");\n      for (var i in a) {\n         if (a[i].href && a[i].href.indexOf(loc) >= 0 && a[i].href.lastIndexOf(\"#\") >= 0) {\n            a[i].href = \"javascript:Slideous.gotoslide(\" + a[i].href.substr(a[i].href.lastIndexOf(\"#\")+2)+\",true,true)\";\n         }\n      }\n   },\n   registerbuttons: function() {\n      var button;\n      for (var b in Slideous.navbuttons)\n         if (button = document.getElementById(b))\n            button.onclick = Slideous.navbuttons[b];\n   },\n   importproperties: function() {  // from html meta section ..\n      var meta = document.getElementsByTagName(\"meta\"), elem;\n      for (var i in meta)\n         if (meta[i].attributes && meta[i].attributes[\"name\"] && meta[i].attributes[\"name\"].value in Slideous)\n            switch (typeof(Slideous[meta[i].attributes[\"name\"].value])) {\n               case \"number\": Slideous[meta[i].attributes[\"name\"].value] = parseInt(meta[i].attributes[\"content\"].value); break;\n               case \"boolean\": Slideous[meta[i].attributes[\"name\"].value] = meta[i].attributes[\"content\"].value == \"true\" ? true : false; break;\n               default: Slideous[meta[i].attributes[\"name\"].value] = meta[i].attributes[\"content\"].value; break;\n            }\n   },\n   injectproperties: function(str) {\n      var meta = document.getElementsByTagName(\"meta\"), elem;\n      for (var i in meta) {\n         if (meta[i].attributes && meta[i].attributes[\"name\"])\n            str = str.replace(new RegExp(\"{\\\\$\"+meta[i].attributes[\"name\"].value+\"}\",\"g\"), meta[i].attributes[\"content\"].value);\n      }\n      return str = str.replace(/{\\$generator}/g, \"Slideous\")\n                      .replace(/{\\$version}/g, Slideous.version)\n                      .replace(/{\\$title}/g, document.title)\n                      .replace(/{\\$slidecount}/g, Slideous.count);\n   },\n   buildtocs: function() {\n      var toc = document.getElementById(\"toc\"), list = \"\",\n          tocbox = document.getElementById(\"tocbox\");\n      if (toc) {\n         for (var i=0; i<Slideous.count; i++)\n            list += Slideous.tocitems.toc.replace(/{\\$slideidx}/g, i+1).replace(/{\\$slidetitle}/, document.getElementById(\"s\"+(i+1)).getElementsByTagName(\"h1\")[0].innerHTML);\n         toc.innerHTML = list;\n         while (toc && !Slideous.hasclass(toc, \"slide\")) toc = toc.parentNode;\n         if (toc) Slideous.tocidx = toc.getAttribute(\"id\").substr(1);\n      }\n      if (tocbox) {\n         tocbox.innerHTML = \"\";\n         for (var i=0; i<Slideous.count; i++)\n            tocbox.options[tocbox.length] = new Option((i+1)+\". \"+document.getElementById(\"s\"+(i+1)).getElementsByTagName(\"h1\")[0].innerHTML, \"#s\"+(i+1));\n         tocbox.onchange = function() { Slideous.gotoslide(this.selectedIndex+1, true, true); };\n      }\n   },\n   next: function(deep) {\n      if (!Slideous.showall) {\n         var slide = document.getElementById(\"s\"+Slideous.curidx),\n             item = Slideous.firstitem(slide, Slideous.isitemhidden);\n         if (deep) {  // next item\n            if (item)\n               Slideous.displayitem(item, true);\n            else\n               Slideous.gotoslide(Slideous.curidx+1, false, false);\n         }\n         else if (item)  // complete slide ..\n            while (item = Slideous.firstitem(slide, Slideous.isitemhidden))\n               Slideous.displayitem(item, true);\n         else           // next slide\n            Slideous.gotoslide(Slideous.curidx+1, true, false);\n         Slideous.updatestatus();\n      }\n   },\n   previous: function(deep) {\n      if (!Slideous.showall) {\n         var slide = document.getElementById(\"s\"+Slideous.curidx);\n         if (deep) {\n            var item = Slideous.lastitem(slide, Slideous.isitemvisible);\n            if (item)\n               Slideous.displayitem(item, false);\n            else\n               Slideous.gotoslide(Slideous.curidx-1, true, false);\n         }\n         else\n            Slideous.gotoslide(Slideous.curidx-1, true, false);\n         Slideous.updatestatus();\n      }\n   },\n   gotoslide: function(i, showitems, updatestatus) {\n      if (!Slideous.showall && i > 0 && i <= Slideous.count && i != Slideous.curidx) {\n         document.getElementById(\"s\"+Slideous.curidx).style.display = \"none\";\n         var slide = document.getElementById(\"s\"+(Slideous.curidx=i)), item;\n         while (item = Slideous.firstitem(slide, showitems ? Slideous.isitemhidden : Slideous.isitemvisible))\n            Slideous.displayitem(item, showitems);\n         slide.style.display = \"block\";\n         if (updatestatus)\n            Slideous.updatestatus();\n      }\n   },\n   firstitem: function(root, filter) {\n      var found = filter(root);\n      for (var node=root.firstChild; node!=null && !found; node = node.nextSibling)\n         found = Slideous.firstitem(node, filter);\n      return found;\n   },\n   lastitem: function(root, filter) {\n      var found = null;\n      for (var node=root.lastChild; node!=null && !found; node = node.previousSibling)\n         found = Slideous.lastitem(node, filter);\n      return found || filter(root);\n   },\n   isitem: function(node, visible) {\n      var nodename;\n      return node && node.nodeType == 1   // elements only ..\n          && (nodename=node.nodeName.toLowerCase()) in Slideous.incrementables\n          && (   Slideous.incrementables[nodename].filter.match(\"\\\\bself\\\\b\") && (Slideous.hasclass(node, \"incremental\") || (Slideous.autoincrement && nodename in Slideous.autoincrementables))\n              || Slideous.incrementables[nodename].filter.match(\"\\\\bparent\\\\b\") && (Slideous.hasclass(node.parentNode, \"incremental\") || (Slideous.autoincrement && node.parentNode.nodeName.toLowerCase() in Slideous.autoincrementables))\n              || Slideous.incrementables[nodename].filter.match(\"\\\\bgrandparent\\\\b\") && (Slideous.hasclass(node.parentNode.parentNode, \"incremental\") || (Slideous.autoincrement && node.parentNode.parentNode.nodeName.toLowerCase() in Slideous.autoincrementables))\n             )\n          && (visible ? (node.style.visibility != \"hidden\")\n                      : (node.style.visibility == \"hidden\"))\n          ? node : null;\n   },\n   isitemvisible: function(node) { return Slideous.isitem(node, true); },\n   isitemhidden: function(node) { return Slideous.isitem(node, false); },\n   displayitem: function(item, show) {\n      if (item) item.style.visibility = (show ? \"visible\" : \"hidden\");\n   },\n   updatestatus: function() {\n      if (Slideous.statusbar) {\n         var eos = document.getElementById(\"eos\"), \n             idx = document.getElementById(\"slideidx\"),\n             tocbox = document.getElementById(\"tocbox\");\n         if (eos) \n            eos.style.visibility = Slideous.firstitem(document.getElementById(\"s\"+Slideous.curidx), Slideous.isitemhidden) != null\n                                 ? \"visible\" : \"hidden\";\n         if (idx) \n            idx.innerHTML = Slideous.curidx;\n         if (tocbox)\n            tocbox.selectedIndex = Slideous.curidx-1;\n      }\n   },\n   changefontsize: function(delta) {\n      document.body.style.fontSize = (Slideous.fontsize+=delta)+\"%\";\n   },\n   togglestatusbar: function() {\n      document.getElementById(\"statusbar\").style.display = (Slideous.statusbar = !Slideous.statusbar) ? \"block\" : \"none\";\n   },\n   toggleshowall: function(showall) {\n      var slide, item;\n      for (var i=0; i<Slideous.count; i++) {\n         slide = document.getElementById(\"s\"+(i+1));\n         slide.style.display = showall ? \"block\" : \"none\";\n         while (item = Slideous.firstitem(slide, showall ? Slideous.isitemhidden : Slideous.isitemvisible)) \n            Slideous.displayitem(item, showall);\n         var divs = slide.getElementsByTagName(\"div\");\n         for (var j in divs)\n            if (Slideous.hasclass(divs[j], \"handout\"))\n               divs[j].style.display = showall ? \"block\" : \"none\";\n      }\n      if (!showall)\n         document.getElementById(\"s\"+Slideous.curidx).style.display = \"block\";\n      if (Slideous.statusbar) \n         document.getElementById(\"statusbar\").style.display = showall ? \"none\" : \"block\";\n      Slideous.showall = showall;\n   },\n   hasclass: function(elem, classname) {\n      var classattr = null;\n      return (classattr=(elem.attributes && elem.attributes[\"class\"])) \n          && classattr.nodeValue.match(\"\\\\b\"+classname+\"\\\\b\");\n   },\n   selectedcontent: function() {\n      return window.getSelection ? window.getSelection().toString() \n                                 : document.getSelection ? document.getSelection() \n                                                         : document.selection ? document.selection.createRange().text\n                                                                              : \"\";\n   },\n   mousenavigation: function(on) {\n      if (on) {\n         document.onmousedown = Slideous.mousedown;\n         document.onmouseup = Slideous.mouseup;\n      }\n      else\n         document.onmousedown = document.onmouseup = null;\n   },\n   mousepos: function(e) {\n      return e.pageX ? {x: e.pageX, y: e.pageY} \n                     : {x: e.x+document.body.scrollLeft, y: e.y+document.body.scrollTop};\n   },\n   mousedown: function(evt) {\n      evt = evt||window.event;\n      Slideous.mousedownpos = Slideous.mousepos(evt);\n      Slideous.contentselected = !!Slideous.selectedcontent() || ((evt.target || evt.srcElement).nodeName.toLowerCase() in Slideous.clickables);\n      return true;\n   },\n   mouseup: function(evt) {\n      evt = evt||window.event;\n      var pos = Slideous.mousepos(evt);\n      if (pos.x == Slideous.mousedownpos.x && pos.y == Slideous.mousedownpos.y && !Slideous.contentselected) {\n         Slideous.next(true);\n         return evt.returnValue = !(evt.cancel = true);\n      }\n      return false;\n   }\n};\nwindow.onload = Slideous.init;\n"),("slidy/graphics/fold-dim.gif","GIF87a\t\NUL\t\NUL\161\ETX\NUL\195\195\255\204\204\204\235\235\255\255\255\255,\NUL\NUL\NUL\NUL\t\NUL\t\NUL\NUL\STX\DC1\140\143\162+\198\235^\v\STXX;e\150\241\161\US\DC4\NUL;"),("slidy/graphics/fold.gif","GIF87a\t\NUL\t\NUL\161\ETX\NUL\NUL\NUL\NUL\NUL\NUL\255\195\195\255\255\255\255,\NUL\NUL\NUL\NUL\t\NUL\t\NUL\NUL\STX\DC1\132\143\162+\198\235^\ETX\"X;e\150\241\161\SI\DC4\NUL;"),("slidy/graphics/nofold-dim.gif","GIF87a\t\NUL\t\NUL\128\STX\NUL\204\204\204\235\235\255,\NUL\NUL\NUL\NUL\t\NUL\t\NUL\NUL\STX\SI\132\143\161\ESC\198\235^\ETXr\214\248\&0C\FS\DC4\NUL;"),("slidy/graphics/unfold-dim.gif","GIF87a\t\NUL\t\NUL\161\ETX\NUL\195\195\255\204\204\204\235\235\255\255\255\255,\NUL\NUL\NUL\NUL\t\NUL\t\NUL\NUL\STX\DC4\140\143\162+\182\176\156\130\202\129{[xq\207\206t\bR\NUL\NUL;"),("slidy/graphics/unfold.gif","GIF87a\t\NUL\t\NUL\161\ETX\NUL\NUL\NUL\NUL\NUL\NUL\255\195\195\255\255\255\255,\NUL\NUL\NUL\NUL\t\NUL\t\NUL\NUL\STX\DC4\132\143\162+\182\177\156\130\202\133{\ESCxq\207\206t\bR\NUL\NUL;"),("slidy/scripts/slidy.js.gz","\US\139\b\b%@\186N\NUL\ETXslidy.js\NUL\237}\239\151\FS\197\145\224\247\249+j\202\207\163n\166\212\211\&3\STX!M\171\164'\tn\225\EM\ETX\SI\t{}B\215\175\166;\167\187\&4\213U\189U\213\&3\154_\239\129d\ESC\179\139\151{\187\246\237\222\218\187\134\247\216\179\217\&3`\140\ENQ\b\EOT|\CAN\243u4\250\ESCf\ENQ\187\159\238_\184\136\200\204\170\204\170\172\158\RS!\176}gcMgeFFfDFFFfFfN\173z\177\181v\172\211N\STX\191\187\238n\134I{\CAN%\139\181t}\200\162ek\205\SI\187\209Zc\232\245\216\247\158Z^NX:\237\RS\EM\133]\182\236\135\172{\164\238\172\244\211A\176X\171\133\222\170\223\243\210(n\140\DC2\SYN\159\237\177\&0\173\&7 3\187\250\212r\205\254\214c\ETB\191\253\132]?\237\&6\207\164\241\136-.{A\194\234N4d\177w`\230\167\DLE\170\156\217\USz\221\ETX\243\250O{]S\214~\DC4\178\t2#X9\187\ETBv\227\200?\184\240\179\FS\206P>\203\CAN\220\141:\163\SOHdkxA0\237\218\EMk\237\153\153\233\180\239'\r\226\DC1f9\190X\227\&1\188\137ff\f\133\231e\DEL\251\194\227\143Z\199\237\250\180{t\RSs?|\248\220\SI\231\185O\FS>\247\137<\247\201\195\231>)s\a^\146\182So\184\216t\134\&1[\NAK\193$\245\226\180}5\v\173C\168\203\130\212\163\&8\RS\194\&8?i_%\SOH\157\187:\b\230\SUB)K\210Z\198\241N\DC4\166\240{\DC1\SUB\162\238\160\248\179v8\SUB,\177\CAN\209*\159m\SYN0\204\176\CAN\142\130\128\167$\139\151.;a\148\242\192\146\215Y\233\197\DC1\180\GS}\166Q\DC4,y1\aO\253\&4`<H\164$\253h-\228\223\f\250\EM\135\137:<\DLE\141\210\NUL\SUB_\DC4\EOT\197vR\214m\167\236j\218\SOX\b\213Z\245\217Z\ESC$\ENQ\130k^\b\140\DC1E\161p9\131\b\184\217\238\EOT~g\165\205Bo)`]\158\144t\226(\b\218}\168&r\199O0\173\205I$p.\151P\193\176\183h\179\208v\250,\CAN\182\189\176\211\143\EOT\EM\DC4\129Z`\209\238\167\233pqnnmm\173\177v\172\DC1\197\189\185\139^\176\146\204]\132\186$s\ETBP\141,\204!<\253i \251\ENQB$d\209~\146\&7>\ETX\221\146\246-\170\180E\181p\172d\232u\152\ENQ\EOT9\214\249Q\156D\177\245\EOT[N\231\158\241{\253\212\177\236Y\ESCb\158\238Y\207\SO-\232\130\CANz$lX\207B\254\v\DC4q\206J#\171\211\a*\152\181\f\141k%\254\ACKk\216\SO\254\180I\190\176e\241\195\235^\EM%)5*\143\129\150`k\214\217\&8\246\214k\246|s\152\218\142=\191\192\DEL\RS\228?\199\249\207\t\250Y\224 \v\FSd\129\131,p\144\ENQ\SOr\140\131\FSC\DLE!\199k~7\237C\137\244\209gH\SYN|EKW\160\161It@\191\182G\195\197\229Q\216I\253(\172\213\&7Q=\251\161\159\186J\\\166\174\ESC\152R\171\183\182[\254rAc{\221\238\163\171@\223\DC3~\STXB\206bM\183\212\167*\160jv\DLE\129\194t\DLE\175\195\149U\139\193\223\f>M\189N\159\178\212\236(\204\129\161\SON\US\229It\SI\165\182P\181\172\203-E\221uPl:\SOH\190\ETB@\vt\235S\SUBX#I\215\ETX\214X\245\DC3\DEL\201\SI\252t\221\181\161\128.H'\175\DC1\176\234\162?`\208ej9:\165\n\206CM\172\148\207\184\220\171\236\227\180\196\f\ESC\254\220z\173\233\128\162i\149c\231)?TP\205|P\GS)\FS0\187E\n\SIs\183\131\168\131\DC4z\FS\ETXO\NUL\198\203\206+\163\214bo\216\246\aC\232\n\144\137\DC3!\211:\208\DELAF*bI\DC1\NAK#\NAK\165$\147\132\160\185:\r=\150>\202\NAK\\rn\253\162\215{\210\ESC0h\\\130\181E\206\161\151v\250B!d\232T\GS\233R\fHW\183\173F\215\144v\164\187\209\143\217r\198\228\b,\137N\204X\184\&4Z^f\177\US\246\\TT\STX\173\222AU\204y\138\172C\n\"\NUL\186qY\ENQ\235\142b\141\215$\DC4\254\NUL\148W\145\229\212<B\233\198\&9J\208\216\&9\143\232\147\167\172\176\245\165\200\139\187\SOHK\DC2\183\198\&1\128\DC1\178\181%\130h-\136\SIa\"\212\169c\SYN\243\214\167\148.\FS\179A\180\138z\216K\DC2E\146EM\GS)\244\245).$\138\214w\155\173m\RS+\135\&9W\239i\141\148\183\166\235\218\231\158z\228{\246\EM\234\209\&4&\228\NAK\227\"\213\128\241\165\151\246O7\161n\168r(\214U\NUL.\149\154\252\178\142B\196\DC2\ACK\RS\v\186,\239\EM8j\129\SO\134V\199\234yA-\235)\130\237\249\232\200\139\197\209\222\135\193A\205\212\246S6\168\225\128$E\DLE\202\128a\180\rV@:Jj\156\178\237)R\DLE\155E\180\152\175\&5Q\213$\207\141\133\bS\ACK\a\229R\213\nE\214\235\178\133\DLE\135\236\v\170\SO\224\205\174\242\185y\217\177\151\253\&8I\143R\EOTT\"\ETB\nD\202\251W\141\254f\232\193\130\224\\Kih\143\150\219\194\184I\212\194\132\178m\SI\227h0\196.\EOT\r8m\144\206,C \135\ENQM\172\FS\155\134k\219!8nu,\141\210\&4\n\185\&5\161\148XB\224\216P\DC4\168\128P\228\134\175\&6~\RS\152\a\196!I\148L\244m\202\197U\140csE.r\240\143\238\&8xn$\tx\254\&1>\195H\f\DEL\EOT\193?\204\EMr:\210h\212\233\147\197*\178\229\DC1\DC3dD=\161\230\195\239\t\178\177\176\171\230\130O)\215\160w3;\DLE-K)+\130[\181\\I\192\252\161n\RSq\197\248\234\204\&7\155\DC2-\ni\174h!\215\227 \138\241*t,\163\r\ETXU\STX\131U\233\FS\219\206\STX\"3\SUB\t|\156\216vJr^\180\153\178\RS\SOH=\DC4\140Mi\195\215\236\174\191j\151;`\212\SOH\t\192\194\160\230\GS+\235\255\136\169\207\188.\141P\DC3c\DC39\144\255\157\163\226\ETX\160D\b\200\129V\194\t1G)\204\ETX\CANs/\"Q\SYN\216p\231\ENQQ\136:\234\&4\188\225\DLEZ\237|\223\SI\186\DC27\175\154\212\145\\\181-Gq\141\204E\CAN\CAN\252Se\229\222\154\157\245\133z\231c\FS\US\GS\189\196\160\133|\208B\EOT$\152\NUL\202=\US\DC29\DC3.\130\ACK|2\STXUT\243g\231\235\179v\195\&2T\ETB\242q\EOT\158\153\DEL0\175oy\168\GS\207\166i\236\131\SYN\SOH6\160\169\NUL\134\243\&7j\246\172@]\183\185(b\133\DC4\245\196\171\237\137\154JuI\213\197Q\175\170\190\234\152\133\182\142_\199:h\181\134h\140\139BRh\174:,w\184\146\163T\161\203\n\233R\167\SOHH\214@2\128d\200p}J\134h4q\189\DC2\247<\"\219w]\CANT1\141\198\ENQ\128\195HC\ETX\131\EM\203\155w)6s{)64\209R\140\195HVS\SI\199\DC4,\v\184\151\184\186\GS/l,\168\132h\ENQ\ns\208Z]d\140B\SUB\DC2FC\133-\218 1\SUB\182\&8\FSgnV\EOT\171o\130\249Tc\174\176\DC2\EMN3\136\ETX\202\bX\156\DC4\159B\222\DC4&\NUL\229A\144\ESC\ACK\n\154\&4\SUB\226\&0\b3ZO\148\141\229\176F\al\\\SYNL\187\217\\\169>%#\185\234!\168\152\165\163\&8\252\142\ETB\140X\SOHTIq\201\218j\241\CAN\139\DELl\183t\ETX\205\SI\DC3\SYN\167\231\CANt]FJHO&\246R+\213%\RS\NUL\194YI\194\r\f\212V\170\230\227@\202\252*\239\221\154\140\230f% \227\n{\156B\157\192ZUQJ\253\171\165\183\&2\161\170\NAK\218\DC4\ACK\151\153\EM\165m\212i\ENQ\182\238\193\227\142\152{\142\161\129\nV\t\201\245G\NAK\NAKPG\202\165\205W\249j\156*p\249JI\222\SI\156\&4\234\225\208:\150\169:\SI\148\ACK\173\213'\150h>7\215\237C\147\t\136\&5\234\200\181\RS\165\191\161\SOH\b\SUBU\239r\188\253\188\CAN&\134J\DC3\194W\155G\138\206\194?ff\248o#\EOT\213\138Ki\174+\181\208(\246]\145\216++x\194\SOH \218\132\163 \ENQ\201%\179X\\n\153\166\252\210&\174\DLE\165<\186<M\197z\180\238\185\n\197\&9\134\170\174\&4\179_O\152h\ACK\162gQ\167!y\138y.b\170_}\252l\"\141\215\167H&\SO+\240S\GS\\ \NUL\193\152\218\220\222\222\158Tz\139Z\160^\234\222\181\131\148\182\208\138\138\&5I\186\SUB\147\184\204\203\193X\DC1{\SUBVH\232 \145\230@<j\n\163(\168w\a\172\166:\"MA6\r\STX'$\231A\252\169;Z8BP\236Z\223\239\244\&9\180\DC2\193\251\172\212\230bH\153\ACK\160z1\146g\234\164q\240-\182\190\181\197?\189 \253\150\SOH\SYN\vq\231\143\169=\SI\199\231?\247\187\255\143\250\221!\186\GS\152Q\203|Rg\234r\149\157\138\ESCd\219SR\224\RSl\130\250\151\171!r\221\a\195Y\r'Fu\236\132@\149[\199\155\218\247\228(\213\174\129J@N\177\213\145OA\142[Jn\190p\ETX_-\237\203\173\225\214\192#`H\215\177?\161)R\DC36\142\&7lwY\224\173\235\217\143j\168\249P)\NULO\185\&8\181\133\198\154\226\&6\DC2T\205eb^\142K?b\ACK\205w\183\\\138\167\189\215\191T\DC3\214\149\132\239\241\EOT\177\247\229*\US\235\184<\232d\v\ENQ:\241\227J\207p\229\165\USU\171\213\210\nQ\170\162B\173\203\178a\154Q.\154\&3\205\196\215\163zC\DLE\176F\214U\RS\183\174\145\202g\152KI\ESC`\191\237\165\253\ACK\132k\221\171\245<~]\137_\167.\192\219\227\161&\136p\141g=\r\182\228\214\SYN\a\199\&0\152a\216)Eb\179\241\208\ETX<\141Gw\175\158\210f\RS\164\fx\175\&6\218f\217z\166\n\195\151*-Y\202\250\233\ENQ^\198Um\137\184\202\154D\r\176\189\237,\209\244\SOHFF?\212\182*\242\213\CANTs\250\214\SOHW\DLE\217\"\141\ETB\192\&4\EOT\230\135\132\201\"L45\240\150S\SYN\151\&1g\235\134r?2[\243\173ZR*,\nmO\137\DC2\169\NUL\165@\n\EM6\145\b\137Jh-\219L\144\159|Y \175\176j\136cU\SYN\rs\217{\173\191\150\153\214\225\149%\231\201X\174\163\152\135\150t\n\EMK\244k\147\175\194\146\172Zsu\225z\178\NAKx(\187Hy\169\244|\198t_\139\190\167\197\DEL1\225\211\&6u\140\STX\202=\SO\132\218!pe\251\203\188\243\245\248\183\255\STX\170\165/\166\241\156\218:\SUB\143\186\228_.\172^\245\128V\SYN\175\251\131\158\237\216a\132\204\221v\228\242\176\&6\249\162i<y\198\DC4\ETB/=\244\136p\r^\DC2b\240\171y\186\203\132\217\189\ACK[5[\229\202\139\160\\\188\FSZ&#\211\201\188\231C\160\151\203\171\160d\200\137\CANi\195\NUL\203\229\218\228\DC4\225%HP\138\177\215Ii\185&_\187\196\230\161\&56\ENQ\146\214\240fmZ\244\195b\197\194_\v!@\242\135\129\215a\181\185\231f\230z\142=\227\r\134-\224l!\237\DC4\165\ENQ\169!\233\&4%\245(I\216\a\b\SOH,Ri\201\153\132\179Y.F\CAN\218\218\194\191\217\DC4w\SUB\167\184\DC2\vr\SI\224\&2\NUL\177\225\246\216\188\173\228\DC2\145\253y;\207\136\DC3\ACK\228l\a\215w\\\STX\205\215{Z0W\bX\141\210@z1\213\192z\158,\139\215Qs\180\244\151\198\166\v\208\223 On\USQ\205\183\GS\181\133\170\232\151\152m[#\149O\247\143i\229R\STX\173\DEL\EM@\231%)Ej\201\RS\193\&5P(\129S\206\139\221\164H\252\&3[\SYN'\STXi\229\248\140T\"d\246\ENQ\216E\131w\162\225zL\254\ETB\133\174\135R\225\136\SOH\150\170\&5`\169w\144\202@\152\146\206\192H}\229\157\132\GS\163Qk\232S3L\STX\f\162\224\n \145\202\167p!\ETB\169\140\144\\\178d\237\139-]\220C\USG\186\DC3\145\179\223\159\STX\a\208\211\231(\146u4w\SUB\200\153\&1\255@\137\GS\243\146\ETB\210Q\224\255\DC1FHrr\226\143\&7\225\DELe\ACK\by\DLE\218\177\189\180\222\SO\163\176\189\DC43o\ENQ\250N\155\188\176r\158$i\\\223\212\233\129(\141\FS\248\134*\186\243\199\155\194c&s\170(\185\&2\193\CAN~\224\b\FS\248\229\SOH\CAN\243\EM\246\177\248*%\165B\r\242\rmeW\139\175@\SO\189\CANJ\193\253\US\199\SYN\149\179\193\192G\222\248!\186\158p0\185)\193\253e8\156\216\240\201\246?\162\160\139\150\184\192\140\179\EOT\145Y\166\bg\SYN\137\177\180\147\162\204\242y\tT\\k;\207\178\DC4\140\226\241\&9x\ESCr\130Mk\172\&0Y\160a\DC4\137\DC4\NUL\137\EM\192\177\155v\190\211[d\156c\179\171C/\236\DC2\RS\190\211\141dJ\226\249,'\227K\SYN\173\EM\196\202>\171\192\EMF\b\141\214\US\175\154\&0\a5\198e\220\DC4['`F\201(\197\152\129\150\231\227\DC4\134\182\182\240\175q\156\230H\168w\227\128Ap\165\225V\f:\134\129K,N\128\193\182\DC4D\157\NAK\SO\169\175\194\GS0\DLE\t*\136\ACKC\253)0e\176\243\&1\SOH\157\r0\US\235\150\&7\155yz\150\202W\SYN2\SUB\207\DC4\b]\228\ve\247F\173q\251$\164.\149o'MU\241\129j\"\ESCZr\131\211u\NUL?\138\196\SYN\153a\224\215\215\205\SI\173\n\247\198\DC2\177^\165)\157\t7k\200\NUL\DLE\187\169\153\156\US\176\131\195i.l\226\200\186\168\155\154\STXOI\143*\186\167\188t-\ETB\191\149\154\201H\180\CAN\243\149\242\ACK\223\DC4.B\242X\215]\224\147\133<\177XUm\255u3\219\150\202\180\135\SYN)\242\168\203\&6ee\150\167\NAKT\157\186\192j\218\139\208\&7\138M{\193%eP\246\202*\SO\152<v\156\243\t\135(hw\DC2DP\237:r\177\&7;\156\&7\227\ESC\230\216T\a\129\225<D\207W\DC4\128\203\210v\149\155#\228\202\157]\236d\205\US2\v\157\&5\209O\ESC\251\v\254b\143\224SO\225\216\171g\186\128\198\136c\145\v8\250gGkV\EOTSU#*{\214\206\177\&9\220\169\220\194\nZK,\128\140`R\NULl\204\172.\216T~\144\216\ACK\231)N\DEL\230\226\166\246?}o\158\247x\193!\202\244G\225`P/x\CANh\r)\170\201\149\153&\EM.\255i){\237\149N\207&\202\183\157\135\154|'^\241l.\202r'\SUB\161'\152\131\171\197\194\215Vx\178\RS\228[%\224*dP\164*b\200\151}\182\182\166\133\247\218qa/\146\RS\EMW\SUB\SOH\DC4\138!'o(f9\136\188t\145\227h\209\196\242\168\ETB\248\189PD\145\205N\EOT\154\v\NUL\179\SUBMs\SOHS\237\ENQ&\214\209fm+\156\ESC\216\162Fj3\n\f\ENQ\214\168\DLE\148\135\247\245\220\&7\218L0\166W\208\171R\136`\178\&1X\148\140\163\&0\ETXR\187\241\ETX\150\205\139R\171)\SOH\165\159]0\172v\DC2\163\179$&?1n\181\202\227)F@\238\200\230\232|\206\243!\157u\145\177\178U0\245\140\228\151\238\144\ETB\f\229\no\190E\231b\152\200\234y\160n\171\\\209l\203\132\DC2\179p\158\200\149\254j\190H\b\179\SI\221\NAKo\213K:\177\SI\227\202$\219\t\213\248\140,\180S\233\176\216\201\FS\SYN\NAK\f\149\188\148\DLEF~\202\196\186\228\222\194\225\185\183 \185'\214F\148\165\179,\142{!e\159r;\FSDx\172p\227O\131\DC4\SI\173\233)\235/<)':K)W\DC1!\NAK\223m\147n+L\207*\187:\226.L\183\&2\132t8\ENQ\244\160\143:\216\205<y\207\216\203\254U0\142\ETBmo)\137\STX(\174\164f)\231\198\227X\SOH\215^h6mS:\157fr\237\147'\ESC'\191i\EOT\224'\156\\{\190\177\192\ACKF\b\CAN%]\219\ESC\165\145\&1u)\STX#p\224\218\230\226I\179U\164\241V\175H\196\254~\SYN\213\154k\147Z3\193\224\162\210\ENQ\DLEV\215>\222\&4\DC3\215\137\STX\232\230v\f\140\212\147\151\162\184\203\226\239\DC2s\154z\146\"7r\204\&2\210\157\GS\221\SOH\252\189\165\218\194\131MG\252\171\219|\169\190BSfB\170\234\222\153p)\EM\182\248\223\a\248\143]-P\201PQ\243\201\240OH5W\146\244\229Ut%\234\175DUs\ENQM\222\224O-\159\191\143\218\&9K<\180\154\174d\192a\213\245\&8N~\213j\219\164\155)A\235\209K\SOHt?[M\CAN\192\EOT\208\SI\159\224\250\166\241PI\151\153T\251XS\144L\175\204\DC2,\232\233\\+\183t\b\161o\185\186\212\147\n\154VOT\148\172\158 \244k\179\DLE\157+\207\STX\158\\o\138\DC1OOW5b\161\160\177\n\237\176\SYN\241\CANY\DC4\134qad5y\154\US\232\249\n\244R@Y\230\152\153a\141$\238\136\NAK\235leD\141\FS\235\CAN{l\204b\202\129SG\ETXV\FSI\128\200'\162\&5\SYN\159\247\DC2V\171O\187\168i\148u\138\242\233,r\141,\US\224\148\194\233\n&\SUB\143\190\137}\229\234\EM\166\202v\156\f\154\206\180\150\182\EOT\FSy^\134\214\205p\ACK\239@\aQw\157\SI\220\&1\192\141Uj(\153A\174H\209\&6\STX\223B\144I\250.\130\220\215\150\169b\ETBA\158\213\201[hZ?6\171l\GS\208\234\158\204\160.\240\SOH\NAKEe\248\232\216\131C\DLE\233Hio\NAK'\221\180Y\195\217\140p\217f:|\152O\b\GS\188\170\&9\241\174u9\242\145\199\191c\136%\170\234S\180\149\212\162C-\165UO\226V\245\130\STX\223\212-\210\164n\245\210\134\238\246\182\163\159\137.J\NAK\143u\243S\253|l\SOH\196\147\157\DEL\230\237\163oBaf]z\168\133\&1\150|S|\211\&6\138\218\166\144CxV\240\US\129\236\&2\226\&0\202\130v\164\STX\201/\217)\143jg{L|\155\207s\151\198\230\131s/\168Nj&\210r\221N\244!\SO\174\244\187~2D7?\155\214\204mh\179)\197\183\196\229?\173\188\GS\249u\SUB\197\173X\140\252ci\197\190\aC\197(%:\169b\151\232\239\228\173(Y \168\194\191\n\ETX\212kD\nlP\146\254X\152Qhw\165\134\151\148\240\225y\163\146\170\132\209\&7P\189\132\160\212\223Y\176\156\239u\240\193\ETX\154+`\202>\170\240\252\151\254\207\&8)iCu\240$\177 \DC1/)p\221r\170~\141\129\&0:\161!H\136\241l$e)\251\183\231Xi\159>\207\&0\205s\168\192\154C~\158\n\186\162\by\185EQe\SI\252\DC2\164\171\DC4\217\154\FSs\217C\157G\235^\245\219b\213a\156\233\194}\178y\195\ACK#~\RS\CAN0\EM\238\160\DC1\251_\220e\151\183\241DR]\246\182\DLE\185u\177\206\SIq\DC4\239<\169O\137\f\232eQ\190\DLEEl\EOT\ba\210.EQ\243\233\ETB\163\232\153\234\153s\167\202\235\210\137e\DEL\160\157\150\160\237:\140\171U\GS\173\144\&6\155j9c\134Y\229\b\130\193\136\182g\167jf\132\228s7g\207\SYNR3V\130\174\210\SOk\ETBI\NUL\NAK\209w\243\190\STX_\133\211\155JY\167\209\241\154\&2\184\&6X\DC2\"\244\r[;\252\214\139\210H\bb3\223\&4DXya\197\194\204\f~\130\225K\231\133\199\208\ENQ\243g\209o\161\191\130]\151\176\199\161\177\180\218\&6\146\209R\146\198\181\133:\183&\253\228I\239I:\195\\Q)H\194\187c\232\CAN\131\178\192*/%\169:\214H\151d\152\SO\132H\189Q8\ESC\149!<\173\185\156g\209G\241X\SOH\nY&3f\225\226\254{\ACK\EOT\130\&3\ETX?L\156\132u\146\SYN\254\225.\243\203A\EOT\189\203\144gn\158v|0\143\n\137\&9\231\142\&7\235\FS\ENQ\254\249\230\241f\139\151_C\224\&3\248g\214\RS\216\139\&6\136#\STX\204\218\137e+.{\b\139\206\171\138\186)\210\131'\156\DC4\223\250j]\221\202\228r\STX\SOH\EM#\173x\DLE\NAK\v\133\DEL\179e\193\246\EM\b\179\250y|kK?\218\166\182\219p\148\244\219\136\132$Y\RS\200\154v\245\154Oi\159Xp\190\203\138\151\189\212\167\&8Y\DC3Q%7\194ff4\129\159v\241o)\DC2\SUBfJ\139\"\176|F\194\175\SIPe\130|w\173\131\171\&2^\232\183\GS\181%\243\&6\199cb|\174\136l\200\253\158\191\193g}>\158\196($}s\225\152\146($\vy\152\aeoo:>\SYN\r\DC3\228\229\216C\225.\184jS#m\SUB\248q8A,5'\151#\160Y\138C\177H\161\234PA\214\165\b\207#\DC3\249@VQ#h%\211t\249\220\250\227]<\223\ACKct\188\254_br2\148W\224}\151#\148\185\176\161\241\NULZXSW%\143\156B\169;}j\142~\142\240\EMjc-\246q\ENQR\164\225\220\243\244)\158\193\194\v\201\220\231h\ESCq.\199\243\156}:\187T2\166S\145\185o\155\222\STX\181#8R\DC1+f\237#\245\214\169\&9\142\SOH\171@\229\160Up\186\207\130 \178\ACK\163\193\169\&9\250\SYN\245\DC3\213\235\EOT\DC1\174\139d\222\175\198\241w\DC2\241\DC2b\211T\236\DC3w\DC4\178\164\227\rYM\DC1&\188\176\162\174\174#U5\ENQ\199Q\215\188h\248\RS5s\231\158\171\213\158\235\214g\159\171\207a\186\&8\245\&7\160\179~1\171\155\198\&1\SOH\195k\129\190\225\243\142\136\202\238\134\224\&6\232hpZ\153\134\137\212\250\DC4\"\155G\128\163G!\136\DC4cL3s\150\a\251\DC1\NAK4T\237\DC2\175\218\229?\182\170\137\246\217\158\DC2\158Mx\192Ju\254\&1\175\152\137E\v\225\225U\246~\204g\238|Qc{2\DEL\168\205\188>\219\202\SUB\148nNe\150\169<nq\217u\v\SOU\190F\154\163\US\"S\207td\199d\234\133\131\164\202\DC1\167lz\129UU\243\168\131\149\&6}\128QO\181a\242c:\211\228\128\170Y1\202\EM\158\194A\212\252\&4O\229\249\216\234\243\182\242,K\182\b1\198\164\226\&3\156\175\231\&0\179\SUB}t\254\222\SI1O~R\234\NULV\UStf\170\146\195\165\203Q\f\183\140U\RS\173\214\133M\RS\183R\GS#\151a0\236g\a\223\232j'\176T\243\227\146\247,\197t\141\166k\226\ni\237I\196\187b\162\131\ETB\233\FS\192m`6\ETX\254\242#\224\213b\141\GSm\186\162*\n^\222\155\170\166\v\167\198T\243\SI&\243\179_B\230\199\US\220?\236\249|\131\184J]1ml\NAK\210\185\248=3\163\138\156\185\201\&18\174\ETX\220\247\139\STX\238\181G\145Ss\177KM:\SUB\152\219l\218\253z\180j\243\143X\148\190\202\139 \138\235i\226\138\232{h\194j\134h\141[T9\DEL\SUB\SUB'/\253Ok\152\173PL\218\210\207\215U\173\&1\130\\\SUB\255Kb\169gP\143\134\225\237\r\217izt\229\156\202\188?U\167\NUL\SOy\166\188\249\191H\238\STX8?\203W\213\148S\168\163\129\178\155\247\149\138\\\190@\254\aWB\247G\205|E\139\&5\ACK6\SUB\ETBr\242XE\\(\171\184$a=\236(;^\EMZ\190\&4\192\239_\189\CAN\213\154N\211t\200\135\160\181K\236\242\134\&6\151\151o;\149\243\SYN\234RB\160\239\192\209\228~\169w\RS\ENQ\187%'o\141\206(\198\137\224\ENQ\DC4\250\250\148Hv\203i\151\148\141\&3\130\177/g\235\218Y\147u\217\178\&7\n\210\239\128\166\151Z\RS\243*\ESC\"\n\EOT.,\156\143\ACK\195Q\202\186T\132\160\144\247{\172 \229U*E\223\152\237\233\CAN\175\EMJ\215\233\&8AM\169\217Q\234\182\182\216\231\216\148\&9\237\&4\246\194\132Oy\237l\255G\166\SYN\146\161ds\202\214\150\136\207WZ@/\240\ETB>\fi\209\208\235@\223\161du\204;\143\173\153]s\197\ESC\151\206qHY2\220\135Z\222\153l\249\179\179\218\246\165[\EOTD\143\DLE\209\228\149%\230\224\249~)\173\137\224y\218\162\148\DC3\SUBG\160\147\199*5\241\206s(r\154\159\180\204e\217\b(\219\133\175h`\191\208\239\130\ETB\157\165b\187\249>rm\178\202:\ACKF\NAK\186\160\206\&1\225\&5D\142J\184)\156\178\&8t\192$\134\254\208\DC2\159\238\220sk\179s\189\SYN\143uEN\177L%`\234b]\134\240\DLE\177\FSZ'\DC1Z\147G\211\234L~\ESC{\230\253S\NULP\183\197s\160\217Y*\133o\DC4\241\STX\221\166~jNT5\167\247\171\170m\182\208\149F+,\172\t\222\&8Y\190\194\177\214\210\153\&5q;tqGfM8<\251\242%\n\185\223J\155\147\228\SO]w\221#|\136\&8\130/P |\t\198\160\fE@,\158\206\204T\165\&4:\129O\139\217X\148\192?\tl\185H\254L\133\190\251<\SOy\DC1@\248\174\145\USe\NAKG\RS\163d\141%\"G\EM\234\203\&3E\148&\139\152\b\250\&0|\169\194_\STX\225\206u\CAN\194\GS3d\214\FS\255<=\223h>\244\192|s\225\193\185\135\143\159\160\211\181\196d\158J\t\141&&\137\221VL\156.\174\254P\236\214\SYN\207SJ\237\139Jn\202\252\167\221y\188\231K5\141\179\167b\220\135\&2\250%l\179\DC2\246\193\"\236\137J\208cE\208\227\149\160\v:h\ENQ\DC4\tX\243\148kJ\156-D\230\&7dh3\191\t\224O\233)\249\234\188\177N\135\195\173\CAN\147<\178\205_\USiw}HN@\199$\156\ETX\142h\193VQ(\v\167\&6\166\v\NAK\208l\248\172B\151\209\219i\f\150\201\144h3\171\\\b]\250[\156#\136\238\209\207\186By\161\231+\156\239\140]\221\168ZV\146O!T^],2h\215$\203\135\190\212\151~\240\182Ie\230\139wM\182\249\229**\161\252\169\170\171\"E[_\211\SI\201d\238\133!\190\209VX\195\",X\STX\f\179Z-\148\197\DC3\243Q\215\STX\187\148+\235\FS\238\239`,e\158<R\213\ESC\222\204\215g\155o\157.\188\244\"'A\249u\210\133\182QW\204\249\203\n\197\&5\162I\248\175T\150?\211p8ndEg\206M\230{\216r\DC4\234\219\&5\133\251\r\141\r+\252F\205\235\161\212M\174~\t\249\161\227c\STXA%\DLE?\nq\DLETv\142B\239O\147\189\235\163\175\204\228\"\213\188O\183\194fw\145\155o\201\&3v\r\173\217\204W\200\ETB\168\184\183'\141\204\178\129\189\169\180P6Q\207\169B\216\164\238Y\144\141\162\156\230/]\254%\DEL\233\&2\179\131\&3\DELP\145\208\186\&7K\140\151\255\EOT\185[\t\204\DC3\192\150\198\186rf>v\229\&9\148\rcA\243\250\129\&4\DEL\175\138\230\239\221\a\154/F\195II\ACK\208\195Q\140\EM\DC4\130\163a\234\SIpt\198Q\156n;3\158\f\152|l%\151\154\190X\201\225E\nK\150f=}\183\199\132\255\f\143\SYN^\217#4\ETB\US\232\246\231\214\250\242vU\206mk\148\250\242\&58\203\181\236\217\209\172\253M\v\t\182\236\169\217n\DEL\214\198'\252 ~\173\207\US>\225^}\144._\f\204\232\129\&8\222\137\&10\165\250\253\b\SYNR\195\228V;g\ESC\151\EOTi\176\231\156-\167\142\195\162r\162\140E\227\147 \USf\174A7<\146\226\237\ESC,\RS\248!\203\218S\204\149\&2b9\167J\244\242\149\230\137\166R\242\146\232\242T\234~\204\162\SO\DC2\229\226\132\231\DLE\DC3(\163\164k\248\182\179GB\f\f\"\SOH\239;Q\191\149\DC4\231\167Z\155D\197\212b\187\163W`\212\207\FSY\224\251t\212?\147\244\ETB!R\247II\ACKt\227i\229\176\159\219\202\228\163q\244\168)I\ESC\ENQ\199\SUBz\247\193b\255\SUB-\236C\155U\252\213\202%\191\215\155\136\165\NAK\211\&2\218\167\155-\206\184\254\204\233\&2\167\171&\156\&9\239\181\153gayT\177\204\248\219\154\250r\FS\STXB\130\184M\144C\200\229\228\SOH\DC4E\a\241 \190xw\USDs\215\195\f\200\181\233\190\225\185d\181\&7{u\DLE\216[[J\146\&7\196\ETX\150\&4\162\204]=\n\132vV\214\188Uvt\EM\236\165\190\205\237\185i,F\220\249#\SYN\177\138\&1\134\154\DLE\237\226h\165\STX.\149U)\202\128\"S\237\128\163X\"\168\152BL\163\211\247\226\179i\t2\151k\160\247\155\210\147\DEL-w2,e\128f\233\176\SUB\189\174[\129I\156\139ck\223\229\147\245\ajk\232\211\222\NUL\185\192L\137\129\DC3\SOB\v\DEL\255\DC2\241\SUB5<\202@\142H0\210\211\&7\210#r\CAN\b*\226\202(zL.\155\213\250\213$\137\150A\154\RS\163\155\228\183\157\236e\197\210s)~\254L\138\249\137\DC4e&\129X\208\254\198\ESC\171\SOx\173A\DEL\171\225\160\199Z\FS\225\149\153z\189\150\169\184\236\ACK\173\241U\213_s\217\172|\206E\222\160\167\166)G\189s7#\237\189\151\205\226\131/\242\152\&8E\137C\229b\130\&3\201\&30\211\186\166\\ow\250q4\200\174\US\213\SYN\242\134\172\131wz\201\139\ACK\178\ESCJ'\DELYF~\225\181\179\166\135f\148\ENQ\ENQ\237\201\170\153\EM\168\251\180{R\252\206\US\ETB\SOH|\215\131\STX\SI6\r\203\SI\213/\148\208\163 \v\SIomQ\224\196\131\"p\252\225\ETXEJyS\228\193\226\\6\159\227\170d\NAKv\216\249\176\"\252N\SI,L\202\NUL/\241\216aK,<\vqo\165.h\172-\189DqHl\250:Q\161\130\211\162\ESC\244\253ez\136\232\176\200\143k\200\NAK\159\181I^v\209Q=dp?\190\&7L'\171\248\247%\169\157/\137\131\184\221\179\"\186\242\130\202\&2\130\138\187*\r\128\aU\185X\231\DC3'\244\195i\220\188?4S\231O\234\GS\158\155\180\135Gs\226\164\232\250\243\205\147\247\167b'\164V\153?9\159\225~\248~T\246\196\177\251R\195\227\199\239Ge\n\252\255\DC2\253\227\225f\221\244\FSMfK\US\146\186\135L\216\196c+\135\172\152\142\138_vBgo\219,\196\177\165\235N\143M\230\167yp}\162=Hznm,\240\EM[\EOT\236E[\FS`\238\210\129Z\130\NAK\215\141z\221U\172\177-V=\DC4\254\203\147\184Yq\245C\139\151:\n\SYN7a:\218\201\208\234\ETB\131\SO\201a\SUBZ\244\243f\234\241\SOy\185\215a_\229\210oDR<\254\240U\144\204\161\144\RS\181\159\153\DC1k>\249\162\136vy\197\147\ETB\166\221#\217\GS\169G\234\229\&5\148\STX8X\190i:\\\156\155[[[k\172\GSkDqon\254\228\201\147sT\FS\216\195\244\&2\201X$\226\133`\190Z%\136h\211\fY1]!\218y\252Qr\201BG+\231\252\133\v\217\a\209\136\DLE\ENQ\199\&1yn\168\148tI\193tY=\r\195\219\166\232\ETX&&\DC4\GS\136\163o\183\STX\142\215\210\206_E\201r\148\253\195\180\250\235ojd\238$\218\179\SOH\SOE\241\v\ETBRy\191A\193C\135\159x\227\174/il\242y\201g\219\a{\188\240\STXuY+9\176\232\190[z\131\201\185\142\144\&8\150-\232\137\139\251tQ\155RZK\ETXk\NAK\DC2z\134{k\235\130o\244U\170\133\147\245\EOT\137c\252\173\246\&1\235\177\171C\186\FS\228\EM\214{\244\234\176f\215\254\219\150U\183g\DC1\209\172\253\220w\US\DLE\247\227\RS\138\&2\142\182\145\178$\173\149\178dBc\130\&2\146\204\&73\243\221\161*\178'\167\136\164<HV\189@\156n\159\144\190M\145\169\220t\232\161Ei9\DLE\255\201\158\DC3\226\&5\163^S\202.`3'\188b9fI\184\167\&2\141\151!\v4\180\225\149\237\153\141\145\174\226s\EM\SUB\128\&8?9\EMGK\233\179.\222\&5A\207,qV(m5\158\GS\SUB\v\206\240\159Y\137lQ`\156\144\t\170\191\180\200\148\208\173\255N\180\226\173\183A\195\168.\213\134\145H\FS\157\&7\160\145\207\138\225u\USI\170]\204#\226.\217C\251\178X\149\200bbV\138\v\252R\DC4\237~\255\213(J\203\208\221\180\FS\213-E\245\ETB\202Q\199\202Q\SI\150\163\RS*G\GS/E\209\197\138\197Hq\244\189\DC4O\134H96.G\245\203Qe\210\240q\181b\FS_^\149\209\149m\230\138\f\138ER\ENQz),\157\SYN\134\145\215\&1z\225\ETB_\206\"\135aq\251\163\159\180\201\178\&8\131\183l-\218\231\158\177\239e]\FS\135\194VK>\160U\152\173b\156t\251\142\196kl\EOTG\231\DC1\196=m\249Qeq\222P\220\211\230\ESC\223\233\242Ko\154-\197\186#\169\201E\128?}\161p\199\214\SYN\168L]N/&7\223\194\168x4M/F{\210\167P\226tu\221\194(<\170A\235\ENQ\230\230\STX\255t*\SI\214\252\225\154<\171\210\159\155\253+k\246\241\aw\242\182_E\211X\222U'\US\233\&3\US\212\201\SOdP\RS\213={S\187\170\209\228\244\"\EM\156\159\a3\169\129r\145$\NAK\153-RQ\140\225\241\154{.\t\237;\253dt\177\159\FS\STX\157\DLE\198\153\153\178\160N\\{\189Y\203\247\DC1\CAN\222<<\184\204q\r\163\SO+cN\229q~9\153\250\206\235\DC1GQ\234h\149\145\GSW\154\219\NUL\160>^%\251l\RS\165?\201h\NULUn\228,<\223\168\\\213\169\235\159B\231\163\173\t\140\227j\198u\177V\ENQ\221\"\153\&8Ia\197\215\233\&4%7\tsx-\137\&7\184\214\165\209\171u\177<\185\174\188\204\148\231)\168\130)\201\&3Y\163\140\DC4\149/zZk\242\210*\202R\238\157\229\140U\249\166\180B\ENQ\211\DC2^\143\242\STX\v\v\234\155\f\237\239\138*\179`f\ACK\DC2\181\201\166\EM>\155\226J)\158\160L\181\193\SI*O\133U\203\226{\ACK\244\176\169\185(\169\139I~\137\229\128M\233\ETX\148\150\&7\133&\157\155\198QQ^\253\162\235\DC2^\145\212\235\149\167W\DLE\169\212#\159D\b\179\NUL\239\129\238\185\240\SI\172\203g\135Ci]\170\NAK\230\179\155/QkE\129\241q\FS\235TA\t\247\180`x\vi\225\174\&5m\133\233\130\132\144^\234\242\219\&5\192\240\187A2\144F\236\133=v\RSO/\157\150\199\248(\202\205A \251\&3\CANu6\197\219\254(\NAK\207\SI\a\222\&0\201v\198\178\177L>\EMK9rg\166\FS\ESC_\176\163d|n[\130\SUB0\210\138\DLE\207\200\186\133\135p\235\155\210\r\215\200\a\221\207L\167\US\SUB\247\STX\191\240H?\176`\196`L\173\198\145T#\168\224@C\188\132\171\248\ACK\171+x\218E\225\163\161\246\240\156b\159\170Lj\aL]\v.1\DC1\202\204\238\141,\223C\174\149P\249\136\GSzi\ETB\227\ACK`6A1\198\231\238\248\230\DEL\157\RS\253c\165\141\DELy\167\187ru\187\200\150\191G7\241\ENQ\239\DC3^\236\238+\175\225m\230\228\228\175\225\205\227\GS\138\&9Ey\194\130x\142\202\240|\158\226z\144=\160\183\169|\185\238\131\245)\NAK+?bX\245\196\158\232Sy\237\202\187\253\165\150/\222ayO\SI\226\233+\179\170_\187\217=@tY\222\222=w\236\205^z\253\r\251\&933\EM\193\218\212\161\194\139\STX`\244Gb\199o\186\223g\214\232\219'\133*\150\250\DC22\135U\241E\SO\166@\199\n[G\DEL\155\173-&\137\218\218\194\188\248\140\128\f1\152\140v\179/\177\204\"?W\129\224(\251\242F]?\255\242\195\225(\135D\185\129^\145\227\229\DC2\149#\RS\210\219\197\226\209z\233\229\162\143\236\210d\DLE\194\RS\168\ETB8\165Q\a\200(D\209\SO\165z\231\146\186\208\169=\EOT\172\242W\216;y\US6n!\NUL\239T\190OI'%e\DC1Z\213?\211\174\157\173\150\194\148\175\210\233(\239\216Bi\144;\145p%\DC2\213\192R\196e\175$\145\134\246W\149\225\215\165\b\201x\171T\132\146\195\194\SOH\202\145\175\169\234\214\147\"\191\129x\202\183Z\132\133\228\EOT\153\DLE\141\242\224\&0\v\ENQ~.\132\180\SO\153\129\196y\152\RS9\DLE\193\133<x,\SI>\152\a\US\202\131\199\179\160\178`\155\245\a\177\FS*\158E\148\143L\150\237Ej\152\236\186h\197\218(_V-M\195\210M\213\SUB\SO\237\158\234,\139~I\181=\171\ETB\139]\175\160\170J\142x\220\161\142\254\158\161\191\139\154h\t\199\&2Rm\231FK\217\179\182\153\207\EM\SYN\240t\142_x\232\NAK\163kE\199@\142\209\228\148(\157\248\212\146\133R\165\152\178b\205\234\130\DC3\SUB\248}\132_\165!\171\162\199\214\244\243Y\138\171\161IK;\252\130\203\164\205\146\197Mqu\228\162=\220y\173\215\DLEO\165\158\129\239\179\235\163\174\a\223\249\251J\139\246\206\143\195\174\223\161W\ETBK\175\&6-R\156gu\153\136\243\187\DC1>{yQB\158\207!/J\200\243*$\b!t\187\212B\215N\\\131 M\187h?\195\252\208\135q$\206\DC2:\254\206\187a\158\SOHk\246\&8\130D6L\DC2p\175\US\b\179\159\197\ETX,\GS\ACK\179\&1\176\224S\200\224X\160ec\207b\248r\188\239u\163\216s\192\&6G=k=\190\209\245\230\RS\233\244!\198\158\181#\235\EMf!?\172u\235\236*\133\SUB\214\179\160q.@\196\&9\v\180\133gu\188\193\DC2\214\t\208\167\222\192\219y'Bz\150GP?\ACKl\148,\238x\SUB\139_\237\&54\RS_1\243\152\RS\212\&3\179x\148\179\CAN\n\CAN\165\213,\RS\229,\206 \SI\197b\ETX\135%\131\129,\206\224t\195\ETB\FS\142\130\157\&7U\SYN\171\FSf\137\245h\242W\141\185GR\175\161\&0\248\213\140\193\175\DC2\131}`\176\143\ff1\240\&7\\\197\n\245`\130\213\221y5\246\137\CANt\236W\185\171\np\DC2\238\188\&9`+\n{\195\157\215\134\209\234\239\DELV\226q\180\148x\253\n\SYNS\SUB\242a\131\248\192*\248\251T\EM\172\130\185\ESCa\180:\178\146\225(I\253\&4\207\225\235\236\NAK\193\140\193 \193Og\160\214\224\179\183?\251\132\165\f\USZ\238\244w^\219`\128)\SUBD\157\157\&7\173\149\192_\tG)\132\ACK\235\159\189\230;\214\NUL\178\197\192\140\149\DC1I3\196\r\217\138\181\SUB\176\213\200\242\172\213a\236\173\226\131\198K\DC1d\221ym\NAK\SUB\231i\175\199\158\GSB\"\ACK\RS\SOHS\171a=\189\243f2\136`\242\140(\186;\175Y\ESC\192\200\DC4p\165\NUL\182\SOH\138\154\130y\GS8\162s\144xAi\160\&0P\197\223\235\249\161\167\180\207c\244\171\&7\205\227a?\SUBu\207T4\142O\169I4\236y\171U-\243x\SOH\166\162Y\250,.\198\&3\189I\RS\DC3\DLEgd\163\NUL5\246\147\222\170\223c \160\221\198\160\177\218\176\250\208\DC2\131\145\159\&8\248\186\ESC\160\192\147\158\214\DC3~\184\146\204=\195:\253\&4\177\210\136\165P\NUL\215,\203\214\211=\224\&4\v\225\247\DC1`\243_\176\165x\228\175\128\224C\212\&9+\SUB\160\148\175\128\130YIY\220\195\&55ht\248\255*\195~\192\192LQ\184\219e\nw/0?e*s\253`\153\NAKu\203\207\151\128&0\209\210\n\254\STX\239\188 M\160\180\r\ACK`\161_\165^\140\128\NAK\156~:\222y=\251\ACK\193\131\206\128`\172\160\194\159d#\173\v\NULu\246\&9\ACK\146\r\157\192\186\224\&3\171\v\255\190\237\141\128\213O@\ETX$\157~\224\245\FS\138=?\138\147(N=\180\&1\172\128\152\USs\230\131a\SYN#\227Q\176\173\209p\142~Q\194\173\141\209\192\250.\NUL\129\129\USZ\bE\f\f-0\DEL\161\&5\240\239\&9ky\231VL\ENQ\\\NUL;\223_N{\241\206{I\162\234\247\161*\224I\224]\233*M@\189\163(\224\201\208\a\153\136\217g?\235\248Ub\174\194T4\192\ENQ\EOT\185\152\129T*v\138\RS]\201\245\206\149\223\255O\163\230\201\164\FSH\178\255\235\192\135a\217\187b\DC1I\235\164c\188+\191\255A\atL\178\241\251\US8V\bj)\DC1q8\160\STXZ\232\STXi\188\225}vm\197\183\STX\182\SYN\205\129\166Y\139\128\249\193h\137\139\253\156\144\250g?\187\181~\ENQ\144zk~\178\177\206\181\190cyK\235\160Y\176\224\223\191h\197\DC1\EOT\209\DC3c\163\179\SOH\180\172\248\n\211\151c]\171\168b\DEL\SYNc\139*e\220\128\138q]P]\ETX\224\217\206\175\128\EMcl\150\&2d%\223;\209\NUL\148d\a\228*8\194\174\SO\163d\231\r\157\237\143\236\188\177\&4\202\132\GSH\226\170e\196\&6,\208[\GS\vF\239$\SUB\197\168Y \136\227*\148~\132\140\ETB\ACKQP\143\229`\231W\157>\EOT\128\197=o\EOT\193\185n\FS\129\DLE[\209\136\NUL\210hD\233O\247\172g\135\SO\254\DLE\243q\220N\160\CANl\EM\ENQ\nTP\138\131/\DC4j\r\162\174\191\236c\229=\v\US\161'\202\241c\CAN\161Q\165\180E\DEL\164\180E\DC4t\189@i\140\132\245v\222L\129\244^\161I\144\t^\DLE\r*[\133'_a\189\245\141\157\&7V*\155\164\EOTV\209\RSKl0J\209\n\180v>\188\DC2{0\EM\128z\237\188\150xz\155\232\137\178m\128D\251\236\134E\196y+\214\202\206{\ESC)H\248\206\ESC\195\NAK\214\221y#\233\ETX/W`\214\226C\173@\193y\ESC\SYN\144\253\ACK\180W\224X\171^o\GS\EM\r3\250\r0G\130+\RS\140\144\201\198\206\187\136\ENQD\RS\SUBVBy\214\149hi\201\n\215w\222\132(\228y\186\202\196\152L*\203\201\DC4\EMt\165%\EOT\b\211\245\207\222Y\129\t\172\ENQ\245\187`A]\NUL\254\156\154\182\STX\198\217*\148\155F\ESC@\DEL\223K\161\STX\128\133\234\240\222*\235Y\ETX\168)Kw\222P\205*?\213\251\151f\178\250\248Dg\169\131U\207\n|\153h\RSFDbU?\242\161\US\249!\154\166\\\252D2\170\132\194h\r\246\233F>\ETX\NUL\DC2x\DEL\194\140P\ESC\238\253,\237S\232D\NUL\235X\203\&0J\192\DC4!\SOH\235\ETBh\247\230\160w\195\143\NAK\DC1\163i\156\150\n+A<\208C2\235\148\172\DEL\170Sv\SUB\DC3\251\136\SII1\249\133\170\n\139\169\163\196\237\235\187\&7v?\218}{\247w\187\239(\140\221\253\237\238\167\187o\237~\NUL\137\&7w\223i\NAKX|\251\249\221\ESC\183_\128\148\ESC\183_\188\253\242\238-\128\250\152C\153x\SO\208oc\250\238\135\187\239\220\190f\169\153\161\144[\187o\238~|\251\165\221\143+\SUBe\247U-7|V\229\174h5\128|\RS\178\DEL\f\149\252\DLE\254Cd\239\ETX\213\239cE\222\SOHT\159\222\254\SOH|\190\ra\136\188}Mo\199\170\204\173lr\ETBP\NAK?\130\186\188\191\251.\252C\150\189}\251\251\187\&7,\228\139\ENQ\161O-\200\137,\254\144\190n\255\NULK\254\DC4\170\253} \227C\248\247\233\237\US;\FSP\232S\b\191cA\DC3\188\t\217\222\183\168\150\&7o_G\164\DLE\250\245\FS\180\213\141\221O \227\175\169\DC3\238\190e\201~\136L\218\189\153w\210\134\181\251K\200\130U\190\t\213\249\148\n\190\185\251\SYNG\198\203\129\184\143\160\169?\188\253}\128|\a\196J 9g\SOH=7\177\"\US\227\159w\NUL\234\163\221_C\185\&7(/\DC4\204i\195&x\ETB*\244\SOH\160\191\134(\223\199fz\ETB\145A\218-\168=\DC2\141bv\DC3k\DEL\251\154\"\138W\212\t\233\254\181\155\251\215\223\216\191\246\250\254\245\151\DC4Q\220\191\254\143\251\215\255\247\254\245\DEL(\b\225\ETB?{\235\243_\191V!s<q\255\218\223\253\199k\191\250\226\245\SI+d+CQ!:\159\255\252\249\187?\250\231\253\ETB\254f\255\218Kw\DEL\248\227/~\242\v]:\212t)\DLE@\DC2T\249_\246\175\253/\160\231\238\251\240\247\237\253\235\255\182\DEL\253:\EOT\172\253\235\USYD\230?\237_\191\ENQ\SOH\138\NUL\160\187\175\188\187\DEL\237M\136C\182\238\191\240\201\254\v\191\216\DEL\225\237\172Y\DC1*k\211\253\ETB~\249\249\223\255\248\223?\254\249\255\185\245\&2\180\SYN\166\157\131\184\253\235?\221\191\246\198\254\245w\247\175\255h\255\218\rd\227\181\SI\239\190\254\210\231?\251]\206\239\141\190\194\239\187\&7?\250\226\133\183\191x\233E\133\217w?x\235\238_\191Q\180\DC2\239\254\240\aw\223\186Ye\US\STX\ETB\239~\252\211j\SYN\243\196\n\SYN\255\231\139?\254\252\DEL\252\230\238\DEL\DEL\251\238_\255\234\238;?\229m\165\176XM\207\140B \195\254\226'\191\250\207[\175~\254\234\139_\NUL\155_\252\200\177\190x\227\195\207_\189\245\249?\191\230\b\142~\241\214\155w_\255\157\195\r\SO\235\238\223\189\204m\SO\235\238\219\183\254\227G\255FS\DEL@b]p@\212?\255\201\205\187\175\252\227\221\&7\255\225\223?\254\251\187\175\255\242\238o^Q\164\&4V\173\138;/\236}\180\247\155\189\155{\191S\216\182\247\233\222'{\183\246>\185\243\210\157\151\139\204\131\f\159\236\253n\239\198\157\231\247\222\131\140\US\239}\176w\163\138\149\NUL\249.\161\255-\252\189\193a+\CAN\187\247/F\208\n6C\ENQ\177\STX7\246\222\135\FS\159\222\185~\231\133;\215\246>\184s\237\206\203\SYN|\242\EOT@\STX\145\191\185\243CH\248[\189\NAK\202\217\247>\204Z\ETX\216c\239\253B\NUL\220\130\223\151\144?\128\234\ACK\148\STX\248?\132\n~\NUL\DEL\DELs\231\NAKk\239\214\157\191\185\243#\248\248d\239\166cAA/\DLE\235>\186\243\242\222\251\128\246\NAK\SO\141D}p\231Gw\174\243\202}\178\247\SO`\134&\198ZS)\US\SOH\216\a\208~\130\248\223\238}2\a\DEL\DLE\SYN\179~\STX\136\177L\209\242<\128\ETX\231\222?\229\200!\246\STX&\157\179\176\206@\250+w\254\246\206\&5\139P\188Od<oA\NAK\158\a\216\239#[\DC4yHV\213i\150\223UW\DC1\250Wv^\SI\134\ENQ\DC1\192\187T\250;\255\SUB\EOT\149V\137HO\150w\222\131\185hg%\132\130*\173\148\n\224\138\166_\245\DC3O\139\131i\229r\188\243\175\161\181\EOT\249\175x\133\137/\143\132\185\191l^\160\214>\ETB\236\188\222\237\130\&12`]0\204S\156\130uV\232ku\231\245\144\236\148\193(Y\t\233)\\\\\244\t\STX/\132\233Z\SI\240\134=\\\134\228\ACK#\135f\241Q+\234\244\173\254\206{=\SYN\SI\253@\STX\197\161g1<\255g\169\&1\250\140\SOH\176\156\r\DC1OW\ETX\186@\CANq\150\252^l\129\205c!\EOTT\v\247\208\192\"\178\240\r\175\128\173\228\205\184\184\185\237\200\ETXf\202\DC1\156\152\223\SI\EOT\191\244\134Xv\183S\220\225\238\168\144'Z\EM\rU\143T\142OqI\ENQ\218{\244$6\135\197\139\243\\\RS\188\EOTx(%\201\&1\183\182i\235=\232\185:\134F2\f\252\180f\US\229\135\GS\130\158|\191\DC1}N+k\DC1\244.5/\US\166\240m\149D\244\253\247\249U\246\242\194\165\210\219\227\243'\DC4\ETB\ACKqm+\200\t2\186x\204\141\252'\248\221\229\188z\238\166\r3\213E5\170\205\DC2\232-^!\178\227Ad\DC1\178\ETX\144aP\136\f\ETX\199\198\158\168E\162\131\225\176\b9\EOT\200\229\184\DLE\185\140w\161\141\n\145\253\145c\251i!\210O\GS\155\NAKq\226\150\232\149a!\242\nT~\163_\136\220\232C?+\SYN\DC4CA\201j!2Y\133f\NUL.+\FS\186\148\177\243\178KIbg\161\165\193u<3\\\199+\192U\224\235\DC4\240\133\129\EM.\ft\184.3\195\161+\135\n7\172\192\&7,\224[\142\205p\203\177\SO\215\US\153\225\250#\GS\206O\205p~\170\195\177\138\250\177B\253\174T\240\249J\129\207\ESC}3\220F_\135\139+\232\136\vt$\171f\184d\181\165\171\142\194EU\249\142r\225\240\DLE\194\218\197\231s0R\DEL\216gr\132W\a\193\226\228Hm\134\206\v\219\133;2\202\SI\129*w\206\202\183\DC3}z\245\208\242\187\238\DC1\245}\198#8<\160\238>\162\188\194\248\FS\DELj\DC1RN\159\154\195\229\SI|\236\240\&9\155`\197\237\178G\230\143\136\219\184\&1\132\&8\232\EOT\232\145a\148\248\164\EOT\189\165$\n\128\196\SYN\250\191,\RS=\209l\SO\175\RS\SOHt\188\RS\167\139wR\178\180=\SUB\234W\132\154.iJ\232F\165\255\v>MlqP\196\NUL\NUL"),("slidy/styles/slidy.css","/* slidy.css\n\n   Copyright (c) 2005-2010 W3C (MIT, ERCIM, Keio), All Rights Reserved.\n   W3C liability, trademark, document use and software licensing\n   rules apply, see:\n\n   http://www.w3.org/Consortium/Legal/copyright-documents\n   http://www.w3.org/Consortium/Legal/copyright-software\n*/\nbody\n{\n  margin: 0 0 0 0;\n  padding: 0 0 0 0;\n  width: 100%;\n  height: 100%;\n  color: black;\n  background-color: white;\n  font-family: \"Gill Sans MT\", \"Gill Sans\", GillSans, sans-serif;\n  font-size: 14pt;\n}\n\ndiv.toolbar {\n  position: fixed; z-index: 200;\n  top: auto; bottom: 0; left: 0; right: 0;\n  height: 1.2em; text-align: right;\n  padding-left: 1em;\n  padding-right: 1em; \n  font-size: 60%;\n  color: red;\n  background-color: rgb(240,240,240);\n  border-top: solid 1px rgb(180,180,180);\n}\n\ndiv.toolbar span.copyright {\n  color: black;\n  margin-left: 0.5em;\n}\n\ndiv.initial_prompt {\n  position: absolute;\n  z-index: 1000;\n  bottom: 1.2em;\n  width: 100%;\n  background-color: rgb(200,200,200);\n  opacity: 0.35;\n  background-color: rgb(200,200,200, 0.35);\n  cursor: pointer;\n}\n\ndiv.initial_prompt p.help {\n  text-align: center;\n}\n\ndiv.initial_prompt p.close {\n  text-align: right;\n  font-style: italic;\n}\n\ndiv.slidy_toc {\n  position: absolute;\n  z-index: 300;\n  width: 60%;\n  max-width: 30em;\n  height: 30em;\n  overflow: auto;\n  top: auto;\n  right: auto;\n  left: 4em;\n  bottom: 4em;\n  padding: 1em;\n  background: rgb(240,240,240);\n  border-style: solid;\n  border-width: 2px;\n  font-size: 60%;\n}\n\ndiv.slidy_toc .toc_heading {\n  text-align: center;\n  width: 100%;\n  margin: 0;\n  margin-bottom: 1em;\n  border-bottom-style: solid;\n  border-bottom-color: rgb(180,180,180);\n  border-bottom-width: 1px;\n}\n\ndiv.slide {\n  z-index: 20;\n  margin: 0 0 0 0;\n  padding-top: 0;\n  padding-bottom: 0;\n  padding-left: 20px;\n  padding-right: 20px;\n  border-width: 0;\n  clear: both;\n  top: 0;\n  bottom: 0;\n  left: 0;\n  right: 0;\n  line-height: 120%;\n  background-color: transparent;\n}\n\ndiv.background {\n  display: none;\n}\n\ndiv.handout {\n  margin-left: 20px;\n  margin-right: 20px;\n}\n\ndiv.slide.titlepage {\n  text-align: center;\n}\n\ndiv.slide.titlepage h1 {\n  padding-top: 10%;\n  margin-right: 0;\n}\n\ndiv.slide h1 {\n  padding-left: 0;\n  padding-right: 20pt;\n  padding-top: 4pt;\n  padding-bottom: 4pt;\n  margin-top: 0;\n  margin-left: 0;\n  margin-right: 60pt;\n  margin-bottom: 0.5em;\n  display: block; \n  font-size: 160%;\n  line-height: 1.2em;\n  background: transparent;\n}\n\ndiv.toc {\n  position: absolute;\n  top: auto;\n  bottom: 4em;\n  left: 4em;\n  right: auto;\n  width: 60%;\n  max-width: 30em;\n  height: 30em;\n  border: solid thin black;\n  padding: 1em;\n  background: rgb(240,240,240);\n  color: black;\n  z-index: 300;\n  overflow: auto;\n  display: block;\n  visibility: visible;\n}\n\ndiv.toc-heading {\n  width: 100%;\n  border-bottom: solid 1px rgb(180,180,180);\n  margin-bottom: 1em;\n  text-align: center;\n}\n\nimg {\n  image-rendering: optimize-quality;\n}\n\npre {\n font-size: 80%;\n font-weight: bold;\n line-height: 120%;\n padding-top: 0.2em;\n padding-bottom: 0.2em;\n padding-left: 1em;\n padding-right: 1em;\n border-style: solid;\n border-left-width: 1em;\n border-top-width: thin;\n border-right-width: thin;\n border-bottom-width: thin;\n border-color: #95ABD0;\n color: #00428C;\n background-color: #E4E5E7;\n}\n\nli pre { margin-left: 0; }\n\nblockquote { font-style: italic }\n\nimg { background-color: transparent }\n\np.copyright { font-size: smaller }\n\n.center { text-align: center }\n.footnote { font-size: smaller; margin-left: 2em; }\n\na img { border-width: 0; border-style: none }\n\na:visited { color: navy }\na:link { color: navy }\na:hover { color: red; text-decoration: underline }\na:active { color: red; text-decoration: underline }\n\na {text-decoration: none}\n.navbar a:link {color: white}\n.navbar a:visited {color: yellow}\n.navbar a:active {color: red}\n.navbar a:hover {color: red}\n\nul { list-style-type: square; }\nul ul { list-style-type: disc; }\nul ul ul { list-style-type: circle; }\nul ul ul ul { list-style-type: disc; }\nli { margin-left: 0.5em; margin-top: 0.5em; }\nli li { font-size: 85%; font-style: italic }\nli li li { font-size: 85%; font-style: normal }\n\ndiv dt\n{\n  margin-left: 0;\n  margin-top: 1em;\n  margin-bottom: 0.5em;\n  font-weight: bold;\n}\ndiv dd\n{\n  margin-left: 2em;\n  margin-bottom: 0.5em;\n}\n\n\np,pre,ul,ol,blockquote,h2,h3,h4,h5,h6,dl,table {\n  margin-left: 1em;\n  margin-right: 1em;\n}\n\np.subhead { font-weight: bold; margin-top: 2em; }\n\n.smaller { font-size: smaller }\n.bigger { font-size: 130% }\n\ntd,th { padding: 0.2em }\n\nul {\n  margin: 0.5em 1.5em 0.5em 1.5em;\n  padding: 0;\n}\n\nol {\n  margin: 0.5em 1.5em 0.5em 1.5em;\n  padding: 0;\n}\n\nul { list-style-type: square; }\nul ul { list-style-type: disc; }\nul ul ul { list-style-type: circle; }\nul ul ul ul { list-style-type: disc; }\n\nul li { \n  list-style: square;\n  margin: 0.1em 0em 0.6em 0;\n  padding: 0 0 0 0;\n  line-height: 140%;\n}\n\nol li { \n  margin: 0.1em 0em 0.6em 1.5em;\n  padding: 0 0 0 0px;\n  line-height: 140%;\n  list-style-type: decimal;\n}\n\nli ul li { \n  font-size: 85%; \n  font-style: italic;\n  list-style-type: disc;\n  background: transparent;\n  padding: 0 0 0 0;\n}\nli li ul li { \n  font-size: 85%; \n  font-style: normal;\n  list-style-type: circle;\n  background: transparent;\n  padding: 0 0 0 0;\n}\nli li li ul li {\n  list-style-type: disc;\n  background: transparent;\n  padding: 0 0 0 0;\n}\n\nli ol li {\n  list-style-type: decimal;\n}\n\n\nli li ol li {\n  list-style-type: decimal;\n}\n\n/*\n setting class=\"outline on ol or ul makes it behave as an\n ouline list where blocklevel content in li elements is\n hidden by default and can be expanded or collapsed with\n mouse click. Set class=\"expand\" on li to override default\n*/\n\nol.outline li:hover { cursor: pointer }\nol.outline li.nofold:hover { cursor: default }\n\nul.outline li:hover { cursor: pointer }\nul.outline li.nofold:hover { cursor: default }\n\nol.outline { list-style:decimal; }\nol.outline ol { list-style-type:lower-alpha }\n\nol.outline li.nofold {\n  padding: 0 0 0 20px;\n  background: transparent url(../graphics/nofold-dim.gif) no-repeat 0px 0.5em;\n}\nol.outline li.unfolded {\n  padding: 0 0 0 20px;\n  background: transparent url(../graphics/fold-dim.gif) no-repeat 0px 0.5em;\n}\nol.outline li.folded {\n  padding: 0 0 0 20px;\n  background: transparent url(../graphics/unfold-dim.gif) no-repeat 0px 0.5em;\n}\nol.outline li.unfolded:hover {\n  padding: 0 0 0 20px;\n  background: transparent url(../graphics/fold.gif) no-repeat 0px 0.5em;\n}\nol.outline li.folded:hover {\n  padding: 0 0 0 20px;\n  background: transparent url(../graphics/unfold.gif) no-repeat 0px 0.5em;\n}\n\nul.outline li.nofold {\n  padding: 0 0 0 20px;\n  background: transparent url(../graphics/nofold-dim.gif) no-repeat 0px 0.5em;\n}\nul.outline li.unfolded {\n  padding: 0 0 0 20px;\n  background: transparent url(../graphics/fold-dim.gif) no-repeat 0px 0.5em;\n}\nul.outline li.folded {\n  padding: 0 0 0 20px;\n  background: transparent url(../graphics/unfold-dim.gif) no-repeat 0px 0.5em;\n}\nul.outline li.unfolded:hover {\n  padding: 0 0 0 20px;\n  background: transparent url(../graphics/fold.gif) no-repeat 0px 0.5em;\n}\nul.outline li.folded:hover {\n  padding: 0 0 0 20px;\n  background: transparent url(../graphics/unfold.gif) no-repeat 0px 0.5em;\n}\n\n/* for slides with class \"title\" in table of contents */\na.titleslide { font-weight: bold; font-style: italic }\n\n/*\n hide images for work around for save as bug\n where browsers fail to save images used by CSS\n*/\nimg.hidden { display: none; visibility: hidden }\ndiv.initial_prompt { display: none; visibility: hidden }\n\n  div.slide {\n     visibility: visible;\n     position: inherit;\n  }\n  div.handout {\n     border-top-style: solid;\n     border-top-width: thin;\n     border-top-color: black;\n  }\n\n@media screen {\n  .hidden { display: none; visibility: visible }\n\n  div.slide.hidden { display: block; visibility: visible }\n  div.handout.hidden { display: block; visibility: visible }\n  div.background { display: none; visibility: hidden }\n  body.single_slide div.initial_prompt { display: block; visibility: visible }\n  body.single_slide div.background { display: block; visibility: visible }\n  body.single_slide div.background.hidden { display: none; visibility: hidden }\n  body.single_slide .invisible { visibility: hidden }\n  body.single_slide .hidden { display: none; visibility: hidden }\n  body.single_slide div.slide { position: absolute }\n  body.single_slide div.handout { display: none; visibility: hidden }\n}\n\n@media print {\n  .hidden { display: block; visibility: visible }\n\n  div.slide pre { font-size: 60%; padding-left: 0.5em; }\n  div.toolbar { display: none; visibility: hidden; }\n  div.slidy_toc { display: none; visibility: hidden; }\n  div.background { display: none; visibility: hidden; }\n  div.slide { page-break-before: always }\n  /* :first-child isn't reliable for print media */\n  div.slide.first-slide { page-break-before: avoid }\n}\n\n"),("templates/default.asciidoc","$if(titleblock)$\n$title$\n$for(author)$\n:author: $author$\n$endfor$\n$if(date)$\n:date: $date$\n$endif$\n$if(toc)$\n:toc:\n$endif$\n\n$endif$\n$for(header-includes)$\n$header-includes$\n\n$endfor$\n$for(include-before)$\n$include-before$\n\n$endfor$\n$body$\n$for(include-after)$\n\n$include-after$\n$endfor$\n"),("templates/default.beamer","\\documentclass[$if(fontsize)$$fontsize$,$endif$$if(handout)$handout,$endif$$if(beamer)$ignorenonframetext,$endif$]{$documentclass$}\n$if(theme)$\n\\usetheme{$theme$}\n$endif$\n$if(colortheme)$\n\\usecolortheme{$colortheme$}\n$endif$\n\\usepackage{amssymb,amsmath}\n\\usepackage{ifxetex,ifluatex}\n\\usepackage{fixltx2e} % provides \\textsubscript\n\\ifxetex\n  \\usepackage{fontspec,xltxtra,xunicode}\n  \\defaultfontfeatures{Mapping=tex-text,Scale=MatchLowercase}\n\\else\n  \\ifluatex\n    \\usepackage{fontspec}\n    \\defaultfontfeatures{Mapping=tex-text,Scale=MatchLowercase}\n  \\else\n    \\usepackage[utf8]{inputenc}\n  \\fi\n\\fi\n$if(natbib)$\n\\usepackage{natbib}\n\\bibliographystyle{plainnat}\n$endif$\n$if(biblatex)$\n\\usepackage{biblatex}\n$if(biblio-files)$\n\\bibliography{$biblio-files$}\n$endif$\n$endif$\n$if(listings)$\n\\usepackage{listings}\n$endif$\n$if(lhs)$\n\\lstnewenvironment{code}{\\lstset{language=Haskell,basicstyle=\\small\\ttfamily}}{}\n$endif$\n$if(highlighting-macros)$\n$highlighting-macros$\n$endif$\n$if(verbatim-in-note)$\n\\usepackage{fancyvrb}\n$endif$\n$if(tables)$\n\\usepackage{longtable}\n% These lines are needed to make table captions work with longtable:\n\\makeatletter\n\\def\\fnum@table{\\tablename~\\thetable}\n\\makeatother\n$endif$\n$if(url)$\n\\usepackage{url}\n$endif$\n$if(graphics)$\n\\usepackage{graphicx}\n\\makeatletter\n\\def\\ScaleIfNeeded{%\n  \\ifdim\\Gin@nat@width>\\linewidth\n    \\linewidth\n  \\else\n    \\Gin@nat@width\n  \\fi\n}\n\\makeatother\n\\let\\Oldincludegraphics\\includegraphics\n\\renewcommand{\\includegraphics}[2][]{\\Oldincludegraphics[width=\\ScaleIfNeeded]{#2}}\n$endif$\n\n% Comment these out if you don't want a slide with just the\n% part/section/subsection/subsubsection title:\n\\AtBeginPart{\n  \\let\\insertpartnumber\\relax\n  \\let\\partname\\relax\n  \\frame{\\partpage}\n}\n\\AtBeginSection{\n  \\let\\insertsectionnumber\\relax\n  \\let\\sectionname\\relax\n  \\frame{\\sectionpage}\n}\n\\AtBeginSubsection{\n  \\let\\insertsubsectionnumber\\relax\n  \\let\\subsectionname\\relax\n  \\frame{\\subsectionpage}\n}\n\n$if(strikeout)$\n\\usepackage[normalem]{ulem}\n% avoid problems with \\sout in headers with hyperref:\n\\pdfstringdefDisableCommands{\\renewcommand{\\sout}{}}\n$endif$\n\\setlength{\\parindent}{0pt}\n\\setlength{\\parskip}{6pt plus 2pt minus 1pt}\n\\setlength{\\emergencystretch}{3em}  % prevent overfull lines\n$if(numbersections)$\n$else$\n\\setcounter{secnumdepth}{0}\n$endif$\n$if(verbatim-in-note)$\n\\VerbatimFootnotes % allows verbatim text in footnotes\n$endif$\n$if(lang)$\n\\usepackage[$lang$]{babel}\n$endif$\n$for(header-includes)$\n$header-includes$\n$endfor$\n\n$if(title)$\n\\title{$title$}\n$endif$\n$if(author)$\n\\author{$for(author)$$author$$sep$ \\and $endfor$}\n$endif$\n$if(date)$\n\\date{$date$}\n$endif$\n\n\\begin{document}\n$if(title)$\n\\frame{\\titlepage}\n$endif$\n\n$for(include-before)$\n$include-before$\n\n$endfor$\n$if(toc)$\n\\begin{frame}\n\\tableofcontents[hideallsubsections]\n\\end{frame}\n\n$endif$\n$body$\n\n$if(natbib)$\n$if(biblio-files)$\n$if(biblio-title)$\n$if(book-class)$\n\\renewcommand\\bibname{$biblio-title$}\n$else$\n\\renewcommand\\refname{$biblio-title$}\n$endif$\n$endif$\n\\bibliography{$biblio-files$}\n\n$endif$\n$endif$\n$if(biblatex)$\n\\printbibliography$if(biblio-title)$[title=$biblio-title$]$endif$\n\n$endif$\n$for(include-after)$\n$include-after$\n\n$endfor$\n\\end{document}\n"),("templates/default.context","\\startmode[*mkii]\n  \\enableregime[utf-8]  \n  \\setupcolors[state=start]\n\\stopmode\n$if(mainlang)$\n\\mainlanguage[$mainlang$]\n$endif$\n\n% Enable hyperlinks\n\\setupinteraction[state=start, color=middleblue]\n\n\\setuppapersize [$if(papersize)$$papersize$$else$letter$endif$][$if(papersize)$$papersize$$else$letter$endif$]\n\\setuplayout    [width=middle,  backspace=1.5in, cutspace=1.5in,\n                 height=middle, topspace=0.75in, bottomspace=0.75in]\n\n\\setuppagenumbering[location={footer,center}]\n\n\\setupbodyfont[11pt]\n\n\\setupwhitespace[medium]\n\n\\setuphead[chapter]      [style=\\tfd]\n\\setuphead[section]      [style=\\tfc]\n\\setuphead[subsection]   [style=\\tfb]\n\\setuphead[subsubsection][style=\\bf]\n\n$if(number-sections)$\n$else$\n\\setuphead[chapter, section, subsection, subsubsection][number=no]\n$endif$\n\n\\definedescription\n  [description]\n  [headstyle=bold, style=normal, location=hanging, width=broad, margin=1cm]\n\n\\setupitemize[autointro]    % prevent orphan list intro\n\\setupitemize[indentnext=no]\n\n\\setupthinrules[width=15em] % width of horizontal rules\n\n\\setupdelimitedtext\n  [blockquote]\n  [before={\\blank[medium]},\n   after={\\blank[medium]},\n   indentnext=no,\n  ]\n\n$if(toc)$\n\\setupcombinedlist[content][list={$placelist$}]\n\n$endif$\n$for(header-includes)$\n$header-includes$\n$endfor$\n\n\\starttext\n$if(title)$\n\\startalignment[center]\n  \\blank[2*big]\n  {\\tfd $title$}\n$if(author)$\n  \\blank[3*medium]\n  {\\tfa $for(author)$$author$$sep$\\crlf $endfor$}\n$endif$\n$if(date)$\n  \\blank[2*medium]\n  {\\tfa $date$}\n$endif$\n  \\blank[3*medium]\n\\stopalignment\n$endif$\n$for(include-before)$\n$include-before$\n$endfor$\n$if(toc)$\n\\placecontent\n$endif$\n\n$body$\n\n$for(include-after)$\n$include-after$\n$endfor$\n\\stoptext\n"),("templates/default.docbook","<?xml version=\"1.0\" encoding=\"utf-8\" ?>\n$if(mathml)$\n<!DOCTYPE article PUBLIC \"-//OASIS//DTD DocBook EBNF Module V1.1CR1//EN\"\n                  \"http://www.oasis-open.org/docbook/xml/mathml/1.1CR1/dbmathml.dtd\">\n$else$\n<!DOCTYPE article PUBLIC \"-//OASIS//DTD DocBook XML V4.4//EN\"\n                  \"http://www.oasis-open.org/docbook/xml/4.4/docbookx.dtd\">\n$endif$\n<article>\n  <articleinfo>\n    <title>$title$</title>\n$for(author)$\n    <author>\n      $author$\n    </author>\n$endfor$\n$if(date)$\n    <date>$date$</date>\n$endif$\n  </articleinfo>\n$for(include-before)$\n$include-before$\n$endfor$\n$body$\n$for(include-after)$\n$include-after$\n$endfor$\n</article>\n"),("templates/default.dzslides","<!DOCTYPE html>\n<head>\n<meta charset=\"utf-8\">\n$for(author-meta)$\n  <meta name=\"author\" content=\"$author-meta$\" />\n$endfor$\n$if(date-meta)$\n  <meta name=\"dcterms.date\" content=\"$date-meta$\" />\n$endif$\n  <title>$if(title-prefix)$$title-prefix$ - $endif$$pagetitle$</title>\n  <style type=\"text/css\">code{white-space: pre;}</style>\n$if(highlighting-css)$\n  <style type=\"text/css\">\n$highlighting-css$\n  </style>\n$endif$\n$if(css)$\n$for(css)$\n  <link rel=\"stylesheet\" href=\"$css$\" $if(html5)$$else$type=\"text/css\" $endif$/>\n$endfor$\n$else$\n<style>\n  html { background-color: black; }\n  body { background-color: white; border-radius: 12px}\n  /* A section is a slide. It's size is 800x600, and this will never change */\n  section {\n      font-family: Arial, serif;\n      font-size: 20pt;\n    }\n  address, blockquote, dl, fieldset, form, h1, h2, h3, h4, h5, h6, hr, ol, p, pre, table, ul, dl { padding: 10px 20px 10px 20px; }\n  h1, h2, h3 {\n    text-align: center;\n    margin: 10pt 10pt 20pt 10pt;\n  }\n  ul, ol {\n    margin: 10px 10px 10px 50px;\n  }\n  section.titleslide h1 { margin-top: 200px; }\n  h1.title { margin-top: 150px; }\n  h1 { font-size: 180%; }\n  h2 { font-size: 120%; }\n  h3 { font-size: 100%; }\n  q { quotes: \"\226\128\156\" \"\226\128\157\" \"\226\128\152\" \"\226\128\153\"; }\n  blockquote { font-style: italic }\n  /* Figures are displayed full-page, with the caption on\n     top of the image/video */\n  figure {\n    background-color: black;\n  }\n  figcaption {\n    margin: 70px;\n  }\n  footer {\n    position: absolute;\n    bottom: 0;\n    width: 100%;\n    padding: 40px;\n    text-align: right;\n    background-color: #F3F4F8;\n    border-top: 1px solid #CCC;\n  }\n\n  /* Transition effect */\n  /* Feel free to change the transition effect for original\n     animations. See here:\n     https://developer.mozilla.org/en/CSS/CSS_transitions\n     How to use CSS3 Transitions: */\n  section {\n      -moz-transition: left 400ms linear 0s;\n      -webkit-transition: left 400ms linear 0s;\n      -ms-transition: left 400ms linear 0s;\n      transition: left 400ms linear 0s;\n  }\n\n  /* Before */\n  section { left: -150%; }\n  /* Now */\n  section[aria-selected] { left: 0; }\n  /* After */\n  section[aria-selected] ~ section { left: +150%; }\n\n  /* Incremental elements */\n\n  /* By default, visible */\n  .incremental > * { opacity: 1; }\n\n  /* The current item */\n  .incremental > *[aria-selected] { color: red; opacity: 1; }\n\n  /* The items to-be-selected */\n  .incremental > *[aria-selected] ~ * { opacity: 0.2; }\n</style>\n$endif$\n$if(math)$\n  $math$\n$endif$\n$for(header-includes)$\n  $header-includes$\n$endfor$\n</head>\n<body>\n$if(title)$\n<section>\n  <h1 class=\"title\">$title$</h1>\n$for(author)$\n  <h2 class=\"author\">$author$</h2>\n$endfor$\n  <h3 class=\"date\">$date$</h3>\n</section>\n$endif$\n$for(include-before)$\n$include-before$\n$endfor$\n$body$\n$for(include-after)$\n$include-after$\n$endfor$\n$dzslides-core$\n</body>\n</html>\n"),("templates/default.epub","<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.1//EN\" \"http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\"$if(lang)$ xml:lang=\"$lang$\"$endif$>\n<head>\n  <meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\" />\n  <meta http-equiv=\"Content-Style-Type\" content=\"text/css\" />\n  <meta name=\"generator\" content=\"pandoc\" />\n  <title>$pagetitle$</title>\n$if(highlighting-css)$\n  <style type=\"text/css\">\n$highlighting-css$\n  </style>\n$endif$\n$for(css)$\n  <link rel=\"stylesheet\" type=\"text/css\" href=\"$css$\" />\n$endfor$\n</head>\n<body>\n$if(titlepage)$\n  <h1 class=\"title\">$title$</h1>\n$for(author)$\n  <h2 class=\"author\">$author$</h2>\n$endfor$\n$if(date)$\n  <h3 class=\"date\">$date$</h3>\n$endif$\n$else$\n$body$\n$endif$\n</body>\n</html>\n\n"),("templates/default.epub3","<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE html>\n<html xmlns=\"http://www.w3.org/1999/xhtml\" xmlns:epub=\"http://www.idpf.org/2007/ops\"$if(lang)$ xml:lang=\"$lang$\"$endif$>\n<head>\n  <meta charset=\"utf-8\" />\n  <meta name=\"generator\" content=\"pandoc\" />\n  <title>$pagetitle$</title>\n$if(quotes)$\n  <style type=\"text/css\">\n    q { quotes: \"\226\128\156\" \"\226\128\157\" \"\226\128\152\" \"\226\128\153\"; }\n  </style>\n$endif$\n$if(highlighting-css)$\n  <style type=\"text/css\">\n$highlighting-css$\n  </style>\n$endif$\n$for(css)$\n  <link rel=\"stylesheet\" href=\"$css$\" />\n$endfor$\n</head>\n<body>\n$if(titlepage)$\n  <h1 class=\"title\">$title$</h1>\n$for(author)$\n  <h2 class=\"author\">$author$</h2>\n$endfor$\n$if(date)$\n  <h3 class=\"date\">$date$</h3>\n$endif$\n$else$\n$body$\n$endif$\n</body>\n</html>\n\n"),("templates/default.html","<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\"$if(lang)$ lang=\"$lang$\" xml:lang=\"$lang$\"$endif$>\n<head>\n  <meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\" />\n  <meta http-equiv=\"Content-Style-Type\" content=\"text/css\" />\n  <meta name=\"generator\" content=\"pandoc\" />\n$for(author-meta)$\n  <meta name=\"author\" content=\"$author-meta$\" />\n$endfor$\n$if(date-meta)$\n  <meta name=\"date\" content=\"$date-meta$\" />\n$endif$\n  <title>$if(title-prefix)$$title-prefix$ - $endif$$pagetitle$</title>\n  <style type=\"text/css\">code{white-space: pre;}</style>\n$if(quotes)$\n  <style type=\"text/css\">q { quotes: \"\226\128\156\" \"\226\128\157\" \"\226\128\152\" \"\226\128\153\"; }</style>\n$endif$\n$if(highlighting-css)$\n  <style type=\"text/css\">\n$highlighting-css$\n  </style>\n$endif$\n$for(css)$\n  <link rel=\"stylesheet\" href=\"$css$\" $if(html5)$$else$type=\"text/css\" $endif$/>\n$endfor$\n$if(math)$\n  $math$\n$endif$\n$for(header-includes)$\n  $header-includes$\n$endfor$\n</head>\n<body>\n$for(include-before)$\n$include-before$\n$endfor$\n$if(title)$\n<div id=\"$idprefix$header\">\n<h1 class=\"title\">$title$</h1>\n$for(author)$\n<h2 class=\"author\">$author$</h2>\n$endfor$\n$if(date)$\n<h3 class=\"date\">$date$</h3>\n$endif$\n</div>\n$endif$\n$if(toc)$\n<div id=\"$idprefix$TOC\">\n$toc$\n</div>\n$endif$\n$body$\n$for(include-after)$\n$include-after$\n$endfor$\n</body>\n</html>\n"),("templates/default.html5","<!DOCTYPE html>\n<html$if(lang)$ lang=\"$lang$\"$endif$>\n<head>\n  <meta charset=\"utf-8\">\n  <meta name=\"generator\" content=\"pandoc\">\n$for(author-meta)$\n  <meta name=\"author\" content=\"$author-meta$\">\n$endfor$\n$if(date-meta)$\n  <meta name=\"dcterms.date\" content=\"$date-meta$\">\n$endif$\n  <title>$if(title-prefix)$$title-prefix$ - $endif$$pagetitle$</title>\n  <style type=\"text/css\">code{white-space: pre;}</style>\n  <!--[if lt IE 9]>\n    <script src=\"http://html5shim.googlecode.com/svn/trunk/html5.js\"></script>\n  <![endif]-->\n$if(quotes)$\n  <style type=\"text/css\">q { quotes: \"\226\128\156\" \"\226\128\157\" \"\226\128\152\" \"\226\128\153\"; }</style>\n$endif$\n$if(highlighting-css)$\n  <style type=\"text/css\">\n$highlighting-css$\n  </style>\n$endif$\n$for(css)$\n  <link rel=\"stylesheet\" href=\"$css$\">\n$endfor$\n$if(math)$\n  $math$\n$endif$\n$for(header-includes)$\n  $header-includes$\n$endfor$\n</head>\n<body>\n$for(include-before)$\n$include-before$\n$endfor$\n$if(title)$\n<header>\n<h1 class=\"title\">$title$</h1>\n$for(author)$\n<h2 class=\"author\">$author$</h2>\n$endfor$\n$if(date)$\n<h3 class=\"date\">$date$</h3>\n$endif$\n</header>\n$endif$\n$if(toc)$\n<nav id=\"$idprefix$TOC\">\n$toc$\n</nav>\n$endif$\n$body$\n$for(include-after)$\n$include-after$\n$endfor$\n</body>\n</html>\n"),("templates/default.latex","\\documentclass[$if(fontsize)$$fontsize$,$endif$$if(lang)$$lang$,$endif$$if(papersize)$$papersize$,$endif$]{$documentclass$}\n\\usepackage[T1]{fontenc}\n\\usepackage{lmodern}\n\\usepackage{amssymb,amsmath}\n\\usepackage{ifxetex,ifluatex}\n\\usepackage{fixltx2e} % provides \\textsubscript\n% use upquote if available, for straight quotes in verbatim environments\n\\IfFileExists{upquote.sty}{\\usepackage{upquote}}{}\n\\ifnum 0\\ifxetex 1\\fi\\ifluatex 1\\fi=0 % if pdftex\n  \\usepackage[utf8]{inputenc}\n$if(euro)$\n  \\usepackage{eurosym}\n$endif$\n\\else % if luatex or xelatex\n  \\usepackage{fontspec}\n  \\ifxetex\n    \\usepackage{xltxtra,xunicode}\n  \\fi\n  \\defaultfontfeatures{Mapping=tex-text,Scale=MatchLowercase}\n  \\newcommand{\\euro}{\226\130\172}\n$if(mainfont)$\n    \\setmainfont{$mainfont$}\n$endif$\n$if(sansfont)$\n    \\setsansfont{$sansfont$}\n$endif$\n$if(monofont)$\n    \\setmonofont{$monofont$}\n$endif$\n$if(mathfont)$\n    \\setmathfont{$mathfont$}\n$endif$\n\\fi\n% use microtype if available\n\\IfFileExists{microtype.sty}{\\usepackage{microtype}}{}\n$if(geometry)$\n\\usepackage[$for(geometry)$$geometry$$sep$,$endfor$]{geometry}\n$endif$\n$if(natbib)$\n\\usepackage{natbib}\n\\bibliographystyle{plainnat}\n$endif$\n$if(biblatex)$\n\\usepackage{biblatex}\n$if(biblio-files)$\n\\bibliography{$biblio-files$}\n$endif$\n$endif$\n$if(listings)$\n\\usepackage{listings}\n$endif$\n$if(lhs)$\n\\lstnewenvironment{code}{\\lstset{language=Haskell,basicstyle=\\small\\ttfamily}}{}\n$endif$\n$if(highlighting-macros)$\n$highlighting-macros$\n$endif$\n$if(verbatim-in-note)$\n\\usepackage{fancyvrb}\n$endif$\n$if(tables)$\n\\usepackage{longtable}\n$endif$\n$if(graphics)$\n\\usepackage{graphicx}\n% We will generate all images so they have a width \\maxwidth. This means\n% that they will get their normal width if they fit onto the page, but\n% are scaled down if they would overflow the margins.\n\\makeatletter\n\\def\\maxwidth{\\ifdim\\Gin@nat@width>\\linewidth\\linewidth\n\\else\\Gin@nat@width\\fi}\n\\makeatother\n\\let\\Oldincludegraphics\\includegraphics\n\\renewcommand{\\includegraphics}[1]{\\Oldincludegraphics[width=\\maxwidth]{#1}}\n$endif$\n\\ifxetex\n  \\usepackage[setpagesize=false, % page size defined by xetex\n              unicode=false, % unicode breaks when used with xetex\n              xetex]{hyperref}\n\\else\n  \\usepackage[unicode=true]{hyperref}\n\\fi\n\\hypersetup{breaklinks=true,\n            bookmarks=true,\n            pdfauthor={$author-meta$},\n            pdftitle={$title-meta$},\n            colorlinks=true,\n            urlcolor=$if(urlcolor)$$urlcolor$$else$blue$endif$,\n            linkcolor=$if(linkcolor)$$linkcolor$$else$magenta$endif$,\n            pdfborder={0 0 0}}\n\\urlstyle{same}  % don't use monospace font for urls\n$if(links-as-notes)$\n% Make links footnotes instead of hotlinks:\n\\renewcommand{\\href}[2]{#2\\footnote{\\url{#1}}}\n$endif$\n$if(strikeout)$\n\\usepackage[normalem]{ulem}\n% avoid problems with \\sout in headers with hyperref:\n\\pdfstringdefDisableCommands{\\renewcommand{\\sout}{}}\n$endif$\n\\setlength{\\parindent}{0pt}\n\\setlength{\\parskip}{6pt plus 2pt minus 1pt}\n\\setlength{\\emergencystretch}{3em}  % prevent overfull lines\n$if(numbersections)$\n\\setcounter{secnumdepth}{5}\n$else$\n\\setcounter{secnumdepth}{0}\n$endif$\n$if(verbatim-in-note)$\n\\VerbatimFootnotes % allows verbatim text in footnotes\n$endif$\n$if(lang)$\n\\ifxetex\n  \\usepackage{polyglossia}\n  \\setmainlanguage{$mainlang$}\n\\else\n  \\usepackage[$lang$]{babel}\n\\fi\n$endif$\n$for(header-includes)$\n$header-includes$\n$endfor$\n\n$if(title)$\n\\title{$title$}\n$endif$\n\\author{$for(author)$$author$$sep$ \\and $endfor$}\n\\date{$date$}\n\n\\begin{document}\n$if(title)$\n\\maketitle\n$endif$\n\n$for(include-before)$\n$include-before$\n\n$endfor$\n$if(toc)$\n{\n\\hypersetup{linkcolor=black}\n\\setcounter{tocdepth}{$toc-depth$}\n\\tableofcontents\n}\n$endif$\n$body$\n\n$if(natbib)$\n$if(biblio-files)$\n$if(biblio-title)$\n$if(book-class)$\n\\renewcommand\\bibname{$biblio-title$}\n$else$\n\\renewcommand\\refname{$biblio-title$}\n$endif$\n$endif$\n\\bibliography{$biblio-files$}\n\n$endif$\n$endif$\n$if(biblatex)$\n\\printbibliography$if(biblio-title)$[title=$biblio-title$]$endif$\n\n$endif$\n$for(include-after)$\n$include-after$\n\n$endfor$\n\\end{document}\n"),("templates/default.man","$if(has-tables)$\n.\\\"t\n$endif$\n.TH $title$ $section$ \"$date$\" $description$\n$for(header-includes)$\n$header-includes$\n$endfor$\n$for(include-before)$\n$include-before$\n$endfor$\n$body$\n$for(include-after)$\n$include-after$\n$endfor$\n$if(author)$\n.SH AUTHORS\n$for(author)$$author$$sep$; $endfor$.\n$endif$\n"),("templates/default.markdown","$if(titleblock)$\n$titleblock$\n\n$endif$\n$for(header-includes)$\n$header-includes$\n\n$endfor$\n$for(include-before)$\n$include-before$\n\n$endfor$\n$if(toc)$\n$toc$\n\n$endif$\n$body$\n$for(include-after)$\n\n$include-after$\n$endfor$\n"),("templates/default.mediawiki","$for(include-before)$\n$include-before$\n\n$endfor$\n$if(toc)$\n__TOC__\n\n$endif$\n$body$\n$for(include-after)$\n\n$include-after$\n$endfor$\n"),("templates/default.opendocument","<?xml version=\"1.0\" encoding=\"utf-8\" ?>\n<office:document-content xmlns:office=\"urn:oasis:names:tc:opendocument:xmlns:office:1.0\" xmlns:style=\"urn:oasis:names:tc:opendocument:xmlns:style:1.0\" xmlns:text=\"urn:oasis:names:tc:opendocument:xmlns:text:1.0\" xmlns:table=\"urn:oasis:names:tc:opendocument:xmlns:table:1.0\" xmlns:draw=\"urn:oasis:names:tc:opendocument:xmlns:drawing:1.0\" xmlns:fo=\"urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:meta=\"urn:oasis:names:tc:opendocument:xmlns:meta:1.0\" xmlns:number=\"urn:oasis:names:tc:opendocument:xmlns:datastyle:1.0\" xmlns:svg=\"urn:oasis:names:tc:opendocument:xmlns:svg-compatible:1.0\" xmlns:chart=\"urn:oasis:names:tc:opendocument:xmlns:chart:1.0\" xmlns:dr3d=\"urn:oasis:names:tc:opendocument:xmlns:dr3d:1.0\" xmlns:math=\"http://www.w3.org/1998/Math/MathML\" xmlns:form=\"urn:oasis:names:tc:opendocument:xmlns:form:1.0\" xmlns:script=\"urn:oasis:names:tc:opendocument:xmlns:script:1.0\" xmlns:ooo=\"http://openoffice.org/2004/office\" xmlns:ooow=\"http://openoffice.org/2004/writer\" xmlns:oooc=\"http://openoffice.org/2004/calc\" xmlns:dom=\"http://www.w3.org/2001/xml-events\" xmlns:xforms=\"http://www.w3.org/2002/xforms\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" office:version=\"1.0\">\n  $automatic-styles$\n$for(header-includes)$\n  $header-includes$\n$endfor$  \n<office:body>\n<office:text>\n$if(title)$\n<text:h text:style-name=\"Title\">$title$</text:h>\n$endif$\n$for(author)$\n<text:p text:style-name=\"Author\">$author$</text:p>\n$endfor$\n$if(date)$\n<text:p text:style-name=\"Date\">$date$</text:p>\n$endif$\n$for(include-before)$\n$include-before$\n$endfor$\n$body$\n$for(include-after)$\n$include-after$\n$endfor$\n</office:text>\n</office:body>\n</office:document-content>\n"),("templates/default.org","$if(title)$\n$title$\n\n$endif$\n$if(author)$\n#+AUTHOR: $for(author)$$author$$sep$; $endfor$\n$endif$\n$if(date)$\n#+DATE: $date$\n\n$endif$\n$for(header-includes)$\n$header-includes$\n\n$endfor$\n$for(include-before)$\n$include-before$\n\n$endfor$\n$body$\n$for(include-after)$\n\n$include-after$\n$endfor$\n"),("templates/default.plain","$if(titleblock)$\n$titleblock$\n\n$endif$\n$for(header-includes)$\n$header-includes$\n\n$endfor$\n$for(include-before)$\n$include-before$\n\n$endfor$\n$if(toc)$\n$toc$\n\n$endif$\n$body$\n$for(include-after)$\n\n$include-after$\n$endfor$\n"),("templates/default.rst","$if(title)$\n$title$\n\n$endif$\n$for(author)$\n:Author: $author$\n$endfor$\n$if(date)$\n:Date:   $date$\n$endif$\n$if(author)$\n\n$else$\n$if(date)$\n\n$endif$\n$endif$\n$if(math)$\n.. role:: math(raw)\n   :format: html latex\n..\n\n$endif$\n$for(include-before)$\n$include-before$\n\n$endfor$\n$if(toc)$\n.. contents::\n   :depth: $toc-depth$\n..\n\n$endif$\n$for(header-includes)$\n$header-includes$\n\n$endfor$\n$body$\n$for(include-after)$\n\n$include-after$\n$endfor$\n"),("templates/default.rtf","{\\rtf1\\ansi\\deff0{\\fonttbl{\\f0 \\fswiss Helvetica;}{\\f1 Courier;}}\n{\\colortbl;\\red255\\green0\\blue0;\\red0\\green0\\blue255;}\n\\widowctrl\\hyphauto\n$for(header-includes)$\n$header-includes$\n$endfor$\n\n$if(title)$\n{\\pard \\qc \\f0 \\sa180 \\li0 \\fi0 \\b \\fs36 $title$\\par}\n$endif$\n$for(author)$\n{\\pard \\qc \\f0 \\sa180 \\li0 \\fi0  $author$\\par}\n$endfor$\n$if(date)$\n{\\pard \\qc \\f0 \\sa180 \\li0 \\fi0  $date$\\par}\n$endif$\n$if(spacer)$\n{\\pard \\ql \\f0 \\sa180 \\li0 \\fi0 \\par}\n$endif$\n$if(toc)$\n$toc$\n$endif$\n$for(include-before)$\n$include-before$\n$endfor$\n$body$\n$for(include-after)$\n$include-after$\n$endfor$\n}\n"),("templates/default.s5","<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\">\n<head>\n  <meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\" />\n  <meta http-equiv=\"Content-Style-Type\" content=\"text/css\" />\n  <meta name=\"generator\" content=\"pandoc\" />\n$for(author-meta)$\n  <meta name=\"author\" content=\"$author-meta$\" />\n$endfor$\n$if(date-meta)$\n  <meta name=\"date\" content=\"$date-meta$\" />\n$endif$\n  <title>$if(title-prefix)$$title-prefix$ - $endif$$pagetitle$</title>\n  <style type=\"text/css\">code{white-space: pre;}</style>\n  <!-- configuration parameters -->\n  <meta name=\"defaultView\" content=\"slideshow\" />\n  <meta name=\"controlVis\" content=\"hidden\" />\n$if(highlighting-css)$\n  <style type=\"text/css\">\n$highlighting-css$\n  </style>\n$endif$\n$for(css)$\n  <link rel=\"stylesheet\" href=\"$css$\" type=\"text/css\" />\n$endfor$\n  <!-- style sheet links -->\n  <link rel=\"stylesheet\" href=\"$s5-url$/slides.css\" type=\"text/css\" media=\"projection\" id=\"slideProj\" />\n  <link rel=\"stylesheet\" href=\"$s5-url$/outline.css\" type=\"text/css\" media=\"screen\" id=\"outlineStyle\" />\n  <link rel=\"stylesheet\" href=\"$s5-url$/print.css\" type=\"text/css\" media=\"print\" id=\"slidePrint\" />\n  <link rel=\"stylesheet\" href=\"$s5-url$/opera.css\" type=\"text/css\" media=\"projection\" id=\"operaFix\" />\n  <!-- S5 JS -->\n  <script src=\"$s5-url$/slides.js\" type=\"text/javascript\"></script>\n$if(math)$\n  $math$\n$endif$\n$for(header-includes)$\n  $header-includes$\n$endfor$\n</head>\n<body>\n$for(include-before)$\n$include-before$\n$endfor$\n<div class=\"layout\">\n<div id=\"controls\"></div>\n<div id=\"currentSlide\"></div>\n<div id=\"header\"></div>\n<div id=\"footer\">\n  <h1>$date$</h1>\n  <h2>$title$</h2>\n</div>\n</div>\n<div class=\"presentation\">\n$if(title)$\n<div class=\"titleslide slide\">\n  <h1>$title$</h1>\n  <h2>$for(author)$$author$$sep$<br/>$endfor$</h2>\n  <h3>$date$</h3>\n</div>\n$endif$\n$body$\n$for(include-after)$\n$include-after$\n$endfor$\n</div>\n</body>\n</html>\n"),("templates/default.slideous","<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\"\n \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\"$if(lang)$ lang=\"$lang$\" xml:lang=\"$lang$\"$endif$>\n<head>\n  <meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\" />\n  <meta http-equiv=\"Content-Style-Type\" content=\"text/css\" />\n  <meta name=\"generator\" content=\"pandoc\" />\n$for(author-meta)$\n  <meta name=\"author\" content=\"$author-meta$\" />\n$endfor$\n$if(date-meta)$\n  <meta name=\"date\" content=\"$date-meta$\" />\n$endif$\n  <title>$if(title-prefix)$$title-prefix$ - $endif$$pagetitle$</title>\n  <style type=\"text/css\">code{white-space: pre;}</style>\n$if(highlighting-css)$\n  <style type=\"text/css\">\n$highlighting-css$\n  </style>\n$endif$\n  <link rel=\"stylesheet\" type=\"text/css\" media=\"screen, projection, print\"\n    href=\"$slideous-url$/slideous.css\" />\n$for(css)$\n  <link rel=\"stylesheet\" type=\"text/css\" media=\"screen, projection, print\"\n   href=\"$css$\" />\n$endfor$\n$if(math)$\n  $math$\n$endif$\n$for(header-includes)$\n  $header-includes$\n$endfor$\n  <script src=\"$slideous-url$/slideous.js\"\n    charset=\"utf-8\" type=\"text/javascript\"></script>\n$if(duration)$\n  <meta name=\"duration\" content=\"$duration$\" />\n$endif$\n</head>\n<body>\n$for(include-before)$\n$include-before$\n$endfor$\n<div id=\"statusbar\">\n<span style=\"float:right;\">\n<span style=\"margin-right:4em;font-weight:bold;\"><span id=\"slideidx\"></span> of {$$slidecount}</span>\n<button id=\"homebutton\" title=\"first slide\">1</button>\n<button id=\"prevslidebutton\" title=\"previous slide\">&laquo;</button>\n<button id=\"previtembutton\" title=\"previous item\">&lsaquo;</button>\n<button id=\"nextitembutton\" title=\"next item\">&rsaquo;</button>\n<button id=\"nextslidebutton\" title=\"next slide\">&raquo;</button>\n<button id=\"endbutton\" title=\"last slide\">{$$slidecount}</button>\n<button id=\"incfontbutton\" title=\"content\">A+</button>\n<button id=\"decfontbutton\" title=\"first slide\">A-</button>\n<select id=\"tocbox\" size=\"1\"><option></option></select>\n</span>\n<span id=\"eos\">&frac12;</span>\n<span title=\"{$$location}, {$$date}\">{$$title}, {$$author}</span>\n</div>\n$if(title)$\n<div class=\"slide titlepage\">\n  <h1 class=\"title\">$title$</h1>\n  <p class=\"author\">\n$for(author)$$author$$sep$<br/>$endfor$\n  </p>\n$if(date)$\n  <p class=\"date\">$date$</p>\n$endif$\n</div>\n$endif$\n$body$\n$for(include-after)$\n$include-after$\n$endfor$\n</body>\n</html>\n"),("templates/default.slidy","<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\"\n \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\"$if(lang)$ lang=\"$lang$\" xml:lang=\"$lang$\"$endif$>\n<head>\n  <meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\" />\n  <meta http-equiv=\"Content-Style-Type\" content=\"text/css\" />\n  <meta name=\"generator\" content=\"pandoc\" />\n$for(author-meta)$\n  <meta name=\"author\" content=\"$author-meta$\" />\n$endfor$\n$if(date-meta)$\n  <meta name=\"date\" content=\"$date-meta$\" />\n$endif$\n  <title>$if(title-prefix)$$title-prefix$ - $endif$$pagetitle$</title>\n  <style type=\"text/css\">code{white-space: pre;}</style>\n$if(highlighting-css)$\n  <style type=\"text/css\">\n$highlighting-css$\n  </style>\n$endif$\n  <link rel=\"stylesheet\" type=\"text/css\" media=\"screen, projection, print\"\n    href=\"$slidy-url$/styles/slidy.css\" />\n$for(css)$\n  <link rel=\"stylesheet\" type=\"text/css\" media=\"screen, projection, print\"\n   href=\"$css$\" />\n$endfor$\n$if(math)$\n  $math$\n$endif$\n$for(header-includes)$\n  $header-includes$\n$endfor$\n  <script src=\"$slidy-url$/scripts/slidy.js.gz\"\n    charset=\"utf-8\" type=\"text/javascript\"></script>\n$if(duration)$\n  <meta name=\"duration\" content=\"$duration$\" />\n$endif$\n</head>\n<body>\n$for(include-before)$\n$include-before$\n$endfor$\n$if(title)$\n<div class=\"slide titlepage\">\n  <h1 class=\"title\">$title$</h1>\n  <p class=\"author\">\n$for(author)$$author$$sep$<br/>$endfor$\n  </p>\n$if(date)$\n  <p class=\"date\">$date$</p>\n$endif$\n</div>\n$endif$\n$body$\n$for(include-after)$\n$include-after$\n$endfor$\n</body>\n</html>\n"),("templates/default.texinfo","\\input texinfo\n@documentencoding UTF-8\n$for(header-includes)$\n$header-includes$\n$endfor$\n\n$if(strikeout)$\n@macro textstrikeout{text}\n~~\\text\\~~\n@end macro\n\n$endif$\n$if(subscript)$\n@macro textsubscript{text}\n@iftex\n@textsubscript{\\text\\}\n@end iftex\n@ifnottex\n_@{\\text\\@}\n@end ifnottex\n@end macro\n\n$endif$\n$if(superscript)$\n@macro textsuperscript{text}\n@iftex\n@textsuperscript{\\text\\}\n@end iftex\n@ifnottex\n^@{\\text\\@}\n@end ifnottex\n@end macro\n\n$endif$\n@ifnottex\n@paragraphindent 0\n@end ifnottex\n$if(titlepage)$\n@titlepage\n@title $title$\n$for(author)$\n@author $author$\n$endfor$\n$if(date)$\n$date$\n$endif$\n@end titlepage\n\n$endif$\n$for(include-before)$\n$include-before$\n\n$endfor$\n$if(toc)$\n@contents\n\n$endif$\n$body$\n$for(include-after)$\n\n$include-after$\n$endfor$\n\n@bye\n"),("templates/default.textile","$for(include-before)$\n$include-before$\n\n$endfor$\n$body$\n$for(include-after)$\n\n$include-after$\n$endfor$\n"),("templates/README.markdown","Templates for [pandoc](http://github.com/jgm/pandoc).\n\nIf you use custom templates, we recommend forking this repository,\nso that you can integrate changes to the default templates in future\npandoc releases.\n")]
