///////////////////////////////////////////////////////////////////////////
//
// Copyright (c) 2012 DreamWorks Animation LLC
//
// All rights reserved. This software is distributed under the
// Mozilla Public License 2.0 ( http://www.mozilla.org/MPL/2.0/ )
//
// Redistributions of source code must retain the above copyright
// and license notice and the following restrictions and disclaimer.
//
// *     Neither the name of DreamWorks Animation nor the names of
// its contributors may be used to endorse or promote products derived
// from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
// IN NO EVENT SHALL THE COPYRIGHT HOLDERS' AND CONTRIBUTORS' AGGREGATE
// LIABILITY FOR ALL CLAIMS REGARDLESS OF THEIR BASIS EXCEED US$250.00.
//
///////////////////////////////////////////////////////////////////////////

#include <cppunit/extensions/HelperMacros.h>
#include <openvdb/Exceptions.h>
#include <openvdb/openvdb.h>
#include <openvdb/math/BBox.h>
#include <openvdb/math/Ray.h>
#include <openvdb/Types.h>
#include <openvdb/math/Transform.h>

#ifndef REL_EQ_TOL
#define REL_EQ_TOL(v0, v1, eps) (fabs(v0 - v1) < eps)
#endif

#ifndef SMALLVALUE
#define SMALLVALUE (1.e-6)
#endif

typedef float     Real;

class TestBBox : public CppUnit::TestCase
{
public:
    CPPUNIT_TEST_SUITE(TestBBox);
    CPPUNIT_TEST(testBBox);
    CPPUNIT_TEST(testCenter);
    CPPUNIT_TEST(testRayInterval);
    CPPUNIT_TEST_SUITE_END();

    void testBBox();
    void testCenter();
    void testRayInterval();
};

CPPUNIT_TEST_SUITE_REGISTRATION(TestBBox);


void
TestBBox::testBBox()
{
    typedef openvdb::Vec3R                     Vec3R;
    typedef openvdb::math::Ray<openvdb::Real>  RayType;
    typedef openvdb::math::BBox<Vec3R>         BBoxType;

    BBoxType B(Vec3R(1,1,1),Vec3R(2,2,2));

    CPPUNIT_ASSERT(B.isSorted());
    CPPUNIT_ASSERT(B.isInside(Vec3R(1.5,2,2)));
    CPPUNIT_ASSERT(!B.isInside(Vec3R(2,3,2)));
    B.expand(Vec3R(3,3,3));
    CPPUNIT_ASSERT(B.isInside(Vec3R(3,3,3)));

    //openvdb::Vec3R orig(0,0,0), dir(1,1,1);
    //RayType R(orig,dir);

    //CPPUNIT_ASSERT(B.isInside(R));
    /*openvdb::Real t0,t1;
    CPPUNIT_ASSERT(B.isInside(R,t0,t1));
    CPPUNIT_ASSERT(REL_EQ_TOL(t0,1,SMALLVALUE));
    CPPUNIT_ASSERT(REL_EQ_TOL(t1,3,SMALLVALUE));
    //fprintf(stderr,"t0=%f t1=%f\n",t0,t1);

    R.setOrigin(Vec3R(2,2,2));
    CPPUNIT_ASSERT(B.intersects(R,t0,t1));
    //fprintf(stderr,"t0=%f t1=%f\n",t0,t1);
    CPPUNIT_ASSERT(REL_EQ_TOL(t0,0,SMALLVALUE));
    CPPUNIT_ASSERT(REL_EQ_TOL(t1,1,SMALLVALUE));

    //std::cerr << "ray=" << R << std::endl;
    //std::cerr << "bbox=" << B << std::endl;
    */
}


void
TestBBox::testCenter()
{
    using namespace openvdb::math;

    const Vec3<double> expected(1.5);

    BBox<openvdb::Vec3R> fbox(openvdb::Vec3R(1.0), openvdb::Vec3R(2.0));
    CPPUNIT_ASSERT_EQUAL(expected, fbox.getCenter());

    BBox<openvdb::Vec3i> ibox(openvdb::Vec3i(1), openvdb::Vec3i(2));
    CPPUNIT_ASSERT_EQUAL(expected, ibox.getCenter());

    openvdb::CoordBBox cbox(openvdb::Coord(1), openvdb::Coord(2));
    CPPUNIT_ASSERT_EQUAL(expected, cbox.getCenter());
}


void
TestBBox::testRayInterval()
{
    /*typedef openvdb::Vec3R                                      Vec3R;
    typedef openvdb::math::Ray<openvdb::Real>                   RayType;
    typedef openvdb::math::BBox<Vec3R>                          BBoxType;
    typedef openvdb::math::RayInterval<openvdb::Real, float>    IntervalType;
    typedef openvdb::math::RayIntervalSet<openvdb::Real, float> IntervalSetType;

    {// test a simple merge
        IntervalType I1(0,1,4.56f), I2(1,2,4.56f);
        //fprintf(stderr,"t0=%f\t t1=%f tag=%i\n",I1.t0,I1.t1,I1.tag);
        CPPUNIT_ASSERT(I1.merge(I2));
        CPPUNIT_ASSERT_DOUBLES_EQUAL(I1.t0,0,0);
        CPPUNIT_ASSERT_DOUBLES_EQUAL(I1.t1,2,0);
        CPPUNIT_ASSERT_DOUBLES_EQUAL(I1.value,I2.value, 0);
        CPPUNIT_ASSERT(!I1.isEmpty());
        CPPUNIT_ASSERT(!I1.isVariable());
        CPPUNIT_ASSERT( I1.isConstant());
        //fprintf(stderr,"t0=%f\t t1=%f tag=%i\n",I1.t0,I1.t1,I1.tag);
    }

    std::vector<BBoxType> bboxes;//list of setValueBlocks (represents grid)
    for (int i=2; i<10; ++i) {
        if ( i==5) continue;
        Vec3R min(i,i,i), max(i+1,i+1,i+1);
        bboxes.push_back(BBoxType(min,max));
    }
    // Defined the ray
    openvdb::Vec3R orig(0,0,0), dir(1,1,1);
    RayType R(orig,dir);

    // Defined the intervals of intersections
    openvdb::Real t0, t1;
    IntervalSetType intersections;
    for (std::vector<BBoxType>::iterator iter=bboxes.begin(); iter!=bboxes.end(); ++iter) {
        CPPUNIT_ASSERT(iter->intersects(R));
        CPPUNIT_ASSERT(iter->intersects(R,t0,t1));
        intersections.insert(IntervalType(t0,t1,IntervalType::Hit()));
    }
    //for (IntervalSetType::iterator iter=intersections.begin(); iter!=intersections.end(); ++iter)
    //    fprintf(stderr,"t0=%f\t t1=%f tag=%i\n",(*iter).t0,(*iter).t1,(*iter).tag);

    // generate the
    intersections.merge(R);

    //for (IntervalSetType::iterator iter=intersections.begin(); iter!=intersections.end(); ++iter)
    //    fprintf(stderr,"t0=%f\t t1=%f tag=%i\n",iter->t0,iter->t1,iter->tag);
    {
        IntervalSetType::iterator iter=intersections.begin();
        CPPUNIT_ASSERT(*iter==IntervalType(R.getMinTime(),2));
        ++iter;
        CPPUNIT_ASSERT(!(*iter==IntervalType(3,5,IntervalType::Hit())));
        CPPUNIT_ASSERT(*iter==IntervalType(2,5,IntervalType::Hit()));
        ++iter;
        CPPUNIT_ASSERT(*iter==IntervalType(5,6));
        ++iter;
        CPPUNIT_ASSERT(*iter==IntervalType(6,10,IntervalType::Hit()));
        ++iter;
        CPPUNIT_ASSERT(*iter==IntervalType(10,R.getMaxTime()));
    }*/
}

// Copyright (c) 2012 DreamWorks Animation LLC
// All rights reserved. This software is distributed under the
// Mozilla Public License 2.0 ( http://www.mozilla.org/MPL/2.0/ )
