###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_tightvnc_detect_lin.nasl 987 2009-02-27 13:25:36Z feb $
#
# TightVNC Version Detection (Linux)
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900474);
  script_version("Revision: 1.0 ");
  script_name(english:"TightVNC Version Detection (Linux)");
  desc["english"] = "
  Overview: This script finds the installed TightVNC version on Linux
  and saves the version in KB.

  Risk factor: Informational";

  script_description(english:desc["english"]);
  script_summary(english:"Set the Version of TightVNC in KB");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 SecPod");
  script_family(english:"General");
  exit(0);
}


include("version_func.inc");

sock = ssh_login_or_reuse_connection();
if(!sock){
  exit(0);
}

vncPath = find_file(file_name:"Xvnc", file_path:"/", useregex:TRUE,
                      regexpar:"$", sock:sock);
foreach vncBin (vncPath)
{
  vncVer = get_bin_version(full_prog_name:chomp(vncBin),
                           sock:sock, version_argv:"-version",
                           ver_pattern:"tight([0-9]\.[0-9.]+)");
  if(vncVer[1] != NULL)
  {
    set_kb_item(name:"TightVNC/Linux/Ver", value:vncVer[1]);
    ssh_close_connection();
    exit(0);
  }
}
ssh_close_connection();
