##############################################################################
#
#  Opera Version Detection for Windows
#
#  Copyright: SecPod
#
#  Date Written: 2008/08/21
#
#  Revision: 1.1 
#
#  Log: schandan
#  Issue #0136
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL 
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL, 
#  and information regarding obtaining source code from the Author. 
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the 
#  information found in this header with any distribution you make of this 
#  Program.
#  ------------------------------------------------------------------------
##############################################################################

if(description)
{
 script_id(900036);
 script_copyright(english:"Copyright (C) 2008 SecPod");
 script_version("$Revision: 1.1 $");
 script_category(ACT_GATHER_INFO);
 script_family(english:"General");
 script_name(english:"Opera Version Detection for Windows");
 script_summary(english:"Set File Version of Opera in KB");
 desc["english"] = "
 Overview : This script finds the Opera Web browser installed version of
 windows from the Opera.exe file and saves the version in KB.
 
 Risk factor : Informational";
 script_description(english:desc["english"]);
 script_dependencies("secpod_reg_enum.nasl");
 script_require_keys("SMB/WindowsVersion");
 exit(0);
}


 include("smb_nt.inc");
 include("secpod_smb_func.inc");

 if(!get_kb_item("SMB/WindowsVersion")){
 	exit(0);
 }

 operaPath = registry_get_sz(item:"Install Directory",
 		      key:"SOFTWARE\Netscape\Netscape Navigator\5.0, Opera\Main");

 operaFile = operaPath + "\Opera.exe";
 if(!operaPath)
 {
        operaFile = registry_get_sz(item:"(Default)",
                             key:"SOFTWARE\Microsoft\Windows\CurrentVersion" +
                                 "\App Paths\Opera.exe");
        if(!operaFile)
        {
                operaPath = registry_get_sz(item:"ProgramFilesDir",
                            key:"SOFTWARE\Microsoft\Windows\CurrentVersion");

                operaFile = operaPath + "\Opera\Opera.exe";
                if(!operaPath){
                        exit(0);
                }
        }
 }

 share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:operaPath);
 file =  ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:operaFile);

 name   =  kb_smb_name();
 login  =  kb_smb_login();
 pass   =  kb_smb_password();
 domain =  kb_smb_domain();
 port   =  kb_smb_transport();

 soc = open_sock_tcp(port);
 if(!soc){
        exit(0);
 }

 r = smb_session_request(soc:soc, remote:name);
 if(!r){
	close(soc);
        exit(0);
 }

 prot = smb_neg_prot(soc:soc);
 if(!prot){
	close(soc);
        exit(0);
 }

 r = smb_session_setup(soc:soc, login:login, password:pass,
                       domain:domain, prot:prot);
 if(!r){
	close(soc);
        exit(0);
 }

 uid = session_extract_uid(reply:r);

 r = smb_tconx(soc:soc, name:name, uid:uid, share:share);
 tid = tconx_extract_tid(reply:r);
 if(!tid){
	close(soc);
        exit(0);
 }

 fid = OpenAndX(socket:soc, uid:uid, tid:tid, file:file);
 if(!fid){
	close(soc);
        exit(0);
 }

 operaVer = GetVersion(socket:soc, uid:uid, tid:tid, fid:fid, verstr:"prod");
 close(soc);

 if(operaVer){
	set_kb_item(name:"Opera/Win/Version", value:operaVer);
 }
