##############################################################################
#
#  Microsoft Office Detection
#
#  Copyright: SecPod
#
#  Date Written: 2008/08/13
#
#  Revision: 1.1
#
#  Log: schandan
#  Issue #0021
#
#  Updated to make use registry_enum_keys() from secpod_smb_func.inc
#   -By Chandan S 10:46:00 2009/04/24
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL,
#  and information regarding obtaining source code from the Author.
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the
#  information found in this header with any distribution you make of this
#  Program.
#  ------------------------------------------------------------------------
##############################################################################

if(description)
{
  script_id(900025);
  script_copyright(english:"Copyright (C) 2008 SecPod");
  script_version("$Revision: 1.1 $");
  script_category(ACT_GATHER_INFO);
  script_family(english:"Windows");
  script_name(english:"Microsoft Office Detection");
  script_summary(english:"Check for version and set KB");
  desc["english"] = "
  Overview : This script will Detect Microsoft Office Version and sets the KB.

  Risk factor : Informational";
  script_description(english:desc["english"]);
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

if(!registry_key_exists(key:"SOFTWARE\Microsoft\Office")){
  exit(0);
}

key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\";
entries = registry_enum_keys(key:key);
if(entries == NULL){
  exit(0);
}

foreach item (entries)
{
  MSOffName = registry_get_sz(key:key + item, item:"DisplayName");
  if(egrep(pattern:"Microsoft Office.* Viewer", string:MSOffName))
  {
     MSOffVer = registry_get_sz(key:key + item, item:"DisplayVersion");
     if(MSOffVer){
       set_kb_item(name:"MS/Office/Viewer/Ver", value:MSOffVer);
     }
     continue;
  }

  if(egrep(pattern:"Microsoft Office (2000|XP|.* Edition 2003$|.*[^)] 2007$)",
           string:MSOffName))
  {
    MSOffVer = registry_get_sz(key:key + item, item:"DisplayVersion");
    if(MSOffVer){
      set_kb_item(name:"MS/Office/Ver", value:MSOffVer);
    }
    continue;
  }
}
