# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory MDVSA-2009:101 (xpdf)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(63915);
 script_cve_id("CVE-2009-0146", "CVE-2009-0147", "CVE-2009-0165", "CVE-2009-0166", "CVE-2009-0800", "CVE-2009-0799", "CVE-2009-1179", "CVE-2009-1180", "CVE-2009-1181", "CVE-2009-1182", "CVE-2009-1183");
 script_version ("$");
 name["english"] = "Mandrake Security Advisory MDVSA-2009:101 (xpdf)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to xpdf
announced via advisory MDVSA-2009:101.

Multiple buffer overflows in the JBIG2 decoder allows remote
attackers to cause a denial of service (crash) via a crafted PDF file
(CVE-2009-0146).

Multiple integer overflows in the JBIG2 decoder allows remote
attackers to cause a denial of service (crash) via a crafted PDF file
(CVE-2009-0147).

An integer overflow in the JBIG2 decoder has unspecified
impact. (CVE-2009-0165).

A free of uninitialized memory flaw in the the JBIG2 decoder allows
remote to cause a denial of service (crash) via a crafted PDF file
(CVE-2009-0166).

Multiple input validation flaws in the JBIG2 decoder allows
remote attackers to execute arbitrary code via a crafted PDF file
(CVE-2009-0800).

An out-of-bounds read flaw in the JBIG2 decoder allows remote
attackers to cause a denial of service (crash) via a crafted PDF file
(CVE-2009-0799).

An integer overflow in the JBIG2 decoder allows remote attackers to
execute arbitrary code via a crafted PDF file (CVE-2009-1179).

A free of invalid data flaw in the JBIG2 decoder allows remote
attackers to execute arbitrary code via a crafted PDF (CVE-2009-1180).

A NULL pointer dereference flaw in the JBIG2 decoder allows remote
attackers to cause denial of service (crash) via a crafted PDF file
(CVE-2009-1181).

Multiple buffer overflows in the JBIG2 MMR decoder allows remote
attackers to cause denial of service or to execute arbitrary code
via a crafted PDF file (CVE-2009-1182, CVE-2009-1183).

This update provides fixes for that vulnerabilities.

Affected: 2008.0, 2008.1, 2009.0, Corporate 3.0, Corporate 4.0

Solution:
To upgrade automatically use MandrakeUpdate or urpmi.  The verification
of md5 checksums and GPG signatures is performed automatically for you.

https://secure1.securityspace.com/smysecure/catid.html?in=MDVSA-2009:101

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Mandrake Security Advisory MDVSA-2009:101 (xpdf)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"xpdf", rpm:"xpdf~3.02~8.2mdv2008.0", rls:"MNDK_2008.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xpdf-common", rpm:"xpdf-common~3.02~8.2mdv2008.0", rls:"MNDK_2008.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xpdf-tools", rpm:"xpdf-tools~3.02~8.2mdv2008.0", rls:"MNDK_2008.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xpdf", rpm:"xpdf~3.02~10.1mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xpdf-common", rpm:"xpdf-common~3.02~10.1mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xpdf", rpm:"xpdf~3.02~12.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xpdf-common", rpm:"xpdf-common~3.02~12.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xpdf", rpm:"xpdf~3.02~0.2.C30mdk", rls:"MNDK_3.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xpdf-tools", rpm:"xpdf-tools~3.02~0.2.C30mdk", rls:"MNDK_3.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xpdf", rpm:"xpdf~3.02~0.2.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xpdf-tools", rpm:"xpdf-tools~3.02~0.2.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
