# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory MDVSA-2009:005 (xterm)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(63139);
 script_cve_id("CVE-2008-2383");
 script_version ("$");
 name["english"] = "Mandrake Security Advisory MDVSA-2009:005 (xterm)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to xterm
announced via advisory MDVSA-2009:005.

A vulnerability has been discovered in xterm, which can be exploited
by malicious people to compromise a user's system. The vulnerability
is caused due to xterm not properly processing the DECRQSS Device
Control Request Status String escape sequence. This can be exploited
to inject and execute arbitrary shell commands by e.g. tricking a
user into displaying a malicious text file containing a specially
crafted escape sequence via the more command in xterm (CVE-2008-2383).

The updated packages have been patched to prevent this.

Affected: 2008.0, 2008.1, 2009.0, Corporate 3.0, Corporate 4.0

Solution:
To upgrade automatically use MandrakeUpdate or urpmi.  The verification
of md5 checksums and GPG signatures is performed automatically for you.

https://secure1.securityspace.com/smysecure/catid.html?in=MDVSA-2009:005

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Mandrake Security Advisory MDVSA-2009:005 (xterm)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"xterm", rpm:"xterm~229~2.1mdv2008.0", rls:"MNDK_2008.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xterm", rpm:"xterm~232~1.1mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xterm", rpm:"xterm~236~1.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xterm", rpm:"xterm~184~1.1.C30mdk", rls:"MNDK_3.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xterm", rpm:"xterm~203~1.1.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
