###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for redhat-cluster-suite vulnerability USN-489-2
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840029);
  script_version("$Revision: 1.0 $");
  script_xref(name: "USN", value: "489-2");
  script_cve_id("CVE-2007-3380");
  script_name(english: "Ubuntu Update for redhat-cluster-suite vulnerability USN-489-2");
  desc["english"] = "

  Vulnerability Insight:

  USN-489-1 fixed vulnerabilities in the Linux kernel.  This update
  provides the corresponding fixes for the redhat cluster suite kernel
  sources.
  
  Original advisory details:
  
  A flaw was discovered in the cluster manager.  A remote attacker could
  connect to the DLM port and block further DLM operations.
  (CVE-2007-3380)

  Affected Software/OS:
  redhat-cluster-suite vulnerability on Ubuntu 6.06 LTS

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2007-July/000563.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of redhat-cluster-suite vulnerability");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU6.06 LTS")
{

  if(isdpkgvuln(pkg:"ccs", ver:"1.20060222-0ubuntu6.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"cman", ver:"1.20060222-0ubuntu6.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"fence-gnbd", ver:"1.20060222-0ubuntu6.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"fence", ver:"1.20060222-0ubuntu6.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"gfs-tools", ver:"1.20060222-0ubuntu6.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"gnbd-client", ver:"1.20060222-0ubuntu6.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"gnbd-server", ver:"1.20060222-0ubuntu6.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"gulm", ver:"1.20060222-0ubuntu6.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libccs-dev", ver:"1.20060222-0ubuntu6.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libcman-dev", ver:"1.20060222-0ubuntu6.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libcman1", ver:"1.20060222-0ubuntu6.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libdlm-dev", ver:"1.20060222-0ubuntu6.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libdlm1", ver:"1.20060222-0ubuntu6.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libgulm-dev", ver:"1.20060222-0ubuntu6.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libgulm1", ver:"1.20060222-0ubuntu6.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libiddev-dev", ver:"1.20060222-0ubuntu6.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmagma-dev", ver:"1.20060222-0ubuntu6.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmagma1", ver:"1.20060222-0ubuntu6.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"magma-plugins", ver:"1.20060222-0ubuntu6.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"magma", ver:"1.20060222-0ubuntu6.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"rgmanager", ver:"1.20060222-0ubuntu6.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"redhat-cluster-suite-source", ver:"1.20060222-0ubuntu6.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"redhat-cluster-suite", ver:"1.20060222-0ubuntu6.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}