###############################################################################
# OpenVAS Vulnerability Test
#
# SuSE Update for apache2 SUSE-SA:2007:061
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(850088);
  script_version("$Revision: 1.0 $");
  script_xref(name: "SUSE-SA", value: "2007-061");
  script_cve_id("CVE-2006-5752", "CVE-2007-1863", "CVE-2007-3304", "CVE-2007-3847", "CVE-2007-4465");
  script_name(english: "SuSE Update for apache2 SUSE-SA:2007:061");
  desc["english"] = "

  Vulnerability Insight:

  Several bugs were fixed in the Apache2 web server.

  The update includes fixes for the following security issues:

  - CVE-2006-5752: mod_status: Fix a possible XSS
  attack against a site with a public server-status page and
  ExtendedStatus enabled, for browsers which perform charset
  &quot;detection&quot;.

  - CVE-2007-1863: mod_cache: Prevent a segmentation fault if attributes
  are listed in a Cache-Control header without any value.

  - CVE-2007-3304: prefork, worker, event MPMs:
  Ensure that the parent process cannot be forced to kill processes
  outside its process group.

  - CVE-2007-3847: mod_proxy: Prevent reading past the end of a buffer
  when parsing date-related headers. PR 41144.

  - CVE-2007-4465: mod_autoindex: Add in ContentType and Charset options
  to IndexOptions directive. This allows the admin to explicitly set
  the Content-Type and Charset of the generated page.

  and the following non-security issues:

  - get_module_list: replace loadmodule.conf atomically
  - Fixed broken SSLVerifyClient directive handling when global none
  and location required is configured
  (httpd-2.0.x-bnc-309234-ssl-renegotiation.patch)
  - Use File::Temp to create good tmpdir in logresolve.pl2
  (httpd-2.x.x-logresolve.patch)

  Impact:
  remote denial of service

  Affected Software/OS:
  apache2 on SUSE LINUX 10.1, openSUSE 10.2, openSUSE 10.3, SUSE SLES 9, Novell Linux Desktop 9 SDK, Novell Linux Desktop 9, Open Enterprise Server, Novell Linux POS 9, SLE SDK 10 SP1, SUSE Linux Enterprise Server 10 SP1

  Fix: Please Install the Updated Packages.

  References:
  http://www.novell.com/linux/security/advisories/2007_61_apache2.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of apache2");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"SuSE Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "openSUSE10.3")
{

  if(isrpmvuln(pkg:"apache2", rpm:"apache2~2.2.4~70.2", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2-devel", rpm:"apache2-devel~2.2.4~70.2", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2-doc", rpm:"apache2-doc~2.2.4~70.2", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2-example-pages", rpm:"apache2-example-pages~2.2.4~70.2", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2-prefork", rpm:"apache2-prefork~2.2.4~70.2", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2-utils", rpm:"apache2-utils~2.2.4~70.2", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2-worker", rpm:"apache2-worker~2.2.4~70.2", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "openSUSE10.2")
{

  if(isrpmvuln(pkg:"apache2", rpm:"apache2~2.2.3~22", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2-devel", rpm:"apache2-devel~2.2.3~22", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2-doc", rpm:"apache2-doc~2.2.3~22", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2-example-pages", rpm:"apache2-example-pages~2.2.3~22", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2-prefork", rpm:"apache2-prefork~2.2.3~22", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2-worker", rpm:"apache2-worker~2.2.3~22", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "NLDk9")
{

  if(isrpmvuln(pkg:"libapr0", rpm:"libapr0~2.0.59~1.4", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2", rpm:"apache2~2.0.59~1.4", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2-devel", rpm:"apache2-devel~2.0.59~1.4", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2-prefork", rpm:"apache2-prefork~2.0.59~1.4", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2-worker", rpm:"apache2-worker~2.0.59~1.4", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2-doc", rpm:"apache2-doc~2.0.59~1.4", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2-example-pages", rpm:"apache2-example-pages~2.0.59~1.4", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "OES")
{

  if(isrpmvuln(pkg:"libapr0", rpm:"libapr0~2.0.59~1.4", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2", rpm:"apache2~2.0.59~1.4", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2-devel", rpm:"apache2-devel~2.0.59~1.4", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2-prefork", rpm:"apache2-prefork~2.0.59~1.4", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2-worker", rpm:"apache2-worker~2.0.59~1.4", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2-doc", rpm:"apache2-doc~2.0.59~1.4", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2-example-pages", rpm:"apache2-example-pages~2.0.59~1.4", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLES9")
{

  if(isrpmvuln(pkg:"libapr0", rpm:"libapr0~2.0.59~1.4", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2", rpm:"apache2~2.0.59~1.4", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2-devel", rpm:"apache2-devel~2.0.59~1.4", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2-prefork", rpm:"apache2-prefork~2.0.59~1.4", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2-worker", rpm:"apache2-worker~2.0.59~1.4", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2-doc", rpm:"apache2-doc~2.0.59~1.4", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2-example-pages", rpm:"apache2-example-pages~2.0.59~1.4", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "NLDk9SDK")
{

  if(isrpmvuln(pkg:"libapr0", rpm:"libapr0~2.0.59~1.4", rls:"NLDk9SDK"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2", rpm:"apache2~2.0.59~1.4", rls:"NLDk9SDK"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2-devel", rpm:"apache2-devel~2.0.59~1.4", rls:"NLDk9SDK"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2-prefork", rpm:"apache2-prefork~2.0.59~1.4", rls:"NLDk9SDK"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2-worker", rpm:"apache2-worker~2.0.59~1.4", rls:"NLDk9SDK"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2-doc", rpm:"apache2-doc~2.0.59~1.4", rls:"NLDk9SDK"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2-example-pages", rpm:"apache2-example-pages~2.0.59~1.4", rls:"NLDk9SDK"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "LES10SP1")
{

  if(isrpmvuln(pkg:"apache2", rpm:"apache2~2.2.3~16.15", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2-devel", rpm:"apache2-devel~2.2.3~16.15", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2-doc", rpm:"apache2-doc~2.2.3~16.15", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2-example-pages", rpm:"apache2-example-pages~2.2.3~16.15", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2-prefork", rpm:"apache2-prefork~2.2.3~16.15", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2-worker", rpm:"apache2-worker~2.2.3~16.15", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLESDK10SP1")
{

  if(isrpmvuln(pkg:"apache2", rpm:"apache2~2.2.3~16.15", rls:"SLESDK10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2-devel", rpm:"apache2-devel~2.2.3~16.15", rls:"SLESDK10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2-doc", rpm:"apache2-doc~2.2.3~16.15", rls:"SLESDK10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2-example-pages", rpm:"apache2-example-pages~2.2.3~16.15", rls:"SLESDK10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2-prefork", rpm:"apache2-prefork~2.2.3~16.15", rls:"SLESDK10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2-worker", rpm:"apache2-worker~2.2.3~16.15", rls:"SLESDK10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SL10.1")
{

  if(isrpmvuln(pkg:"apache2", rpm:"apache2~2.2.3~16.15", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2-devel", rpm:"apache2-devel~2.2.3~16.15", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2-doc", rpm:"apache2-doc~2.2.3~16.15", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2-example-pages", rpm:"apache2-example-pages~2.2.3~16.15", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2-prefork", rpm:"apache2-prefork~2.2.3~16.15", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2-worker", rpm:"apache2-worker~2.2.3~16.15", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "NLPOS9")
{

  if(isrpmvuln(pkg:"libapr0", rpm:"libapr0~2.0.59~1.4", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2", rpm:"apache2~2.0.59~1.4", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2-devel", rpm:"apache2-devel~2.0.59~1.4", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2-prefork", rpm:"apache2-prefork~2.0.59~1.4", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2-worker", rpm:"apache2-worker~2.0.59~1.4", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2-doc", rpm:"apache2-doc~2.0.59~1.4", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2-example-pages", rpm:"apache2-example-pages~2.0.59~1.4", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}