###############################################################################
# OpenVAS Vulnerability Test
#
# SuSE Update for cacti SUSE-SA:2007:007
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(850055);
  script_version("$Revision: 1.0 $");
  script_xref(name: "SUSE-SA", value: "2007-007");
  script_cve_id("CVE-2006-6799");
  script_name(english: "SuSE Update for cacti SUSE-SA:2007:007");
  desc["english"] = "

  Vulnerability Insight:

  A command injection in cmd.php in cacti was fixed, which might have
  allowed remote attackers to inject commands and so execute code.

  This issue is tracked by the Mitre CVE ID CVE-2006-6799.

  Impact:
  remote code execution

  Affected Software/OS:
  cacti on openSUSE 10.2, SUSE LINUX 10.1

  Fix: Please Install the Updated Packages.

  References:
  http://www.novell.com/linux/security/advisories/2007_07_cacti.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of cacti");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"SuSE Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "SL10.1")
{

  if(isrpmvuln(pkg:"cacti", rpm:"cacti~0.8.6h~15.2", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}