###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_memcachedb_detect.nasl 2114 2009-05-14 12:45:29Z may $
#
# MemcacheDB Version Detection
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800716);
  script_version("$Revision: 1.0 $");
  script_name(english:"MemcacheDB Version Detection");
  desc["english"] = "

  Overview: The script detects the installed version of MemcacheDB and sets
  the result into KB.

  Risk Factor: Informational";

  script_description(english:desc["english"]);
  script_summary(english:"Set Version of MemcacheDB in KB");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_dependencies("find_service.nes");
  script_family(english:"Service detection");
  exit(0);
}


# Default port used by MemcacheDB Daemon
memcachedbPort = 21201;
if(!get_port_state(memcachedbPort)){
  exit(0);
}

data = string("version \r\n");
dbappsock = open_sock_tcp(memcachedbPort);
if(dbappsock)
{
  send(socket:dbappsock, data:data);
  response = recv(socket:dbappsock, length:1024);
  close(dbappsock);
  if(response != NULL)
  {
    version = eregmatch(pattern:"VERSION ([0-9.]+)", string:response);
    if(version[1] != NULL)
    {
      set_kb_item(name:"MemCacheDB/Ver", value:version[1]);
    }
  }
}
