###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for libcdaudio MDVSA-2008:233 (libcdaudio)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830395);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDVSA", value: "2008:233");
  script_cve_id("CVE-2008-5030", "CVE-2005-0706");
  script_name(english: "Mandriva Update for libcdaudio MDVSA-2008:233 (libcdaudio)");
  desc["english"] = "

  Vulnerability Insight:

  A heap overflow was found in the CDDB retrieval code of libcdaudio,
  which could result in the execution of arbitrary code (CVE-2008-5030).
  
  In addition, the fixes for CVE-2005-0706 were not applied to newer
  libcdaudio packages as shipped with Mandriva Linux, so the patch to fix
  that issue has been applied to 2008.1 and 2009.0 (this was originally
  fixed in MDKSA-2005:075).  This issue is a buffer overflow flaw found
  by Joseph VanAndel.  Corporate 3.0 has this fix already applied.
  
  The updated packages have been patched to prevent these issues.

  Affected Software/OS:
  libcdaudio on Mandriva Linux 2008.1,
  Mandriva Linux 2008.1/X86_64,
  Mandriva Linux 2009.0,
  Mandriva Linux 2009.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2008-11/msg00023.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of libcdaudio");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2008.1")
{

  if(isrpmvuln(pkg:"libcdaudio1", rpm:"libcdaudio1~0.99.12~5.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libcdaudio1-devel", rpm:"libcdaudio1-devel~0.99.12~5.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libcdaudio", rpm:"libcdaudio~0.99.12~5.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64cdaudio1", rpm:"lib64cdaudio1~0.99.12~5.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64cdaudio1-devel", rpm:"lib64cdaudio1-devel~0.99.12~5.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2009.0")
{

  if(isrpmvuln(pkg:"libcdaudio1", rpm:"libcdaudio1~0.99.12~6.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libcdaudio1-devel", rpm:"libcdaudio1-devel~0.99.12~6.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libcdaudio", rpm:"libcdaudio~0.99.12~6.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64cdaudio1", rpm:"lib64cdaudio1~0.99.12~6.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64cdaudio1-devel", rpm:"lib64cdaudio1-devel~0.99.12~6.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}