###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for python-django MDVSA-2008:185 (python-django)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830719);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDVSA", value: "2008:185");
  script_cve_id("");
  script_name(english: "Mandriva Update for python-django MDVSA-2008:185 (python-django)");
  desc["english"] = "

  Vulnerability Insight:

  A cross-site request forgery vulnerability was discovered in Django
  that, if exploited, could be used to perform unrequested deletion or
  modification of data.  Updated versions of Django will now discard
  posts from users whose sessions have expired, so data will need to
  be re-entered in these cases.
  
  The versions of Django shipping with Mandriva Linux have been updated
  to the latest patched versions that include the fix for this issue.
  In addition, they provide other bug fixes.

  Affected Software/OS:
  python-django on Mandriva Linux 2007.1,
  Mandriva Linux 2007.1/X86_64,
  Mandriva Linux 2008.0,
  Mandriva Linux 2008.0/X86_64,
  Mandriva Linux 2008.1,
  Mandriva Linux 2008.1/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2008-09/msg00003.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of python-django");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.1")
{

  if(isrpmvuln(pkg:"python-django", rpm:"python-django~0.95.4~0.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2008.0")
{

  if(isrpmvuln(pkg:"python-django", rpm:"python-django~0.96.3~0.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2008.1")
{

  if(isrpmvuln(pkg:"python-django", rpm:"python-django~0.96.3~0.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}