###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for sound-scripts MDVA-2008:168 (sound-scripts)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830680);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDVA", value: "2008:168");
  script_cve_id("");
  script_name(english: "Mandriva Update for sound-scripts MDVA-2008:168 (sound-scripts)");
  desc["english"] = "

  Vulnerability Insight:

  The sound initialization scripts provided with Mandriva Linux 2009
  activate the Analog Loopback channel when it is present. This channel
  is present on most audio chipsets supported by the snd-hda-intel
  driver, which are commonly used on recent systems. When active,
  this channel plays back the sound received by the line-in and mic-in
  channels. If nothing is actually connected to these channels, this
  can result in an unpleasant loud noise over the speakers or headphones
  connected to the line-out or speaker-out connector.
  
  This update adjusts the sound initialization scripts to mute this
  channel by default. Unfortunately, this change will not be applied
  automatically on already-installed systems, as existing settings
  are automatically stored at shutdown and re-applied at startup on
  Mandriva Linux. If you are suffering from this issue, then you can
  run the command 'reset_sound' as root after installing this update,
  and it should resolve the issue. Alternatively, you can simply disable
  / mute the Analog Loopback channel yourself, using a mixer application.

  Affected Software/OS:
  sound-scripts on Mandriva Linux 2009.0,
  Mandriva Linux 2009.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2008-11/msg00005.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of sound-scripts");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2009.0")
{

  if(isrpmvuln(pkg:"sound-scripts", rpm:"sound-scripts~0.56~1.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}