###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for pulseaudio MDVA-2008:148 (pulseaudio)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830546);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDVA", value: "2008:148");
  script_cve_id("");
  script_name(english: "Mandriva Update for pulseaudio MDVA-2008:148 (pulseaudio)");
  desc["english"] = "

  Vulnerability Insight:

  Some issues relating to thread cancellation have been discovered in
  the pulseaudio package shipped with Mandriva Linux 2009.0.
  
  These issues could result in the crash of an application acting as
  a pulseaudio client. This condition is greatly exacerbated when
  the client is unable to connect to the pulseaudio server. Due to
  the fact that libcanberra is used to play event sounds in GTK apps,
  this problem could present itself when running GTK applications as
  root which, under some circumstances, was unable to connect to the
  user's pulseaudio daemon.
  
  The problems were traced to the use of libasycns in pulseaudio and
  this updated package is compiled without support for this library
  (it is not essential to pulseaudio operation).
  
  In addition, the version of pulseaudio shipped in Mandriva Linux
  2009.0 used wallclock time to determine when a misbehaving daemon
  was overloading the CPU (under which circumstances the daemon
  terminated). This can cause problems when the time is changed manually
  or when daylight savings kick in. This package also contains an
  upstream fix to use monotonic time which does not suffer from this
  limitation.

  Affected Software/OS:
  pulseaudio on Mandriva Linux 2009.0,
  Mandriva Linux 2009.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2008-10/msg00027.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of pulseaudio");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2009.0")
{

  if(isrpmvuln(pkg:"libpulseaudio0", rpm:"libpulseaudio0~0.9.10~11.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libpulseaudio-devel", rpm:"libpulseaudio-devel~0.9.10~11.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libpulsecore5", rpm:"libpulsecore5~0.9.10~11.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libpulseglib20", rpm:"libpulseglib20~0.9.10~11.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libpulsezeroconf0", rpm:"libpulsezeroconf0~0.9.10~11.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"pulseaudio", rpm:"pulseaudio~0.9.10~11.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"pulseaudio-esound-compat", rpm:"pulseaudio-esound-compat~0.9.10~11.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"pulseaudio-module-bluetooth", rpm:"pulseaudio-module-bluetooth~0.9.10~11.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"pulseaudio-module-gconf", rpm:"pulseaudio-module-gconf~0.9.10~11.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"pulseaudio-module-jack", rpm:"pulseaudio-module-jack~0.9.10~11.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"pulseaudio-module-lirc", rpm:"pulseaudio-module-lirc~0.9.10~11.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"pulseaudio-module-x11", rpm:"pulseaudio-module-x11~0.9.10~11.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"pulseaudio-module-zeroconf", rpm:"pulseaudio-module-zeroconf~0.9.10~11.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"pulseaudio-utils", rpm:"pulseaudio-utils~0.9.10~11.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64pulseaudio0", rpm:"lib64pulseaudio0~0.9.10~11.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64pulseaudio-devel", rpm:"lib64pulseaudio-devel~0.9.10~11.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64pulsecore5", rpm:"lib64pulsecore5~0.9.10~11.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64pulseglib20", rpm:"lib64pulseglib20~0.9.10~11.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64pulsezeroconf0", rpm:"lib64pulsezeroconf0~0.9.10~11.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}