###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for madwifi-source MDKSA-2007:132 (madwifi-source)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830107);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDKSA", value: "2007:132");
  script_cve_id("CVE-2007-2829", "CVE-2007-2830", "CVE-2007-2831", "CVE-2006-2830", "CVE-2006-2831");
  script_name(english: "Mandriva Update for madwifi-source MDKSA-2007:132 (madwifi-source)");
  desc["english"] = "

  Vulnerability Insight:

  The 802.11 network stack in MadWifi prior to 0.9.3.1 would alloa remote
  attackers to cause a denial of service (system hang) via a crafted
  length field in nested 802.3 Ethernet frames in Fast Frame packets,
  which results in a NULL pointer dereference (CVE-2007-2829).
  
  The ath_beacon_config function in MadWifi prior to 0.9.3.1 would
  allow a remote attacker to cause a denial of service (system crash)
  via crafted beacon interval information when scanning for access
  points, which triggered a divide-by-zero error (CVE-2007-2830).
  
  An array index error in MadWifi prior to 0.9.3.1 would allow a
  local user to cause a denial of service (system crash) and possibly
  obtain kerenl memory contents, as well as possibly allowing for the
  execution of arbitrary code via a large negative array index value
  (CVE-2007-2831).
  
  Updated packages have been updated to 0.9.3.1 to correct these
  issues. Wpa_supplicant is built using madwifi-source and has been
  rebuilt using 0.9.3.1 source.

  Affected Software/OS:
  madwifi-source on Mandriva Linux 2007.0,
  Mandriva Linux 2007.0/X86_64,
  Mandriva Linux 2007.1,
  Mandriva Linux 2007.1/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2007-06/msg00034.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of madwifi-source");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.1")
{

  if(isrpmvuln(pkg:"madwifi-source", rpm:"madwifi-source~0.9.3.1~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"wpa_gui", rpm:"wpa_gui~0.5.7~1.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"wpa_supplicant", rpm:"wpa_supplicant~0.5.7~1.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2007.0")
{

  if(isrpmvuln(pkg:"madwifi-source", rpm:"madwifi-source~0.9.3.1~1.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"wpa_gui", rpm:"wpa_gui~0.5.5~2.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"wpa_supplicant", rpm:"wpa_supplicant~0.5.5~2.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}