###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for util-linux MDKSA-2007:053 (util-linux)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830143);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDKSA", value: "2007:053");
  script_cve_id("CVE-2007-0822");
  script_name(english: "Mandriva Update for util-linux MDKSA-2007:053 (util-linux)");
  desc["english"] = "

  Vulnerability Insight:

  Umount allows local users to trigger a NULL dereference and application
  crash by invoking the program with a pathname for a USB pen drive that
  was mounted and then physically removed, which might allow the users to
  obtain sensitive information, including core file contents.
  
  Updated packages have been patched to address this issue.

  Affected Software/OS:
  util-linux on Mandriva Linux 2006.0,
  Mandriva Linux 2006.0/X86_64,
  Mandriva Linux 2007.0,
  Mandriva Linux 2007.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2007-03/msg00005.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of util-linux");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.0")
{

  if(isrpmvuln(pkg:"losetup", rpm:"losetup~2.12r~8.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mount", rpm:"mount~2.12r~8.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"util-linux", rpm:"util-linux~2.12r~8.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2006.0")
{

  if(isrpmvuln(pkg:"losetup", rpm:"losetup~2.12q~7.1.20060mdk", rls:"MNDK_2006.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mount", rpm:"mount~2.12q~7.1.20060mdk", rls:"MNDK_2006.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"util-linux", rpm:"util-linux~2.12q~7.1.20060mdk", rls:"MNDK_2006.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}