###############################################################################
# OpenVAS Vulnerability Test
#
# HP-UX Update for Apache HPSBUX00224
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(835104);
  script_version("$Revision: 1.0 $");
  script_xref(name: "HPSBUX", value: "00224");
  script_cve_id("CAN-2002-0839", "CAN-2002-0840", "CAN-2002-0843", "CAN-2002-1156");
  script_name(english: "HP-UX Update for Apache HPSBUX00224");
  desc["english"] = "

  Vulnerability Insight:
  A potential security vulnerability has been identifiedwith HP-UX running 
  Apache that may allow a user to gain increased privileges or Denial of 
  Service (DoS) or execution of arbitrary code. 

  Impact:
  Increased privileges or Denial of Service (DoS) or execution of arbitrary code.

  Affected Software/OS:
  Apache on
  HP-UX B.11.00, B.11.11, B.11.20 and B.11.22 running the ApacheStrong or 
  HPApache HP-UX Apache-based Web Servers. HP-UX B.11.04 running Virtualvault 
  4.5 or HP-UX and Solaris running OV-NNM6.2. 

  Fix: Please Install the Updated Packages.

  References:
  http://www11.itrc.hp.com/service/cki/docDisplay.do?docId=emr_na-c00944288-1

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of Apache");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"HP-UX Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-hpux.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "HPUX11.00")
{

  if(ishpuxpkgvuln(pkg:"ApacheStrong.APACHE-STRONG", revision:"1.3.27.00", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"HPApache", revision:"2.0.43.00", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"OVNNMgr.OVNNM-RUN", patch_list:['PHSS_28705'], rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"OVNNMgr.OVRPT-RUN", patch_list:['PHSS_28705'], rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.04")
{

  if(ishpuxpkgvuln(pkg:"VaultWS.WS-CORE", patch_list:['PHSS_28111', 'PHSS_28098'], rls:"HPUX11.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"VaultTS.VV-IWS", patch_list:['PHSS_28111', 'PHSS_28098'], rls:"HPUX11.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"VaultTS.VV-IWS-JK", patch_list:['PHSS_28111', 'PHSS_28098'], rls:"HPUX11.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"VaultTS.VV-CORE-CMN", patch_list:['PHSS_28111', 'PHSS_28098'], rls:"HPUX11.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"VaultWS.WS-CORE", patch_list:['PHSS_28090', 'PHSS_28099'], rls:"HPUX11.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"VaultTS.VV-IWS", patch_list:['PHSS_28090', 'PHSS_28099'], rls:"HPUX11.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"VaultTS.VV-CORE-CMN", patch_list:['PHSS_28090', 'PHSS_28099'], rls:"HPUX11.04"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX10.20")
{

  if(ishpuxpkgvuln(pkg:"OVNNMgr.OVNNM-RUN", patch_list:['PHSS_28704'], rls:"HPUX10.20"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"OVNNMgr.OVRPT-RUN", patch_list:['PHSS_28704'], rls:"HPUX10.20"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.22")
{

  if(ishpuxpkgvuln(pkg:"ApacheStrong.APACHE-STRONG", revision:"1.3.27.00", rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"HPApache", revision:"2.0.43.00", rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.20")
{

  if(ishpuxpkgvuln(pkg:"ApacheStrong.APACHE-STRONG", revision:"1.3.27.00", rls:"HPUX11.20"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"HPApache", revision:"2.0.43.00", rls:"HPUX11.20"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.11")
{

  if(ishpuxpkgvuln(pkg:"ApacheStrong.APACHE-STRONG", revision:"1.3.27.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"HPApache", revision:"2.0.43.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"OVNNMgr.OVNNM-RUN", patch_list:['PHSS_28705'], rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"OVNNMgr.OVRPT-RUN", patch_list:['PHSS_28705'], rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}
