###############################################################################
# OpenVAS Vulnerability Test
#
# HP-UX Update for setrlimit(1M) HPSBUX00156
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(835074);
  script_version("$Revision: 1.0 $");
  script_xref(name: "HPSBUX", value: "00156");
  script_cve_id("");
  script_name(english: "HP-UX Update for setrlimit(1M) HPSBUX00156");
  desc["english"] = "

  Vulnerability Insight:
  A potential security vulnerability has been identifiedwith HP-UX running 
  setrlimit(1M), where setrlimit() may allow incorrect core files and cause a 
  Denial of Service (DoS). 

  Impact:
  Denial of Service (DoS).

  Affected Software/OS:
  setrlimit(1M) on
  HP 9000 Series 700/800 running HP-UX B.10.01, B.10.10, B.10.20, B.10.24, 
  B.10.26 and HP-UX B.11.00, B11.04 and B.11.11 running setrlimit(1M). 

  Fix: Please Install the Updated Packages.

  References:
  http://www11.itrc.hp.com/service/cki/docDisplay.do?docId=emr_na-c00968563-1

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of setrlimit(1M)");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"HP-UX Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-hpux.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "HPUX10.01")
{

  if(ishpuxpkgvuln(pkg:"setrlimit(1M)", patch_list:['PHKL_23512/PACHRDME/English]'], rls:"HPUX10.01"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"setrlimit(1M)", patch_list:['PHKL_23513'], rls:"HPUX10.01"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX10.10")
{

  if(ishpuxpkgvuln(pkg:"setrlimit(1M)", patch_list:['PHKL_23477/PACHRDME/English]'], rls:"HPUX10.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"setrlimit(1M)", patch_list:['PHKL_23478/PACHRDME/English]'], rls:"HPUX10.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.00")
{

  if(ishpuxpkgvuln(pkg:"setrlimit(1M)", patch_list:['PHKL_23628/PACHRDME/English]'], rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX10.24")
{

  if(ishpuxpkgvuln(pkg:"setrlimit(1M)", patch_list:['PHKL_24249/PACHRDME/English]'], rls:"HPUX10.24"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"setrlimit(1M)", patch_list:['PHKL_24250/PACHRDME/English]'], rls:"HPUX10.24"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX10.26")
{

  if(ishpuxpkgvuln(pkg:"setrlimit(1M)", patch_list:['PHKL_25243/PACHRDME/English]'], rls:"HPUX10.26"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"setrlimit(1M)", patch_list:['PHKL_25244/PACHRDME/English]'], rls:"HPUX10.26"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.04")
{

  if(ishpuxpkgvuln(pkg:"setrlimit(1M)", patch_list:['PHKL_23886/PACHRDME/English]'], rls:"HPUX11.04"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX10.20")
{

  if(ishpuxpkgvuln(pkg:"setrlimit(1M)", patch_list:['PHKL_22701/PACHRDME/English]'], rls:"HPUX10.20"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"setrlimit(1M)", patch_list:['PHKL_22702/PACHRDME/English]'], rls:"HPUX10.20"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.11")
{

  if(ishpuxpkgvuln(pkg:"setrlimit(1M)", patch_list:['PHKL_23423/PACHRDME/English]'], rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}