###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_firefox_detect_win.nasl 302 2008-10-03 16:07:35Z oct $
#
# Mozilla Firefox Version Detection (Windows)
#
# Authors:
# Chandan S <schandan@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800014);
  script_version("Revision: 1.0 ");
  script_name(english:"Mozilla Firefox Version Detection (Windows)");
  desc["english"] = "
  Overview : This script finds the Mozilla Firefox installed version on Windows 
  and save the version in KB.

  Risk factor : Informational";

  script_description(english:desc["english"]);
  script_summary(english:"Set Version of Mozilla Firefox in KB");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2008 Intevation GmbH");
  script_family(english:"General");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

# Check for Firefox browser
foxVer = registry_get_sz(key:"SOFTWARE\Mozilla\Mozilla Firefox",
                         item:"CurrentVersion");
if(foxVer)
{
  # Check other than Firefox Version 1.5
  if("1.5" >!< foxVer){
     foxVer = eregmatch(pattern:"[0-9.]+", string:foxVer);
     set_kb_item(name:"Firefox/Win/Ver", value:foxVer[0]);
  }

  # Detect Firefox Version 1.5.x series
  if("1.5" >< foxVer)
  {
    exeFile  =  registry_get_sz(key:"SOFTWARE\Microsoft\Windows\Current" +
                                    "Version\Uninstall\Mozilla Firefox (1.5)",
                                item:"InstallLocation");
    if(exeFile == NULL)
    {
      close(soc);
      exit(0);
    }

    share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:exeFile);
    file = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1",
                        string:exeFile + "\firefox.exe");

    soc = open_sock_tcp(port);
    if(!soc){
      exit(0);
    }

    r = smb_session_request(soc:soc, remote:name);
    if(!r){
      close(soc);
      exit(0);
    }

    prot = smb_neg_prot(soc:soc);
    if(!prot){
      close(soc);
      exit(0);
    }

    r = smb_session_setup(soc:soc, login:login, password:pass, domain:domain,
                          prot:prot);
    if(!r){
      close(soc);
      exit(0);
    }

    uid = session_extract_uid(reply:r);
    if(!uid){
      close(soc);
      exit(0);
    }

    r = smb_tconx(soc:soc, name:name, uid:uid, share:share);
    tid = tconx_extract_tid(reply:r);
    if(!tid){
      close(soc);
      exit(0);
    }

    fid = OpenAndX(socket:soc, uid:uid, tid:tid, file:file);
    if(!fid){
      close(soc);
      exit(0);
    }

    fileVer = GetVersion(socket:soc, uid:uid, tid:tid, fid:fid, verstr:"prod",
                         offset:260000);
    close(soc);
    if(fileVer){
      set_kb_item(name:"Firefox/Win/Ver",value:fileVer);
    }
  }
}
else
{
  foxVer = registry_get_sz(key:"SOFTWARE\mozilla.org\Mozilla Firefox",
                           item:"CurrentVersion");
  if(foxVer)
  {
    foxVer = eregmatch(pattern:"[0-9.]+", string:foxVer);
    set_kb_item(name:"Firefox/Win/Ver", value:foxVer[0]);
  }
}
