###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for condor FEDORA-2008-8733
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(860848);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2008-8733");
  script_cve_id("CVE-2008-3826", "CVE-2008-3828", "CVE-2008-3829", "CVE-2008-3830");
  script_name(english: "Fedora Update for condor FEDORA-2008-8733");
  desc["english"] = "

  Vulnerability Insight:
  Condor is a specialized workload management system for
  compute-intensive jobs. Like other full-featured batch systems, Condor
  provides a job queueing mechanism, scheduling policy, priority scheme,
  resource monitoring, and resource management. Users submit their
  serial or parallel jobs to Condor, Condor places them into a queue,
  chooses when and where to run the jobs based upon a policy, carefully
  monitors their progress, and ultimately informs the user upon
  completion.


  Affected Software/OS:
  condor on Fedora 9

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2008-October/msg00264.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of condor");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC9")
{

  if(isrpmvuln(pkg:"condor", rpm:"condor~7.0.5~1.fc9", rls:"FC9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}