###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for gimp FEDORA-2007-619
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861142);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2007-619");
  script_cve_id("");
  script_name(english: "Fedora Update for gimp FEDORA-2007-619");
  desc["english"] = "

  Vulnerability Insight:
  GIMP (GNU Image Manipulation Program) is a powerful image composition and
  editing program, which can be extremely useful for creating logos and other
  graphics for webpages. GIMP has many of the tools and filters you would expect
  to find in similar commercial offerings, and some interesting extras as well.
  GIMP provides a large image manipulation toolbox, including channel operations
  and layers, effects, sub-pixel imaging and anti-aliasing, and conversions, all
  with multi-level undo


  Affected Software/OS:
  gimp on Fedora Core 6

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2007-June/msg00651.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of gimp");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC6")
{

  if(isrpmvuln(pkg:"gimp", rpm:"gimp~2.2.15~3.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/gimp", rpm:"x86_64/gimp~2.2.15~3.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/gimp-devel", rpm:"x86_64/gimp-devel~2.2.15~3.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/debug/gimp-debuginfo", rpm:"x86_64/debug/gimp-debuginfo~2.2.15~3.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/gimp-libs", rpm:"x86_64/gimp-libs~2.2.15~3.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/debug/gimp-debuginfo", rpm:"i386/debug/gimp-debuginfo~2.2.15~3.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/gimp-devel", rpm:"i386/gimp-devel~2.2.15~3.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/gimp", rpm:"i386/gimp~2.2.15~3.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/gimp-libs", rpm:"i386/gimp-libs~2.2.15~3.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}