###############################################################################
# OpenVAS Vulnerability Test
#
# RedHat Update for bluez-libs and bluez-utils RHSA-2008:0581-01
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(870132);
  script_version("$Revision: 1.0 $");
  script_xref(name: "RHSA", value: "2008:0581-01");
  script_cve_id("CVE-2008-2374");
  script_name(english: "RedHat Update for bluez-libs and bluez-utils RHSA-2008:0581-01");
  desc["english"] = "

  Vulnerability Insight:
  The bluez-libs package contains libraries for use in Bluetooth
  applications. The bluez-utils package contains Bluetooth daemons and utilities.
  
  An input validation flaw was found in the Bluetooth Session Description
  Protocol (SDP) packet parser used by the Bluez Bluetooth utilities. A
  Bluetooth device with an already-established trust relationship, or a local
  user registering a service record via a UNIX® socket or D-Bus interface,
  could cause a crash, or possibly execute arbitrary code with privileges of
  the hcid daemon. (CVE-2008-2374)
  
  Users of bluez-libs and bluez-utils are advised to upgrade to these updated
  packages, which contains a backported patch to correct this issue.


  Affected Software/OS:
  bluez-libs and bluez-utils on Red Hat Enterprise Linux AS version 4,
  Red Hat Enterprise Linux ES version 4,
  Red Hat Enterprise Linux WS version 4,
  Red Hat Enterprise Linux (v. 5 server)

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/rhsa-announce/2008-July/msg00013.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of bluez-libs and bluez-utils");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Red Hat Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "RHENT_5")
{

  if(isrpmvuln(pkg:"bluez-libs", rpm:"bluez-libs~3.7~1.1", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bluez-libs-debuginfo", rpm:"bluez-libs-debuginfo~3.7~1.1", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bluez-libs-devel", rpm:"bluez-libs-devel~3.7~1.1", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bluez-utils", rpm:"bluez-utils~3.7~2.2", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bluez-utils-cups", rpm:"bluez-utils-cups~3.7~2.2", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bluez-utils-debuginfo", rpm:"bluez-utils-debuginfo~3.7~2.2", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "RHENT_4")
{

  if(isrpmvuln(pkg:"bluez-libs", rpm:"bluez-libs~2.10~3", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bluez-libs-debuginfo", rpm:"bluez-libs-debuginfo~2.10~3", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bluez-libs-devel", rpm:"bluez-libs-devel~2.10~3", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bluez-utils", rpm:"bluez-utils~2.10~2.4", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bluez-utils-cups", rpm:"bluez-utils-cups~2.10~2.4", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bluez-utils-debuginfo", rpm:"bluez-utils-debuginfo~2.10~2.4", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}