###############################################################################
# OpenVAS Vulnerability Test
#
# RedHat Update for rdesktop RHSA-2008:0575-01
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(870030);
  script_version("$Revision: 1.0 $");
  script_xref(name: "RHSA", value: "2008:0575-01");
  script_cve_id("CVE-2008-1801", "CVE-2008-1803");
  script_name(english: "RedHat Update for rdesktop RHSA-2008:0575-01");
  desc["english"] = "

  Vulnerability Insight:
  rdesktop is an open source client for Microsoft Windows NT Terminal Server
  and Microsoft Windows 2000 and 2003 Terminal Services, capable of natively
  using the Remote Desktop Protocol (RDP) to present the user's NT desktop.
  No additional server extensions are required.
  
  An integer underflow and integer signedness issue were discovered in the
  rdesktop. If an attacker could convince a victim to connect to a malicious
  RDP server, the attacker could cause the victim's rdesktop to crash or,
  possibly, execute an arbitrary code. (CVE-2008-1801, CVE-2008-1803)
  
  Users of rdesktop should upgrade to these updated packages, which contain a
  backported patches to resolve these issues.


  Affected Software/OS:
  rdesktop on Red Hat Enterprise Linux (v. 5 server)

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/rhsa-announce/2008-July/msg00027.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of rdesktop");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Red Hat Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "RHENT_5")
{

  if(isrpmvuln(pkg:"rdesktop", rpm:"rdesktop~1.4.1~6", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"rdesktop-debuginfo", rpm:"rdesktop-debuginfo~1.4.1~6", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}