###############################################################################
# OpenVAS Vulnerability Test
#
# RedHat Update for evolution RHSA-2008:0177-01
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(870024);
  script_version("$Revision: 1.0 $");
  script_xref(name: "RHSA", value: "2008:0177-01");
  script_cve_id("CVE-2008-0072");
  script_name(english: "RedHat Update for evolution RHSA-2008:0177-01");
  desc["english"] = "

  Vulnerability Insight:
  Evolution is the GNOME collection of personal information management (PIM)
  tools.
  
  A format string flaw was found in the way Evolution displayed encrypted
  mail content. If a user opened a carefully crafted mail message, arbitrary
  code could be executed as the user running Evolution. (CVE-2008-0072)
  
  All users of Evolution should upgrade to these updated packages, which
  contain a backported patch which resolves this issue.
  
  Red Hat would like to thank Ulf Härnhammar of Secunia Research for finding
  and reporting this issue.


  Affected Software/OS:
  evolution on Red Hat Enterprise Linux AS version 4,
  Red Hat Enterprise Linux ES version 4,
  Red Hat Enterprise Linux WS version 4

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/rhsa-announce/2008-March/msg00001.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of evolution");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Red Hat Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "RHENT_4")
{

  if(isrpmvuln(pkg:"evolution", rpm:"evolution~2.0.2~35.0.4.el4_6.1", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"evolution-debuginfo", rpm:"evolution-debuginfo~2.0.2~35.0.4.el4_6.1", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"evolution-devel", rpm:"evolution-devel~2.0.2~35.0.4.el4_6.1", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"evolution28", rpm:"evolution28~2.8.0~53.el4_6.2", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"evolution28-debuginfo", rpm:"evolution28-debuginfo~2.8.0~53.el4_6.2", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"evolution28-devel", rpm:"evolution28-devel~2.8.0~53.el4_6.2", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}