###############################################################################
# OpenVAS Vulnerability Test
#
# CentOS Update for cups CESA-2008:0153 centos3 i386
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(880163);
  script_version("$Revision: 1.0 $");
  script_xref(name: "CESA", value: "2008:0153");
  script_cve_id("CVE-2008-0596", "CVE-2008-0597", "CVE-2008-0882");
  script_name(english: "CentOS Update for cups CESA-2008:0153 centos3 i386");
  desc["english"] = "

  Vulnerability Insight:
  The Common UNIX Printing System (CUPS) provides a portable printing layer
  for UNIX(R) operating systems.
  
  A flaw was found in the way CUPS handled the addition and removal of remote
  shared printers via IPP.  A remote attacker could send malicious UDP IPP
  packets causing the CUPS daemon to attempt to dereference already freed
  memory and crash. (CVE-2008-0597)
  
  A memory management flaw was found in the way CUPS handled the addition and
  removal of remote shared printers via IPP.  When shared printer was
  removed, allocated memory was not properly freed, leading to a memory leak
  possibly causing CUPS daemon crash after exhausting available memory.
  (CVE-2008-0596)
  
  These issues were found during the investigation of CVE-2008-0882, which
  did not affect Red Hat Enterprise Linux 3. 
  
  Note that the default configuration of CUPS on Red Hat Enterprise Linux
  3 allow requests of this type only from the local subnet.
  
  In addition, these updated cups packages fix a bug that occurred when using
  the CUPS polling daemon. Excessive debugging log information was saved to
  the error_log file regardless of the LogLevel setting, which filled up disk
  space rapidly.
  
  All CUPS users are advised to upgrade to these updated packages, which
  contain backported patches to resolve this issue.


  Affected Software/OS:
  cups on CentOS 3

  Fix: Please Install the Updated Packages.

  References:
  http://lists.centos.org/pipermail/centos-announce/2008-February/014708.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of cups");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"CentOS Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "CENTOS3")
{

  if(isrpmvuln(pkg:"cups", rpm:"cups~1.1.17~13.3.51", rls:"CENTOS3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-devel", rpm:"cups-devel~1.1.17~13.3.51", rls:"CENTOS3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-libs", rpm:"cups-libs~1.1.17~13.3.51", rls:"CENTOS3"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}