#
#VID a7062952-9023-11d9-a22c-0001020eed82
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(52160);
 script_bugtraq_id(7963);
 script_cve_id("CVE-2005-0544");
 script_version ("$");
 name["english"] = "FreeBSD Ports: phpmyadmin, phpMyAdmin";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to the system
as announced in the referenced advisory.

The following packages are affected:
   phpmyadmin
   phpMyAdmin

CVE-2005-0544
phpMyAdmin 2.6.1 allows remote attackers to obtain the full path of
the server via direct requests to (1) sqlvalidator.lib.php, (2)
sqlparser.lib.php, (3) select_theme.lib.php, (4) select_lang.lib.php,
(5) relation_cleanup.lib.php, (6) header_meta_style.inc.php, (7)
get_foreign.lib.php, (8) display_tbl_links.lib.php, (9)
display_export.lib.php, (10) db_table_exists.lib.php, (11)
charset_conversion.lib.php, (12) ufpdf.php, (13) mysqli.dbi.lib.php,
(14) setup.php, or (15) cookie.auth.lib.php, which reveals the path in
a PHP error message.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://www.phpmyadmin.net/home_page/security.php?issue=PMASA-2005-2
http://www.vuxml.org/freebsd/a7062952-9023-11d9-a22c-0001020eed82.html

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "FreeBSD Ports: phpmyadmin, phpMyAdmin";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"phpmyadmin");
if(!isnull(bver) && revcomp(a:bver, b:"2.6.1.2")<0) {
    security_note(0, data:"Package phpmyadmin version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"phpMyAdmin");
if(!isnull(bver) && revcomp(a:bver, b:"2.6.1.2")<0) {
    security_note(0, data:"Package phpMyAdmin version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
