#
#VID e5afdf63-1746-11da-978e-0001020eed82
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(55177);
 script_cve_id("CVE-2005-2549", "CVE-2005-2550");
 script_version ("$");
 name["english"] = "FreeBSD Ports: evolution";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: evolution

CVE-2005-2549
Multiple format string vulnerabilities in Evolution 1.5 through
2.3.6.1 allow remote attackers to cause a denial of service (crash)
and possibly execute arbitrary code via (1) full vCard data, (2)
contact data from remote LDAP servers, or (3) task list data from
remote servers.

CVE-2005-2550
Format string vulnerability in Evolution 1.4 through 2.3.6.1 allows
remote attackers to cause a denial of service (crash) and possibly
execute arbitrary code via the calendar entries such as task lists,
which are not properly handled when the user selects the Calendars
tab.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://www.sitic.se/eng/advisories_and_recommendations/sa05-001.html
http://www.vuxml.org/freebsd/e5afdf63-1746-11da-978e-0001020eed82.html

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "FreeBSD Ports: evolution";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"evolution");
if(!isnull(bver) && revcomp(a:bver, b:"1.5")>0 && revcomp(a:bver, b:"2.3.7")<0) {
    security_note(0, data:"Package evolution version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
